/* Generated by GOB (v2.0.11) on Sun Mar  6 22:34:28 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-message-view.h"

#include "mn-message-view-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 24 "mn-message-view.gob"

#include "config.h"
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "mn-message.h"
#include "mn-util.h"

  typedef struct
  {
    MNMessage		*message;
    GSList		*header_marks;
    char		*last_sent;
    GtkTextMark		*sent_start;
    GtkTextMark		*sent_end;
  } MessageInfo;

#line 44 "mn-message-view.c"
/* self casting macros */
#define SELF(x) MN_MESSAGE_VIEW(x)
#define SELF_CONST(x) MN_MESSAGE_VIEW_CONST(x)
#define IS_SELF(x) MN_IS_MESSAGE_VIEW(x)
#define TYPE_SELF MN_TYPE_MESSAGE_VIEW
#define SELF_CLASS(x) MN_MESSAGE_VIEW_CLASS(x)

#define SELF_GET_CLASS(x) MN_MESSAGE_VIEW_GET_CLASS(x)

/* self typedefs */
typedef MNMessageView Self;
typedef MNMessageViewClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_message_view_init (MNMessageView * o) G_GNUC_UNUSED;
static void mn_message_view_class_init (MNMessageViewClass * c) G_GNUC_UNUSED;
static GObject * ___2_mn_message_view_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void mn_message_view_update_tabs (MNMessageView * self) G_GNUC_UNUSED;
static void mn_message_view_style_set_h (GtkWidget * widget, GtkStyle * previous_style, gpointer user_data) G_GNUC_UNUSED;
static gboolean mn_message_view_update_tabs_cb (gpointer data) G_GNUC_UNUSED;
static void mn_message_view_realize_h (GtkWidget * widget, gpointer user_data) G_GNUC_UNUSED;
static void mn_message_view_message_info_free (MessageInfo * info) G_GNUC_UNUSED;
static void ___8_mn_message_view_finalize (GObject * object) G_GNUC_UNUSED;
static gboolean mn_message_view_update_sent_cb (gpointer data) G_GNUC_UNUSED;
static void mn_message_view_clear (MNMessageView * self) G_GNUC_UNUSED;
static MessageInfo * mn_message_view_append_message (MNMessageView * self, MNMessage * message) G_GNUC_UNUSED;
static void mn_message_view_append (MNMessageView * self, const char * text) G_GNUC_UNUSED;
static void mn_message_view_append_row (MNMessageView * self, const char * name, const char * value, GSList ** header_marks, GtkTextMark ** value_start_mark, GtkTextMark ** value_end_mark) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_TRANSPARENT,
	PROP_TEXT_POINTER,
	PROP_MESSAGES
};

/* pointer to the class of our parent */
static GtkTextViewClass *parent_class = NULL;

/* Short form macros */
#define self_set_messages mn_message_view_set_messages
#define self_update_tabs mn_message_view_update_tabs
#define self_style_set_h mn_message_view_style_set_h
#define self_update_tabs_cb mn_message_view_update_tabs_cb
#define self_realize_h mn_message_view_realize_h
#define self_message_info_free mn_message_view_message_info_free
#define self_update_sent_cb mn_message_view_update_sent_cb
#define self_clear mn_message_view_clear
#define self_append_message mn_message_view_append_message
#define self_append mn_message_view_append
#define self_append_row mn_message_view_append_row
#define self_new mn_message_view_new
GType
mn_message_view_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMessageViewClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_message_view_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMessageView),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_message_view_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_TEXT_VIEW, "MNMessageView", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMessageView *)g_object_new(mn_message_view_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMessageView * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMessageView *
GET_NEW_VARG (const char *first, ...)
{
	MNMessageView *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMessageView *)g_object_new_valist (mn_message_view_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Message:View::finalize"
	MNMessageView *self G_GNUC_UNUSED = MN_MESSAGE_VIEW (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 232 "mn-message-view.gob"
	___8_mn_message_view_finalize(obj_self);
#line 150 "mn-message-view.c"
}
#undef __GOB_FUNCTION__

static void 
mn_message_view_init (MNMessageView * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message:View::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNMessageViewPrivate);
}
#undef __GOB_FUNCTION__
static void 
mn_message_view_class_init (MNMessageViewClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message:View::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMessageViewPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_TEXT_VIEW);

#line 94 "mn-message-view.gob"
	g_object_class->constructor = ___2_mn_message_view_constructor;
#line 232 "mn-message-view.gob"
	g_object_class->finalize = ___finalize;
#line 175 "mn-message-view.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("transparent" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_TRANSPARENT,
		param_spec);
	param_spec = g_param_spec_boolean
		("text_pointer" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_TEXT_POINTER,
		param_spec);
	param_spec = g_param_spec_pointer
		("messages" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGES,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message:View::set_property"
{
	MNMessageView *self G_GNUC_UNUSED;

	self = MN_MESSAGE_VIEW (object);

	switch (property_id) {
	case PROP_TRANSPARENT:
		{
#line 49 "mn-message-view.gob"
self->_priv->transparent = g_value_get_boolean (VAL);
#line 227 "mn-message-view.c"
		}
		break;
	case PROP_TEXT_POINTER:
		{
#line 52 "mn-message-view.gob"
self->_priv->text_pointer = g_value_get_boolean (VAL);
#line 234 "mn-message-view.c"
		}
		break;
	case PROP_MESSAGES:
		{
#line 57 "mn-message-view.gob"

      GSList *messages;
      MessageInfo *info;
      GSList *l;
      gboolean need_updates = FALSE;

      eel_g_slist_free_deep_custom(selfp->messages, (GFunc) self_message_info_free, NULL);
      selfp->messages = NULL;
      
      self_clear(self);

      messages = g_value_get_pointer(VAL);
      if (messages)
	MN_LIST_FOREACH(l, messages)
          {
	    info = self_append_message(self, l->data);
	    
	    if (info->last_sent)
	      need_updates = TRUE;
	    
	    if (l->next)
	      self_append(self, "\n\n");
	  }
      else
	self_append(self, _("You have no new mail."));

      self_update_tabs(self);

      if (need_updates)
	{
	  if (! selfp->update_sent_timeout_id)
	    selfp->update_sent_timeout_id = g_timeout_add(500, self_update_sent_cb, self);
	}
      else
	mn_source_remove(&selfp->update_sent_timeout_id);
    
#line 276 "mn-message-view.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message:View::get_property"
{
	MNMessageView *self G_GNUC_UNUSED;

	self = MN_MESSAGE_VIEW (object);

	switch (property_id) {
	case PROP_TRANSPARENT:
		{
#line 49 "mn-message-view.gob"
g_value_set_boolean (VAL, self->_priv->transparent);
#line 307 "mn-message-view.c"
		}
		break;
	case PROP_TEXT_POINTER:
		{
#line 52 "mn-message-view.gob"
g_value_set_boolean (VAL, self->_priv->text_pointer);
#line 314 "mn-message-view.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 57 "mn-message-view.gob"
void 
mn_message_view_set_messages (MNMessageView * self, gpointer val)
#line 334 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::set_messages"
{
#line 55 "mn-message-view.gob"
		g_object_set (G_OBJECT (self), "messages", val, NULL);
}}
#line 341 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 94 "mn-message-view.gob"
static GObject * 
___2_mn_message_view_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 347 "mn-message-view.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Message:View::constructor"
{
#line 96 "mn-message-view.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    selfp->buffer = gtk_text_buffer_new(NULL);
    selfp->header_tag = gtk_text_buffer_create_tag(selfp->buffer,
						   NULL,
						   "weight", PANGO_WEIGHT_BOLD,
						   NULL);

    gtk_text_view_set_buffer(GTK_TEXT_VIEW(self), selfp->buffer);
    gtk_text_view_set_editable(GTK_TEXT_VIEW(self), FALSE);
    gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(self), FALSE);

    g_object_connect(self,
		     "signal-after::style-set", self_style_set_h, NULL,
		     "signal-after::realize", self_realize_h, NULL,
		     NULL);

    return object;
  }}
#line 380 "mn-message-view.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 121 "mn-message-view.gob"
static void 
mn_message_view_update_tabs (MNMessageView * self)
#line 387 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::update_tabs"
#line 121 "mn-message-view.gob"
	g_return_if_fail (self != NULL);
#line 121 "mn-message-view.gob"
	g_return_if_fail (MN_IS_MESSAGE_VIEW (self));
#line 394 "mn-message-view.c"
{
#line 123 "mn-message-view.gob"
	
    GSList *l;
    int longest_header_len = 0;
    PangoTabArray *tabs;

    MN_LIST_FOREACH(l, selfp->messages)
      {
	MessageInfo *info = l->data;
	GSList *m;

	MN_LIST_FOREACH(m, info->header_marks)
	  {
	    GtkTextMark *mark = m->data;
	    GtkTextIter iter;
	    GdkRectangle rect;

	    gtk_text_buffer_get_iter_at_mark(selfp->buffer, &iter, mark);
	    gtk_text_view_get_iter_location(GTK_TEXT_VIEW(self), &iter, &rect);

	    if (rect.x > longest_header_len)
	      longest_header_len = rect.x;
	  }
      }

    tabs = pango_tab_array_new_with_positions(1, TRUE, PANGO_TAB_LEFT, longest_header_len + 12);
    gtk_text_view_set_tabs(GTK_TEXT_VIEW(self), tabs);
    pango_tab_array_free(tabs);
  }}
#line 425 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 152 "mn-message-view.gob"
static void 
mn_message_view_style_set_h (GtkWidget * widget, GtkStyle * previous_style, gpointer user_data)
#line 431 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::style_set_h"
#line 152 "mn-message-view.gob"
	g_return_if_fail (widget != NULL);
#line 152 "mn-message-view.gob"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 438 "mn-message-view.c"
{
#line 156 "mn-message-view.gob"
	
    Self *self = SELF(widget);

    if (selfp->update_tabs_idle_id)
      g_source_remove(selfp->update_tabs_idle_id);

    selfp->update_tabs_idle_id = g_idle_add(self_update_tabs_cb, self);
  }}
#line 449 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 165 "mn-message-view.gob"
static gboolean 
mn_message_view_update_tabs_cb (gpointer data)
#line 455 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::update_tabs_cb"
#line 165 "mn-message-view.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 460 "mn-message-view.c"
{
#line 167 "mn-message-view.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();
    self_update_tabs(self);
    selfp->update_tabs_idle_id = 0;
    GDK_THREADS_LEAVE();

    return FALSE;		/* remove */
  }}
#line 473 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 178 "mn-message-view.gob"
static void 
mn_message_view_realize_h (GtkWidget * widget, gpointer user_data)
#line 479 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::realize_h"
#line 178 "mn-message-view.gob"
	g_return_if_fail (widget != NULL);
#line 178 "mn-message-view.gob"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 486 "mn-message-view.c"
{
#line 180 "mn-message-view.gob"
	
    Self *self = SELF(widget);
    GtkStateType state;

    if (selfp->transparent)
      {
	GtkWidget *toplevel;
	
	toplevel = gtk_widget_get_toplevel(widget);
	g_return_if_fail(toplevel != NULL);
	g_return_if_fail(toplevel->style != NULL);
	
	for (state = GTK_STATE_NORMAL; state <= GTK_STATE_INSENSITIVE; state++)
	  gtk_widget_modify_base(widget, state, &toplevel->style->bg[state]);
      }

    if (! selfp->text_pointer)
      {
	GdkWindow *window;

	window = gtk_text_view_get_window(GTK_TEXT_VIEW(self), GTK_TEXT_WINDOW_TEXT);
	g_return_if_fail(window != NULL);

	gdk_window_set_cursor(window, NULL);
      }

    g_return_if_fail(widget->style != NULL);
    for (state = GTK_STATE_NORMAL; state <= GTK_STATE_INSENSITIVE; state++)
      gtk_widget_modify_bg(widget, state, &widget->style->base[state]);
  }}
#line 519 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 211 "mn-message-view.gob"
static void 
mn_message_view_message_info_free (MessageInfo * info)
#line 525 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::message_info_free"
#line 211 "mn-message-view.gob"
	g_return_if_fail (info != NULL);
#line 530 "mn-message-view.c"
{
#line 213 "mn-message-view.gob"
	
    GSList *l;

    g_object_unref(info->message);
    
    MN_LIST_FOREACH(l, info->header_marks)
      gtk_text_buffer_delete_mark(gtk_text_mark_get_buffer(l->data), l->data);
    g_slist_free(info->header_marks);

    if (info->sent_start)
      {
	gtk_text_buffer_delete_mark(gtk_text_mark_get_buffer(info->sent_start), info->sent_start);
	gtk_text_buffer_delete_mark(gtk_text_mark_get_buffer(info->sent_end), info->sent_end);
      }
    
    g_free(info->last_sent);
    g_free(info);
  }}
#line 551 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 232 "mn-message-view.gob"
static void 
___8_mn_message_view_finalize (GObject * object G_GNUC_UNUSED)
#line 557 "mn-message-view.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Message:View::finalize"
#line 232 "mn-message-view.gob"
	g_return_if_fail (object != NULL);
#line 232 "mn-message-view.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 567 "mn-message-view.c"
{
#line 234 "mn-message-view.gob"
	
    Self *self = SELF(object);

    if (selfp->update_tabs_idle_id)
      g_source_remove(selfp->update_tabs_idle_id);
    if (selfp->update_sent_timeout_id)
      g_source_remove(selfp->update_sent_timeout_id);

    eel_g_slist_free_deep_custom(selfp->messages, (GFunc) self_message_info_free, NULL);
    g_object_unref(selfp->buffer);

    PARENT_HANDLER(object);
  }}
#line 583 "mn-message-view.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 248 "mn-message-view.gob"
static gboolean 
mn_message_view_update_sent_cb (gpointer data)
#line 590 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::update_sent_cb"
#line 248 "mn-message-view.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 595 "mn-message-view.c"
{
#line 250 "mn-message-view.gob"
	
    Self *self = data;
    GSList *l;

    GDK_THREADS_ENTER();
    MN_LIST_FOREACH(l, selfp->messages)
      {
	MessageInfo *info = l->data;

	if (info->last_sent)
	  {
	    char *sent;
	    
	    sent = mn_message_format_sent_time(info->message);
	    if (! sent || strcmp(sent, info->last_sent))
	      {
		GtkTextIter start;
		GtkTextIter end;

		gtk_text_buffer_get_iter_at_mark(selfp->buffer, &start, info->sent_start);
		gtk_text_buffer_get_iter_at_mark(selfp->buffer, &end, info->sent_end);

		gtk_text_buffer_delete(selfp->buffer, &start, &end);

		if (sent)
		  {
		    gtk_text_buffer_insert(selfp->buffer, &end, sent, -1);
		    gtk_text_buffer_move_mark(selfp->buffer, info->sent_end, &end);
		  }

		g_free(info->last_sent);
		info->last_sent = sent;
	      }
	    else
	      g_free(sent);
	  }
      }
    GDK_THREADS_LEAVE();

    return TRUE;		/* continue */
  }}
#line 639 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 292 "mn-message-view.gob"
static void 
mn_message_view_clear (MNMessageView * self)
#line 645 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::clear"
#line 292 "mn-message-view.gob"
	g_return_if_fail (self != NULL);
#line 292 "mn-message-view.gob"
	g_return_if_fail (MN_IS_MESSAGE_VIEW (self));
#line 652 "mn-message-view.c"
{
#line 294 "mn-message-view.gob"
	
    GtkTextIter start;
    GtkTextIter end;

    gtk_text_buffer_get_start_iter(selfp->buffer, &start);
    gtk_text_buffer_get_end_iter(selfp->buffer, &end);
    gtk_text_buffer_delete(selfp->buffer, &start, &end);
  }}
#line 663 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 303 "mn-message-view.gob"
static MessageInfo * 
mn_message_view_append_message (MNMessageView * self, MNMessage * message)
#line 669 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::append_message"
#line 303 "mn-message-view.gob"
	g_return_val_if_fail (self != NULL, (MessageInfo * )0);
#line 303 "mn-message-view.gob"
	g_return_val_if_fail (MN_IS_MESSAGE_VIEW (self), (MessageInfo * )0);
#line 303 "mn-message-view.gob"
	g_return_val_if_fail (message != NULL, (MessageInfo * )0);
#line 303 "mn-message-view.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (message), (MessageInfo * )0);
#line 680 "mn-message-view.c"
{
#line 305 "mn-message-view.gob"
	
    MessageInfo *info;

    info = g_new0(MessageInfo, 1);
    info->message = g_object_ref(message);

    self_append_row(self,
		    _("Mailbox"),
		    message->mailbox_uri->human_readable,
		    &info->header_marks,
		    NULL,
		    NULL);
    self_append(self, "\n");
    
    if (message->error)
      self_append_row(self,
		      _("Unreadable message"),
		      message->error,
		      &info->header_marks,
		      NULL,
		      NULL);
    else
      {
	self_append_row(self,
			_("From"),
			message->from,
			&info->header_marks,
			NULL,
			NULL);
	self_append(self, "\n");

	self_append_row(self,
			_("Subject"),
			message->subject,
			&info->header_marks,
			NULL,
			NULL);

	info->last_sent = mn_message_format_sent_time(message);
	if (info->last_sent)
	  {
	    self_append(self, "\n");
	    self_append_row(self,
			    _("Sent"),
			    info->last_sent,
			    &info->header_marks,
			    &info->sent_start,
			    &info->sent_end);
	  }
      }

    selfp->messages = g_slist_append(selfp->messages, info);
    
    return info;
  }}
#line 738 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 361 "mn-message-view.gob"
static void 
mn_message_view_append (MNMessageView * self, const char * text)
#line 744 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::append"
#line 361 "mn-message-view.gob"
	g_return_if_fail (self != NULL);
#line 361 "mn-message-view.gob"
	g_return_if_fail (MN_IS_MESSAGE_VIEW (self));
#line 361 "mn-message-view.gob"
	g_return_if_fail (text != NULL);
#line 753 "mn-message-view.c"
{
#line 363 "mn-message-view.gob"
	
    GtkTextIter end;
    
    gtk_text_buffer_get_end_iter(selfp->buffer, &end);
    gtk_text_buffer_insert(selfp->buffer, &end, text, -1);
  }}
#line 762 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 370 "mn-message-view.gob"
static void 
mn_message_view_append_row (MNMessageView * self, const char * name, const char * value, GSList ** header_marks, GtkTextMark ** value_start_mark, GtkTextMark ** value_end_mark)
#line 768 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::append_row"
#line 370 "mn-message-view.gob"
	g_return_if_fail (self != NULL);
#line 370 "mn-message-view.gob"
	g_return_if_fail (MN_IS_MESSAGE_VIEW (self));
#line 370 "mn-message-view.gob"
	g_return_if_fail (name != NULL);
#line 370 "mn-message-view.gob"
	g_return_if_fail (value != NULL);
#line 370 "mn-message-view.gob"
	g_return_if_fail (header_marks != NULL);
#line 781 "mn-message-view.c"
{
#line 377 "mn-message-view.gob"
	
    GtkTextIter end;

    gtk_text_buffer_get_end_iter(selfp->buffer, &end);
    
    gtk_text_buffer_insert_with_tags(selfp->buffer, &end, name, -1, selfp->header_tag, NULL);
    gtk_text_buffer_insert_with_tags(selfp->buffer, &end, ":", -1, selfp->header_tag, NULL);

    *header_marks = g_slist_append(*header_marks, gtk_text_buffer_create_mark(selfp->buffer, NULL, &end, TRUE));
    gtk_text_buffer_insert(selfp->buffer, &end, "\t", -1);

    if (value_start_mark)
      *value_start_mark = gtk_text_buffer_create_mark(selfp->buffer, NULL, &end, TRUE);

    gtk_text_buffer_insert(selfp->buffer, &end, value, -1);

    if (value_end_mark)
      *value_end_mark = gtk_text_buffer_create_mark(selfp->buffer, NULL, &end, TRUE);
  }}
#line 803 "mn-message-view.c"
#undef __GOB_FUNCTION__

#line 397 "mn-message-view.gob"
GtkWidget * 
mn_message_view_new (gboolean transparent, gboolean text_pointer)
#line 809 "mn-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Message:View::new"
{
#line 399 "mn-message-view.gob"
	
    return GTK_WIDGET(GET_NEW_VARG(MN_MESSAGE_VIEW_PROP_TRANSPARENT(transparent),
				   MN_MESSAGE_VIEW_PROP_TEXT_POINTER(text_pointer),
				   NULL));
  }}
#line 819 "mn-message-view.c"
#undef __GOB_FUNCTION__
