
{ 
  open Dot_types
  open Dot_parser
  let kwd = Hashtbl.create 37

  let _ = 
    List.iter (fun (k, tok) -> Hashtbl.add kwd k tok)
      [ "strict", STRICT;
        "graph", GRAPH;
        "digraph", DIGRAPH;
        "node", NODE;
        "edge", EDGE;
        "subgraph", SUBGRAPH; ]
}

let alpha = ['A'-'Z' 'a'-'z']
let digit = ['0'-'9']
let ident = (alpha | '_') (alpha | '_' | digit)*
let number = digit+

rule lex = parse
  | [ ' ' '\n' '\t']+   { lex lexbuf }
  | '#'  [^ '\n']* '\n' { lex lexbuf }
  | "//" [^ '\n']* '\n' { lex lexbuf }
  | "/*"                { comment lexbuf ; lex lexbuf }
  | "{"                 { LBRACE }
  | "}"                 { RBRACE }
  | "("                 { LPAREN }
  | ")"                 { RPAREN }
  | "["                 { LBRACKET }
  | "]"                 { RBRACKET }
  | ","                 { COMMA }
  | ";"                 { SEMICOLON }
  | "="                 { EQUAL }
  | "@"                 { AT }
  | ":"                 { COLON }
  | "+"                 { PLUS }
  | "->"                { DIR_EDGEOP }
  | "--"                { UNDIR_EDGEOP }
  | ident               { let lexeme = (Lexing.lexeme lexbuf) in
                          try Hashtbl.find kwd lexeme
                          with Not_found -> IDENT lexeme }
  | digit               { NUMBER (Lexing.lexeme lexbuf) }
  | '"'                 { let b = Buffer.create 128 in
                          string b lexbuf ; 
                          STRING (Buffer.contents b) }

and string b = parse
  | '"'     { () }
  | "\\\n"  { string b lexbuf } 
  | "\\\""  { Buffer.add_char b '"' ; string b lexbuf }
  | _       { Buffer.add_char b (Lexing.lexeme_char lexbuf 0) ; 
              string b lexbuf }

and comment = parse
  | "*/"                { () }
  | _                   { comment lexbuf }
  
