//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: key.cpp,v 1.1 2002/01/30 12:08:38 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include <assert.h>
#include "key.h"
#include "symbols.h"
#include "globals.h"

int NKey::offsets[14] = {
      0, 7, 14, -7,
      -(12),
      -19, -26, -10, -14, -2, -4, -6, -8, 0
      };

int NKey::width() const
      {
      return 25;
      }

//---------------------------------------------------------
//   draw
//---------------------------------------------------------

void Scale::draw(NKey& key, QPainter& p, const QPoint& pto) const
      {
      int lineD = 6;

      if (val == 0)
            return;

      if (val > 0) {
            for (int i = 0; i < val; ++i) {
                  int k = sharpTab[key.idx()][i];
                  QPoint pt(i*7, k * (lineD/2));
                  sharpSprite->draw(p, pt+pto);
                  }
            }
      else {
            int s = -val;
            for (int i = 0; i < s; ++i) {
                  QPoint pt(i*6, flatTab[key.idx()][i] * (lineD/2));
                  flatSprite->draw(p, pt+pto);
                  }
            }
      }

//---------------------------------------------------------
//   Scale::width
//---------------------------------------------------------

int Scale::width() const
      {
      int i = val;
      if (i < 0)
           i = -i;
      return i * 7;
      }

//---------------------------------------------------------
//   NKey::draw
//---------------------------------------------------------

void NKey::draw(QPainter& p, const QPoint& pto) const
      {
      QPoint po;

      switch(val) {
            case  0:
            case  1:
            case  2:
            case  3:
            case  4:
            case  5:
            case  6:
            case  7:
            case  8:     po = QPoint(8, 7); break;
            case  9:
            case 10:
            case 11:
            case 12:     po = QPoint(8, 8); break;
            case 13:     po = QPoint(8, 7); break;
            }
      p.drawPixmap(pto - po, *keyBM[val]);
      }

//---------------------------------------------------------
//   Scale::print
//---------------------------------------------------------

void Scale::print(NKey& key, FILE* f, const QPoint& pto) const
      {
      if (val == 0)
            return;

      int x = pto.x();
      if (val > 0) {
            for (int i = 0; i < val; ++i) {
                  int k = sharpTab[key.idx()][i];
                  fprintf(f, "%d %d moveto <cb> show\n", x + i*6, k * 3);
                  }
            }
      else {
            int s = -val;
            for (int i = 0; i < s; ++i) {
                  int k = flatTab[key.idx()][i];
                  fprintf(f, "%d %d moveto <c8> show\n", x + i*6, k * 3);  // flat
                  }
            }
      }
