//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: pcm.cpp,v 1.1 2002/01/30 12:08:39 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//  based on libsndfile:
//  Copyright (C) 1999-2000 Erik de Castro Lopo <erikd@zip.com.au>
//=========================================================

#include <unistd.h>
#include <math.h>
#include "config.h"
#include "sndfile.h"
#include "sfendian.h"
#include "pcm.h"

//---------------------------------------------------------
//   les2f_array
//    short to float, deinterleaving
//---------------------------------------------------------

static void les2f_array (short *buffer, unsigned frames, int channels,
   float** pp, int index)
      {
      for (unsigned k = 0; k < frames*channels; k += channels) {
            for (int i = 0; i < channels; ++i) {
                  short value = buffer[k+i];
		      *(pp[i] + index + k/channels) = float(value) / 32767.0;
                  }
		}
      }

//---------------------------------------------------------
//   les1f_array
//    char to float, deinterleaving
//---------------------------------------------------------

static void les1f_array (char *buffer, unsigned frames, int channels,
   float** pp, int index)
      {
      for (unsigned k = 0; k < frames*channels; k += channels) {
            for (int i = 0; i < channels; ++i) {
                  char value = buffer[k+i];
		      *(pp[i] + index + k/channels) = float(value) / 128.0;
                  }
		}
      }

//---------------------------------------------------------
//   f2les_array
//    float to short, interleaving
//---------------------------------------------------------

static void f2les_array (float** ptr, int index, short *buffer,
   unsigned frames, int channels)
      {
	for (unsigned k = 0 ; k < frames; ++k) {
            for (int i = 0; i < channels; ++i) {
                  buffer[k*channels+i] = lrint(*(ptr[i] + index + k) * 32767.0);
                  }
            }
      }

//---------------------------------------------------------
//   SndFileFormatFloat
//---------------------------------------------------------

SndFileFormatWaveFloat::SndFileFormatWaveFloat(SndFile* s)
   : SndFileFormatWave(s)
      {
      }

//---------------------------------------------------------
//   SndFileFormatWavePCM1::read
//---------------------------------------------------------

size_t SndFileFormatWavePCM1::read(float** pp, unsigned len)
      {	
      unsigned total     = 0;
	int index          = 0;
      int channels       = sfile->channels();
	int framesize      = sfile->blockwidth();
	unsigned bufferlen = SF_BUFFER_LEN / framesize;
	while (len > 0) {	
            unsigned readcount = (len >= bufferlen) ? bufferlen : len;
		unsigned frames    = fread(buffer, framesize, readcount, sfile->file());
		les1f_array((char *) (buffer), frames, channels, pp, index);
		total += frames;
		if (frames < readcount) {
		      sfile->setErrno(SFE_SHORT_READ);
			break;
                  }
		index += frames;
		len   -= frames;
		}
	return total;
      }

//---------------------------------------------------------
//   SndFileFormatWavePCM2::read
//    read len frames
//---------------------------------------------------------

size_t SndFileFormatWavePCM2::read(float** pp, unsigned len)
      {	
      unsigned total     = 0;
	int index          = 0;
      int channels       = sfile->channels();
	int framesize      = sfile->blockwidth();
	unsigned bufferlen = SF_BUFFER_LEN / framesize;
	while (len > 0) {	
            unsigned readcount = (len >= bufferlen) ? bufferlen : len;
		unsigned frames    = fread(buffer, framesize, readcount, sfile->file());
		les2f_array((short*) (buffer), frames, channels, pp, index);
		total += frames;
		if (frames < readcount) {
		      sfile->setErrno(SFE_SHORT_READ);
			break;
                  }
		index += frames;
		len   -= frames;
		}
	return total;
      }

//---------------------------------------------------------
//   SndFileFormatWavePCM2::write
//    write len frames
//---------------------------------------------------------

size_t SndFileFormatWavePCM2::write(float**ptr, unsigned len)
      {	
      unsigned total        = 0;
	int index             = 0;
      int channels          = sfile->channels();
	int framesize         = sfile->blockwidth();
	unsigned bufferlen    = SF_BUFFER_LEN / framesize;
	
	while (len > 0) {	
            unsigned writecount = (len >= bufferlen) ? bufferlen : len;
		f2les_array (ptr, index, (short*) buffer, writecount, channels);
		unsigned frames = fwrite (buffer, framesize, writecount, sfile->file());
		total += frames;
		if (frames < writecount)
			break;
		index  += frames;
		len    -= frames;
		}
	return total;
      }

size_t SndFileFormatWavePCM3::read(float**, unsigned)
      {	
      unsigned total = 0;
      printf("not implemented: PCM3 read\n");
#if 0
      unsigned int readcount, thisread ;
	int		bytecount, bufferlen ;
	int		index = 0;
	double		normfact ;

	normfact = 1.0;

	bufferlen = SF_BUFFER_LEN - (SF_BUFFER_LEN % sfile->blockwidth()) ;
	bytecount = len * sfile->bytewidth ;
	while (bytecount > 0)
	{	readcount = (bytecount >= bufferlen) ? bufferlen : bytecount ;
		thisread = fread (sfile->buffer, 1, readcount, sfile->file()) ;
		let2f_array ((tribyte*) (sfile->buffer), thisread / sfile->bytewidth, ptr, index, normfact) ;
		total += thisread ;
		if (thisread < readcount)
			break ;
		index += thisread / sfile->bytewidth ;
		bytecount -= thisread ;
		} ;

	total /= sfile->bytewidth ;
	if (total < len)
		sfile->setErrno(SFE_SHORT_READ);
#endif
	return total;
      }

size_t SndFileFormatWavePCM4::read(float**, unsigned)
      {	
      unsigned total = 0;
      printf("not implemented: PCM4 read\n");
#if 0
      unsigned int readcount, thisread ;
	int		bytecount, bufferlen ;
	int		index = 0;
	double		normfact ;

	normfact = 1.0;

	bufferlen = SF_BUFFER_LEN - (SF_BUFFER_LEN % sfile->blockwidth()) ;
	bytecount = len * sfile->bytewidth ;
	while (bytecount > 0)
	{	readcount = (bytecount >= bufferlen) ? bufferlen : bytecount ;
		thisread = fread (sfile->buffer, 1, readcount, sfile->file()) ;
		lei2f_array ((int*) (sfile->buffer), thisread / sfile->bytewidth, ptr, index, normfact) ;
		total += thisread ;
		if (thisread < readcount)
			break ;
		index += thisread / sfile->bytewidth ;
		bytecount -= thisread ;
		} ;

	total /= sfile->bytewidth ;
	if (total < len)
		sfile->setErrno(SFE_SHORT_READ);
#endif
	return total;
      }

size_t SndFileFormatWaveFloat::read(float**, unsigned)
      {	
      unsigned total = 0;
#if 0
      unsigned int readcount, thisread ;
	int		bytecount, bufferlen ;
	int	index = 0;
	double normfact;

	normfact = 1.0;

	bufferlen = SF_BUFFER_LEN - (SF_BUFFER_LEN % sfile->blockwidth()) ;
	bytecount = len * sfile->bytewidth ;
	while (bytecount > 0)
	{	readcount = (bytecount >= bufferlen) ? bufferlen : bytecount ;
		thisread = fread (sfile->buffer, 1, readcount, sfile->file()) ;
		f2f_array ((float*) (sfile->buffer), thisread / sfile->bytewidth, ptr, index, normfact) ;
		total += thisread ;
		if (thisread < readcount)
			break ;
		index += thisread / sfile->bytewidth ;
		bytecount -= thisread ;
		} ;

	total /= sfile->bytewidth ;
	if (total < len)
		sfile->setErrno(SFE_SHORT_READ);
#endif
	return total;
      }

size_t SndFileFormatWavePCM1::write(float**, unsigned)
      {	
      unsigned total = 0;
#if  0
      unsigned int      writecount, thiswrite ;
	int	bytecount, bufferlen ;
	int		index = 0;
	double		normfact ;
	
	normfact = 1.0;

	bufferlen = SF_BUFFER_LEN - (SF_BUFFER_LEN % sfile->blockwidth()) ;
	bytecount = len * sfile->bytewidth ;
	while (bytecount > 0)
	{	writecount = (bytecount >= bufferlen) ? bufferlen : bytecount ;
		f2uc_array (ptr, index, (unsigned char*) (sfile->buffer), writecount / sfile->bytewidth, normfact) ;
		thiswrite = fwrite (sfile->buffer, 1, writecount, sfile->file()) ;
		total += thiswrite ;
		if (thiswrite < writecount)
			break ;
		index += thiswrite / sfile->bytewidth ;
		bytecount -= thiswrite ;
		} ;

	total /= sfile->bytewidth ;
	if (total < len)
		sfile->setErrno(SFE_SHORT_WRITE);
#endif
	return total;
      }

size_t SndFileFormatWavePCM3::write(float**, unsigned)
      {	
      unsigned total = 0;
#if 0
      unsigned int      writecount, thiswrite ;
	int	bytecount, bufferlen ;
	int		index = 0;
	double		normfact ;
	
	normfact = 1.0;

	bufferlen = SF_BUFFER_LEN - (SF_BUFFER_LEN % sfile->blockwidth()) ;
	bytecount = len * sfile->bytewidth ;
	while (bytecount > 0)
	{	writecount = (bytecount >= bufferlen) ? bufferlen : bytecount ;
		f2let_array (ptr, index, (tribyte*) (sfile->buffer), writecount / sfile->bytewidth, normfact) ;
		thiswrite = fwrite (sfile->buffer, 1, writecount, sfile->file()) ;
		total += thiswrite ;
		if (thiswrite < writecount)
			break ;
		index += thiswrite / sfile->bytewidth ;
		bytecount -= thiswrite ;
		} ;

	total /= sfile->bytewidth ;
	if (total < len)
		sfile->setErrno(SFE_SHORT_WRITE);
#endif
	return total;
      }

size_t SndFileFormatWavePCM4::write(float**, unsigned)
      {	
      unsigned total = 0;
#if 0
      unsigned int      writecount, thiswrite ;
	int	bytecount, bufferlen ;
	int		index = 0;
	double		normfact ;
	
	normfact = (double) 0x80000000;

	bufferlen = SF_BUFFER_LEN - (SF_BUFFER_LEN % sfile->blockwidth()) ;
	bytecount = len * sfile->bytewidth ;
	while (bytecount > 0)
	{	writecount = (bytecount >= bufferlen) ? bufferlen : bytecount ;
		f2lei_array (ptr, index, (int*) (sfile->buffer), writecount / sfile->bytewidth, normfact) ;
		thiswrite = fwrite (sfile->buffer, 1, writecount, sfile->file()) ;
		total += thiswrite ;
		if (thiswrite < writecount)
			break ;
		index += thiswrite / sfile->bytewidth ;
		bytecount -= thiswrite ;
		} ;

	total /= sfile->bytewidth ;
	if (total < len)
		sfile->setErrno(SFE_SHORT_WRITE);
#endif
	return total;
      }

size_t SndFileFormatWaveFloat::write(float**, unsigned)
      {	
      unsigned total = 0;
#if 0
      unsigned int writecount, thiswrite;
	int index = 0;

	double normfact = 1.0;
	int bufferlen = SF_BUFFER_LEN - (SF_BUFFER_LEN % sfile->blockwidth());
	int bytecount = len * sfile->bytewidth;

	while (bytecount > 0) {	
            writecount = (bytecount >= bufferlen) ? bufferlen : bytecount;
		f2f_array (ptr, index, (float*) (sfile->buffer), writecount / sfile->bytewidth, normfact);
		thiswrite = fwrite (sfile->buffer, 1, writecount, sfile->file());
		total += thiswrite;
		if (thiswrite < writecount)
			break;
		index += thiswrite / sfile->bytewidth;
		bytecount -= thiswrite;
		} ;

	total /= sfile->bytewidth;
	if (total < len)
		sfile->setErrno(SFE_SHORT_WRITE);
#endif
	return total;
      }

