#include "xport.h"
#include <qfiledialog.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qmessagebox.h>
#include "mainwindow.h"

void Xport::slot_close()
{
	parentWidget()->close();
}

void Xport::slot_export()
{
	QString z = QFileDialog::getOpenFileName(QString::null, "*.sql", this);

	if(!z.isEmpty())
	{
		export_file->setText(z);
	}
}

void Xport::slot_import()
{
	QString z = QFileDialog::getOpenFileName(QString::null, "*.sql", this);

	if(!z.isEmpty())
	{
		import_file->setText(z);
	}
}

void Xport::slot_list_export_table(int s)
{
	MYSQL_RES *result;

    MYSQL_ROW row;

	export_table->clear();

	if(mysql_select_db(mysql, export_database->text(s).latin1()))
		return;

	result = mysql_list_tables(mysql, NULL);

	if(result == NULL)
	{
		return;
	}

    export_table->insertItem("*");
	
	while((row = mysql_fetch_row(result)))
    {
        export_table->insertItem(row[0]);
	}

	mysql_free_result(result);
}

void Xport::slot_fire()
{
	if(import->isOn())
	{
		if(import_file->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter import file."));
			return;
		}
		xport_import();
	}
	else if(export_->isOn())
	{
		if(export_file->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter export file."));
			return;
		}
		xport_export();
	}
}

void Xport::slot_database()
{
	QList<QString> value;
	value = ((MainWindow *)qApp->mainWidget())->database->get_value();
	export_database->slot_value(value);
	value = ((MainWindow *)qApp->mainWidget())->database->get_value();
	import_database->slot_value(value);

	slot_list_export_table(0);
	
	return;
}

void Xport::slot_database(const QString &value)
{
	for(int z = 0; z < export_database->count(); z++)
	{
		if(value == export_database->text(z))
		{
			export_database->setCurrentItem(z);
			import_database->setCurrentItem(z);
			export_database->data = value;
			import_database->data = value;
			break;
		}
	}
}
