'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_text.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: msc $ $Date: 2006/03/31 09:52:54 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : test for a text database
'*
'************************************************************************
'*
' #1 b_lvl1_text
' #1 tCountCharacterSet
' #1 tOpenUTF8File
'*
'\***********************************************************************

sub b_lvl1_text(sFilename as string)

    call tCountCharacterSet(sFilename)
    call tOpenUTF8File(sFilename)

end sub
'-------------------------------------------------------------------------
testcase tCountCharacterSet(sFilename as string)

	'/// open the text database create in the bas file    
    call fOpendatabase(sFileName)

	'/// open the properties dialog of the open database
    printlog "open the properties dialog of the open database"            
    Kontext "Insight"    
        Insight.UseMenu    
        hMenuSelectNr(2)
        hMenuSelectNr(14)
        hMenuSelectNr(1)

    '/// switch to the Text Tabpage    
    printlog "switch to the Text Tabpage"    
    Kontext "DatabaseProperties"        
        TabControl.setPage TabTextBase
    
    '/// check if there are 54 character sets
    printlog "check if there are 54 character sets"   
    Kontext "TabTextBase"
        dim i as integer
        i = CharSet.getItemCount()
        if i <> 54 then
            warnlog "The count of the charsets is wrong. It have to be 54 but it is:" + i
        else
            printlog "The count of the charsets is correct.There are 54 character sets."
        endif       
    '/// close the properties dialog with OK
    printlog "close the properties dialog with OK"    
    Kontext "DatabaseProperties"
        DatabaseProperties.OK
    
    '/// close the database
    printlog "close the database"    
    call fCloseDatabase()

endcase
'-------------------------------------------------------------------------
testcase tOpenUTF8File(sFilename as string)
    
    '/// copy the file TesttoolPath + base\level1\input\text_datasource\text_database.txt" to your local wotk directory
    printlog "copy the file TesttoolPath + base\level1\input\text_datasource\text_database.txt to your local wotk directory"
    app.FileCopy gTesttoolPath + ConvertPath("base\level1\input\text_datasource\text_database.txt"),gOfficePath + ConvertPath("user\work\text_database.txt")

    '/// open the text database create in the bas file
    call fOpendatabase(sFileName)
    
    '/// open the properties dialog of the open database
    printlog "open the properties dialog of the open database"
    Kontext "Insight"    
        Insight.UseMenu    
        hMenuSelectNr(2)
        hMenuSelectNr(14)
        hMenuSelectNr(1)

    '/// switch to the Text Tabpage
    printlog "switch to the Text Tabpage"
    Kontext "DatabaseProperties"        
        TabControl.setPage TabTextBase
   
    '/// set UTF-8 as character set
    printlog "set UTF-8 as character set"    
    Kontext "TabTextBase"
        dim iCount as integer
        dim i as integer
        iCount = CharSet.getItemCount()
        for i = 1 to iCount 
            CharSet.select(i)            
            if (Instr(CharSet.getSelText(),"(UTF-8)") <> 0 ) then
                i = iCount
            endif
        next

    '/// close the properties dialog with OK
    printlog "close the properties dialog with OK"    
    Kontext "DatabaseProperties"
        DatabaseProperties.OK
    
    '/// open the table text_database
    printlog "open the table text_database"    
    call fOpenTable("text_database")
    
    '/// check if the first row contains the string öäü
    printlog "check if the first row contains the string öäü"
    kontext "TableView"
        TableView.TypeKeys("<MOD1 C>",true)
        if ( getClipboard = "1,öäü") then
        	printlog "The table is load with an UTF-8 locale -> OK"
        else
        	warnlog "The table is not load ed with an UTF-8 locale -> FAILED"
		endif
    
    '/// close the table
    printlog "close the table"    
    call fCloseTableView
    
    '/// close the database
    printlog "close the database"
    call fCloseDatabase()

endcase
