'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: coption1.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/22 18:06:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Check Tools->Options->Spreadsheet->General
'*
'************************************************************************
'*
' #1 cOption1                        ' Initial Routine
' #1 tOptionsGeneral_save            ' Check all General Options and change them
' #1 tOptionsGeneral_reload          ' Check if changes persist after exit and restart the office
' #1 tOptionsGeneralRestore_settings ' Restore default settings
' #1 tOptionsGeneral_functionality   ' Test correct functionality of changes
'*
'\***********************************************************************

Global flag_MvSel as integer, curr_MvSel as integer, flag_Switch as integer, curr_Switch as integer, flag_Form as integer, curr_Form as integer
Global flag_ExpRef as integer, curr_ExpRef as integer, flag_High as integer, curr_High as integer
Global stat_Move as integer, curr_Move as integer, curr_PrinterMeasure as integer, flag_PrinterMeasure as integer
Global curr_Overwrite as integer, flag_Overwrite as integer
Global str_Move as string
Global curr_Tab as string, stat_Tab as string, solve_Tab as string
Global flag_Ref as integer, curr_Ref as integer

'*** Global variables for the functionality test
Global chg_enter as boolean, chg_switch as boolean, chg_expand as boolean, chg_Overwrite as boolean
Global cellLoc as string
Global chg_unit as boolean

sub cOption1

   printLog Chr(13) + "--------- cOption1 ---------"
   printlog "Tools|Options...|Spreadsheet|General"

   call tOptionsGeneral_save
   call tOptionsGeneral_reload
   call tOptionsGeneral_functionality
   call tOptionsGeneralRestore_settings

end sub

'*********************************************************************************************************

testcase tOptionsGeneral_save
'/// This test calls the "Tools|Options...|Spreadsheet|General" dialog and checks the default settings ///'
'/// If the default settings are not as expected the tester will be informed for each item ///'
'/// Then each parameter is changed and then the dialog is closed with OK ///'
'/// After a restart of the office it is checked if the changed settings are persistant ///'
'/// If the test runs in the enhanced modus (functionality test) ///'
'/// The following functionalities are tested: ///'
'/// - Press Enter to move selection ///'
'/// - Press Enter to switch to edit mode ///'
'/// - Expand fomatting ///'
'/// - Metrics ///'
'/// Finaly the current settings are restored. ///'

    Dim sTabulatorCurr as string
    
   ' Initialize the variables
   flag_MvSel = 0
   curr_MvSel = 0
   flag_Switch = 0
   curr_Switch = 0
   flag_Form = 0
   curr_Form = 0
   flag_Ref = 0
   curr_Ref = 0
   flag_ExpRef = 0
   curr_ExpRef = 0
   flag_High = 0
   curr_High = 0
   stat_Move = 4
   curr_Move = 1
   curr_PrinterMeasure = 1
   curr_Overwrite = 1
   chg_enter = false
   chg_switch = false
   chg_expand = false
   chg_Overwrite = false
   stat_Unit = 5
   more_Tab = 2
   solve_Tab = "35,3pt"
   chg_unit = false
  
   ' It is necessary to determine the systemlanguage for the default unit setting
   ' Test is only executed on English and German system locales
   printlog "Systemlanguage: " & iSystemSprache

    select case iSystemSprache
        case 49 :   curr_Unit = 2
                    curr_Tab = "1,25" 
                    solve_Tab = "35,5"
        case 01 :   curr_Unit = 3 
                    curr_Tab = "0.50"
                    solve_Tab = "36.0"
    end select
    
    Call hNewDocument
   ' Modify all parameters in this tabpage
   ToolsOptions
   hToolsOptions("SPREADSHEET", "GENERAL")

    ' Selection
    if Eingabebestaetigung.ischecked then
      curr_MvSel = 1
      if SelektionNach.isenabled then
         SelektionNach.Select stat_Move
      else
         warnlog "The listbox MoveSelection is disabled but it must be enabled"
      end if
      Eingabebestaetigung.uncheck
    else
      curr_MvSel = 0
      warnlog "The MoveSelection is not enabled by default"
      Eingabebestaetigung.check
      if SelektionNach.isenabled then
         SelektionNach.Select stat_Move
      else
         warnlog "The listbox MoveSelection is disabled but it must be enabled"
      end if
    end if
    flag_MvSel = Eingabebestaetigung.GetState

    ' Switch mode
    if Eingabetaste.ischecked then
      warnlog "Switch mode is by default enabled"
      curr_Switch = 1
      Eingabetaste.uncheck
    else
      curr_Switch = 0
      Eingabetaste.check
    end if
    flag_Switch = Eingabetaste.GetState

    ' Expand formatting
    if FormatierungAusdehnen.ischecked then
      warnlog "Expand formatting is enabled by default"
      curr_Form = 1
      FormatierungAusdehnen.uncheck
    else
      curr_Form = 0
      FormatierungAusdehnen.check
    end if
    flag_Form = FormatierungAusdehnen.GetState

    ' Expand references
    if Referenzenausdehnen.ischecked then
      warnlog "Expand references is enabled by default"
      curr_ExpRef = 1
      Referenzenausdehnen.uncheck
    else
      curr_ExpRef = 0
      Referenzenausdehnen.check
    end if
    flag_ExpRef = Referenzenausdehnen.GetState

    ' Highlight selection
    if SelektionHervorheben.ischecked then
      curr_High = 1
      SelektionHervorheben.uncheck
    else
      warnlog "Highlighing selection in Col/Rows isn't enabled by default"
      curr_High = 0
      SelektionHervorheben.check
    end if
    flag_High = SelektionHervorheben.GetState

    ' Metrics
    if Masseinheit.GetSelIndex <> curr_Unit then
      warnlog "The default Measurement Unit is not correct, it is  " & Masseinheit.GetSelText & " instead of " & curr_Unit
    end if

    sTabulatorCurr = Tabulator.GetText
    'Only use the numbers and the comma or dot and not the language dependent metric string    
    sTabulatorCurr = left(sTabulatorCurr,4)
    curr_Tab = left(curr_Tab, 4)
    if InStr(curr_Tab, sTabulatorCurr) = 0 then
      warnlog "The default Tab Stop isn't correct, it is '" & sTabulatorCurr & "' instead of '" & curr_Tab & "'"
    end if

    Masseinheit.Select stat_Unit
    if left(Tabulator.GetText, 3) <> left(solve_Tab, 3) then
      warnlog "The Tab Stop hasn't changed in depend of the Measurement Unit"
      warnlog "It is " & Tabulator.GetText & " instead of " & solve_Tab
    end if

    ' Printer Measure
    if Druckermasse.isChecked then
      curr_PrinterMeasure = 1
      Druckermasse.uncheck
      warnlog "PrinterMeasure is checked by default"
    else
      Druckermasse.check
      curr_PrinterMeasure = 0
    end if
    flag_PrinterMeasure = Druckermasse.getState

    ' Overwrite Warning
    if NOT Ueberschreibwarnung.isChecked then
      warnlog "Overwrite warning isn't checked by default"
      curr_Overwrite = 0
      Ueberschreibwarnung.check
    else
      Ueberschreibwarnung.uncheck
      curr_Overwrite = 1
    end if
    flag_Overwrite = Ueberschreibwarnung.getState

   ' Close the Options dialog with the made settings
   Kontext "OptionenDlg"
   OptionenDlg.OK
   sleep 5
   Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsGeneral_reload

    sleep 5
   'Restart the complete office
   ExitRestartTheOffice
    Call hNewDocument

   ' Check if settings are persistent
   ToolsOptions
   hToolsOptions("SPREADSHEET", "GENERAL")

    ' Selection
    if Eingabebestaetigung.GetState = flag_MvSel then
      printlog "OK, the change of <Move Selection> is persistent"
      chg_enter = true
   else
      warnlog "The change of <Move Selection> wasn't stored"
   end if

    ' Switch mode
    if Eingabetaste.GetState = flag_Switch then
      printlog "OK, the change of <Switch to EditMode> is persistent"
      chg_switch = true
    else
      warnlog "The change of <Switch to EditMode> wasn't stored"
    end if

    ' Expand formatting
    if FormatierungAusdehnen.GetState =  flag_Form then
      printlog "OK, the change of <Expand Formatting> is persistent"
      chg_expand = true
    else
      warnlog "The change of <Expand Formatting> wasn't stored"
    end if

    ' Expand references
    if Referenzenausdehnen.GetState = flag_ExpRef then
      printlog "OK, the change of <Expand References> is persistent"
    else
      warnlog "The change of <Expand References> wasn't stored"
    end if

    ' Highlight selection
    if SelektionHervorheben.GetState = flag_High then
      printlog "OK, the change of <Highlight Selection> is persistent"
    else
      warnlog "The change of <Highlight Selection> wasn't stored"
    end if

    ' to check the listbox Move Selection it is necessary to enable the checkbox Move Selection
    Eingabebestaetigung.check
    if SelektionNach.GetSelIndex = stat_Move then
      printlog "OK, the change of value in listbox <Move selection> is persistent"
   else
      warnlog "The change of value in listbox <Move selection> wasn't stored"
    end if

    ' Metrics
   if Masseinheit.GetSelIndex = stat_Unit then
      printlog "OK, the change of the <Measurement Unit> is persistent"
      chg_unit = true
   else
      warnlog "The change of the <Measurement Unit> wasn't stored"
   end if

   ' PrinterMeasure
   if Druckermasse.GetState = flag_PrinterMeasure then
      printlog "OK, the change of the <PrinterMeasure> is persistent"
   else
      warnlog "The change of the <PrinterMeasure> wasn't stored"
   end if

   ' Overwrite Warning
   if Ueberschreibwarnung.GetState = flag_Overwrite then
      printlog "OK, the change of <Overwrite> is persistent"
      chg_Overwrite = true
   else
      warnlog "The change of <Overwrite> wasn't stored"
   end if

    ' Close the Options dialog with the changed settings
   Kontext "OptionenDlg"
      OptionenDlg.Cancel

      Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsGeneralRestore_settings

   Call hNewDocument

    ' restore the default settings
   ToolsOptions
   hToolsOptions("SPREADSHEET", "GENERAL")

    ' Selection
    if curr_MvSel = 1 then
      Eingabebestaetigung.check
      SelektionNach.Select curr_Move
    else
      Eingabebestaetigung.uncheck
    end if

    ' Switch mode
    if curr_Switch = 1 then
      Eingabetaste.check
    else
      Eingabetaste.uncheck
    end if

    ' Expand formatting
    if curr_Form = 1 then
      FormatierungAusdehnen.check
    else
      FormatierungAusdehnen.uncheck
   end if

    ' Expand references
    if curr_ExpRef = 1 then
         Referenzenausdehnen.check
      else
         Referenzenausdehnen.uncheck
      end if

    ' Highlight selection
    if curr_High = 1 then
      SelektionHervorheben.check
    else
      SelektionHervorheben.uncheck
    end if

    ' Measurement units
   Masseinheit.select curr_Unit

   ' Tab stops
   Tabulator.SetText curr_Tab

   'PrinterMeasure
   if curr_PrinterMeasure = 1 then
      Druckermasse.check
   else
      Druckermasse.uncheck
   end if

   ' Overwrite Warning
   if curr_Overwrite = 1 then
      Ueberschreibwarnung.check
   else
      Ueberschreibwarnung.uncheck
   end if

    Kontext "OptionenDlg"
      OptionenDlg.OK

      Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsGeneral_functionality

   Call hNewDocument

   ' Check the made settings on their functionality

   ' Selection
   if chg_enter then
      printlog "Check 'Press Enter to move selection'"
      ' check if the box 'Press Enter to move selection' is activated
      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "<Mod1 Home>Current<right>"
      DocumentCalc.TypeKeys "Next<return>"
      if flag_MvSel = 1 then
         call mvselect()
         ' if the option 'Press Enter to move selection' is checked, it must be now disabled
         printlog "If the option 'Press Enter to move selection' is checked, it must be now disabled"
         ToolsOptions
         hToolsOptions("SPREADSHEET", "GENERAL")
         Eingabebestaetigung.uncheck
         Kontext "OptionenDlg"
            OptionenDlg.OK
            call hCloseDocument
            ' now check this option
            printlog "Now check this option"
            call hNewDocument
            Kontext "DocumentCalc"
         DocumentCalc.TypeKeys "<Mod1 Home>Current<right>"
         DocumentCalc.TypeKeys "Next<return>"
         call stselect()
         ' now it is time to restore the old state
         printlog "It is time to restore the old state"
         ToolsOptions
            ToPosInOptionlist ( 5 )
         Kontext "OptionenDlg"
         Optionsliste.TypeKeys "<Down>"
         Kontext "TabLayoutCalc"
         Eingabebestaetigung.check
         Kontext "OptionenDlg"
            OptionenDlg.OK
      else
         call stselect()
         ' if the option 'Press Enter to move selection' isn't checked, it must be now
         printlog "If the option 'Press Enter to move selection' isn't checked, it must be now"
         ToolsOptions
         hToolsOptions("SPREADSHEET", "GENERAL")
         Eingabebestaetigung.check
         Kontext "OptionenDlg"
            OptionenDlg.OK
            call hCloseDocument
            ' now check this option
            printlog "Now check this option"
            call hNewDocument
         Kontext "DocumentCalc"
         DocumentCalc.TypeKeys "<Mod1 Home>Current<right>"
         DocumentCalc.TypeKeys "Next<return>"
         call mvselect()
         ' now it is time to restore the old state
         printlog "It is time to restore the old state"
         ToolsOptions
            ToPosInOptionlist ( 5 )
         Kontext "OptionenDlg"
         Optionsliste.TypeKeys "<Down>"
         Kontext "TabLayoutCalc"
         Eingabebestaetigung.uncheck
         Kontext "OptionenDlg"
            OptionenDlg.OK
       end if
   else
      warnlog "Due to the change of settings wasn't applied, this test case failed"
   end if

   call hCloseDocument
   call hNewDocument

   ' Switch mode
   if chg_switch then
      ' check if the box 'Press Enter to switch to edit mode' is activated
      printlog "Check 'Press Enter to switch to edit mode'"
      if flag_Switch = 1 then
         call contextmenuopen()
      else
         ' if the switch mode isn't enabled, change in
         printlog "If the switch mode isn't enabled, change it"
         ToolsOptions
         hToolsOptions("SPREADSHEET", "GENERAL")
         Eingabetaste.check
         Kontext "OptionenDlg"
            OptionenDlg.OK
            call hCloseDocument
            ' now we check the enabled switch mode
            call hNewDocument
            call contextmenuopen()
         end if
    else
         warnlog "Due to the change of settings wasn't applied, this test case failed"
    end if

   call hCloseDocument
   call hNewDocument

   ' Expand formatting
   if chg_expand then
   printlog "Check 'Expand formatting'"
   ' check if the box 'Expand formatting' is activated
      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "<Mod1 Home><right><right><down><down>"
      FormatCells
      Kontext
      Active.SetPage TabFont
      Kontext "TabFont"
      if gAsianSup then
        '/// Choose Fonttype BOLD 
         StyleWest.Select(3)
      else
         Style.Select 3
      end if
      TabFont.OK

      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "Bold"
      DocumentCalc.TypeKeys "<down>"
      DocumentCalc.TypeKeys "Bold<left>"
      DocumentCalc.TypeKeys "Bold<up>"
      DocumentCalc.TypeKeys "Bold<up>"
      DocumentCalc.TypeKeys "Bold<right>"
      DocumentCalc.TypeKeys "Bold<right>"
      DocumentCalc.TypeKeys "Bold<down>"
      DocumentCalc.TypeKeys "Bold<down>"
      DocumentCalc.TypeKeys "Bold<down>"
        DocumentCalc.TypeKeys "<down>"
        DocumentCalc.TypeKeys "bold<down>"

        DocumentCalc.TypeKeys "<left><up><up><up>"
        call formatFont(3, "BOLD")
        sleep 5
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<left>"
        call formatFont(3, "BOLD")
        sleep 5
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<up>"
        call formatFont(3, "BOLD")
        sleep 5
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<up>"
        call formatFont(3, "BOLD")
        sleep 5
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<right>"
        call formatFont(3, "BOLD")
        sleep 5
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<right>"
        call formatFont(3, "BOLD")
        sleep 5
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<down>"
        call formatFont(3, "BOLD")
        sleep 5
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<down>"
        call formatFont(3, "BOLD")
        sleep 5
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<down>", 2
        call formatFont(1, "STANDARD")
    else
      warnlog "Due to the change of settings wasn't applied, this test case failed"
    end if

   call hCloseDocument

   ' Metrics
   Dim str_search as string
   Call hNewDocument

   ' Check functionality of changed settings
   if chg_unit then
      FormatRowHeightCalc
      Kontext "Zeilenhoehe"
      str_search = right(Hoehe.GetText, 2)
      if str_search = "pt" then
         printlog "OK, the change of the measurement unit to pt works"
      else
         if iSprache = 81 AND str_search = "ント" then
            printlog "OK, the change of the measurement unit to ントin Japanese works"
         else
             warnlog "The unit of the measurement is " & right(Hoehe.GetText, 2) & " instead of 'pt'"
         end if
      end if
      Zeilenhoehe.close
   end if

   call hCloseDocument

   ' Overwrite Warning
   printlog "Check 'Overwrite Warning"
   call hNewDocument
   Dim stateOverwrite as integer
   if chg_Overwrite then
      ToolsOptions
      sleep 5
      hToolsOptions("SPREADSHEET", "GENERAL")
      ' Check if the overwrite warning is active
      stateOverwrite = Ueberschreibwarnung.getState
      ' Enable the Selection
      Eingabebestaetigung.check
      SelektionNach.Select 1
      Kontext "OptionenDlg"
      OptionenDlg.OK
      sleep 5
      if stateOverwrite = 1 then
         Kontext "DocumentCalc"
         DocumentCalc.TypeKeys "<MOD1 HOME>"
         DocumentCalc.TypeKeys "Content<RETURN>AnotherContent<RETURN><UP><UP>"
         DocumentCalc.TypeKeys "<MOD1 C>"
         DocumentCalc.TypeKeys "<DOWN>"
         DocumentCalc.TypeKeys "<MOD1 V>"
         Kontext "Active"
         if Active.exists then
            printlog "OK the Overwrite Warning appears"
            Active.YES
            if cZellwert("A2") = "Content" then
               printlog "OK, the content has been inserted correctly"
            else
               warnlog "Content from 'A1' wasn't pasted in 'A2'"
            end if
         else
            warnlog "Although the overwrite warning is active no warning appears while the old content is replaced"
         end if
      else
         ' if the overwrite warning is disabled check that the warning doesn't appear when overwrite a cells content
         Kontext "DocumentCalc"
         DocumentCalc.TypeKeys "<MOD1 HOME>"
         DocumentCalc.TypeKeys "Content"
         DocumentCalc.TypeKeys "<RETURN>"
         DocumentCalc.TypeKeys "Another"
         DocumentCalc.TypeKeys "<RETURN><UP><UP>"
         DocumentCalc.TypeKeys "<MOD1 C>"
         DocumentCalc.TypeKeys "<DOWN>"
         DocumentCalc.TypeKeys "<MOD1 V>"
         Kontext "Active"
         if Active.exists then
            warnlog "Altough the overwrite warning is disabled the warning appears"
            Active.YES
         else
            if cZellwert("A2") = "Content" then
               printlog "OK, the content from 'A1' has been copied to 'A2'"
            else
               warnlog "Copying the content from 'A1' to 'A2' failed"
            end if
         end if
      end if
   end if

   sleep 5

   call hCloseDocument

endcase
