'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: un_redo6.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/15 13:51:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description	:	Complete Test for the undo/redo function which test
'*
'************************************************************************
'*
' #1 un_redo6       ' Initial routine
' #1 tData_Validity ' Data validity - Undo/Redo - Check correct settings
'*
'\***********************************************************************

sub un_redo6

Printlog Chr(13) + "--------- Data_Validity ---------"

        call tData_Validity

end sub

'**************************************************************************************************

testcase  tData_Validity

'/// Call a new calc document, call menuitem 'DataValidity', goto tabpage 'Criteria'
'/// and select nr 2 from allowlist
        call hNewDocument
        Printlog ""
        Printlog "* DataValidity TabPage Values"
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        Zulassen.Select 2
        TabWerte.OK

'/// check if the modify has been taken over
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        if Zulassen.GetSelIndex = 2 then
                printlog "OK, the AllowListBox has been modified"
        else
                warnlog "The AllowListBox hasn't been modified"
        end if
   Kontext
   TabWerte.Cancel

'/// check if the undo-function works
   EditUndo
   DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        if Zulassen.GetSelIndex = 1 then
                printlog "OK, the AllowListBox has been reset to current"
        else
                warnlog "The AllowListBox hasn't beenreset to current"
        end if
   Kontext
   TabWerte.Cancel

'/// check if the redo-function works
   EditRedo
   DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        if Zulassen.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
   Kontext
   TabWerte.Cancel
   EditUndo
   '_________________________________________________________________________________________________

'/// Call menuitem 'DataValidity', goto tabpage 'Criteria', select nr 2 from
'/// allowlist and check allowblanks
        dim state_int, state_current as integer
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        Zulassen.Select 2
        state_current = LeerzellenZulassen.GetState
        printlog "status:" & LeerzellenZulassen.GetState & "!"
   LeerzellenZulassen.Click
   state_int = LeerzellenZulassen.GetState
   if state_current = state_int then
        warnlog "The TriStateBox AllowBlanks couldn't be toggelt, it could be a bug"
   end if
   Kontext
   TabWerte.OK

'/// check if the modify has been taken over
   DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        if Zulassen.GetSelIndex = 2 and state_int <> state_current then
                printlog "OK, the TriStateBox AllowBlanks has been toggelt"
        else
                warnlog "The TriStateBox AllowBlanks hasn't been toggelt"
        end if
        Kontext
        TabWerte.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        if Zulassen.GetSelIndex = 1 then
                printlog "OK, the ListBox Allow has been reset to current"
        else
                warnlog "The ListBox Allow hasn't been reset to current"
        end if
        Kontext
        TabWerte.Cancel

'/// check if the redo-function works
        EditRedo
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        if Zulassen.GetSelIndex = 2 and state_int <> state_current then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabWerte.Cancel
        EditRepeat

        '_________________________________________________________________________________________________

'/// Call menuitem 'DataValidity', select nr 2 from allowlist and select nr 3 from
'/// datalist
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        Zulassen.Select 2
        Daten.Select 3
        TabWerte.OK

'/// check if the modify has been taken over
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        if Daten.GetSelIndex = 3 then
                printlog "OK, the ListBox Values has been modified"
        else
                warnlog "The ListBox Values hasn't been modified"
        end if
        Kontext
        TabWerte.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        if Daten.GetSelIndex = 1 then
                printlog "OK, the ListBox Values has been reset to current"
        else
                warnlog "The ListBox Values hasn't been reset to current"
        end if
        Kontext
        TabWerte.Cancel

'/// check if the redo-function works
        EditRedo
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        if Daten.GetSelIndex = 3 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabWerte.Cancel
        EditRepeat
        '_________________________________________________________________________________________________

'/// Call menuitem 'DataValidity', goto tabpage 'Criteria' select nr 2 from allowlist
'/// and set a text in TextField value
        dim value_current as string
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        Zulassen.Select 2
        value_current = Wert.GetText
        Wert.SetText "100"
        Kontext
        TabWerte.OK

'/// check if the modify has been taken over
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        If Wert.GetText = "100" then
                printlog "OK, the value in the EditField has been modified"
        else
                warnlog " The  value in the EditField hasn't been modified"
        end if
        Kontext
        TabWerte.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        If Wert.GetText = value_current then
                printlog "OK, the value in the EditField has been reset to current"
        else
                warnlog " The  value in the EditField hasn't been reset to current"
        end if
        Kontext
        TabWerte.Cancel

'/// check if the redo-function works
        EditRedo
        DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        If Wert.GetText = "100" then
                printlog "OK, redo works"
        else
                warnlog " The redo-function doesn't work"
        end if
        Kontext
        TabWerte.Cancel
   EditUndo

   call hCloseDocument
        '_________________________________________________________________________________________________

   call hNewDocument

'/// Call menuitem 'DataValidity', goto tabpage 'InputHelp' and check ShowInputHelp
   Printlog ""
        Printlog "* DataValidity TabPage InputHelp"
        DataValidity
        Kontext
        active.setpage TabEingabehilfe
        Kontext "TabEingabehilfe"
        dim help_int, help_current as integer
        help_current = EingabehilfenbeiSelektion.GetState
        printlog "status:" & EingabehilfenbeiSelektion.GetState & "!"
   EingabehilfenbeiSelektion.Click
   printlog "status after click:" & EingabehilfenbeiSelektion.GetState & "!"
   help_int = EingabehilfenbeiSelektion.GetState
   if help_current = help_int then
        warnlog "The TriStateBox InputHelp couldn't be toggelt, it could be a bug"
   end if
   Kontext
   TabEingabeHilfe.OK

'/// check if the modify has been taken over
   DataValidity
        Kontext
        active.setpage TabEingabeHilfe
        Kontext "TabEingabeHilfe"
        if EingabehilfenbeiSelektion.GetState <> help_current then
                printlog "OK, the TriStateBox InputHelp has been toggelt"
        else
                warnlog "The TriStateBox InputHelp hasn't been toggelt"
        end if
        Kontext
        TabEingabeHilfe.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabEingabeHilfe
        Kontext "TabEingabeHilfe"
        printlog "status after undo:" & EingabehilfenbeiSelektion.GetState & "!"
        if EingabehilfenbeiSelektion.GetState = help_current  then
                printlog "OK, the TriStateBox InputHelp has been reset to current"
        else
                warnlog "The TriStateBox InputHelp hasn't been reset to current"
        end if
        Kontext
        TabEingabeHilfe.Cancel

'/// check if the redo-function works
        EditRedo
        DataValidity
        Kontext
        active.setpage TabEingabeHilfe
        Kontext "TabEingabeHilfe"
        printlog "status after redo:" & EingabehilfenbeiSelektion.GetState & "!"
        if EingabehilfenbeiSelektion.GetState <> help_current then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabEingabeHilfe.Cancel
        EditRepeat

        '_________________________________________________________________________________________________

'/// Call menuitem 'DataValidity', goto tabpage 'InputHelp', check ShowInputHelp and
'/// set a text in TextField Title
   DataValidity
        Kontext
        active.setpage TabEingabehilfe
        Kontext "TabEingabehilfe"
        EingabehilfenbeiSelektion.Check
        Titel.SetText "example"
        Kontext
        TabEingabehilfe.OK

'/// check if the modify has been taken over
        DataValidity
        Kontext
        active.setpage TabEingabehilfe
        Kontext "TabEingabehilfe"
        if Titel.GetText = "example" then
                printlog "OK, the modify of the textfield has been taken over"
        else
                warnlog "The modify of the textfield hasn't been taken over"
        end if
        Kontext
        TabEingabehilfe.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabEingabehilfe
        Kontext "TabEingabehilfe"
        if Titel.GetText = "" then
                printlog "OK, the textfieldcontent has been reset to current"
        else
                warnlog "The textfieldcontent hasn't been reset to current"
        end if
        Kontext
        TabEingabehilfe.Cancel

'/// check if the redo-function works
        EditRedo
        DataValidity
        Kontext
        active.setpage TabEingabehilfe
        Kontext "TabEingabehilfe"
        Kontext "TabEingabehilfe"
        if Titel.GetText = "example" then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabEingabehilfe.Cancel
        EditRepeat
   '_________________________________________________________________________________________________

'/// Call menuitem 'DataValidity', goto tabpage 'InputHelp', check ShowInputHelp and
'/// set a text in TextField InputHelp
        DataValidity
        Kontext
        active.setpage TabEingabehilfe
        Kontext "TabEingabehilfe"
        EingabehilfenbeiSelektion.Check
        Eingabehilfe.SetText "testtext"
        Kontext
        TabEingabehilfe.OK

'/// check if the modify has been taken over
        DataValidity
        Kontext
        active.setpage TabEingabehilfe
        Kontext "TabEingabehilfe"
        if Eingabehilfe.GetText = "testtext" then
                printlog "OK, the modify of the EditField has been taken over"
        else
                warnlog "The modfy of the EditField hasn't been taken over"
        end if
        Kontext
        TabEingabehilfe.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabEingabehilfe
        Kontext "TabEingabehilfe"
        if Eingabehilfe.GetText = "" then
                printlog "OK, the EditField content has been reset to current"
        else
                warnlog "The EditField content hasn't been reset to current"
        end if
        Kontext
        TabEingabehilfe.Cancel

'/// check if the redo-function works
        EditRedo
        DataValidity
        Kontext
        active.setpage TabEingabehilfe
        Kontext "TabEingabehilfe"
        if Eingabehilfe.GetText = "testtext" then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabEingabehilfe.Cancel
   EditUndo
   call hCloseDocument
   '_________________________________________________________________________________________________

   call hNewDocument
   Printlog ""
        Printlog "* DataValidity TabPage Error Alert"
   dim error_current, error_bool as boolean
   error_current = false
   error_bool = false
   ' at first it is necessary to create a condition for input
'Call menuitem 'DataValidity', goto tabpage 'Criteria' and select nr 2 from allowlist
   DataValidity
        Kontext
        active.setpage TabWerte
        Kontext "TabWerte"
        Zulassen.Select 2
        Wert.SetText "10"
        Kontext
        TabWerte.OK

'/// now the maintest can start
'/// Call menuitem 'DataValidity', goto tabpage 'ErrorAlert' and toggle ShowErrorMessage
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if FehlermeldungbeiEingabe.IsChecked then
                FehlermeldungbeiEingabe.Uncheck
                error_bool = false
        else
                FehlermeldungbeiEingabe.Check
                error_bool = true
        end if
        error_current = error_bool
        Kontext
        TabFehlermeldung.OK

'/// check if the modify has been taken over
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if FehlermeldungbeiEingabe.IsChecked then
                error_bool = true
        else
                error_bool = false
        end if
        if error_current = error_bool then
                printlog "OK, the state of the checkbox errormessage has been modified"
        else
                warnlog "The modify of the checkbox errormessage hasn't been modified"
        end if
        Kontext
        TabFehlermeldung.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if FehlermeldungbeiEingabe.IsChecked then
                error_bool = true
        else
                error_bool = false
        end if
        if error_current <> error_bool then
                printlog "OK, the state of the checkbox errormessage has been reset to current"
        else
                warnlog "The modify of the checkbox errormessage hasn't been reset to current"
        end if
        Kontext
        TabFehlermeldung.Cancel

'/// check if the redo-function works
        EditRedo
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if FehlermeldungbeiEingabe.IsChecked then
                error_bool = true
        else
                error_bool = false
        end if
        if error_current = error_bool then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabFehlermeldung.Cancel
   '_________________________________________________________________________________________________

        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        Aktion.Select 2
        Kontext
        TabFehlermeldung.OK

'/// check if the modify has been taken over
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if Aktion.GetSelIndex = 2 then
                printlog "OK, the listbox Action has been modified"
        else
                warnlog "The listbox Action hasn't been modified"
        end if
        Kontext
        TabFehlermeldung.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if Aktion.GetSelIndex = 1 then
                printlog "OK, the listbox Action has been reset to current"
        else
                warnlog "The listbox Action hasn't been reset to current"
        end if
        Kontext
        TabFehlermeldung.Cancel

'/// check if the redo-function works
   EditRedo
   DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if Aktion.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabFehlermeldung.Cancel
        '_________________________________________________________________________________________________

'/// Call menuitem 'DataValidity', goto tabpage 'ErrorAlert' and set a tect for TextField
'/// Title
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        Titel.SetText "Warning message"
        Kontext
        TabFehlermeldung.OK

'/// check if the modify has been taken over
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if Titel.GetText = "Warning message" then
                printlog "OK, the text of the errortitle has been set"
        else
                warnlog "The text of the errortitle hasn't been set"
        end if
        Kontext
        TabFehlermeldung.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if Titel.GetText = "" then
                printlog "OK, the text of the errortitle has been reset to current"
        else
                warnlog "The text of the errortitle hasn't been reset to current"
        end if
        Kontext
        TabFehlermeldung.Cancel

'/// check if the redo-function works
        EditRedo
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if Titel.GetText = "Warning message" then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabFehlermeldung.Cancel
        EditRepeat
        '_________________________________________________________________________________________________

'/// Call menuitem 'DataValidity', goto tabpage 'ErrorAlert' and set a text in TextField
'/// ErrorMessage
   DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        Fehlermeldung.SetText "example message"
        Kontext
        TabFehlermeldung.OK

'/// check if the modify has been taken over
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if Fehlermeldung.GetText = "example message" then
                printlog "OK, the text of the errormessage has been set"
        else
                warnlog "The text of the errormessage hasn't been set"
        end if
        Kontext
        TabFehlermeldung.Cancel

'/// check if the undo-function works
        EditUndo
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if Fehlermeldung.GetText = "" then
                printlog "OK, the text of the errormessage has been reset to current"
        else
                warnlog "The text of the errormessage hasn't been reset to current"
        end if
        Kontext
        TabFehlermeldung.Cancel

'/// check if the redo-function works
        EditRedo
        DataValidity
        Kontext
        active.setpage TabFehlermeldung
        Kontext "TabFehlermeldung"
        if Fehlermeldung.GetText = "example message" then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        Kontext
        TabFehlermeldung.Cancel
        EditRepeat
        '_________________________________________________________________________________________________

        call hCloseDocument

endcase
