'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_003_.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: jsi $ $Date: 2006/05/29 14:15:01 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Check all resources for menuitem View
'*
'*************************************************************************************************
'*
' #1 C_003_ ' Initial routine
' #1 tViewNormal
' #1 tViewPageBreakPreview
' #1 tViewToolbars
' #1 tViewToolbarsCustomize
' #1 tViewFormulaBar
' #1 tViewStatusBar
' #1 tViewColumnAndRowHeaders
' #1 tViewValueHighlighting
' #1 tViewDataSources
' #1 tViewFullScreen
' #1 tViewZoom
'*
'\************************************************************************************************

sub C_003_

Printlog "--------- C_003_ ---------"

    call ExitRestartTheOffice
    call tViewNormal
    call tViewPageBreakPreview
    Call tViewToolbars
    Call tViewToolbarsCustomize
    Call tViewFormulaBar
    Call tViewStatusBar
    Call tViewColumnAndRowHeaders
    Call tViewValueHighlighting
    call tViewDataSources
    Call tViewFullScreen
    Call tViewZoom

end sub
'
'-----------------------------------------------------------
'
testcase tViewNormal
'///<u><b>View::Normal AND View::Page Break Preview</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call hNewDocument
    '///<li>Invoke slot 'View::Page Break Preview'</li>///
    ViewPageBreakPreview
    '///<li>Invoke slot 'View::Normal'</li>///
    ViewNormalView
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>

endcase

'
'-----------------------------------------------------------
'
testcase tViewPageBreakPreview
'///<u><b>View::Page Break Preview</b></u>///
'///<b>Tested as 'side effect' in 'tViewNormal'</b>///

    printlog "This slot has already been tested in previous testcase 'tViewNormal'"

endcase
'
'-----------------------------------------------------------
'
testcase tViewToolbars
'///<u><b>View::Toolbars::*</b></u>///
'///<ul>

    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Show and Hide for all available toolbars in sub-menu</li>///
    '///<li>View::Toolbars::3D-Settings</li>///
    ViewToolbarsThreeDSettings
    ViewToolbarsThreeDSettings
    '///<li>View::Toolbars::Align</li>///
    ViewToolbarsAlign
    ViewToolbarsAlign
    '///<li>View::Toolbars::BasicShapes</li>///
    ViewToolbarsBasicShapes
    ViewToolbarsBasicShapes
    '///<li>View::Toolbars::Controls</li>///
    ViewToolbarsFormControls
    ViewToolbarsFormControls
    '///<li>View::Toolbars::Drawing</li>///
    ViewToolbarsDrawing
    ViewToolbarsDrawing
    '///<li>View::Toolbars::Fontwork</li>///
    ViewToolbarsFontwork
    ViewToolbarsFontwork
    '///<li>View::Toolbars::Form Design</li>///
    ViewToolbarsFormDesign
    ViewToolbarsFormDesign
    '///<li>View::Toolbars::Form Object</li>///
    ViewToolbarsFormObject
    ViewToolbarsFormObject
    '///<li>View::Toolbars::Formatting</li>///
    ViewToolbarsFormatting
    ViewToolbarsFormatting
    '///<li>View::Toolbars::Insert</li>///
    ViewToolbarsInsert
    ViewToolbarsInsert
    '///<li>View::Toolbars::Insert Cell</li>///
    ViewToolbarsInsertCell
    ViewToolbarsInsertCell
    '///<li>View::Toolbars::Insert Object</li>///
    ViewToolbarsInsertObject
    ViewToolbarsInsertObject
    '///<li>View::Toolbars::Media Playback</li>///
    ViewToolbarsMediaPlayback
    ViewToolbarsMediaPlayback
    '///<li>View::Toolbars::Picture</li>///
    ViewToolbarsPicture
    ViewToolbarsPicture
    '///<li>View::Toolbars::Standard</li>///
    ViewToolbarsStandard
    ViewToolbarsStandard
    '///<li>View::Toolbars::Text Formatting</li>///
    ViewToolbarsTextFormatting
    ViewToolbarsTextFormatting    
    '///<li>View::Toolbars::Tools</li>///
    ViewToolbarsTools
    ViewToolbarsTools
    '///<li>View::Toolbars::Hyperlink bar</li>///
    ViewToolbarsInsertHyperlink
    ViewToolbarsInsertHyperlink
    '///<li>View::Toolbars::Formula Bar</li>///
    ViewToolbarsFormulaBar
    ViewToolbarsFormulaBar
    
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tViewFormulaBar
'///<u><b>View::Formula Bar</b></u>///
'///<ul>

    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Invoke 'View::Formula Bar' twice to toggle both states</li>///
    ViewToolbarsFormulaBar
    ViewToolbarsFormulaBar
    
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tViewToolbarsCustomize
'///<u><b>View::Toolbars::Customize</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Invoke View::Toolbars::Customize</li>///
    ViewToolbarsCustomize
    '///<li>Tabpages are Tab pages are tested in-depth in testcase 'tToolsCustomize'</li>///
    printlog "Tab pages are tested in-depth in testcase 'tToolsCustomize'"
    Kontext
    Messagebox.SetPage TabCustomizeToolbars
    '///<li>Check existence of dialog</li>///
    Call DialogTest ( TabCustomizeToolbars )
    '///<li>Leave dialog without in-depth tests (see above)</li>///
    TabCustomizeToolbars.cancel
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tViewStatusBar
'///<u><b>View::Status Bar</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Invoke 'View::Status Bar' twice to toggle off/on</li>///
    ViewToolbarsStatusbar
    ViewToolbarsStatusbar
    
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tViewColumnAndRowHeaders
'///<u><b>View::Column & Row Headers</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    
    '///<li>Invoke 'View::Column & Row Headers' twice to toggle off/on</li>///
    ViewColumnAndRowHeaders
    ViewColumnAndRowHeaders
    
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tViewValueHighlighting
'///<u><b>View::Value Highlighting</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument

    '///<li>Invoke 'View::Value Highlighting' twice to toggle off/on</li>///
    ViewValueHightlighting
    ViewValueHightlighting
    
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tViewDataSources
'///<u><b>View::Data Sources</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument

    '///<li>Invoke 'View::Data Sources' twice to toggle off/on</li>///
    ViewDataSources
    ViewDataSources
    
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tViewFullScreen
'///<u><b>View::Full Screen</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument

    '///<li>Invoke 'View::Full Screen' twice to toggle off/on</li>///
    kontext
    DocumentCalc.typekeys "13<RETURN>"
    ViewFullScreen
    kontext
    DocumentCalc.typekeys "13<RETURN>"
    ViewFullScreen
    
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tViewZoom
'///<u><b>View::Zoom</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument

    '///<li>Invoke View::Zoom</li>///
    ViewZoom
    Kontext "Massstab"
    '///<li>Check if zoom dialog is visible</li>///
    DialogTest ( Massstab )
    '///<li>Close zoom  dialog</li>///
    Massstab.Close

    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase

