'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_spectemplate.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2006/05/16 13:19:46 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Load the spec template via http and enable macros
'*
'*******************************************************************************
'**
' #1 tBasicSpecTemplate ' Load the spec template via http and enable macros
'**
'\******************************************************************************

testcase tBasicSpecTemplate

    '///<h1>Load the spec template via http and enable macros</h1>
    '///<i>Required: Macro Security Level must be Default (Medium)</i>
    '///<ul>
    
    const cFile = "http://specs.openoffice.org/collaterals/template/" & _
                  "OpenOffice-org-Specification-Template.ott"
    
    '///+<li>Set HTTP-Proxy to access a website outside SWAN (not for OOo)</li>
    printlog( "Init: Set proxy (SWAN only)" )
    if ( not gOOo ) then
        hSetProxies( "so-webcache.germany.sun.com", "3128", "", "", "" )
    endif
    
    '///+<li>File open</li>
    printlog( "FileOpen" )
    FileOpen
    
    '///+<li>Enter the path/filename of the specification template</li>
    printlog( "Set Filename: " & cFile )
    Kontext "OeffnenDlg"
    DateiName.setText( cFile )
    
    '///+<li>Click the Open-button</li>
    printlog( "Open" )
    Oeffnen.click()
    sleep( 10 ) ' allow some time to load
    
    '///+<li>Handle security warning (allow execution of macros)</li>
    printlog( "Accept to execute macros" )
    hHandleSecurityWarning()
    
    '///+<li>Wait until the document is loaded</li>
    sleep( 5 )
    
    '///+<li>Close the document</li>
    printlog( "Cleanup: Close the document" )
    hDestroyDocument()
    
    '///+<li>Reset proxies (delete all proxies, if changed)</li>
    printlog( "Cleanup: Delete proxy settings (if changed)" )
    if ( not gOOo ) then
        hSetProxies( "", "", "", "", "" )
    endif
    '///</ul>

endcase

