'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_fonts.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2006/06/20 13:31:45 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.co
'*
'*  short description : Test the fonts shipped with StarOffice
'*
'*******************************************************************************
'**
' #1 tCheck_Installed_Fonts ' Use the fonts shipped with StarOffice
'**
'\******************************************************************************

testcase tCheck_Installed_Fonts

    '///<h1>Check if all StarOffice fonts are installed</h1>
    '///<i>The fonts are :</i>
    '///<ul>
    '///<li>Albany ( Bold / BoldItalic / Italic )</li>
    '///<li>Andale Sans ( Bold / BoldItalic / Italic / Regular / UI )</li>
    '///<li>Arial ( Black / Narrow / Narrow Bold / Narrow BoldItalic / Italic )</li>
    '///<li>Broadway</li>
    '///<li>Cumberland ( Bold / BoldItalic / Italic )</li>
    '///<li>Garamond ( Bold / BoldItalic / Italic )</li>
    '///<li>Impact MT Shadow ( Italic )</li>
    '///<li>Kidprint ( Bold )</li>
    '///<li>Palace Script ( MT / Semibold )</li>
    '///<li>Sheffield ( Bold / Italic )</li>
    '///<li>StarSymbol</li>
    '///<li>Thorndale ( Bold / BoldItalic / Italic )</li>
    '///</ul>
    dim iCurrentFont as integer
    dim iSpecialChar as integer 
    dim iFontCount as integer
    dim iRandomNumber as integer
    dim cFile as string
    dim cFont as string
    
    printlog( "- Check all fonts that are installed by StarOffice" )
    gApplication = "WRITER"
    Call hNewDocument()

    ' close the stylist if it is open, it's in the way
    kontext "stylist"
    if ( Stylist.Exists() ) then
        Stylist.Close()
    endif
    
    '///<i>open "Insert\Special Character" in Writer and insert for each font some characters</i><br>
    InsertSpecialCharacterWriter

    ' get the number of fonts registered in the special characters dialog
    kontext "sonderzeichen"
    iFontCount = Schrift.GetItemCount()

    ' Override the iFontCount for some platforms
    select case gPlatGroup
    case "w95" :  iFontCount = 16
    case "unx" :  iFontCount = 14
    end select

    ' step through the installed fonts, pick some random chars and write them
    ' into a writer document
    for iCurrentFont = 1 to iFontCount

        select case iCurrentFont
        case 1  : cFont = "Albany"
        case 2  : cFont = "Andale Sans"
        case 3  : cFont = "Andale Sans UI"
        case 4  : cFont = "Arial Black"
        case 5  : cFont = "Arial Narrow"
        case 6  : cFont = "Broadway"
        case 7  : cFont = "Cumberland"
        case 8  : cFont = "Garamond"
        case 9  : cFont = "Imprint MT Shadow"
        case 10 : cFont = "Kidprint"
        case 11 : cFont = "Palace Script"
        case 12 : cFont = "Sheffield"
        case 13 : cFont = "StarSymbol"
        case 14 : cFont = "Thorndale"
        case 15 : cFont = "Arial"
        case 16 : cFont = "Palace Script MT"
        end select

        ' Workaround for missing andale sans ui in korean installations
        ' there are other fonts instead TODO: Create fontlists per locale

        if( ( iCurrentFont = 3 ) AND ( iSprache = 82 ) ) then
            printlog( "Font Andale Sans UI is missing in Korean office" )
        elseif ( ( iCurrentFont = 3 ) AND ( gtSysName = "WinXP" ) ) then
            Warnlog( "#i65714# Skipping Andale Sans UI on Windows/patch" )
        else

            try
                printlog( "    select " & cFont & " and insert 10 characters!" )
                Schrift.Select( cFont )
                SchriftListe.TypeKeys( "<PageUp>", 8 )

                ' pick 10 special chars at random (DOESN'T RND HAVE TO BE INITIALIZED?)
                for iSpecialChar = 1 to 10
                
                    iRandomNumber = Int( ( 12 * Rnd ) + 1 )
                    SchriftListe.TypeKeys( "<Right>", iRandomNumber )
                    SchriftListe.TypeKeys( "<Space>" )
                    
                next iSpecialChar

                ' leave special characters dialog with OK.
                Sonderzeichen.OK()

                
                ' select the chars we just entered and verify that the string is 
                ' not empty
                kontext "documentwriter"
                DocumentWriter.TypeKeys "<Home><Shift Right>"
                EditCopy
                
                sleep( 1 )
                
                ' Test content of clipboard against empty strings
                if ( GetClipboardText = " " OR GetClipboardText = "" ) then
                    Warnlog "Perhaps no characters is inserted ! -> " & cFont
                endif
                
                ' append some more information (font) to the line
                ' NOTE: If you have a linebreak somewhere, the test might fail.
                DocumentWriter.TypeKeys( "<End>        -> Font : " )
                DocumentWriter.TypeKeys( cFont & "<Return>" )
                
                ' special chars dialog again
                InsertSpecialCharacterWriter

                kontext "sonderzeichen"
            catch

                kontext "sonderzeichen"
                Exceptlog
                Warnlog( "There is a problem with " + cFont + "!" )
            endcatch

        endif ' ( ( iCurrentFont = 3) AND ( iSprache = 82 ) )

    next iCurrentFont

    ' cancel the special chars dialog
    Sonderzeichen.Cancel()
    
    '///<i>save the document and load it again</i><br>
    printlog "- save the document and load it"
    cFile = gOfficePath & "user\work\sonderz" & hGetSuffix( "current" )
    hSpeichernUnterKill ( cFile )
    
    FileClose
    
    hDateiOeffnen ( cFile )
    '///<i>close the document</i>
    Call hCloseDocument()
    
endcase

