'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_attributes.bas,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2006/06/07 12:44:01 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
' **
' ** owner : joerg.skottke@sun.com
' **
' ** short description : check the internal file dialog (Load/Save files w. special attributes)
' **
'\******************************************************************************

sub main
    
    ' NOTE: The test can only complete correctly if some of the working
    '       directories have special attributes/accessrights
    ' chmod -R 000 /.../framework/filedlg/input/noentry
    ' chmod -R 555 /.../framework/filedlg/input/readentry
    ' chmod 444 /.../framework/filedlg/input/readonly/*.*
    
    use "framework\filedlg\inc\filedlg_tools.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\stringtools.inc"
    use "framework\tools\inc\filetools.inc"
    use "framework\filedlg\inc\filedlg2.inc"
    use "framework\filedlg\inc\filedlg3.inc"
    use "framework\filedlg\inc\filedlg8.inc"
    
    PrintLog Chr(13) + "Test of the FileOpen-Dialog (Load/Save files w. special attributes)"
    Call hStatusIn ( "framework", "filedlg_attributes.bas" )
    
    call hSetUNIXAttributes ' tries to set the attributes for the directories/files
    ' used in tFileSpecialLoad and tFileSpecialSave
    ' This works on Sol/Lin only (permissions required)
    
    tOnlyRead             ' load files with the 'only read'-flag in our file-open-dialog
                          '  (all documenttypes of StarOffice)
    tReadOnly             ' load read-only files (all documenttypes of StarOffice)
    tOnlyReadReadOnly     ' load read-only files with 'only read'-flag in the file-open-dialog
    
    tFileSpecialLoad      ' load non existed files, load file from readonly directory
                          '  and file out of no entry directory
    tFileSpecialSave      ' save a file in a non-existed dir, save a file in a dir
                          '  without any rights for the user
    
    Call hStatusOut
    
end sub

' ****************************************

sub LoadIncludeFiles
    
    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    gApplication = "WRITER"
    Call GetUseFiles
    
end sub

