'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg4.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:02:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'*******************************************************************************
' **
' #1 tDialogTestFileSaveAs              ' open the file-save-as-dialog with menuitem
' #1 tDialogTestFileSave                ' open the file-save-dialog with ShortCuts, Button in the functionbar and menuitem
' #1 tDialogTestFileOpen                ' open the file-open-dialog with ShortCuts, Button in the functionbar and menuitem
' **
'\******************************************************************************

testcase tDialogTestFileSaveAs

   '///open the file-save-as-dialog
   '///open a new writer-doc
   gApplication = "WRITER"
   hNewDocument

   '///try to open the save-as-dialog without any changes in the document => slot should be disabled
   printlog " - File/Save-as without any changes"
   FileSaveAs
   Kontext "SpeichernDlg"
   Sleep (1)
   SpeichernDlg.Cancel

   '///try to open the save-as-dialog with changes in the document
   printlog " - File/Save-as with changes in the document"
   Kontext "DocumentWriter"
   DocumentWriter.TypeKeys "I made some changes in this document!<Return>"
   FileSaveAs
   Kontext "SpeichernDlg"
   Sleep (1)
   SpeichernDlg.Cancel

   hCloseDocument

endcase

'*******************************************************************************

testcase tDialogTestFileSave

   dim cAccel as string

   '///open the file-save-dialog on differnt ways
   printlog "the different ways to open the File-Save-Dialog"

   '///open a new writer-doc
   gApplication = "WRITER"
   hNewDocument

   '///try to open the save-dialog without any changes in the document => slot should be disabled
   printlog " - File/Save without any changes -> slot must be disabled"
   try
      FileSave
      Kontext "SpeichernDlg"
      if SpeichernDlg.Exists() then 
         Warnlog "#i42080# The slot 'File/Save' can be activated without any changes in the document!"
         Sleep (1)
         SpeichernDlg.Cancel()
         endif
   catch
   endcatch

   '///open the save-dialog out of the function-bar => button should be disabled
   printlog " - out of the function bar without any changes in the doc -> button must be disabled"
   try
      Kontext "StandardBar"
      Speichern.Click()
      
      Kontext "SpeichernDlg"
      if SpeichernDlg.Exists() then 
         Warnlog "#i42080# The save-button was active in the functionbar without any changes in the document!"
         Sleep (1)
         SpeichernDlg.Cancel()
      endif
   catch
   endcatch

   '///try to open the save-dialog with changes in the document
   printlog " - File/Save with changes in the document"
   Kontext "DocumentWriter"
   DocumentWriter.TypeKeys( "I made some changes in this document!<Return>" )
   Sleep (1)
   FileSave
   
   Kontext "SpeichernDlg"
   Sleep (1)
   SpeichernDlg.Cancel()
   Sleep (1)

   '///open the dialog with Ctrl-S -> close the file-dialog
   Kontext "DocumentWriter"

   cAccel = hGetAccel( "FileSave" )
   printlog( " - " & cAccel )
   DocumentWriter.TypeKeys( cAccel )
   
   Kontext "SpeichernDlg"
   Sleep (1)
   SpeichernDlg.Cancel()
   Sleep (1)

   '///open the save-dialog out of the function-bar -> close the file-dialog
   printlog " - out of the function bar"
   Kontext "StandardBar"
   Speichern.Click()
   
   Kontext "SpeichernDlg"
   Sleep (1)
   SpeichernDlg.Cancel()

   hCloseDocument

endcase

'*******************************************************************************

testcase tDialogTestFileOpen

   dim cAccel as string

   '///open the file-save-dialog on differnt ways
   printlog "the different ways to open the File-Open-Dialog"

   gApplication = "WRITER"
   
   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument

   '///call file/open -> close the file-dialog
   printlog " - File/Open"
   FileOpen
   
   Kontext "OeffnenDlg"
   Sleep (1)
   OeffnenDlg.Cancel()

   '///open the dialog with Ctrl-O -> close the file-dialog
   Kontext "DocumentWriter"
   cAccel = hGetAccel( "FileOpen" )
   printlog( " - " & cAccel )
   DocumentWriter.TypeKeys( cAccel )

   Kontext "OeffnenDlg"
   Sleep (1)
   OeffnenDlg.Cancel()

   '///open the dialog out of the function-bar -> close the file-dialog
   printlog " - out of the function bar"
   Kontext "StandardBar"
   Oeffnen.Click()
   
   Kontext "OeffnenDlg"
   Sleep ( 1 )
   OeffnenDlg.Cancel()

   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument

endcase




