'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_tools.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/11/21 12:37:57 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'************************************************************************
' **
' #1 GetFirstNameOfFileList    'get the first file listed in file-open
' #1 CheckDirectoryName        'create and verify its creation
' #1 CreateInvalidDirectory    'check if errormessages come up
' #1 CreateValidDirectory      'check if they are indeed created
' #1 CreateValidDirectoryCrop  'crop leading and trailing blanks
' #0 LoadDocumentReadOnly      'Open a document and verify it has been loaded
' #0 hSetUNIXAttributes        'sets Attributes for files/directories
' **
'\***************************************************************************

function GetFirstNameOfFileList as String

   'Get the first file listed in the filelist of the file-open dialog.
   'todo: remove the mouse action.
   
   const ICTIME = 2 ' default time to wait for an instruction to complete

   printlog( " - get the first file in the filepicker-list" )
   Kontext "OeffnenDlg"
   hMouseClick ( Dateiauswahl, 10, 10 )
   Dateiauswahl.TypeKeys( "<Down><Up>" )
   Dateiauswahl.TypeKeys( "<PageUp>" )
   Sleep ( ICTIME )
   GetFirstNameOfFileList = lcase ( Dateiauswahl.GetSelText() )

   if GetFirstNameOfFileList = "cvs" then
      printlog( " - skipping existing CVS-directory" )
      Dateiauswahl.TypeKeys( "<Down>" )
      GetFirstNameOfFileList = lcase ( Dateiauswahl.GetSelText() )
   end if

end function

'*******************************************************************************

sub CheckDirectoryName( dirname as string )

   ' Try to create a folder twice and make sure a warning comes up that the 
   ' folder already exists
   
   dim i as integer
   dim FULLPATH as string 
       FULLPATH = gOfficePath + "user\work\" + dirname + "\" 
       
   printlog( " - Create the folder and verify it's existence" )
   
   try

      for i=1 to 2
         
         printlog( " - creating folder for the " + i + ". time" )
      
         Kontext "OeffnenDlg"
         printlog( " - press 'new folder' button" )
         NeuerOrdner.Click()

         Kontext "NeuerOrdner"
         printlog( " - name the folder" )
         OrdnerName.SetText( dirname )
         printlog( " - press OK")
         NeuerOrdner.OK()
         Sleep (1)

         ' Take care of the File Exists Dialog
         printlog( " - check for 'File Exists'-Dialog" )
         Kontext "Active"
         If Active.Exists() then
            Active.OK()

            'if the file exists during first run of the test: just go on
            if i =  1 then
               warnlog( "File exists. Did you clean the output-dir?" )
            end if
            
            'if the active exists, we will return to the 'new folder' dialog
            'it must be closed as well
            Kontext "NeuerOrdner"
            NeuerOrdner.Cancel()
         else
            'this should only be displayed on second run
            if i = 2 then
               warnlog( "No message that the folder '" + dirname + "' exists!" )
            end if
         end if      

      next i

      printlog( " - verify the existence of the new directory" )
      if App.Dir ( ConvertPath ( FULLPATH ), 16 ) = "" then
         Warnlog( "The directory'" + dirname + "' wasn't created!" )
      else
         printlog( " - delete it")
         App.RmDir ( ConvertPath ( FULLPATH ) )
      end if

      
   catch

      warnlog( "Could not create the directory. Bugid: #108256# or #106510# ?" )

   endcatch

end sub

'*******************************************************************************

sub CreateInvalidDirectory( dirname as string )

   'Try to create a directory with a name that is invalid by using characters
   'that are not allowed for a filesystems. An errormessage is expected.

   const ICTIME = 1 ' default time to wait for an instruction to complete

   dim i as integer
   dim FULLPATH as string 
       FULLPATH = gOfficePath + "user\work\" + dirname + "\" 'experimental

   printlog( " - Trying to create directory <" + FULLPATH + ">" )

   try

      Kontext "OeffnenDlg"
      NeuerOrdner.Click()

      Kontext "NeuerOrdner"
      OrdnerName.SetText( dirname )
      NeuerOrdner.OK()

      Kontext "Active"
      if gPlatgroup() = "unx" then 

         'unx allows weird filenames
         if App.Dir ( ConvertPath ( FULLPATH ), 16 ) = "" then
            Warnlog "  the '" + dirname + "'-dir wasn't created!"
         else
            Sleep ( ICTIME )
            App.RmDir ( ConvertPath ( FULLPATH ) )
         end if

      else

         'windows
         if Active.Exists() then

            printlog( " - handle the 'Active' dialog" )
            Active.OK()

            'If a second dialog comes up (JSK 2002/11/21)
            Kontext "Active"
            if Active.Exists() then
               warnlog( "Double errormessage displayed, one expected." )
               Active.OK()
            end if

            Kontext "NeuerOrdner"
            NeuerOrdner.Cancel()

         else

            warnlog( "No warning that the folder can't be created!" )

         end if

         if App.Dir( ConvertPath ( FULLPATH ), 16 ) <> "" then
            Warnlog "The directory '"+ dirname + "' contains invalid chars"
            Sleep ( ICTIME )
            App.RmDir( ConvertPath ( FULLPATH ) )
         end if

      end if

   catch

      warnlog( "Could not create the directory. Bugid: #108256# or #106510# ?" )
      
   endcatch

end sub

'*******************************************************************************

sub CreateValidDirectory( dirname as string )

   'Create a directory that has a valid name at a valid location
   'The directory should not exist.
   'It will be created in the user's directory

   const ICTIME = 1 'default time to wait for an instruction to complete
   
   dim FULLPATH as string 
       FULLPATH = gOfficePath() + "user\work\" + dirname + "\" 'experimental

       
   printlog( " - Trying to create directory: <" + FULLPATH + ">" )
   
   try
   
      printlog( " - Open the file-open dialog" )
      Kontext "OeffnenDlg"
      NeuerOrdner.Click()
   
      printlog( " - name the folder" )
      Kontext "NeuerOrdner"
      OrdnerName.SetText( dirname )
      NeuerOrdner.OK()
      sleep ( ICTIME )
   
      printlog( " - check if the directory has been created" )
      if App.Dir ( ConvertPath ( FULLPATH ) , 16 ) = "" then
         warnlog( "The '" + dirname + "' has not been created!" )
      else
         Sleep ( ICTIME )
         App.RmDir( ConvertPath ( FULLPATH ) )
         printlog( " - existing file was successfully deleted" )
      end if
      
   catch

      warnlog( "Could not create the directory. Bugid: #108256# or #106510# ?" )
      
   endcatch
   
end sub

'*******************************************************************************

sub CreateValidDirectoryCrop( dirname as string , cropname as string)

   'Create a directory that has a name with leading or trailing spaces.
   'Those names are valid but must be cropped.
   'The directory should not exist.
   'It will be created in the user's directory.
   
   const ICTIME = 1 'default time to wait for an instruction to complete

   dim FULLPATH as string
       FULLPATH = gOfficePath + "user\work\" + dirname + "\" 'experimental
   dim CROPPATH as string
       CROPPATH = gOfficePath + "user\work\" + cropname + "\" 'experimental
   
   printlog( " - Trying to create directory: <" + FULLPATH + ">" )
   
   try
      
      printlog( " - open the file-open dialog" )
      Kontext "OeffnenDlg"
      NeuerOrdner.Click()

      printlog( " - name the folder" )
      Kontext "NeuerOrdner"
      OrdnerName.SetText( dirname )
      NeuerOrdner.OK()
      Sleep ( ICTIME )
      
      printlog( " - check if the directory has been created" )
      if App.Dir( ConvertPath ( CROPPATH ), 16 ) = "" then
      
         warnlog( "The leading or trailing spaces have not been deleted!" )
         
      else
      
         Sleep ( ICTIME )
         App.RmDir( ConvertPath ( CROPPATH ) )
         printlog( " - existing directory was successfully deleted." )
         
      end if
      
   catch

      warnlog( "Could not create the directory. Bugid: #108256# or #106510# ?" )
      
   endcatch
   
end sub 

'*******************************************************************************

function LoadDocumentReadOnly ( sDatei as String, TypeOfDocument as Integer, ReadOnlyFlag as Boolean ) as Boolean

    LoadDocumentReadOnly = TRUE

    FileOpen
    
    Kontext "OeffnenDlg"
    Dateiname.SetText sDatei
    
    if ReadOnlyFlag = TRUE then 
          NurLesen.Check()
          endif
          
    Oeffnen.Click
    IsItLoaded
    
    Kontext "Active"
    if Active.Exists then
       LoadDocumentReadOnly = FALSE
       Warnlog Active.GetText
       Active.OK
       Sleep (1)
       if Active.Exists then
          Warnlog "A second messagebox is active!"
          Active.OK
       end if
       
       Kontext "Filterauswahl"
       If FilterAuswahl.Exists then
          Warnlog "Filterbox is also active!"
          FilterAuswahl.Cancel
       end if
    end if
    
    'printlog( " - check for (unexpected) filter-dialog" )
    Kontext "Filterauswahl"
      
    If ( FilterAuswahl.Exists() ) then
       Warnlog( "Filterbox is active, this is not expected" )
       FilterAuswahl.Cancel()
       
       qaerrorlog( "TODO: There is no way that this function can handle " & _
                   "the filterdialog correctly, rewrite it!" )
       warnlog( "The test will most likely fail!" )
       
       LoadDocumentReadOnly() = false
       exit function
       
    endif    
    
    
    
    kontext "OeffnenDlg"
    
    if ( OeffnenDlg.exists() ) then
        warnlog( "File-Open dialog is open, this is not expected at this point" )
        printlog( "Exiting routine to recover" )
        
        OeffnenDlg.cancel()
        
        LoadDocumentReadOnly() = false
        exit function
        
    endif
    
    try
    
       select case TypeOfDocument
       
          case 1  : InsertSection                           ' Writer
                    Kontext
                    Active.Setpage TabBereiche
                    Kontext "TabBereiche"
                    TabBereiche.Cancel
          case 2  : FormatCells                             ' Calc
                    Kontext
                    Active.SetPage TabZahlen
                    Kontext "TabZahlen"
                    TabZahlen.Cancel
          case 3  : SlideShowPresentationSettings           ' Impress
                    Kontext "Bildschirmpraesentation"
                    Bildschirmpraesentation.Cancel
          case 4  : InsertLayer                             ' Draw
                    Kontext "EbeneEinfuegenDlg"
                    EbeneEinfuegenDlg.Cancel
          case 5  : FormatLegend                            ' Chart
                    Kontext "TabUmrandungChart" :
                    TabUmrandungChart.Cancel
          case 6  : FormatFonts                             ' Math
                    Kontext "Schriftarten"
                    Schriftarten.Cancel
       end select
       
       if LoadDocumentReadOnly = TRUE then 
          Warnlog "The document wasn't loaded read only"
          endif
       
    catch
    
    endcatch

end function

'*******************************************************************************

sub hSetUNIXAttributes()

   ' NOTE: Requested by TBO
   ' This sub tries to set the file-attributes on the qatesttool-snapshot on 
   ' mahler.germany.
   ' Since all BASIC commands are platform independent, it cannot be checked
   ' exactly.
   ' If you are not the owner of the testtool snapshot, this is *not* going to 
   ' work.

   '///Make sure the file-attributes are correct for the next tests. 

   dim cFullPath as string
   dim cParameter as string
   dim cCommand as string
   dim rc as integer

   if ( gPLatGroup = "unx" ) then

      cCommand = "chmod" ' Fallback, if no following definition matches
      if ( gPlatform = "sol" ) then cCommand = "/usr/bin/chmod"
      if ( gPlatform = "x86" ) then cCommand = "/usr/bin/chmod"
      if ( gPlatform = "lin" ) then cCommand = "/bin/chmod"

      cFullPath = convertpath( gTesttoolPath + "framework/filedlg/input/noentry" )
      printlog( "Trying to set attributes for "  + cFullPath )
      cParameter = "-R 000 " + cFullPath
      rc = shell( cCommand , 0 , cParameter , false )

      ' the readentry-directory must be readonly, the files as well
      cFullPath = convertpath( gTesttoolPath + "framework/filedlg/input/readentry" )
      printlog( "Trying to set attributes for " + cFullPath )
      cParameter = "-R 444 " + cFullPath
      rc = shell( cCommand , 0 , cParameter , false )
      'need to remove the "S" attribute
      cParameter = "-R -s " + cFullPath
      rc = shell( cCommand , 0 , cParameter , false )

      ' the readonly-directory: Only the directory is read-only, the files are rw
      cFullPath = convertpath( gTesttoolPath + "framework/filedlg/input/readonly/*.*" )
      printlog( "Trying to set attributes for " + cFullPath )
      cParameter = "444 " + cFullPath
      rc = shell( cCommand , 0 , cParameter , false )

   else

      printlog( "No file-attribute setting for non-UNIX platforms" )

   endif

end sub
