'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: topten.inc,v $
'*
'*  $Revision: 1.17 $
'*
'*  last change: $Author: jsk $ $Date: 2006/05/30 07:31:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Smoke test (load/save/clipboard)
'*
'************************************************************************
'*
' #1 Top_ten_test       ' check load/save/clipboard in all applications
' #0 topten             ' control program for top-ten-test
' #0 cutCopyPaste       ' sub to cut/copy/paste some text
' #0 fgetWorkingFilterName '
'*
'\***********************************************************************


sub topten
    gApplication = "WRITER"
    printlog( "** " + gApplication )
    call Top_ten_test
    gApplication = "CALC"
    printlog( "** " + gApplication )
    call Top_ten_test
    gApplication = "IMPRESS"
    printlog( "** " + gApplication )
    call Top_ten_test
    gApplication = "DRAW"
    printlog( "** " + gApplication )
    call Top_ten_test
    gApplication = "MATH"
    printlog( "** " + gApplication )
    call Top_ten_test
    gApplication = "HTML"
    printlog( "** " + gApplication )
    call Top_ten_test
    gApplication = "MASTERDOC"
    printlog( "** " + gApplication )
    call Top_ten_test
end sub

'*******************************************************************************

testcase Top_ten_test
    '///Top-Ten-Test
    '///<ul><li>open all document types</li>
    '///+<li>insert a text or a rectangle (Draw/Impress)</li>
    '///+<li>cut - paste / copy - paste</li>
    '///+<li>save as default-format (6.0format (XML))</li>
    '///+<li>save as 5.2-format</li>
    '///+<li>close the doc</li>
    '///+<li>load the 8.0-doc, change it, save this changes and close the doc</li>
    '///+<li>load the 5.2-doc, change it, save this changes and close the doc</li></ul>
    
    dim rootdir as string
    dim DokName1 as String
    dim DokName2 as String
    dim sFilter1 as string
    dim sFilter2 as String
    Dim i as Integer
    dim bExport as boolean

    rootdir = gOfficePath + "user\work\"
    bExport = true
    
    ' set the filenames and their filters
    DokName1 = "ls_test" & hGetSuffix( "current" )
    DokName2 = "ls_test" & hGetSuffix( "569" )
    
    printlog( " * File (current): " & DokName1 )
    printlog( " * File (src569).: " & DokName2 )
    
    sFilter1 = hGetFilter( "current" )
    sFilter1 = fgetWorkingFilterName(8,sFilter1)

    if ( gApplication = "HTML" ) then
        bExport = false
    endif

    printlog( "- create a new document" )
    call hNewDocument
    printlog( "- clipboard" )
    call CutCopyPaste
    printlog( "- saving => default-fileformat" )
    call hSpeichernUnterKill ( rootdir & DokName1 )
    Sleep (3)

    if bExport then
        sFilter2 = hGetFilter( "569" )
        sFilter2 = fgetWorkingFilterName(5,sFilter2)
        printlog "- saving => 5.2-fileformat"
        call hSpeichernUnterMitFilterKill (rootdir & DokName2, sFilter2)

        printlog "- close"
        FileClose

        kontext "active"
        If active.exists(5) then
            warnlog "Unexpected messagebox: '" + active.getText + "'"
            Active.Yes
        else
            printlog "- no more alien warning on closing the document. Good."
        end if
    else
        FileClose

        kontext "active"
        if Active.Exists(5) then
            warnlog "Unexpected Active after saving: '" + active.gettext + "'"
            try
                Active.Yes
            catch
                Active.No
            endcatch
        end if
    end if

    printlog "- loading => default-fileformat"
    call hDateiOeffnen (rootdir & DokName1)

    if bExport then
        printlog "  - change the doc"
        hChangeDoc()
        printlog "  - save"
        FileSave
        sleep(2)
    endif

    printlog "  - close"
    call hCloseDocument

    if bExport then
    'if (ucase(gApplication)="WRITER" OR ucase(gApplication)="MASTERDOC" AND iSprache=07 OR iSprache=90) then
    '    qaErrorLog("#61468# Loop on loading binary saved format of writer and masterdoc for language 07 and 90 (fixed in 2.0.3)")
    'else
        printlog "- loading => 5.2-fileformat"
        call hDateiOeffnen (rootdir & DokName2)
        printlog "  - change the doc"
        hChangeDoc()
        printlog "  - save"
        FileSave

        Kontext "AlienWarning"
        if AlienWarning.exists(5) then
            printlog "- alien warning came up. Good."
            AlienWarning.OK
            sleep 5
        else
            if (gBuild > 8870) then '8871 is CWS alienwarning integrated SRC680m77
                warnlog "- alien warning didn't came up."
            endif
        endif

        kontext "active"
        if Active.Exists(5) then
            if (gBuild > 8870) then '8871 is CWS alienwarning integrated SRC680m77
                warnlog  "Unexpected messagebox: '" + active.gettext + "'"
            else
                printlog "  - alien warning for change to current filter. Good. '" + active.gettext + "'"
            endif
            Active.yes
        end if

        printlog "  - close"
        FileClose

        kontext "active"
        if Active.Exists(5) then
            warnlog  "Unexpected messagebox: '" + active.gettext + "'"
            Active.Yes
        else
            printlog "- no more alien warning on closing the document. Good."
        end if
    'end if
    end if
endcase

'*******************************************************************************

sub CutCopyPaste
    dim sSelectAll as string

    ' In Spain Select All is CTRL+E; CTRL+A is FileOpen
    if (iSprache=34) then
        sSelectAll = "<Mod1 e>"
    else
        sSelectAll = "<Mod1 a>"
    endif

    select case gApplication
        case "WRITER", "HTMLDOKUMENT", "MASTERDOC"
            kontext "documentwriter"
            DocumentWriter.TypeKeys "This is a test.<Return>"
            printlog( "   cut" )
            DocumentWriter.TypeKeys sSelectAll
            DocumentWriter.TypeKeys "<Mod1 x>"
            Sleep 1
            printlog( "   paste" )
            DocumentWriter.TypeKeys "<Mod1 v>"
            Sleep 1
            printlog( "   copy" )
            DocumentWriter.TypeKeys sSelectAll
            DocumentWriter.TypeKeys "<Mod1 c>"
            Sleep 1
            printlog( "   paste" )
            DocumentWriter.TypeKeys "<Mod1 v>"
            Sleep 1
        case "CALC"   : Kontext "DocumentCalc"
            DocumentCalc.TypeKeys "This is a test.<Return>"
            DocumentCalc.TypeKeys "<Up>"
            printlog( "   cut" )
            DocumentCalc.TypeKeys "<Mod1 x>"
            Sleep 1
            printlog( "   paste" )
            DocumentCalc.TypeKeys "<Down>"
            DocumentCalc.TypeKeys "<Mod1 v>"
            Sleep 1
            printlog( "   copy" )
            DocumentCalc.TypeKeys "<Mod1 c>"
            Sleep 1
            printlog( "   paste" )
            DocumentCalc.TypeKeys "<Down>"
            DocumentCalc.TypeKeys "<Mod1 v>"
            Sleep 1
        case "DRAW"   : Kontext "DocumentDraw"
            hRechteckErstellen ( 30, 30, 60, 60 )
            gMouseClick ( 1, 1 )
            printlog( "   cut" )
            DocumentDraw.TypeKeys sSelectAll
            DocumentDraw.TypeKeys "<Mod1 x>"
            Sleep 1
            printlog( "   paste" )
            DocumentDraw.TypeKeys "<Mod1 v>"
            Sleep 1
            printlog( "   copy" )
            gMouseClick ( 1, 1 )
            DocumentDraw.TypeKeys sSelectAll
            DocumentDraw.TypeKeys "<Mod1 c>"
            Sleep 1
            printlog( "   paste" )
            gMouseClick ( 1, 1 )
            DocumentDraw.TypeKeys "<Mod1 v>"
        case "IMPRESS": Kontext "DocumentImpress"
            hRechteckErstellen ( 30, 30, 60, 60 )
            gMouseClick ( 1, 1 )
            printlog( "   cut" )
            DocumentImpress.TypeKeys sSelectAll
            DocumentImpress.TypeKeys "<Mod1 x>"
            Sleep 1
            printlog( "   paste" )
            DocumentImpress.TypeKeys "<Mod1 v>"
            Sleep 1
            printlog( "   copy"
            gMouseClick ( 1, 1 )
            DocumentImpress.TypeKeys sSelectAll
            DocumentImpress.TypeKeys "<Mod1 c>"
            Sleep 1
            printlog( "   paste" )
            gMouseClick ( 1, 1 )
            DocumentImpress.TypeKeys "<Mod1 v>"
        case "MATH"   : SchreibenInMathdok "a over b"
            Sleep (1)
            printlog( "   cut" )
            EditSelectAllMath
            Sleep (1)
            EditCut
            Sleep (1)
            printlog( "   paste" )
            EditPaste
            Sleep (1)
            printlog( "   copy" )
            EditSelectAllMath
            Sleep (1)
            EditCopy
            Sleep (1)
            printlog( "   paste" )
            EditPaste
            Sleep (1)
    end select
end sub

'*******************************************************************************

function fgetWorkingFilterName(iVersion as integer, optional sTryFilter) as string
    '/// Get the Filtername for gApplication and the Version from the API ///'
    '/// This is to workaround issues, where the reference file Filter differs from the UI ///'
    ' iVersion: 5,6(=7),8
    dim sFilterName as string
    dim sFilter as string
    dim sFilterExt() as string
    dim sFilterTemp as string
    dim sFilterExtTemp as string
    dim bCompare as boolean
    dim i as integer
    dim bIgnore as boolean
    
    bIgnore = FALSE
    if isMissing(sTryFilter) then
        bCompare = FALSE
    else
        bCompare = TRUE
    endif
    
    sFilterTemp=""
    sFilterExtTemp=""
    select case uCase(gApplication)
        case "WRITER": select case iVersion
                            case 5: sFilterTemp="StarWriter 5.0": sFilterExtTemp="writer_StarWriter_50"
                            case 6: sFilterTemp="StarOffice XML (Writer)": sFilterExtTemp="writer_StarOffice_XML_Writer"
                            case 8: sFilterTemp="writer8": sFilterExtTemp="writer8"
                       end select
        case "CALC": select case iVersion
                            case 5: sFilterTemp="StarCalc 5.0": sFilterExtTemp="calc_StarCalc_50"
                            case 6: sFilterTemp="StarOffice XML (Calc)": sFilterExtTemp="calc_StarOffice_XML_Calc"
                            case 8: sFilterTemp="calc8": sFilterExtTemp="calc8"
                       end select
        case "IMPRESS": select case iVersion
                            case 5: sFilterTemp="StarImpress 5.0": sFilterExtTemp="impress_StarImpress_50": bIgnore=TRUE
                            'case 5: sFilterTemp="StarDraw 3.0 (StarImpress)": sFilterExtTemp="draw_StarDraw_30"
                            case 6: sFilterTemp="StarOffice XML (Impress)": sFilterExtTemp="impress_StarOffice_XML_Impress"
                            case 8: sFilterTemp="impress8": sFilterExtTemp="impress8"
                       end select
        case "DRAW": select case iVersion
                            case 5: sFilterTemp="StarDraw 5.0": sFilterExtTemp="draw_StarDraw_50"
                            case 6: sFilterTemp="StarOffice XML (Draw)": sFilterExtTemp="draw_StarOffice_XML_Draw"
                            case 8: sFilterTemp="draw8": sFilterExtTemp="draw8"
                       end select
        case "MATH": select case iVersion
                            case 5: sFilterTemp="StarMath 5.0": sFilterExtTemp="math_StarMath_50"
                            case 6: sFilterTemp="StarOffice XML (Math)": sFilterExtTemp="math_StarOffice_XML_Math"
                            case 8: sFilterTemp="math8": sFilterExtTemp="math8"
                       end select
        case "HTML": select case iVersion
                            case 5,6,8: sFilterTemp="HTML": sFilterExtTemp="writer_web_HTML"
                       end select
        case "MASTERDOC": select case iVersion
                            case 5: sFilterTemp="StarWriter 5.0/GlobalDocument": sFilterExtTemp="writer_globaldocument_StarWriter_50GlobalDocument"
                            case 6: sFilterTemp="writer_globaldocument_StarOffice_XML_Writer_GlobalDocument": sFilterExtTemp="writer_globaldocument_StarOffice_XML_Writer_GlobalDocument"
                            case 8: sFilterTemp="writerglobal8": sFilterExtTemp="writerglobal8"
                       end select
    end select
    sFilterName = ""
    if ((sFilterTemp<>"") AND (sFilterExtTemp<>"")) then    
        sFilter = hGetUIFiltername(sFilterTemp)
        sFilterExt() = hGetFilternameExtension(sFilterExtTemp)
        if iVersion < 8 then
            sFilterName = sFilter + " (." 
            for i = 0 to uBound(sFilterExt())
                sFilterName = sFilterName + sFilterExt(i)
                if (i > -1) AND (uBound(sFilterExt()) <> i) then
                    sFilterName = sFilterName + ";."
                endif
            next i
            sFilterName = sFilterName + ")"
        else
            sFilterName = sFilter + " (." + sFilterExt(0) + ")"
        endif
    endif
    if bCompare then
        if (sFilterName <> sTryFilter) then
            if bIgnore then
                qaErrorLog "Reference is wrong! Filtername differs from reference; '" + gApplication + "' Version: " + iVersion + " expected: '" + sTryFilter + "'; found: '" + sFilterName + "'"
            else
                warnlog "Filtername differs from reference; '" + gApplication + "' Version: " + iVersion + " expected: '" + sTryFilter + "'; found: '" + sFilterName + "'"
            endif
        endif
    endif
    fgetWorkingFilterName = sFilterName
end function

'*******************************************************************************

