'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: help_compare_topics.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsk $ $Date: 2006/02/17 12:50:16 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : 
'*
'*******************************************************************************
' **
' #1 tCompareHelpTopics ' Compare all Help-Topics against a reference
' **
'\******************************************************************************

testcase tCompareHelpTopics()

    '///<h1>Compare list of help topics against a reference file</h1>
    '///<h2>help_compare_topics::tCompareHelpTopics</h2>
    '///<ul>

    ' NOTE: As some of the entries might exists twice or multiple times it is quite
    '       possible that the results are inaccurate. The new implementation of
    '       gCompare2Lists() (hListCompare() as used here) should be able to
    '       handle this. If problems occur, this shuld be the first place to
    '       look.

    const MAX_ENTRIES = 30000

    ' variables related to filenames
    dim sFileOut as string
    dim sFileIn as string
    dim sfileName as string
    
    ' The list that will hold all the entries
    dim aTopicsFromUI( MAX_ENTRIES ) as string
    
    ' some increment operators and temporary variables
    dim iCurrentItem as integer
    dim sCurrentItem as string
    dim iCurrentApp as integer
    dim iAboutItems as integer
    dim cAboutItem as string
    dim irc as integer
    dim bNextItem as boolean
    
    ' define input and output paths, preset variables
    sFileName = "help_topic" & iSprache & ".txt"
    sFileOut = hGetWorkFile( sFilename )
    sFileIn  = gTesttoolPath & "framework\help\input\help_topics" 
    sFileIn  = hGetInputPath( sFileIn , sFileName )
    aTopicsFromUI( 0 ) = "0"    
    
    '///+<li>Go to the Index-Page of the Help-Viewer</li>
    call hOpenHelp()
    hSelectHelpTab( "index" )
    
    '///+<li>Find out how many About-Items we have - usually this is 7 = Applications</li>
    ' NOTE: This testcase will not warn about missing About-Items, this is done
    '       by the update-test. But you will get an enormous list of missing
    '       Items.
    iAboutItems = HelpAbout.getItemCount()
    
    '///+<li>cycle through all applications listed in the About-List</li>
    for iCurrentApp = 1 to iAboutItems
    
        '///+<li>select and print the name of the current item</li>
        HelpAbout.select( icurrentApp )
        cAboutItem = HelpAbout.getSeltext()
        sleep( 5 )
    
        '///+<li>copy the strings from the ListBox into an array</li>
        iCurrentItem = 1
        bNextItem = true
        
        while( bNextItem ) 

            try
                SearchIndex.select( iCurrentItem )
                sCurrentItem = cAboutItem & " : " & SearchIndex.getSelText()
                hListAppend( sCurrentItem, aTopicsFromUI() )
                iCurrentItem = iCurrentItem + 1
            catch
                printlog( cAboutItem & ": Read " & iCurrentItem & " items" )
                bNextItem = false
            endcatch

        wend
        
    next iCurrentApp
    
    call hCloseHelp()
    
    ' hManageComparisionList takes care of a lot of things like checking
    ' for reference file and comparing or creating a new ref-file
    printlog( "" )
    printlog( "Beginning comparision. This will take a while ..." )
    
    '///+<li>Compare the items to the reference list</li>
    irc = hManageComparisionList( sFileIn, sFileOut, aTopicsFromUI() )    
    if ( irc <> 0 ) then
	    warnlog( "Something went wrong, please review the log" )
    endif
    '///</ul>
    
endcase


