'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: l1_ole.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2006/06/01 15:44:11 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : global-level-1-test -> insert all OLE-Objects out of OLE-dialog into all doc-types
'*
'*******************************************************************************
' **
' #1 tOLEWriter
' #1 tOLECalc
' #1 tOLEDraw
' #1 tOLEImpress
' **
'\******************************************************************************

testcase tOLEWriter

   '///Test all OLE-Objects you can insert out of menu
   Dim i% : Dim k%
   Dim sText$

   gApplication = "WRITER"

   '///'file / new / text document'
   Call hNewDocument

   '///'insert / object / chart' without a table
   PrintLog "- Writer :   Chart without table"
   InsertObjectChart
   
   '///+ click 'create' on the Autoformat dialog for Charts
   Kontext "AutoformatDiagramm1"
   Fertigstellen.Click
   sleep 4
   
   '///+ delete the selected chart with keyboard ( delete )
   Kontext "DocumentWriter"
   DocumentWriter.TypeKeys "<Delete>"
   Sleep 1

   '///create a table with numbers
   PrintLog "- Writer :   Chart out of a table only with numbers"
   InsertTableWriter
   
   Kontext "TabelleEinfuegenWriter"
   Spalten.SetText "3"
   Zeilen.SetText "10"
   TabelleEinfuegenWriter.OK

   Kontext "DocumentWriter"
   for i%=1 to 10
      for k%=1 to 3
         sText$ = (i%+k%)*k%
         DocumentWriter.TypeKeys  sText$
         DocumentWriter.TypeKeys "<Right>"
      next k%
      DocumentWriter.TypeKeys "<Down>"
      DocumentWriter.TypeKeys "<Left>", 3
   next i%

   '///+if you are in the table 'insert / object / chart'
   InsertObjectChart
   
   '///+click on each page of the Autoformat-dialog for charts on 'next' and on the last page 'create'
   Kontext "AutoFormatDiagramm1"
   Weiter.Click
   
   Kontext "AutoFormatDiagramm2"
   Weiter.Click
   
   Kontext "AutoFormatDiagramm3"
   Weiter.Click
   
   Kontext "AutoFormatDiagramm4"
   Fertigstellen.Click
   Sleep 3
   
   '///+ delete the selected chart with keyboard ( delete )
   Kontext "DocumentWriter"
   DocumentWriter.TypeKeys "<Delete>"
   Sleep 1
   DocumentWriter.TypeKeys "<Down>", 20
   DocumentWriter.TypeKeys "<Return>", 2
   Sleep 1

   '///create a new table only with characters
   PrintLog "- Writer :   Chart out of a table only with chars"
   InsertTableWriter
   
   Kontext "TabelleEinfuegenWriter"
   Spalten.SetText "3"
   Zeilen.SetText "10"
   TabelleEinfuegenWriter.OK

   Kontext "DocumentWriter"
   for i%=1 to 10
      for k%=1 to 3
         sText$ = (i%+k%)*k%
         DocumentWriter.TypeKeys  "Hallo" + sText$
         DocumentWriter.TypeKeys "<Right>"
      next k%
      DocumentWriter.TypeKeys "<Down>"
      DocumentWriter.TypeKeys "<Left>", 3
   next i%

   '///+if you are in the table 'insert / object / chart'
   InsertObjectChart
   
   '///+click on each page of the Autoformat-dialog for charts on 'next' and on the last page 'create'
   Kontext "AutoFormatDiagramm1"
   Weiter.Click
   
   Kontext "AutoFormatDiagramm2"
   Weiter.Click
   
   Kontext "AutoFormatDiagramm3"
   Weiter.Click
   
   Kontext "AutoFormatDiagramm4"
   Fertigstellen.Click
   Sleep 3
   
   '///+ delete the selected chart with keyboard ( delete )
   Kontext "DocumentWriter"
   DocumentWriter.TypeKeys "<Delete>"
   Sleep 1

   '///insert a math object into the writer doc
   PrintLog "- Writer :   Math"
   
   '///+ insert / object / formula
   InsertObjectFormulaWriter
   gMouseClick ( 1, 1)
   
   '///+ delete the selected mathobject with keyboard ( delete )
   Kontext "DocumentWriter"
   DocumentWriter.TypeKeys "<Delete>"
   Sleep 1

   '///insert a floating object into the writer doc
   PrintLog "- Writer :   floating frame"
   
   '///+insert / floating frame
   InsertFloatingFrame
   
   '///+insert in the dialog as name 'hello' and as contents '[Testtoolpath]\global\input\graf_inp\borabora.jpg'
   Kontext "TabEigenschaften"
   FrameName.SetText "Hallo"
   Inhalt.SetText ConvertPath ( gTesttoolPath+"global\input\graf_inp\borabora.jpg" )
   
   '///+click 'OK'
   TabEigenschaften.OK
   Sleep 2
   
   '///+ delete the selected frame with keyboard ( delete )
   Kontext "DocumentWriter"
   DocumentWriter.TypeKeys "<Delete>"
   Sleep 1

   '///close the document
   hCloseDocument
   
endcase

'*******************************************************************************

testcase tOLECalc

   dim i as Integer
   dim k as Integer
   const ICWAIT as Integer = 2

   gApplication = "CALC"

   '///'file / new / spreadsheet'
   Call hNewDocument

   '///insert a chart without data
   PrintLog "- Calc :   Chart without data"
   '///+insert / chart
   InsertChartCalc
   
   '///+click on 'create'
   Kontext "AutoFormatDiagrammBeginn"
   Fertigstellen.Click()
   sleep( ICWAIT )
   
   '///+Remove focus from object by clicking into the document
   Kontext "DocumentCalc"
   gMouseClick ( 1, 1 )
   sleep( ICWAIT )
   
   '///+Click on the chart and delete it with 'delete'
   gMouseClick ( 30, 30 )
   sleep( ICWAIT )
   
   DocumentCalc.TypeKeys "<Delete>"

   '///insert a chart with data
   PrintLog "- Calc :   Chart with data"
   
   '///+create a table with numbers
   DocumentCalc.TypeKeys "<Up><Left>",20
   for i = 1 to 7
      for k = 1 to 7
         hTypeKeys ( i * k )
         hTypeKeys ( "<Return>" )
      next k
      DocumentCalc.TypeKeys "<Up><Left>",20
      DocumentCalc.TypeKeys "<Right>", i
   next i

   '///+select the table
   DocumentCalc.TypeKeys "<Up><Left>",20
   call ZellenMarkieren (7,7)

   '///+insert / chart
   InsertChartCalc
   
   '///+click on 'next' for each page in AutoFormat dialog for charts and on the last page click 'create'
   Kontext "AutoFormatDiagrammBeginn"
   Weiter.Click()
   
   Kontext "AutoFormatDiagramm2"
   Weiter.Click()
   
   Kontext "AutoFormatDiagramm3"
   Weiter.Click()
   
   Kontext "AutoFormatDiagramm4"
   Fertigstellen.Click()
   sleep( ICWAIT )
   
   '///+click in the spreadsheet document to deselect the chart
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys("<escape>")
   sleep( ICWAIT )
   
   '///insert a chart only with text in the table
   PrintLog "- Calc :   Chart for a table only with text"
   
   '///+create a table only with text
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Up><Left>",20
   for i = 1 to 7
      for k = 1 to 7
         hTypeKeys ( "Hallo<Return>" )
      next k
      DocumentCalc.TypeKeys "<Up><Left>",20
      DocumentCalc.TypeKeys "<Right>", i
   next i

   DocumentCalc.TypeKeys "<Up><Left>",20
   call ZellenMarkieren (7,7)

   '///+insert / chart
   InsertChartCalc
   
   '///+click on 'next' for each page in AutoFormat dialog for charts and on the last page click 'create'
   Kontext "AutoFormatDiagrammBeginn"
   Weiter.Click()
   
   Kontext "AutoFormatDiagramm2"
   Weiter.Click()
   
   Kontext "AutoFormatDiagramm3"
   Weiter.Click()
   
   Kontext "AutoFormatDiagramm4"
   Fertigstellen.Click()
   sleep( ICWAIT )
   
   '///+click in the spreadsheet document to deselect the chart
   Kontext "DocumentCalc"
   gMouseCLick ( 1, 1 )
   sleep( ICWAIT )
   
   '///insert a math object
   PrintLog( "- Calc :   Math" )
   
   '///+insert / object / formula
   InsertObjectFormulaCalc
   sleep( ICWAIT )
   
   '///+click in the spreadsheet document to deselect the chart
   gMouseClick ( 50, 99 )
   sleep( ICWAIT )
   
   '///insert a floating frame
   PrintLog( "- Calc :   floating frame" )
   
   '///+insert / floating frame
   InsertFloatingFrame
   
   '///+insert in the dialog as name 'hello' and as contents '[Testtoolpath]\global\input\graf_inp\borabora.jpg'
   Kontext "TabEigenschaften"
   FrameName.SetText "Hallo"
   Inhalt.SetText ConvertPath ( gTesttoolPath+"global\input\graf_inp\borabora.jpg" )
   
   '///+click 'OK'
   TabEigenschaften.OK()
   sleep( ICWAIT )
   
   '///+click in the spreadsheet document to deselect the chart
   gMouseCLick ( 1, 1 )
   sleep( ICWAIT )
   
   '///close the document
   hCloseDocument
   
endcase

'*******************************************************************************

testcase tOLEDraw

   Dim i% : Dim k%
   Dim iMenuCount(1) as integer

   gApplication = "DRAW"

   '///file / new / drawing
   Call hNewDocument

   '///insert a math object
   PrintLog "- Draw :   Math"
   '///+insert / object / formula
   InsertObjectFormulaDraw
   sleep 2
   
   '///+click into the draw document once to set the focus on the math object
   gMouseClick ( 1 , 1 )
   sleep 1
   
   '///+delete the object with keyboard ( delete )
   DocumentDraw.TypeKeys "<Delete>"

   '///insert a chart
   PrintLog "- Draw :   Chart"
   
   '/// Special test: check that menubar switches, by comparing the count. ///'
   hUseMenu()
   iMenuCount(0) = menuGetItemCount
   MenuSelect(0)
   
   '///+insert / chart
   try
      InsertObjectChart
      Sleep ( 2 )
   
       Kontext "DocumentChart"
       DocumentChart.useMenu
       iMenuCount(1) = menuGetItemCount
       MenuSelect(0)
       if iMenuCount(0) = iMenuCount(1) then
           warnlog "Menu bar didn't change after inserting OLE object; It should be different from: " +iMenuCount(0)
       else
           printlog "Menu bar did change; from: " + iMenuCount(0) + "; to: " + iMenuCount(1)
       endif
       
      '///+click into the draw document once to set the focus on the math object
      gMouseClick ( 1 , 1 )
      Sleep ( 1 )

      '///+delete the object with keyboard ( delete )
      DocumentDraw.TypeKeys "<Delete>"
   catch
      Call hReopenDoc
   endcatch

   '///insert a spreadsheet
   PrintLog "- Draw :   Calc"
   
   '///+insert / spreadsheet
   InsertSpreadsheetDraw
   sleep 2
   
   '///+click one time into the draw document to set only the focus on the math object
   gMouseClick ( 1 , 1 )
   sleep 1
   
   '///+delete the object with keyboard ( delete )
   DocumentDraw.TypeKeys "<Delete>"

   '///insert a floating frame
   PrintLog "- Draw :   floating frame"
   
   '///+insert / floating frame
   try 
      InsertFloatingFrame
   
      Kontext "TabEigenschaften"
   
      '///+insert in the dialog as name 'hello' and as contents '[Testtoolpath]\global\input\graf_inp\borabora.jpg'
      FrameName.SetText "Hallo"
      Inhalt.SetText ConvertPath ( gTesttoolPath+"global\input\graf_inp\borabora.jpg" )
   
      '///+click 'OK'
      TabEigenschaften.OK
      Sleep 2
   
      '///+click one time into the draw document to set only the focus on the math object
      gMouseClick ( 1 , 1 )
      Sleep 1
   
      '///+delete the object with keyboard ( delete )
      DocumentDraw.TypeKeys "<Delete>"
   catch
      Call hReopenDoc
   endcatch

   hCloseDocument
   
endcase

'*******************************************************************************

testcase tOLEImpress

   Dim i% : Dim k%

   gApplication = "IMPRESS"

   '///file / new / presentation
   Call hNewDocument

   '///insert a math object
   PrintLog "- Impress :   Math"
   
   '///+insert / object / formula
   InsertObjectFormulaDraw
   sleep 2
   
   '///+click one time into the impress document to set only the focus on the math object
   gMouseClick ( 1 , 1 )
   sleep 1

   '///+delete the object with keyboard ( delete )
   DocumentImpress.TypeKeys "<Delete>"

   '*** Chart
   PrintLog "- Impress :   Chart"

   try
      '///+insert / chart
      InsertObjectChart
      sleep 2

      '///+click one time into the impress document to set only the focus on the math object
      gMouseClick ( 1 , 1 )
      sleep 1

      '///+delete the object with keyboard ( delete )
      DocumentImpress.TypeKeys "<Delete>"
   catch 
      Call hReopenDoc
   endcatch

   '*** Calc
   PrintLog "- Impress :   Calc"

   '///+insert / spreadsheet
   InsertSpreadsheetDraw
   sleep 2

   '///+click one time into the impress document to set only the focus on the math object
   gMouseClick ( 1 , 1 )
   sleep 1

   '///+delete the object with keyboard ( delete )
   DocumentImpress.TypeKeys "<Delete>"

   '*** floating frame
   PrintLog "- Impress :   floating frame"

   try
      '///+insert / floating frame
      InsertFloatingFrame
   
      Kontext "TabEigenschaften"
      FrameName.SetText "Hallo"

      '///+insert in the dialog as name 'hello' and as contents '[Testtoolpath]\global\input\graf_inp\borabora.jpg'
      Inhalt.SetText ConvertPath ( gTesttoolPath+"global\input\graf_inp\borabora.jpg" )

      '///+click 'OK'
      TabEigenschaften.OK
      Sleep 2

      '///+click one time into the impress document to set only the focus on the math object
      gMouseClick ( 1 , 1 )
      Sleep 1
   catch
      hReopenDoc
   endcatch

   '///+delete the object with keyboard ( delete )
   DocumentImpress.TypeKeys "<Delete>"

   hCloseDocument
   
endcase


