'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_trusted_subdir.bas,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsk $ $Date: 2006/07/24 07:35:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Execute macros from trusted path
'*
'\******************************************************************************

sub main

    use "framework\security\inc\f_sec_trusted_path.inc"

    use "framework\tools\inc\filetools.inc"
    use "framework\tools\inc\stringtools.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\security_tools.inc"

    ' this is the trusted path we want to add to the list
    dim cWorkPath as string
        cWorkPath = gTesttoolPath & "framework\basic\input\"
        cWorkPath = convertpath( cWorkPath )

    ' this is the file to be loaded, located directly below trusted path
    dim cWorkFile as string

    dim iApp as integer
    dim cApp as string

    call hStatusIn( "framework" , "f_sec_trusted_subdir.bas" )

    ' Set the macrosecurity to medium, add the trusted path
    hSetMacroSecurity( 1 )
    hAddTrustedPath( cWorkPath )

    ' Cycle through the six main applications for the most recent documenttype
    for iApp = 1 to 6

        cWorkFile = cWorkPath & "BasicDocs/basic" & hGetSuffix( "current" )
        cWorkFile = convertpath( cWorkFile )
        cApp = hNumericDoctype( iApp )

        printlog( "" )
        printlog( cApp )
        call tSecTrustedPath( cWorkFile )

    next iApp

    ' Reset the trusted path, reset macro security level.
    hRemoveTrustedPath( cWorkPath )
    hSetMacrosecurity( 1 )

    call hStatusOut()

end sub

'-------------------------------------------------------------------------

sub LoadIncludeFiles

    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    gApplication = "WRITER"
    call GetUseFiles()

end sub

