'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_evilmacro1.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsk $ $Date: 2006/07/24 07:33:54 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Load documents containing hidden BASIC scripts
'*
'*******************************************************************************
'**
' #1 tSecurityEvilMacro1 ' Allow macro execution/Security set to medium
'**
'\******************************************************************************

testcase tSecurityEvilMacro1()

    '///<h1>Level 1 test: Allow macro execution/Security set to medium</h1>
    '///<ul>

    dim acFile( 2 ) as string

        acFile( 1 ) = gTesttoolPath & "framework\security\input\test_macro.html"
        acFile( 1 ) = convertpath( acFile( 1 ) )

        acFile( 2 ) = gTesttoolPath & "framework\security\input\test_macro.odt"
        acFile( 2 ) = convertpath( acFile( 2 ) )

    dim iCurrentFile as integer ' increment variable
    dim cMsg as string          ' string from messagebox
    dim brc as boolean          ' some returnvalue
    

    '///+<li>Do following for each document to be tested:</li>
    '///<ul>

    for iCurrentFile = 1 to ubound( acFile() )

        printlog( "" )
        printlog( "File: " & acFile( iCurrentFile ) )

        '///+<li>Click FileOpen or go to the dialog via menu</li>
	FileOpen

        '///+<li>Enter the name of the file</li>
	kontext "OeffnenDlg"
	Dateiname.setText( acFile( iCurrentFile ) )

        '///+<li>Click &quot;Open&quot;</li>
        Oeffnen.click()
        sleep( 3 )

        '///+<li>Verify that the security warning comes up, confirm to run macro.<br>
        '///+ There should be no warning for security levels other than medium!</li>
        brc = hAllowMacroExecution() 
        if ( not brc ) then
            warnlog( "Macro security dialog not triggered by document with macro" )
        endif

        '///+<li>Wait a moment for the document to get loaded</li>
        sleep( 5 )

        '///+<li>Check for a messagebox to come up on load. This might only<br>
        '///+ after a security warning has been displayed!</li>
        kontext "Active"
        if ( active.exists() ) then

            ' warn if macro runs without security warning
            if ( not brc ) then
                cMsg = active.getText()
                cMsg = hRemoveLineBreaks( cMsg )
                if ( cMsg = "Hello from StarBasic" ) then
                    warnlog( "The macro was executed without asking for permission" )
                else
                    printlog( "Messagebox: " & cMsg )
                endif
            endif

            ' get the string on the messagebox
            cMsg = active.getText()
            cMsg = hRemoveLineBreaks( cMsg )
            if ( cMsg = "Hello from StarBasic!" ) then
                printlog( "Macro was executed: " & cMsg )
            else
                warnlog( "Unknown dialog is open. This is not the macro" )
            endif
            active.ok()
        endif

        '///+<li>Close the document</li>
        call ExitRestartTheOffice()

    next iCurrentFile

    '///</ul>
    '///</ul>

endcase

