'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extension_manager_tools.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsk $ $Date: 2006/08/08 10:03:41 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools to ease working with the extension manager
'*
'*******************************************************************************
'**
' #1 hExtensionAddGUI ' Add an extension via Extension Manager GUI
' #1 hExtensionRemoveGUI ' Remove an extension vi Extension Manager GUI
'**
'\******************************************************************************

function hExtensionAddGUI( sPathToExtension as string, _
                           bExtensionHasLicense as boolean ) as integer


    '///<h3>Add an extension via Extension Manager</h3>
    '///<i>This function adds an extension to the office using the
    '///+ Extension Manager GUI (formerly known as Package Manager).<br>
    '///It notifies about unexpected messageboxes, progressbars, missing
    '///+ depency warnings as well as license agreements. The function
    '///+ will exit on any error, print a message and return an errorcode.<br>
    '///The errorcode *must* be evaluated, some errors are fatal. Cleanup must be 
    '///+ done outside of this function.<br>
    '///All new extensions are installed below My Packages.<br>
    '///Starting point is any document or the backing window, the function
    '///+ will return to the starting document</i><br>
    '///<u>Input value(s):</u><br>
    '///<ol>

    '///+<li>Path to extension (string)</li>
    '///<ul>
    '///+<li>The path must be absolute</li>
    '///</ul>

    '///+<li>Expect a license text (boolean)</li>
    '///<ul>
    '///+<li>TRUE: Extension shows license text during installation</li>
    '///+<li>FALSE: Custom package without license</li>
    '///</ul>

    '///</ol>


    '///<u>Return Value:</u><br>

    '///<ol>
    '///+<li>Errorcode (Integer)</li>
    '///<ul>
    '///+<li>0 = No errors, extension was added correctly</li>
    '///+<li>1 = Extension Manager could not be opened (fatal)</li>
    '///+<li>2 = Add-Button is not enabled</li>
    '///+<li>3 = Error while opening file (fatal)</li>
    '///+<li>4 = Unexpected messagebox was displayed (fatal)</li>
    '///+<li>5 = Unsatisfied dependencies dialog was displayed (fatal)</li>
    '///+<li>6 = Expected license dialog is missing</li>
    '///+<li>7 = Unexpected license dialog is displayed (fatal)</li>   
    '///+<li>8 = Unknown error / did not return to extension manager (fatal)</li>    
    '///</ul>
    '///</ol>

    const CFN = "hExtensionAddGUI::"
    
        
        
    dim brc as boolean 'a multi purpose boolean returnvalue
    dim iWait as integer
    dim cMsg as string
    dim iUnsatisfiedDeps as integer
    dim bLicenseExists as boolean
    dim cSelectAll as string

    '///<u>Description:</u>
    '///<ul>
    '///+<li>Open the Extension Manager</li>
    ToolsPackageManager
    kontext "PackageManager"
    if ( not PackageManager.exists() ) then
        printlog( CFN & "Could not open Extension Manager" )
        hExtensionAddGUI() = 1
        exit function
    endif
        
    '///+<li>Click the &quot;Add&quot; button</li>
    BrowsePackages.typeKeys( "<HOME>" )
    if ( not Add.isEnabled() ) then
        printlog( CFN & "Add-button is not enabled" )
        hExtensionAddGUI() = 2
        exit function
    endif
    
    Add.click()
    
    '///+<li>Enter the path to the extension, click &quot;Open&quot;</li>
    kontext "OeffnenDlg"
    if ( OeffnenDlg.exists() ) then
        DateiName.setText( sPathToExtension )
        Oeffnen.click()
    else
        printlog( CFN & "Adding package: FileOpen failed" )
        hExtensionAddGUI() = 3
        exit function
    endif
    
    '///+<li>Ckeck for progress bar</li>
    for iWait = 1 to 15
        kontext "AddingPackages"
        if ( AddingPackages.exists() ) then
            sleep( 1 )
        else
            exit for
        endif
    next iWait
    
    '///+<li>Check for errormessages</li>
    kontext "Active"
    if ( active.exists() ) then
        cMsg = active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        printlog( CFN & "Unexpected Messagebox: " & cMsg )
        hExtensionAddGUI() = 4
        exit function
    endif
    
    '///+<li>Check for unsatisfied dependencies/li>
    kontext "UnsatisfiedDependencies"
    if ( UnsatisfiedDependencies.exists( 10 ) ) then
        iUnsatisfiedDeps = UnsatisfiedDependencyList.getItemCount()
        printlog( CFN & "Unsatisfied deps: " & iUnsatisfiedDeps )
        hExtensionAddGUI() = 5
        exit function
    endif
    
    '///+<li>Check for software license agreement</li>
    '///<ul>
    
    '///+<li>Expected license exists (good)</li>   
    kontext "ExtensionSoftwareLicenseAgreement"
    bLicenseExists = ExtensionSoftwareLicenseAgreement.exists()
    if ( bExtensionHasLicense and bLicenseExists ) then
        while ( not Accept.isEnabled() )
            ScrollDown.click()
            sleep( 1 )
        wend
        accept.click()
    endif
     
    '///+<li>Expected license does not exist (bad)</li>
    if ( bExtensionHasLicense and not bLicenseExists ) then
        printlog( CFN & "Expected license is missing" )

        kontext "PackageManager"
        PackageManager.ok()
        
        hExtensionAddGUI() = 6
        exit function
    endif
    
    '///+<li>License exists but was not expected (bad)</li>
    if ( bLicenseExists and not bExtensionHasLicense ) then
        printlog( CFN & "License is displayed but was not expected" )
        while ( not Accept.isEnabled() )
            ScrollDown.click()
            sleep( 1 )
        wend
        
        accept.click()
        
        kontext "PackageManager"
        PackageManager.ok()
        
        hExtensionAddGUI() = 7
        exit function
    endif
        
    '///+<li>License does not exist and was not expected (good)</li>
    if ( not bExtensionHasLicense and not bLicenseExists ) then
        ' do nothing
    endif
    '///</ul>
    
    '///+<li>Verify that we are back on the Extension Manager GUI</li>
    kontext "PackageManager"
    if ( not PackageManager.exists() ) then
        printlog( CFN & "We are not back to the Extension Manager" )
        hExtensionAddGUI() = 8
        exit function
    endif
    
    '///+<li>Close the Extension Manager</li>
    kontext "PackageManager"
    PackageManager.ok()
    
    '///</ul>

    printlog( CFN & "Successfully added extension" )
    hExtensionAddGUI() = 0
    
end function


'*******************************************************************************

function hExtensionRemoveGUI( cExtensionName as string) as integer


    '///<h3>Remove an extension via Extension Manager </h3>
    '///<i>This function removes a package/an extension by name.<br>
    '///It will notify about errorconditions such as non existing packages, 
    '///+ errors during removal etc.<br>
    '///Some errors are considered fatal, others are recovered. If the error
    '///+ is non-fatal, the function returns to the document it started from<br>
    '///The function will do printlogs but no warnings so you *must* evaluate
    '///+ the returncode and you must clean up manually<i></br>
    

    '///<u>Input value(s):</u><br>
    '///<ol>
    '///+<li>UI Name of the extension (string)</li>
    '///</ol>


    '///<u>Return Value:</u><br>

    '///<ol>
    '///+<li>Errorcode (integer)</li>
    '///<ul>
    '///+<li>0 = No errors, extension was removed</li>
    '///+<li>1 = Failure to open Extension Manager (fatal)</li>
    '///+<li>2 = Cannot delete found extension, remove-button is disabled (fatal)</li>
    '///+<li>3 = The extension was not found (non-fatal)</li>
    '///+<li>4 = Extension was not deleted / unknown error (non-fatal)</li>
    '///+<li>Options/Limitations/Ranges</li>
    '///</ul>
    '///</ol>

    const CFN = "hExtensionRemoveGUI::"
    dim brc as boolean 'a multi purpose boolean returnvalue
        brc = false
    dim iExtensionCount as integer
    dim iExtensionRemoved as integer
    dim iCurrentExtension as integer
    dim cCurrentExtension as string

    '///<u>Description:</u>
    '///<ul>
    '///+<li>Open the Extension Manager</li>
    ToolsPackageManager
    kontext "PackageManager"
    if ( not PackageManager.exists() ) then
        printlog( CFN & "Could not open Extension Manager" )
        hExtensionRemoveGUI() = 1
        exit function
    endif   

    '///+<li>Expand &quot;My packages&quot;</li>
    BrowsePackages.typeKeys( "<HOME>" )
    BrowsePackages.typeKeys( "<RIGHT>" )
    
    '///+<li>Find out how many extensions are listed below &quot;My packages&quot;</li>    
    iExtensionCount = BrowsePackages.getItemCount() - 2
    
    '///+<li>Locate the extension</li>
    for iCurrentExtension = 1 to iExtensionCount
    
        BrowsePackages.typeKeys( "<DOWN>" )
        cCurrentExtension = BrowsePackages.getText()
        
        if ( cCurrentExtension = cExtensionName ) then
            if ( remove.isEnabled() ) then
                remove.click()
                brc = true
                exit for
            else
                printlog( CFN & "Unable to remove package, button is disabled" )
                hExtensionRemoveGUI() = 2
                exit function
            endif
        endif
        
    next iCurrentExtension
        
    '///+<li>Verify that the extension has been found, if not -> back to document</li>
    if ( not brc ) then
        printlog( CFN & "Could not find extension with given name" )
        hExtensionRemoveGUI() = 3
        
        kontext "PackageManager"
        PackageManager.ok()
        exit function
    endif
        
    '///+<li>Verify that the extension has been removed</li>
    iExtensionRemoved = BrowsePackages.getItemCount() - 2
    if ( ( iExtensionCount - 1 ) <> iExtensionRemoved ) then
        printlog( CFN & "The number of extensions after removal is incorrect" )
        hExtensionRemoveGUI() = 4
        
        kontext "PackageManager"
        PackageManager.ok()        
        exit function
    endif
    
    '///+<li>Close the Extension Manager</li>
    kontext "PackageManager"
    PackageManager.ok()
    
    '///</ul>

    printlog( CFN & "Successfully removed extension" )
    hExtensionRemoveGUI() = 0

end function
