'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: help_tools.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsk $ $Date: 2006/06/28 05:57:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : Replacements for routines in t_lists.inc adds some
'*
'*******************************************************************************
'*
' #1 hOpenHelp      ' Open the help window
' #1 hCloseHelp     ' Close the help window
' #1 hSelectHelpTab ' Select a tabpage on the help dialog by name
' #1 hUseBookmarksContextMenu ' Bookmarks Context menu
' #1 hHelpGetAboutItemCount ' Get the number of items from the AboutItems box
' #1 hHelpGetSearchIndexItemCount ' a workaround for failing getItemCount
'*
'\******************************************************************************

function hOpenHelp() as boolean

    '///<h3>Function to open the Help Browser</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE if the help is open</li>
    '///+<li>FALSE if the help did not open</li>
    '///</ul>
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    const CFN = "hOpenHelp::"

    dim iTry as integer
    dim brc as boolean
        brc = false

    '///+<li>Open the help Browser using the slot</li>
    HelpContents

    '///+<li>Verify that the help is indeed open (max 10 sec.)</li>
    Kontext "StarOfficeHelp"
    for iTry = 1 to 50

        if ( StarOfficeHelp.exists() ) then
            brc = true
            exit for
        endif

        sleep( 1 )

    next iTry

    '///+<li>Print a status to the log, return TRUE or FALSE</li>
    if ( brc ) then
        printlog( CFN & "Help is open" )
    else
        printlog( CFN & "Help is not open" )
    endif

    '///</ul>
    hOpenHelp() = brc

end function

'*******************************************************************************

function hCloseHelp() as boolean

    '///<h3>Function to close the Help Browser</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE if the help is closed</li>
    '///+<li>FALSE if the help did not close</li>
    '///</ul>
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    const CFN = "hCloseHelp::"

    dim brc as boolean

    '///+<li>Verify that the Help Browser is Open</li>
    kontext "StarOfficeHelp"
    if ( not StarOfficeHelp.exists() ) then
        printlog( CFN & "Help is not open" )
        hCloseHelp() = false 
        exit function
    endif

    '///+<li>Close the Help Browser by typing CTRL+F4</li>
    StarOfficeHelp.typeKeys( "<MOD1 F4>" )

    '///+<li>Verify that the Help Browser is not open (anymore)</li>
    kontext "StarOfficeHelp"
    if ( StarOfficeHelp.exists() ) then
        printlog( CFN & "Help is still open" )
        brc = false
    else
        printlog( CFN & "Help has been closed" )
        brc = true
    endif

    '///+<li>Return TRUE or FALSE</li>
    '///</ul>
    hCloseHelp() = brc

end function

'******************************************************************************

function hSelectHelpTab( cTab as string ) as boolean

    '///<h3>Select a tab on the help dialog by name</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>The tab to open (string)</li>
    '///<ul>
    '///+<li>&quot;content&quot; for the contents tab</li>
    '///+<li>&quot;index&quot; for the index tab</li>
    '///+<li>&quot;find&quot; for the find tab</li>
    '///+<li>&quot;bookmarks&quot; for the bookmarks tab</li>
    '///</ul>    
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE if the requested tabpage is open</li>
    '///+<li>FALSE if the requested tabpage did not open</li>
    '///</ul>
    '///</ol>
    
    '///<u>Description</u>:    
    '///<ul>
    const CFN = "hSelectHelpTab::"

    dim brc as boolean
        brc = false

    dim cTabName as string
        cTabName = lcase( cTab )

    kontext "StarOfficeHelp"

    '///+<li>Select the requested Tabpage, verify that it is open</li>
    select case cTabName
    case "content"       : TabControl.setPage( ContentPage )
                           if ( SearchContent.isVisible() ) then
                               brc = true
                           endif
    case "index"         : TabControl.setPage( IndexPage )
                           if ( SearchIndex.isVisible() ) then
                               brc = true
                           endif
    case "find"          : TabControl.setPage( FindPage )
                           if ( SearchFind.isVisible() ) then
                               brc = true
                           endif
    case "bookmarks"     : TabControl.setPage( BookmarksPage )
                           if ( Bookmarks.isVisible() ) then
                               brc = true
                           endif
    case else 
        printlog( CFN & "Invalid parameter passed to function: " & cTab )
        printlog( CFN & "Valid are: content, index, find, bookmarks" )
        brc = false
    end select

    '///+<li>Print a comment to the log</li>
    if ( brc ) then
        printlog( CFN & "Selected Tabpage: " & cTab )
    endif
 
    '///+<li>Return TRUE or FALSE</li>
    hSelectHelpTab() = brc    

    '///</ul>
end function

'*******************************************************************************

function hUseBookmarksContextMenu( cAction as string ) as boolean

    '///<h3>handle the bookmarks context menu in Help Browser</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>The context item to execute (string)</li>
    '///<ul>
    '///+<li>&quot;show&quot;</li>
    '///+<li>&quot;rename&quot;</li>
    '///+<li>&quot;delete&quot;</li>
    '///</ul>    
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE on success</li>
    '///+<li>FALSE on any other error</li>
    '///</ul>
    '///</ol>
    
    '///<u>Description</u>:        
    '///<ul>
    const CFN = "hUseBookmarksContextMenu::"
    dim cSelection as string
    dim iActionPos as integer

    '///+<li>Verify that we are on the Bookmarks Page</li>
    Kontext "BookmarksPage"
    if ( not BookmarksPage.exists() ) then
        printlog( CFN & "BookmarksPage is not open" )
        hUseBookmarksContextMenu() = false
        exit function
    endif

    '///+<li>Find the index of the requested entry</li>
    cSelection = lcase( cAction )
    select case cSelection
    case "show"       : iActionPos = 1
    case "rename"     : iActionPos = 2
    case "delete"     : iActionPos = 3
    case else         : iActionPos = 0
    end select

    '///+<li>If action is unsuported, return false and exit the function</li>
    if ( iActionPos = 0 ) then
        printlog( CFN & "Invalid action passed to function" )
        hUseBookmarksContextMenu() = false
        exit function
    endif
    
    '///+<li>Open the context menu and select the requested index</li>
    kontext "Bookmarks"
    Bookmarks.openContextMenu()
    printlog( CFN & "Opening item: " & MenuGetItemText( iActionPos ) )
    MenuSelect( iActionPos )

    '///+<li>Return TRUE if all went well so far</li>
    hUseBookmarksContextMenu() = true
   
    '///</ul>

end function

'*******************************************************************************

function hHelpGetAboutItemCount() as integer

    '///<h3>Get the number of applications listed in the Help ListBox</h3>
    
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Number of applications listed (integer)</li>
    '///<ul>
    '///+<li>The default is 7</li>
    '///</ul>
    '///</ol
    
    '///<u>Description</u>:
    '///<ul>
    
    const I_ABOUT_ITEMS = 7
    const CFN = "hHelpGetAboutItemCount::"
    
    dim iItem as integer
    dim cItemName as string
    dim iAboutItems as integer
    
    '///+<li>Open Help</li>
    hOpenHelp()
    hSelectHelpTab( "index" )
    Kontext "IndexPage"
    
    '///+<li>get the number of applications from the drop down box</li>
    iAboutItems = HelpAbout.getItemCount()
    if ( iAboutItems <> I_ABOUT_ITEMS ) then
        warnlog( "The list of topics is incomplete:" )
    endif
    
    '///+<li>Print the list of items to the log</li>
    printlog( CFN & "Items listed in Application Listbox (HelpAbout)" )
    for iItem = 1 to iAboutItems
        cItemName = HelpAbout.getItemText( iItem )
        printlog( "     " & cItemName )
    next iItem
    
    '///+<li>close help</li>
    hCloseHelp()
    '///</ul>    
    
    hHelpGetAboutItemCount() = iAboutItems
    
end function

'*******************************************************************************

function hHelpGetSearchIndexItemCount() as integer

    '///<h3>Get the number of items in the Help Search Index</h3>
    '///<i>Starting point: Help / Index page</i><br>
    '///<i>Note: Workaround for incorrect value returned by .getItemCount()</i><br>
    
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Number of items in the list (integer)</li>
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hHelpGetSearchIndexItemCount:"
    
    dim iItem as integer
    
    '///+<li>Run through the list and count the items, break on error</li>
    for iItem = 1 to 10000
    
        try
            SearchIndex.select( iItem )
        catch
            iItem = iItem - 1
            exit for
        endcatch
            
    next iItem
    
    hHelpGetSearchIndexItemCount() = iItem
    '///</ul>
    
end function
