'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: pbrowser_tools.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsk $ $Date: 2006/06/28 09:01:31 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools for working with the property browser for formcontrols
'*
'*******************************************************************************
'**
' #1 hOpenPropertyBrowser   ' somewhat safe method to open the Control Properties
' #1 hClosePropertyBrowser  ' close the propertybrowser
' #1 hSetControlName        ' Name the current control
' #1 hGetControlName        ' Get and compare the name of the current control
' #1 hCheckPropertyPresence ' Finds out whether a property should be available or not
' #1 hSetPBTabPage          ' Switches the TabPage Properties <--> Events
'**
'\******************************************************************************

function hOpenPropertyBrowser() as boolean
    
    '///<h3>Function to open the properties of a selected control</h3>
    '///<i>The function verifies that the property browser is really open
    '///+ If - for some reason - the P-Browser already is open, a warning
    '///+ is written to the log but the test continues.</i><br><br>
    
    '///<u>Input</u>:
    '///<ol>
    
    '///+<li>Nothing</li>
    
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE on successful open of the property browser</li>
    '///+<li>FALSE on any error</li>
    '///</ul>
    
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    dim brc as boolean
    dim iWait as integer
    
    '///+<li>Verify that the property browser is not open</li>
    'Printlog( "Opening Property-Browser" )
    
    ' in case the p-browser is already open, we live with that. But a warning
    ' is put to the log. Note that performing a "ControlPropertiesDialog.exists()"
    ' i very slow and might even fail completely so we look for TabGeneralControl
    ' instead.
    kontext "ControlPropertiesDialog"
    if ( TabGeneralControl.exists() ) then
        hOpenPropertyBrowser() = true
        warnlog( "The Property-Browser is already open." )
        exit function
    endif
    
    '///+<li>Verify that the ToolsCollectionBar is open</li>
    ' Since the problem existed that the ToolsCollectionBar closed after usage,
    ' the test verifies that it is still present.
    ' A times there is a delay when repainting the ToolscollectionBar so
    ' the OpenProperties Button might not be ready instantly, so we loop for
    ' max 5 seconds.
    Kontext "ToolsCollectionBar"
    brc = false
    if ( ToolsCollectionBar.exists() ) then
        
        '///+<li>Click the &quot;Properties&quot;-button on ToolsCollectionBar</li>
        for iWait = 1 to 20
            if ( OpenProperties.isEnabled() ) then
                OpenProperties.Click()
                brc = true
                exit for
            else
                wait( 250 )
            endif
        next iWait
    endif
    
    '///+<li>Verify that the button could be clicked</li>
    if ( not brc ) then
        warnlog( "Could not open Properties, button is disabled." )
        hOpenPropertyBrowser() = false
        exit function
    endif
    
    '///+<li>Verify that the Property Browser is open (TabGeneralControl)</li>
    ' Check for TabGeneralControl is what gives speed to the function,
    ' Testing the presence of ControlPropertiesDialog always returns false!
    brc = false
    for iWait = 1 to 20
        kontext "ControlPropertiesDialog"
        if ( TabGeneralControl.exists() ) then
            brc = true
            exit for
        else
            wait( 250 )
        endif
    next iWait
    
    '///+<li>Set returnvalues</li>
    if ( brc ) then
        hOpenPropertyBrowser() = true
    else
        warnlog( "Could not open/access the Property-Browser" )
        hOpenPropertyBrowser() = false
    endif
    '///</ul>
    
    
end function

'*******************************************************************************

function hClosePropertyBrowser() as boolean
    
    '///<h3>A function that closes the Property-Browser</h3>
    '///<i>Since the Property-Browser does not have a close button, it can only
    '///be closed by clicking on the OpenProperties Button on the
    '///ToolsCollectionBar</i><br><br>
    
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE if the Property Browser has been closed</li>
    '///+<li>FALSE on any error</li>
    '///</ul>
    
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    dim iWait as integer
    dim brc as boolean
    brc = false
    
    hClosePropertyBrowser() = true
    
    'printlog( "Closing Property-Browser" )
    
    '///+<li>Verify that the ToolsCollectionBar is open</li>
    ' Since the problem existed that the ToolsCollectionBar closed after usage,
    ' the test verifies that it is still present.
    ' A times there is a delay when repainting the ToolscollectionBar so
    ' the OpenProperties Button might not be ready instantly, so we loop for
    ' max 5 seconds.
    Kontext "ToolsCollectionBar"
    if ( ToolsCollectionBar.exists() ) then
        for iWait = 1 to 20
            
            '///+<li>Click on &quot;OpenProperties&quot;, the Property Browser should close</li>
            if ( OpenProperties.isEnabled() ) then
                OpenProperties.Click()
                brc = true
                exit for
            else
                wait( 250 )
            endif
        next iWait
    endif
    
    '///+<li>Verify that the Property browser is no longer present</li>
    if ( brc ) then
        kontext "ControlPropertiesDialog"
        if ( ControlPropertiesDialog.exists() ) then
            hClosePropertyBrowser() = false
        endif
    else
        warnlog( "Could not close the Property-Browser" )
    endif
    '///</ul>
    
end function

'*******************************************************************************

function hSetControlName( sControl as string ) as boolean
    
    '///<h3>Name a control, with limited errorhandling</h3>
    
    '///<i>This function was introduced due to a problem with the property-
    '///browser not being open fast enough or just refusing to accept input</i><br><br>
    
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Text to be inserted in the control &quot;NameText&quot; (string)</li>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    
    '///+<li>Errorcondition</li>
    '///<ul>
    '///+<li>TRUE: The control name was successfully updated</li>
    '///+<li>FALSE: Control is not visible within current context</li>
    '///</ul>
    
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    '///+<li>Test that the control &quot;NameText&quot; exists</li>
    kontext "TabGeneralControl"
    if ( NameText.exists() ) then
        '///+<li>Set the new name</li>
        NameText.setText( sControl )
        hSetControlName() = true
    else
        warnlog( "Unable to name the control." )
        hSetControlName() = false
    endif
    '///</ul>
    
end function

'*******************************************************************************

function hGetControlName( sControl as string ) as boolean
    
    '///<h3>Verify that the expected control is open</h3>
    '///<i>Use hSetControlName( string ) to set the name and when you reopen it
    '///+ verify that you got the right control wit this function</i><br><br>
    
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name of the control (string)</li>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE: The control has the correct name</li>
    '///+<li>FALSE: Any other condition</li>
    '///</ul>
    
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    dim cControlName as string
    
    '///+<li>If &quot;NameText&quot; exists, retrieve its text</li>
    kontext "TabGeneralControl"
    if ( NameText.exists() ) then
        cControlName = NameText.getText()
    else
        warnlog( "Unable to get the name from the control." )
        hGetControlName() = false
        exit function
    endif
    
    '///+<li>Verify that the name is correct</li>
    if ( cControlName = sControl ) then
        'printlog( "The correct control is open: " & sControl )
        hGetControlName() = true
    else
        warnlog( "This is not the correct control." )
        hGetControlName() = false
    endif
    '///</ul>
    
end function

'*******************************************************************************

function hCheckPropertyPresence ( cSetting as string , iPos as integer ) as boolean
    
    '///<h3>Function to determine whether a property is available for a control or not</h3>
    '///<i>This function takes a string (provided by controlcfg.dat) and looks for an 'x' at.
    '///+ a given position.  If it is found it returns TRUE, FALSE if it is a '-'<br>
    '///+Note that this function is a terrible workaround for a missing feature: In the current
    '///+ version of the Testtool we cannot ask which controls are present on a dialog. So this
    '///+ has to be kept in a list of some sort. This is especially bad for a property browser
    '///+ test as we need to maintain such a list for 21 controls and a total of 76 (IIRC)
    '///+ possible properties whereof only a small number (eight, i think) are common for all
    '///+ controls. The test is barely maintainable, issues have been written but there is
    '///+ no solution so far.</i><br><br>
    
    '///<u>Input</u>:
    '///<ol>
    
    '///+<li>Configuration string (string)</li>
    '///<ul>
    '///+<li>The string must be taken from file &quot;controlcfg.dat&quot;</li>
    '///</ul>
    
    '///+<li>Position of the control (integer)</li>
    '///<ul>
    '///+<li>&gt; 0 and &lt; 74 (all possible control config items)</li>
    '///</ul>
    
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Status (boolean)</li>
    '///<ul>
    '///+<li>TRUE: The property should exist for the current control</li>
    '///+<li>FALSE: The property is not expected to exist for this control</li>
    '///</ul>
    
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    ' this function looks at a given position in the string cSetting for either
    ' a "x" or a "-".
    ' if "x" is found, the function returns true, else false.
    
    
    '///+<li>Find the requested position in the string, set TRUE if it is an &quot;x&quot;</li>
    if ( mid( cSetting , iPos , 1 ) = "x" ) then
        hCheckPropertyPresence() = true
    else
        hCheckPropertyPresence() = false
    endif
    '///</ul>
    
end function

'*******************************************************************************

function hSetPBTabPage( iPage as integer ) as boolean
    
    '///<h3>A small helper to switch between tabpages in the property-browser</h3>
    '///<u>Input</u>:
    '///<ol>
    
    '///+<li>Page-ID (integer)</li>
    '///<ul>
    '///+<li>1 = General page</li>
    '///+<li>2 = Events page</li>
    '///</ul>
    
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE on success</li>
    '///+<li>FALSE on any error</li>
    '///</ul>
    
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    dim brc as boolean
    dim iWait as integer
    
    const CFN = "hSetPBTabPage::"
    
    '///+<li>Verify function parameter</li>
    if ( ( iPage < 1 ) or ( iPage > 2 ) ) then
        warnlog( CFN & "Illegal argument passed: " & iPage )
        hSetPBTabPage() = false
        exit function
    endif
    
    '///+<li>Switch to the requested page</li>
    kontext "ControlPropertiesTabControl"
    brc = false
    for iWait = 1 to 10
        
        select case iPage
        case 1
            printlog( CFN & "Switching to TabGeneralControl" )
            ControlPropertiesTabControl.setPage TabGeneralControl
            kontext "TabGeneralControl"
            if ( TabGeneralControl.exists() ) then
                brc = true
                exit for
            else
                wait( 100 )
            endif
            
        case 2
            printlog( CFN & "Switching to TabEventsControl" )
            ControlPropertiesTabControl.setPage TabEventsControl
            kontext "TabEventsControl"
            if ( TabEventsControl.exists() ) then
                brc = true
                exit for
            else
                wait( 100 )
            endif
            
        end select
        
    next iWait
    
    hSetPBTabPage() = brc
    '///</ul>
    
end function



