'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_set_standard_controls.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsi $ $Date: 2006/08/09 08:52:05 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Tool library for setting controls and verifying the functionality
'*
'**************************************************************************************************
'*
' #1 tControlsToolsDocumentation    'Documentation of this library
' #1 fSetListBoxByItem              'Function to select item in list box
' #1 fSetListBoxByString            'Function to select item by string in list box
' #1 fSetSpinFieldByString          'Function to set a string in a spin field control
' #1 fSetSpinFieldByButton          'Function to set a spin field control by using 'more' or 'less' button
' #1 fSetSpinFieldByLimit           'Function to set a spin field control to minimum or maximum value
' #1 fSetComboBoxByItem             'Function to select item in combo box
' #1 fSetComboBoxByString           'Function to select item in combo box
' #1 fSetComboBoxByText             'Function to Edit Field part of a combo box
' #1 fSetCheckBox                   'Function to (un)check a check box
' #1 fSetRadioButton                'Function to check a radio button
'*
'\************************************************************************************************

testcase tControlsToolsDocumentation
'///<u><b>Library for abtracted handling of several control types</b></u>
'///+Note: This functions are designed to be called by wrapping functions
'///+All functions are designed to return error codes depending on the behaviour of the action applied.
'///<b>Return codes:</b>
'///+<ul><li>Error  0: Success</li>
'///+<li>Error  1: The basic action beeing applied caused a serious problem, e.g. a crash</li>
'///+<li>Error  2 TO  9: A functional problem occured.</li>
'///+<li>Error 11 TO 19: Wrong marginal conditions end up in Failure, e.g. control not visible</li></ul>
'/// NOTE: This errors can also be used for 'negative' testing.
'///+<ul><li>Error 42: Wrong input. Probably only of interest during test development</li>
'///+<li>Error 99: Unexpected behaviour - Shouldn't normally occur</li></ul>
'///<b>ATTENTION:</b>
'///+<ul><li>Only Errors 42 and 99 throw 'warnlogs'</li>
'///+<li>All other errors are silent!</li>
'///+<li>They only throw QAErrorlogs the give a hint what probably went wrong.</li>
'///+<li>Expected Errors MUST exclusivly be handled by the calling routine!</li></ul>
'///+<p><font size=-1><i>The idea and the first implementation of this library has been made by Peter Junge (pj at openoffice.org)</i></font></p> 
    QAErrorLog "This testcase isn't really meant to be used!!!"
endcase
'
'--------------------------------------------------------------------
'
function fSetTextBox ( oThisTextBox as OBJECT , sThisText as STRING ) as INTEGER
         fSetTextBox = 99
'///<u><b>Function to set a text box</b></u>
'///Input: 
'///+<ul><li><b>OBJECT oThisTextBox</b> (text box name in declaration)</li>
'///+<li><b>STRING sThisText</b> (text to be set in text box control)</li></ul>
'/// Return (Error-codes):
'///+<ul><li>0  = Sucess</li>
'///+<li>1  = Serious problem trying to set value</li>
'///+<li>2  = Value was not set</li>
'///+<li>11 = Text box is not visible</li>
'///+<li>12 = Text box is not enabled</li>
'///+<li>99 = Unexpected error</li></ul>

    dim iIndex as INTEGER
    dim iListLength as INTEGER
    dim sResultInUI as STRING
    
    sResultInUI = ""

    printlog "Setting text in Text Box Edit field"
    ' Check if desired Text box is visible
    if NOT oThisTextBox.IsVisible then
        QAErrorLog "Error 11: Text box is not visible"
        fSetTextBox = 11
        exit function
    endif
    ' Check if desired Text box is enabled
    if NOT oThisTextBox.IsEnabled then
        QAErrorLog "Error 12: Text box is not enabled"
        fSetTextBox = 12
        exit function
    endif
    ' Try to set text on Text Box
    try 
        oThisTextBox.setText sThisText
    catch
        ' Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Set text on Text box seems to cause a serious problem."
        fSetTextBox = 1
        exit function
    endcatch
    'Verify (against input) if text was set correctly    
    sResultInUI = oThisTextBox.GetText
    if sResultInUI = sThisText then
        fSetTextBox = 0
        printlog "Set '" & sThisText & "' in 'text box' control PASSED."
    else
        QAErrorLog "Error 2: Setting '" & sThisText & "' in 'text box' control failed!"
        fSetTextBox = 2
    endif

    if fSetTextBox = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif   
end function
'
'--------------------------------------------------------------------
'
function fSetListBoxByItem ( oThisListBox as OBJECT , iThisValue as INTEGER ) as INTEGER
         fSetListBoxByItem = 99
'///<u><b>Function to select item in list box</b></u>
'///Input: 
'///+<ul><li><b>OBJECT oThisListBox</b> (list box name in declaration)</li>
'///+<li><b>INTEGER iThisValue</b> (item number to be selected in list box control)</li></ul>
'///<b>Return (Error-codes):</b>
'///+<ul><li>0  = Sucess</li>
'///+<li> 1 = Serious problem trying to set value</li>
'///+<li> 2 = Value was not set</li>
'///+<li>11 = List box is not visible</li>
'///+<li>12 = List box is not enabled</li>
'///+<li>13 = Item number to be selected out of list range</li>
'///+<li>99 = Unexpected error</li></ul>

    dim iListLength as INTEGER
    dim iResultFromUI as INTEGER
    
    iResultFromUI = ""
    
    printlog "Setting Item in list box"
    'Check if desired list box is visible
    if NOT oThisListBox.IsVisible then
        QAErrorLog "Error 11: List box is not visible"
        fSetListBoxByItem = 11
        exit function
    endif
    'Check if desired list box is enabled
    if NOT oThisListBox.IsEnabled then
        QAErrorLog "Error 12: List box is not enabled"
        fSetListBoxByItem = 12
        exit function
    endif
    'Check if input value is within list length
    iListLength = oThisListBox.GetItemCount
    if iThisValue < 1 OR iThisValue > iListLength then
        QAErrorLog "Error 13: Item number out of list range"        
        fSetListBoxByItem = 13
        exit function
    endif
    'Try to set value in List Box
    try 
        oThisListBox.select iThisValue
    catch
        'Throw error 1 and quit on serious problem
        QAErrorLog "Error 1: Set value on list box seems to cause a serious problem."
        fSetListBoxByItem = 1
        exit function
    endcatch
    'Verify (against input) if item was set correctly
    iResultFromUI = oThisListBox.GetSelIndex
    if iResultFromUI = iThisValue then
        fSetListBoxByItem = 0
        printlog ">> Set value in list box seems to work"
    else
        QAErrorLog "Error 2: Set value in list box failed."
        fSetListBoxByItem = 2
    endif

    if fSetListBoxByItem = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif   
end function
'
'--------------------------------------------------------------------
'
function fSetListBoxByString ( oThisListBox as OBJECT , sThisString as STRING ) as INTEGER
         fSetListBoxByString = 99
'///<u><b>Function to select item by string in list box</b></u>
'///Input: 
'///+<ul><li><b>OBJECT oThisListBox</b> (list box name in declaration)</li>
'///+<li><b>STRING sThisString</b> (string trying to match in list box items)</li></ul>
'///<b>Return(E rror-codes):</b>
'///+<ul><li> 0 = Sucess</li>
'///+<li> 1 = Serious problem trying to set value</li>
'///+<li> 2 = Value was not set</li>
'///+<li>11 = List box is not visible</li>
'///+<li>12 = List box is not enabled</li>
'///+<li>13 = String to be selected doesn't exist in list box</li>
'///+<li>99 = Unexpected error</li></ul>

    dim iIndex as INTEGER
    dim iListLength as INTEGER
    dim bStringIsInList as BOOLEAN
    dim sUIStringNow as STRING

    bStringIsInList = FALSE
    sUIStringNow = ""

    printlog "** Setting Item in list box"
    'Check if desired list box is visible
    if NOT oThisListBox.IsVisible then
        qaErrorLog "Error 11: List box is not visible"
        fSetListBoxByString = 11
        exit function
    endif
    'Check if desired list box is enabled
    if NOT oThisListBox.IsEnabled then
        qaErrorLog "Error 12: List box is not enabled"
        fSetListBoxByString = 12
        exit function
    endif
    'Check if input value is existent in list entries
    iListLength = oThisListBox.GetItemCount
    for iIndex = 1 to iListLength
        if oThisListBox.GetItemText ( iIndex ) = sThisString then
            bStringIsInList = TRUE
        endif
    next iIndex
    if bStringIsInList then
        printlog "OK, String exists in list box"
    else
        qaErrorLog "Error 13: Input String not found in list entries"
        fSetListBoxByString = 13
        exit function
    endif
    'Try to set value in List Box
    try 
        oThisListBox.select sThisString
    catch
        'Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Set value on list box seems to cause a serious problem."
        fSetListBoxByString = 1
        exit function
    endcatch
    'Verify (against input) if item was set correctly
    sUIStringNow = oThisListBox.GetSelText
    if sUIStringNow = sThisString then
        fSetListBoxByString = 0
        printlog "Setting value in list box is OK"
    else
        qaErrorLog "Error 2: Set value in list box failed."
        fSetListBoxByString = 2
    endif

    if fSetListBoxByString = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif   
end function
'
'--------------------------------------------------------------------
'
function fSetSpinFieldByString ( oThisSpinField as OBJECT , sThisString as STRING ) as INTEGER
         fSetSpinFieldByString = 99
'///<u><b>Function to set a string in a spin field control</b></u>
'///Input: 
'///+<ul><li><b>OBJECT oThisSpinField</b> (spin field name in declaration)</li>
'///+<li><b>STRING sThisString</b> (string to set in spin field control)</li></ul>
'///<b>Return (Error codes):</b>
'///+<ul><li> 0 = Sucess</li>
'///+<li> 1 = Serious problem trying to set value</li>
'///+<li>11 = Spin field is not visible</li>
'///+<li>12 = Spin field is not enabled</li>
'///+<li>99 = Unexpected error</li></ul>

    printlog "Setting value in spin field"
    'Check if desired spin field is visible
    if NOT oThisSpinField.IsVisible then
        qaErrorLog "Error 11: Spin field is not visible"
        fSetSpinFieldByString = 11
        exit function
    endif
    'Check if desired spin field is enabled
    if NOT oThisSpinField.IsEnabled then
        qaErrorLog "Error 12: Spin field is not enabled"
        fSetSpinFieldByString = 12
        exit function
    endif
    'Try to set value in spin field
    try 
        oThisSpinField.setText sThisString
        fSetSpinFieldByString = 0
    catch
        'Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Setting value on spin field seems to cause a serious problem."
        fSetSpinFieldByString = 1
        exit function
    endcatch
    if fSetSpinFieldByString = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif   
end function
'
'--------------------------------------------------------------------
'
function fSetSpinFieldByButton ( oThisSpinField as OBJECT , sMoreOrLess as STRING , OPTIONAL iTimes as INTEGER ) as INTEGER
         fSetSpinFieldByButton = 99
'///<u><b>Function to set a spin field control by using More or Less button</b></u>
'///Input:
'///+<ul><li><b>OBJECT oThisSpinField</b> (spin field control name in declaration</li>
'///+<li><b>STRING sMoreOrLess</b> has to be <i><b>more</i></b> or <i><b>less</i></b> (to click on 'More' or 'Less' button in spin field)</li>
'///+<li><i>optional</i> <b>INTEGER iTimes</b> (How often to click if more than once)</li></ul>
'///<b>Return (Error codes):</b>
'///+<ul><li> 0 = Sucess</li>
'///+<li> 1 = Serious problem trying to set value</li>
'///+<li>11 = Spin field is not visible</li>
'///+<li>12 = Spin field is not enabled</li>
'///+<li>42 = User error, input doesn't match</li>
'///+<li>99 = Unexpected error</li></ul>

    'toggle spin field as least once
    if isMissing ( iTimes ) then
        iTimes = 1
    endif
    printlog "Toggle value in spin field"
    'Check if desired spin field is visible
    if NOT oThisSpinField.IsVisible then
        qaErrorLog "Error 11: Spin field is not visible"
        fSetSpinFieldByButton = 11
        exit function
    endif
    'Check if desired spin field is enabled
    if NOT oThisSpinField.IsEnabled then
        qaErrorLog "Error 12: Spin field is not enabled"
        fSetSpinFieldByButton = 12
        exit function
    endif
    'Try to toggle value in spin field
    try 
        select case lcase ( sMoreOrLess ) 
               case "more" : oThisSpinField.more ( iTimes )
               case "less" : oThisSpinField.less ( iTimes )
               case else
                    fSetSpinFieldByButton = 42
                    warnlog "USER ERROR: Input doesn't match!"
                    exit function
        end select
        fSetSpinFieldByButton = 0
    catch
        'Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Try to toggle spin field seems to cause a serious problem."
        fSetSpinFieldByButton = 1
        exit function
    endcatch
    if fSetSpinFieldByButton = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif   
end function
'
'--------------------------------------------------------------------
'
function fSetSpinFieldByLimit ( oThisSpinField as OBJECT , sMinOrMax as STRING ) as INTEGER
         fSetSpinFieldByLimit = 99
'///<u><b>Function to set a spin field control to minimum or maximum value</b></u>
'///Input:
'///+<ul><li><b>OBJECT oThisSpinField</b> (spin field name in declaration</li>
'///+<li><b>STRING sMinOrMax</b> has to be <i><b>min</i></b> or <i><b>max</i></b> (to set spin field to minimum or maximum value)</li></ul>
'///<b>Return (Error codes):</b>
'///+<ul><li> 0 = Sucess</li>
'///+<li> 1 = Serious problem trying to set value</li>
'///+<li>11 = Spin field is not visible</li>
'///+<li>12 = Spin field is not enabled</li>
'///+<li>42 = User error, input doesn't match</li>
'///+<li>99 = Unexpected error</li></ul>

    printlog "Set spin field control to minimum or maximum value"
    'Check if desired spin field is visible
    if NOT oThisSpinField.IsVisible then
        qaErrorLog "Error 11: Spin field is not visible"
        fSetSpinFieldByLimit = 11
        exit function
    endif
    'Check if desired spin field is enabled
    if NOT oThisSpinField.IsEnabled then
        qaErrorLog "Error 12: spin field is not enabled"
        fSetSpinFieldByLimit = 12
        exit function
    endif
    'Try to set spin field to minimum or maximum value
    try 
        select case lcase ( sMinOrMax ) 
               case "max" : oThisSpinField.toMax
               case "min" : oThisSpinField.toMin
               case else
                    fSetSpinFieldByLimit = 42
                    warnlog "USER ERROR: Input doesn't match!"
                    exit function
        end select
        fSetSpinFieldByLimit = 0
    catch
        'Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Trying to set spin field to minimum or maximum value seems to cause a serious problem."
        fSetSpinFieldByLimit = 1
        exit function
    endcatch
    if fSetSpinFieldByLimit = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif 
end function
'
'--------------------------------------------------------------------
'
function fSetComboBoxByItem ( oThisComboBox as OBJECT , iThisValue as INTEGER ) as INTEGER
'This is an alias for 'fSetListBoxByItem'

'///<u><b>Function to select item in combo box</b></u>
'///Input:
'///+<ul><li><b>OBJECT oThisComboBox</b> (combo box name in declaration)</li>
'///+<li><b>INTEGER iThisValue</b> (item number to be selected in Combo box)</li></ul>
'///<b>Return (Error codes):</b>
'///+<ul><li> 0 = Sucess</li>
'///+<li> 1 = Serious problem trying to set value</li>
'///+<li> 2 = Value was not set</li>
'///+<li>11 = Combo box is not visible</li>
'///+<li>12 = Combo box is not enabled</li>
'///+<li>13 = Item number to be selected out of list range</li>
'///+<li>99 = Unexpected error</li></ul>
    fSetComboBoxByItem = fSetListBoxByItem ( oThisComboBox , iThisValue )
end function
'
'--------------------------------------------------------------------
'
function fSetComboBoxByString ( oThisComboBox as OBJECT , iThisString as STRING ) as INTEGER
'This is an alias for 'fSetListBoxByString'
'///<u><b>Function to select item in combo box</b></u>
'///Input:
'///+<ul><li><b>OBJECT oThisComboBox</b> (combo box name in declaration)</li>
'///+<li><b>STRING iThisString</b> (string to be selected in combo box control)</li></ul>
'///<b>Return (Error codes):</b>
'///+<ul><li> 0 = Sucess</li>
'///+<li> 1 = Serious problem trying to set value</li>
'///+<li> 2 = Value was not set</li>
'///+<li>11 = Combo box is not visible</li>
'///+<li>12 = Combo box is not enabled</li>
'///+<li>13 = String to be selected doesn't exist in list box</li>
'///+<li>99 = Unexpected error</li></ul>
    fSetComboBoxByString = fSetListBoxByString ( oThisComboBox , iThisString )
end function
'
'--------------------------------------------------------------------
'
function fSetComboBoxByText ( oThisComboBox as OBJECT , sThisText as STRING , OPTIONAL bVerifyAgainstEntries as BOOLEAN ) as INTEGER
         fSetComboBoxByText = 99
'///<u><b>Function to Edit Field part of a combo box</b></u>
'///Input:
'///+<ul><li><b>OBJECT oThisComboBox</b> (combo box name in declaration)</li>
'///+<li><b>STRING sThisText</b> (Text to be set in combo box edit field</li>
'///+<li><i>optional</i> <b>BOOLEAN bVerifyAgainstEntries</b> (Check if setting the text succeeded)</li></ul>
'///<b>Return (Error codes):</b>
'///+<ul><li> 0 = Sucess</li>
'///+<li> 1 = Serious problem trying to set value</li>
'///+<li> 2 = Value was not set</li>
'///+<li>11 = Combo box is not visible</li>
'///+<li>12 = Combo box is not enabled</li>
'///+<li>13 = String to be selected doesn't exist in list box (if <i>optional</i> input parameter has been used)</li>
'///+<li>99 = Unexpected error</li></ul>

    dim iIndex as INTEGER
    dim iListLength as INTEGER
    dim bStringIsInList as BOOLEAN
    dim sStringinUI as STRING
    
        bStringIsInList = FALSE
        sStringinUI = ""
        
    'Only check Edit Field against list box if 'bVerifyAgainstEntries' is explizitly TRUE	
    if isMissing ( bVerifyAgainstEntries ) then
        bVerifyAgainstEntries = FALSE
    endif
    
    printlog "Setting text in Combo Box Edit field"
    'Check if desired combo box is visible
    if NOT oThisComboBox.IsVisible then
        qaErrorLog "Error 11: Combo box is not visible"
        fSetComboBoxByText = 11
        exit function
    endif
    'Check if desired combo box is enabled
    if NOT oThisComboBox.IsEnabled then
        qaErrorLog "Error 12: Combo box is not enabled"
        fSetComboBoxByText = 12
        exit function
    endif
    'Check if input value is existent in list entries (optinal if desired)
    if bVerifyAgainstEntries then
        iListLength = oThisComboBox.GetItemCount
        for iIndex = 1 to iListLength
            if oThisComboBox.GetItemText ( iIndex ) = sThisText then
                bStringIsInList = TRUE
            endif
        next iIndex
        if bStringIsInList then
            printlog "OK, string exists in list box control"
        else
            qaErrorLog "Error 13: Input string not found in list entries"
            fSetComboBoxByText = 13
            exit function
        endif
    endif
    'Trying to set text on combo box
    try 
        oThisComboBox.setText sThisText
    catch
        'Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Set text in combo box seems to cause a serious problem."
        fSetComboBoxByText = 1
        exit function
    endcatch
    'Verify (against input) if text was set correctly
    sStringinUI = oThisComboBox.GetSelText
    if sStringinUI = sThisText then
        fSetComboBoxByText = 0
        printlog "Setting text in Combo box works"
    else
        qaErrorLog "Error 2: Set text in Combo box failed."
        fSetComboBoxByText = 2
    endif

    if fSetComboBoxByText = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif  
end function
'
'--------------------------------------------------------------------
'
function fSetCheckBox ( oThisCheckBox as OBJECT , bCheck as BOOLEAN ) as INTEGER
         fSetCheckBox = 99
'///<u><b>Function to (un)check a check box</b></u>
'///Input:
'///+<ul><li><b>OBJECT oThisCheckBox</b> (check box name in declaration)</li>
'///+<li><b>BOOLEAN bCheck</b> (check or uncheck the check box control)</li></ul>
'///<b>Return (Error codes):</b>
'///+<ul><li> 0 = Sucess</li>
'///+<li> 1 = Serious problem trying to check the box</li>
'///+<li> 2 = Box was not checked</li>
'///+<li>11 = Check box is not visible</li>
'///+<li>12 = Check box is not enabled</li>
'///+<li>99 = Unexpected error</li></ul>

    printlog "Checking check box"
    'Check if desired check box is visible
    if NOT oThisCheckBox.IsVisible then
        qaErrorLog "Error 11: Check box is not visible"
        fSetCheckBox = 11
        exit function
    endif
    'Check if desired check box is enabled
    if NOT oThisCheckBox.IsEnabled then
        qaErrorLog "Error 12: Check box is not enabled"
        fSetCheckBox = 12
        exit function
    endif
    'Try to check check box control
    try 
        if bCheck then
            oThisCheckBox.Check
        else
            oThisCheckBox.Uncheck
        endif
    catch
        'Throw error 1 and quit on serious problem
        if bCheck then
            qaErrorLog "Error 1: Checking check box control cause into a serious problem."
        else
            qaErrorLog "Error 1: Unchecking check box control cause into a serious problem."
        endif
        fSetCheckBox = 1
        exit function
    endcatch
    'Verify (against input) if check box is checked
    if oThisCheckBox.IsChecked = bCheck then
        fSetCheckBox = 0
        printlog "Check check box seems to work"
    else
        qaErrorLog "Error 2: Check check box failed."
        fSetCheckBox = 2
    endif
    if fSetCheckBox = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif  
end function
'
'--------------------------------------------------------------------
'
function fSetRadioButton ( oThisRadioButton as OBJECT  ) as INTEGER
         fSetRadioButton = 99
'///<u><b>Function to check a radio button</b></u>
'///Input:
'///+<b>OBJECT oThisRadioButton</b> (radio button name in declaration)
'///<b>Return (Error codes):</b>
'///+<ul><li> 0 = Sucess</li>
'///+<li> 1 = Serious problem trying to check the radio button</li>
'///+<li> 2 = Radio button was not checked</li>
'///+<li>11 = Radio button is not visible</li>
'///+<li>12 := Radio button is not enabled</li>
'///+<li>99 := Unexpected error</li></ul>
    printlog "Checking radio button"
    'Check if desired radio button is visible
    if NOT oThisRadioButton.IsVisible then
        qaErrorLog "Error 11: Radio button is not visible"
        fSetRadioButton = 11
        exit function
    endif
    'Check if desired radio button is enabled
    if NOT oThisRadioButton.IsEnabled then
        qaErrorLog "Error 12: Radio button is not enabled"
        fSetRadioButton = 12
        exit function
    endif
    'Try to check Radio Button
    try 
        oThisRadioButton.Check
    catch
        'Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Check radio button seems to cause a serious problem."
        fSetRadioButton = 1
        exit function
    endcatch
    'Verify if radio button is checked
    if oThisRadioButton.IsChecked = TRUE then
        fSetRadioButton = 0
        printlog "Check radio button seems to work"
    else
        qaErrorLog "Error 2: Check radio button failed."
        fSetRadioButton = 2
    endif
    if fSetRadioButton = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif  
end function

