'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_001.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/01 12:54:53 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : thorsten.bosbach@sun.com
'*
'* short description : Global resource tests for the menu: File
'*
'*************************************************************************
'*
' #1 tFileExportAsPDF
' #1 tExportAsPDFButton
'*
'\************************************************************************

testcase tFileExportAsPDF
   dim sPDF as string
   dim sTemp as string

   sPDF = "PDF - Portable Document Format (.pdf)"

   '/// open application ///'
   Call hNewDocument

   '/// choose File->Export As PDF ... ///'
   FileExportAsPDF
      ' The file dialog has to come up
      Kontext "SpeichernDlg"
      if SpeichernDlg.exists(5) then
          '/// the selected file type should be: 'PDF - Portable Document Format (.pdf)' ///'
          sTemp = Dateityp.GetSelText
          if (sTemp <> sPDF) then
             Warnlog "filter for PDF export is missing :-( should: '" + sPDF + "'; is: '" + sTemp + "'"
          endif
          '///+ - set Textbox 'File name' to "abc" ///'
          Dateiname.SetText "abc"
          speichern.click
          kontext
          if active.exists(5) then
              ' catch active about already existing file name
              if active.getrt = 304 then
                  active.yes
              endif
          endif
      else
          warnlog "Export dialog didn't come up."
      endif
      kontext
      '/// dialog 'PDF Options' comes up ///'
      if active.exists(5) then
          '/// select the tab page 'General' ///'
          active.setPage PDFOptions
          kontext "PDFOptions"
          if PDFOptions.exists(5) then
              dialogTest(PDFOptions)
              try
                  '/// touch every control on the tab page ///'
                  ' Range
                  RangePages.check
                  RangePagesEdit.setText "1"
                  RangeAll.check
                  'RangeSelection disabled
                  ' Images
                  JpegCompression.check
                  ImagesQuality.gettext
                  LosslessCompression.check
                  ReduceImageResolution.check
                  ReduceImageResolutionDPI.getSelText
                  'General
                  TaggedPDF.check
                  ExportNotes.check
                  if lCase(gApplication) = "impress" then
                      TransitionEffects.check
                  endif
                  FormsFormat.getselText
                  if lCase(gApplication) = "writer" then
                      ExportBlankPages.check
                  endif
              catch
                  warnlog "Some control on Tab page 'PDF Options - General' caused an error"
              endcatch
          else
              warnlog "Tab page 'PDF Options - General' isn't available."
          endif
      else
          warnlog "Dialog 'PDF Options' didn't come up"
      endif
      kontext
      if active.exists(5) then
          '/// select the tab page 'Initial View' ///'
          active.setPage PDFOptionsInitialView
          kontext "PDFOptionsInitialView"
          if PDFOptionsInitialView.exists(5) then
              dialogTest(PDFOptionsInitialView)
              try
                  '/// touch every control on the tab page ///'
                  ' Panes
                  BookmarksAndPage.check
                  PageOnly.check
                  ThumbnailsAndPage.check
                  ' Magnification
                  FitInWindow.check
                  MagnificationDefault.check
                  FitWidth.check
                  FitVisible.check
                  ' Page layout
                  SinglePage.check
                  PageLayoutDefault.check
                  Continuous.check
                  ContinuousFacing.check
              catch
                  warnlog "Some control on Tab page 'PDF Options - Initial View' caused an error"
              endcatch
          else
              warnlog "Tab page 'PDF Options - Initial View' isn't available."
          endif
      endif
      kontext
      if active.exists(5) then
          '/// select the tab page 'User Interface' ///'
          active.setPage PDFOptionsUserInterface
          kontext "PDFOptionsUserInterface"
          if PDFOptionsUserInterface.exists(5) then
              dialogTest(PDFOptionsUserInterface)
              try
                  '/// touch every control on the tab page ///'
                  ' Window options
                  ResizeWindow.check
                  CenterWindow.check
                  OpenInFullscreen.check
                  DisplayDocumentTitle.check
                  ' User interface options
                  HideMenubar.check
                  HideToolbar.check
                  HideWindowControls.check
              catch
                  warnlog "Some control on Tab page 'PDF Options - User Interface' caused an error"
              endcatch
          else
              warnlog "Tab page 'PDF Options - User Interface' isn't available."
          endif
      endif
      kontext
      if active.exists(5) then
          '/// select the tab page 'General' ///'
          active.setPage PDFOptions
          kontext "PDFOptions"
          '/// close the dialog with 'Cancel' ///'
          if PDFOptions.exists(5) then
              PDFOptions.cancel
          else
              warnlog "Tab page 'PDF Options - General' isn't available."
          endif
      endif
   '/// close application ///'
   Call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tExportAsPDFButton
    Dim sTemp as string   
    '/// Create new document
    Call hNewDocument
        '/// Click the button 'Export Directly as PDF' on the standard toolbar.
        Kontext "Standardbar"
        ExportAsPDF.click
        '///  The 'Export as PDF' dialog has to come up, with the only 'File type' 'PDF - Portable Document Format'
        Kontext "SpeichernDlg"
        if SpeichernDlg.exists(1) then
            sTemp = Dateityp.GetSelText
            if InStr(sTemp, "PDF") = 0 then
                warnlog "Filter for PDF export seems to be wrong or is missing in selection."
            endif
            '/// Leave dialog with CANCEL button
            SpeichernDlg.Cancel
        else
            warnlog "SaveAsPDF dialog did not come up."
        endif
    '/// Close spreadsheet document.
    Call hCloseDocument
endcase

