'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_009.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2006/08/17 11:52:05 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : thorsten.bosbach@sun.com
'*
'* short description : Global resource tests for the menu: Help
'*
'*************************************************************************
'*
' #1 tHelpCheckForUpdates
'*
'\************************************************************************

testcase tHelpCheckForUpdates
   dim sTemp as string
   dim sIniFile as string

   if gPlatGroup = "w95" then
       qaErrorLog "#i66703# disabled on win32 because of freezing when used by TestTool"
       goto endsub
   endif
   
   '/// open application ///'
   Call hNewDocument

   if gPlatGroup = "unx" then
       sIniFile = convertPath(gNetzOfficePath+"program/versionrc")
   else
       sIniFile = convertPath(gNetzOfficePath+"program\version.ini")
   endif
   sTemp = GetIniValue (sIniFile, "Version", "UpdateURL")
   '/// choose Help -> Check for Updates... ///'
   try
       HelpCheckForUpdates
   catch
       if (gtplatform = "sol") OR (gtplatform = "x86") or gOOO then
           printlog "This could be a (patched) OOo installation on Solaris Sparc/Intel - No Online Update Feature available."
           hCloseDocument
       else
           if gplatgroup = "w95" then
               qaErrorLog "This is a win32 installation, where the feature failed"
               sleep 60
           else
               warnlog "Help->Check for Updates failed"
               hCloseDocument
           endif
       endif
       goto endsub
   endcatch
      ' The dialog has to come up: 'Check for Updates'
      Kontext "CheckForUpdates"
      if CheckForUpdates.exists(10) then
          if sTemp <> "" then
              printlog "'Check for Updates' came up"
          else
              warnlog "'Check for Updates' came up, but the feature is disabled and the dialog hasn't to come up"
          endif
          dialogTest(CheckForUpdates)
          '/// A messagebox comes up with either CANCEL and/or OK -> press CANCEL or the only available button. ///'
          ' And will be overlayed soon by an 'active'
          Kontext
          if active.exists(30) then
              printlog "Active text: '" + active.getText + "'"
              try
                  active.cancel
                  printlog "Pressed CANCEL"
              catch
                  active.ok
                  printlog "Pressed OK"
              endcatch
          else
              warnlog "No active came up within 30 seconds; But should've been some..."
              Kontext "CheckForUpdates"
              CheckForUpdates.cancel
          endif
      else
          if sTemp <> "" then
              if (gtplatform = "sol") OR (gtplatform = "x86") or gOOO then
                  printlog "This could be a (patched) OOo installation on Solaris Sparc/Intel - No Online Update Feature available."
              else
                  warnlog "Dialog didn't came up: 'Check for Updates'; URL that was called is: '" + sTemp + "'"
              endif
          else
              warnlog "Online Update Feature isn't available in this build? (no 'UpdateURL' in file: '"+sIniFile+"')"
          endif
      endif
   '/// close application ///'
   Call hCloseDocument
endcase

