'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_format.inc,v $
'*
'*  $Revision: 1.20 $
'*
'*  last change: $Author: fredrikh $ $Date: 2006/08/14 10:02:51 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description :
'*
'*******************************************************************
' #1 tiFormatText
' #1 tdFormatLayer
' #1 tdFormatConnector
' #1 tiFormatPositionAndSize
' #1 tiFormat3D_Effekte
' #1 tdFormatTemplates
' #1 tiFormatAufzaehlungszeichen
'\******************************************************************

        '      DateiName.SetText ConvertPath (gTesttoolPath + "global\input\graf_inp\baer.tif")

testcase tiFormatText
    Dim a as string
    Dim b as string
    Dim n as integer
    Dim i as integer
    Dim ZaehlerEffekt
    dim sTemp as string

    '/// open application ///'
    Call hNewDocument
    '/// create a textbox with text ///'
    Call hTextrahmenErstellen ("This is a text, which, I hope, in Staroffice, will be automaticly formatted. Should that not be the case, then it doesn't matter.",20,20,70,20)
    sleep 1
    '/// click outside of textbox, to leave edit mode of textbox and deselect it ///'
    gMouseClick 99,99
    '/// type key [TAB] to select textbox again ///'
    hTypeKeys "<TAB>"

    '/// Format->Position and Size ///'
    FormatPositionAndSize
        Kontext
        '/// select tabpage 'Format and Size' on dialog 'Position and Size' ///'
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        sleep 2
        '/// get and remember Position: 'Position X' ///'
        a = PositionX.GetText
        '/// close dialog 'Position and Size' with OK ///'
        TabPositionAndSize.OK

    '/// Format -> Text... ///'
    FormatTextDraw
        Kontext
        '/// select tabpage 'Text' ///'
        Active.SetPage TabText
        Kontext "TabText"
        '/// Check checkbox 'Fit width to text' ///'
        BreiteAnTextAnpassen.Check
        '/// leave dialog with OK ///'
        TabText.OK

    '/// Dialog should have been resized and moved now! ///'

    '/// Format->Position and Size ///'
    ContextPositionAndSize
        Kontext
        '/// select tabpage 'Format and Size' on dialog 'Position and Size' ///'
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        sleep 2
        '/// compare 'Position X' with saved value - has to be different ///'
        sTemp = PositionX.GetText
        if (sTemp <> a)  Then
            Printlog "  - Fit to frame does work"
        else
            warnlog "  - Fit to frame doesn't work: expected: '" + a + "' is: '" +  + "'"
        endif
        '/// get and remember Position: 'Position Y' ///'
        b=PositionY.GetText
        TabPositionAndSize.OK

    '/// Format -> Text... ///'
    FormatTextDraw
        Kontext
        '/// select tabpage 'Text' ///'
        Active.SetPage TabText
        Kontext "TabText"
        '/// UNCheck checkbox 'Fit width to text' ///'
        BreiteAnTextAnpassen.Uncheck
        '/// check checkbox 'Fit height to text' ///'
        HoeheAnTextAnpassen.Check
        '/// if checkbox 'Fit to frame' is enabled: this state only happens, if 'Fit height to text' and 'Fit width to text' are checked ///'
        if AmRahmenAnpassen.IsEnabled Then
            WarnLog "  - checkbox 'Fit to frame' is enabled, which is wrong!"
        else
            PrintLog "  - checkbox 'Fit to frame' is disabled."
        end if
        sleep 1
        '/// UNcheck checkbox 'Fit height to text' ///'
        HoeheAnTextAnpassen.UnCheck
        '/// UNCheck checkbox 'Fit width to text' ///'
        BreiteAnTextAnpassen.UnCheck
        '/// if checkbox 'Fit to frame' is disabled: this state only happens, if 'Fit height to text' and/or 'Fit width to text' are checked ///'
        if AmRahmenAnpassen.IsEnabled Then
            PrintLog "  - checkbox 'Fit to frame' is enabled."
        else
            WarnLog "  - checkbox 'Fit to frame' is disabled, which is wrong!"
        end if
'        PrintLog "Full width: " + GanzeBreite.IsChecked
        '/// set metric field 'Left' to 10 ///'
        Links.SetText "10"
        '/// set metric field 'Right' to 10 ///'
        Rechts.SetText "10"
        '/// set metric field 'Top' to 10 ///'
        Oben.SetText "10"
        '/// set metric field 'Bottom' to 10 ///'
        Unten.SetText "10"
        '/// leave dialog with OK ///'
        TabText.OK

    '/// Edit -> Select All ///'
    EditSelectAll
    '/// type Keys [Strg]+[x] to cut object ///'
    hTypeKeys "<MOD1 X>"
    '/// No object exists in dokument right now! ///'
    '/// Format -> Text... ///'
    FormatTextDraw
        Kontext
        '/// select tabpage 'Text' ///'
        Active.SetPage TabText
        Kontext "TabText"
        '/// check checkbox 'Adjust to contour' ///'
        Konturfluss.Check
        '/// now every other control on the dialog has to get disabled ///'
        if ((AmRahmenAnpassen.IsEnabled=False) And (Links.IsEnabled=False) And (Rechts.IsEnabled=False) And (Oben.IsEnabled=False) And (Unten.IsEnabled =False)) Then
            PrintLog "  - Adjust to contour is working"
        else
            WarnLog "  - contourflow aktivated doesn't work it's supposed to"
        end if
        '/// leave dialog with OK ///'
        TabText.OK

    '/// create a textbox with text ///'
    Call hTextrahmenErstellen ("blablablablablablablablablablablabla",20,20,60,60)
    sleep 5
    '/// Format -> Text... ///'
    FormatTextDraw
        Kontext
        '/// select tabpage 'Text Animation' ///'
        Active.SetPage TabLauftext
        Kontext "TabLauftext"

        ZaehlerEffekt = Effekt.GetItemCount
        if (ZaehlerEffekt <> 5) then
            qaerrorlog "There are now more or less than 5 Effects - Change testcase! " + ZaehlerEffekt
        endif
        for n=1 to ZaehlerEffekt
            Effekt.Select n
            printlog "" + n + ": '" + Effekt.getSelText + "' -------------------------------"
            if (n > 2) then
                '/// test all directions ///'
                for i = 1 to 4
                    printlog "" + i
                    select case i
                        case 1: NachOben.click
                        case 2: NachLinks.click
                        case 3: NachRechts.click
                        case 4: NachUnten.click
                    end select
                    sFormatTextDrawAnimation
                next i
            endif
            if ((n > 1) AND (n < 5)) then
                '/// test all Start/End Text visibility ///'
                for i = 1 to 4
                    printlog "" + i
                    select case i
                        case 1: TextSichtbarBeimStarten.check : TextSichtbarBeimBeenden.uncheck
                        case 2: TextSichtbarBeimBeenden.check
                        case 3: TextSichtbarBeimStarten.uncheck
                        case 4: TextSichtbarBeimBeenden.uncheck
                    end select
                    sFormatTextDrawAnimation
                next i
            endif
            if ((n > 1) AND (n < 5)) then
                '/// test all Animation cycles ///'
                for i = 1 to 3
                    printlog "" + i
                    select case i
                        case 1: Endlos.check
                        case 2: Endlos.UnCheck : Anzahl.typeKeys ("<PageUp>")
                        case 3: Anzahl.setText ("1")
                    end select
                    sFormatTextDrawAnimation
                next i
            endif
            if (n > 2) then
                '/// test all Increment ///'
                for i = 1 to 4
                    printlog "" + i
                    select case i
                        case 1: Pixel.check : Schrittweite.setText("1")
                        case 2: qaerrorlog "#114551# Loop, if Step greater than object size"
                                 ' Schrittweite.typeKeys ("<PageUp>")
                        case 3: Pixel.UnCheck : Schrittweite.typeKeys ("<PageDown>")
                        case 4: qaerrorlog "#114551# Loop, if Step greater than object size"
                                ' Schrittweite.typeKeys ("<PageUp>")
                    end select
                    sFormatTextDrawAnimation
                next i
            endif
            if (n > 1) then
                '/// test all Delay ///'
                for i = 1 to 3
                    printlog "" + i
                    select case i
                        case 1: Automatisch.check
                        case 2: Automatisch.UnCheck : Verzoegerung.setText("1")
                        case 3: Verzoegerung.typeKeys ("<PageUp>")
                    end select
                    sFormatTextDrawAnimation
                next i
            endif
        next n
        TabLauftext.OK
    Call hCloseDocument
endcase

sub sFormatTextDrawAnimation
    TabLauftext.OK
    sleep 3
    gMouseClick 99,99
    sleep 3
    hTypeKeys("<Tab>")
    sleep 1
    hTypeKeys("<F2>")
    sleep 1
    FormatTextDraw
    Kontext
    Active.SetPage TabLauftext
    Kontext "TabLauftext"
end sub

testcase tdFormatLayer
    '/// open application ///'
    Call hNewDocument

    '/// Edit->Layer->Insert (in DRAW also via Insert->Layer) ///'
    InsertLayer
        Kontext "EbeneEinfuegenDlg"
        EbenenName.SetText " Test 4"
        EbeneEinfuegenDlg.OK

    '/// Edit->Layer->Modify (in DRAW also via Format->Layer)///'
    FormatLayer
        Kontext "EbeneAendernDlg"
        if EbenenName.GetText = "Test 4" Then EbenenName.SetText "Ebene 5"
        Sichtbar.Check
        Druckbar.Check
        Gesperrt.Check
        EbeneAendernDlg.OK

    '/// Edit->Layer->Modify (in DRAW also via Format->Layer)///'
    FormatLayer
        Kontext "EbeneAendernDlg"
        if EbenenName.GetText="Ebene 5" Then WarnLog " Value changed: name"
        if Sichtbar.IsChecked=False Then WarnLog " Value changed: visible"
        if Druckbar.IsChecked=False Then WarnLog " Value changed: printable"
        if Gesperrt.IsChecked=False then WarnLog " Value changed: locked"
        EbeneAendernDlg.OK

    '/// close application ///'
    Call hCloseDocument
endcase

testcase tdFormatConnector
    Dim Zaehler as integer
    Dim i as integer
    dim sUnit as string
    dim sTemp as string
    dim cDecSep as string


    Call hNewDocument
    '/// insert connector ///

         kontext "Toolbar"
         sleep 1
            try
               Verbinder.TearOff  ' insert connector
            catch
               warnlog "bug for GH from TBO; .tearoff doesn't tell success"
            endcatch

    kontext "Connectorsbar"
    Verbinder.click
    gMouseMove ( 10,10,30,30)

    Call hCloseDocument
    '/// Open file with a finished scenario ///'
    if (lcase(gApplication) = "impress") then
       hDateiOeffnen  ConvertPath (gTesttoolPath + "graphics\level1\input\FormatConnector.odp")
    else
       hDateiOeffnen  ConvertPath (gTesttoolPath + "graphics\level1\input\FormatConnector.odg")
    endif

    ' Check if the document is writable
    if fIsDocumentWritable = false then
        ' Make the document writable and check if it's succesfull
        if fMakeDocumentWritable = false then
            warnlog "The document can't be make writeable. Test stopped."
            goto endsub
        endif
    endif
    gMouseClick 1,1

    '/// Press TAB three times to select the connector. ///'
    hTypekeys "<TAB>"
    hTypekeys "<TAB>"
    hTypekeys "<TAB>"

    sleep 1
    hOpenContextMenu  ' FormatConnector
    sleep 3
    hMenuSelectNr(2)  ' Connector

    Kontext "Verbinder"
        Typ.Select 2 ' the one with 2 from 3 posibilities to set a value...
        AnfangHorizontal.SetText "1"
        AnfangVertikal.SetText "1"
        EndeHorizontal.SetText "1"
        EndeVertikal.SetText "1"
        printlog EndeVertikal.getText
        try
            Linie1.SetText "10"
            sTemp = Linie1.getText
            sUnit = GetMeasUnit(sTemp)
            cDecSep = GetDecimalSeperator(sTemp)
        catch
            PrintLog "  Lineoffset not activated -> you have to choose another linetype: 1"
        endcatch
        try
            Linie2.SetText "10"
        catch
            PrintLog "  Lineoffset not activated -> you have to choose another linetype: 2"
        endcatch
        try
            Linie3.SetText "10"
        catch
            PrintLog "  Lineoffset not activated -> you have to choose another linetype: 3 when will this be enabled ?"
        endcatch
    Verbinder.OK

    FormatConnector
        Kontext "Verbinder"
        sTemp = AnfangHorizontal.GetText

        if fCompareTwoValues(sTemp, "1"+cDecSep+"00"+sUnit) Then
            WarnLog "  value not changed"
            printlog "AnfangHorizontal = is '" + sTemp + "' should: '"+"1"+cDecSep+"00"+sUnit+"'"
        endif
        if fCompareTwoValues(AnfangVertikal.GetText, "1"+cDecSep+"00"+sUnit) Then
            WarnLog "  value not changed"
            printlog "AnfangVertikal.GetText = " + AnfangVertikal.GetText
        endif
        if fCompareTwoValues(EndeHorizontal.GetText, "1"+cDecSep+"00"+sUnit) Then
            WarnLog "  value not changed"
            printlog "EndeHorizontal.GetText = " + EndeHorizontal.GetText
        endif
        if fCompareTwoValues(EndeVertikal.GetText, "1"+cDecSep+"00"+sUnit) Then
            WarnLog "  value not changed"
            printlog "EndeHorizontal.GetText = " + EndeHorizontal.GetText
        endif

        Zaehler = Typ.GetItemCount
        for i = 1 to Zaehler
            Typ.Select i
            SetClipboard Typ.GetSelText
            Verbinder.OK
            FormatConnector
            Kontext "Verbinder"
            if GetClipboardText <> Typ.GetSelText Then WarnLog "  Selection not saved"
        next i
    Verbinder.OK
    Call hCloseDocument
endcase

function fCompareTwoValues(a as string, b as string) as boolean
    dim c as boolean

    c = val(str(StrToDouble(a))) <> val(str(StrToDouble(b)))
    c = c AND (GetMeasUnit(a) <> GetMeasUnit(b))
    fCompareTwoValues = c
end function

testcase tiFormatPositionAndSize
    Dim x      'Variable fuer PositionX
    Dim y      'Variable fuer PositionY
    Dim h      'Variable fuer Hoehe
    Dim b      'Variable fuer Breite
    Dim r      'Variable fuer Radius
    Dim w      'Variable fuer Winkel

    Call hNewDocument                  '/// New Impress document ///'
    sleep 3
    '-----------------------------RECTANGLER-----1/2------------------------------------------------
    Call hRechteckErstellen (20,20,70,30)          '/// create rectangle ///'
    sleep 1
    gMouseClick 50,25
    sleep 1
    ContextPositionAndSize                '/// Format-position and size ///'
        sleep 1
        Kontext
        Active.SetPage TabPositionAndSize                '/// TabPositionAndSize ///'
        Kontext "TabPositionAndSize"
        SetClipboard (PositionX.GetText + PositionY.GetText)  '/// put x and y position into clipboard ///'
        TabPositionAndSize.OK
    sleep 2
    hTypeKeys "<DOWN>",30         '/// move rectangle down and right ///'
    hTypeKeys "<RIGHT>",30
    ContextPositionAndSize                '/// open PositionAndSize///'
        sleep 1
        Kontext
        Active.SetPage TabPositionAndSize                '/// TabPositionAndSize ///'
        Kontext "TabPositionAndSize"
        if (PositionX.GetText + PositionY.GetText) = GetClipboardText Then WarnLog "Der Dialog hat die Positionsaenderung nicht registriert"          '/// control position changes with clipboard content ///'
        PositionX.SetText "2"                 '/// set position of rectange using the edit fields ///'
        x=PositionX.GetText
        PositionY.SetText "2"
        y=PositionY.GetText
        ProtectPosition.Check                   '/// check protect ///'
        TabPositionAndSize.OK
    sleep 1
    ContextPositionAndSize
        sleep 1
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        if PositionX.GetText = x And PositionY.GetText = y Then PrintLog " Values could be changed"  '/// check if values are correct ///'
        if PositionX.GetText<> x Then                                   '/// check if protect works ///'
            WarnLog "Protect does not work"
        else
            PrintLog "  Protext works, X axis checked"
        end if
        if PositionY.GetText<> y Then
            WarnLog "Protect does not work"
        else
            PrintLog "  Protext does work, checked y axis"
        end if
        ProtectPosition.UnCheck                                         '/// uncheck protect ///'
        TabPositionAndSize.OK
    sleep 1
    ContextPositionAndSize
        sleep 1
        Kontext
        Active.SetPage TabPositionAndSize                             '/// TabPositionAndSize ///'
        Kontext "TabPositionAndSize"
        Width.SetText "10"                                   '/// set widh to 10///'
        b=Width.GetText                                  '/// put value into a variable///'
        SetClipboard Width.GetText
        Height.SetText "5"                                 '/// set heigth to 5///'
        h=Height.GetText                                   '/// put value into variable ///'
        ProtectPosition.Check                                   '/// check protect ///'
        TabPositionAndSize.OK                                     '/// close dialog ///'
    sleep 1
    ContextPositionAndSize
        sleep 1
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        sleep 2
        if Width.GetText = GetClipboardText Then                     '/// control size changes ///'
            PrintLog "  Size of rectangle could be changed. It is = " + Width.GetText + "   but it should be = " + b
        else
            WarnLog "  Controls for height and width do not work"
        end if
        '/// Uncheck the "Position-Protection", so we can work with this window. ///'
        if ProtectPosition.isChecked = FALSE then
           ErrorLog "ProtectPosition was not checked - why?"   '/// Should be checked since it was checked just 16 rows ago ///'
        else
           ProtectPosition.Uncheck
        endif

        KeepRatio.Check
        Width.More 5                                     '/// raise value for width ///'
        if Height.GetText = h Then
        WarnLog "  Keep ratio does not work properly"
        else
        PrintLog "  Keep ratio does work"
        KeepRatio.UnCheck
        end if
        TabPositionAndSize.OK
    sleep 2
    gMouseClick 90,90
    sleep 1
    '-----------------------------TEXT-----------------------------------------------------
    Call hTextrahmenErstellen ("Never before have I written such a meaning" ,10,10,60,20) '/// create textbox ///'
    sleep 2
    FormatPositionAndSize                                 '/// Format-Postion and Size ///'
        sleep 1
        Kontext
        Active.SetPage TabPositionAndSize                             '/// TabPositionAndSize ///'
        Kontext "TabPositionAndSize"
        printlog "default value ?: width :-----"+Width.IsEnabled
        if Width.IsEnabled then FitWidthText.Check                                    '/// check fit width to text ///'
        if Width.IsEnabled = True Then
            WarnLog "  Fit width does not work"
        else
            PrintLog "  Fit width does work"
        end if
        FitHeightText.Check                                 '/// fit heigth to text ///'
        if Height.IsEnabled = True Then
            WarnLog "  fit heigth doe not work"
        else
            PrintLog "  fit heigth does work"
        end if
        '   PrintLog "  Fit width to text active:   " + FitWidthText.IsChecked
        '   PrintLog "  Fit heigth to text active:   " + FitHeightText.IsChecked
        FitWidthText.UnCheck                                 '/// uncheck fit width to text ///'
        FitHeightText.Uncheck                                  '/// uncheck fit heigth to text ///'
        TabPositionAndSize.OK
    sleep 1
    hTypeKeys "<escape>",2
    hTypeKeys "<TAB>",2
    sleep 1
    ContextPositionAndSize
        sleep 1
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        SetClipboard PositionX.GetText                            '/// check x-position of textbox ///'
        sleep 1
        Kontext
        Active.SetPage TabDrehung                             '/// set rotation angle to 50 and position x and y to 1///'
        Kontext "TabDrehung"
        PositionX.SetText "1"
        PositionY.SetText "1"
        Winkel.SetText "50"
        w=Winkel.GetText
        TabDrehung.OK
    sleep 3

    ContextPositionAndSize                                '/// check position of manipulated textbox ///'
        sleep 3
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        if PositionX = GetClipboardText Then PrintLog "  Position changed due to rotation"
        Kontext
        Active.SetPage TabDrehung
        Kontext "TabDrehung"
        sleep 1
        if Winkel.GetText = w Then PrintLog "  Object rotated"           '/// check rotation angle ///'
        TabDrehung.OK

    '-----------------------------RECTANGLER-----2/2------------------------------------------------
    Call hRechteckErstellen (10,60,70,90)                         '/// create rectangle ///'
    sleep 1
    '  gMouseClick 55,55
    sleep 1
    ContextPositionAndSize
        sleep 1
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        SetClipboard PositionX.GetText                            '/// put x-axis postion of rectangle into clipboard///'
        Kontext
        Active.SetPage TabSchraegstellen                          '/// set slant angle to 5///'
        Kontext "TabSchraegstellen"
        sleep 1
        Radius.SetText "5"                                    '/// set radius to 5 ///'
        r=Radius.GetText
        Winkel.SetText w
        TabSchraegstellen.OK
    sleep 1
    ContextPositionAndSize
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        if PositionX <> GetClipboardText Then PrintLog "  Object changed position due to scaling"
        '/// Before we change tab, we set the Position-marker back to checked ///'
        ProtectPosition.Check
        Kontext
        Active.SetPage TabSchraegstellen                          '/// check slant angle and radius ///'
        Kontext "TabSchraegstellen"
        if Radius.GetText = r Then PrintLog "  Cornwer radius changed"
        if Winkel.GetText =w Then PrintLog "  Object rotated over 45°"
        TabSchraegstellen.OK
    Call hCloseDocument
endcase

testcase tiFormat3D_Effekte
    Dim Hor  as string
    Dim Vert  as string
    Dim Rund  as string
    Dim Skal  as string
    Dim Tief  as string
    Dim Winkel  as string                       '/// get value for angle ///'
'    dim Vertikal%
    Dim X as string
    Dim y as integer
    Dim i as integer
    Dim Zaehler as integer
    Dim Posi as string

    Call hNewDocument                              '/// new document ///'
    '-----------------------------------RECTANGLE------------------------------------------------------
    Call hRechteckErstellen (20,20,60,70)         '/// create rectangle ///'
    sleep 1
    ContextPositionAndSize                        '/// get position and size of rectangle ///'
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        X=PositionX.GetText
        printlog "--- created RECTANGLE; xPosition @ "+ x
        TabPositionAndSize.OK
    ContextConvertInto3D                          '/// convert rectangle into 3d ///'
    sleep 1
    Format3D_Effects                          '/// open 3d flyer///'
        Kontext "Drei_D_Effekte"
        try
            if Perspektive.isvisible then
                Perspektive.Click                         '/// check perspective ///'
            else
                warnlog "why not in draw?"
            endif
        catch
            warnlog "something is wrong mit perspective"
        endcatch
        Zuweisen.Click                            '/// assign perspective ///'
        Kontext "DocumentImpress"
        gMouseClick 40,40
        ContextPositionAndSize                        '/// check position and size ///'
            Kontext
            Active.SetPage TabPositionAndSize
            Kontext "TabPositionAndSize"
            if PositionX.GetText = X Then
            Warnlog "- Perspective not acitvated x: "+PositionX.GetText
            else
            Printlog "- Perspective seems to work"
            end if
            TabPositionAndSize.OK
        Kontext "Drei_D_Effekte"
        Aktualisieren.Click
        Drei_D_Effekte.Close
    EditSelectAll                   '/// delete rectangle ///'
    hTypeKeys "<DELETE>"

    '-----------------------------------RECTANGLE------------------------------------------------------
    hRechteckErstellen (20,20,60,70)              '/// create new rectangle ///'
    printlog "--- created RECTANGLE 2"
    Format3D_Effects                              '/// open 3d flyer ///'
    Kontext "Drei_D_Effekte"
    Rotationskoerper.Click                        '/// create lathe object ///'
    sleep 1
    Kontext "DocumentImpress"
    ContextPositionAndSize                        '/// check position and size ///'
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        if PositionX.GetText = X Then
            Warnlog "- Rectangle not converted into a lath object; x: "+PositionX.GetText
        else
            Printlog "- Creating a lath object seems to work"
        end if
        TabPositionAndSize.OK
    EditSelectAll
    hTypeKeys "<DELETE>"                         '/// delete object ///'
    sleep 1
    '-----------------------------------RECTANGLE------------------------------------------------------
    hRechteckErstellen (20,20,60,70)             '/// create rectangle ///'
    printlog "--- created RECTANGLE 3"
    Kontext "Drei_D_Effekte"
    sleep 1
    In_3D_Umwandeln.Click                        '/// convert to 3d in 3d flyer ///'
    sleep 2
    gMouseClick 40,40
    hOpenContextmenu
    y = hMenuItemGetCount
    MenuSelect (0) 'TODO FHA: Workaround: When bug no: i68585 is fixed, remove this line.
    gMouseClick 90,90
    if y = 18 Then Warnlog "- Create 3d object does not work; x: " + PositionX.GetText
    if y = 14 Then Printlog "- 3D object created"
'    ContextPositionAndSize                        '/// check changes using position and size of object ///'
'        Kontext
'        Active.SetPage TabPositionAndSize
'        Kontext "TabPositionAndSize"
'        if PositionX.GetText = X Then
'            Warnlog "- Create 3d object does not work; x: " + PositionX.GetText
'        else
'            Printlog "- 3D object created"
'        end if
'        TabPositionAndSize.OK
    EditSelectAll
    hTypeKeys "<DELETE>"                        '/// delete object ///'

    '-----------------------------------ZYLINDER------------------------------------------------------
    sleep 1
    printlog "--- create CYLINDER"
    WL_SD_Zylinder                              '/// create cylinder ///'
    gMousemove 30,30,80,80  '/// This affects the Vertical-value down to 15 ///'
    sleep 1
    hTypeKeys "<ESC>"
    Kontext "Drei_D_Effekte"
    Geometrie.Click                              '///  geometry ///'
    sleep 1
    '   Endwinkel.More
    Vert=Vertikale_Segmente.GetText             '/// get value for vertical segments (default) ///'
    Hor =Horizontale_Segmente.GetText           '/// get value for horizontal segments (default) ///'
    Rund=Kantenrundung.GetText                  '/// get value for edge rounding ///'
    Skal=Tiefenskalierung.GetText               '/// get value for scale ///'
    Tief=Tiefe.GetText                          '/// get value for depth ///'
    Winkel=Endwinkel.GetText                    '/// get value for angle ///'

    '/// Check if every entry has a value <> "" -> an init value is shown. ///'
    if Vert  ="" then warnlog "Vertical Segment   has no init value"
    if Hor   ="" then warnlog "Horizontal Segment has no init value"
    if Rund  ="" then warnlog "Rounded edges      has no init value"
    if Skal  ="" then warnlog "Scaled depth       has no init value"
    if Tief  ="" then warnlog "Depth              has no init value"
    if Winkel="" then printlog "Rotation angle    has no init value"

    '/// Go back to the 3d-effects-dialogue and change the value for the cylinder ///'

    hTypeKeys "<ESC>"                 '/// Deselect object and check if 3d controller has default values again ///'
    Kontext "Drei_D_Effekte"

    '/// Check if value for vertical segments has changed in 3d controller ///'
    if Vertikale_Segmente.GetText = Vert Then
        Printlog "- Vertical segment value read from object's properties in the 3d flyer"
    else
        Warnlog "- 3D flyer could not read vertical segment information from object. It is = '"+ Vertikale_Segmente.GetText + "'  but should be = '" + Vert + "'"
    end if

    if Horizontale_Segmente.GetText = Hor Then          '/// check if value for horizontal segments has changed ///'
        Printlog "- Horizontal segment value read from object's properties in the 3d flyer"
    else
        Warnlog "- 3D flyer not be able to read horizonal segment information from object. It is = '"+ Horizontale_Segmente.GetText + "'  but should be = '" + Hor + "'"
    end if

    if Kantenrundung.GetText = Rund Then                '/// check if value for edge rounding has changed ///'
        Printlog "- Rounded edges works"
    else
        Warnlog "- Rounded edges value could not be read by the 3d flyer It is = '" + Kantenrundung.GetText + "'  but should be = '" + rund + "'"
    end if

    if Tiefenskalierung.GetText = Skal Then             '/// check value for scale ///'
        Printlog "- Scaled depth works"
    else
        Warnlog "- Scale depth value could not be read by the 3d flyer It is = '" + Tiefenskalierung.GetText + "'  but should be = '" + skal + "'"
    end if

    if Tiefe.GetText = Tief Then                        '/// check value for depth ///'
        Printlog "- Depth value could be read by the 3d flyer"
    else
        Warnlog "- Depth value of object could not be read by the flyer It is = '"+ Tiefe.GetText + "'  but should be = '" + tief + "'"
    end if

    if Endwinkel.GetText = Winkel Then                   '/// check value for angle ///'
        Printlog "- Angle value could be read by the 3d flyer"
    else
        Warnlog "- Angle value is not correct"
    end if

    hTypeKeys "<ESC>"                                    '/// deselect object and check if 3d controller has default values again ///'
    Kontext "Drei_D_Effekte"
    sleep 2
    Printlog "- check if 3D flyer goes back to default values if object is deselected"
    if Vertikale_Segmente.GetText <> Vert Then 	Warnlog " Vertical Segment   - Default value is wrong is: "+Vertikale_Segmente.GetText+"; should: " +vert
    if Horizontale_Segmente.GetText <> Hor Then 	Warnlog " Horizontal Segment - Default value is wrong"
    if Kantenrundung.GetText <> Rund Then 		Warnlog " Rounded edges        - Default value is wrong"
    if Tiefenskalierung.GetText <> Skal Then 		Warnlog " Scaled depth     - Default value is wrong"
    if Endwinkel.GetText <> Winkel Then 		Warnlog " Rotation angle            - Default value is wrong"
    if Tiefe.GetText<>Tief Then 			Warnlog " Depth                - Default value is wrong"

    hTypeKeys "<TAB>"
    Kontext "Drei_D_Effekte"
        sleep 2
        Horizontale_Segmente.SetText "32"                  '/// change horizontal and vertical segments ///'
        Vertikale_Segmente.SetText "32"
        Kantenrundung.SetText "100"
        Endwinkel.Settext "300"
        Tiefenskalierung.SetText "500"
        Tiefe.SetText "100"
        Zuweisen.Click                                     '/// assign changes ///'

    sleep 1                                            '/// check value changes ///'
    if Vertikale_Segmente.GetText = Vert Then Warnlog "- Default value is wrong"
    if Horizontale_Segmente.GetText = Hor Then Warnlog "- Default value is wrong"
    if Kantenrundung.GetText = Rund Then Warnlog "- Default value is wrong"
    if Tiefenskalierung.GetText = Skal Then Warnlog "- Default value is wrong"
    if Endwinkel.GetText = Winkel Then Warnlog "- Default value is wrong"
    if Tiefe.GetText=Tief Then Warnlog "- Default value is wrong"
    EditSelectAll
    hTypeKeys "<DELETE>"                               '/// delete cylinder ///'

    '-----------------------------------ZYLINDER------------------------------------------------------
    WL_SD_Zylinder                                     '/// create new cylinder ///'
    gMouseMove (20,20,60,60)
    sleep 3                                            ' check if default values are correct for a standard cylinder ///'
    Kontext "Drei_D_Effekte"
    '     Printlog "- check default valueus for a cylinder"
    '      if Horizontale_Segmente.GetText <>"24" Then Warnlog "- Horizontal segment number is not correct. should: 24 Is: "+ Horizontale_Segmente.GetText
    '      if Vertikale_Segmente.GetText <> "16" Then Warnlog "- Vertical segment number is not correct. should: 16 Is: "+ Vertikale_Segmente.GetText
    '      if Kantenrundung.GetText <>"10 %" Then Warnlog "- Rounded edges should be enabled for lathe objects. should: 10 % Is: "+Kantenrundung.GetText
    '      if Endwinkel.GetText <> "360,0 Ôö¼Ôûæ" or Endwinkel.GetText <>"360.0 Ôö¼Ôûæ" Then Warnlog "- for a lathe object Agnel should be enabled. should: 360,.0 Ôö¼Ôûæ  Is: "+Endwinkel.GetText
    '      if Tiefe.GetText <> "" Then Warnlog "- This function is only avaiable for Extrusionobjects. should:  Is: "+Tiefe.GetText
        Printlog "- Change basic geometric parameters for the object"
        Printlog "Segments : Horizontal: 8; Vertical: 8; Rounded edges: 50 %"
        sleep 3
        Horizontale_Segmente.SetText "8"                   '/// changing values for cylinder ///'
        Vertikale_Segmente.SetText "8"
        Kantenrundung.SetText "50 %"
        sleep 1
        Zuweisen.Click
    sleep 2
    gMouseClick 90,90
    sleep 1
    EditSelectAll                                    '/// select object ///'
    sleep 1
    Kontext "Drei_D_Effekte"                       '/// control if changes are done ///'
        if Horizontale_Segmente.GetText <> "8" Then Warnlog "- Horizontal segment count is not correct "+Horizontale_Segmente.GetText
        if Vertikale_Segmente.GetText <> "8" Then Warnlog "- Vertical segment count is not correct "+Vertikale_Segmente.GetText
        if Kantenrundung.GetText <> "50 %" Then Warnlog "- Value for rounded edges is not correct "+Kantenrundung.GetText
    Darstellung.Click
    Zaehler=Modus.GetItemCount                  '/// get number of pssibole render methods ///'
    for i =1 to Zaehler
        Modus.Select i
        Zuweisen.Click                        '/// assign every render method ///'
        gMouseClick 90,90
        sleep 1
        EditSelectAll                                    '/// select object ///'
        sleep 1
        Kontext "Drei_D_Effekte"
        if Modus.GetSelIndex <> i Then Warnlog "- Value for render modus did not change"   '/// check if render method has changed ///'
    next i
        Printlog "- Check 3d shadow and surface angle"
        Drei_DSchatten.Click                              '/// check 3d shadow ///'
        Papierneigung.SetText "90"
        vert = Papierneigung.getText
        Zuweisen.Click                                    '/// assign shadow ///'
    gMouseClick 90,90                                     '/// deselect object ///'
    sleep 1
    EditSelectAll                                  '/// select object ///'
    Kontext "Drei_D_Effekte"
        if Papierneigung.GetText <> vert Then Warnlog "- Value for surface angle is not correct"   '/// check value changes ///'
        Entfernung.SetText "10"                             '/// set distance to 10///'
        sleep 1
        hor = Entfernung.getText
        sleep 1
	Zuweisen.Click
    if Entfernung.GetText <> hor Then Warnlog "- Value for distance is not correct; should: "+hor+"; is: "+Entfernung.GetText
    sleep 2
    hTypeKeys "<TAB>"
    sleep 2
    ContextPositionAndSize
        sleep 2
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        Posi=PositionX.GetText
        TabPositionAndSize.OK
    sleep 1
    Kontext "Drei_D_Effekte"
    sleep 1

    Brennweite.SetText "50"                             '/// set focval length to 50 ///'
    Zuweisen.Click
    ContextPositionAndSize                            '/// check change in position of the object ///'
        Kontext
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        If PositionX.GetText = Posi Then Warnlog "- Raising value for focal length has not changed optical appearence of object"
        TabPositionAndSize.OK
    sleep 1
    Kontext "Drei_D_Effekte"
        Brennweite.SetText "5"
        Zuweisen.Click
    sleep 1
    EditSelectAll
    sleep 3
    ContextPositionAndSize
        sleep 1
        Kontext
        sleep 2
        Active.SetPage TabPositionAndSize
        Kontext "TabPositionAndSize"
        sleep 2
        if PositionX.GetText = Posi Then Warnlog "- Lowering focus length value has not changed optical appearence of object"
        TabPositionAndSize.OK
    Kontext "Drei_D_Effekte"
    '/// close document ///'
    Drei_D_Effekte.Close
    Call hCloseDocument
endcase

'------------------------------------------------------------------
testcase tdFormatTemplates
 dim Zaehler
 dim i,x as integer
 dim sStyleName as string
 dim bDouble as boolean
 dim sTemp(2) as string

 Call hNewDocument               '/// new impress document ///'

   sleep 5
 FormatStylesCatalog             '/// format-Style catalog///'
   sleep 10

 Kontext "Vorlagenkatalog"
 Vorlagen.GetItemCount                             '/// get item count for templates ///'
  Vorlagen.Select 2              '/// select template 2 ///'

 if Bereich.GetItemCount = Vorlagen.GetItemCount Then    '/// check if area changes when selecting a template ///'
   PrintLog " - Area did changed"
 else
   WarnLog " Number of entrees should be 2, but it is " + Bereich.GetItemCount
 end if

 Zaehler = Ansicht.GetItemCount              'Vorlagenliste.GetItemCount

 for i = 1 to Zaehler
   Ansicht.TypeKeys "<DOWN>" ,i
   SetClipboard Ansicht.GetSelText
    sleep 2
   Vorlagen.Select 1
   PrintLog   "    "+i+": Offset: '" + Vorlagen.GetSelText+"'"
   if Bereich.GetItemCount=Vorlagen.GetItemCount Then WarnLog " Range has not changed"
   Vorlagen.Select 2
    sleep 1
    Ansicht.TypeKeys "<HOME>"
   sleep 1
   Ansicht.Select 1
   sleep 1
   PrintLog "     : Offset: '"+Vorlagen.GetSelText + "'; Opinion: '" + Ansicht.GetSelText+"'"
   Vorlagenkatalog.OK
   FormatStylesCatalog
   Kontext "Vorlagenkatalog"
 next i

 Vorlagen.Select 2
 sleep 2
 Vorlagen.Select 1                  '/// select first template ///'
 if Neu.IsEnabled =False Then WarnLog " Button must be choosable, but is not"
 Ansicht.Select 1
 sleep 1
 Neu.Click                    '/// create new template ///'
   Kontext
   Active.SetPage TabVerwalten
   Kontext "TabVerwalten"
   sStyleName = VorlagenName.GetText
   printlog "   created new style: '"+sStyleName +"'"
 TabVerwalten.OK
   PrintLog " New template created"
 Kontext "Vorlagenkatalog"
 sleep 1
 ' find newly created style, because they are alphabetical ordered :-( i have to check every entry :-(((((
   Zaehler = Ansicht.GetItemCount
   i=1
   Ansicht.TypeKeys "<home>"
   bDouble = false
   sTemp(1) = Ansicht.GetText
   while (sTemp(1) <> sStyleName) AND (i <= Zaehler)
      Ansicht.TypeKeys "<DOWN>"
      inc i
      if (i > Zaehler) then ' here we are only, if we didn't found 'our' template
         if bDouble then
            qaErrorLog "There are Double Entries in the list! #111652#"
         else
             warnlog " style not found :-(" ' print out the styles...
         endif
        Ansicht.TypeKeys "<home>"
         for x=0 to zaehler
            printlog "             "+(x+1)+": "+Ansicht.GetText
            if (Loeschen.IsEnabled) then qaErrorLog "^ is delete-able :-)"
            Ansicht.TypeKeys "<DOWN>"
         next x
      endif
      sTemp(2) = sTemp(1)
      sTemp(1) = Ansicht.GetText
      if (sTemp(1) = sTemp(2)) then
            bDouble = true
      endif
   wEnd
   if bDouble then
       i=1
       Ansicht.TypeKeys "<end>"
       sTemp(1) = Ansicht.GetText
       while (sTemp(1) <> sStyleName) AND (i <= Zaehler)
          printlog "             "+(i)+": "+sTemp(1)
          Ansicht.TypeKeys "<UP>"
          inc i
          if (i > Zaehler) then ' here we are only, if we didn't found 'our' template
            warnlog " style not found :-(" ' print out the styles...
            Ansicht.TypeKeys "<end>"
             for x=0 to zaehler
                printlog "             "+(x+1)+": "+Ansicht.GetText
                if (Loeschen.IsEnabled) then qaErrorLog "^ is delete-able :-)"
                Ansicht.TypeKeys "<UP>"
             next x
          endif
          sTemp(1) = Ansicht.GetText
       wEnd
   endif
   if (i <= Zaehler) then  printlog "   found created entry for deleting it :-)"
' Ansicht.TypeKeys "<DOWN>" ,( i + 1 )           '/// control if template list has created template included ///'
 sleep 2
 try
    Loeschen.Click                  '/// delete template ///'
    sleep 1
    Kontext "Active"
    if active.exists then
       printlog "ac: "+active.gettext
       try
          Active.Yes
       catch
          warnlog "active-Yes doesn't exist :-( WorkInProgress TBO"
       endcatch
    endif
    PrintLog " Delete did work"
    Kontext "Vorlagenkatalog"
 catch
    WarnLog " Only a new created template can be deleted"
 endcatch
  sleep 1
UseBindings
 Ansicht.Select 1
sleep 1
Aendern.Click                    '/// modify template ///'
 sleep 2
 Kontext
 Active.SetPage TabSchatten
 Kontext "TabSchatten"
 sleep 2
 TabSchatten.Cancel
 sleep 2
 Kontext "Vorlagenkatalog"

 Verwalten.Click                 '/// organize templates ///'
 sleep 2
 Kontext "DVVerwalten"
 DVVerwalten.OK
 sleep 1
 try
   Kontext "Vorlagenkatalog"
   Vorlagenkatalog.OK
 catch
    Warnlog " - Style Catalog can't close unless the Template Management-dialog is closed"
 endcatch
 PrintLog " FormatStylesCatalog finished"        '/// close template catalog ///'
 sleep 2
 FormatModifyLayout                 '/// format modify layout ///'
 sleep 2
 Kontext "Seitenvorlage"
 if HintergrundseiteAustauschen.IsChecked=True Then HintergrundseiteAustauschen.UnCheck   '/// uncheck switch background page ///'
 Laden.Click                     '/// load ///'
 sleep 2
 Kontext "Neu"
 Neu.Cancel
 Kontext "Seitenvorlage"               '/// choose a page layout ///'
 'Waehlen.Click
 Seitenvorlage.OK                '/// close dialog ///'

 Call hCloseDocument                '/// close document ///'

endcase

testcase tiFormatAufzaehlungszeichen
  Dim i as Integer :
  PrintLog "- Format/Numbering and Bullets"

   Call hNewDocument
   sleep 2
  Kontext "DocumentImpress"
  hTextrahmenErstellen ("Hello <Return><Return>",20,20,60,60)
  for i=1 to 8
      Kontext "DocumentImpress"
      gMouseClick 30,30
      EditSelectAll
      sleep 1
      FormatNumberingBulletsDraw
      sleep 2
      Kontext
      Active.SetPage TabBullet
      Kontext "TabBullet"
      Auswahl.TypeKeys "<Right>", i
      TabBullet.OK
      Kontext "DocumentImpress"
  next i
  for i=1 to 8
      Kontext "DocumentImpress"
      gMouseClick 30,30
      EditSelectAll
      sleep 1
      FormatNumberingBulletsDraw
      Kontext
      Active.SetPage TabNumerierungsart
      Kontext "TabNumerierungsart"
      Auswahl.TypeKeys "<Right>", i
      TabNumerierungsart.OK
      Kontext "DocumentImpress"
  next i
  for i=1 to 8
      Kontext "DocumentImpress"
      gMouseClick 30,30
      EditSelectAll
      FormatNumberingBulletsDraw
      Kontext
      Active.SetPage TabNumerierungsart
      Kontext "TabNumerierungsart"
      Auswahl.TypeKeys "<Right>", i
      TabNumerierungsart.OK
      Kontext "DocumentImpress"
  next i
  sleep 3
  for i=1 to 29
      sleep 3
      FormatNumberingBulletsDraw
      sleep 3
      Kontext
      Active.SetPage TabGrafiken
      Kontext "TabGrafiken"
      wait 500
      Auswahl.TypeKeys "<Right>", i
      TabGrafiken.OK
      Kontext "DocumentImpress"
  next i

 gMouseClick 90,90

 Call hCloseDocument

endcase
