'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: i_slidecopy.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: fredrikh $ $Date: 2006/07/11 14:13:01 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description: includefile for Slidecopy-testing
'*
'**************************************************************************************
' #1 tiSlideCopyNewPresentation
' #1 tiSlideCopyDuplicate
' #1 tiSlideCopyPasteSpecial
' #1 tiSlideCopyInSlideSorter
'\*************************************************************************************

testcase tiSlideCopyNewPresentation
    Dim value1 as string
    Dim value2 as string
    Dim value12 as string
    Dim value13 as string
     '/// Copies one slide from one presentation to another ///'
     '/// Make new presentation ///'
     Call  hNewDocument
     '/// Insert three objects: Connector, Door-plate, and Smiley ///'

     '1 Insert Connector.
     kontext "Toolbar"
     sleep 1
     try
        Verbinder.TearOff  ' insert connector
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "Connectorsbar"
     sleep 1
     Verbinder.click
     sleep 1
     gMouseMove (10,10,30,30)
     'rename object
     DocumentImpress.OpenContextMenu
     sleep 2
     'Choose rename.
     if hMenuFindSelect(27027, true, 13) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     sleep 1
     kontext "NameDlgObject"
     NameField.SetText "First"
     NameDlgObject.OK

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90

     '2 Insert Door-plate.
     kontext "Toolbar"
     sleep 1
     try
        StarShapes.TearOff  ' insert connector
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "StarShapes"
     sleep 1
     StarShapesDoorplate.click
     sleep 1
     gMouseMove (40,40,60,60)

     'rename object
     DocumentImpress.OpenContextMenu
     sleep 2
     'Choose rename.
     if hMenuFindSelect(27027, true, 14) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     kontext "NameDlgObject"
     NameField.SetText "Second"
     NameDlgObject.OK

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90

     '3 Insert Smiley.
     kontext "Toolbar"
     sleep 1
     try
        SymbolShapes.TearOff  ' insert connector
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "SymbolShapes"
     sleep 1
     SymbolShapesSmiley.Click
     sleep 1
     gMouseMove  (70,70,89,89)

     'rename object
     DocumentImpress.OpenContextMenu
     sleep 2
     'Choose rename.
     if hMenuFindSelect(27027, true, 14) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     kontext "NameDlgObject"
     NameField.SetText "Third"
     NameDlgObject.OK

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90

     '/// Copy the slide to the clipboard ///'
     kontext "Slides"
     SlidesControl.TypeKeys "<HOME>"
     SlidesControl.OpenContextMenu
     sleep 2
     'Choose `Copy`
     if hMenuFindSelect(5711, true, 10) = false then
        Warnlog "Context-Menu-entry `Copy` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     '/// Close the presentation-window ///'
     Call hCloseDocument
     '/// Open a new presentation ///'
     Call  hNewDocument
     '/// Paste the slide from the clipboard ///'
     kontext "Slides"
     EditPaste
     '/// Delete the first slide ///'
     EditDeleteSlide
     '/// Check if all three objects exists, and has the right values ///'
     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90
     DocumentImpress.TypeKeys "<TAB>" 'Select the first object.
     'Bring up the kontext-menu for the object
     DocumentImpress.OpenContextMenu
     sleep 2
     'Choose rename.
     if hMenuFindSelect(27027, true, 13) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     'Read out what the name is, and check if its correct.
     kontext "NameDlgObject"  '"LinieName"  "NameDlgPage"
     value1 = NameField.GetText
     NameDlgObject.OK 'TypeKeys "<Enter>"
     if value1 = "First" then
        printlog "First object was found correctly"
     else
        Warnlog "Wrong object or object-name! The name found was: " + value1
     endif
     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90
     DocumentImpress.TypeKeys "<TAB TAB>" 'Select the second object.
     'Bring up the kontext-menu for the object
     DocumentImpress.OpenContextMenu
     sleep 2
     'Choose rename.
     if hMenuFindSelect(27027, true, 14) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     'Read out what the name is, and check if its correct.
     sleep 1
     kontext "NameDlgObject"
     value12 = NameField.GetText
     NameDlgObject.OK

     if value12 = "Second" then
        printlog "Second object was found correctly"
     else
        Warnlog "Wrong object or object-name! The name found was: " + value12
     endif

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90
     DocumentImpress.TypeKeys "<TAB TAB TAB>" 'Select the third object.
     'Bring up the kontext-menu for the object
     DocumentImpress.OpenContextMenu
     sleep 2
     'Choose rename.
     if hMenuFindSelect(27027, true, 14) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     'Read out what the name is, and check if its correct.
     kontext "NameDlgObject"
     value13 = NameField.GetText
     NameDlgObject.OK

     if value13 = "Third" then
        printlog "Third object was found correctly"
     else
        Warnlog "Wrong object or object-name! The name found was: " + value13
     endif

     '/// Close the bars we opened before. ///'
     kontext "Connectorsbar"
     if Connectorsbar.Exists then Connectorsbar.Close
     kontext "SymbolShapes"
     if SymbolShapes.Exists then SymbolShapes.Close
     kontext "StarShapes"
     if StarShapes.Exists then StarShapes.Close

     '/// Close Presentation. End testcase ///'
     Call hCloseDocument
endcase 'tiSlideCopyNewPresentation

'-------------------------------------------------------------------------

testcase tiSlideCopyDuplicate
    Dim value1 as string
    Dim value2 as string
    Dim value12 as string
    Dim value13 as string
    dim i as integer
     '/// Make a duplicate of a slide. In the same presentation ///'
     '/// Make new presentation ///'
     Call  hNewDocument
     '/// Insert three objects: Connector, Door-plate, and Smiley ///'
     '1 Insert Connector.
     kontext "Toolbar"
     sleep 1
     try
        Verbinder.TearOff  ' insert connector
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "Connectorsbar"
     sleep 1
     Verbinder.click
     sleep 1
     kontext "DocumentImpress"
     gMouseMove (10,10,30,30)

     'rename object
     DocumentImpress.OpenContextMenu
     sleep 1
     'Choose rename.
     if hMenuFindSelect(27027, true, 13) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     kontext "NameDlgObject"
     NameField.SetText "First"
     NameDlgObject.OK
     sleep 1

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90

     '2 Insert Door-plate.
     kontext "Toolbar"
     sleep 1
     try
        StarShapes.TearOff  ' insert connector
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "StarShapes"
     sleep 1
     StarShapesDoorplate.click
     sleep 1
     kontext "DocumentImpress"
     gMouseMove (40,40,60,60)

     'rename object
     kontext "DocumentImpress"
     DocumentImpress.OpenContextMenu
     sleep 1
     'Choose rename.
     if hMenuFindSelect(27027, true, 14) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     kontext "NameDlgObject"
     NameField.SetText "Second"
     NameDlgObject.OK
     sleep 1

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90

     '3 Insert Smiley.
     kontext "Toolbar"
     sleep 1
     try
        SymbolShapes.TearOff  ' insert connector
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "SymbolShapes"
     sleep 1
     SymbolShapesSmiley.Click
     sleep 1
     gMouseMove  (70,70,89,89)

     'rename object
     DocumentImpress.OpenContextMenu
     sleep 1
     'Choose rename.
     if hMenuFindSelect(27027, true, 14) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     kontext "NameDlgObject"
     NameField.SetText "Third"
     NameDlgObject.OK
     sleep 1

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90

     '/// Close the bars we opened before. ///'
     kontext "Connectorsbar"
     if Connectorsbar.Exists then Connectorsbar.Close
     kontext "SymbolShapes"
     if SymbolShapes.Exists then SymbolShapes.Close
     kontext "StarShapes"
     if StarShapes.Exists then StarShapes.Close

     '/// Copy the slide to the clipboard ///'
     kontext "Slides"
     SlidesControl.TypeKeys "<HOME>"
     SlidesControl.OpenContextMenu
     sleep 1
     'Choose `Copy`
     if hMenuFindSelect(5711, true, 10) = false then
        Warnlog "Context-Menu-entry `Copy` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     '/// Paste the content from the Clipboard ///'
     kontext "Slides"
     'open context-menu choose 'paste'

     EditPaste

     kontext "InsertPaste"
     if InsertPaste.Exists(1) then
        After.Check
        InsertPaste.OK
     endif

     '/// Check if we have two slides, and that the objects exists, and has the right values ///'

     kontext "Slides"
     SlidesControl.TypeKeys "<HOME>"

     for i = 1 to 2   ' we have two slides, so we do this two times to check everything.
        Printlog "Checking objects the " + i + " + time."
        kontext "DocumentImpress"
        hMouseClick DocumentImpress, 90, 90
        DocumentImpress.TypeKeys "<TAB>" 'Select the first object.
        'Bring up the kontext-menu for the object
        DocumentImpress.OpenContextMenu
        sleep 1
        'Choose rename.
        if hMenuFindSelect(27027, true, 13) = false then
           Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
           Call hCloseDocument
           Goto Endsub
        endif

        'Read out what the name is, and check if its correct.
        kontext "NameDlgObject"  '"LinieName"  "NameDlgPage"
        value1 = NameField.GetText
        NameDlgObject.OK 'TypeKeys "<Enter>"

        if value1 = "First" then
           printlog "First object was found correctly"
        else
           Warnlog "Wrong object or object-name! The name found was: " + value1
        endif

        kontext "DocumentImpress"
        hMouseClick DocumentImpress, 90, 90

        DocumentImpress.TypeKeys "<TAB TAB>" 'Select the second object.
        'Bring up the kontext-menu for the object
        DocumentImpress.OpenContextMenu
        sleep 1
        'Choose rename.
        if hMenuFindSelect(27027, true, 14) = false then
           Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
           Call hCloseDocument
           Goto Endsub
        endif

        'Read out what the name is, and check if its correct.
        kontext "NameDlgObject"
        value12 = NameField.GetText
        NameDlgObject.OK

        if value12 = "Second" then
           printlog "Second object was found correctly"
        else
           Warnlog "Wrong object or object-name! The name found was: " + value12
        endif

        kontext "DocumentImpress"
        hMouseClick DocumentImpress, 90, 90

        DocumentImpress.TypeKeys "<TAB TAB TAB>" 'Select the third object.
        'Bring up the kontext-menu for the object
        DocumentImpress.OpenContextMenu
        sleep 1
        'Choose rename.
        if hMenuFindSelect(27027, true, 14) = false then
           Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
           Call hCloseDocument
           Goto Endsub
        endif

        'Read out what the name is, and check if its correct.
        kontext "NameDlgObject"
        value13 = NameField.GetText
        NameDlgObject.OK

        if value13 = "Third" then
           printlog "Third object was found correctly"
        else
           Warnlog "Wrong object or object-name! The name found was: " + value13
        endif
        kontext "Slides"
        SlidesControl.TypeKeys "<DOWN>"
     next i

     '/// Close Presentation. End testcase ///'
     Call hCloseDocument
endcase 'tiSlidecopyDuplicate

'-----------------------------------------------------------------------

testcase tiSlideCopyPasteSpecial
    Dim value1 as string
    Dim value2 as string
    Dim value3 as string
     '/// Copies slide, and pastes it with "Paste Special", ///'
     '/// just to see if the office can handle it ///'
     '/// Make new presentation ///'
     Call  hNewDocument
     '/// Insert three objects: Connector, Door-plate, and Smiley ///'

     '1 Insert Connector.
     kontext "Toolbar"
     sleep 1
     try
        Verbinder.TearOff  ' insert connector
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "Connectorsbar"
     sleep 1
     Verbinder.click
     sleep 1
     gMouseMove (10,10,30,30)

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90

     '2 Insert Door-plate.
     kontext "Toolbar"
     sleep 1
     try
        StarShapes.TearOff  ' insert connector
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "StarShapes"
     sleep 1
     StarShapesDoorplate.click
     sleep 1
     gMouseMove (40,40,60,60)

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90

     '3 Insert Smiley.
     kontext "Toolbar"
     sleep 1
     try
        SymbolShapes.TearOff  ' insert connector
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "SymbolShapes"
     sleep 1
     SymbolShapesSmiley.Click
     sleep 1
     gMouseMove  (70,70,89,89)

     '/// Copy the slide to the clipboard ///'
     kontext "Slides"
     SlidesControl.TypeKeys "<HOME>"
     SlidesControl.OpenContextMenu
     sleep 1
     'Choose `Copy`
     if hMenuFindSelect(5711, true, 10) = false then
        Warnlog "Context-Menu-entry `Copy` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     '/// Try to paste special. And check that the office still stays alive ///'
     EditPasteSpecial
     kontext "InhaltEinfuegen"
     InhaltEinfuegen.OK

     '/// Close the bars we opened before. ///'
     kontext "Connectorsbar"
     if Connectorsbar.Exists then Connectorsbar.Close
     kontext "SymbolShapes"
     if SymbolShapes.Exists then SymbolShapes.Close
     kontext "StarShapes"
     if StarShapes.Exists then StarShapes.Close

     sleep 1
     kontext "DocumentImpress"
     '/// Close Presentation. End testcase ///'

     Call hCloseDocument
endcase 'tiSlideCopyPasteSpecial

'-----------------------------------------------------------------------

testcase tiSlideCopyInSlideSorter
    Dim value1 as string
    Dim value2 as string
    Dim value3 as string
     '/// Copies slides within the slidesorter, and makes sure they are pasted on the correct position ///'
     '/// Make new presentation ///'
     Call  hNewDocument
     '/// Insert an object: Connector, on the first slide ///'
     kontext "Toolbar"
     sleep 1
     try
        Verbinder.TearOff
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "Connectorsbar"
     sleep 1
     Verbinder.click
     Verbinder.click
     Verbinder.click
     sleep 1
     kontext "DocumentImpress"
     gMouseMove (10,10,30,30)
     Printlog "   Inserted a Connector-object."
     'Rename object
     DocumentImpress.TypeKeys "<SHIFT F10>" 'OpenContextMenu
     sleep 3
     'Rename
     if hMenuFindSelect(27027, true, 13) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     kontext "NameDlgObject"
     NameField.SetText "First"
     NameDlgObject.OK
     sleep 1
     Printlog "   Renamed a the object to 'First'"

     sleep 3
     '/// Rename slide to "1" ///'
     kontext "Slides"
     SlidesControl.TypeKeys "<SHIFT F10>" 'OpenContextMenu
'     SlidesControl.OpenContextMenu
     sleep 3
     'Rename
     if hMenuFindSelect(27268, true, 2) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     kontext "NameDlgPage"
     NameField.SetText "1"
     NameDlgPage.OK
     sleep 1
     Printlog "   Renamed the Slide to '1'"

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90
     sleep 3

     '/// Insert a new slide ///'
     kontext "Slides"
     SlidesControl.MouseDown 90,90
     SlidesControl.MouseUp 90,90
     SlidesControl.TypeKeys "<SHIFT F10>" 'OpenContextMenu
     sleep 3
     'Insert slide
     if hMenuFindSelect(27014, true, 1) = false then
        Warnlog "Context-Menu-entry `Insert slide` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     Printlog "   Inserted a new slide."
     '/// Insert an object: Door-plate, on the second slide ///'
     kontext "Toolbar"
     sleep 1
     try
        StarShapes.TearOff
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "StarShapes"
     sleep 1
     StarShapesDoorplate.click
     sleep 1
     kontext "DocumentImpress"
     gMouseMove (40,40,60,60)
     Printlog "   Inserted a Door-Plate-object."

     'Rename object
     kontext "DocumentImpress"
     DocumentImpress.OpenContextMenu
     sleep 2
     ' Rename
     if hMenuFindSelect(27027, true, 14) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     kontext "NameDlgObject"
     NameField.SetText "Second"
     NameDlgObject.OK
     sleep 1
     Printlog "   Renamed a the object to 'Second'"

     kontext "DocumentImpress"
     hMouseClick DocumentImpress, 90, 90
     sleep 2
     '/// Rename slide to "2" ///'
     kontext "Slides"
     SlidesControl.OpenContextMenu
     sleep 3
     ' Rename
     if hMenuFindSelect(27268, true, 3) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     kontext "NameDlgPage"
     NameField.SetText "2"
     NameDlgPage.OK
     sleep 1
     Printlog "   Renamed the slide '2'"

     '/// Insert a new slide ///'
     kontext "Slides"
     Slidescontrol.OpenContextMenu  'TypeKeys "<SHIFT F10>" '
     sleep 3
     'Insert slide
     if hMenuFindSelect(27014, true, 1) = false then
        Warnlog "Context-Menu-entry `Insert slide` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     Printlog "   Inserted a new slide."

     '/// Insert an object: Smiley, on the second slide ///'
     kontext "Toolbar"
     sleep 1
     try
        SymbolShapes.TearOff
     catch
        warnlog "bug for GH from FHA; .tearoff doesnt tell success"
     endcatch
     kontext "SymbolShapes"
     sleep 1
     SymbolShapesSmiley.Click
     sleep 1
     gMouseMove  (70,70,89,89)
     Printlog "   Inserted a Smiley-object."
'     sleep 3
     'Rename object
     DocumentImpress.OpenContextMenu true
     sleep 3
     'Choose rename.
     if hMenuFindSelect(27027, true, 14) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     kontext "NameDlgObject"
     NameField.SetText "Third"
     NameDlgObject.OK
     Printlog "   Renamed a the object to 'Third'"

'     kontext "DocumentImpress"
'     hMouseClick DocumentImpress, 90, 90
'     sleep 3
     '/// Rename slide to "3" ///'
     kontext "Slides"
     SlidesControl.OpenContextMenu
     sleep 3
     ' Rename
     if hMenuFindSelect(27268, true, 3) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     kontext "NameDlgPage"
     NameField.SetText "3"
     NameDlgPage.OK
     sleep 1
     Printlog "   Renamed the slide '3'"

     '/// Close the bars we opened before. ///'
     kontext "Connectorsbar"
     if Connectorsbar.Exists then Connectorsbar.Close
     kontext "SymbolShapes"
     if SymbolShapes.Exists then SymbolShapes.Close
     kontext "StarShapes"
     if StarShapes.Exists then StarShapes.Close

     '/// Change to Slidesorter ///'
     kontext "DocumentImpress"
     ViewSlideSorter
     kontext "Slides"
     Printlog "   Changed view to 'SlideSorter'"

     '/// Make sure the last slide is selcted ///'
     SlidesControl.TypeKeys "<PAGEDOWN PAGEDOWN PAGEDOWN>"

'     sleep 3
     '/// Cut the last slide ///'
     SlidesControl.TypeKeys "<SHIFT F10>" '= open context menu
     sleep 3
     if hMenuFindSelect(5710, true, 10) = false then
        Warnlog "Context-Menu-entry `Cut` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     '/// Make sure the first slide is selected ///'
     SlidesControl.TypeKeys "<PAGEUP PAGEUP>"
     sleep 1

     '/// Paste the Slide ///'
     kontext "Slides"
     SlidesControl.OpenContextMenu true
     sleep 3
     if hMenuFindSelect(5712, true, 12) = false then
        Warnlog "Context-Menu-entry `Paste` were not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     sleep 1

     '/// choose "Before" as specification for where
     Kontext "InsertPaste"
     if InsertPaste.Exists(1) then
        Before.Check
        InsertPaste.OK
     endif
     Printlog "   Pasted slide 'Before'"

     '/// Check where the slide ended up ///'
     kontext "Slides"
     SlidesControl.TypeKeys "<PAGEUP PAGEUP PAGEUP>" 'to get to the first slide
     SlidesControl.TypeKeys "<SHIFT F10>" '= open context menu
     sleep 3
     ' Rename
     if hMenuFindSelect(27268, true, 3) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     kontext "NameDlgPage"
     if NameField.GetText <> "3" then
        Warnlog "Wrong slide found! Expected nr 3, but found " + NameField.GetText + "."
     else
        Printlog "   Slide nr 3 was found correctly."
     endif
     NameDlgPage.OK
     sleep 1

     kontext "Slides"
     '/// Choose the slide in the middle (named "1") ///'
     SlidesControl.TypeKeys "<PAGEDOWN PAGEDOWN PAGEDOWN>" 'to get to the last slide
     SlidesControl.TypeKeys "<PAGEUP>" 'to go back one step
     '/// Cut the slide ///'
     SlidesControl.OpenContextMenu
     sleep 3
     if hMenuFindSelect(5710, true, 10) = false then
        Warnlog "Context-Menu-entry `Cut` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     '/// Make sure we have selected the last slide ///'
     SlidesControl.TypeKeys "<PAGEDOWN PAGEDOWN>"

     '/// Place the marker to the left of the first slide ///'
     sleep 1
     kontext "Slides"
     SlidesControl.MouseMove 2, 3
     SlidesControl.OpenContextMenu true
     sleep 3

     '/// Paste the Slide ///'
     if hMenuFindSelect(5712, true, 12) = false then
        Warnlog "Context-Menu-entry `Paste` were not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif
     sleep 1

     '/// Choose "After" as specification for where ///'
     Kontext "InsertPaste"
     if InsertPaste.Exists(1) then
        After.Check
        InsertPaste.OK
     endif
     Printlog "   Pasted slide 'After'"

     '/// Check where the slide ended up ///'
     kontext "Slides"
     SlidesControl.TypeKeys "<PAGEDOWN PAGEDOWN PAGEDOWN>" 'to get to the last slide
     SlidesControl.TypeKeys "<SHIFT F10>" '= open context menu
     sleep 3
     ' Rename
     if hMenuFindSelect(27268, true, 3) = false then
        Warnlog "Context-Menu-entry `Rename` was not found. Therefore the test ends."
        Call hCloseDocument
        Goto Endsub
     endif

     kontext "NameDlgPage"
     if NameField.GetText <> "1" then
        Warnlog "Wrong slide found! Expected nr 1, but found " + NameField.GetText + "."
     else
        Printlog "   Slide nr 1 was found correctly."
     endif
     NameDlgPage.OK
     sleep 1

     '/// Close Presentation. End testcase ///'
     Call hCloseDocument
endcase 'tiSlideCopyInSlideSorter

'------------------------------------------------------------------------

'TODO FHA - Check the objects after pasting them.
