'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_advanced_tools.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: hde $ $Date: 2006/04/10 14:16:41 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Test the AutoCorrect/AutoFormat/Word tools
'*
'************************************************************************
'*
' #0 fFormatCharacter
' #0 fFormatParagraph
' #0 fDeleteAllEntries
' #0 fPositionAndSize
' #0 fFormatLine
' #0 fDrawALine
' #0 fStartupNavigator
' #0 fCloseNavigator
' #0 fSetAllInDrawbar
' #0 fSetDrawbarToDefault
' #0 fGetDrawing
'*
'\***********************************************************************


function fAutocorrectOptions(Options as String)
    '/// Open Tools/Autocorrect/Autoformat diglog with tab page Options
    '///+ then choose the relevant Options and press 'space bar'

    Call fAutocorrectAutoformat("TabOptionenAutokorrektur")
    Sleep 1
    Einstellungen.TypeKeys "<Home>"

    Select case Options

    case "UseReplacementTable"         : Goto going
    case "CorrectTWoINitialCApitals"   : Einstellungen.TypeKeys "<Down>"
    case "CapitalizeFirstLetter"       : Einstellungen.TypeKeys "<Down>",2
    case "AutomaticBoldAndUnderline"   : Einstellungen.TypeKeys "<Down>",3
    case "URLRecognition"              : Einstellungen.TypeKeys "<Down>",4
    case "Replace1st"                  : Einstellungen.TypeKeys "<Down>",5
    case "Replace1/2"                  : Einstellungen.TypeKeys "<Down>",6
    case "ReplaceDashes"               : Einstellungen.TypeKeys "<Down>",7
    case "DeleteSpaceParagraph"        : Einstellungen.TypeKeys "<Down>",8
    case "DeleteSpaceLine"             : Einstellungen.TypeKeys "<Down>",9
    case "IgnoreDoulbeSpaces"          : Einstellungen.TypeKeys "<Down>",10
    case "ApplyNumbering"              : Einstellungen.TypeKeys "<Down>",11
    case "ApplyBorder"                 : Einstellungen.TypeKeys "<Down>",12
    case "CreateTable"                 : Einstellungen.TypeKeys "<Down>",13
    case "ApplyStyles"                 : Einstellungen.TypeKeys "<Down>",14
    case "RemoveBlankParagraphs"       : Einstellungen.TypeKeys "<Down>",15
    case "ReplaceCustomStyles"         : Einstellungen.TypeKeys "<Down>",16
    case "ReplaceBullets"              : Einstellungen.TypeKeys "<Down>",17
    case "ReplaceQuotes"               : Einstellungen.TypeKeys "<Down>",18
    case "CombineSingleLine"           : Einstellungen.TypeKeys "<End>"

  end select

going:
    Einstellungen.TypeKeys "<SPACE>"
    TabOptionenAutokorrektur.OK
end function

'-------------------------------------------------------------------------

function fFormatCharacter(Options as string)
'/// Open format/character diglog with Options.
  Kontext
  FormatCharacter

  Select case Options
    case "TabFont"                     : active.SetPage TabFont
    case "TabFontEffects"              : active.SetPage TabFontEffects
    case "TabFontPosition"             : active.SetPage TabFontPosition
    case "TabHyperlinkZeichen"         : active.SetPage TabHyperlinkZeichen
    case "TabHintergrund"              : active.SetPage TabHintergrund
  end select

  Kontext Options

end function

'-------------------------------------------------------------------------

function fFormatParagraph(Options as string)
'/// Open format/paragraph diglog with Options
  Kontext
  FormatParagraph

  Select case Options
    case "TabUmrandung"                : active.SetPage TabUmrandung             'Borders
    case "TabEinzuegeUndAbstaende"     : active.SetPage TabEinzuegeUndAbstaende  'Indents & Spacing
  end select

  Kontext Options

end function

'-------------------------------------------------------------------------

function fDeleteAllEntries()
'/// This function is to delete all entries in tools/autocorrect/Word completions.
  Dim i as Integer

  fAutocorrectAutoformat("TabWortergaenzung")

   if GesammelteWorte.GetItemCount > 0 then
    for i= 1 to GesammelteWorte.GetItemCount
     GesammelteWorte.Select 1
     if EintragLoeschen.IsEnabled then
      EintragLoeschen.Click
     else
      i = GesammelteWorte.GetItemCount + 1
     endif
    next i
   endif

  TabWortergaenzung.OK
end function

'-------------------------------------------------------------------------

function fPositionAndSize(Options as string)
'/// Open Format/Position and Size diglog with Options.
    Kontext
    FormatPositionAndSize

  Select case Options
    case "TabPositionAndSizeWriter"  : active.SetPage TabPositionAndSizeWriter
    case "TabDrehung"                : active.SetPage TabDrehung
    case "TabSchraegstellen"         : active.SetPage TabSchraegstellen
  end Select

  Kontext Options
end function

'-------------------------------------------------------------------------

function fFormatLine(Options as string)
'/// Open Format/Line with Options.
  Kontext
  FormatLine

  Select case Options
    case "TabLinie"           : active.SetPage TabLinie
    case "TabLinienstile"     : active.SetPage TabLinienstile
    case "TabLinienenden"     : active.SetPage TabLinienenden
  end Select

  Kontext Options
end function

'-------------------------------------------------------------------------

function fDrawALine( xStart%, yStart%, xEnd%, yEnd% )
'/// Draw a line
   Kontext "WL_SW"
   Zeichnen.TearOff

  '/// + Draw a line
   Kontext "TB_Zeichenfunktionen"
   Linie.Click
   gMouseMove(xStart%, yStart%, xEnd%, yEnd%)
   gMouseClick (75,5)
   Sleep 1
   Kontext "TB_Zeichenfunktionen"
   TB_Zeichenfunktionen.Close
end function

'-------------------------------------------------------------------------

function fStartupNavigator(navigatorItem as String , subItemNum as Integer)
'/// Start up Navigator , and set focus to the correct position.
   Dim j as Integer

   Kontext "Navigator"
   if NOT Navigator.Exists then
       EditNavigator
   end if
   Kontext "NavigatorWriter"
   if Auswahlliste.GetItemCount < 11 then
       Inhaltsansicht.Click
   end if
   Auswahlliste.TypeKeys "<Home>"         '<- Set focus to first entry
   if Auswahlliste.GetItemCount > 11 then '<- If nodes are open
       For j= 1 to 12              '<- close all nodes
           Auswahlliste.Select j
           Auswahlliste.TypeKeys "-"
       next j
   end if
   Auswahlliste.TypeKeys "<Home>"   ' point focus to first entry
   sleep 1

   Select case navigatorItem
     case "Headings"        : goto GoON
     case "Tables"          : Auswahlliste.TypeKeys "<down>"
     case "TextFrame"       : Auswahlliste.TypeKeys "<down>" , 2
     case "Graphics"        : Auswahlliste.TypeKeys "<down>" , 3
     case "OLEObject"       : Auswahlliste.TypeKeys "<down>" , 4
     case "Bookmarks"       : Auswahlliste.TypeKeys "<down>" , 5
     case "Section"         : Auswahlliste.TypeKeys "<down>" , 6
     case "Hyperlinks"      : Auswahlliste.TypeKeys "<down>" , 7
     case "References"      : Auswahlliste.TypeKeys "<down>" , 8
     case "Indexes"         : Auswahlliste.TypeKeys "<down>" , 9
     case "Notes"           : Auswahlliste.TypeKeys "<down>" , 10
     case "DrawObjects"     : Auswahlliste.TypeKeys "<down>" , 11
   end Select
   sleep 2
GoON:
   Auswahlliste.TypeKeys "<return>"
   sleep 2
   Toolbox.Click Inhaltsansicht
   sleep 2
   Auswahlliste.TypeKeys "<Up>",subItemNum
   sleep 2
end function

'-------------------------------------------------------------------------

function fCloseNavigator
'/// Close Navigator
   Kontext "Navigator"
   Sleep 3
   if Navigator.Exists(2) then
       Navigator.Close
   end if
   Sleep 3

end function

'-------------------------------------------------------------------------

function fSetAllInDrawbar()
'/// Set all icon in drawbar active.
  Dim i , j    as Integer
  Dim sDrawing as String

  sDrawing = fGetDrawing()

  ToolsCustomize
  sleep 3
  Kontext
  Active.SetPage TabCustomizeToolbars
  Kontext "TabCustomizeToolbars"
    Menu.Select sDrawing
    Sleep 1

    j = ToolbarContents.GetItemCount

    ToolbarContents.Typekeys "<Home>"
    for i = 1 to j
        if NOT ToolbarContents.IsChecked then
            iFlag(i) = 1
            ToolbarContents.Check
        end if
        ToolbarContents.Typekeys "<Down>"
    next i
  TabCustomizeToolbars.OK
end function

'-------------------------------------------------------------------------

function fSetDrawbarToDefault()
'/// Set drawbar to default
  Dim i , j    as Integer
  Dim sDrawing as String

  sDrawing = fGetDrawing()

  ToolsCustomize
  sleep 3
  Kontext
  Active.SetPage TabCustomizeToolbars
  Kontext "TabCustomizeToolbars"
    Menu.Select sDrawing
    Sleep 1

    j = ToolbarContents.GetItemCount

    ToolbarContents.Typekeys "<Home>"
    for i = 1 to j
        if iFlag(i) = 1 then
            ToolbarContents.UnCheck
        end if
        ToolbarContents.Typekeys "<Down>"
    next i
  TabCustomizeToolbars.OK
end function

'-------------------------------------------------------------------------

function fGetDrawing() as String
'/// Set drawing toolbar to different local.
  Select case iSprache
      case 01   : fGetDrawing   = "Drawing"
      case 33   : fGetDrawing   = ""
      case 34   : fGetDrawing   = ""
      case 39   : fGetDrawing   = ""
      case 46   : fGetDrawing   = ""
      case 49   : fGetDrawing   = ""
      case 55   : fGetDrawing   = ""
      case 81   : fGetDrawing   = ""
      case 82   : fGetDrawing   = ""
      case 86   : fGetDrawing   = ""
      case 88   : fGetDrawing   = ""
      case else : QAErrorLog "The test does not support the language " + iSprache
                  fGetDrawing   = "Drawing"
  end select
end function
