'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_105aa_.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:26:54 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_105aa_
   printLog Chr(13) + "---------   Level 1 - Format / Tables   ----------"

' Tabelle
   Call tFormatDefaultTable
   Call tFormatTable
   Call tFormatTableAlignment
   Call tFormatJoinTables
   Call tFormatJoinTables_2
   Call tFormatSplitTables
   Call tFormatSplitTables_2
   Call tFormatCharacter
   Call tFormatCellSplit
   Call tFormatCellProtect
   Call tFormatCellMerge
   Call tFormatCellAlignment
   Call tFormatRowHeight
   Call tFormatRow
   Call tFormatColumnWidth
   Call tFormatColumn
   Call tFormatAutoformatTable

end sub


testcase tFormatDefaultTable
  PrintLog "- Format / Default in tables"
   '/// new document ///
   Call hNewDocument
   '/// Insert a table in document ///
   Call hTabelleEinfuegen

  Printlog "   - modify format"
   '/// write in every cell a word ///
   Call wDokSchreiben "Hallo<Tab>dies<Tab>ist<Tab>eine<Tab>Tabelle<Tab>1<Tab>2<Tab>3<Tab>4<Tab>5<Shift up>"
   Call wDokSchreiben "<Shift Left>", 4
   '/// Call Format / Character ///
   FormatCharacter
   Kontext
   Active.SetPage TabFontEffects
   Kontext "TabFontEffects"
   '/// Check 'Outline'///
   Outline.Check
   '/// on Strike Through select second entry ///
   StrikeThrough.Select 2
   Kontext
   Active.SetPage TabFont
   Kontext "TabFont"
   '/// Change font size to 18 ///
   try
    SizeWest.Select 18
   catch
    Size.Select 18
   endcatch
   TabFont.OK
   Sleep 1

  Format "   - auf Standard setzen"
   '/// Call Format / Default ///
   FormatDefaultWriter
   Call wDokSchreiben "<Right>"

  Format "   - 1. Zeile testen"
   '/// Check if table has been set to default ///
   Sleep 1
   FormatCharacter
   Kontext
   Active.SetPage TabFontEffects
   Kontext "TabFontEffects"
   if Outline.IsChecked or StrikeThrough.GetSelIndex = 2 then
      Warnlog "Format has not been set to default"
   end if
   TabFontEffects.Cancel

  Format "   - 2. Zeile testen"
   Call wDokSchreiben "<Down>"
   FormatCharacter
   Kontext
   Active.SetPage TabFontEffects
   Kontext "TabFontEffects"
   if Outline.IsChecked or StrikeThrough.GetSelIndex = 2 then
      Warnlog "Format has not been set to default"
   end if
   TabFontEffects.Cancel
   '/// Close document ///
   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatTable
  PrintLog "- Format / Table"

   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert a table into document ///
   Call hTabelleEinfuegen

  PrintLog "   - modify format"
   '/// Call Format / Table and change properties ///
   FormatTable
   Kontext
   Active.SetPage TabTabelle
   Kontext "TabTabelle"
   TabellenName.SetText "DiesIstEineSchneTabelle"
   Links.Check
   Kontext
   Sleep 2
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   UeberschriftWiederholen.Uncheck
   Kontext
   Active.SetPage TabSpaltenTabelle
   Kontext "TabSpaltenTabelle"
   BreiteAnpassen.Check
   Spalte2.Less 2
   Kontext
   Active.SetPage TabHintergrund
   Kontext "TabHintergrund"
   wait 500
   Fuer.Select 3
   Hintergrundfarbe.TypeKeys "<Down><Left>", 4
   '/// Close dialog / reopen and check settings made ///
   TabHintergrund.OK

  PrintLog "   - check format"
   FormatTable
   Kontext
   Active.SetPage TabTabelle
   Kontext "TabTabelle"
   if TabellenName.GetText <> "DiesIstEineSchneTabelle" then Warnlog "Table has a wrong name :"+ TabellenName.GetText
   if NOT Links.IsChecked then Warnlog "Alignment is not left"
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if UeberschriftWiederholen.IsChecked then Warnlog "Repeat header has been checked again!"
   Kontext
   Active.SetPage TabSpaltenTabelle
   Kontext "TabSpaltenTabelle"
   if iSystemSprache = 01 or iSystemSprache = 07 or iSystemSprache = 48 then
      if iSystemSprache = 48 then
       if VerfuegbarerPlatz.GetText <> "0.20" + mUnit then Warnlog "Modify Width has not been worked correctly. Value is " + VerfuegbarerPlatz.GetText
      else
       if VerfuegbarerPlatz.GetText <> "0.20" + mUnit then Warnlog "Modify Width has not been worked correctly. Value is " + VerfuegbarerPlatz.GetText
      endif
   else
      if VerfuegbarerPlatz.GetText <> "0,20" + mUnit then Warnlog "Modify Width has not been worked correctly. Value is " + VerfuegbarerPlatz.GetText
   end if
   Kontext
   Active.SetPage TabHintergrund
   Kontext "TabHintergrund"
   if Fuer.GetSelIndex <> 3 then Warnlog "Modifying Background has not been effected to the whole table."
   Hintergrundfarbe.TypeKeys "<Down><Left>", 4
   TabHintergrund.Cancel

   ' Hier kommt die TabUmrandung rein
    'Active.Setpage TabUmrandung
    'Kontext "TabUmrandung"
    'Abstaende.Click
    'Kontext "AbstaendeUmrandung"
    'AbstandLinks

  printlog "  - check saved formatting"
   '/// Save document and reload previous saved document ///
   if gApplication = "WRITER" then
    Call hSpeichernUnterKill ( gOfficePath + "user\work\stufe1.sxw" )
    Call hCloseDocument
    Call hDateiOeffnen ( gOfficePath + "user\work\stufe1.sxw" )
   else
    Call hSpeichernUnterKill ( gOfficePath + "user\work\stufe1.sxg" )
    Call hCloseDocument
    Call hDateiOeffnen ( gOfficePath + "user\work\stufe1.sxg" )
   endif

   FormatTable
   '/// check settings made to table ///
   Kontext
   Active.SetPage TabTabelle
   Kontext "TabTabelle"
   if TabellenName.GetText <> "DiesIstEineSchneTabelle" then Warnlog "Table has a wrong name :"+ TabellenName.GetText
   if NOT Links.IsChecked then Warnlog "Alignment is not left"
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if UeberschriftWiederholen.IsChecked then Warnlog "Repeat header is checked"
   Kontext
   Active.SetPage TabSpaltenTabelle
   Kontext "TabSpaltenTabelle"
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
     if iSystemSprache = 48 then
      if VerfuegbarerPlatz.GetText <> "0.20" + mUnit then Warnlog "Modify Width has not been worked correctly. Value is " + VerfuegbarerPlatz.GetText
     else
      if VerfuegbarerPlatz.GetText <> "0.20" + mUnit then Warnlog "Modify Width has not been worked correctly. Value is " + VerfuegbarerPlatz.GetText
     endif
   else
     if VerfuegbarerPlatz.GetText <> "0,20" + mUnit then Warnlog "Modify Width has not been worked correctly. Value is " + VerfuegbarerPlatz.GetText
   end if
   Kontext
   Active.SetPage TabHintergrund
   Kontext "TabHintergrund"
   if Fuer.GetSelIndex <> 3 then Warnlog "Modifying Background has not been effected to the whole table."
   Hintergrundfarbe.TypeKeys "<Down><Left>", 4
   TabHintergrund.Cancel

   '/// Close document ///
   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatTableAlignment
  printlog "- Format / Table Alignment left"
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert a table into document ///
   Call hTabelleEinfuegen
   '/// Call Format / Table and change settings on Tab Table///
   FormatTable
   Kontext
   Active.Setpage TabTabelle
   Kontext "TabTabelle"
   Vonlinks.Check
   Relativ.Check
   Breite.Settext "20%"
   TabTabelle.OK

   Call wDocSetContext
   '/// Call Format / Table again and check properties ///
   FormatTable
   Kontext
   Active.Setpage TabSpaltenTabelle
   Kontext "TabSpaltenTabelle"
   if Spalte1.Gettext <> 20% then Warnlog "- Value for Row 1 is not 20% but "+ Spalte1.Gettext
   if Spalte1.Gettext <> 20% then Warnlog "- Value for Row 3 is not 20% but "+ Spalte1.Gettext
   if Spalte1.Gettext <> 20% then Warnlog "- Value for Row 5 is not 20% but "+ Spalte1.Gettext
   TabSpaltenTabelle.OK
   '/// Close document ///
   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatJoinTables
  Dim i as integer , tabelle1 as string, tabelle2 as string , tabelle3 as string

   printLog "- Format / Join Tables"
   '/// New writerdocument ///
   Call hNewDocument
   Kontext "Navigator"
   If Navigator.Exists then Navigator.Close

   Call wDocSetContext
   '/// Insert 3 tables ///
   Call hTabelleEinfuegen
   Call sZahlenformatfuerZelle
   Call wDokSchreiben "<Down>"
   for i=1 to 2
     Call wDokSchreiben "25 <Down>"
     Call hTabelleEinfuegen
     Call sZahlenformatfuerZelle
     Call wDokSchreiben "25 <Down>"
     Call sZahlenformatfuerZelle
   next i
     Call wDokSchreiben "25 <Down>"

     EditNavigator
     Sleep 4
     sNavigatorInBrauchbarenZustand

   Kontext "NavigatorWriter"
   if Auswahlliste.GetItemCount < 4 then
     Warnlog "There has been " + Liste.GetItemCount + " instead of 3 Tables inserted!"
   else
   tabelle1=Auswahlliste.Getitemtext (2)
   tabelle2=Auswahlliste.GetItemText (3)
   tabelle3=Auswahlliste.GetItemText (4)
   endif

   Call wDokSchreiben "<Up><Up><Up><Up><Up><Up>"
   '/// Call Format / Merge tables ///
   FormatMergeTables
   Call wDokSchreiben "="
   Kontext "OL_SW_Rechenleiste"
   Eingabefeld.Settext "sum<A2:A4>"
   Eingabefeld.TypeKeys "<Return>"
   Call wDokSchreiben "<End>"
   Call wDokSchreiben "<Shift Home>"
   EditCopy
   Sleep 2
   '/// Check if tables have been merged ///
  if GetClipBoardText="75" then
    sNavigatorInBrauchbarenZustand
    Kontext "NavigatorWriter"
    if Auswahlliste.GetItemCount=3 then
     printlog tabelle1 + " and " + tabelle2 + " succesfully joined to " + Auswahlliste.GetItemText (2)
    else
     Warnlog "- " + tabelle1 + " and " + tabelle2 + "  not joined successfuly!"
    endif
  else
    Warnlog "- Calculating in joined table doesn't work!"
  endif
  Sleep 5

  Call wDokSchreiben "<Down><Down><Down><Down><Down>"
  FormatMergeTables
  Kontext "OL_SW_Tabelle"
  FormelEingeben.Click       ' AutoSumme bilden
  Kontext "OL_SW_Rechenleiste"
  Eingabefeld.TypeKeys "<Return>"
  Call wDokSchreiben "<End><Shift Home>"
  EditCopy

  if GetClipBoardText="100" then
    Kontext "NavigatorWriter"
    Sleep 2
    if Auswahlliste.GetItemCount=2 then
      printlog tabelle2 + " and " + tabelle3 + " succesfully joined to " + Auswahlliste.GetItemText (2)
    else
     Warnlog "- Table2 and Table3 not succesfully joined !"
    endif
  else
    Warnlog "- Calculating in joined table doesn't work!"
  endif

   '/// Close document ///
  Call hCloseDocument

endcase

' -------------------------------------------

testcase tFormatJoinTables_2
  Dim i as integer, dieTab1 as string, dieTab2 as string, dieTab3 as string
   select case iSprache
      case 01 : dieTab1 = "Table1"
                dieTab2 = "Table2"
                dieTab3 = "Table3"

      case 03 : dieTab1 = "Tabela1"
                dieTab2 = "Tabela2"
                dieTab3 = "Tabela3"

      case 31 : dieTab1 = "Tabel1"
                dieTab2 = "Tabel2"
                dieTab3 = "Tabel3"

      case 33 : dieTab1 = "Tableau1"
                dieTab2 = "Tableau2"
                dieTab3 = "Tableau3"

      case 34 : dieTab1 = "Tabla1"
                dieTab2 = "Tabla2"
                dieTab3 = "Tabla3"

      case 39 : dieTab1 = "Tabella1"
                dieTab2 = "Tabella2"
                dieTab3 = "Tabella3"

      case 45 : dieTab1 = "Tabel1"
                dieTab2 = "Tabel2"
                dieTab3 = "Tabel3"

      case 46 : dieTab1 = "Tabell1"
                dieTab2 = "Tabell2"
                dieTab3 = "Tabell3"

      case 48 : dieTab1 = "Tabela1"
                dieTab2 = "Tabela2"
                dieTab3 = "Tabela3"

      case 49 : dieTab1 = "Tabelle1"
                dieTab2 = "Tabelle2"
                dieTab3 = "Tabelle3"


      case else : if bAsianLan = False then
                   Warnlog "- You have to insert the word for 'Table' for this language!"
                  else
                   Printlog "Not in Asian-Version!"
                   goto endsub
                  endif
   end select


  Call hNewDocument
  '/// Open new Writerdocument ///
  Kontext "Navigator"
  If Navigator.Exists then Navigator.Close
  Kontext
  '/// Insert 3 Tables in document and set cursor to 2nd table ///
  for i=1 to 3
    Call hTabelleEinfuegen
    Call wDokSchreiben "<Down><Down>"
  next i
  Call wDokSchreiben "<Up>",3
   '/// Format / Join Tables ///
  FormatMergeTables
  Kontext "TabellenVerbinden"
   '/// In dialog check 'Join with previous table' and click 'ok' ///
  if TabellenVerbinden.Exists then
   MitVorherigerTabelleVerbinden.Check
   TabellenVerbinden.OK
  else
    Warnlog "- Dialog Join Tables not up!"
  endif

  EditNavigator
  Call wNavigatorAuswahl(2,0,True)
  Kontext "NavigatorWriter"
  Inhaltsansicht.Click

  if Auswahlliste.GetItemText(2) =dieTab2 and Auswahlliste.GetItemText(3)=dieTab3 then
    printlog "- joining with previous table succesfull!"
  else
    Warnlog "- Joining with previous table is not successfull!"
  endif
   '/// Check if table have been joined ///
  Kontext "Navigator"
  Navigator.Close

  Kontext
   '/// Edit / Undo ///
  EditUndo
  Sleep 5
  EditNavigator
  Call wNavigatorAuswahl(2,0,True)
  Kontext "NavigatorWriter"
  Inhaltsansicht.Click
  if Auswahlliste.GetItemCount=4 then
    printlog "- Undo Joining Tables is possible !"
  else
    Warnlog "- Not able to undo joining tables!"
  endif
  Kontext "Navigator"
  Navigator.Close

  Kontext
   '/// Call again / Format / Join Table ///
  FormatMergeTables
  Kontext "TabellenVerbinden"
   '/// In dialog check 'Join with next table' ///
  MitNachfolgenderTabelleVerbinden.Check
  TabellenVerbinden.OK
   '/// Close dialog with 'OK' and check if table have been joined ///
  Sleep 5
  EditNavigator
  Call wNavigatorAuswahl(2,0,False)
  Kontext "NavigatorWriter"
  Inhaltsansicht.Click
  if Auswahlliste.GetItemText(2) =dieTab1 and Auswahlliste.GetItemText(3)=dieTab2 then
    printlog "- joining with following table successful!"
  else
    Warnlog "- Joining with following table was not successful!"
  endif
  Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatSplitTables
  Dim i as integer,DerNameDanach as string
  Dim Tabelle1_Ueberschrift as string, Tabelle1_Standard as string
  Dim Tabelle2_Ueberschrift as string, Tabelle2_Standard as string
  Dim dieTab1 as string, dieTab2 as string, dieTab3 as string
   select case iSprache
      case 01 : dieTab1 = "Table1"
                dieTab2 = "Table2"
                dieTab3 = "Table3"

      case 03 : dieTab1 = "Tabela1"
                dieTab2 = "Tabela2"
                dieTab3 = "Tabela3"

      case 31 : dieTab1 = "Tabel1"
                dieTab2 = "Tabel2"
                dieTab3 = "Tabel3"

      case 33 : dieTab1 = "Tableau1"
                dieTab2 = "Tableau2"
                dieTab3 = "Tableau3"

      case 34 : dieTab1 = "Tabla1"
                dieTab2 = "Tabla2"
                dieTab3 = "Tabla3"

      case 39 : dieTab1 = "Tabella1"
                dieTab2 = "Tabella2"
                dieTab3 = "Tabella3"

      case 45 : dieTab1 = "Tabel1"
                dieTab2 = "Tabel2"
                dieTab3 = "Tabel3"

      case 46 : dieTab1 = "Tabell1"
                dieTab2 = "Tabell2"
                dieTab3 = "Tabell3"

      case 48 : dieTab1 = "Tabela1"
                dieTab2 = "Tabela2"
                dieTab3 = "Tabela3"

      case 49 : dieTab1 = "Tabelle1"
                dieTab2 = "Tabelle2"
                dieTab3 = "Tabelle3"

      case else : if bAsianLan = False then
                   Warnlog "- Insert Word ' Table ' for this language!"
                  else
                   Printlog "- Not in Asian-Version"
                   goto endsub
                  endif
   end select

   '/// New writerdocument ///
  Call hNewDocument

  Kontext "Navigator"
  If Navigator.Exists then Navigator.Close
  Call sSeiteMitBrauchbarerTabelleEinrichten
  '/// Insert 2 tables and add a header in each table ///
  Call wDokSchreiben "<Up>",5
  Sleep 2
  Kontext "OL_SW_Tabelle"
  Tabelle1_Ueberschrift=Vorlage.GetSelText
  Call wDokSchreiben "<Down>"
  Sleep 2
  Kontext "OL_SW_Tabelle"
  Tabelle1_Standard=Vorlage.GetSelText

  Call wDokSchreiben "<Down>"
  Sleep 2
  Kontext "OL_SW_Tabelle"
  Tabelle2_Ueberschrift=Vorlage.GetSelText
  Call wDokSchreiben "<Down>"
  Sleep 2
  Kontext "OL_SW_Tabelle"
  Tabelle2_Standard=Vorlage.GetSelText
  Call wDokSchreiben "<Up>"

  '/// Format / Join Tables and check if tbales have been joined ///
  FormatMergeTables
  EditNavigator
  Call sNavigatorInBrauchbarenZustand
  Kontext "NavigatorWriter"
  DerNameDanach=Auswahlliste.GetItemText(2)
  if DerNameDanach=dieTab1 then
    printlog "- Name of table after joining is:" + DerNameDanach
  else
    Warnlog "- After joining the tables the name is :" + DerNameDanach + " instead of " + dieTab1
  endif
  '/// Call Format / Split Table and in dialog select 'Copy heading' ///
  Kontext
  printlog "- Split table and copy heading"
    FormatSplitTable
    Kontext "TabelleAuftrennen"
    UeberschriftKopieren.Check
    TabelleAuftrennen.OK
    Sleep 3
   '/// Close dialog with 'OK' and check if table header has been copied ///
    Call sNavigatorInBrauchbarenZustand
    Sleep 3
    Kontext "NavigatorWriter"
    if Auswahlliste.GetItemCount > 1 then
     try
      Auswahlliste.Select 3
      if Auswahlliste.GetItemText(3)<>dieTab2 then Warnlog "- Tablename (Tabelle 2) after splitting in wrong order!"
     catch
      Warnlog "Maybe table has not been splitted!"
     endcatch
    else
     Warnlog " Maybe wrong document selected -> See Bug-ID: 81956"
    endif

    Call wDokSchreiben "<Up>"
    Sleep 2
    Call sZellinhaltInZwischenablage("berschrift 1","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Ueberschrift then  Warnlog "- Format Should:" + Tabelle1_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Down>"
    Sleep 2
    sZellinhaltInZwischenablage("berschrift 2","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle2_Ueberschrift then  Warnlog "- Format Should:" + Tabelle2_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Down>"
    Sleep 2
    sZellinhaltInZwischenablage("Text 2","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle2_Standard then  Warnlog "- Format Should:" + Tabelle2_Standard + " >> Format is: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Up>",5

    Kontext "NavigatorWriter"
    Auswahlliste.Select 2
    if Auswahlliste.GetItemText(2)<>dieTab1 then Warnlog "-  Tablename (Tabelle 1) after splitting in wrong order!"
   Call wDocSetContext
   Sleep 2
   Call sZellinhaltInZwischenablage("berschrift 1","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Ueberschrift then  Warnlog "- Format Should:" + Tabelle1_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText
    Call wDokSchreiben "<Down>"
    Sleep 2
    Call sZellinhaltInZwischenablage("Text 1","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Standard then  Warnlog "- Format Should:" + Tabelle1_Standard + " >> Format is: "+ Vorlage.GetSelText

   printlog "- Save document and reload!"
   '/// Save document and reload previous saved document ///
   if gApplication = "WRITER" then
    Call hSpeichernUnterKill(gOfficePath + "user\work\tabl1_1.sxw")
    Call hCloseDocument
    Call hDateioeffnen(gOfficePath + "user\work\tabl1_1.sxw")
   else
    Call hSpeichernUnterKill(gOfficePath + "user\work\tabl1_1.sxg")
    Call hCloseDocument
    Call hDateioeffnen(gOfficePath + "user\work\tabl1_1.sxg")
   endif
   '/// Check if settings have been saved ///

    Call wDokSchreiben "<Down>",3
    Call sNavigatorInBrauchbarenZustand
    Kontext "NavigatorWriter"
    try
     Auswahlliste.Select 3
     if Auswahlliste.GetItemText(3)<>dieTab2 then Warnlog "-  Tablename (Tabelle 2) after splitting in wrong order!"
    catch
     Warnlog "- Problem to select entry in Navigator. Maybe of Bug 81956!"
    endcatch

    Call wDokSchreiben "<Up>"
    Sleep 2
    Call sZellinhaltInZwischenablage("berschrift 1","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Ueberschrift then  Warnlog "- Format Should:" + Tabelle1_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Down>"
    Sleep 2
    Call sZellinhaltInZwischenablage("berschrift 2","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle2_Ueberschrift then  Warnlog "- Format Should:" + Tabelle2_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Down>"
    Sleep 2
    Call sZellinhaltInZwischenablage("Text 2","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle2_Standard then  Warnlog "- Format Should:" + Tabelle2_Standard + " >> Format is: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Up>",5


    Kontext "NavigatorWriter"
    try
     Auswahlliste.Select 2
     if Auswahlliste.GetItemText(2)<>dieTab1 then Warnlog "- Tablenname (Tabelle 1) after splitting wrong!"
    catch
      Warnlog "- Problem to select entry in Navigator. Maybe of Bug 81956!"
    endcatch

   Call wDocSetContext
   Sleep 2
   sZellinhaltInZwischenablage("berschrift 1","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Ueberschrift then  Warnlog "- Format Should:" + Tabelle1_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText
    Call wDokSchreiben "<Down>"
    Sleep 2
    Call sZellinhaltInZwischenablage("Text 1","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Standard then  Warnlog "- Format Should:" + Tabelle1_Standard + " >> Format is: "+ Vorlage.GetSelText
    Kontext "Navigator"
    if Navigator.Exists then Navigator.Close
   '/// Close document ///
    Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatSplitTables_2
  Dim i as integer,DerNameDanach as string
  Dim Tabelle1_Ueberschrift as string, Tabelle1_Standard as string
  Dim Tabelle2_Ueberschrift as string, Tabelle2_Standard as string
  Dim dieTab1 as string, dieTab2 as string, dieTab3 as string

   select case iSprache
      case 01 : dieTab1 = "Table1"
                dieTab2 = "Table2"
                dieTab3 = "Table3"

      case 03 : dieTab1 = "Tabela1"
                dieTab2 = "Tabela2"
                dieTab3 = "Tabela3"

      case 31 : dieTab1 = "Tabel1"
                dieTab2 = "Tabel2"
                dieTab3 = "Tabel3"

      case 33 : dieTab1 = "Tableau1"
                dieTab2 = "Tableau2"
                dieTab3 = "Tableau3"

      case 34 : dieTab1 = "Tabla1"
                dieTab2 = "Tabla2"
                dieTab3 = "Tabla3"

      case 39 : dieTab1 = "Tabella1"
                dieTab2 = "Tabella2"
                dieTab3 = "Tabella3"

      case 45 : dieTab1 = "Tabel1"
                dieTab2 = "Tabel2"
                dieTab3 = "Tabel3"

      case 46 : dieTab1 = "Tabell1"
                dieTab2 = "Tabell2"
                dieTab3 = "Tabell3"

      case 48 : dieTab1 = "Tabela1"
                dieTab2 = "Tabela2"
                dieTab3 = "Tabela3"

      case 49 : dieTab1 = "Tabelle1"
                dieTab2 = "Tabelle2"
                dieTab3 = "Tabelle3"

      case else : if bAsianLan = False then
                   Warnlog "- Insert Word 'Table' for this language!"
                  else
                   Printlog "- Not in Asian-Version!"
                   goto endsub
                  endif
   end select

  Call hNewDocument
  '/// New Writerdocument ///
  Kontext "Navigator"
  If Navigator.Exists then Navigator.Close
   '/// Insert 2 tables and a header in each table ///
  Call sSeiteMitBrauchbarerTabelleEinrichten
  Call wDokSchreiben "<Up>",5
  Sleep 2
  Kontext "OL_SW_Tabelle"
  Tabelle1_Ueberschrift=Vorlage.GetSelText
  Call wDokSchreiben "<Down>"
  Sleep 2
  Kontext "OL_SW_Tabelle"
  Tabelle1_Standard=Vorlage.GetSelText

  Call wDokSchreiben "<Down>"
  Sleep 2
  Kontext "OL_SW_Tabelle"
  Vorlage.Select Tabelle1_Standard
  Tabelle2_Ueberschrift=Vorlage.GetSelText
  Call wDokSchreiben "<Down>"
  Sleep 2
  Kontext "OL_SW_Tabelle"
  Tabelle2_Standard=Vorlage.GetSelText
  Call wDokSchreiben "<Up>"

  FormatMergeTables
  '/// Format / Join Table / and check if tables have been joined ///
  EditNavigator
  Call sNavigatorInBrauchbarenZustand
  Kontext "NavigatorWriter"

  DerNameDanach=Auswahlliste.GetItemText(2)
  if DerNameDanach=dieTab1 then
    printlog "- Name of table after joining is:" + DerNameDanach
  else
    Warnlog "- Name of the table is :" + DerNameDanach + " instead of " + dieTab1
  endif

  Kontext
  printlog "- Split table, Custom heading (apply style)"
   '/// Format / Split Table and select in dialog Custom heading (apply style) ///
    FormatSplitTable
    Kontext "TabelleAuftrennen"
    EigeneMitVorlage.Check
    TabelleAuftrennen.OK
    Sleep 3
   '/// Close dialog with 'OK' and check if changes have been made ///

    sNavigatorInBrauchbarenZustand
    Sleep 3
    Kontext "NavigatorWriter"
    try
      Auswahlliste.Select 3
      if Auswahlliste.GetItemText(3)<>dieTab2 then Warnlog "-  Tablename (Tabelle 2) after splitting in wrong order!"
    catch
      Warnlog "Maybe table has not been splitted!"
    endcatch

    Call wDocSetContext
    Sleep 2
    Call sZellinhaltInZwischenablage("berschrift 2","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Ueberschrift then  Warnlog "- Format Should:" + Tabelle1_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Down>"
    Sleep 2
    Call sZellinhaltInZwischenablage("Text 2","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle2_Standard then  Warnlog "- Format Should:" + Tabelle2_Standard + " >> Format is: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Up>",5

    Kontext "NavigatorWriter"
    Auswahlliste.Select 2
    if Auswahlliste.GetItemText(2)<>dieTab1 then Warnlog "-  Tablename (Tabelle 1) after splitting in wrong order!"
    Call wDocSetContext
   Sleep 2
   Call sZellinhaltInZwischenablage("berschrift 1","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Ueberschrift then  Warnlog "- Format Should:" + Tabelle1_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText
      Call wDokSchreiben "<Down>"
      Sleep 2
      Call sZellinhaltInZwischenablage("Text 1","berschrift kopieren")
      Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Standard then  Warnlog "- Format Should:" + Tabelle1_Standard + " >> Format is: "+ Vorlage.GetSelText

    Printlog "- Save and reload document!"
   '/// Save document and reload previous saved document ///
    if gApplication = "WRITER" then
     Call hSpeichernUnterKill(gOfficePath + "user\work\tabl1_1.sxw")
     Call hCloseDocument
     Call hDateioeffnen(gOfficepath + "user\work\tabl1_1.sxw")
    else
     Call hSpeichernUnterKill(gOfficePath + "user\work\tabl1_1.sxg")
     Call hCloseDocument
     Call hDateioeffnen(gOfficepath + "user\work\tabl1_1.sxg")
    endif

    Call sNavigatorInBrauchbarenZustand
    Kontext "NavigatorWriter"

    if Auswahlliste.GetItemCount > 1 then
     Auswahlliste.Select 3
     if Auswahlliste.GetItemText(3)<>dieTab2 then Warnlog "-  Tablename (Tabelle 2) after splitting in wrong order!"
    else
     Warnlog "- Maybe wrong document selected -> See Bug ID: 81956"
    endif
   '/// Check if changes have been saved ///

    Call wDokSchreiben "<Down>",2
    Sleep 2
    Call sZellinhaltInZwischenablage("berschrift 2","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Ueberschrift then  Warnlog "- Format Should:" + Tabelle1_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Down>"
    Sleep 2
    Call sZellinhaltInZwischenablage("Text 2","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle2_Standard then  Warnlog "- Format Should:" + Tabelle2_Standard + " >> Format ist: "+ Vorlage.GetSelText

    Call wDokSchreiben "<Up>",5

    Kontext "NavigatorWriter"
    if Auswahlliste.GetItemCount > 1 then
     Auswahlliste.Select 2
     if Auswahlliste.GetItemText(2)<>dieTab1 then Warnlog "-  Tablename (Tabelle 1) after splitting in wrong order!"
    else
     Warnlog "- Maybe wrong document selected -> See Bug ID: 81956"
    endif
    Call wDocSetContext
   Sleep 2
   Call sZellinhaltInZwischenablage("berschrift 1","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Ueberschrift then  Warnlog "- Format Should:" + Tabelle1_Ueberschrift + " >> Format is: "+ Vorlage.GetSelText
    Call wDokSchreiben "<Down>"
    Sleep 2
    Call sZellinhaltInZwischenablage("Text 1","berschrift kopieren")
    Kontext "OL_SW_Tabelle"
    if Vorlage.GetSelText<>Tabelle1_Standard then  Warnlog "- Format Should:" + Tabelle1_Standard + " >> Format is: "+ Vorlage.GetSelText
   '/// Close writerdocument ///
    Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatCharacter
   printLog "- Format / Character in tables"
   '/// Deactivate in Options 'Number format recognition' ///

   ToolsOptions
   Kontext "ExtrasOptionenDLG"
   Call hToolsOptions("TextDocument","Table")
   if Zahlenformaterkennung.IsChecked then
     Zahlenformaterkennung.Uncheck
     printlog "-  Number format recognition not checked"
   endif
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

   '/// New Writerdocument and insert a table ///
   Call hNewDocument
   Call hTabelleEinfuegen
   '/// Insert in cell '1.' and leave cell with tab ///
   Call wDokSchreiben "1.<Tab>"
   Call wDokSchreiben "<Shift Tab><Shift End>"
   EditCopy
   '/// Check if Number has been converted ///
   if GetClipboardText <> "1." then Warnlog "-   Number has been converted to date "
   Call wDokSchreiben "<End><Tab>"
   '/// Call Format / Number Format and change Format to date ///
   FormatNumberFormat
   Kontext "Zahlenformat"
   Kategorie.Select 6
   Zahlenformat.OK

   Call wDokSchreiben "1.<Tab>"
   Call wDokSchreiben "<Shift Tab><Shift End>"
   EditCopy
   if GetClipboardText = "1." then Warnlog "-   Number has not been converted to date!"
   Call wDokSchreiben "<End><Tab>"
   '/// Reenter a '1.' in cell and leave with tab, check if number has been converted ///

   ToolsOptions
   '/// Activate Number recognition' in Options ///
   Kontext "ExtrasOptionenDLG"
   Call hToolsOptions("TextDocument","Table")
   if Not Zahlenformaterkennung.IsChecked then
    Zahlenformaterkennung.Check
    printlog "-  Number format recognition checked"
   endif
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

   '/// Enter a '1.' in cell, leave with 'Tab' and check if number has been converted ///
   Call wDokSchreiben "1.<Tab>"
   Call wDokSchreiben "<Shift Tab><Shift End>"
   EditCopy
   if GetClipboardText = "1." then Warnlog "-   Number has not been converted to date!"
   Call wDokSchreiben "<End><Tab>"

   '/// Close document ///
   Call hCloseDocument

endcase

' -------------------------------------------

testcase tFormatCellSplit
  Dim i : Dim Zaehler
   '/// New Writerdocument and insert a table ///
   Call hNewDocument
   Call hTabelleEinfuegen

  printlog "   - split vertical"
   '/// Format / Cell / Split / Set number to 4 and check 'vertical' ///
   FormatCellSplit
   Kontext "ZellenTeilen"
   Anzahl.SetText "4"
   Vertikal.Check
   ZellenTeilen.OK


  printlog "   - check"
   '/// Check if cell has been splitted vertical in 4 cells ///
   FormatTable
   Kontext
   Active.SetPage TabSpaltenTabelle
   Kontext "TabSpaltenTabelle"
   wait 200
   if Weiter.Exists AND Weiter.IsEnabled then
      if NOT ( Spalte1.GetText = Spalte2.GetText AND Spalte3.GetText = Spalte4.GetText ) then Warnlog "Not 4 columns inserted"
   else
      Warnlog "No columns have been created"
   end if
   wait 200
   TabSpaltenTabelle.Cancel
   '/// Call Edit / Undo ///
   EditUndo

  printlog "   - split horizontal"
   Call wDokSchreiben "<Down>Hallo<Up>"
   '/// Call Format / Cell Split / enter as number 4 and check 'Horizontal' ///
   FormatCellSplit
   Kontext "ZellenTeilen"
   Anzahl.SetText "4"
   Horizontal.Check
   ZellenTeilen.OK

  printlog "   - check"
   '/// Check if cell has been splitted horizontally in 4 Cells ///
   Zaehler = 0
   for i=1 to 4
      Zaehler = Zaehler+1
      Call wDokSchreiben "<Down><Home><Shift End>"
      try
          EditCopy
      catch
      endcatch
      if GetClipboardText = "Hallo" then i = 100
   next i
   if Zaehler <> 4 then Warnlog "After splitting not 4 columns inserted"
   '/// Close document ///
   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatCellProtect
   '/// New writerdocument and insert a table ///
   Call hNewDocument
   Call hTabelleEinfuegen

  printlog "- protect cell"
   Call wDokSchreiben "Protect"
   '/// Select Format / Cell / Protect ///
   FormatCellProtect
   Call wDokSchreiben "<Mod1 Home>"  ' Point cursor to first cell
   Call wDokSchreiben "<Mod1 A>"     ' Select cell content
   '/// try to insert a text in protected cell, a message has to appear ///
   EditCopy
   if GetClipboardText = "Protect" then
      Call wDokSchreiben "<SPACE>"
      Kontext "Active"
      if Active.Exists then
         Active.OK
         printlog "- protected cell can not be overwritten"
      else
         Warnlog "- Able to overwrite protected cell content!"
      endif
   else
      QAErrorLog "- Cursor-Position wrong finding cell content !"
   endif

  printlog "- unprotect cell"
   '/// Unprotect cell with Format / Cell / Unprotect ///
   '/// Check if cell has been unprotected  ///
   Call wDokSchreiben "<Mod1 Home>"
   Call wDokSchreiben "<Mod1 A>"     ' Select cell content
   EditCopy
   if GetClipboardText <> "Protect" then
      try
       FormatCellUnprotect
      catch
        Warnlog "- Unable to unprotect cell, Menu is disabled!"
      endcatch
   else
      try
        FormatCellUnprotect
      catch
        printlog "- Cell protect for only one cell can not be done !"
      endcatch
   endif
   Kontext
   '/// Close document ///
   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatCellMerge
   '/// New writerdocument and insert a table ///
   Call hNewDocument
   Call wDokSchreiben "Ende<Home>"
   Call hTabelleEinfuegen

  printlog "   - Merge cell"
   Call wDokSchreiben "<Up><Left>", 4
   Call wDokSchreiben "Verbunden<Shift Right>"
   '/// Select  Format / Cell / Merge and check if cells have been merged ///
   FormatCellMerge

  printlog "   - check"
   Call wDokSchreiben "<Down>", 4
   Call wDokSchreiben "<End><Shift Home>"
   try
       EditCopy
   catch
       Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
   endcatch

   if GetClipboardText = "Ende" then
      SetClipboard = ""
      Call wDokSchreiben "<Left>", 8
      Call wDokSchreiben "<Shift Home>"
      try
        EditCopy
      catch
      endcatch
      if GetClipBoardText <> "" then
         Warnlog "To much cells have been merged"
      else
         Call wDokSchreiben "<Left>"
         Call wDokSchreiben "<Shift Home>"
         try
            EditCopy
         catch
         endcatch
         if GetClipBoardText = "Verbunden " then
            Warnlog "No Bug and no Featurewish has been worked: On merging cells there has been created an Space character or an empty paragraph."
         else
            if Trim$(GetClipboardText) <> "Verbunden" then Warnlog "Cells have not been merged correctly"
         end if
      end if
   end if
   '/// Close document ///
   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatCellAlignment
   '/// New writerdocument and insert a table ///
   Call hNewDocument
   Call hTabelleEinfuegen

  printlog "   - check vertical alignment for numbers and characters"
   Call wDokSchreiben "1<Right><Left>"

   '/// Format / Table ///
   FormatTable
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if NOT Unten.IsChecked then Warnlog "Vertical alignment: Bottom is not checked for numbers"
   TabTextflussTabelle.Cancel

   Call wDokSchreiben "<Right>Hallo<Right><Left>"
   FormatTable
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if NOT Oben.IsChecked then Warnlog "Vertical alignment: Bottom is not checked for characters"
   TabTextflussTabelle.Cancel

  printlog "   - modify vertical alignment and check it"
   Call wDokSchreiben "<Right>Richard Lwenherz<Right><Left>"
   FormatCellCenter
   FormatTable
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if NOT Mitte.IsChecked then Warnlog "Vertical alignment: Centered is not checked"
   TabTextflussTabelle.Cancel

   FormatCellTop
   FormatTable
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if NOT Oben.IsChecked then Warnlog "Vertical alignment: Top is not checked"
   TabTextflussTabelle.Cancel

   FormatCellBottom
   FormatTable
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if NOT Unten.IsChecked then Warnlog "Vertical alignment: Bottom is not checked"
   TabTextflussTabelle.Cancel

   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatRowHeight
  Dim sH as String
   Call hNewDocument
   Call hTabelleEinfuegen

  printlog "   - modify and check Row Height"
   FormatRowHeight
   Kontext "ZellenHoehe"
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
      Hoehe.SetText "1.5"
   else
      Hoehe.SetText "1,5"
   end if
   sH = Hoehe.GetText
   Dynamisch.Uncheck
   ZellenHoehe.OK
   FormatCharacter
   Kontext
   Active.SetPage TabFont
   Kontext "TabFont"
   try
    SizeWest.Select SizeWest.GetItemCount
   catch
    Size.Select Size.GetItemCount
   endcatch
   TabFont.OK
   Call wDokSchreiben "Ha"
   FormatRowHeight
   Kontext "ZellenHoehe"
   if Hoehe.GetText <> sH then Warnlog "Row height is not " + sH  + " but "+Hoehe.GetText
   if Dynamisch.IsChecked then Warnlog "Fit to size is checked again"
   ZellenHoehe.Cancel

  printlog "   - modify Row Height to optimal"
   FormatRowOptimalHeight
   FormatRowHeight
   Kontext "ZellenHoehe"
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
    if iSystemSprache = 48 then
     if Hoehe.GetText <> "0.01" + mUnit then Warnlog "Row height has not been set to default, is: "+Hoehe.GetText
    else
     if Hoehe.GetText <> "0.01" + mUnit then Warnlog "Row height has not been set to default, is: "+Hoehe.GetText
    endif
   else
      if Hoehe.GetText <> "0,01" + mUnit then Warnlog "Row height has not been set to default, is: "+Hoehe.GetText
   end if
   if NOT Dynamisch.IsChecked then Warnlog "Fit to size is not checked"
   ZellenHoehe.Cancel

  printlog "   - Space equally Row height"
   Call wDokSchreiben "<Shift Down>"
   FormatRowSpaceEqually

   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatRow
   Call hNewDocument
   Call hTabelleEinfuegen
   Call wDokSchreiben "1. Zeile"

  printlog "   - select row"
   FormatRowSelect

  printlog "   - Insert row before"
   FormatRowInsert
   Kontext "EinfuegenZeilen"
   Anzahl.SetText "1"
   Davor.Check
   EinfuegenZeilen.OK

   Call wDokSchreiben "<Shift Tab>", 4
   Call wDokSchreiben "<Up><Down><End><Shift Home>"
   EditCopy
   if GetClipboardText <> "1. Zeile" then Warnlog "Row has not been inserted before"

  printlog "   - Insert row after"
   FormatRowInsert
   Kontext "EinfuegenZeilen"
   Anzahl.SetText "1"
   Dahinter.Check
   EinfuegenZeilen.OK

   Call wDokSchreiben "<Down>", 3
   Call wDokSchreiben "<Up>", 3
   Call wDokSchreiben "<End><Shift Home>"
   EditCopy
   if GetClipboardText <> "1. Zeile" then Warnlog "Row has not been inserted before"

  printlog "   - delete row"
   FormatRowDelete
   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatColumnWidth
  Dim Vergleich1$, Vergleich2$
  Dim AlterWert$
   Call hNewDocument
   Call hTabelleEinfuegen

  printlog "  - modify column width"
   FormatColumnWidthWriter
   Kontext "SpaltenBreite"
   Spalte.SetText "1"
   Breite.SetText "3"
   Vergleich1$ = Breite.GetText
   SpaltenBreite.OK

   FormatColumnWidthWriter
   Kontext "SpaltenBreite"
   Spalte.SetText "3"
   Breite.SetText "2"
   Vergleich2$ = Breite.GetText
   SpaltenBreite.OK

  printlog "  - check column width"
   FormatColumnWidthWriter
   Kontext "SpaltenBreite"
   Spalte.SetText "1"
   if Breite.GetText <> Vergleich1$ then Warnlog "Column width 1 is not " + Vergleich1$ + " but "+ Breite.GetText
   SpaltenBreite.OK

   FormatColumnWidthWriter
   Kontext "SpaltenBreite"
   Spalte.SetText "3"
   if Breite.GetText <> Vergleich2$ then Warnlog "Column width 3 is not "+Vergleich2$+" but "+ Breite.GetText
   SpaltenBreite.OK

  printlog "  - modify width to optimal"
   Call wDokSchreiben "Dies ist ein langer Text, HALLO HALLO"
   Call wDokSchreiben "<Shift Right>", 4
   FormatColumnOptimalWidthWriter

   FormatColumnWidthWriter
   Kontext "SpaltenBreite"
   Spalte.SetText "1"
   if Breite.GetText = Vergleich1$ then Warnlog "Column width1 has not been changed"
   AlterWert$ = Breite.GetText
   SpaltenBreite.OK

  printlog "  - Space equally columns"
   Call wDokSchreiben "<Shift Down>"
   FormatColumnSpaceEqually
   Call wDokSchreiben "<Right><Left>"

   FormatColumnWidthWriter
   Kontext "SpaltenBreite"
   Spalte.SetText "1"
   if Breite.GetText = AlterWert$ then Warnlog "Column width1 has not been changed"
   SpaltenBreite.OK

   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatColumn
  Dim AlterWert$
   Call hNewDocument
   Call hTabelleEinfuegen

   Call wDokSchreiben "Hallo 1. Feld"

  printlog "  - mark column"
   FormatColumnSelect

  printlog "  - Insert column before"
   FormatColumnInsert
   Kontext "EinfuegenSpalten"
   Anzahl.SetText "1"
   Davor.Check
   EinfuegenSpalten.OK

   Call wDokSchreiben "<Up><Shift Tab><Home><Shift End>"
   try
    EditCopy
    if GetClipboardText <> "" then Warnlog "Column has not been inserted before"
   catch
   endcatch

  printlog "  - Insert column after"
   Call wDokSchreiben "<Tab>"
   FormatColumnSelect
   FormatColumnInsert
   Kontext "EinfuegenSpalten"
   Anzahl.SetText "1"
   Dahinter.Check
   EinfuegenSpalten.OK

   Call wDokSchreiben "<Left>", 7
   Call wDokSchreiben "<Shift Home>"
   try
       EditCopy
   catch
       Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
   endcatch
   if GetClipboardText = "" then Warnlog "Column has not been inserted after"

  printlog "  - delete column"
   FormatColumnDelete

   Call hCloseDocument
endcase

' -------------------------------------------

testcase tFormatAutoformatTable
  Dim Zaehler : Dim i
   Call hNewDocument
   Call hTabelleEinfuegen

  PrintLog "   - all Formats in Tables"
   FormatAutoformat
   Kontext "AutoformatTabelle"
   Zaehler = FormatBox.GetItemCount

   for i=1 to Zaehler
      FormatBox.Select i
      AutoformatTabelle.OK
      Wait 500
      FormatAutoformat
      Kontext "AutoformatTabelle"
   next i

  PrintLog "   - insert an own format"
   Einfuegen.Click
   Kontext "AutoformatHinzufuegenWriter"
   TabellenName.SetText "Testtool"
   AutoformatHinzufuegenWriter.OK
   Sleep 2
   Kontext "AutoformatTabelle"
   AutoformatTabelle.OK

  PrintLog "   - delete own format"
   FormatAutoformat
   Kontext "AutoformatTabelle"
   try
    FormatBox.Select "Testtool"
    Loeschen.Click
   catch
    Warnlog "Probably own format has not been inserted! (Bug:83301)"
   endcatch
   Kontext
   Active.OK
   Kontext "AutoformatTabelle"
   try
      FormatBox.Select "Testtool"
      Warnlog "Own format has not been deleted"
   catch
   endcatch
   AutoformatTabelle.OK

   Call hCloseDocument
endcase
