--TEST--
maxdb autocommit/commit/rollback
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";
	
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

	maxdb_autocommit($link, TRUE);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE ac_01");
        maxdb_report (MAXDB_REPORT_ERROR);

	maxdb_query($link,"CREATE TABLE ac_01(a int, b varchar(10))");

	maxdb_query($link, "INSERT INTO ac_01 VALUES (1, 'foobar')");
	maxdb_autocommit($link, FALSE);

	maxdb_query($link, "DELETE FROM ac_01");
	maxdb_query($link, "INSERT INTO ac_01 VALUES (2, 'egon')");

	maxdb_rollback($link);

	$result = maxdb_query($link, "SELECT * FROM ac_01");
	$row = maxdb_fetch_row($result);
	maxdb_free_result($result);

	var_dump($row);

	maxdb_query($link, "DELETE FROM ac_01");
	maxdb_query($link, "INSERT INTO ac_01 VALUES (2, 'egon')");
	maxdb_commit($link);

	$result = maxdb_query($link, "SELECT * FROM ac_01");
	$row = maxdb_fetch_row($result);
	maxdb_free_result($result);

	var_dump($row);

	maxdb_close($link);
?>
--EXPECT--
array(2) {
  [0]=>
  int(1)
  [1]=>
  string(6) "foobar"
}
array(2) {
  [0]=>
  int(2)
  [1]=>
  string(4) "egon"
}
