///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "div_div.h"
#include "rheolef/ublas_matrix_range.h"

namespace rheolef {

using namespace std;
using namespace ublas;

template<class T, class M>
void
div_div<T,M>::operator() (const geo_element& K, matrix<T>& dd) const
{
  check_macro (! base::is_on_band(), "unsupported banded level set extension");
  base::build_div_div (K, dd);
  // TODO: axisymmetric : add terms
}
template<class T, class M>
void
div_div<T,M>::initialize () const
{
  base::set_n_derivative(2);
  size_type d = base::get_first_space().get_geo().dimension();
  check_macro (
	d == base::get_first_space().size() && 
	d == base::get_second_space().size(),
	"unsupported non-vectorial space for `div_div' form");

  // TODO: axisymmetric : add terms
  check_macro (base::coordinate_system() == space_constant::cartesian,
	"axisymmetric `div_div' form not yet implemented");
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class div_div<Float,sequential>;

#ifdef _RHEOLEF_HAVE_MPI
template class div_div<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
