/* HP Scanjet 3900 series - RTS8822 internal config

   Copyright (C) 2005 Jonathan Bravo Lopez <jkdsoft@gmail.com>

   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
*/

/* Inline config reading functions */
static int get_value (int section, int option, int defvalue, int file);
static double get_lvalue (int section, int option, double defvalue, int file);

/*
These functions are used when reading config from files
char	*strlwr(char *string);
void	*ltrim(char *texto);
int		GetValue(char *section, char *option, int defvalue, char *file);
double GetLValue(char *section, char *option, double defvalue, char *file);
char	*GetStrValue(char *section, char *option, char *file);
*/

/* ----- Implementation ----- */

enum ConfigFiles
{
  FITCALIBRATE = 0,
  MOTORCURVE1,
  MOTORCURVE2,
  MOTORCURVE3,
  MOTORCURVE4,
  MOTORCURVE5,
  MOTORCURVE6,
  MOTORCURVE7,
  MOTORCURVE8,
  T_RTINIFILE,
  T_USB1INIFILE,
  T_TIMING1,
  T_TIMING2,
  T_TIMING3,
  T_TIMING4,
  T_TIMING5,
  T_TIMING6,
  T_TIMING7,
  T_TIMING8,
  T_TIMING9,
  T_TIMING10,
  T_TIMING11,
  T_TIMING12,
  S_RTINIFILE,
  S_USB1INIFILE,
  S_TIMING1,
  S_TIMING2,
  S_TIMING3,
  S_TIMING4,
  S_TIMING5,
  S_TIMING6,
  S_TIMING7,
  S_TIMING8,
  S_TIMING9,
  S_TIMING10,
  S_TIMING11,
  S_TIMING12
};

enum mcsecs
{
  MOTORSETTING = 0,
  ACC,
  DEC,
  ACCCURVE1,
  ACCCURVE2,
  ACCCURVE3,
  DECCURVE1,
  DECCURVE2,
  DECCURVE3,
  DECCURVE4
};

enum mcsec1
{
  ACCCURVECOUNT = 9999,
  DECCURVECOUNT,
  MRI,
  MSI,
  SKIPLINECOUNT,
  NORMALSCAN,
  PARKHOME,
  SMEARING,
  SCANBUFFERFULL,
  MINSPEED,
  MAXSPEED,
  COUNT
};

enum fcsec6
{
  PIDVID = 0,
  SONY_LAMP,
  TOSHIBA_LAMP,
  CHECKSTABLE,
  AUTOREFPOS,
  CALIBREFLECTIVE,
  CALIBTRANSPARENT,
  CALIBNEGATIVEFILM,
  SCANINFO,
  SCAN_CALI,
  FLBSCANYSTART,
  CCDTYPE,
  WARMUPT1,
  WARMUPT2,
  UCCDTYPE,
  TA_STRIPTOSCAN,
  HIGAINDEFAULTPWM,
  LOGAINDEFAULTPWM,
  T_USB2FIXEDPWM,
  T_USB1FIXEDPWM,
  T_USB2FIXEDPWM_TA,
  T_USB1FIXEDPWM_TA,
  T_USB2FIXEDPWM_NEG,
  T_USB1FIXEDPWM_NEG,
  S_USB2FIXEDPWM,
  S_USB1FIXEDPWM,
  S_USB2FIXEDPWM_TA,
  S_USB1FIXEDPWM_TA,
  S_USB2FIXEDPWM_NEG,
  S_USB1FIXEDPWM_NEG,
  WARMUPDEFSEARCH,
  USB2_LAMP_MAX_100,
  USB2_LAMP_MIN_100,
  USB2_PWM_100,
  USB2_LAMP_MAX_200,
  USB2_LAMP_MIN_200,
  USB2_PWM_200,
  USB2_LAMP_MAX_300,
  USB2_LAMP_MIN_300,
  USB2_PWM_300,
  USB2_LAMP_MAX_600,
  USB2_LAMP_MIN_600,
  USB2_PWM_600,
  USB2_LAMP_MAX_1200,
  USB2_LAMP_MIN_1200,
  USB2_PWM_1200,
  USB2_LAMP_MAX_2400,
  USB2_LAMP_MIN_2400,
  USB2_PWM_2400,
  USB1_LAMP_MAX_100,
  USB1_LAMP_MIN_100,
  USB1_PWM_100,
  USB1_LAMP_MAX_200,
  USB1_LAMP_MIN_200,
  USB1_PWM_200,
  USB1_LAMP_MAX_300,
  USB1_LAMP_MIN_300,
  USB1_PWM_300,
  USB1_LAMP_MAX_600,
  USB1_LAMP_MIN_600,
  USB1_PWM_600,
  USB1_LAMP_MAX_1200,
  USB1_LAMP_MIN_1200,
  USB1_PWM_1200,
  USB1_LAMP_MAX_2400,
  USB1_LAMP_MIN_2400,
  USB1_PWM_2400,
  PREVIEW_DIFF,
  PREVIEW_INTERVAL,
  PREVIEW_TOTTIME,
  FLB_DIFF,
  FLB_INTERVAL,
  FLB_TOTTIME,
  TMA_DIFF,
  TMA_INTERVAL,
  TMA_TOTTIME,
  AUTOFINDREFPOS,
  LEROFFSET,
  SEROFFSET,
  SAVEAUTOREFFILE,
  EXTERNBOUNDARY,
  T2952_STARTEFFECTIVEPIXEL_2400,
  T2952_STARTEFFECTIVEPIXEL_1200,
  T2952_STARTEFFECTIVEPIXEL_600,
  S575_STARTEFFECTIVEPIXEL_2400,
  S575_STARTEFFECTIVEPIXEL_1200,
  S575_STARTEFFECTIVEPIXEL_600,
  WSTRIPXPOS,
  WSTRIPYPOS,
  BSTRIPXPOS,
  BSTRIPYPOS,
  U2_S_8B_24D_WREF_R,
  U2_S_8B_24D_WREF_G,
  U2_S_8B_24D_WREF_B,
  U2_S_16B_24D_WREF_R,
  U2_S_16B_24D_WREF_G,
  U2_S_16B_24D_WREF_B,
  U1_S_8B_24D_WREF_R,
  U1_S_8B_24D_WREF_G,
  U1_S_8B_24D_WREF_B,
  U1_S_16B_24D_WREF_R,
  U1_S_16B_24D_WREF_G,
  U1_S_16B_24D_WREF_B,
  U2_S_8B_12D_WREF_R,
  U2_S_8B_12D_WREF_G,
  U2_S_8B_12D_WREF_B,
  U2_S_16B_12D_WREF_R,
  U2_S_16B_12D_WREF_G,
  U2_S_16B_12D_WREF_B,
  U1_S_8B_12D_WREF_R,
  U1_S_8B_12D_WREF_G,
  U1_S_8B_12D_WREF_B,
  U1_S_16B_12D_WREF_R,
  U1_S_16B_12D_WREF_G,
  U1_S_16B_12D_WREF_B,
  U2_S_8B_6D_WREF_R,
  U2_S_8B_6D_WREF_G,
  U2_S_8B_6D_WREF_B,
  U2_S_16B_6D_WREF_R,
  U2_S_16B_6D_WREF_G,
  U2_S_16B_6D_WREF_B,
  U1_S_8B_6D_WREF_R,
  U1_S_8B_6D_WREF_G,
  U1_S_8B_6D_WREF_B,
  U1_S_16B_6D_WREF_R,
  U1_S_16B_6D_WREF_G,
  U1_S_16B_6D_WREF_B,
  U2_S_8B_3D_WREF_R,
  U2_S_8B_3D_WREF_G,
  U2_S_8B_3D_WREF_B,
  U2_S_16B_3D_WREF_R,
  U2_S_16B_3D_WREF_G,
  U2_S_16B_3D_WREF_B,
  U1_S_8B_3D_WREF_R,
  U1_S_8B_3D_WREF_G,
  U1_S_8B_3D_WREF_B,
  U1_S_16B_3D_WREF_R,
  U1_S_16B_3D_WREF_G,
  U1_S_16B_3D_WREF_B,
  U2_S_8B_2D_WREF_R,
  U2_S_8B_2D_WREF_G,
  U2_S_8B_2D_WREF_B,
  U2_S_16B_2D_WREF_R,
  U2_S_16B_2D_WREF_G,
  U2_S_16B_2D_WREF_B,
  U1_S_8B_2D_WREF_R,
  U1_S_8B_2D_WREF_G,
  U1_S_8B_2D_WREF_B,
  U1_S_16B_2D_WREF_R,
  U1_S_16B_2D_WREF_G,
  U1_S_16B_2D_WREF_B,
  U2_S_8B_1D_WREF_R,
  U2_S_8B_1D_WREF_G,
  U2_S_8B_1D_WREF_B,
  U2_S_16B_1D_WREF_R,
  U2_S_16B_1D_WREF_G,
  U2_S_16B_1D_WREF_B,
  U1_S_8B_1D_WREF_R,
  U1_S_8B_1D_WREF_G,
  U1_S_8B_1D_WREF_B,
  U1_S_16B_1D_WREF_R,
  U1_S_16B_1D_WREF_G,
  U1_S_16B_1D_WREF_B,
  U2_T_8B_24D_WREF_R,
  U2_T_8B_24D_WREF_G,
  U2_T_8B_24D_WREF_B,
  U2_T_16B_24D_WREF_R,
  U2_T_16B_24D_WREF_G,
  U2_T_16B_24D_WREF_B,
  U1_T_8B_24D_WREF_R,
  U1_T_8B_24D_WREF_G,
  U1_T_8B_24D_WREF_B,
  U1_T_16B_24D_WREF_R,
  U1_T_16B_24D_WREF_G,
  U1_T_16B_24D_WREF_B,
  U2_T_8B_12D_WREF_R,
  U2_T_8B_12D_WREF_G,
  U2_T_8B_12D_WREF_B,
  U2_T_16B_12D_WREF_R,
  U2_T_16B_12D_WREF_G,
  U2_T_16B_12D_WREF_B,
  U1_T_8B_12D_WREF_R,
  U1_T_8B_12D_WREF_G,
  U1_T_8B_12D_WREF_B,
  U1_T_16B_12D_WREF_R,
  U1_T_16B_12D_WREF_G,
  U1_T_16B_12D_WREF_B,
  U2_T_8B_6D_WREF_R,
  U2_T_8B_6D_WREF_G,
  U2_T_8B_6D_WREF_B,
  U2_T_16B_6D_WREF_R,
  U2_T_16B_6D_WREF_G,
  U2_T_16B_6D_WREF_B,
  U1_T_8B_6D_WREF_R,
  U1_T_8B_6D_WREF_G,
  U1_T_8B_6D_WREF_B,
  U1_T_16B_6D_WREF_R,
  U1_T_16B_6D_WREF_G,
  U1_T_16B_6D_WREF_B,
  U2_T_8B_3D_WREF_R,
  U2_T_8B_3D_WREF_G,
  U2_T_8B_3D_WREF_B,
  U2_T_16B_3D_WREF_R,
  U2_T_16B_3D_WREF_G,
  U2_T_16B_3D_WREF_B,
  U1_T_8B_3D_WREF_R,
  U1_T_8B_3D_WREF_G,
  U1_T_8B_3D_WREF_B,
  U1_T_16B_3D_WREF_R,
  U1_T_16B_3D_WREF_G,
  U1_T_16B_3D_WREF_B,
  U2_T_8B_2D_WREF_R,
  U2_T_8B_2D_WREF_G,
  U2_T_8B_2D_WREF_B,
  U2_T_16B_2D_WREF_R,
  U2_T_16B_2D_WREF_G,
  U2_T_16B_2D_WREF_B,
  U1_T_8B_2D_WREF_R,
  U1_T_8B_2D_WREF_G,
  U1_T_8B_2D_WREF_B,
  U1_T_16B_2D_WREF_R,
  U1_T_16B_2D_WREF_G,
  U1_T_16B_2D_WREF_B,
  U2_T_8B_1D_WREF_R,
  U2_T_8B_1D_WREF_G,
  U2_T_8B_1D_WREF_B,
  U2_T_16B_1D_WREF_R,
  U2_T_16B_1D_WREF_G,
  U2_T_16B_1D_WREF_B,
  U1_T_8B_1D_WREF_R,
  U1_T_8B_1D_WREF_G,
  U1_T_8B_1D_WREF_B,
  U1_T_16B_1D_WREF_R,
  U1_T_16B_1D_WREF_G,
  U1_T_16B_1D_WREF_B,
  BREFR,
  BREFG,
  BREFB,
  REFBITDEPTH,
  OFFSETHEIGHT,
  S575_OFFSETPIXELSTART_2400,
  S575_OFFSETPIXELSTART_1200,
  S575_OFFSETPIXELSTART_600,
  S575_OFFSETPIXELSTART_300,
  S575_OFFSETPIXELSTART_200,
  S575_OFFSETPIXELSTART_100,
  T2952_OFFSETPIXELSTART_2400,
  T2952_OFFSETPIXELSTART_1200,
  T2952_OFFSETPIXELSTART_600,
  T2952_OFFSETPIXELSTART_300,
  T2952_OFFSETPIXELSTART_200,
  T2952_OFFSETPIXELSTART_100,
  OFFSETNPIXEL_2400,
  OFFSETNPIXEL_1200,
  OFFSETNPIXEL_600,
  OFFSETNPIXEL_300,
  OFFSETNPIXEL_200,
  OFFSETNPIXEL_100,
  OFFSETNSIGMA,
  OFFSETTARGETMAX,
  OFFSETTARGETMIN,
  OFFSETAVGTARGETR,
  OFFSETAVGTARGETG,
  OFFSETAVGTARGETB,
  ADCOFFEVENODD,
  CALIBOFFSET1ON,
  ADCOFFQUICKWAY,
  ADCOFFPREDICTSTART,
  ADCOFFPREDICTEND,
  OFFSETTUNESTEP1,
  OFFSETBOUNDARYRATIO1,
  OFFSETAVGRATIO1,
  OFFSETEVEN1R,
  OFFSETODD1R,
  OFFSETEVEN1G,
  OFFSETODD1G,
  OFFSETEVEN1B,
  OFFSETODD1B,
  ADCOFFPREDICTR,
  ADCOFFPREDICTG,
  ADCOFFPREDICTB,
  ADCOFFEVEN1R_1ST,
  ADCOFFODD1R_1ST,
  ADCOFFEVEN1G_1ST,
  ADCOFFODD1G_1ST,
  ADCOFFEVEN1B_1ST,
  ADCOFFODD1B_1ST,
  PEAKR,
  PEAKG,
  PEAKB,
  MINR,
  MING,
  MINB,
  CALIBOFFSET2ON,
  OFFSETTUNESTEP2,
  OFFSETBOUNDARYRATIO2,
  OFFSETAVGRATIO2,
  OFFSETEVEN2R,
  OFFSETODD2R,
  OFFSETEVEN2G,
  OFFSETODD2G,
  OFFSETEVEN2B,
  OFFSETODD2B,
  GAINHEIGHT,
  GAINTARGETFACTOR,
  CALIBPAGON,
  PAGR,
  PAGG,
  PAGB,
  CALIBGAIN1ON,
  GAIN1R,
  GAIN1G,
  GAIN1B,
  CALIBGAIN2ON,
  GAIN2R,
  GAIN2G,
  GAIN2B,
  TOTSHADING,
  BSHADINGON,
  BSHADINGHEIGHT,
  BSHADINGPREDIFFR,
  BSHADINGPREDIFFG,
  BSHADINGPREDIFFB,
  BSHADINGDEFCUTOFF,
  WSHADINGON,
  WSHADINGHEIGHT,
  WSHADINGPREDIFFR,
  WSHADINGPREDIFFG,
  WSHADINGPREDIFFB,
  U2_S_8B_24D_CUT_R,
  U2_S_8B_24D_CUT_G,
  U2_S_8B_24D_CUT_B,
  U2_S_16B_24D_CUT_R,
  U2_S_16B_24D_CUT_G,
  U2_S_16B_24D_CUT_B,
  U1_S_8B_24D_CUT_R,
  U1_S_8B_24D_CUT_G,
  U1_S_8B_24D_CUT_B,
  U1_S_16B_24D_CUT_R,
  U1_S_16B_24D_CUT_G,
  U1_S_16B_24D_CUT_B,
  U2_S_8B_12D_CUT_R,
  U2_S_8B_12D_CUT_G,
  U2_S_8B_12D_CUT_B,
  U2_S_16B_12D_CUT_R,
  U2_S_16B_12D_CUT_G,
  U2_S_16B_12D_CUT_B,
  U1_S_8B_12D_CUT_R,
  U1_S_8B_12D_CUT_G,
  U1_S_8B_12D_CUT_B,
  U1_S_16B_12D_CUT_R,
  U1_S_16B_12D_CUT_G,
  U1_S_16B_12D_CUT_B,
  U2_S_8B_6D_CUT_R,
  U2_S_8B_6D_CUT_G,
  U2_S_8B_6D_CUT_B,
  U2_S_16B_6D_CUT_R,
  U2_S_16B_6D_CUT_G,
  U2_S_16B_6D_CUT_B,
  U1_S_8B_6D_CUT_R,
  U1_S_8B_6D_CUT_G,
  U1_S_8B_6D_CUT_B,
  U1_S_16B_6D_CUT_R,
  U1_S_16B_6D_CUT_G,
  U1_S_16B_6D_CUT_B,
  U2_S_8B_3D_CUT_R,
  U2_S_8B_3D_CUT_G,
  U2_S_8B_3D_CUT_B,
  U2_S_16B_3D_CUT_R,
  U2_S_16B_3D_CUT_G,
  U2_S_16B_3D_CUT_B,
  U1_S_8B_3D_CUT_R,
  U1_S_8B_3D_CUT_G,
  U1_S_8B_3D_CUT_B,
  U1_S_16B_3D_CUT_R,
  U1_S_16B_3D_CUT_G,
  U1_S_16B_3D_CUT_B,
  U2_S_8B_2D_CUT_R,
  U2_S_8B_2D_CUT_G,
  U2_S_8B_2D_CUT_B,
  U2_S_16B_2D_CUT_R,
  U2_S_16B_2D_CUT_G,
  U2_S_16B_2D_CUT_B,
  U1_S_8B_2D_CUT_R,
  U1_S_8B_2D_CUT_G,
  U1_S_8B_2D_CUT_B,
  U1_S_16B_2D_CUT_R,
  U1_S_16B_2D_CUT_G,
  U1_S_16B_2D_CUT_B,
  U2_S_8B_1D_CUT_R,
  U2_S_8B_1D_CUT_G,
  U2_S_8B_1D_CUT_B,
  U2_S_16B_1D_CUT_R,
  U2_S_16B_1D_CUT_G,
  U2_S_16B_1D_CUT_B,
  U1_S_8B_1D_CUT_R,
  U1_S_8B_1D_CUT_G,
  U1_S_8B_1D_CUT_B,
  U1_S_16B_1D_CUT_R,
  U1_S_16B_1D_CUT_G,
  U1_S_16B_1D_CUT_B,
  U2_T_8B_24D_CUT_R,
  U2_T_8B_24D_CUT_G,
  U2_T_8B_24D_CUT_B,
  U2_T_16B_24D_CUT_R,
  U2_T_16B_24D_CUT_G,
  U2_T_16B_24D_CUT_B,
  U1_T_8B_24D_CUT_R,
  U1_T_8B_24D_CUT_G,
  U1_T_8B_24D_CUT_B,
  U1_T_16B_24D_CUT_R,
  U1_T_16B_24D_CUT_G,
  U1_T_16B_24D_CUT_B,
  U2_T_8B_12D_CUT_R,
  U2_T_8B_12D_CUT_G,
  U2_T_8B_12D_CUT_B,
  U2_T_16B_12D_CUT_R,
  U2_T_16B_12D_CUT_G,
  U2_T_16B_12D_CUT_B,
  U1_T_8B_12D_CUT_R,
  U1_T_8B_12D_CUT_G,
  U1_T_8B_12D_CUT_B,
  U1_T_16B_12D_CUT_R,
  U1_T_16B_12D_CUT_G,
  U1_T_16B_12D_CUT_B,
  U2_T_8B_6D_CUT_R,
  U2_T_8B_6D_CUT_G,
  U2_T_8B_6D_CUT_B,
  U2_T_16B_6D_CUT_R,
  U2_T_16B_6D_CUT_G,
  U2_T_16B_6D_CUT_B,
  U1_T_8B_6D_CUT_R,
  U1_T_8B_6D_CUT_G,
  U1_T_8B_6D_CUT_B,
  U1_T_16B_6D_CUT_R,
  U1_T_16B_6D_CUT_G,
  U1_T_16B_6D_CUT_B,
  U2_T_8B_3D_CUT_R,
  U2_T_8B_3D_CUT_G,
  U2_T_8B_3D_CUT_B,
  U2_T_16B_3D_CUT_R,
  U2_T_16B_3D_CUT_G,
  U2_T_16B_3D_CUT_B,
  U1_T_8B_3D_CUT_R,
  U1_T_8B_3D_CUT_G,
  U1_T_8B_3D_CUT_B,
  U1_T_16B_3D_CUT_R,
  U1_T_16B_3D_CUT_G,
  U1_T_16B_3D_CUT_B,
  U2_T_8B_2D_CUT_R,
  U2_T_8B_2D_CUT_G,
  U2_T_8B_2D_CUT_B,
  U2_T_16B_2D_CUT_R,
  U2_T_16B_2D_CUT_G,
  U2_T_16B_2D_CUT_B,
  U1_T_8B_2D_CUT_R,
  U1_T_8B_2D_CUT_G,
  U1_T_8B_2D_CUT_B,
  U1_T_16B_2D_CUT_R,
  U1_T_16B_2D_CUT_G,
  U1_T_16B_2D_CUT_B,
  U2_T_8B_1D_CUT_R,
  U2_T_8B_1D_CUT_G,
  U2_T_8B_1D_CUT_B,
  U2_T_16B_1D_CUT_R,
  U2_T_16B_1D_CUT_G,
  U2_T_16B_1D_CUT_B,
  U1_T_8B_1D_CUT_R,
  U1_T_8B_1D_CUT_G,
  U1_T_8B_1D_CUT_B,
  U1_T_16B_1D_CUT_R,
  U1_T_16B_1D_CUT_G,
  U1_T_16B_1D_CUT_B,
  WREFR,
  WREFG,
  WREFB,
  USEFIXEDPWM,
  T_WREFR,
  T_WREFG,
  T_WREFB,
  S_WREFR,
  S_WREFG,
  S_WREFB,
  PARKHOMEAFTERCALIB,
  SHADINGTIME_16BIT,
  SHADOWTIME_16BIT,
  SHADINGTIME_8BIT,
  SHADOWTIME_8BIT,
  PREVIEWDPI,
  FIRSTDCOFFSETEVEN0,
  FIRSTDCOFFSETODD0,
  FIRSTDCOFFSETEVEN1,
  FIRSTDCOFFSETODD1,
  FIRSTDCOFFSETEVEN2,
  FIRSTDCOFFSETODD2,
  OVERDRIVETIME_FLB,
  OVERDRIVETIME_TA,
  CALIBOFFSET10N,
  CALIBOFFSET20N,
  CALIBGAIN10N,
  CALIBGAIN20N,
  ARRANGELINE,
  CALIBRATE,
  COMPRESSION,
  TA_X_START,
  TA_Y_START,
  DPIGAINCONTROL600,
  DPIGAINCONTROL_TA600,
  DPIGAINCONTROL_NEG600,
  DPILUMPING100,
  CRVS,
  VRTS,
  VRMS,
  VRBS,
  MLOCK,
  ENABLEWARMUP,
  NMAXTARGET,
  NMINTARGET,
  NMAXTARGETTA,
  NMINTARGETTA,
  NMAXTARGETNEG,
  NMINTARGETNEG,
  STABLEDIFF,
  DELTAPWM,
  PWMLAMPENABLED,
  PWMLAMPLEVEL,
  PWMLAMPFREQUENCYFLB1200,
  PWMLAMPDUTYCYCLEFLB1200,
  TMAPWMDUTY,
  EDCG11,
  EDCG12,
  EDCG13,
  EDCG21,
  EDCG22,
  EDCG23,
  ODCG11,
  ODCG12,
  ODCG13,
  ODCG21,
  ODCG22,
  ODCG23,
  PAG1,
  PAG2,
  PAG3,
  VGAG11,
  VGAG12,
  VGAG13,
  VGAG21,
  VGAG22,
  VGAG23,
  LEFTLEADING,
  SER_100,
  SER_200,
  SER_300,
  SER_600,
  SER_1200,
  SER_2400,
  LER_100,
  LER_200,
  LER_300,
  LER_600,
  LER_1200,
  LER_2400,
  SSCGENABLE,
  SSCGMODE,
  SSCGCLOCKCONTROL,
  TA_PWM_100_8BIT,
  TA_PWM_200_8BIT,
  TA_PWM_300_8BIT,
  TA_PWM_600_8BIT,
  TA_PWM_1200_8BIT,
  TA_PWM_2400_8BIT,
  TA_PWM_100_16BIT,
  TA_PWM_200_16BIT,
  TA_PWM_300_16BIT,
  TA_PWM_600_16BIT,
  TA_PWM_1200_16BIT,
  TA_PWM_2400_16BIT,
  NEG_PWM_100_8BIT,
  NEG_PWM_200_8BIT,
  NEG_PWM_300_8BIT,
  NEG_PWM_600_8BIT,
  NEG_PWM_1200_8BIT,
  NEG_PWM_2400_8BIT,
  NEG_PWM_100_16BIT,
  NEG_PWM_200_16BIT,
  NEG_PWM_300_16BIT,
  NEG_PWM_600_16BIT,
  NEG_PWM_1200_16BIT,
  NEG_PWM_2400_16BIT,
  WAVE_XSTART,
  WAVE_S575_XDUMMY_2400,
  WAVE_S575_XDUMMY_1200,
  WAVE_S575_XDUMMY_600,
  ODD_DCOFFSET11,
  ODD_DCOFFSET12,
  ODD_DCOFFSET13,
  ODD_DCOFFSET21,
  ODD_DCOFFSET22,
  ODD_DCOFFSET23,
  EVEN_DCOFFSET11,
  EVEN_DCOFFSET12,
  EVEN_DCOFFSET13,
  EVEN_DCOFFSET21,
  EVEN_DCOFFSET22,
  EVEN_DCOFFSET23,
  DCGAIN11,
  DCGAIN12,
  DCGAIN13,
  DCGAIN21,
  DCGAIN22,
  DCGAIN23,
  DMATRANSFERSIZE,
  DMASETLENGTH,
  DMABUFFERSIZE,
  CRYSTALFREQ,
  PGA1,
  PGA2,
  PGA3,
  VGAGAIN11,
  VGAGAIN12,
  VGAGAIN13,
  DCSTEPEVEN1,
  DCSTEPODD1,
  DCSTEPEVEN2,
  DCSTEPODD2,
  DCSTEPEVEN3,
  DCSTEPODD3,
  FIRSTDCOFFSETEVEN11,
  FIRSTDCOFFSETODD11,
  FIRSTDCOFFSETEVEN12,
  FIRSTDCOFFSETODD12,
  FIRSTDCOFFSETEVEN13,
  FIRSTDCOFFSETODD13,
  DCOFFSETEVEN11,
  DCOFFSETODD11,
  DCOFFSETEVEN12,
  DCOFFSETODD12,
  DCOFFSETEVEN13,
  DCOFFSETODD13,
  SHADINGBASE,
  SHADINGFACT1,
  SHADINGFACT2,
  SHADINGFACT3,
  LINEDARKLEVEL1,
  LINEDARKLEVEL2,
  PIXELDARKLEVEL,
  PIXELDARKSCANLINES,
  PIXELDARKDISCARDPERCENT,
  EXPOSURETIME,
  SCANYSTART,
  SCANYLINES,
  CHECKOFFSETSER,
  FINDSERSTART,
  FINDSEREND,
  COLOR600,
  CHANGEMOTORCURRENT,
  BASESPEEDMOTORMOVE,
  HIGHSPEEDMOTORMOVE,
  PARKHOMEMOTORMOVE,
  BASESPEEDPPS,
  BUTTONCOUNT,
  SENSORTYPE,
  SENSORCHANNELCOLOR,
  SENSORCHANNELGRAY,
  RGBCHANNELORDER,
  REALSENSORRESOLUTION,
  SENSORLINEDISTANCE,
  SENSOREVENODDDISTANCE,
  MOTORTYPE,
  MOTORRESOLUTION,
  BUFFERFULLMOTORBACKSTEP,
  BASETARGETCODE,
  BINARYTHRESHOLDH,
  BINARYTHRESHOLDL,
  LAMPOFFTIMER,
  LAMPWARMUPCHECKLEVEL,
  CLOSETIME,
  TIMINGCOUNT,
  MOTORCOUNT,
  MOTORMOVECOUNT,
  SCANCOLORCOUNT,
  SCANTACOLORCOUNT,
  SCANNEGCOLORCOUNT,
  SCANGRAYCOUNT,
  SCANTAGRAYCOUNT,
  SCANNEGGRAYCOUNT,
  SCANTALINEARTCOUNT,
  SCANNEGLINEARTCOUNT,
  SCANLINEARTCOUNT,
  PLATFORM,
  SCAN_PARAM,
  USB1_PWM,
  USB2_PWM,
  WAVETEST,
  DMA_PARAM,
  TRUE_GRAY_PARAM,
  CALI_PARAM,
  FLB_FIND_EDGE,
  DUMMYLINE,
  MOVEMOTORSETTING,
  MOTORMOVE1,
  MOTORMOVE2,
  SCANCOLORMODE1,
  SCANCOLORMODE2,
  SCANCOLORMODE3,
  SCANCOLORMODE4,
  SCANCOLORMODE5,
  SCANCOLORMODE6,
  SCANGRAYMODE1,
  SCANGRAYMODE2,
  SCANGRAYMODE3,
  SCANGRAYMODE4,
  SCANGRAYMODE5,
  SCANGRAYMODE6,
  SCANTACOLORMODE1,
  SCANTACOLORMODE2,
  SCANTACOLORMODE3,
  SCANTACOLORMODE4,
  SCANTACOLORMODE5,
  SCANTACOLORMODE6,
  SCANTAGRAYMODE1,
  SCANTAGRAYMODE2,
  SCANTAGRAYMODE3,
  SCANTAGRAYMODE4,
  SCANTAGRAYMODE5,
  SCANTAGRAYMODE6,
  SCANNEGCOLORMODE1,
  SCANNEGCOLORMODE2,
  SCANNEGCOLORMODE3,
  SCANNEGCOLORMODE4,
  SCANNEGCOLORMODE5,
  SCANNEGCOLORMODE6,
  SCANNEGGRAYMODE1,
  SCANNEGGRAYMODE2,
  SCANNEGGRAYMODE3,
  SCANNEGGRAYMODE4,
  SCANNEGGRAYMODE5,
  SCANNEGGRAYMODE6,
  SCANLINEARTMODE1,
  SCANLINEARTMODE2,
  SCANLINEARTMODE3,
  SCANLINEARTMODE4,
  SCANLINEARTMODE5,
  SCANLINEARTMODE6,
  SCANTALINEARTMODE1,
  SCANTALINEARTMODE2,
  SCANTALINEARTMODE3,
  SCANTALINEARTMODE4,
  SCANTALINEARTMODE5,
  SCANTALINEARTMODE6,
  SCANNEGLINEARTMODE1,
  SCANNEGLINEARTMODE2,
  SCANNEGLINEARTMODE3,
  SCANNEGLINEARTMODE4,
  SCANNEGLINEARTMODE5,
  SCANNEGLINEARTMODE6,
  SYSTEMCLOCK,
  CTPC,
  SCANMOTORSTEPTYPE,
  MOTORCURVE,
  SAMPLERATE,
  TIMING,
  MOTORBACKSTEP,
  MEXPT1,
  EXPT1,
  MEXPT2,
  EXPT2,
  MEXPT3,
  EXPT3,
  PWMLAMPFREQUENCYFLB600,
  PWMLAMPDUTYCYCLEFLB600,
  PWMLAMPFREQUENCYTA1200,
  PWMLAMPDUTYCYCLETA1200,
  PWMLAMPFREQUENCYTA600,
  PWMLAMPDUTYCYCLETA600,
  PWMLAMPFREQUENCYNEG1200,
  PWMLAMPDUTYCYCLENEG1200,
  PWMLAMPFREQUENCYNEG600,
  PWMLAMPDUTYCYCLENEG600,
  MOTORPWMFREQUENCY,
  STARTPOS,
  THROUGHPUT,
  LINEDARLAMPOFF,
  WAITTIMEAFTERPIXELDARK,
  DISCARDWHITEPERCENT,
  DISCARDBLACKPERCENT,
  MCLKIOC,
  TA_FIND_EDGE,
  TA_NEG_FIND_EDGE,
  FINDLERMETHOD,
  FINDLERSTART,
  FINDLEREND,
  FINDSERCHECKLINES,
  FINDSERMETHOD,
  OFFSETTOSER,
  OFFSETTOLER,
  MOTORPLUS,
  MULTIEXPOSUREFOR16BITMODE,
  MULTIEXPOSUREFORFULLSPEED,
  MULTIEXPOSURE,
  MMTIR,
  MMTIRH,
  SENSORRESOLUTION,
  CNPP,
  CVTRP1,
  CVTRP2,
  CVTRP3,
  CVTRW,
  CVTRFPW,
  CVTRBPW,
  CPHBP2S,
  CPHBP2E,
  CLAMPS,
  CLAMPE,
  CDSS1,
  CDSC1,
  CDSS2,
  CDSC2,
  ADCCLKP2E,
  ADCCLKP1,
  ADCCLKP2,
  CPH0P1,
  CPH0P2,
  CPH0PS,
  CPH0GE,
  CPH0GO,
  CPH1P1,
  CPH1P2,
  CPH1PS,
  CPH1GE,
  CPH1GO,
  CPH2P1,
  CPH2P2,
  CPH2PS,
  CPH2GE,
  CPH2GO,
  CPH3P1,
  CPH3P2,
  CPH3PS,
  CPH3GE,
  CPH3GO,
  CPH4P1,
  CPH4P2,
  CPH4PS,
  CPH4GE,
  CPH4GO,
  CPH5P1,
  CPH5P2,
  CPH5PS,
  CPH5GE,
  CPH5GO
};

static int
fc_sec1_get (int option, int defvalue)
{
  int rst = defvalue;

  switch (option)
    {
    case PIDVID:
      rst = 0X03F02305;
      break;
    case FLBSCANYSTART:
      rst = 100;
      break;
    case CCDTYPE:
      rst = -1;
      break;
    case WARMUPT1:
      rst = 0;
      break;
    case WARMUPT2:
      rst = 0;
      break;
    case UCCDTYPE:
      rst = 1;
      break;
    case TA_STRIPTOSCAN:
      rst = 1800;
      break;
    case HIGAINDEFAULTPWM:
      rst = 38;
      break;
    case LOGAINDEFAULTPWM:
      rst = 18;
      break;
    case T_USB2FIXEDPWM:
      rst = 22;
      break;
    case T_USB1FIXEDPWM:
      rst = 22;
      break;
    case T_USB2FIXEDPWM_TA:
      rst = 22;
      break;
    case T_USB1FIXEDPWM_TA:
      rst = 22;
      break;
    case T_USB2FIXEDPWM_NEG:
      rst = 22;
      break;
    case T_USB1FIXEDPWM_NEG:
      rst = 22;
      break;
    case S_USB2FIXEDPWM:
      rst = 22;
      break;
    case S_USB1FIXEDPWM:
      rst = 22;
      break;
    case S_USB2FIXEDPWM_TA:
      rst = 22;
      break;
    case S_USB1FIXEDPWM_TA:
      rst = 22;
      break;
    case S_USB2FIXEDPWM_NEG:
      rst = 22;
      break;
    case S_USB1FIXEDPWM_NEG:
      rst = 22;
      break;
    case WARMUPDEFSEARCH:
      rst = 0;
      break;
    }

  return rst;
}

static int
fc_sec2_get (int option, int defvalue)
{
  int rst = defvalue;

  switch (option)
    {
    case USB2_LAMP_MAX_100:
      rst = 180;
      break;
    case USB2_LAMP_MIN_100:
      rst = 150;
      break;
    case USB2_PWM_100:
      rst = 38;
      break;
    case USB2_LAMP_MAX_200:
      rst = 180;
      break;
    case USB2_LAMP_MIN_200:
      rst = 150;
      break;
    case USB2_PWM_200:
      rst = 42;
      break;
    case USB2_LAMP_MAX_300:
      rst = 180;
      break;
    case USB2_LAMP_MIN_300:
      rst = 150;
      break;
    case USB2_PWM_300:
      rst = 38;
      break;
    case USB2_LAMP_MAX_600:
      rst = 180;
      break;
    case USB2_LAMP_MIN_600:
      rst = 150;
      break;
    case USB2_PWM_600:
      rst = 38;
      break;
    case USB2_LAMP_MAX_1200:
      rst = 100;
      break;
    case USB2_LAMP_MIN_1200:
      rst = 60;
      break;
    case USB2_PWM_1200:
      rst = 40;
      break;
    case USB2_LAMP_MAX_2400:
      rst = 100;
      break;
    case USB2_LAMP_MIN_2400:
      rst = 60;
      break;
    case USB2_PWM_2400:
      rst = 42;
      break;
    case USB1_LAMP_MAX_100:
      rst = 180;
      break;
    case USB1_LAMP_MIN_100:
      rst = 150;
      break;
    case USB1_PWM_100:
      rst = 40;
      break;
    case USB1_LAMP_MAX_200:
      rst = 180;
      break;
    case USB1_LAMP_MIN_200:
      rst = 150;
      break;
    case USB1_PWM_200:
      rst = 40;
      break;
    case USB1_LAMP_MAX_300:
      rst = 180;
      break;
    case USB1_LAMP_MIN_300:
      rst = 150;
      break;
    case USB1_PWM_300:
      rst = 34;
      break;
    case USB1_LAMP_MAX_600:
      rst = 180;
      break;
    case USB1_LAMP_MIN_600:
      rst = 150;
      break;
    case USB1_PWM_600:
      rst = 34;
      break;
    case USB1_LAMP_MAX_1200:
      rst = 100;
      break;
    case USB1_LAMP_MIN_1200:
      rst = 600;
      break;
    case USB1_PWM_1200:
      rst = 46;
      break;
    case USB1_LAMP_MAX_2400:
      rst = 100;
      break;
    case USB1_LAMP_MIN_2400:
      rst = 60;
      break;
    case USB1_PWM_2400:
      rst = 44;
      break;
    }

  return rst;
}

static int
fc_sec3_get (int option, int defvalue)
{
  int rst = defvalue;

  switch (option)
    {
    case USB2_LAMP_MAX_100:
      rst = 180;
      break;
    case USB2_LAMP_MIN_100:
      rst = 150;
      break;
    case USB2_PWM_100:
      rst = 38;
      break;
    case USB2_LAMP_MAX_200:
      rst = 180;
      break;
    case USB2_LAMP_MIN_200:
      rst = 150;
      break;
    case USB2_PWM_200:
      rst = 42;
      break;
    case USB2_LAMP_MAX_300:
      rst = 180;
      break;
    case USB2_LAMP_MIN_300:
      rst = 150;
      break;
    case USB2_PWM_300:
      rst = 38;
      break;
    case USB2_LAMP_MAX_600:
      rst = 180;
      break;
    case USB2_LAMP_MIN_600:
      rst = 150;
      break;
    case USB2_PWM_600:
      rst = 38;
      break;
    case USB2_LAMP_MAX_1200:
      rst = 100;
      break;
    case USB2_LAMP_MIN_1200:
      rst = 60;
      break;
    case USB2_PWM_1200:
      rst = 40;
      break;
    case USB2_LAMP_MAX_2400:
      rst = 100;
      break;
    case USB2_LAMP_MIN_2400:
      rst = 60;
      break;
    case USB2_PWM_2400:
      rst = 36;
      break;
    case USB1_LAMP_MAX_100:
      rst = 180;
      break;
    case USB1_LAMP_MIN_100:
      rst = 150;
      break;
    case USB1_PWM_100:
      rst = 38;
      break;
    case USB1_LAMP_MAX_200:
      rst = 180;
      break;
    case USB1_LAMP_MIN_200:
      rst = 150;
      break;
    case USB1_PWM_200:
      rst = 45;
      break;
    case USB1_LAMP_MAX_300:
      rst = 180;
      break;
    case USB1_LAMP_MIN_300:
      rst = 150;
      break;
    case USB1_PWM_300:
      rst = 48;
      break;
    case USB1_LAMP_MAX_600:
      rst = 180;
      break;
    case USB1_LAMP_MIN_600:
      rst = 150;
      break;
    case USB1_PWM_600:
      rst = 47;
      break;
    case USB1_LAMP_MAX_1200:
      rst = 100;
      break;
    case USB1_LAMP_MIN_1200:
      rst = 60;
      break;
    case USB1_PWM_1200:
      rst = 34;
      break;
    case USB1_LAMP_MAX_2400:
      rst = 100;
      break;
    case USB1_LAMP_MIN_2400:
      rst = 60;
      break;
    case USB1_PWM_2400:
      rst = 42;
      break;
    }

  return rst;
}

static int
fc_sec4_get (int option, int defvalue)
{
  int rst = defvalue;

  switch (option)
    {
    case PREVIEW_DIFF:
      rst = 1000;
      break;
    case PREVIEW_INTERVAL:
      rst = 200;
      break;
    case PREVIEW_TOTTIME:
      rst = 5000;
      break;
    case FLB_DIFF:
      rst = 500;
      break;
    case FLB_INTERVAL:
      rst = 200;
      break;
    case FLB_TOTTIME:
      rst = 5000;
      break;
    case TMA_DIFF:
      rst = 500;
      break;
    case TMA_INTERVAL:
      rst = 200;
      break;
    case TMA_TOTTIME:
      rst = 5000;
      break;
    }

  return rst;
}

static int
fc_sec5_get (int option, int defvalue)
{
  int rst = defvalue;
  switch (option)
    {
    case AUTOFINDREFPOS:
      rst = 1;
      break;
    case LEROFFSET:
      rst = 717;
      break;
    case SEROFFSET:
      rst = 88;
      break;
    case SAVEAUTOREFFILE:
      rst = 0;
      break;
    case EXTERNBOUNDARY:
      rst = 40;
      break;
    case T2952_STARTEFFECTIVEPIXEL_2400:
      rst = 134;
      break;
    case T2952_STARTEFFECTIVEPIXEL_1200:
      rst = 134;
      break;
    case T2952_STARTEFFECTIVEPIXEL_600:
      rst = 230;
      break;
    case S575_STARTEFFECTIVEPIXEL_2400:
      rst = 218;
      break;
    case S575_STARTEFFECTIVEPIXEL_1200:
      rst = 240;
      break;
    case S575_STARTEFFECTIVEPIXEL_600:
      rst = 242;
      break;
    }

  return rst;
}

static int
fc_sec6_get (int option, int defvalue)
{
  int rst = defvalue;
  switch (option)
    {
    case WSTRIPXPOS:
      rst = 0;
      break;
    case WSTRIPYPOS:
      rst = 0;
      break;
    case BSTRIPXPOS:
      rst = 0;
      break;
    case BSTRIPYPOS:
      rst = 0;
      break;
    case WREFR:
      rst = 233;
      break;
    case WREFG:
      rst = 230;
      break;
    case WREFB:
      rst = 222;
      break;
    case BREFR:
      rst = 10;
      break;
    case BREFG:
      rst = 10;
      break;
    case BREFB:
      rst = 10;
      break;
    case REFBITDEPTH:
      rst = 8;
      break;
    case OFFSETHEIGHT:
      rst = 10;
      break;
    case S575_OFFSETPIXELSTART_2400:
      rst = 84;
      break;
    case S575_OFFSETPIXELSTART_1200:
      rst = 54;
      break;
    case S575_OFFSETPIXELSTART_600:
      rst = 28;
      break;
    case S575_OFFSETPIXELSTART_300:
      rst = 15;
      break;
    case S575_OFFSETPIXELSTART_200:
      rst = 5;
      break;
    case S575_OFFSETPIXELSTART_100:
      rst = 2;
      break;
    case T2952_OFFSETPIXELSTART_2400:
      rst = 16;
      break;
    case T2952_OFFSETPIXELSTART_1200:
      rst = 16;
      break;
    case T2952_OFFSETPIXELSTART_600:
      rst = 15;
      break;
    case T2952_OFFSETPIXELSTART_300:
      rst = 7;
      break;
    case T2952_OFFSETPIXELSTART_200:
      rst = 7;
      break;
    case T2952_OFFSETPIXELSTART_100:
      rst = 3;
      break;
    case OFFSETNPIXEL_2400:
      rst = 20;
      break;
    case OFFSETNPIXEL_1200:
      rst = 10;
      break;
    case OFFSETNPIXEL_600:
      rst = 10;
      break;
    case OFFSETNPIXEL_300:
      rst = 5;
      break;
    case OFFSETNPIXEL_200:
      rst = 3;
      break;
    case OFFSETNPIXEL_100:
      rst = 3;
      break;
    case OFFSETNSIGMA:
      rst = 2;
      break;
    case OFFSETTARGETMAX:
      rst = 50;
      break;
    case OFFSETTARGETMIN:
      rst = 2;
      break;
    case OFFSETAVGTARGETR:
      rst = 10;
      break;
    case OFFSETAVGTARGETG:
      rst = 10;
      break;
    case OFFSETAVGTARGETB:
      rst = 10;
      break;
    case ADCOFFEVENODD:
      rst = 1;
      break;
    case CALIBOFFSET1ON:
      rst = 2;
      break;
    case ADCOFFQUICKWAY:
      rst = 1;
      break;
    case ADCOFFPREDICTSTART:
      rst = 300;
      break;
    case ADCOFFPREDICTEND:
      rst = 500;
      break;
    case OFFSETTUNESTEP1:
      rst = 5;
      break;
    case OFFSETBOUNDARYRATIO1:
      rst = 100;
      break;
    case OFFSETAVGRATIO1:
      rst = 100;
      break;
    case OFFSETEVEN1R:
      rst = 327;
      break;
    case OFFSETODD1R:
      rst = 327;
      break;
    case OFFSETEVEN1G:
      rst = 315;
      break;
    case OFFSETODD1G:
      rst = 315;
      break;
    case OFFSETEVEN1B:
      rst = 322;
      break;
    case OFFSETODD1B:
      rst = 322;
      break;
    case ADCOFFPREDICTR:
      rst = 322;
      break;
    case ADCOFFPREDICTG:
      rst = 310;
      break;
    case ADCOFFPREDICTB:
      rst = 322;
      break;
    case ADCOFFEVEN1R_1ST:
      rst = 344;
      break;
    case ADCOFFODD1R_1ST:
      rst = 344;
      break;
    case ADCOFFEVEN1G_1ST:
      rst = 328;
      break;
    case ADCOFFODD1G_1ST:
      rst = 328;
      break;
    case ADCOFFEVEN1B_1ST:
      rst = 341;
      break;
    case ADCOFFODD1B_1ST:
      rst = 341;
      break;
    case PEAKR:
      rst = 82;
      break;
    case PEAKG:
      rst = 117;
      break;
    case PEAKB:
      rst = 116;
      break;
    case MINR:
      rst = 37;
      break;
    case MING:
      rst = 51;
      break;
    case MINB:
      rst = 53;
      break;
    case CALIBOFFSET2ON:
      rst = 0;
      break;
    case OFFSETTUNESTEP2:
      rst = 1;
      break;
    case OFFSETBOUNDARYRATIO2:
      rst = 100;
      break;
    case OFFSETAVGRATIO2:
      rst = 100;
      break;
    case OFFSETEVEN2R:
      rst = 0;
      break;
    case OFFSETODD2R:
      rst = 0;
      break;
    case OFFSETEVEN2G:
      rst = 0;
      break;
    case OFFSETODD2G:
      rst = 0;
      break;
    case OFFSETEVEN2B:
      rst = 0;
      break;
    case OFFSETODD2B:
      rst = 0;
      break;
    case GAINHEIGHT:
      rst = 10;
      break;
    case GAINTARGETFACTOR:
      rst = 90;
      break;
    case CALIBPAGON:
      rst = 0;
      break;
    case PAGR:
      rst = 3;
      break;
    case PAGG:
      rst = 3;
      break;
    case PAGB:
      rst = 3;
      break;
    case CALIBGAIN1ON:
      rst = 1;
      break;
    case GAIN1R:
      rst = 28;
      break;
    case GAIN1G:
      rst = 22;
      break;
    case GAIN1B:
      rst = 21;
      break;
    case CALIBGAIN2ON:
      rst = 0;
      break;
    case GAIN2R:
      rst = 4;
      break;
    case GAIN2G:
      rst = 4;
      break;
    case GAIN2B:
      rst = 4;
      break;
    case TOTSHADING:
      rst = 0;
      break;
    case BSHADINGON:
      rst = -2;
      break;
    case BSHADINGHEIGHT:
      rst = 10;
      break;
    case BSHADINGPREDIFFR:
      rst = 2;
      break;
    case BSHADINGPREDIFFG:
      rst = 2;
      break;
    case BSHADINGPREDIFFB:
      rst = 2;
      break;
    case BSHADINGDEFCUTOFF:
      rst = 0;
      break;
    case WSHADINGON:
      rst = 3;
      break;
    case WSHADINGHEIGHT:
      rst = 24;
      break;
    case WSHADINGPREDIFFR:
      rst = -1;
      break;
    case WSHADINGPREDIFFG:
      rst = -1;
      break;
    case WSHADINGPREDIFFB:
      rst = -1;
      break;
    case U2_S_8B_24D_CUT_R:
      rst = -15;
      break;
    case U2_S_8B_24D_CUT_G:
      rst = -15;
      break;
    case U2_S_8B_24D_CUT_B:
      rst = -15;
      break;
    case U2_S_16B_24D_CUT_R:
      rst = -15;
      break;
    case U2_S_16B_24D_CUT_G:
      rst = -15;
      break;
    case U2_S_16B_24D_CUT_B:
      rst = -15;
      break;
    case U1_S_8B_24D_CUT_R:
      rst = -15;
      break;
    case U1_S_8B_24D_CUT_G:
      rst = -15;
      break;
    case U1_S_8B_24D_CUT_B:
      rst = -15;
      break;
    case U1_S_16B_24D_CUT_R:
      rst = -15;
      break;
    case U1_S_16B_24D_CUT_G:
      rst = -15;
      break;
    case U1_S_16B_24D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_24D_CUT_R:
      rst = -15;
      break;
    case U2_T_8B_24D_CUT_G:
      rst = -15;
      break;
    case U2_T_8B_24D_CUT_B:
      rst = -15;
      break;
    case U2_T_16B_24D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_24D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_24D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_24D_CUT_R:
      rst = -15;
      break;
    case U1_T_8B_24D_CUT_G:
      rst = -15;
      break;
    case U1_T_8B_24D_CUT_B:
      rst = -15;
      break;
    case U1_T_16B_24D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_24D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_24D_CUT_B:
      rst = -15;
      break;
    case U2_S_8B_12D_CUT_R:
      rst = -15;
      break;
    case U2_S_8B_12D_CUT_G:
      rst = -15;
      break;
    case U2_S_8B_12D_CUT_B:
      rst = -15;
      break;
    case U2_S_16B_12D_CUT_R:
      rst = -15;
      break;
    case U2_S_16B_12D_CUT_G:
      rst = -15;
      break;
    case U2_S_16B_12D_CUT_B:
      rst = -15;
      break;
    case U1_S_8B_12D_CUT_R:
      rst = -15;
      break;
    case U1_S_8B_12D_CUT_G:
      rst = -15;
      break;
    case U1_S_8B_12D_CUT_B:
      rst = -15;
      break;
    case U1_S_16B_12D_CUT_R:
      rst = -15;
      break;
    case U1_S_16B_12D_CUT_G:
      rst = -15;
      break;
    case U1_S_16B_12D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_12D_CUT_R:
      rst = -15;
      break;
    case U2_T_8B_12D_CUT_G:
      rst = -15;
      break;
    case U2_T_8B_12D_CUT_B:
      rst = -15;
      break;
    case U2_T_16B_12D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_12D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_12D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_12D_CUT_R:
      rst = -15;
      break;
    case U1_T_8B_12D_CUT_G:
      rst = -15;
      break;
    case U1_T_8B_12D_CUT_B:
      rst = -15;
      break;
    case U1_T_16B_12D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_12D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_12D_CUT_B:
      rst = -15;
      break;
    case U2_S_8B_6D_CUT_R:
      rst = -15;
      break;
    case U2_S_8B_6D_CUT_G:
      rst = -15;
      break;
    case U2_S_8B_6D_CUT_B:
      rst = -15;
      break;
    case U2_S_16B_6D_CUT_R:
      rst = -15;
      break;
    case U2_S_16B_6D_CUT_G:
      rst = -15;
      break;
    case U2_S_16B_6D_CUT_B:
      rst = -15;
      break;
    case U1_S_8B_6D_CUT_R:
      rst = -15;
      break;
    case U1_S_8B_6D_CUT_G:
      rst = -15;
      break;
    case U1_S_8B_6D_CUT_B:
      rst = -15;
      break;
    case U1_S_16B_6D_CUT_R:
      rst = -15;
      break;
    case U1_S_16B_6D_CUT_G:
      rst = -15;
      break;
    case U1_S_16B_6D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_6D_CUT_R:
      rst = -15;
      break;
    case U2_T_8B_6D_CUT_G:
      rst = -15;
      break;
    case U2_T_8B_6D_CUT_B:
      rst = -15;
      break;
    case U2_T_16B_6D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_6D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_6D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_6D_CUT_R:
      rst = -15;
      break;
    case U1_T_8B_6D_CUT_G:
      rst = -15;
      break;
    case U1_T_8B_6D_CUT_B:
      rst = -15;
      break;
    case U1_T_16B_6D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_6D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_6D_CUT_B:
      rst = -15;
      break;
    case U2_S_8B_3D_CUT_R:
      rst = -15;
      break;
    case U2_S_8B_3D_CUT_G:
      rst = -15;
      break;
    case U2_S_8B_3D_CUT_B:
      rst = -15;
      break;
    case U2_S_16B_3D_CUT_R:
      rst = -15;
      break;
    case U2_S_16B_3D_CUT_G:
      rst = -15;
      break;
    case U2_S_16B_3D_CUT_B:
      rst = -15;
      break;
    case U1_S_8B_3D_CUT_R:
      rst = -15;
      break;
    case U1_S_8B_3D_CUT_G:
      rst = -15;
      break;
    case U1_S_8B_3D_CUT_B:
      rst = -15;
      break;
    case U1_S_16B_3D_CUT_R:
      rst = -15;
      break;
    case U1_S_16B_3D_CUT_G:
      rst = -15;
      break;
    case U1_S_16B_3D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_3D_CUT_R:
      rst = -15;
      break;
    case U2_T_8B_3D_CUT_G:
      rst = -15;
      break;
    case U2_T_8B_3D_CUT_B:
      rst = -15;
      break;
    case U2_T_16B_3D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_3D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_3D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_3D_CUT_R:
      rst = -15;
      break;
    case U1_T_8B_3D_CUT_G:
      rst = -15;
      break;
    case U1_T_8B_3D_CUT_B:
      rst = -15;
      break;
    case U1_T_16B_3D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_3D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_3D_CUT_B:
      rst = -15;
      break;
    case U2_S_8B_2D_CUT_R:
      rst = -15;
      break;
    case U2_S_8B_2D_CUT_G:
      rst = -15;
      break;
    case U2_S_8B_2D_CUT_B:
      rst = -15;
      break;
    case U2_S_16B_2D_CUT_R:
      rst = -15;
      break;
    case U2_S_16B_2D_CUT_G:
      rst = -15;
      break;
    case U2_S_16B_2D_CUT_B:
      rst = -15;
      break;
    case U1_S_8B_2D_CUT_R:
      rst = -15;
      break;
    case U1_S_8B_2D_CUT_G:
      rst = -15;
      break;
    case U1_S_8B_2D_CUT_B:
      rst = -15;
      break;
    case U1_S_16B_2D_CUT_R:
      rst = -15;
      break;
    case U1_S_16B_2D_CUT_G:
      rst = -15;
      break;
    case U1_S_16B_2D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_2D_CUT_R:
      rst = -15;
      break;
    case U2_T_8B_2D_CUT_G:
      rst = -15;
      break;
    case U2_T_8B_2D_CUT_B:
      rst = -15;
      break;
    case U2_T_16B_2D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_2D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_2D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_2D_CUT_R:
      rst = -15;
      break;
    case U1_T_8B_2D_CUT_G:
      rst = -15;
      break;
    case U1_T_8B_2D_CUT_B:
      rst = -15;
      break;
    case U1_T_16B_2D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_2D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_2D_CUT_B:
      rst = -15;
      break;
    case U2_S_8B_1D_CUT_R:
      rst = -15;
      break;
    case U2_S_8B_1D_CUT_G:
      rst = -15;
      break;
    case U2_S_8B_1D_CUT_B:
      rst = -15;
      break;
    case U2_S_16B_1D_CUT_R:
      rst = -15;
      break;
    case U2_S_16B_1D_CUT_G:
      rst = -15;
      break;
    case U2_S_16B_1D_CUT_B:
      rst = -15;
      break;
    case U1_S_8B_1D_CUT_R:
      rst = -15;
      break;
    case U1_S_8B_1D_CUT_G:
      rst = -15;
      break;
    case U1_S_8B_1D_CUT_B:
      rst = -15;
      break;
    case U1_S_16B_1D_CUT_R:
      rst = -15;
      break;
    case U1_S_16B_1D_CUT_G:
      rst = -15;
      break;
    case U1_S_16B_1D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_1D_CUT_R:
      rst = -15;
      break;
    case U2_T_8B_1D_CUT_G:
      rst = -15;
      break;
    case U2_T_8B_1D_CUT_B:
      rst = -15;
      break;
    case U2_T_16B_1D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_1D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_1D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_1D_CUT_R:
      rst = -15;
      break;
    case U1_T_8B_1D_CUT_G:
      rst = -15;
      break;
    case U1_T_8B_1D_CUT_B:
      rst = -15;
      break;
    case U1_T_16B_1D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_1D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_1D_CUT_B:
      rst = -15;
      break;
    }

  return rst;
}

static int
fc_sec7_get (int option, int defvalue)
{
  int rst = defvalue;
  switch (option)
    {
    case WSTRIPXPOS:
      rst = 0;
      break;
    case WSTRIPYPOS:
      rst = 7500;
      break;
    case BSTRIPXPOS:
      rst = 0;
      break;
    case BSTRIPYPOS:
      rst = 0;
      break;
    case U2_S_8B_24D_WREF_R:
      rst = 94;
      break;
    case U2_S_8B_24D_WREF_G:
      rst = 85;
      break;
    case U2_S_8B_24D_WREF_B:
      rst = 78;
      break;
    case U2_S_16B_24D_WREF_R:
      rst = 94;
      break;
    case U2_S_16B_24D_WREF_G:
      rst = 85;
      break;
    case U2_S_16B_24D_WREF_B:
      rst = 78;
      break;
    case U1_S_8B_24D_WREF_R:
      rst = 94;
      break;
    case U1_S_8B_24D_WREF_G:
      rst = 85;
      break;
    case U1_S_8B_24D_WREF_B:
      rst = 78;
      break;
    case U1_S_16B_24D_WREF_R:
      rst = 94;
      break;
    case U1_S_16B_24D_WREF_G:
      rst = 85;
      break;
    case U1_S_16B_24D_WREF_B:
      rst = 78;
      break;
    case U2_S_8B_12D_WREF_R:
      rst = 83;
      break;
    case U2_S_8B_12D_WREF_G:
      rst = 82;
      break;
    case U2_S_8B_12D_WREF_B:
      rst = 75;
      break;
    case U2_S_16B_12D_WREF_R:
      rst = 83;
      break;
    case U2_S_16B_12D_WREF_G:
      rst = 82;
      break;
    case U2_S_16B_12D_WREF_B:
      rst = 75;
      break;
    case U1_S_8B_12D_WREF_R:
      rst = 83;
      break;
    case U1_S_8B_12D_WREF_G:
      rst = 82;
      break;
    case U1_S_8B_12D_WREF_B:
      rst = 75;
      break;
    case U1_S_16B_12D_WREF_R:
      rst = 83;
      break;
    case U1_S_16B_12D_WREF_G:
      rst = 82;
      break;
    case U1_S_16B_12D_WREF_B:
      rst = 75;
      break;
    case U2_S_8B_6D_WREF_R:
      rst = 84;
      break;
    case U2_S_8B_6D_WREF_G:
      rst = 84;
      break;
    case U2_S_8B_6D_WREF_B:
      rst = 76;
      break;
    case U2_S_16B_6D_WREF_R:
      rst = 84;
      break;
    case U2_S_16B_6D_WREF_G:
      rst = 84;
      break;
    case U2_S_16B_6D_WREF_B:
      rst = 76;
      break;
    case U1_S_8B_6D_WREF_R:
      rst = 84;
      break;
    case U1_S_8B_6D_WREF_G:
      rst = 84;
      break;
    case U1_S_8B_6D_WREF_B:
      rst = 76;
      break;
    case U1_S_16B_6D_WREF_R:
      rst = 84;
      break;
    case U1_S_16B_6D_WREF_G:
      rst = 84;
      break;
    case U1_S_16B_6D_WREF_B:
      rst = 76;
      break;
    case U2_S_8B_3D_WREF_R:
      rst = 146;
      break;
    case U2_S_8B_3D_WREF_G:
      rst = 166;
      break;
    case U2_S_8B_3D_WREF_B:
      rst = 166;
      break;
    case U2_S_16B_3D_WREF_R:
      rst = 146;
      break;
    case U2_S_16B_3D_WREF_G:
      rst = 166;
      break;
    case U2_S_16B_3D_WREF_B:
      rst = 166;
      break;
    case U1_S_8B_3D_WREF_R:
      rst = 146;
      break;
    case U1_S_8B_3D_WREF_G:
      rst = 166;
      break;
    case U1_S_8B_3D_WREF_B:
      rst = 166;
      break;
    case U1_S_16B_3D_WREF_R:
      rst = 146;
      break;
    case U1_S_16B_3D_WREF_G:
      rst = 166;
      break;
    case U1_S_16B_3D_WREF_B:
      rst = 166;
      break;
    case U2_S_8B_2D_WREF_R:
      rst = 145;
      break;
    case U2_S_8B_2D_WREF_G:
      rst = 310;
      break;
    case U2_S_8B_2D_WREF_B:
      rst = 160;
      break;
    case U2_S_16B_2D_WREF_R:
      rst = 145;
      break;
    case U2_S_16B_2D_WREF_G:
      rst = 310;
      break;
    case U2_S_16B_2D_WREF_B:
      rst = 160;
      break;
    case U1_S_8B_2D_WREF_R:
      rst = 145;
      break;
    case U1_S_8B_2D_WREF_G:
      rst = 310;
      break;
    case U1_S_8B_2D_WREF_B:
      rst = 160;
      break;
    case U1_S_16B_2D_WREF_R:
      rst = 145;
      break;
    case U1_S_16B_2D_WREF_G:
      rst = 310;
      break;
    case U1_S_16B_2D_WREF_B:
      rst = 160;
      break;
    case U2_S_8B_1D_WREF_R:
      rst = 140;
      break;
    case U2_S_8B_1D_WREF_G:
      rst = 300;
      break;
    case U2_S_8B_1D_WREF_B:
      rst = 155;
      break;
    case U2_S_16B_1D_WREF_R:
      rst = 140;
      break;
    case U2_S_16B_1D_WREF_G:
      rst = 300;
      break;
    case U2_S_16B_1D_WREF_B:
      rst = 155;
      break;
    case U1_S_8B_1D_WREF_R:
      rst = 140;
      break;
    case U1_S_8B_1D_WREF_G:
      rst = 300;
      break;
    case U1_S_8B_1D_WREF_B:
      rst = 155;
      break;
    case U1_S_16B_1D_WREF_R:
      rst = 140;
      break;
    case U1_S_16B_1D_WREF_G:
      rst = 300;
      break;
    case U1_S_16B_1D_WREF_B:
      rst = 155;
      break;
    case U2_T_8B_24D_WREF_R:
      rst = 78;
      break;
    case U2_T_8B_24D_WREF_G:
      rst = 78;
      break;
    case U2_T_8B_24D_WREF_B:
      rst = 68;
      break;
    case U2_T_16B_24D_WREF_R:
      rst = 81;
      break;
    case U2_T_16B_24D_WREF_G:
      rst = 81;
      break;
    case U2_T_16B_24D_WREF_B:
      rst = 71;
      break;
    case U1_T_8B_24D_WREF_R:
      rst = 78;
      break;
    case U1_T_8B_24D_WREF_G:
      rst = 78;
      break;
    case U1_T_8B_24D_WREF_B:
      rst = 68;
      break;
    case U1_T_16B_24D_WREF_R:
      rst = 80;
      break;
    case U1_T_16B_24D_WREF_G:
      rst = 80;
      break;
    case U1_T_16B_24D_WREF_B:
      rst = 70;
      break;
    case U2_T_8B_12D_WREF_R:
      rst = 78;
      break;
    case U2_T_8B_12D_WREF_G:
      rst = 78;
      break;
    case U2_T_8B_12D_WREF_B:
      rst = 68;
      break;
    case U2_T_16B_12D_WREF_R:
      rst = 81;
      break;
    case U2_T_16B_12D_WREF_G:
      rst = 81;
      break;
    case U2_T_16B_12D_WREF_B:
      rst = 71;
      break;
    case U1_T_8B_12D_WREF_R:
      rst = 78;
      break;
    case U1_T_8B_12D_WREF_G:
      rst = 78;
      break;
    case U1_T_8B_12D_WREF_B:
      rst = 68;
      break;
    case U1_T_16B_12D_WREF_R:
      rst = 80;
      break;
    case U1_T_16B_12D_WREF_G:
      rst = 80;
      break;
    case U1_T_16B_12D_WREF_B:
      rst = 70;
      break;
    case U2_T_8B_6D_WREF_R:
      rst = 79;
      break;
    case U2_T_8B_6D_WREF_G:
      rst = 80;
      break;
    case U2_T_8B_6D_WREF_B:
      rst = 70;
      break;
    case U2_T_16B_6D_WREF_R:
      rst = 81;
      break;
    case U2_T_16B_6D_WREF_G:
      rst = 82;
      break;
    case U2_T_16B_6D_WREF_B:
      rst = 72;
      break;
    case U1_T_8B_6D_WREF_R:
      rst = 79;
      break;
    case U1_T_8B_6D_WREF_G:
      rst = 79;
      break;
    case U1_T_8B_6D_WREF_B:
      rst = 70;
      break;
    case U1_T_16B_6D_WREF_R:
      rst = 80;
      break;
    case U1_T_16B_6D_WREF_G:
      rst = 81;
      break;
    case U1_T_16B_6D_WREF_B:
      rst = 71;
      break;
    case U2_T_8B_3D_WREF_R:
      rst = 79;
      break;
    case U2_T_8B_3D_WREF_G:
      rst = 80;
      break;
    case U2_T_8B_3D_WREF_B:
      rst = 70;
      break;
    case U2_T_16B_3D_WREF_R:
      rst = 81;
      break;
    case U2_T_16B_3D_WREF_G:
      rst = 82;
      break;
    case U2_T_16B_3D_WREF_B:
      rst = 72;
      break;
    case U1_T_8B_3D_WREF_R:
      rst = 79;
      break;
    case U1_T_8B_3D_WREF_G:
      rst = 79;
      break;
    case U1_T_8B_3D_WREF_B:
      rst = 70;
      break;
    case U1_T_16B_3D_WREF_R:
      rst = 80;
      break;
    case U1_T_16B_3D_WREF_G:
      rst = 81;
      break;
    case U1_T_16B_3D_WREF_B:
      rst = 71;
      break;
    case U2_T_8B_2D_WREF_R:
      rst = 79;
      break;
    case U2_T_8B_2D_WREF_G:
      rst = 80;
      break;
    case U2_T_8B_2D_WREF_B:
      rst = 70;
      break;
    case U2_T_16B_2D_WREF_R:
      rst = 81;
      break;
    case U2_T_16B_2D_WREF_G:
      rst = 82;
      break;
    case U2_T_16B_2D_WREF_B:
      rst = 72;
      break;
    case U1_T_8B_2D_WREF_R:
      rst = 79;
      break;
    case U1_T_8B_2D_WREF_G:
      rst = 79;
      break;
    case U1_T_8B_2D_WREF_B:
      rst = 70;
      break;
    case U1_T_16B_2D_WREF_R:
      rst = 80;
      break;
    case U1_T_16B_2D_WREF_G:
      rst = 81;
      break;
    case U1_T_16B_2D_WREF_B:
      rst = 71;
      break;
    case U2_T_8B_1D_WREF_R:
      rst = 79;
      break;
    case U2_T_8B_1D_WREF_G:
      rst = 80;
      break;
    case U2_T_8B_1D_WREF_B:
      rst = 70;
      break;
    case U2_T_16B_1D_WREF_R:
      rst = 81;
      break;
    case U2_T_16B_1D_WREF_G:
      rst = 82;
      break;
    case U2_T_16B_1D_WREF_B:
      rst = 72;
      break;
    case U1_T_8B_1D_WREF_R:
      rst = 79;
      break;
    case U1_T_8B_1D_WREF_G:
      rst = 79;
      break;
    case U1_T_8B_1D_WREF_B:
      rst = 70;
      break;
    case U1_T_16B_1D_WREF_R:
      rst = 80;
      break;
    case U1_T_16B_1D_WREF_G:
      rst = 81;
      break;
    case U1_T_16B_1D_WREF_B:
      rst = 71;
      break;
    case BREFR:
      rst = 2;
      break;
    case BREFG:
      rst = 2;
      break;
    case BREFB:
      rst = 2;
      break;
    case REFBITDEPTH:
      rst = 8;
      break;
    case OFFSETHEIGHT:
      rst = 10;
      break;
    case S575_OFFSETPIXELSTART_2400:
      rst = 84;
      break;
    case S575_OFFSETPIXELSTART_1200:
      rst = 54;
      break;
    case S575_OFFSETPIXELSTART_600:
      rst = 28;
      break;
    case S575_OFFSETPIXELSTART_300:
      rst = 15;
      break;
    case S575_OFFSETPIXELSTART_200:
      rst = 5;
      break;
    case S575_OFFSETPIXELSTART_100:
      rst = 2;
      break;
    case T2952_OFFSETPIXELSTART_2400:
      rst = 16;
      break;
    case T2952_OFFSETPIXELSTART_1200:
      rst = 16;
      break;
    case T2952_OFFSETPIXELSTART_600:
      rst = 15;
      break;
    case T2952_OFFSETPIXELSTART_300:
      rst = 7;
      break;
    case T2952_OFFSETPIXELSTART_200:
      rst = 7;
      break;
    case T2952_OFFSETPIXELSTART_100:
      rst = 3;
      break;
    case OFFSETNPIXEL_2400:
      rst = 20;
      break;
    case OFFSETNPIXEL_1200:
      rst = 10;
      break;
    case OFFSETNPIXEL_600:
      rst = 10;
      break;
    case OFFSETNPIXEL_300:
      rst = 5;
      break;
    case OFFSETNPIXEL_200:
      rst = 3;
      break;
    case OFFSETNPIXEL_100:
      rst = 3;
      break;
    case OFFSETNSIGMA:
      rst = 2;
      break;
    case OFFSETTARGETMAX:
      rst = 50;
      break;
    case OFFSETTARGETMIN:
      rst = 2;
      break;
    case OFFSETAVGTARGETR:
      rst = 10;
      break;
    case OFFSETAVGTARGETG:
      rst = 10;
      break;
    case OFFSETAVGTARGETB:
      rst = 10;
      break;
    case ADCOFFEVENODD:
      rst = 1;
      break;
    case CALIBOFFSET1ON:
      rst = 2;
      break;
    case ADCOFFQUICKWAY:
      rst = 1;
      break;
    case ADCOFFPREDICTSTART:
      rst = 200;
      break;
    case ADCOFFPREDICTEND:
      rst = 500;
      break;
    case OFFSETTUNESTEP1:
      rst = 5;
      break;
    case OFFSETBOUNDARYRATIO1:
      rst = 100;
      break;
    case OFFSETAVGRATIO1:
      rst = 100;
      break;
    case OFFSETEVEN1R:
      rst = 323;
      break;
    case OFFSETODD1R:
      rst = 323;
      break;
    case OFFSETEVEN1G:
      rst = 327;
      break;
    case OFFSETODD1G:
      rst = 327;
      break;
    case OFFSETEVEN1B:
      rst = 327;
      break;
    case OFFSETODD1B:
      rst = 327;
      break;
    case ADCOFFPREDICTR:
      rst = 333;
      break;
    case ADCOFFPREDICTG:
      rst = 313;
      break;
    case ADCOFFPREDICTB:
      rst = 317;
      break;
    case ADCOFFEVEN1R_1ST:
      rst = 69;
      break;
    case ADCOFFODD1R_1ST:
      rst = 69;
      break;
    case ADCOFFEVEN1G_1ST:
      rst = 87;
      break;
    case ADCOFFODD1G_1ST:
      rst = 87;
      break;
    case ADCOFFEVEN1B_1ST:
      rst = 106;
      break;
    case ADCOFFODD1B_1ST:
      rst = 106;
      break;
    case PEAKR:
      rst = 42;
      break;
    case PEAKG:
      rst = 55;
      break;
    case PEAKB:
      rst = 53;
      break;
    case MINR:
      rst = 31;
      break;
    case MING:
      rst = 39;
      break;
    case MINB:
      rst = 38;
      break;
    case CALIBOFFSET2ON:
      rst = 0;
      break;
    case OFFSETTUNESTEP2:
      rst = 1;
      break;
    case OFFSETBOUNDARYRATIO2:
      rst = 100;
      break;
    case OFFSETAVGRATIO2:
      rst = 100;
      break;
    case OFFSETEVEN2R:
      rst = 0;
      break;
    case OFFSETODD2R:
      rst = 0;
      break;
    case OFFSETEVEN2G:
      rst = 0;
      break;
    case OFFSETODD2G:
      rst = 0;
      break;
    case OFFSETEVEN2B:
      rst = 0;
      break;
    case OFFSETODD2B:
      rst = 0;
      break;
    case GAINHEIGHT:
      rst = 30;
      break;
    case GAINTARGETFACTOR:
      rst = 90;
      break;
    case CALIBPAGON:
      rst = 0;
      break;
    case PAGR:
      rst = 3;
      break;
    case PAGG:
      rst = 3;
      break;
    case PAGB:
      rst = 2;
      break;
    case CALIBGAIN1ON:
      rst = 1;
      break;
    case GAIN1R:
      rst = 21;
      break;
    case GAIN1G:
      rst = 14;
      break;
    case GAIN1B:
      rst = 12;
      break;
    case CALIBGAIN2ON:
      rst = 0;
      break;
    case GAIN2R:
      rst = 4;
      break;
    case GAIN2G:
      rst = 4;
      break;
    case GAIN2B:
      rst = 4;
      break;
    case TOTSHADING:
      rst = 0;
      break;
    case BSHADINGON:
      rst = 1;
      break;
    case BSHADINGHEIGHT:
      rst = 30;
      break;
    case BSHADINGPREDIFFR:
      rst = 2;
      break;
    case BSHADINGPREDIFFG:
      rst = 2;
      break;
    case BSHADINGPREDIFFB:
      rst = 2;
      break;
    case BSHADINGDEFCUTOFF:
      rst = 0;
      break;
    case WSHADINGON:
      rst = 3;
      break;
    case WSHADINGHEIGHT:
      rst = 24;
      break;
    case WSHADINGPREDIFFR:
      rst = -1;
      break;
    case WSHADINGPREDIFFG:
      rst = -1;
      break;
    case WSHADINGPREDIFFB:
      rst = -1;
      break;
    case U2_S_8B_24D_CUT_R:
      rst = -68;
      break;
    case U2_S_8B_24D_CUT_G:
      rst = -37;
      break;
    case U2_S_8B_24D_CUT_B:
      rst = -43;
      break;
    case U2_S_16B_24D_CUT_R:
      rst = -68;
      break;
    case U2_S_16B_24D_CUT_G:
      rst = -37;
      break;
    case U2_S_16B_24D_CUT_B:
      rst = -43;
      break;
    case U1_S_8B_24D_CUT_R:
      rst = -68;
      break;
    case U1_S_8B_24D_CUT_G:
      rst = -37;
      break;
    case U1_S_8B_24D_CUT_B:
      rst = -43;
      break;
    case U1_S_16B_24D_CUT_R:
      rst = -68;
      break;
    case U1_S_16B_24D_CUT_G:
      rst = -37;
      break;
    case U1_S_16B_24D_CUT_B:
      rst = -43;
      break;
    case U2_S_8B_12D_CUT_R:
      rst = -20;
      break;
    case U2_S_8B_12D_CUT_G:
      rst = -20;
      break;
    case U2_S_8B_12D_CUT_B:
      rst = -28;
      break;
    case U2_S_16B_12D_CUT_R:
      rst = -20;
      break;
    case U2_S_16B_12D_CUT_G:
      rst = -20;
      break;
    case U2_S_16B_12D_CUT_B:
      rst = -28;
      break;
    case U1_S_8B_12D_CUT_R:
      rst = -20;
      break;
    case U1_S_8B_12D_CUT_G:
      rst = -20;
      break;
    case U1_S_8B_12D_CUT_B:
      rst = -28;
      break;
    case U1_S_16B_12D_CUT_R:
      rst = -20;
      break;
    case U1_S_16B_12D_CUT_G:
      rst = -20;
      break;
    case U1_S_16B_12D_CUT_B:
      rst = -28;
      break;
    case U2_S_8B_6D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_6D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_6D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_6D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_6D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_6D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_6D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_6D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_6D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_6D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_6D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_6D_CUT_B:
      rst = 0;
      break;
    case U2_S_8B_3D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_3D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_3D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_3D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_3D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_3D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_3D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_3D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_3D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_3D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_3D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_3D_CUT_B:
      rst = 0;
      break;
    case U2_S_8B_2D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_2D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_2D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_2D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_2D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_2D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_2D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_2D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_2D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_2D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_2D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_2D_CUT_B:
      rst = 0;
      break;
    case U2_S_8B_1D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_1D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_1D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_1D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_1D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_1D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_1D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_1D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_1D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_1D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_1D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_1D_CUT_B:
      rst = 0;
      break;
    case U2_T_8B_24D_CUT_R:
      rst = 0;
      break;
    case U2_T_8B_24D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_24D_CUT_B:
      rst = 0;
      break;
    case U2_T_16B_24D_CUT_R:
      rst = -7;
      break;
    case U2_T_16B_24D_CUT_G:
      rst = -7;
      break;
    case U2_T_16B_24D_CUT_B:
      rst = -7;
      break;
    case U1_T_8B_24D_CUT_R:
      rst = 0;
      break;
    case U1_T_8B_24D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_24D_CUT_B:
      rst = 0;
      break;
    case U1_T_16B_24D_CUT_R:
      rst = -7;
      break;
    case U1_T_16B_24D_CUT_G:
      rst = -7;
      break;
    case U1_T_16B_24D_CUT_B:
      rst = -7;
      break;
    case U2_T_8B_12D_CUT_R:
      rst = 0;
      break;
    case U2_T_8B_12D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_12D_CUT_B:
      rst = 0;
      break;
    case U2_T_16B_12D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_12D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_12D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_12D_CUT_R:
      rst = 0;
      break;
    case U1_T_8B_12D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_12D_CUT_B:
      rst = 0;
      break;
    case U1_T_16B_12D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_12D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_12D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_6D_CUT_R:
      rst = 0;
      break;
    case U2_T_8B_6D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_6D_CUT_B:
      rst = 0;
      break;
    case U2_T_16B_6D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_6D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_6D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_6D_CUT_R:
      rst = 0;
      break;
    case U1_T_8B_6D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_6D_CUT_B:
      rst = 0;
      break;
    case U1_T_16B_6D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_6D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_6D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_3D_CUT_R:
      rst = 0;
      break;
    case U2_T_8B_3D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_3D_CUT_B:
      rst = 0;
      break;
    case U2_T_16B_3D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_3D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_3D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_3D_CUT_R:
      rst = 0;
      break;
    case U1_T_8B_3D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_3D_CUT_B:
      rst = 0;
      break;
    case U1_T_16B_3D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_3D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_3D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_2D_CUT_R:
      rst = 0;
      break;
    case U2_T_8B_2D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_2D_CUT_B:
      rst = 0;
      break;
    case U2_T_16B_2D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_2D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_2D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_2D_CUT_R:
      rst = 0;
      break;
    case U1_T_8B_2D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_2D_CUT_B:
      rst = 0;
      break;
    case U1_T_16B_2D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_2D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_2D_CUT_B:
      rst = -15;
      break;
    case U2_T_8B_1D_CUT_R:
      rst = 0;
      break;
    case U2_T_8B_1D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_1D_CUT_B:
      rst = 0;
      break;
    case U2_T_16B_1D_CUT_R:
      rst = -15;
      break;
    case U2_T_16B_1D_CUT_G:
      rst = -15;
      break;
    case U2_T_16B_1D_CUT_B:
      rst = -15;
      break;
    case U1_T_8B_1D_CUT_R:
      rst = 0;
      break;
    case U1_T_8B_1D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_1D_CUT_B:
      rst = 0;
      break;
    case U1_T_16B_1D_CUT_R:
      rst = -15;
      break;
    case U1_T_16B_1D_CUT_G:
      rst = -15;
      break;
    case U1_T_16B_1D_CUT_B:
      rst = -15;
      break;
    }

  return rst;
}

static int
fc_sec8_get (int option, int defvalue)
{
  int rst = defvalue;
  switch (option)
    {
    case WSTRIPXPOS:
      rst = 0;
      break;
    case WSTRIPYPOS:
      rst = 7500;
      break;
    case BSTRIPXPOS:
      rst = 0;
      break;
    case BSTRIPYPOS:
      rst = 0;
      break;
    case T_WREFR:
      rst = 110;
      break;
    case T_WREFG:
      rst = 138;
      break;
    case T_WREFB:
      rst = 144;
      break;
    case S_WREFR:
      rst = 120;
      break;
    case S_WREFG:
      rst = 120;
      break;
    case S_WREFB:
      rst = 120;
      break;
    case U2_S_8B_24D_WREF_R:
      rst = 94;
      break;
    case U2_S_8B_24D_WREF_G:
      rst = 85;
      break;
    case U2_S_8B_24D_WREF_B:
      rst = 78;
      break;
    case U2_S_16B_24D_WREF_R:
      rst = 94;
      break;
    case U2_S_16B_24D_WREF_G:
      rst = 85;
      break;
    case U2_S_16B_24D_WREF_B:
      rst = 78;
      break;
    case U1_S_8B_24D_WREF_R:
      rst = 94;
      break;
    case U1_S_8B_24D_WREF_G:
      rst = 85;
      break;
    case U1_S_8B_24D_WREF_B:
      rst = 78;
      break;
    case U1_S_16B_24D_WREF_R:
      rst = 94;
      break;
    case U1_S_16B_24D_WREF_G:
      rst = 85;
      break;
    case U1_S_16B_24D_WREF_B:
      rst = 78;
      break;
    case U2_S_8B_12D_WREF_R:
      rst = 140;
      break;
    case U2_S_8B_12D_WREF_G:
      rst = 155;
      break;
    case U2_S_8B_12D_WREF_B:
      rst = 155;
      break;
    case U2_S_16B_12D_WREF_R:
      rst = 140;
      break;
    case U2_S_16B_12D_WREF_G:
      rst = 155;
      break;
    case U2_S_16B_12D_WREF_B:
      rst = 155;
      break;
    case U1_S_8B_12D_WREF_R:
      rst = 140;
      break;
    case U1_S_8B_12D_WREF_G:
      rst = 155;
      break;
    case U1_S_8B_12D_WREF_B:
      rst = 155;
      break;
    case U1_S_16B_12D_WREF_R:
      rst = 140;
      break;
    case U1_S_16B_12D_WREF_G:
      rst = 155;
      break;
    case U1_S_16B_12D_WREF_B:
      rst = 155;
      break;
    case U2_S_8B_6D_WREF_R:
      rst = 145;
      break;
    case U2_S_8B_6D_WREF_G:
      rst = 155;
      break;
    case U2_S_8B_6D_WREF_B:
      rst = 165;
      break;
    case U2_S_16B_6D_WREF_R:
      rst = 145;
      break;
    case U2_S_16B_6D_WREF_G:
      rst = 155;
      break;
    case U2_S_16B_6D_WREF_B:
      rst = 165;
      break;
    case U1_S_8B_6D_WREF_R:
      rst = 145;
      break;
    case U1_S_8B_6D_WREF_G:
      rst = 155;
      break;
    case U1_S_8B_6D_WREF_B:
      rst = 165;
      break;
    case U1_S_16B_6D_WREF_R:
      rst = 145;
      break;
    case U1_S_16B_6D_WREF_G:
      rst = 155;
      break;
    case U1_S_16B_6D_WREF_B:
      rst = 165;
      break;
    case U2_S_8B_3D_WREF_R:
      rst = 146;
      break;
    case U2_S_8B_3D_WREF_G:
      rst = 166;
      break;
    case U2_S_8B_3D_WREF_B:
      rst = 166;
      break;
    case U2_S_16B_3D_WREF_R:
      rst = 146;
      break;
    case U2_S_16B_3D_WREF_G:
      rst = 166;
      break;
    case U2_S_16B_3D_WREF_B:
      rst = 166;
      break;
    case U1_S_8B_3D_WREF_R:
      rst = 146;
      break;
    case U1_S_8B_3D_WREF_G:
      rst = 166;
      break;
    case U1_S_8B_3D_WREF_B:
      rst = 166;
      break;
    case U1_S_16B_3D_WREF_R:
      rst = 146;
      break;
    case U1_S_16B_3D_WREF_G:
      rst = 166;
      break;
    case U1_S_16B_3D_WREF_B:
      rst = 166;
      break;
    case U2_S_8B_2D_WREF_R:
      rst = 145;
      break;
    case U2_S_8B_2D_WREF_G:
      rst = 310;
      break;
    case U2_S_8B_2D_WREF_B:
      rst = 160;
      break;
    case U2_S_16B_2D_WREF_R:
      rst = 145;
      break;
    case U2_S_16B_2D_WREF_G:
      rst = 310;
      break;
    case U2_S_16B_2D_WREF_B:
      rst = 160;
      break;
    case U1_S_8B_2D_WREF_R:
      rst = 145;
      break;
    case U1_S_8B_2D_WREF_G:
      rst = 310;
      break;
    case U1_S_8B_2D_WREF_B:
      rst = 160;
      break;
    case U1_S_16B_2D_WREF_R:
      rst = 145;
      break;
    case U1_S_16B_2D_WREF_G:
      rst = 310;
      break;
    case U1_S_16B_2D_WREF_B:
      rst = 160;
      break;
    case U2_S_8B_1D_WREF_R:
      rst = 140;
      break;
    case U2_S_8B_1D_WREF_G:
      rst = 300;
      break;
    case U2_S_8B_1D_WREF_B:
      rst = 155;
      break;
    case U2_S_16B_1D_WREF_R:
      rst = 140;
      break;
    case U2_S_16B_1D_WREF_G:
      rst = 300;
      break;
    case U2_S_16B_1D_WREF_B:
      rst = 155;
      break;
    case U1_S_8B_1D_WREF_R:
      rst = 140;
      break;
    case U1_S_8B_1D_WREF_G:
      rst = 300;
      break;
    case U1_S_8B_1D_WREF_B:
      rst = 155;
      break;
    case U1_S_16B_1D_WREF_R:
      rst = 140;
      break;
    case U1_S_16B_1D_WREF_G:
      rst = 300;
      break;
    case U1_S_16B_1D_WREF_B:
      rst = 155;
      break;
    case U2_T_8B_24D_WREF_R:
      rst = 120;
      break;
    case U2_T_8B_24D_WREF_G:
      rst = 136;
      break;
    case U2_T_8B_24D_WREF_B:
      rst = 157;
      break;
    case U2_T_16B_24D_WREF_R:
      rst = 119;
      break;
    case U2_T_16B_24D_WREF_G:
      rst = 137;
      break;
    case U2_T_16B_24D_WREF_B:
      rst = 158;
      break;
    case U1_T_8B_24D_WREF_R:
      rst = 120;
      break;
    case U1_T_8B_24D_WREF_G:
      rst = 137;
      break;
    case U1_T_8B_24D_WREF_B:
      rst = 158;
      break;
    case U1_T_16B_24D_WREF_R:
      rst = 120;
      break;
    case U1_T_16B_24D_WREF_G:
      rst = 137;
      break;
    case U1_T_16B_24D_WREF_B:
      rst = 158;
      break;
    case U2_T_8B_12D_WREF_R:
      rst = 120;
      break;
    case U2_T_8B_12D_WREF_G:
      rst = 136;
      break;
    case U2_T_8B_12D_WREF_B:
      rst = 157;
      break;
    case U2_T_16B_12D_WREF_R:
      rst = 119;
      break;
    case U2_T_16B_12D_WREF_G:
      rst = 137;
      break;
    case U2_T_16B_12D_WREF_B:
      rst = 158;
      break;
    case U1_T_8B_12D_WREF_R:
      rst = 120;
      break;
    case U1_T_8B_12D_WREF_G:
      rst = 137;
      break;
    case U1_T_8B_12D_WREF_B:
      rst = 158;
      break;
    case U1_T_16B_12D_WREF_R:
      rst = 120;
      break;
    case U1_T_16B_12D_WREF_G:
      rst = 137;
      break;
    case U1_T_16B_12D_WREF_B:
      rst = 158;
      break;
    case U2_T_8B_6D_WREF_R:
      rst = 119;
      break;
    case U2_T_8B_6D_WREF_G:
      rst = 136;
      break;
    case U2_T_8B_6D_WREF_B:
      rst = 157;
      break;
    case U2_T_16B_6D_WREF_R:
      rst = 119;
      break;
    case U2_T_16B_6D_WREF_G:
      rst = 137;
      break;
    case U2_T_16B_6D_WREF_B:
      rst = 158;
      break;
    case U1_T_8B_6D_WREF_R:
      rst = 120;
      break;
    case U1_T_8B_6D_WREF_G:
      rst = 137;
      break;
    case U1_T_8B_6D_WREF_B:
      rst = 158;
      break;
    case U1_T_16B_6D_WREF_R:
      rst = 120;
      break;
    case U1_T_16B_6D_WREF_G:
      rst = 137;
      break;
    case U1_T_16B_6D_WREF_B:
      rst = 158;
      break;
    case U2_T_8B_3D_WREF_R:
      rst = 119;
      break;
    case U2_T_8B_3D_WREF_G:
      rst = 136;
      break;
    case U2_T_8B_3D_WREF_B:
      rst = 157;
      break;
    case U2_T_16B_3D_WREF_R:
      rst = 119;
      break;
    case U2_T_16B_3D_WREF_G:
      rst = 137;
      break;
    case U2_T_16B_3D_WREF_B:
      rst = 158;
      break;
    case U1_T_8B_3D_WREF_R:
      rst = 120;
      break;
    case U1_T_8B_3D_WREF_G:
      rst = 137;
      break;
    case U1_T_8B_3D_WREF_B:
      rst = 158;
      break;
    case U1_T_16B_3D_WREF_R:
      rst = 120;
      break;
    case U1_T_16B_3D_WREF_G:
      rst = 137;
      break;
    case U1_T_16B_3D_WREF_B:
      rst = 158;
      break;
    case U2_T_8B_2D_WREF_R:
      rst = 119;
      break;
    case U2_T_8B_2D_WREF_G:
      rst = 136;
      break;
    case U2_T_8B_2D_WREF_B:
      rst = 157;
      break;
    case U2_T_16B_2D_WREF_R:
      rst = 119;
      break;
    case U2_T_16B_2D_WREF_G:
      rst = 137;
      break;
    case U2_T_16B_2D_WREF_B:
      rst = 158;
      break;
    case U1_T_8B_2D_WREF_R:
      rst = 120;
      break;
    case U1_T_8B_2D_WREF_G:
      rst = 137;
      break;
    case U1_T_8B_2D_WREF_B:
      rst = 158;
      break;
    case U1_T_16B_2D_WREF_R:
      rst = 120;
      break;
    case U1_T_16B_2D_WREF_G:
      rst = 137;
      break;
    case U1_T_16B_2D_WREF_B:
      rst = 158;
      break;
    case U2_T_8B_1D_WREF_R:
      rst = 119;
      break;
    case U2_T_8B_1D_WREF_G:
      rst = 136;
      break;
    case U2_T_8B_1D_WREF_B:
      rst = 157;
      break;
    case U2_T_16B_1D_WREF_R:
      rst = 119;
      break;
    case U2_T_16B_1D_WREF_G:
      rst = 137;
      break;
    case U2_T_16B_1D_WREF_B:
      rst = 158;
      break;
    case U1_T_8B_1D_WREF_R:
      rst = 120;
      break;
    case U1_T_8B_1D_WREF_G:
      rst = 137;
      break;
    case U1_T_8B_1D_WREF_B:
      rst = 158;
      break;
    case U1_T_16B_1D_WREF_R:
      rst = 120;
      break;
    case U1_T_16B_1D_WREF_G:
      rst = 137;
      break;
    case U1_T_16B_1D_WREF_B:
      rst = 158;
      break;
    case BREFR:
      rst = 10;
      break;
    case BREFG:
      rst = 10;
      break;
    case BREFB:
      rst = 10;
      break;
    case REFBITDEPTH:
      rst = 8;
      break;
    case OFFSETHEIGHT:
      rst = 10;
      break;
    case S575_OFFSETPIXELSTART_2400:
      rst = 84;
      break;
    case S575_OFFSETPIXELSTART_1200:
      rst = 54;
      break;
    case S575_OFFSETPIXELSTART_600:
      rst = 28;
      break;
    case S575_OFFSETPIXELSTART_300:
      rst = 15;
      break;
    case S575_OFFSETPIXELSTART_200:
      rst = 5;
      break;
    case S575_OFFSETPIXELSTART_100:
      rst = 2;
      break;
    case T2952_OFFSETPIXELSTART_2400:
      rst = 16;
      break;
    case T2952_OFFSETPIXELSTART_1200:
      rst = 16;
      break;
    case T2952_OFFSETPIXELSTART_600:
      rst = 15;
      break;
    case T2952_OFFSETPIXELSTART_300:
      rst = 7;
      break;
    case T2952_OFFSETPIXELSTART_200:
      rst = 7;
      break;
    case T2952_OFFSETPIXELSTART_100:
      rst = 3;
      break;
    case OFFSETNPIXEL_2400:
      rst = 20;
      break;
    case OFFSETNPIXEL_1200:
      rst = 10;
      break;
    case OFFSETNPIXEL_600:
      rst = 10;
      break;
    case OFFSETNPIXEL_300:
      rst = 5;
      break;
    case OFFSETNPIXEL_200:
      rst = 3;
      break;
    case OFFSETNPIXEL_100:
      rst = 3;
      break;
    case OFFSETNSIGMA:
      rst = 2;
      break;
    case OFFSETTARGETMAX:
      rst = 50;
      break;
    case OFFSETTARGETMIN:
      rst = 2;
      break;
    case OFFSETAVGTARGETR:
      rst = 10;
      break;
    case OFFSETAVGTARGETG:
      rst = 10;
      break;
    case OFFSETAVGTARGETB:
      rst = 10;
      break;
    case ADCOFFEVENODD:
      rst = 1;
      break;
    case CALIBOFFSET1ON:
      rst = 2;
      break;
    case ADCOFFQUICKWAY:
      rst = 1;
      break;
    case ADCOFFPREDICTSTART:
      rst = 200;
      break;
    case ADCOFFPREDICTEND:
      rst = 500;
      break;
    case OFFSETTUNESTEP1:
      rst = 5;
      break;
    case OFFSETBOUNDARYRATIO1:
      rst = 100;
      break;
    case OFFSETAVGRATIO1:
      rst = 100;
      break;
    case OFFSETEVEN1R:
      rst = 294;
      break;
    case OFFSETODD1R:
      rst = 294;
      break;
    case OFFSETEVEN1G:
      rst = 276;
      break;
    case OFFSETODD1G:
      rst = 276;
      break;
    case OFFSETEVEN1B:
      rst = 266;
      break;
    case OFFSETODD1B:
      rst = 266;
      break;
    case ADCOFFPREDICTR:
      rst = 333;
      break;
    case ADCOFFPREDICTG:
      rst = 313;
      break;
    case ADCOFFPREDICTB:
      rst = 317;
      break;
    case ADCOFFEVEN1R_1ST:
      rst = 69;
      break;
    case ADCOFFODD1R_1ST:
      rst = 69;
      break;
    case ADCOFFEVEN1G_1ST:
      rst = 87;
      break;
    case ADCOFFODD1G_1ST:
      rst = 87;
      break;
    case ADCOFFEVEN1B_1ST:
      rst = 106;
      break;
    case ADCOFFODD1B_1ST:
      rst = 106;
      break;
    case PEAKR:
      rst = 33;
      break;
    case PEAKG:
      rst = 75;
      break;
    case PEAKB:
      rst = 105;
      break;
    case MINR:
      rst = 19;
      break;
    case MING:
      rst = 34;
      break;
    case MINB:
      rst = 42;
      break;
    case CALIBOFFSET2ON:
      rst = 0;
      break;
    case OFFSETTUNESTEP2:
      rst = 1;
      break;
    case OFFSETBOUNDARYRATIO2:
      rst = 100;
      break;
    case OFFSETAVGRATIO2:
      rst = 100;
      break;
    case OFFSETEVEN2R:
      rst = 0;
      break;
    case OFFSETODD2R:
      rst = 0;
      break;
    case OFFSETEVEN2G:
      rst = 0;
      break;
    case OFFSETODD2G:
      rst = 0;
      break;
    case OFFSETEVEN2B:
      rst = 0;
      break;
    case OFFSETODD2B:
      rst = 0;
      break;
    case GAINHEIGHT:
      rst = 30;
      break;
    case GAINTARGETFACTOR:
      rst = 90;
      break;
    case CALIBPAGON:
      rst = 0;
      break;
    case PAGR:
      rst = 3;
      break;
    case PAGG:
      rst = 3;
      break;
    case PAGB:
      rst = 3;
      break;
    case CALIBGAIN1ON:
      rst = 1;
      break;
    case GAIN1R:
      rst = 23;
      break;
    case GAIN1G:
      rst = 18;
      break;
    case GAIN1B:
      rst = 23;
      break;
    case CALIBGAIN2ON:
      rst = 0;
      break;
    case GAIN2R:
      rst = 4;
      break;
    case GAIN2G:
      rst = 4;
      break;
    case GAIN2B:
      rst = 4;
      break;
    case TOTSHADING:
      rst = 0;
      break;
    case BSHADINGON:
      rst = 1;
      break;
    case BSHADINGHEIGHT:
      rst = 30;
      break;
    case BSHADINGPREDIFFR:
      rst = 2;
      break;
    case BSHADINGPREDIFFG:
      rst = 2;
      break;
    case BSHADINGPREDIFFB:
      rst = 2;
      break;
    case BSHADINGDEFCUTOFF:
      rst = 0;
      break;
    case WSHADINGON:
      rst = 3;
      break;
    case WSHADINGHEIGHT:
      rst = 24;
      break;
    case WSHADINGPREDIFFR:
      rst = -1;
      break;
    case WSHADINGPREDIFFG:
      rst = -1;
      break;
    case WSHADINGPREDIFFB:
      rst = -1;
      break;
    case U2_S_8B_24D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_24D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_24D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_24D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_24D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_24D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_24D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_24D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_24D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_24D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_24D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_24D_CUT_B:
      rst = 0;
      break;
    case U2_S_8B_12D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_12D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_12D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_12D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_12D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_12D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_12D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_12D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_12D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_12D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_12D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_12D_CUT_B:
      rst = 0;
      break;
    case U2_S_8B_6D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_6D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_6D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_6D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_6D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_6D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_6D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_6D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_6D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_6D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_6D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_6D_CUT_B:
      rst = 0;
      break;
    case U2_S_8B_3D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_3D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_3D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_3D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_3D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_3D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_3D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_3D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_3D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_3D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_3D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_3D_CUT_B:
      rst = 0;
      break;
    case U2_S_8B_2D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_2D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_2D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_2D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_2D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_2D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_2D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_2D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_2D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_2D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_2D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_2D_CUT_B:
      rst = 0;
      break;
    case U2_S_8B_1D_CUT_R:
      rst = 0;
      break;
    case U2_S_8B_1D_CUT_G:
      rst = 0;
      break;
    case U2_S_8B_1D_CUT_B:
      rst = 0;
      break;
    case U2_S_16B_1D_CUT_R:
      rst = 0;
      break;
    case U2_S_16B_1D_CUT_G:
      rst = 0;
      break;
    case U2_S_16B_1D_CUT_B:
      rst = 0;
      break;
    case U1_S_8B_1D_CUT_R:
      rst = 0;
      break;
    case U1_S_8B_1D_CUT_G:
      rst = 0;
      break;
    case U1_S_8B_1D_CUT_B:
      rst = 0;
      break;
    case U1_S_16B_1D_CUT_R:
      rst = 0;
      break;
    case U1_S_16B_1D_CUT_G:
      rst = 0;
      break;
    case U1_S_16B_1D_CUT_B:
      rst = 0;
      break;
    case U2_T_8B_24D_CUT_R:
      rst = 63;
      break;
    case U2_T_8B_24D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_24D_CUT_B:
      rst = 3;
      break;
    case U2_T_16B_24D_CUT_R:
      rst = 43;
      break;
    case U2_T_16B_24D_CUT_G:
      rst = 0;
      break;
    case U2_T_16B_24D_CUT_B:
      rst = 3;
      break;
    case U1_T_8B_24D_CUT_R:
      rst = 63;
      break;
    case U1_T_8B_24D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_24D_CUT_B:
      rst = 3;
      break;
    case U1_T_16B_24D_CUT_R:
      rst = 43;
      break;
    case U1_T_16B_24D_CUT_G:
      rst = 0;
      break;
    case U1_T_16B_24D_CUT_B:
      rst = 3;
      break;
    case U2_T_8B_12D_CUT_R:
      rst = 63;
      break;
    case U2_T_8B_12D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_12D_CUT_B:
      rst = 5;
      break;
    case U2_T_16B_12D_CUT_R:
      rst = 63;
      break;
    case U2_T_16B_12D_CUT_G:
      rst = 0;
      break;
    case U2_T_16B_12D_CUT_B:
      rst = 5;
      break;
    case U1_T_8B_12D_CUT_R:
      rst = 63;
      break;
    case U1_T_8B_12D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_12D_CUT_B:
      rst = 5;
      break;
    case U1_T_16B_12D_CUT_R:
      rst = 63;
      break;
    case U1_T_16B_12D_CUT_G:
      rst = 0;
      break;
    case U1_T_16B_12D_CUT_B:
      rst = 5;
      break;
    case U2_T_8B_6D_CUT_R:
      rst = 75;
      break;
    case U2_T_8B_6D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_6D_CUT_B:
      rst = 5;
      break;
    case U2_T_16B_6D_CUT_R:
      rst = 75;
      break;
    case U2_T_16B_6D_CUT_G:
      rst = 0;
      break;
    case U2_T_16B_6D_CUT_B:
      rst = 5;
      break;
    case U1_T_8B_6D_CUT_R:
      rst = 50;
      break;
    case U1_T_8B_6D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_6D_CUT_B:
      rst = 5;
      break;
    case U1_T_16B_6D_CUT_R:
      rst = 50;
      break;
    case U1_T_16B_6D_CUT_G:
      rst = 0;
      break;
    case U1_T_16B_6D_CUT_B:
      rst = 5;
      break;
    case U2_T_8B_3D_CUT_R:
      rst = 75;
      break;
    case U2_T_8B_3D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_3D_CUT_B:
      rst = 5;
      break;
    case U2_T_16B_3D_CUT_R:
      rst = 75;
      break;
    case U2_T_16B_3D_CUT_G:
      rst = 0;
      break;
    case U2_T_16B_3D_CUT_B:
      rst = 5;
      break;
    case U1_T_8B_3D_CUT_R:
      rst = 50;
      break;
    case U1_T_8B_3D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_3D_CUT_B:
      rst = 5;
      break;
    case U1_T_16B_3D_CUT_R:
      rst = 50;
      break;
    case U1_T_16B_3D_CUT_G:
      rst = 0;
      break;
    case U1_T_16B_3D_CUT_B:
      rst = 5;
      break;
    case U2_T_8B_2D_CUT_R:
      rst = 75;
      break;
    case U2_T_8B_2D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_2D_CUT_B:
      rst = 5;
      break;
    case U2_T_16B_2D_CUT_R:
      rst = 75;
      break;
    case U2_T_16B_2D_CUT_G:
      rst = 0;
      break;
    case U2_T_16B_2D_CUT_B:
      rst = 5;
      break;
    case U1_T_8B_2D_CUT_R:
      rst = 50;
      break;
    case U1_T_8B_2D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_2D_CUT_B:
      rst = 5;
      break;
    case U1_T_16B_2D_CUT_R:
      rst = 50;
      break;
    case U1_T_16B_2D_CUT_G:
      rst = 0;
      break;
    case U1_T_16B_2D_CUT_B:
      rst = 5;
      break;
    case U2_T_8B_1D_CUT_R:
      rst = 75;
      break;
    case U2_T_8B_1D_CUT_G:
      rst = 0;
      break;
    case U2_T_8B_1D_CUT_B:
      rst = 5;
      break;
    case U2_T_16B_1D_CUT_R:
      rst = 75;
      break;
    case U2_T_16B_1D_CUT_G:
      rst = 0;
      break;
    case U2_T_16B_1D_CUT_B:
      rst = 5;
      break;
    case U1_T_8B_1D_CUT_R:
      rst = 50;
      break;
    case U1_T_8B_1D_CUT_G:
      rst = 0;
      break;
    case U1_T_8B_1D_CUT_B:
      rst = 5;
      break;
    case U1_T_16B_1D_CUT_R:
      rst = 50;
      break;
    case U1_T_16B_1D_CUT_G:
      rst = 0;
      break;
    case U1_T_16B_1D_CUT_B:
      rst = 5;
      break;
    }

  return rst;
}

static int
fc_sec9_get (int option, int defvalue)
{
  int rst = defvalue;
  switch (option)
    {
    case PARKHOMEAFTERCALIB:
      rst = 1;
      break;
    case SHADINGTIME_16BIT:
      rst = 0;
      break;
    case SHADOWTIME_16BIT:
      rst = 0;
      break;
    case SHADINGTIME_8BIT:
      rst = 0;
      break;
    case SHADOWTIME_8BIT:
      rst = 0;
      break;
    case PREVIEWDPI:
      rst = 100;
      break;
    }

  return rst;
}

static int
fc_sec10_get (int option, int defvalue)
{
  int rst = defvalue;
  switch (option)
    {
    case FIRSTDCOFFSETEVEN0:
      rst = 0;
      break;
    case FIRSTDCOFFSETODD0:
      rst = 0;
      break;
    case FIRSTDCOFFSETEVEN1:
      rst = 0;
      break;
    case FIRSTDCOFFSETODD1:
      rst = 0;
      break;
    case FIRSTDCOFFSETEVEN2:
      rst = 0;
      break;
    case FIRSTDCOFFSETODD2:
      rst = 0;
      break;
    }

  return rst;
}

static int
fc_sec_get (int section, int option, int defvalue)
{
  int rst = defvalue;

  switch (section)
    {
    case PLATFORM:
      rst = fc_sec1_get (option, defvalue);
      break;
    case SONY_LAMP:
      rst = fc_sec2_get (option, defvalue);
      break;
    case TOSHIBA_LAMP:
      rst = fc_sec3_get (option, defvalue);
      break;
    case CHECKSTABLE:
      rst = fc_sec4_get (option, defvalue);
      break;
    case AUTOREFPOS:
      rst = fc_sec5_get (option, defvalue);
      break;
    case CALIBREFLECTIVE:
      rst = fc_sec6_get (option, defvalue);
      break;
    case CALIBTRANSPARENT:
      rst = fc_sec7_get (option, defvalue);
      break;
    case CALIBNEGATIVEFILM:
      rst = fc_sec8_get (option, defvalue);
      break;
    case SCANINFO:
      rst = fc_sec9_get (option, defvalue);
      break;
    case SCAN_CALI:
      rst = fc_sec10_get (option, defvalue);
      break;
    }

  return rst;
}

static int
mc_sec1_get (int curve, int option, int defvalue)
{
  int acc[] = { 3, 3, 3, 3, 3, 3, 3, 3 };
  int dec[] = { 4, 4, 4, 4, 4, 4, 4, 4 };
  int mri[] = { 1, 1, 1, 1, 1, 1, 1, 1 };
  int msi[] = { 1, 1, 1, 1, 1, 1, 1, 1 };
  int skp[] = { 1, 1, 1, 1, 1, 1, 1, 1 };
  int rst = defvalue;

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case ACCCURVECOUNT:
	  rst = acc[curve];
	  break;
	case DECCURVECOUNT:
	  rst = dec[curve];
	  break;
	case MRI:
	  rst = mri[curve];
	  break;
	case MSI:
	  rst = msi[curve];
	  break;
	case SKIPLINECOUNT:
	  rst = skp[curve];
	  break;
	}
    }

  return rst;
}

static int
mc_sec2_get (int curve, int option, int defvalue)
{
  int nrm[] = { 1, 1, 1, 1, 1, 1, 1, 1 };
  int prk[] = { 2, 2, 2, 2, 2, 2, 2, 2 };
  int smr[] = { 3, 3, 3, 3, 2, 3, 3, 2 };
  int rst = defvalue;

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case NORMALSCAN:
	  rst = nrm[curve];
	  break;
	case PARKHOME:
	  rst = prk[curve];
	  break;
	case SMEARING:
	  rst = smr[curve];
	  break;
	}
    }

  return rst;
}

static int
mc_sec3_get (int curve, int option, int defvalue)
{
  int nrm[] = { 1, 1, 1, 1, 1, 1, 1, 1 };
  int prk[] = { 2, 2, 2, 2, 2, 2, 2, 2 };
  int smr[] = { 3, 3, 3, 3, 3, 3, 3, 3 };
  int sbf[] = { 4, 4, 4, 4, 4, 4, 4, 1 };
  int rst = defvalue;

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case NORMALSCAN:
	  rst = nrm[curve];
	  break;
	case PARKHOME:
	  rst = prk[curve];
	  break;
	case SMEARING:
	  rst = smr[curve];
	  break;
	case SCANBUFFERFULL:
	  rst = sbf[curve];
	  break;
	}
    }

  return rst;
}

static int
mc_sec4_get (int curve, int option, int defvalue)
{
  int rst = defvalue;
  int mi[] = { 2000, 4705, 5360, 4705, 3763, 23999, 1046 };
  int ma[] = { 749, 171, 1374, 171, 93, 23999, 23 };
  int co[] = { 80, 394, 12, 394, 1480, 1, 1070 };
  int ac1[] = {
    2000, 1984, 1968, 1953, 1937, 1921, 1906, 1890, 1874, 1859,
    1843, 1827, 1812, 1796, 1781, 1765, 1749, 1734, 1715, 1700,
    1684, 1669, 1653, 1637, 1622, 1606, 1590, 1572, 1556, 1541,
    1525, 1510, 1494, 1478, 1463, 1447, 1431, 1416, 1400, 1384,
    1366, 1351, 1335, 1319, 1304, 1288, 1272, 1257, 1241, 1225,
    1210, 1194, 1179, 1160, 1145, 1129, 1113, 1098, 1082, 1066,
    1051, 1035, 1017, 1001, 986, 970, 954, 939, 923, 907, 892,
    876, 861, 845, 829, 814, 798, 782, 767, 749
  };

  int ac2[] = {
    4705, 2664, 2061, 1732, 1521, 1370, 1257, 1167, 1094, 1033,
    982, 937, 898, 864, 833, 805, 780, 757, 736, 717, 699, 683,
    667, 653, 640, 627, 615, 604, 593, 583, 574, 564, 556, 547,
    540, 532, 525, 518, 511, 505, 499, 493, 487, 481, 476, 471,
    466, 461, 456, 452, 447, 443, 439, 435, 431, 427, 424, 420,
    417, 413, 410, 407, 403, 400, 397, 394, 391, 389, 386, 383,
    381, 378, 375, 373, 371, 368, 366, 364, 361, 359, 357, 355,
    353, 351, 349, 347, 345, 343, 341, 339, 338, 336, 334, 332,
    331, 329, 327, 326, 324, 323, 321, 320, 318, 317, 315, 314,
    312, 311, 310, 308, 307, 306, 304, 303, 302, 301, 299, 298,
    297, 296, 295, 293, 292, 291, 290, 289, 288, 287, 286, 285,
    284, 283, 282, 281, 280, 279, 278, 277, 276, 275, 274, 273,
    272, 271, 270, 270, 269, 268, 267, 266, 265, 264, 264, 263,
    262, 261, 260, 260, 259, 258, 257, 257, 256, 255, 255, 254,
    253, 252, 252, 251, 250, 250, 249, 248, 248, 247, 246, 246,
    245, 244, 244, 243, 242, 242, 241, 241, 240, 239, 239, 238,
    238, 237, 237, 236, 235, 235, 234, 234, 233, 233, 232, 232,
    231, 231, 230, 230, 229, 229, 228, 227, 227, 227, 226, 226,
    225, 225, 224, 224, 223, 223, 222, 222, 221, 221, 220, 220,
    219, 219, 219, 218, 218, 217, 217, 216, 216, 216, 215, 215,
    214, 214, 214, 213, 213, 212, 212, 212, 211, 211, 210, 210,
    210, 209, 209, 208, 208, 208, 207, 207, 207, 206, 206, 206,
    205, 205, 204, 204, 204, 203, 203, 203, 202, 202, 202, 201,
    201, 201, 200, 200, 200, 199, 199, 199, 198, 198, 198, 197,
    197, 197, 197, 196, 196, 196, 195, 195, 195, 194, 194, 194,
    194, 193, 193, 193, 192, 192, 192, 192, 191, 191, 191, 190,
    190, 190, 190, 189, 189, 189, 188, 188, 188, 188, 187, 187,
    187, 187, 186, 186, 186, 186, 185, 185, 185, 185, 184, 184,
    184, 184, 183, 183, 183, 183, 182, 182, 182, 182, 181, 181,
    181, 181, 181, 180, 180, 180, 180, 179, 179, 179, 179, 178,
    178, 178, 178, 178, 177, 177, 177, 177, 177, 176, 176, 176,
    176, 175, 175, 175, 175, 175, 174, 174, 174, 174, 174, 173,
    173, 173, 173, 173, 172, 172, 172, 172, 172, 171, 171, 171
  };

  int ac3[] = {
    5360, 3655, 2855, 2422, 2142, 1944, 1795, 1678, 1582, 1503, 1434, 1374
  };

  int ac4[] = {
    4705, 2664, 2061, 1732, 1521, 1370, 1257, 1167, 1094, 1033, 982,
    937, 898, 864, 833, 805, 780, 757, 736, 717, 699, 683, 667, 653, 640,
    627, 615, 604, 593, 583, 574, 564, 556, 547, 540, 532, 525, 518, 511,
    505, 499, 493, 487, 481, 476, 471, 466, 461, 456, 452, 447, 443, 439,
    435, 431, 427, 424, 420, 417, 413, 410, 407, 403, 400, 397, 394, 391,
    389, 386, 383, 381, 378, 375, 373, 371, 368, 366, 364, 361, 359, 357,
    355, 353, 351, 349, 347, 345, 343, 341, 339, 338, 336, 334, 332, 331,
    329, 327, 326, 324, 323, 321, 320, 318, 317, 315, 314, 312, 311, 310,
    308, 307, 306, 304, 303, 302, 301, 299, 298, 297, 296, 295, 293, 292,
    291, 290, 289, 288, 287, 286, 285, 284, 283, 282, 281, 280, 279, 278,
    277, 276, 275, 274, 273, 272, 271, 270, 270, 269, 268, 267, 266, 265,
    264, 264, 263, 262, 261, 260, 260, 259, 258, 257, 257, 256, 255, 255,
    254, 253, 252, 252, 251, 250, 250, 249, 248, 248, 247, 246, 246, 245,
    244, 244, 243, 242, 242, 241, 241, 240, 239, 239, 238, 238, 237, 237,
    236, 235, 235, 234, 234, 233, 233, 232, 232, 231, 231, 230, 230, 229,
    229, 228, 227, 227, 227, 226, 226, 225, 225, 224, 224, 223, 223, 222,
    222, 221, 221, 220, 220, 219, 219, 219, 218, 218, 217, 217, 216, 216,
    216, 215, 215, 214, 214, 214, 213, 213, 212, 212, 212, 211, 211, 210,
    210, 210, 209, 209, 208, 208, 208, 207, 207, 207, 206, 206, 206, 205,
    205, 204, 204, 204, 203, 203, 203, 202, 202, 202, 201, 201, 201, 200,
    200, 200, 199, 199, 199, 198, 198, 198, 197, 197, 197, 197, 196, 196,
    196, 195, 195, 195, 194, 194, 194, 194, 193, 193, 193, 192, 192, 192,
    192, 191, 191, 191, 190, 190, 190, 190, 189, 189, 189, 188, 188, 188,
    188, 187, 187, 187, 187, 186, 186, 186, 186, 185, 185, 185, 185, 184,
    184, 184, 184, 183, 183, 183, 183, 182, 182, 182, 182, 181, 181, 181,
    181, 181, 180, 180, 180, 180, 179, 179, 179, 179, 178, 178, 178, 178,
    178, 177, 177, 177, 177, 177, 176, 176, 176, 176, 175, 175, 175, 175,
    175, 174, 174, 174, 174, 174, 173, 173, 173, 173, 173, 172, 172, 172,
    172, 172, 171, 171, 171
  };

  int ac5[] = {
    3763, 3763, 3763, 3763, 3763, 3763, 2444, 2178, 1997, 1198, 1198, 1098,
    1020, 956, 903, 858, 819, 785, 754, 727, 703, 681, 662, 644, 626, 610,
    596, 582, 571, 558, 547, 537, 527, 518, 509, 500, 492, 485, 478, 471,
    464, 458, 452, 446, 440, 435, 430, 425, 420, 415, 410, 407, 402, 398,
    394, 391, 386, 383, 380, 376, 373, 369, 366, 364, 360, 357, 355, 352,
    349, 347, 344, 341, 338, 337, 334, 332, 329, 328, 325, 323, 321, 319,
    317, 315, 313, 311, 310, 308, 306, 304, 302, 301, 299, 297, 295, 294,
    293, 291, 290, 288, 286, 285, 284, 283, 281, 280, 278, 277, 275, 275,
    274, 272, 271, 270, 268, 267, 266, 265, 264, 263, 262, 261, 259, 258,
    257, 257, 256, 255, 254, 253, 251, 250, 249, 248, 248, 247, 246, 245,
    244, 243, 243, 242, 241, 240, 239, 239, 238, 237, 236, 235, 235, 234,
    233, 232, 231, 230, 230, 230, 229, 228, 228, 227, 226, 225, 225, 224,
    223, 222, 222, 221, 221, 221, 220, 219, 219, 218, 217, 217, 216, 215,
    215, 214, 213, 213, 212, 212, 212, 211, 211, 210, 209, 209, 208, 208,
    207, 207, 206, 206, 205, 204, 204, 203, 203, 203, 203, 202, 202, 201,
    201, 200, 200, 199, 199, 198, 198, 197, 197, 196, 196, 195, 195, 194,
    194, 194, 194, 194, 193, 193, 192, 192, 191, 191, 190, 190, 190, 189,
    189, 188, 188, 188, 187, 187, 186, 186, 185, 185, 185, 185, 185, 185,
    184, 184, 183, 183, 183, 182, 182, 182, 181, 181, 180, 180, 180, 179,
    179, 179, 178, 178, 178, 177, 177, 177, 176, 176, 176, 176, 176, 176,
    175, 175, 175, 174, 174, 174, 173, 173, 173, 172, 172, 172, 171, 171,
    171, 171, 170, 170, 170, 169, 169, 169, 169, 168, 168, 168, 167, 167,
    167, 167, 167, 167, 167, 166, 166, 166, 166, 165, 165, 165, 165, 164,
    164, 164, 163, 163, 163, 163, 162, 162, 162, 162, 161, 161, 161, 161,
    160, 160, 160, 160, 159, 159, 159, 159, 159, 158, 158, 158, 158, 158,
    158, 158, 158, 157, 157, 157, 157, 157, 156, 156, 156, 156, 155, 155,
    155, 155, 155, 154, 154, 154, 154, 154, 153, 153, 153, 153, 152, 152,
    152, 152, 152, 151, 151, 151, 151, 151, 150, 150, 150, 150, 150, 149,
    149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 148, 148, 148, 148,
    148, 147, 147, 147, 147, 147, 147, 146, 146, 146, 146, 146, 145, 145,
    145, 145, 145, 145, 144, 144, 144, 144, 144, 144, 143, 143, 143, 143,
    143, 143, 142, 142, 142, 142, 142, 142, 141, 141, 141, 141, 141, 141,
    140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 139,
    139, 139, 139, 139, 139, 139, 138, 138, 138, 138, 138, 138, 138, 137,
    137, 137, 137, 137, 137, 137, 136, 136, 136, 136, 136, 136, 136, 135,
    135, 135, 135, 135, 135, 135, 134, 134, 134, 134, 134, 134, 134, 134,
    133, 133, 133, 133, 133, 133, 133, 133, 132, 132, 132, 132, 132, 132,
    132, 132, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131,
    131, 131, 131, 131, 130, 130, 130, 130, 130, 130, 130, 130, 129, 129,
    129, 129, 129, 129, 129, 129, 129, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 127, 127, 127, 127, 127, 127, 127, 127, 127, 126, 126, 126,
    126, 126, 126, 126, 126, 126, 125, 125, 125, 125, 125, 125, 125, 125,
    125, 125, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 123, 123,
    123, 123, 123, 123, 123, 123, 123, 123, 122, 122, 122, 122, 122, 122,
    122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122,
    121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119, 118, 118, 118, 118, 118, 118, 118, 118,
    118, 118, 118, 118, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117,
    117, 117, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
    115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 114,
    114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 113, 113,
    113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113,
    113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 111, 111,
    111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 110, 110,
    110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
    109, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,
    108, 108, 108, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
    107, 107, 107, 107, 107, 107, 106, 106, 106, 106, 106, 106, 106, 106,
    106, 106, 106, 106, 106, 106, 106, 106, 106, 105, 105, 105, 105, 105,
    105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 103, 103, 103, 103, 103, 103,
    103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 102,
    102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102,
    102, 102, 102, 102, 102, 101, 101, 101, 101, 101, 101, 101, 101, 101,
    101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 100, 100,
    100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
    99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98,
    98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 97, 97,
    97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
    97, 97, 97, 97, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
    96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 95, 95, 95, 95, 95, 95, 95, 95,
    95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
    95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
    95, 95, 95, 95, 95, 95, 95, 95, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
    94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
    93, 93, 93, 93
  };

  int ac6[] = { 23999 };
  int ac7[] = { 6667 };

  int ac8[] = {
    1046, 1046, 1046, 1046, 1046, 1046, 647, 501, 421, 370, 333, 305, 284,
    266, 251, 239, 228, 218, 210, 202, 196, 190, 184, 179, 174, 170, 166,
    162, 159, 155, 152, 149, 147, 144, 142, 139, 137, 135, 133, 131, 129,
    127, 126, 124, 123, 121, 120, 118, 117, 116, 114, 113, 112, 111, 110,
    109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 100, 99, 98, 97, 96,
    96, 95, 94, 94, 93, 92, 92, 91, 91, 90, 89, 89, 88, 88, 87, 87, 86,
    86, 85, 85, 84, 84, 83, 83, 82, 82, 82, 81, 81, 80, 80, 79, 79, 79,
    78, 78, 78, 77, 77, 76, 76, 76, 75, 75, 75, 74, 74, 74, 74, 73, 73,
    73, 72, 72, 72, 71, 71, 71, 71, 70, 70, 70, 70, 69, 69, 69, 69, 68,
    68, 68, 68, 67, 67, 67, 67, 66, 66, 66, 66, 65, 65, 65, 65, 64, 64,
    64, 64, 63, 63, 63, 63, 62, 62, 62, 62, 61, 61, 61, 61, 61, 60, 60,
    60, 60, 60, 60, 59, 59, 59, 59, 59, 59, 59, 58, 58, 58, 58, 58, 58,
    57, 57, 57, 57, 57, 57, 57, 56, 56, 56, 56, 56, 56, 56, 56, 55, 55,
    55, 55, 55, 55, 55, 55, 54, 54, 54, 54, 54, 54, 54, 54, 53, 53, 53,
    53, 53, 53, 53, 53, 52, 52, 52, 52, 52, 52, 52, 52, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51, 50, 50, 50, 50, 50, 50, 50, 50, 50,
    50, 50, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 47, 47, 47, 47, 47, 47, 47, 47,
    47, 47, 47, 47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
    46, 46, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
    45, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 43,
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
    42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
    42, 42, 42, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
    41, 41, 41, 41, 41, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 39, 39, 39, 39, 39,
    39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
    39, 39, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
    38, 38, 38, 38, 38, 38, 38, 38, 38, 37, 37, 37, 37, 37, 37, 37, 37,
    37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 33, 33, 33, 33, 33,
    33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
    33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 23, 23
  };

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case MINSPEED:
	  rst = mi[curve];
	  break;
	case MAXSPEED:
	  rst = ma[curve];
	  break;
	case COUNT:
	  rst = co[curve];
	  break;
	default:
	  if ((option > 0) && (option <= co[curve]))
	    {
	      option--;
	      switch (curve)
		{
		case 0:
		  rst = ac1[option];
		  break;
		case 1:
		  rst = ac2[option];
		  break;
		case 2:
		  rst = ac3[option];
		  break;
		case 3:
		  rst = ac4[option];
		  break;
		case 4:
		  rst = ac5[option];
		  break;
		case 5:
		  rst = ac6[option];
		  break;
		case 6:
		  rst = ac7[option];
		  break;
		case 7:
		  rst = ac8[option];
		  break;
		}
	    }
	  break;
	}
    }

  return rst;
}

static int
mc_sec5_get (int curve, int option, int defvalue)
{
  int mi[] = { 4705, 4705, 5360, 4705, 3763, 5360, 5360, 1045 };
  int ma[] = { 500, 49, 348, 171, 138, 692, 692, 39 };
  int co[] = { 49, 49, 180, 470, 466, 41, 41, 415 };
  int ac1[] = {
    4705, 2913, 2253, 1894, 1662, 1498, 1374, 1276, 1196, 1129, 1073,
    1024, 981, 944, 910, 880, 852, 827, 804, 783, 764, 746, 729, 713,
    699, 685, 672, 659, 648, 637, 626, 616, 607, 598, 589, 581, 573,
    565, 558, 551, 544, 538, 532, 526, 520, 514, 509, 503, 500
  };

  int ac2[] = {
    4705, 2913, 2253, 1894, 1662, 1498, 1374, 1276, 1196, 1129, 1073,
    1024, 981, 944, 910, 880, 852, 827, 804, 783, 764, 746, 729, 713,
    699, 685, 672, 659, 648, 637, 626, 616, 607, 598, 589, 581, 573,
    565, 558, 551, 544, 538, 532, 526, 520, 514, 509, 503, 500
  };

  int ac3[] = {
    5360, 3362, 2628, 2229, 1973, 1791, 1654, 1547, 1458, 1384, 1319,
    1264, 1214, 1170, 1131, 1096, 1063, 1034, 1006, 981, 958, 937,
    916, 897, 880, 863, 847, 832, 818, 805, 792, 780, 769, 758, 747,
    737, 727, 718, 709, 700, 692, 684, 677, 669, 662, 655, 648, 642,
    636, 629, 624, 618, 612, 607, 602, 596, 591, 587, 582, 577, 573,
    568, 564, 560, 556, 552, 548, 544, 540, 537, 533, 530, 526, 523,
    520, 516, 513, 510, 507, 504, 501, 498, 496, 493, 490, 488, 485,
    482, 480, 477, 475, 472, 470, 468, 466, 463, 461, 459, 457, 455,
    453, 450, 448, 446, 444, 443, 441, 439, 437, 435, 433, 431, 430,
    428, 426, 425, 423, 421, 420, 418, 416, 415, 413, 412, 410, 409,
    407, 406, 405, 403, 402, 400, 399, 398, 396, 395, 394, 392, 391,
    390, 389, 387, 386, 385, 384, 382, 381, 380, 379, 378, 377, 376,
    374, 373, 372, 371, 370, 369, 368, 367, 366, 365, 364, 363, 362,
    361, 360, 359, 358, 357, 356, 355, 354, 353, 353, 352, 351, 350,
    349, 348
  };

  int ac4[] = {
    4705, 2888, 2234, 1878, 1648, 1485, 1362, 1265, 1186, 1120, 1064,
    1016, 973, 936, 903, 873, 845, 821, 798, 777, 758, 740, 723, 708,
    693, 679, 666, 654, 643, 632, 621, 612, 602, 593, 585, 576, 569,
    561, 554, 547, 540, 534, 528, 522, 516, 510, 505, 499, 494, 490,
    485, 480, 476, 471, 467, 463, 459, 455, 451, 448, 444, 440, 437,
    434, 430, 427, 424, 421, 418, 415, 412, 409, 407, 404, 401, 399,
    396, 394, 391, 389, 387, 384, 382, 380, 378, 376, 374, 371, 369,
    367, 366, 364, 362, 360, 358, 356, 354, 353, 351, 349, 348, 346,
    344, 343, 341, 340, 338, 337, 335, 334, 332, 331, 329, 328, 327,
    325, 324, 323, 321, 320, 319, 318, 316, 315, 314, 313, 312, 311,
    309, 308, 307, 306, 305, 304, 303, 302, 301, 300, 299, 298, 297,
    296, 295, 294, 293, 292, 291, 290, 289, 288, 287, 286, 285, 285,
    284, 283, 282, 281, 280, 279, 279, 278, 277, 276, 275, 275, 274,
    273, 272, 272, 271, 270, 269, 269, 268, 267, 267, 266, 265, 264,
    264, 263, 262, 262, 261, 260, 260, 259, 259, 258, 257, 257, 256,
    255, 255, 254, 254, 253, 252, 252, 251, 251, 250, 249, 249, 248,
    248, 247, 247, 246, 246, 245, 245, 244, 243, 243, 242, 242, 241,
    241, 240, 240, 239, 239, 238, 238, 237, 237, 237, 236, 236, 235,
    235, 234, 234, 233, 233, 232, 232, 231, 231, 231, 230, 230, 229,
    229, 228, 228, 228, 227, 227, 226, 226, 225, 225, 225, 224, 224,
    223, 223, 223, 222, 222, 222, 221, 221, 220, 220, 220, 219, 219,
    219, 218, 218, 217, 217, 217, 216, 216, 216, 215, 215, 215, 214,
    214, 214, 213, 213, 213, 212, 212, 212, 211, 211, 211, 210, 210,
    210, 209, 209, 209, 208, 208, 208, 207, 207, 207, 207, 206, 206,
    206, 205, 205, 205, 204, 204, 204, 204, 203, 203, 203, 202, 202,
    202, 202, 201, 201, 201, 200, 200, 200, 200, 199, 199, 199, 199,
    198, 198, 198, 198, 197, 197, 197, 196, 196, 196, 196, 195, 195,
    195, 195, 194, 194, 194, 194, 193, 193, 193, 193, 192, 192, 192,
    192, 192, 191, 191, 191, 191, 190, 190, 190, 190, 189, 189, 189,
    189, 189, 188, 188, 188, 188, 187, 187, 187, 187, 187, 186, 186,
    186, 186, 186, 185, 185, 185, 185, 184, 184, 184, 184, 184, 183,
    183, 183, 183, 183, 182, 182, 182, 182, 182, 181, 181, 181, 181,
    181, 180, 180, 180, 180, 180, 180, 179, 179, 179, 179, 179, 178,
    178, 178, 178, 178, 177, 177, 177, 177, 177, 177, 176, 176, 176,
    176, 176, 176, 175, 175, 175, 175, 175, 174, 174, 174, 174, 174,
    174, 173, 173, 173, 173, 173, 173, 172, 172, 172, 172, 172, 172,
    171, 171, 171, 171
  };

  int ac5[] = {
    3763, 2330, 1803, 1515, 1330, 1198, 1099, 1021, 957, 904, 859,
    819, 785, 755, 728, 704, 682, 662, 644, 626, 611, 597, 583, 571,
    559, 548, 537, 527, 518, 509, 501, 493, 485, 478, 472, 464, 458,
    453, 446, 441, 436, 430, 425, 420, 416, 411, 407, 402, 399, 394,
    391, 387, 383, 380, 376, 374, 370, 366, 364, 361, 358, 355, 352,
    349, 347, 344, 342, 339, 337, 335, 332, 330, 328, 326, 323, 321,
    320, 318, 315, 313, 311, 310, 308, 306, 304, 302, 301, 300, 298,
    296, 294, 293, 292, 290, 289, 287, 285, 284, 283, 282, 280, 279,
    277, 276, 275, 274, 273, 271, 270, 269, 267, 266, 266, 265, 263,
    262, 261, 260, 259, 258, 257, 256, 255, 254, 253, 252, 251, 250,
    249, 248, 248, 247, 246, 245, 244, 243, 242, 241, 240, 239, 239,
    239, 238, 237, 236, 235, 234, 233, 233, 232, 231, 230, 230, 230,
    229, 228, 227, 227, 226, 225, 224, 224, 223, 222, 221, 221, 221,
    220, 220, 219, 218, 218, 217, 216, 216, 215, 214, 214, 213, 213,
    212, 212, 212, 211, 211, 210, 209, 209, 208, 208, 207, 207, 206,
    205, 205, 204, 204, 203, 203, 203, 203, 202, 202, 201, 201, 200,
    200, 199, 199, 198, 198, 197, 197, 196, 196, 195, 195, 194, 194,
    194, 194, 194, 193, 193, 192, 192, 191, 191, 191, 190, 190, 189,
    189, 188, 188, 188, 187, 187, 186, 186, 186, 185, 185, 185, 185,
    185, 184, 184, 184, 183, 183, 182, 182, 182, 181, 181, 181, 180,
    180, 180, 179, 179, 178, 178, 178, 177, 177, 177, 176, 176, 176,
    176, 176, 176, 175, 175, 175, 174, 174, 174, 174, 173, 173, 173,
    172, 172, 172, 171, 171, 171, 170, 170, 170, 170, 169, 169, 169,
    168, 168, 168, 168, 167, 167, 167, 167, 167, 167, 167, 166, 166,
    166, 166, 165, 165, 165, 165, 164, 164, 164, 163, 163, 163, 163,
    162, 162, 162, 162, 161, 161, 161, 161, 160, 160, 160, 160, 160,
    159, 159, 159, 159, 158, 158, 158, 158, 158, 158, 158, 158, 157,
    157, 157, 157, 157, 156, 156, 156, 156, 155, 155, 155, 155, 155,
    154, 154, 154, 154, 154, 153, 153, 153, 153, 153, 152, 152, 152,
    152, 152, 151, 151, 151, 151, 151, 150, 150, 150, 150, 150, 149,
    149, 149, 149, 149, 149, 149, 149, 149, 149, 148, 148, 148, 148,
    148, 148, 147, 147, 147, 147, 147, 147, 146, 146, 146, 146, 146,
    145, 145, 145, 145, 145, 145, 144, 144, 144, 144, 144, 144, 143,
    143, 143, 143, 143, 143, 142, 142, 142, 142, 142, 142, 141, 141,
    141, 141, 141, 141, 141, 140, 140, 140, 140, 140, 140, 140, 140,
    140, 140, 140, 140, 140, 139, 139, 139, 139, 139, 139, 139, 138
  };

  int ac6[] = {
    5360, 3362, 2628, 2229, 1973, 1791, 1654, 1547, 1458, 1384, 1319,
    1264, 1214, 1170, 1131, 1096, 1063, 1034, 1006, 981, 958, 937,
    916, 897, 880, 863, 847, 832, 818, 805, 792, 780, 769, 758, 747,
    737, 727, 718, 709, 700, 692
  };

  int ac7[] = {
    5360, 3362, 2628, 2229, 1973, 1791, 1654, 1547, 1458, 1384, 1319,
    1264, 1214, 1170, 1131, 1096, 1063, 1034, 1006, 981, 958, 937,
    916, 897, 880, 863, 847, 832, 818, 805, 792, 780, 769, 758, 747,
    737, 727, 718, 709, 700, 692
  };

  int ac8[] = {
    1045, 678, 604, 554, 332, 332, 304, 283, 265, 250, 238, 227, 217,
    209, 201, 195, 189, 183, 178, 173, 169, 165, 161, 158, 154, 151, 148,
    146, 143, 141, 138, 136, 134, 132, 130, 128, 126, 125, 123, 122, 120,
    119, 117, 116, 115, 113, 112, 111, 110, 109, 108, 107, 106, 105, 104,
    103, 102, 101, 100, 99, 99, 98, 97, 96, 95, 95, 94, 93, 93, 92, 91, 91,
    90, 90, 89, 88, 88, 87, 87, 86, 86, 85, 85, 84, 84, 83, 83, 82, 82, 81,
    81, 81, 80, 80, 79, 79, 78, 78, 78, 77, 77, 77, 76, 76, 75, 75, 75, 74,
    74, 74, 73, 73, 73, 73, 72, 72, 72, 71, 71, 71, 70, 70, 70, 70, 69, 69,
    69, 69, 68, 68, 68, 68, 67, 67, 67, 67, 66, 66, 66, 66, 65, 65, 65, 65,
    65, 64, 64, 64, 64, 64, 63, 63, 63, 63, 63, 62, 62, 62, 62, 62, 61, 61,
    61, 61, 61, 61, 60, 60, 60, 60, 60, 60, 59, 59, 59, 59, 59, 59, 58, 58,
    58, 58, 58, 58, 58, 57, 57, 57, 57, 57, 57, 57, 56, 56, 56, 56, 56, 56,
    56, 55, 55, 55, 55, 55, 55, 55, 55, 54, 54, 54, 54, 54, 54, 54, 54, 53,
    53, 53, 53, 53, 53, 53, 53, 53, 52, 52, 52, 52, 52, 52, 52, 52, 52, 51,
    51, 51, 51, 51, 51, 51, 51, 51, 51, 50, 50, 50, 50, 50, 50, 50, 50, 50,
    50, 50, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
    47, 47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 44, 44, 44, 44, 44,
    44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 43, 43, 43, 43, 43, 43,
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 42, 42, 42, 42, 42, 42, 42,
    42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 41, 41, 41, 41, 41, 41,
    41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 40, 40, 40, 40,
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
    39
  };

  int rst = defvalue;

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case MINSPEED:
	  rst = mi[curve];
	  break;
	case MAXSPEED:
	  rst = ma[curve];
	  break;
	case COUNT:
	  rst = co[curve];
	  break;
	default:
	  if ((option > 0) && (option <= co[curve]))
	    {
	      option--;
	      switch (curve)
		{
		case 0:
		  rst = ac1[option];
		  break;
		case 1:
		  rst = ac2[option];
		  break;
		case 2:
		  rst = ac3[option];
		  break;
		case 3:
		  rst = ac4[option];
		  break;
		case 4:
		  rst = ac5[option];
		  break;
		case 5:
		  rst = ac6[option];
		  break;
		case 6:
		  rst = ac7[option];
		  break;
		case 7:
		  rst = ac8[option];
		  break;
		}
	    }
	  break;
	}
    }

  return rst;
}

static int
mc_sec6_get (int curve, int option, int defvalue)
{
  int mi[] = { 200, 200, 5360, 4705, 3763, 23999, 6667, 1045 };
  int ma[] = { 1000, 1000, 1547, 675, 540, 23999, 6667, 151 };
  int co[] = { 4, 4, 8, 27, 27, 1, 1, 26 };
  int ac1[] = { 200, 12, 14, 16 };
  int ac2[] = { 200, 12, 14, 16 };
  int ac3[] = { 5360, 3362, 2628, 2229, 1973, 1791, 1654, 1547 };
  int ac4[] = {
    4705, 3056, 2724, 2497, 1498, 1498, 1374, 1276, 1196, 1130, 1073,
    1025, 982, 944, 911, 880, 853, 828, 805, 784, 764, 746, 730, 714,
    699, 685, 675
  };

  int ac5[] = {
    3763, 2330, 1803, 1515, 1330, 1198, 1099, 1021, 957, 904, 859, 819,
    785, 755, 728, 704, 682, 662, 644, 626, 611, 597, 583, 571, 559, 548,
    540
  };

  int ac6[] = { 23999 };
  int ac7[] = { 6667 };
  int ac8[] = {
    1045, 678, 604, 554, 332, 332, 304, 283, 265, 250, 238, 227, 217, 209,
    201, 195, 189, 183, 178, 173, 169, 165, 161, 158, 154, 151
  };

  int rst = defvalue;

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case MINSPEED:
	  rst = mi[curve];
	  break;
	case MAXSPEED:
	  rst = ma[curve];
	  break;
	case COUNT:
	  rst = co[curve];
	  break;
	default:
	  if ((option > 0) && (option <= co[curve]))
	    {
	      option--;
	      switch (curve)
		{
		case 0:
		  rst = ac1[option];
		  break;
		case 1:
		  rst = ac2[option];
		  break;
		case 2:
		  rst = ac3[option];
		  break;
		case 3:
		  rst = ac4[option];
		  break;
		case 4:
		  rst = ac5[option];
		  break;
		case 5:
		  rst = ac6[option];
		  break;
		case 6:
		  rst = ac7[option];
		  break;
		case 7:
		  rst = ac8[option];
		  break;
		}
	    }
	  break;
	}
    }

  return rst;
}

static int
mc_sec7_get (int curve, int option, int defvalue)
{
  int mi[] = { 2000, 4705, 5360, 4705, 3763, 23999, 6667, 1045 };
  int ma[] = { 749, 171, 1374, 171, 86, 23999, 6667, 25 };
  int co[] = { 4, 126, 12, 126, 165, 1, 1, 165 };
  int dc1[] = { 749, 1166, 1583, 2000 };
  int dc2[] = {
    171, 172, 172, 173, 174, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181,
    181, 182, 183, 184, 184, 185, 186, 187, 188, 189, 189, 190, 191, 192, 193,
    194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 207, 208, 209,
    210, 211, 213, 214, 215, 217, 218, 219, 221, 222, 224, 225, 227, 228, 230,
    232, 233, 235, 237, 239, 241, 243, 245, 247, 249, 251, 253, 255, 258, 260,
    262, 265, 268, 270, 273, 276, 279, 282, 285, 289, 292, 296, 299, 303, 307,
    311, 316, 320, 325, 330, 335, 341, 347, 353, 359, 366, 373, 381, 390, 398,
    408, 418, 429, 441, 455, 469, 485, 503, 523, 545, 571, 601, 636, 678, 730,
    796, 883, 1005, 1195, 1544, 4705
  };
  int dc3[] = {
    1374, 1434, 1503, 1582, 1678, 1795, 1944, 2142, 2422, 2855, 3655, 5360
  };
  int dc4[] = {
    171, 172, 172, 173, 174, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181,
    181, 182, 183, 184, 184, 185, 186, 187, 188, 189, 189, 190, 191, 192, 193,
    194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 207, 208, 209,
    210, 211, 213, 214, 215, 217, 218, 219, 221, 222, 224, 225, 227, 228, 230,
    232, 233, 235, 237, 239, 241, 243, 245, 247, 249, 251, 253, 255, 258, 260,
    262, 265, 268, 270, 273, 276, 279, 282, 285, 289, 292, 296, 299, 303, 307,
    311, 316, 320, 325, 330, 335, 341, 347, 353, 359, 366, 373, 381, 390, 398,
    408, 418, 429, 441, 455, 469, 485, 503, 523, 545, 571, 601, 636, 678, 730,
    796, 883, 1005, 1195, 1544, 4705
  };

  int dc5[] = {
    86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
    86, 86, 86, 86, 87, 87, 87, 87, 87, 87, 87, 87, 88, 88, 88, 88, 88, 88,
    88, 88, 89, 89, 89, 89, 89, 89, 89, 90, 90, 90, 90, 90, 90, 91, 91, 91,
    91, 91, 92, 92, 92, 92, 93, 93, 93, 93, 94, 94, 94, 95, 95, 95, 95, 95,
    96, 96, 97, 97, 98, 98, 99, 99, 100, 100, 101, 101, 102, 102, 103, 104,
    104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 113, 115, 117, 119,
    121, 122, 124, 127, 130, 132, 135, 139, 142, 146, 149, 153, 158, 162,
    167, 171, 176, 180, 186, 193, 202, 209, 216, 223, 232, 243, 254, 266,
    279, 292, 306, 320, 335, 337, 351, 367, 380, 396, 414, 437, 464, 493,
    520, 549, 583, 611, 644, 675, 711, 755, 785, 819, 859, 904, 957, 1021,
    1099, 1198, 1330, 1515, 1803, 2330, 3763
  };

  int dc6[] = { 23999 };
  int dc7[] = { 6667 };
  int dc8[] = {
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 30, 30, 30,
    30, 31, 31, 31, 31, 32, 32, 32, 32, 33, 33, 34, 34, 35, 35, 36, 37, 38,
    38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 50, 51, 53, 54, 57, 59, 61, 63,
    65, 68, 71, 75, 78, 82, 86, 90, 94, 94, 98, 103, 106, 111, 116, 122,
    130, 138, 145, 153, 163, 171, 180, 188, 198, 211, 219, 228, 239, 252,
    267, 284, 306, 334, 370, 422, 502, 648, 1045
  };

  int rst = defvalue;

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case MINSPEED:
	  rst = mi[curve];
	  break;
	case MAXSPEED:
	  rst = ma[curve];
	  break;
	case COUNT:
	  rst = co[curve];
	  break;
	default:
	  if ((option > 0) && (option <= co[curve]))
	    {
	      option--;
	      switch (curve)
		{
		case 0:
		  rst = dc1[option];
		  break;
		case 1:
		  rst = dc2[option];
		  break;
		case 2:
		  rst = dc3[option];
		  break;
		case 3:
		  rst = dc4[option];
		  break;
		case 4:
		  rst = dc5[option];
		  break;
		case 5:
		  rst = dc6[option];
		  break;
		case 6:
		  rst = dc7[option];
		  break;
		case 7:
		  rst = dc8[option];
		  break;
		}
	    }
	  break;
	}
    }

  return rst;
}

static int
mc_sec8_get (int curve, int option, int defvalue)
{
  int mi[] = { 4705, 4705, 5360, 4705, 3763, 5360, 5360, 1045 };
  int ma[] = { 500, 500, 348, 171, 138, 692, 692, 39 };
  int co[] = { 49, 49, 61, 156, 56, 41, 41, 56 };
  int dc1[] = {
    500, 503, 509, 514, 520, 526, 532, 538, 544, 551, 558, 565, 573, 581,
    589, 598, 607, 616, 626, 637, 648, 659, 672, 685, 699, 713, 729, 746,
    764, 783, 804, 827, 852, 880, 910, 944, 981, 1024, 1073, 1129, 1196,
    1276, 1374, 1498, 1662, 1894, 2253, 2913, 4705
  };
  int dc2[] = {
    500, 503, 509, 514, 520, 526, 532, 538, 544, 551, 558, 565, 573, 581,
    589, 598, 607, 616, 626, 637, 648, 659, 672, 685, 699, 713, 729, 746,
    764, 783, 804, 827, 852, 880, 910, 944, 981, 1024, 1073, 1129, 1196,
    1276, 1374, 1498, 1662, 1894, 2253, 2913, 4705
  };
  int dc3[] = {
    348, 351, 353, 356, 359, 362, 365, 368, 371, 374, 378, 381, 385, 389,
    392, 396, 400, 405, 409, 413, 418, 423, 428, 433, 439, 444, 450, 457,
    463, 470, 477, 485, 493, 501, 510, 520, 530, 540, 552, 564, 577, 591,
    607, 624, 642, 662, 684, 709, 737, 769, 805, 847, 897, 958, 1034, 1131,
    1264, 1458, 1791, 2628, 5360
  };
  int dc4[] = {
    171, 172, 172, 173, 173, 174, 174, 175, 175, 176, 176, 177, 177, 178,
    179, 179, 180, 180, 181, 182, 182, 183, 183, 184, 185, 185, 186, 187,
    187, 188, 189, 189, 190, 191, 192, 192, 193, 194, 195, 195, 196, 197,
    198, 199, 199, 200, 201, 202, 203, 204, 205, 206, 206, 207, 208, 209,
    210, 211, 212, 213, 214, 215, 217, 218, 219, 220, 221, 222, 223, 225,
    226, 227, 228, 230, 231, 232, 234, 235, 237, 238, 240, 241, 243, 244,
    246, 247, 249, 251, 253, 254, 256, 258, 260, 262, 264, 266, 268, 271,
    273, 275, 278, 280, 282, 285, 288, 290, 293, 296, 299, 302, 305, 309,
    312, 316, 319, 323, 327, 331, 336, 340, 345, 350, 355, 360, 365, 371,
    377, 384, 391, 398, 406, 414, 422, 432, 441, 452, 463, 476, 489, 504,
    520, 538, 558, 580, 605, 633, 667, 706, 752, 810, 883, 979, 1116, 1326,
    1714, 4705
  };
  int dc5[] = {
    138, 142, 146, 149, 153, 158, 162, 167, 171, 176, 180, 186, 193, 202,
    209, 216, 223, 232, 243, 254, 266, 279, 292, 306, 320, 335, 337, 351,
    367, 380, 396, 414, 437, 464, 493, 520, 549, 583, 611, 644, 675, 711,
    755, 785, 819, 859, 904, 957, 1021, 1099, 1198, 1330, 1515, 1803, 2330,
    3763
  };
  int dc6[] = {
    692, 700, 709, 718, 727, 737, 747, 758, 769, 780, 792, 805, 818, 832, 847,
    863, 880, 897, 916, 937, 958, 981, 1006, 1034, 1063, 1096, 1131, 1170,
    1214, 1264, 1319, 1384, 1458, 1547, 1654, 1791, 1973, 2229, 2628, 3362,
    5360
  };
  int dc7[] = {
    692, 700, 709, 718, 727, 737, 747, 758, 769, 780, 792, 805, 818, 832, 847,
    863, 880, 897, 916, 937, 958, 981, 1006, 1034, 1063, 1096, 1131, 1170,
    1214, 1264, 1319, 1384, 1458, 1547, 1654, 1791, 1973, 2229, 2628, 3362,
    5360
  };
  int dc8[] = {
    39, 40, 41, 42, 43, 45, 46, 47, 48, 50, 51, 53, 54, 57, 59, 61, 63, 65,
    68, 71, 75, 78, 82, 86, 90, 94, 94, 98, 103, 106, 111, 116, 122, 130, 138,
    145, 153, 163, 171, 180, 188, 198, 211, 219, 228, 239, 252, 267, 284, 306,
    334, 370, 422, 502, 648, 1045
  };

  int rst = defvalue;

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case MINSPEED:
	  rst = mi[curve];
	  break;
	case MAXSPEED:
	  rst = ma[curve];
	  break;
	case COUNT:
	  rst = co[curve];
	  break;
	default:
	  if ((option > 0) && (option <= co[curve]))
	    {
	      option--;
	      switch (curve)
		{
		case 0:
		  rst = dc1[option];
		  break;
		case 1:
		  rst = dc2[option];
		  break;
		case 2:
		  rst = dc3[option];
		  break;
		case 3:
		  rst = dc4[option];
		  break;
		case 4:
		  rst = dc5[option];
		  break;
		case 5:
		  rst = dc6[option];
		  break;
		case 6:
		  rst = dc7[option];
		  break;
		case 7:
		  rst = dc8[option];
		  break;
		}
	    }
	  break;
	}
    }

  return rst;
}

static int
mc_sec9_get (int curve, int option, int defvalue)
{
  int mi[] = { 100, 100, 5360, 4705, 3763, 23999, 6667, 1045 };
  int ma[] = { 300, 300, 1547, 675, 138, 23999, 6667, 39 };
  int co[] = { 4, 4, 8, 27, 466, 1, 1, 466 };
  int dc1[] = { 300, 234, 167, 100 };
  int dc2[] = { 300, 234, 167, 100 };
  int dc3[] = { 1547, 1654, 1791, 1973, 2229, 2628, 3362, 5360 };
  int dc4[] = {
    675, 685, 699, 714, 730, 746, 764, 784, 805, 828, 853, 880, 911, 944,
    982, 1025, 1073, 1130, 1196, 1276, 1374, 1498, 1498, 2497, 2724, 3056,
    4705
  };
  int dc5[] = {
    138, 139, 139, 139, 139, 139, 139, 139, 140, 140, 140, 140, 140, 140,
    140, 140, 140, 140, 140, 140, 140, 141, 141, 141, 141, 141, 141, 141,
    142, 142, 142, 142, 142, 142, 143, 143, 143, 143, 143, 143, 144, 144,
    144, 144, 144, 144, 145, 145, 145, 145, 145, 145, 146, 146, 146, 146,
    146, 147, 147, 147, 147, 147, 147, 148, 148, 148, 148, 148, 148, 149,
    149, 149, 149, 149, 149, 149, 149, 149, 149, 150, 150, 150, 150, 150,
    151, 151, 151, 151, 151, 152, 152, 152, 152, 152, 153, 153, 153, 153,
    153, 154, 154, 154, 154, 154, 155, 155, 155, 155, 155, 156, 156, 156,
    156, 157, 157, 157, 157, 157, 158, 158, 158, 158, 158, 158, 158, 158,
    159, 159, 159, 159, 160, 160, 160, 160, 160, 161, 161, 161, 161, 162,
    162, 162, 162, 163, 163, 163, 163, 164, 164, 164, 165, 165, 165, 165,
    166, 166, 166, 166, 167, 167, 167, 167, 167, 167, 167, 168, 168, 168,
    168, 169, 169, 169, 170, 170, 170, 170, 171, 171, 171, 172, 172, 172,
    173, 173, 173, 174, 174, 174, 174, 175, 175, 175, 176, 176, 176, 176,
    176, 176, 177, 177, 177, 178, 178, 178, 179, 179, 180, 180, 180, 181,
    181, 181, 182, 182, 182, 183, 183, 184, 184, 184, 185, 185, 185, 185,
    185, 186, 186, 186, 187, 187, 188, 188, 188, 189, 189, 190, 190, 191,
    191, 191, 192, 192, 193, 193, 194, 194, 194, 194, 194, 195, 195, 196,
    196, 197, 197, 198, 198, 199, 199, 200, 200, 201, 201, 202, 202, 203,
    203, 203, 203, 204, 204, 205, 205, 206, 207, 207, 208, 208, 209, 209,
    210, 211, 211, 212, 212, 212, 213, 213, 214, 214, 215, 216, 216, 217,
    218, 218, 219, 220, 220, 221, 221, 221, 222, 223, 224, 224, 225, 226,
    227, 227, 228, 229, 230, 230, 230, 231, 232, 233, 233, 234, 235, 236,
    237, 238, 239, 239, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248,
    248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261,
    262, 263, 265, 266, 266, 267, 269, 270, 271, 273, 274, 275, 276, 277,
    279, 280, 282, 283, 284, 285, 287, 289, 290, 292, 293, 294, 296, 298,
    300, 301, 302, 304, 306, 308, 310, 311, 313, 315, 318, 320, 321, 323,
    326, 328, 330, 332, 335, 337, 339, 342, 344, 347, 349, 352, 355, 358,
    361, 364, 366, 370, 374, 376, 380, 383, 387, 391, 394, 399, 402, 407,
    411, 416, 420, 425, 430, 436, 441, 446, 453, 458, 464, 472, 478, 485,
    493, 501, 509, 518, 527, 537, 548, 559, 571, 583, 597, 611, 626, 644,
    662, 682, 704, 728, 755, 785, 819, 859, 904, 957, 1021, 1099, 1198,
    1330, 1515, 1803, 2330, 3763
  };
  int dc6[] = { 23999 };
  int dc7[] = { 6667 };
  int dc8[] = {
    39, 39, 39, 39, 39, 39, 39, 39, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 41, 41,
    41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
    41, 41, 41, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
    42, 42, 42, 42, 42, 42, 42, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
    43, 43, 43, 43, 43, 43, 43, 43, 43, 44, 44, 44, 44, 44, 44, 44, 44, 44,
    44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45, 45, 46, 46, 46, 46, 46, 46, 46, 46, 46,
    46, 46, 46, 46, 46, 46, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
    47, 47, 47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
    49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50,
    50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52,
    52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53,
    53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55,
    55, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 58,
    58, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, 59, 59, 60, 60, 60, 60, 60,
    60, 60, 61, 61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 63, 63, 63, 63,
    63, 64, 64, 64, 64, 64, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 67, 67,
    67, 67, 67, 68, 68, 68, 68, 69, 69, 69, 69, 70, 70, 70, 70, 71, 71, 71,
    71, 72, 72, 72, 73, 73, 73, 73, 74, 74, 74, 75, 75, 75, 76, 76, 76, 77,
    77, 77, 78, 78, 78, 79, 79, 79, 80, 80, 81, 81, 81, 82, 82, 83, 83, 84,
    84, 84, 85, 85, 86, 86, 87, 87, 88, 88, 89, 90, 90, 91, 91, 92, 93, 93,
    94, 94, 95, 96, 96, 97, 98, 99, 99, 100, 101, 102, 103, 104, 105, 105,
    106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 118, 119, 120, 122,
    123, 125, 127, 128, 130, 132, 134, 136, 138, 140, 142, 145, 147, 150,
    153, 156, 159, 163, 167, 171, 175, 180, 185, 190, 196, 203, 211, 219,
    228, 239, 252, 267, 284, 306, 334, 370, 422, 502, 648, 1045
  };

  int rst = defvalue;

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case MINSPEED:
	  rst = mi[curve];
	  break;
	case MAXSPEED:
	  rst = ma[curve];
	  break;
	case COUNT:
	  rst = co[curve];
	  break;
	default:
	  if ((option > 0) && (option <= co[curve]))
	    {
	      option--;
	      switch (curve)
		{
		case 0:
		  rst = dc1[option];
		  break;
		case 1:
		  rst = dc2[option];
		  break;
		case 2:
		  rst = dc3[option];
		  break;
		case 3:
		  rst = dc4[option];
		  break;
		case 4:
		  rst = dc5[option];
		  break;
		case 5:
		  rst = dc6[option];
		  break;
		case 6:
		  rst = dc7[option];
		  break;
		case 7:
		  rst = dc8[option];
		  break;
		}
	    }
	  break;
	}
    }

  return rst;
}

static int
mc_sec10_get (int curve, int option, int defvalue)
{
  int mi[] = { 400, 400, 5360, 4705, 3763, 23999, 6667, 1045 };
  int ma[] = { 1100, 1100, 1374, 171, 93, 23999, 6667, 25 };
  int co[] = { 4, 4, 12, 126, 165, 1, 1, 165 };
  int dc1[] = { 1100, 867, 633, 400 };
  int dc2[] = { 1100, 867, 633, 400 };
  int dc3[] = {
    1374, 1434, 1503, 1582, 1678, 1795, 1944, 2142, 2422, 2855, 3655, 5360
  };
  int dc4[] = {
    171, 172, 172, 173, 174, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181,
    181, 182, 183, 184, 184, 185, 186, 187, 188, 189, 189, 190, 191, 192, 193,
    194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 207, 208, 209,
    210, 211, 213, 214, 215, 217, 218, 219, 221, 222, 224, 225, 227, 228, 230,
    232, 233, 235, 237, 239, 241, 243, 245, 247, 249, 251, 253, 255, 258, 260,
    262, 265, 268, 270, 273, 276, 279, 282, 285, 289, 292, 296, 299, 303, 307,
    311, 316, 320, 325, 330, 335, 341, 347, 353, 359, 366, 373, 381, 390, 398,
    408, 418, 429, 441, 455, 469, 485, 503, 523, 545, 571, 601, 636, 678, 730,
    796, 883, 1005, 1195, 1544, 4705
  };

  int dc5[] = {
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
      93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
      93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
      93,
    93, 93, 93, 93, 93, 93, 93, 94, 94, 94, 95, 95, 95, 95, 95, 96, 96, 97,
      97,
    98, 98, 99, 99, 100, 100, 101, 101, 102, 102, 103, 104, 104, 105, 106,
      107,
    108, 109, 110, 111, 112, 113, 113, 115, 117, 119, 121, 122, 124, 127, 130,
    132, 135, 139, 142, 146, 149, 153, 158, 162, 167, 171, 176, 180, 186, 193,
    202, 209, 216, 223, 232, 243, 254, 266, 279, 292, 306, 320, 335, 337, 351,
    367, 380, 396, 414, 437, 464, 493, 520, 549, 583, 611, 644, 675, 711, 755,
    785, 819, 859, 904, 957, 1021, 1099, 1198, 1330, 1515, 1803, 2330, 3763
  };
  int dc6[] = { 23999 };
  int dc7[] = { 6667 };
  int dc8[] = {
    1045, 648, 502, 422, 370, 334, 306, 284, 267, 252, 239, 228, 219, 211,
      198,
    188, 180, 171, 163, 153, 145, 138, 130, 122, 116, 111, 106, 103, 98, 94,
    94, 90, 86, 82, 78, 75, 71, 68, 65, 63, 61, 59, 57, 54, 53, 51, 50, 48,
    47, 46, 45, 43, 42, 41, 40, 39, 38, 38, 37, 36, 35, 35, 34, 34, 33, 33,
    32, 32, 32, 32, 31, 31, 31, 31, 30, 30, 30, 30, 29, 29, 29, 29, 29, 29,
    29, 28, 28, 28, 28, 28, 28, 28, 28, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25
  };

  int rst = defvalue;

  if ((curve > 0) && (curve < 9))
    {
      curve--;
      switch (option)
	{
	case MINSPEED:
	  rst = mi[curve];
	  break;
	case MAXSPEED:
	  rst = ma[curve];
	  break;
	case COUNT:
	  rst = co[curve];
	  break;
	default:
	  if ((option > 0) && (option <= co[curve]))
	    {
	      option--;
	      switch (curve)
		{
		case 0:
		  rst = dc1[option];
		  break;
		case 1:
		  rst = dc2[option];
		  break;
		case 2:
		  rst = dc3[option];
		  break;
		case 3:
		  rst = dc4[option];
		  break;
		case 4:
		  rst = dc5[option];
		  break;
		case 5:
		  rst = dc6[option];
		  break;
		case 6:
		  rst = dc7[option];
		  break;
		case 7:
		  rst = dc8[option];
		  break;
		}
	    }
	  break;
	}
    }

  return rst;
}

static int
mc_sec_get (int curve, int section, int option, int defvalue)
{
  int rst = defvalue;

  switch (section)
    {
    case MOTORSETTING:
      rst = mc_sec1_get (curve, option, defvalue);
      break;
    case ACC:
      rst = mc_sec2_get (curve, option, defvalue);
      break;
    case DEC:
      rst = mc_sec3_get (curve, option, defvalue);
      break;
    case ACCCURVE1:
      rst = mc_sec4_get (curve, option, defvalue);
      break;
    case ACCCURVE2:
      rst = mc_sec5_get (curve, option, defvalue);
      break;
    case ACCCURVE3:
      rst = mc_sec6_get (curve, option, defvalue);
      break;
    case DECCURVE1:
      rst = mc_sec7_get (curve, option, defvalue);
      break;
    case DECCURVE2:
      rst = mc_sec8_get (curve, option, defvalue);
      break;
    case DECCURVE3:
      rst = mc_sec9_get (curve, option, defvalue);
      break;
    case DECCURVE4:
      rst = mc_sec10_get (curve, option, defvalue);
      break;
    }

  return rst;
}

static int
srt_sec1_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 1, 0, 0, 150, 9480, 0, 1, 0, 6, 0, 0, 0, 0, 0, 170, 140,
    40, 30, 40, 30, 1500, 20, 1, 0, 9, 38, 36, 280, 266, 286, 0,
    0, 0, 280, 266, 286, 0, 0, 0, 3, 3, 3, 7, 4, 4, 7, 4, 4, 360,
    15, 39, 56, 108, 221, 407, 60, 117, 161, 342, 642, 1285, 1,
    1, 0
  };
  /* s_usb1inifile */
  int value2[] = { 1, 0, 0, 150, 9480, 0, 1, 0, 6, 0, 0, 0, 0, 0, 170, 140,
    40, 30, 40, 30, 1500, 20, 1, 0, 9, 38, 36, 280, 266, 286, 0,
    0, 0, 280, 266, 286, 0, 0, 0, 3, 3, 3, 7, 4, 4, 7, 4, 4, 360,
    15, 39, 56, 108, 221, 407, 60, 117, 161, 342, 642, 1285, 1,
    1, 0
  };
  /* t_rtinifile */
  int value3[] = { 1, 0, 0, 150, 9480, 1, 1, 0, 12, 0, 0, 0, 0, 0, 170, 140,
    40, 30, 40, 30, 1500, 20, 1, 0, 9, 38, 36, 280, 266, 286, 0,
    0, 0, 280, 266, 286, 0, 0, 0, 3, 3, 3, 7, 4, 4, 7, 4, 4, 0,
    28, 37, 52, 103, 156, 309, 60, 117, 162, 344, 660, 1262, 1,
    1, 0
  };
  /* t_usb1inifile */
  int value4[] = { 1, 0, 0, 150, 9480, 0, 1, 0, 12, 0, 0, 0, 0, 0, 170, 140,
    40, 30, 40, 30, 1500, 20, 1, 0, 9, 38, 36, 280, 266, 286, 0,
    0, 0, 280, 266, 286, 0, 0, 0, 3, 3, 3, 7, 4, 4, 7, 4, 4, 0,
    28, 37, 52, 103, 156, 309, 60, 117, 162, 344, 660, 1262, 1,
    1, 0
  };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case ARRANGELINE:
	rst = value[0];
	break;
      case CALIBRATE:
	rst = value[1];
	break;
      case COMPRESSION:
	rst = value[2];
	break;
      case TA_X_START:
	rst = value[3];
	break;
      case TA_Y_START:
	rst = value[4];
	break;
      case CCDTYPE:
	rst = value[5];
	break;
      case DPIGAINCONTROL600:
	rst = value[6];
	break;
      case DPILUMPING100:
	rst = value[7];
	break;
      case CRVS:
	rst = value[8];
	break;
      case VRTS:
	rst = value[9];
	break;
      case VRMS:
	rst = value[10];
	break;
      case VRBS:
	rst = value[11];
	break;
      case MLOCK:
	rst = value[12];
	break;
      case ENABLEWARMUP:
	rst = value[13];
	break;
      case NMAXTARGET:
	rst = value[14];
	break;
      case NMINTARGET:
	rst = value[15];
	break;
      case NMAXTARGETTA:
	rst = value[16];
	break;
      case NMINTARGETTA:
	rst = value[17];
	break;
      case NMAXTARGETNEG:
	rst = value[18];
	break;
      case NMINTARGETNEG:
	rst = value[19];
	break;
      case STABLEDIFF:
	rst = value[20];
	break;
      case DELTAPWM:
	rst = value[21];
	break;
      case PWMLAMPENABLED:
	rst = value[22];
	break;
      case PWMLAMPLEVEL:
	rst = value[23];
	break;
      case PWMLAMPFREQUENCYFLB1200:
	rst = value[24];
	break;
      case PWMLAMPDUTYCYCLEFLB1200:
	rst = value[25];
	break;
      case TMAPWMDUTY:
	rst = value[26];
	break;
      case EDCG11:
	rst = value[27];
	break;
      case EDCG12:
	rst = value[28];
	break;
      case EDCG13:
	rst = value[29];
	break;
      case EDCG21:
	rst = value[30];
	break;
      case EDCG22:
	rst = value[31];
	break;
      case EDCG23:
	rst = value[32];
	break;
      case ODCG11:
	rst = value[33];
	break;
      case ODCG12:
	rst = value[34];
	break;
      case ODCG13:
	rst = value[35];
	break;
      case ODCG21:
	rst = value[36];
	break;
      case ODCG22:
	rst = value[37];
	break;
      case ODCG23:
	rst = value[38];
	break;
      case PAG1:
	rst = value[39];
	break;
      case PAG2:
	rst = value[40];
	break;
      case PAG3:
	rst = value[41];
	break;
      case VGAG11:
	rst = value[42];
	break;
      case VGAG12:
	rst = value[43];
	break;
      case VGAG13:
	rst = value[44];
	break;
      case VGAG21:
	rst = value[45];
	break;
      case VGAG22:
	rst = value[46];
	break;
      case VGAG23:
	rst = value[47];
	break;
      case LEFTLEADING:
	rst = value[48];
	break;
      case SER_100:
	rst = value[49];
	break;
      case SER_200:
	rst = value[50];
	break;
      case SER_300:
	rst = value[51];
	break;
      case SER_600:
	rst = value[52];
	break;
      case SER_1200:
	rst = value[53];
	break;
      case SER_2400:
	rst = value[54];
	break;
      case LER_100:
	rst = value[55];
	break;
      case LER_200:
	rst = value[56];
	break;
      case LER_300:
	rst = value[57];
	break;
      case LER_600:
	rst = value[58];
	break;
      case LER_1200:
	rst = value[59];
	break;
      case LER_2400:
	rst = value[60];
	break;
      case SSCGENABLE:
	rst = value[61];
	break;
      case SSCGMODE:
	rst = value[62];
	break;
      case SSCGCLOCKCONTROL:
	rst = value[63];
	break;
      }

  return rst;
}

static int
srt_sec2_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 48, 40, 40, 40, 40, 40, 48, 40, 40, 40, 40, 40, 48,
    40, 40, 40, 40, 40, 48, 40, 40, 40, 40, 40
  };
  /* s_usb1inifile */
  int value2[] = { 48, 40, 40, 40, 40, 40, 48, 40, 40, 40, 40, 40, 48,
    40, 40, 40, 40, 40, 48, 40, 40, 40, 40, 40
  };
  /* t_usb1inifile */
  int value3[] = { 48, 40, 40, 40, 40, 40, 48, 40, 40, 40, 40, 40, 48,
    22, 22, 22, 22, 22, 48, 22, 22, 22, 22, 22
  };

  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_USB1INIFILE:
      value = value3;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case TA_PWM_100_8BIT:
	rst = value[0];
	break;
      case TA_PWM_200_8BIT:
	rst = value[1];
	break;
      case TA_PWM_300_8BIT:
	rst = value[2];
	break;
      case TA_PWM_600_8BIT:
	rst = value[3];
	break;
      case TA_PWM_1200_8BIT:
	rst = value[4];
	break;
      case TA_PWM_2400_8BIT:
	rst = value[5];
	break;
      case TA_PWM_100_16BIT:
	rst = value[6];
	break;
      case TA_PWM_200_16BIT:
	rst = value[7];
	break;
      case TA_PWM_300_16BIT:
	rst = value[8];
	break;
      case TA_PWM_600_16BIT:
	rst = value[9];
	break;
      case TA_PWM_1200_16BIT:
	rst = value[10];
	break;
      case TA_PWM_2400_16BIT:
	rst = value[11];
	break;
      case NEG_PWM_100_8BIT:
	rst = value[12];
	break;
      case NEG_PWM_200_8BIT:
	rst = value[13];
	break;
      case NEG_PWM_300_8BIT:
	rst = value[14];
	break;
      case NEG_PWM_600_8BIT:
	rst = value[15];
	break;
      case NEG_PWM_1200_8BIT:
	rst = value[16];
	break;
      case NEG_PWM_2400_8BIT:
	rst = value[17];
	break;
      case NEG_PWM_100_16BIT:
	rst = value[18];
	break;
      case NEG_PWM_200_16BIT:
	rst = value[19];
	break;
      case NEG_PWM_300_16BIT:
	rst = value[20];
	break;
      case NEG_PWM_600_16BIT:
	rst = value[21];
	break;
      case NEG_PWM_1200_16BIT:
	rst = value[22];
	break;
      case NEG_PWM_2400_16BIT:
	rst = value[23];
	break;
      }

  return rst;
}

static int
srt_sec4_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 378, 148, 170, 172, 0, 0, 0, 286, 276, 286, 0,
    0, 0, 286, 276, 286, 0, 0, 0, 4, 4, 4, 4, 4, 4
  };
  /* s_usb1inifile */
  int value2[] = { 378, 148, 170, 172, 0, 0, 0, 286, 276, 286, 0,
    0, 0, 286, 276, 286, 0, 0, 0, 4, 4, 4, 4, 4, 4
  };
  /* t_rtinifile */
  int value3[] = { 378, 64, 64, 160, 0, 0, 0, 286, 276, 286, 0, 0, 0,
    286, 276, 286, 0, 0, 0, 4, 4, 4, 4, 4, 4
  };
  /* t_usb1inifile */
  int value4[] = { 378, 64, 64, 160, 0, 0, 0, 286, 276, 286, 0, 0, 0,
    286, 276, 286, 0, 0, 0, 4, 4, 4, 4, 4, 4
  };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case WAVE_XSTART:
	rst = value[0];
	break;
      case WAVE_S575_XDUMMY_2400:
	rst = value[1];
	break;
      case WAVE_S575_XDUMMY_1200:
	rst = value[2];
	break;
      case WAVE_S575_XDUMMY_600:
	rst = value[3];
	break;
      case PAG1:
	rst = value[4];
	break;
      case PAG2:
	rst = value[5];
	break;
      case PAG3:
	rst = value[6];
	break;
      case ODD_DCOFFSET11:
	rst = value[7];
	break;
      case ODD_DCOFFSET12:
	rst = value[8];
	break;
      case ODD_DCOFFSET13:
	rst = value[9];
	break;
      case ODD_DCOFFSET21:
	rst = value[10];
	break;
      case ODD_DCOFFSET22:
	rst = value[11];
	break;
      case ODD_DCOFFSET23:
	rst = value[12];
	break;
      case EVEN_DCOFFSET11:
	rst = value[13];
	break;
      case EVEN_DCOFFSET12:
	rst = value[14];
	break;
      case EVEN_DCOFFSET13:
	rst = value[15];
	break;
      case EVEN_DCOFFSET21:
	rst = value[16];
	break;
      case EVEN_DCOFFSET22:
	rst = value[17];
	break;
      case EVEN_DCOFFSET23:
	rst = value[18];
	break;
      case DCGAIN11:
	rst = value[19];
	break;
      case DCGAIN12:
	rst = value[20];
	break;
      case DCGAIN13:
	rst = value[21];
	break;
      case DCGAIN21:
	rst = value[22];
	break;
      case DCGAIN22:
	rst = value[23];
	break;
      case DCGAIN23:
	rst = value[24];
	break;
      }

  return rst;
}

static int
srt_sec3_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 40, 48, 40, 40, 40, 40, 40, 48, 40, 40, 40, 40, 36,
    40, 40, 40, 40, 40, 36, 40, 40, 40, 40, 40
  };
  /* s_usb1inifile */
  int value2[] = { 40, 48, 40, 40, 40, 40, 40, 48, 40, 40, 40, 40, 36,
    40, 40, 40, 40, 40, 36, 40, 40, 40, 40, 40
  };
  /* t_rtinifile */
  int value3[] = { 40, 48, 40, 40, 40, 40, 40, 48, 40, 40, 40, 40, 36,
    40, 22, 22, 22, 22, 36, 40, 22, 22, 22, 22
  };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case TA_PWM_100_8BIT:
	rst = value[0];
	break;
      case TA_PWM_200_8BIT:
	rst = value[1];
	break;
      case TA_PWM_300_8BIT:
	rst = value[2];
	break;
      case TA_PWM_600_8BIT:
	rst = value[3];
	break;
      case TA_PWM_1200_8BIT:
	rst = value[4];
	break;
      case TA_PWM_2400_8BIT:
	rst = value[5];
	break;
      case TA_PWM_100_16BIT:
	rst = value[6];
	break;
      case TA_PWM_200_16BIT:
	rst = value[7];
	break;
      case TA_PWM_300_16BIT:
	rst = value[8];
	break;
      case TA_PWM_600_16BIT:
	rst = value[9];
	break;
      case TA_PWM_1200_16BIT:
	rst = value[10];
	break;
      case TA_PWM_2400_16BIT:
	rst = value[11];
	break;
      case NEG_PWM_100_8BIT:
	rst = value[12];
	break;
      case NEG_PWM_200_8BIT:
	rst = value[13];
	break;
      case NEG_PWM_300_8BIT:
	rst = value[14];
	break;
      case NEG_PWM_600_8BIT:
	rst = value[15];
	break;
      case NEG_PWM_1200_8BIT:
	rst = value[16];
	break;
      case NEG_PWM_2400_8BIT:
	rst = value[17];
	break;
      case NEG_PWM_100_16BIT:
	rst = value[18];
	break;
      case NEG_PWM_200_16BIT:
	rst = value[19];
	break;
      case NEG_PWM_300_16BIT:
	rst = value[20];
	break;
      case NEG_PWM_600_16BIT:
	rst = value[21];
	break;
      case NEG_PWM_1200_16BIT:
	rst = value[22];
	break;
      case NEG_PWM_2400_16BIT:
	rst = value[23];
	break;
      }

  return rst;
}

static int
srt_sec5_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 0x80000, 0x7c0000, 0x400000, 7200 };
  /* s_usb1inifile */
  int value2[] = { 0x80000, 0x7c0000, 0x400000, 7200 };
  /* t_rtinifile */
  int value3[] = { 0x80000, 0x7c0000, 0x400000, 7200 };
  /* t_usb1inifile */
  int value4[] = { 0x80000, 0x7c0000, 0x400000, 7200 };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case DMATRANSFERSIZE:
	rst = value[0];
	break;
      case DMASETLENGTH:
	rst = value[1];
	break;
      case DMABUFFERSIZE:
	rst = value[2];
	break;
      case CRYSTALFREQ:
	rst = value[3];
	break;
      }

  return rst;
}

static int
srt_sec6_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 3, 3, 3, 14, 4, 4, 41, 41, 42, 41, 41, 42, 91, 91,
    53, 53, 48, 48, 104, 104, 59, 59, 64, 64
  };
  /* s_usb1inifile */
  int value2[] = { 3, 3, 3, 14, 4, 4, 41, 41, 42, 41, 41, 42, 91, 91,
    53, 53, 48, 48, 104, 104, 59, 59, 64, 64
  };
  /* t_rtinifile */
  int value3[] = { 3, 3, 3, 14, 4, 4, 41, 41, 42, 41, 41, 42, 270, 270,
    511, 511, 511, 511, 270, 270, 511, 511, 511, 511
  };
  /* t_usb1inifile */
  int value4[] = { 3, 3, 3, 14, 4, 4, 41, 41, 42, 41, 41, 42, 270, 270,
    511, 511, 511, 511, 270, 270, 511, 511, 511, 511
  };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case PGA1:
	rst = value[0];
	break;
      case PGA2:
	rst = value[1];
	break;
      case PGA3:
	rst = value[2];
	break;
      case VGAGAIN11:
	rst = value[3];
	break;
      case VGAGAIN12:
	rst = value[4];
	break;
      case VGAGAIN13:
	rst = value[5];
	break;
      case DCSTEPEVEN1:
	rst = value[6];
	break;
      case DCSTEPODD1:
	rst = value[7];
	break;
      case DCSTEPEVEN2:
	rst = value[8];
	break;
      case DCSTEPODD2:
	rst = value[9];
	break;
      case DCSTEPEVEN3:
	rst = value[10];
	break;
      case DCSTEPODD3:
	rst = value[11];
	break;
      case FIRSTDCOFFSETEVEN11:
	rst = value[12];
	break;
      case FIRSTDCOFFSETODD11:
	rst = value[13];
	break;
      case FIRSTDCOFFSETEVEN12:
	rst = value[14];
	break;
      case FIRSTDCOFFSETODD12:
	rst = value[15];
	break;
      case FIRSTDCOFFSETEVEN13:
	rst = value[16];
	break;
      case FIRSTDCOFFSETODD13:
	rst = value[17];
	break;
      case DCOFFSETEVEN11:
	rst = value[18];
	break;
      case DCOFFSETODD11:
	rst = value[19];
	break;
      case DCOFFSETEVEN12:
	rst = value[20];
	break;
      case DCOFFSETODD12:
	rst = value[21];
	break;
      case DCOFFSETEVEN13:
	rst = value[22];
	break;
      case DCOFFSETODD13:
	rst = value[23];
	break;
      }

  return rst;
}

static int
srt_sec7_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 100, 30, 59, 11 };
  /* s_usb1inifile */
  int value2[] = { 100, 30, 59, 11 };
  /* t_rtinifile */
  int value3[] = { 100, 30, 59, 11 };
  /* t_usb1inifile */
  int value4[] = { 100, 30, 59, 11 };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case SHADINGBASE:
	rst = value[0];
	break;
      case SHADINGFACT1:
	rst = value[1];
	break;
      case SHADINGFACT2:
	rst = value[2];
	break;
      case SHADINGFACT3:
	rst = value[3];
	break;
      }

  return rst;
}

static int
srt_sec8_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 5, 4, 0xffff, 20, 35 };
  /* s_usb1inifile */
  int value2[] = { 5, 4, 0xffff, 20, 35 };
  /* t_rtinifile */
  int value3[] = { 5, 4, 0xffff, 20, 35 };
  /* t_usb1inifile */
  int value4[] = { 5, 4, 0xffff, 20, 35 };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case LINEDARKLEVEL1:
	rst = value[0];
	break;
      case LINEDARKLEVEL2:
	rst = value[1];
	break;
      case PIXELDARKLEVEL:
	rst = value[2];
	break;
      case PIXELDARKSCANLINES:
	rst = value[3];
	break;
      case PIXELDARKDISCARDPERCENT:
	rst = value[4];
	break;
      }

  return rst;
}

static int
srt_sec9_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 7000, 1, 60, -10, 0, 600 };
  /* s_usb1inifile */
  int value2[] = { 7000, 1, 60, -10, 0, 600 };
  /* t_rtinifile */
  int value3[] = { 7000, 1, 60, -10, 0, 600 };
  /* t_usb1inifile */
  int value4[] = { 7000, 1, 60, -10, 0, 600 };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case EXPOSURETIME:
	rst = value[0];
	break;
      case SCANYSTART:
	rst = value[1];
	break;
      case SCANYLINES:
	rst = value[2];
	break;
      case CHECKOFFSETSER:
	rst = value[3];
	break;
      case FINDSERSTART:
	rst = value[4];
	break;
      case FINDSEREND:
	rst = value[5];
	break;
      }

  return rst;
}

static int
srt_sec10_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 0 };
  /* s_usb1inifile */
  int value2[] = { 0 };
  /* t_rtinifile */
  int value3[] = { 0 };
  /* t_usb1inifile */
  int value4[] = { 0 };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case COLOR600:
	rst = value[0];
	break;
      }

  return rst;
}

static int
srt_sec11_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 1, 2, 1, 1, 800 };
  /* s_usb1inifile */
  int value2[] = { 1, 2, 1, 1, 800 };
  /* t_rtinifile */
  int value3[] = { 1, 2, 1, 1, 800 };
  /* t_usb1inifile */
  int value4[] = { 1, 2, 1, 1, 800 };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    switch (option)
      {
      case CHANGEMOTORCURRENT:
	rst = value[0];
	break;
      case BASESPEEDMOTORMOVE:
	rst = value[1];
	break;
      case HIGHSPEEDMOTORMOVE:
	rst = value[2];
	break;
      case PARKHOMEMOTORMOVE:
	rst = value[3];
	break;
      case BASESPEEDPPS:
	rst = value[4];
	break;
      }

  return rst;
}

static int
srt_sec12_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = {
    4, 1, 123, 1, 123, 2400, 24, 4, 0, 2400, 48, 0xF5F8FA, 128, 127, 15, 0,
    1214636, 6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200,
    100, 6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200, 100,
    6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200, 100, 12,
    8, 2
  };
  /* s_usb1inifile */
  int value2[] = {
    4, 1, 123, 1, 123, 2400, 24, 4, 0, 2400, 48, 0xF5F8FA, 128, 127, 15, 0,
    1214636, 6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200,
    100, 6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200, 100,
    6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200, 100, 12,
    8, 2
  };
  /* t_rtinifile */
  int value3[] = {
    4, 1, 123, 1, 123, 2400, 24, 4, 0, 2400, 48, 0xF5F8FA, 128, 127, 15, 0,
    1214636, 6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200,
    100, 6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200, 100,
    6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200, 100, 12,
    8, 2
  };
  /* t_usb1inifile */
  int value4[] = {
    4, 1, 123, 1, 123, 2400, 24, 4, 0, 2400, 48, 0xF5F8FA, 128, 127, 15, 0,
    1214636, 6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200,
    100, 6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200, 100,
    6, 2400, 1200, 600, 300, 200, 100, 6, 2400, 1200, 600, 300, 200, 100, 12,
    8, 2
  };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    {
      switch (option)
	{
	case BUTTONCOUNT:
	  rst = value[0];
	  break;
	case SENSORTYPE:
	  rst = value[1];
	  break;
	case SENSORCHANNELCOLOR:
	  rst = value[2];
	  break;
	case SENSORCHANNELGRAY:
	  rst = value[3];
	  break;
	case RGBCHANNELORDER:
	  rst = value[4];
	  break;
	case REALSENSORRESOLUTION:
	  rst = value[5];
	  break;
	case SENSORLINEDISTANCE:
	  rst = value[6];
	  break;
	case SENSOREVENODDDISTANCE:
	  rst = value[7];
	  break;
	case MOTORTYPE:
	  rst = value[8];
	  break;
	case MOTORRESOLUTION:
	  rst = value[9];
	  break;
	case BUFFERFULLMOTORBACKSTEP:
	  rst = value[10];
	  break;
	case BASETARGETCODE:
	  rst = value[11];
	  break;
	case BINARYTHRESHOLDH:
	  rst = value[12];
	  break;
	case BINARYTHRESHOLDL:
	  rst = value[13];
	  break;
	case LAMPOFFTIMER:
	  rst = value[14];
	  break;
	case LAMPWARMUPCHECKLEVEL:
	  rst = value[15];
	  break;
	case CLOSETIME:
	  rst = value[16];
	  break;
	case SCANCOLORCOUNT:
	  rst = value[17];
	  break;
	case SCANCOLORMODE1:
	  rst = value[18];
	  break;
	case SCANCOLORMODE2:
	  rst = value[19];
	  break;
	case SCANCOLORMODE3:
	  rst = value[20];
	  break;
	case SCANCOLORMODE4:
	  rst = value[21];
	  break;
	case SCANCOLORMODE5:
	  rst = value[22];
	  break;
	case SCANCOLORMODE6:
	  rst = value[23];
	  break;
	case SCANTACOLORCOUNT:
	  rst = value[24];
	  break;
	case SCANTACOLORMODE1:
	  rst = value[25];
	  break;
	case SCANTACOLORMODE2:
	  rst = value[26];
	  break;
	case SCANTACOLORMODE3:
	  rst = value[27];
	  break;
	case SCANTACOLORMODE4:
	  rst = value[28];
	  break;
	case SCANTACOLORMODE5:
	  rst = value[29];
	  break;
	case SCANTACOLORMODE6:
	  rst = value[30];
	  break;
	case SCANNEGCOLORCOUNT:
	  rst = value[31];
	  break;
	case SCANNEGCOLORMODE1:
	  rst = value[32];
	  break;
	case SCANNEGCOLORMODE2:
	  rst = value[33];
	  break;
	case SCANNEGCOLORMODE3:
	  rst = value[34];
	  break;
	case SCANNEGCOLORMODE4:
	  rst = value[35];
	  break;
	case SCANNEGCOLORMODE5:
	  rst = value[36];
	  break;
	case SCANNEGCOLORMODE6:
	  rst = value[37];
	  break;
	case SCANGRAYCOUNT:
	  rst = value[38];
	  break;
	case SCANGRAYMODE1:
	  rst = value[39];
	  break;
	case SCANGRAYMODE2:
	  rst = value[40];
	  break;
	case SCANGRAYMODE3:
	  rst = value[41];
	  break;
	case SCANGRAYMODE4:
	  rst = value[42];
	  break;
	case SCANGRAYMODE5:
	  rst = value[43];
	  break;
	case SCANGRAYMODE6:
	  rst = value[44];
	  break;
	case SCANTAGRAYCOUNT:
	  rst = value[45];
	  break;
	case SCANTAGRAYMODE1:
	  rst = value[46];
	  break;
	case SCANTAGRAYMODE2:
	  rst = value[47];
	  break;
	case SCANTAGRAYMODE3:
	  rst = value[48];
	  break;
	case SCANTAGRAYMODE4:
	  rst = value[49];
	  break;
	case SCANTAGRAYMODE5:
	  rst = value[50];
	  break;
	case SCANTAGRAYMODE6:
	  rst = value[51];
	  break;
	case SCANNEGGRAYCOUNT:
	  rst = value[52];
	  break;
	case SCANNEGGRAYMODE1:
	  rst = value[53];
	  break;
	case SCANNEGGRAYMODE2:
	  rst = value[54];
	  break;
	case SCANNEGGRAYMODE3:
	  rst = value[55];
	  break;
	case SCANNEGGRAYMODE4:
	  rst = value[56];
	  break;
	case SCANNEGGRAYMODE5:
	  rst = value[57];
	  break;
	case SCANNEGGRAYMODE6:
	  rst = value[58];
	  break;
	case TIMINGCOUNT:
	  rst = value[59];
	  break;
	case MOTORCOUNT:
	  rst = value[60];
	  break;
	case MOTORMOVECOUNT:
	  rst = value[61];
	  break;
	}
    }

  return rst;
}

static int
srt_sec13_get (int file, int section, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 2, 6431, 1, 2 };
  int value2[] = { 2, 6431, 1, 2 };
  /* s_usb1inifile */
  int value3[] = { 2, 6431, 1, 2 };
  int value4[] = { 2, 2000, 1, 0 };
  /* t_rtinifile */
  int value5[] = { 2, 6431, 1, 2 };
  int value6[] = { 2, 2000, 1, 0 };
  /* t_usb1inifile */
  int value7[] = { 2, 6431, 1, 2 };
  int value8[] = { 2, 2000, 1, 0 };
  int *value = NULL;
  int *pvalue1 = NULL;
  int *pvalue2 = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      pvalue1 = value1;
      pvalue2 = value2;
      break;
    case S_USB1INIFILE:
      pvalue1 = value3;
      pvalue2 = value4;
      break;
    case T_RTINIFILE:
      pvalue1 = value5;
      pvalue2 = value6;
      break;
    case T_USB1INIFILE:
      pvalue1 = value7;
      pvalue1 = value8;
    }

  if (section == MOTORMOVE1)
    value = pvalue1;
  else
    value = pvalue2;

  if (value != NULL)
    {
      switch (option)
	{
	case SYSTEMCLOCK:
	  rst = value[0];
	  break;
	case CTPC:
	  rst = value[1];
	  break;
	case SCANMOTORSTEPTYPE:
	  rst = value[2];
	  break;
	case MOTORCURVE:
	  rst = value[3];
	  break;
	}
    }

  return rst;
}

static int
srt_sec14_get (int file, int section, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 0, 4, 0, 24499, 1, 0, 256 };
  int value2[] = { 0, 5, 0, 14667, 2, 0, 256 };
  int value3[] = { 0, 4, 0, 5499, 3, 3, 256 };
  int value4[] = { 0, 4, 1, 2751, 4, 4, 768 };
  int value5[] = { 0, 4, 1, 2255, 5, 5, 1856 };
  int value6[] = { 0, 4, 1, 2255, 5, 5, 1856, 2 };
  /* s_usb1inifile */
  int value7[] = { 0, 2, 0, 21499, 1, 0, 256 };
  int value8[] = { 0, 3, 0, 14667, 2, 0, 256 };
  int value9[] = { 0, 4, 0, 21999, 3, 0, 256 };
  int value10[] = { 0, 4, 1, 10727, 4, 4, 768 };
  int value11[] = { 0, 4, 1, 5591, 5, 5, 1024 };
  int value12[] = { 0, 4, 1, 2255, 5, 5, 1856, 2 };
  /* t_rtinifile */
  int value13[] = { 0, 4, 0, 24499, 1, 0, 256 };
  int value14[] = { 0, 5, 0, 14667, 2, 0, 256 };
  int value15[] = { 0, 4, 0, 5499, 3, 3, 256 };
  int value16[] = { 0, 4, 1, 2751, 4, 4, 768 };
  int value17[] = { 0, 4, 1, 2255, 5, 5, 1856 };
  int value18[] = { 0, 4, 1, 2255, 5, 5, 1856, 2 };
  /* t_usb1inifile */
  int value19[] = { 0, 3, 0, 21499, 1, 0, 256 };
  int value20[] = { 0, 4, 0, 14667, 2, 0, 256 };
  int value21[] = { 0, 4, 0, 21999, 3, 0, 256 };
  int value22[] = { 0, 4, 1, 10727, 4, 4, 768 };
  int value23[] = { 0, 4, 1, 5591, 5, 5, 1024 };
  int value24[] = { 0, 4, 1, 2255, 5, 5, 1856, 2 };

  int *value = NULL;
  int *pvalue1 = NULL;
  int *pvalue2 = NULL;
  int *pvalue3 = NULL;
  int *pvalue4 = NULL;
  int *pvalue5 = NULL;
  int *pvalue6 = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      pvalue1 = value1;
      pvalue2 = value2;
      pvalue3 = value3;
      pvalue4 = value4;
      pvalue5 = value5;
      pvalue6 = value6;
      break;
    case S_USB1INIFILE:
      pvalue1 = value7;
      pvalue2 = value8;
      pvalue3 = value9;
      pvalue4 = value10;
      pvalue5 = value11;
      pvalue6 = value12;
      break;
    case T_RTINIFILE:
      pvalue1 = value13;
      pvalue2 = value14;
      pvalue3 = value15;
      pvalue4 = value16;
      pvalue5 = value17;
      pvalue6 = value18;
      break;
    case T_USB1INIFILE:
      pvalue1 = value19;
      pvalue2 = value20;
      pvalue3 = value21;
      pvalue4 = value22;
      pvalue5 = value23;
      pvalue6 = value24;
      break;
    }

  switch (section)
    {
    case SCANCOLORMODE1:
      value = pvalue1;
      break;
    case SCANCOLORMODE2:
      value = pvalue2;
      break;
    case SCANCOLORMODE3:
      value = pvalue3;
      break;
    case SCANCOLORMODE4:
      value = pvalue4;
      break;
    case SCANCOLORMODE5:
      value = pvalue5;
      break;
    case SCANCOLORMODE6:
      value = pvalue6;
      break;
    }

  if (value != NULL)
    {
      switch (option)
	{
	case SAMPLERATE:
	  rst = value[0];
	  break;
	case SYSTEMCLOCK:
	  rst = value[1];
	  break;
	case SCANMOTORSTEPTYPE:
	  rst = value[2];
	  break;
	case CTPC:
	  rst = value[3];
	  break;
	case TIMING:
	  rst = value[4];
	  break;
	case MOTORCURVE:
	  rst = value[5];
	  break;
	case MOTORBACKSTEP:
	  rst = value[6];
	  break;
	case DUMMYLINE:
	  if (section == SCANCOLORMODE6)
	    rst = value[7];
	  break;
	}
    }

  return rst;
}

static int
srt_sec15_get (int file, int section, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 1, 4, 0, 24499, 6, 0, 256 };
  int value2[] = { 1, 5, 0, 14667, 7, 0, 256 };
  int value3[] = { 1, 4, 0, 5499, 8, 3, 256 };
  int value4[] = { 1, 4, 1, 2751, 9, 4, 768 };
  int value5[] = { 1, 4, 1, 2255, 10, 5, 1856 };
  int value6[] = { 1, 4, 1, 2255, 10, 5, 1856, 2 };
  /* s_usb1inifile */
  int value7[] = { 1, 4, 0, 21499, 6, 0, 256 };
  int value8[] = { 1, 5, 0, 14667, 7, 0, 256 };
  int value9[] = { 1, 4, 0, 6999, 8, 3, 256 };
  int value10[] = { 1, 4, 1, 4671, 9, 4, 768 };
  int value11[] = { 1, 4, 1, 2255, 10, 5, 1856 };
  int value12[] = { 1, 4, 1, 2255, 10, 5, 1856, 2 };
  /* t_rtinifile */
  int value13[] = { 1, 4, 0, 24499, 6, 0, 256 };
  int value14[] = { 1, 5, 0, 14667, 7, 0, 256 };
  int value15[] = { 1, 4, 0, 5499, 8, 3, 256 };
  int value16[] = { 1, 4, 1, 2751, 9, 4, 768 };
  int value17[] = { 1, 4, 1, 2255, 10, 5, 1856 };
  int value18[] = { 1, 4, 1, 2255, 10, 5, 1856, 2 };
  /* t_usb1inifile */
  int value19[] = { 1, 2, 0, 21499, 6, 0, 256 };
  int value20[] = { 1, 4, 0, 14667, 7, 0, 256 };
  int value21[] = { 1, 4, 0, 6999, 8, 3, 256 };
  int value22[] = { 1, 4, 1, 4671, 9, 4, 768 };
  int value23[] = { 1, 4, 1, 2255, 10, 5, 1856 };
  int value24[] = { 1, 4, 1, 2255, 10, 5, 1856, 2 };
  int *value = NULL;
  int *pvalue1 = NULL;
  int *pvalue2 = NULL;
  int *pvalue3 = NULL;
  int *pvalue4 = NULL;
  int *pvalue5 = NULL;
  int *pvalue6 = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      pvalue1 = value1;
      pvalue2 = value2;
      pvalue3 = value3;
      pvalue4 = value4;
      pvalue5 = value5;
      pvalue6 = value6;
      break;
    case S_USB1INIFILE:
      pvalue1 = value7;
      pvalue2 = value8;
      pvalue3 = value9;
      pvalue4 = value10;
      pvalue5 = value11;
      pvalue6 = value12;
      break;
    case T_RTINIFILE:
      pvalue1 = value13;
      pvalue2 = value14;
      pvalue3 = value15;
      pvalue4 = value16;
      pvalue5 = value17;
      pvalue6 = value18;
      break;
    case T_USB1INIFILE:
      pvalue1 = value19;
      pvalue2 = value20;
      pvalue3 = value21;
      pvalue4 = value22;
      pvalue5 = value23;
      pvalue6 = value24;
      break;
    }

  switch (section)
    {
    case SCANGRAYMODE1:
      value = pvalue1;
      break;
    case SCANGRAYMODE2:
      value = pvalue2;
      break;
    case SCANGRAYMODE3:
      value = pvalue3;
      break;
    case SCANGRAYMODE4:
      value = pvalue4;
      break;
    case SCANGRAYMODE5:
      value = pvalue5;
      break;
    case SCANGRAYMODE6:
      value = pvalue6;
      break;
    }

  if (value != NULL)
    {
      switch (option)
	{
	case SAMPLERATE:
	  rst = value[0];
	  break;
	case SYSTEMCLOCK:
	  rst = value[1];
	  break;
	case SCANMOTORSTEPTYPE:
	  rst = value[2];
	  break;
	case CTPC:
	  rst = value[3];
	  break;
	case TIMING:
	  rst = value[4];
	  break;
	case MOTORCURVE:
	  rst = value[5];
	  break;
	case MOTORBACKSTEP:
	  rst = value[6];
	  break;
	case DUMMYLINE:
	  if (section == SCANGRAYMODE6)
	    rst = value[7];
	  break;
	}
    }

  return rst;
}

static int
srt_sec17_get (int file, int section, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 1, 4, 0, 25599, 6, 0, 256 };
  int value2[] = { 1, 3, 0, 10899, 7, 0, 256 };
  int value3[] = { 1, 1, 0, 5487, 8, 0, 256 };
  int value4[] = { 1, 4, 1, 8351, 9, 4, 512 };
  int value5[] = { 1, 4, 1, 7343, 10, 5, 1024 };
  int value6[] = { 1, 4, 1, 7343, 10, 5, 1024 };
  /* s_usb1inifile */
  int value7[] = { 1, 4, 0, 25599, 6, 0, 256 };
  int value8[] = { 1, 3, 0, 10899, 7, 0, 256 };
  int value9[] = { 1, 1, 0, 5487, 8, 0, 256 };
  int value10[] = { 1, 4, 1, 8351, 9, 4, 512 };
  int value11[] = { 1, 4, 1, 7343, 10, 5, 1024 };
  int value12[] = { 1, 4, 1, 7343, 10, 5, 1024 };
  /* t_rtinifile */
  int value13[] = { 1, 4, 0, 25599, 6, 0, 256 };
  int value14[] = { 1, 3, 0, 10899, 7, 0, 256 };
  int value15[] = { 1, 1, 0, 5487, 8, 0, 256 };
  int value16[] = { 1, 4, 1, 8351, 9, 4, 512 };
  int value17[] = { 1, 4, 1, 7343, 10, 5, 1024 };
  int value18[] = { 1, 4, 1, 7343, 10, 5, 1024 };
  /* t_usb1inifile */
  int value19[] = { 1, 4, 0, 25599, 6, 0, 256 };
  int value20[] = { 1, 3, 0, 10899, 7, 0, 256 };
  int value21[] = { 1, 1, 0, 5487, 8, 0, 256 };
  int value22[] = { 1, 4, 1, 8351, 9, 4, 512 };
  int value23[] = { 1, 4, 1, 7343, 10, 5, 1024 };
  int value24[] = { 1, 4, 1, 7343, 10, 5, 1024 };
  int *value = NULL;
  int *pvalue1 = NULL;
  int *pvalue2 = NULL;
  int *pvalue3 = NULL;
  int *pvalue4 = NULL;
  int *pvalue5 = NULL;
  int *pvalue6 = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      pvalue1 = value1;
      pvalue2 = value2;
      pvalue3 = value3;
      pvalue4 = value4;
      pvalue5 = value5;
      pvalue6 = value6;
      break;
    case S_USB1INIFILE:
      pvalue1 = value7;
      pvalue2 = value8;
      pvalue3 = value9;
      pvalue4 = value10;
      pvalue5 = value11;
      pvalue6 = value12;
      break;
    case T_RTINIFILE:
      pvalue1 = value13;
      pvalue2 = value14;
      pvalue3 = value15;
      pvalue4 = value16;
      pvalue5 = value17;
      pvalue6 = value18;
      break;
    case T_USB1INIFILE:
      pvalue1 = value19;
      pvalue2 = value20;
      pvalue3 = value21;
      pvalue4 = value22;
      pvalue5 = value23;
      pvalue6 = value24;
      break;
    }

  switch (section)
    {
    case SCANTAGRAYMODE1:
      value = pvalue1;
      break;
    case SCANTAGRAYMODE2:
      value = pvalue2;
      break;
    case SCANTAGRAYMODE3:
      value = pvalue3;
      break;
    case SCANTAGRAYMODE4:
      value = pvalue4;
      break;
    case SCANTAGRAYMODE5:
      value = pvalue5;
      break;
    case SCANTAGRAYMODE6:
      value = pvalue6;
      break;
    }

  if (value != NULL)
    {
      switch (option)
	{
	case SAMPLERATE:
	  rst = value[0];
	  break;
	case SYSTEMCLOCK:
	  rst = value[1];
	  break;
	case SCANMOTORSTEPTYPE:
	  rst = value[2];
	  break;
	case CTPC:
	  rst = value[3];
	  break;
	case TIMING:
	  rst = value[4];
	  break;
	case MOTORCURVE:
	  rst = value[5];
	  break;
	case MOTORBACKSTEP:
	  rst = value[6];
	  break;
	}
    }

  return rst;
}

static int
srt_sec16_get (int file, int section, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] = { 0, 4, 0, 25599, 1, 0, 256 };
  int value2[] = { 0, 3, 0, 10899, 2, 0, 256 };
  int value3[] = { 0, 1, 0, 5487, 3, 0, 256 };
  int value4[] = { 0, 4, 1, 8351, 4, 4, 512 };
  int value5[] = { 0, 4, 1, 7343, 5, 5, 1024 };
  int value6[] = { 0, 4, 1, 7343, 5, 5, 1024 };
  /* s_usb1inifile */
  int value7[] = { 0, 4, 0, 25599, 1, 0, 256 };
  int value8[] = { 0, 3, 0, 10899, 2, 0, 256 };
  int value9[] = { 0, 1, 0, 5487, 3, 0, 256 };
  int value10[] = { 0, 4, 1, 8351, 4, 4, 512 };
  int value11[] = { 0, 4, 1, 7343, 5, 5, 1024 };
  int value12[] = { 0, 4, 1, 7343, 5, 5, 1024 };
  /* s_rtinifile */
  int value13[] = { 0, 4, 0, 25599, 1, 0, 256 };
  int value14[] = { 0, 3, 0, 10899, 2, 0, 256 };
  int value15[] = { 0, 1, 0, 5487, 3, 0, 256 };
  int value16[] = { 0, 4, 1, 8351, 4, 4, 512 };
  int value17[] = { 0, 4, 1, 7343, 5, 5, 1024 };
  int value18[] = { 0, 4, 1, 7343, 5, 5, 1024 };
  /* t_usb1inifile */
  int value19[] = { 0, 4, 0, 25599, 1, 0, 256 };
  int value20[] = { 0, 3, 0, 10899, 2, 0, 256 };
  int value21[] = { 0, 1, 0, 5487, 3, 0, 256 };
  int value22[] = { 0, 4, 1, 8351, 4, 4, 512 };
  int value23[] = { 0, 4, 1, 7343, 5, 5, 1024 };
  int value24[] = { 0, 4, 1, 7343, 5, 5, 1024 };

  int *value = NULL;
  int *pvalue1 = NULL;
  int *pvalue2 = NULL;
  int *pvalue3 = NULL;
  int *pvalue4 = NULL;
  int *pvalue5 = NULL;
  int *pvalue6 = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      pvalue1 = value1;
      pvalue2 = value2;
      pvalue3 = value3;
      pvalue4 = value4;
      pvalue5 = value5;
      pvalue6 = value6;
      break;
    case S_USB1INIFILE:
      pvalue1 = value7;
      pvalue2 = value8;
      pvalue3 = value9;
      pvalue4 = value10;
      pvalue5 = value11;
      pvalue6 = value12;
      break;
    case T_RTINIFILE:
      pvalue1 = value13;
      pvalue2 = value14;
      pvalue3 = value15;
      pvalue4 = value16;
      pvalue5 = value17;
      pvalue6 = value18;
      break;
    case T_USB1INIFILE:
      pvalue1 = value19;
      pvalue2 = value20;
      pvalue3 = value21;
      pvalue4 = value22;
      pvalue5 = value23;
      pvalue6 = value24;
      break;
    }

  switch (section)
    {
    case SCANTACOLORMODE1:
      value = pvalue1;
      break;
    case SCANTACOLORMODE2:
      value = pvalue2;
      break;
    case SCANTACOLORMODE3:
      value = pvalue3;
      break;
    case SCANTACOLORMODE4:
      value = pvalue4;
      break;
    case SCANTACOLORMODE5:
      value = pvalue5;
      break;
    case SCANTACOLORMODE6:
      value = pvalue6;
      break;
    }

  if (value != NULL)
    {
      switch (option)
	{
	case SAMPLERATE:
	  rst = value[0];
	  break;
	case SYSTEMCLOCK:
	  rst = value[1];
	  break;
	case SCANMOTORSTEPTYPE:
	  rst = value[2];
	  break;
	case CTPC:
	  rst = value[3];
	  break;
	case TIMING:
	  rst = value[4];
	  break;
	case MOTORCURVE:
	  rst = value[5];
	  break;
	case MOTORBACKSTEP:
	  rst = value[6];
	  break;
	}
    }

  return rst;
}

static int
srt_sec18_get (int file, int section, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] =
    { 0, 2, 0, 76799, 1, 0, 256, 25599, 25599, 25599, 51199, 76799, 0 };
  int value2[] =
    { 0, 3, 0, 36467, 2, 0, 256, 12155, 12155, 12155, 24311, 36467, 0 };
  int value3[] =
    { 0, 2, 0, 16463, 3, 0, 256, 5487, 5487, 5487, 10975, 16463, 0 };
  int value4[] =
    { 0, 2, 1, 8351, 4, 0, 256, 2783, 2783, 2783, 5567, 8351, 0 };
  int value5[] =
    { 0, 2, 1, 6191, 5, 0, 256, 2063, 2063, 2063, 4127, 6191, 0 };
  int value6[] =
    { 0, 2, 1, 6191, 5, 0, 256, 2063, 2063, 2063, 4127, 6191, 0, 2 };
  /* s_usb1inifile */
  int value7[] =
    { 0, 2, 0, 76799, 1, 0, 256, 25599, 25599, 25599, 51199, 76799, 0 };
  int value8[] =
    { 0, 3, 0, 36467, 2, 0, 256, 12155, 12155, 12155, 24311, 36467, 0 };
  int value9[] =
    { 0, 2, 0, 16463, 3, 0, 256, 5487, 5487, 5487, 10975, 16463, 0 };
  int value10[] =
    { 0, 2, 1, 8351, 4, 0, 256, 2783, 2783, 2783, 5567, 8351, 0 };
  int value11[] =
    { 0, 2, 1, 6191, 5, 0, 256, 2063, 2063, 2063, 4127, 6191, 0 };
  int value12[] =
    { 0, 2, 1, 6191, 5, 0, 256, 2063, 2063, 2063, 4127, 6191, 0, 2 };
  /* t_rtinifile */
  int value13[] =
    { 0, 2, 0, 76799, 1, 0, 256, 25599, 25599, 25599, 51199, 76799, 0 };
  int value14[] =
    { 0, 3, 0, 36467, 2, 0, 256, 12155, 12155, 12155, 24311, 36467, 0 };
  int value15[] =
    { 0, 2, 0, 16463, 3, 0, 256, 5487, 5487, 5487, 10975, 16463, 0 };
  int value16[] =
    { 0, 2, 1, 8351, 4, 0, 256, 2783, 2783, 2783, 5567, 8351, 0 };
  int value17[] =
    { 0, 2, 1, 6191, 5, 0, 256, 2063, 2063, 2063, 4127, 6191, 0 };
  int value18[] =
    { 0, 2, 1, 6191, 5, 0, 256, 2063, 2063, 2063, 4127, 6191, 0, 2 };
  /* t_usb1inifile */
  int value19[] =
    { 0, 2, 0, 76799, 1, 0, 256, 25599, 25599, 25599, 51199, 76799, 0 };
  int value20[] =
    { 0, 3, 0, 36467, 2, 0, 256, 12155, 12155, 12155, 24311, 36467, 0 };
  int value21[] =
    { 0, 2, 0, 16463, 3, 0, 256, 5487, 5487, 5487, 10975, 16463, 0 };
  int value22[] =
    { 0, 2, 1, 8351, 4, 0, 256, 2783, 2783, 2783, 5567, 8351, 0 };
  int value23[] =
    { 0, 2, 1, 6191, 5, 0, 256, 2063, 2063, 2063, 4127, 6191, 0 };
  int value24[] =
    { 0, 2, 1, 6191, 5, 0, 256, 2063, 2063, 2063, 4127, 6191, 0, 2 };
  int *value = NULL;
  int *pvalue1 = NULL;
  int *pvalue2 = NULL;
  int *pvalue3 = NULL;
  int *pvalue4 = NULL;
  int *pvalue5 = NULL;
  int *pvalue6 = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      pvalue1 = value1;
      pvalue2 = value2;
      pvalue3 = value3;
      pvalue4 = value4;
      pvalue5 = value5;
      pvalue6 = value6;
      break;
    case S_USB1INIFILE:
      pvalue1 = value7;
      pvalue2 = value8;
      pvalue3 = value9;
      pvalue4 = value10;
      pvalue5 = value11;
      pvalue6 = value12;
      break;
    case T_RTINIFILE:
      pvalue1 = value13;
      pvalue2 = value14;
      pvalue3 = value15;
      pvalue4 = value16;
      pvalue5 = value17;
      pvalue6 = value18;
      break;
    case T_USB1INIFILE:
      pvalue1 = value19;
      pvalue2 = value20;
      pvalue3 = value21;
      pvalue4 = value22;
      pvalue5 = value23;
      pvalue6 = value24;
      break;
    }

  switch (section)
    {
    case SCANNEGCOLORMODE1:
      value = pvalue1;
      break;
    case SCANNEGCOLORMODE2:
      value = pvalue2;
      break;
    case SCANNEGCOLORMODE3:
      value = pvalue3;
      break;
    case SCANNEGCOLORMODE4:
      value = pvalue4;
      break;
    case SCANNEGCOLORMODE5:
      value = pvalue5;
      break;
    case SCANNEGCOLORMODE6:
      value = pvalue6;
      break;
    }

  if (value != NULL)
    {
      switch (option)
	{
	case SAMPLERATE:
	  rst = value[0];
	  break;
	case SYSTEMCLOCK:
	  rst = value[1];
	  break;
	case SCANMOTORSTEPTYPE:
	  rst = value[2];
	  break;
	case CTPC:
	  rst = value[3];
	  break;
	case TIMING:
	  rst = value[4];
	  break;
	case MOTORCURVE:
	  rst = value[5];
	  break;
	case MOTORBACKSTEP:
	  rst = value[6];
	  break;
	case MEXPT1:
	  rst = value[7];
	  break;
	case EXPT1:
	  rst = value[8];
	  break;
	case MEXPT2:
	  rst = value[9];
	  break;
	case EXPT2:
	  rst = value[10];
	  break;
	case MEXPT3:
	  rst = value[11];
	  break;
	case EXPT3:
	  rst = value[12];
	  break;
	case DUMMYLINE:
	  if (section == SCANNEGCOLORMODE6)
	    rst = value[13];
	  break;
	}
    }

  return rst;
}

static int
srt_sec19_get (int file, int section, int option, int defvalue)
{
  int rst = defvalue;
  /* s_rtinifile */
  int value1[] =
    { 1, 2, 0, 76799, 6, 0, 256, 25599, 25599, 25599, 51199, 76799, 0 };
  int value2[] =
    { 1, 3, 0, 36467, 7, 0, 256, 12155, 12155, 12155, 24311, 36467, 0 };
  int value3[] =
    { 1, 2, 0, 16463, 8, 0, 256, 5487, 5487, 5487, 10975, 16463, 0 };
  int value4[] =
    { 1, 2, 1, 8351, 9, 0, 256, 2783, 2783, 2783, 5567, 8351, 0 };
  int value5[] =
    { 1, 2, 1, 6191, 10, 0, 256, 2063, 2063, 2063, 4127, 6191, 0 };
  int value6[] =
    { 1, 2, 1, 6191, 10, 0, 256, 2063, 2063, 2063, 4127, 6191, 0, 2 };
  /* s_usb1inifile */
  int value7[] =
    { 1, 2, 0, 76799, 6, 0, 256, 25599, 25599, 25599, 51199, 76799, 0 };
  int value8[] =
    { 1, 3, 0, 36467, 7, 0, 256, 12155, 12155, 12155, 24311, 36467, 0 };
  int value9[] =
    { 1, 2, 0, 16463, 8, 0, 256, 5487, 5487, 5487, 10975, 16463, 0 };
  int value10[] =
    { 1, 2, 1, 8351, 9, 0, 256, 2783, 2783, 2783, 5567, 8351, 0 };
  int value11[] =
    { 1, 2, 1, 6191, 10, 0, 256, 2063, 2063, 2063, 4127, 6191, 0 };
  int value12[] =
    { 1, 2, 1, 6191, 10, 0, 256, 2063, 2063, 2063, 4127, 6191, 0, 2 };
  /* t_rtinifile */
  int value13[] =
    { 1, 2, 0, 76799, 6, 0, 256, 25599, 25599, 25599, 51199, 76799, 0 };
  int value14[] =
    { 1, 3, 0, 36467, 7, 0, 256, 12155, 12155, 12155, 24311, 36467, 0 };
  int value15[] =
    { 1, 2, 0, 16463, 8, 0, 256, 5487, 5487, 5487, 10975, 16463, 0 };
  int value16[] =
    { 1, 2, 1, 8351, 9, 0, 256, 2783, 2783, 2783, 5567, 8351, 0 };
  int value17[] =
    { 1, 2, 1, 6191, 10, 0, 256, 2063, 2063, 2063, 4127, 6191, 0 };
  int value18[] =
    { 1, 2, 1, 6191, 10, 0, 256, 2063, 2063, 2063, 4127, 6191, 0, 2 };
  /* t_usb1inifile */
  int value19[] =
    { 1, 2, 0, 76799, 6, 0, 256, 25599, 25599, 25599, 51199, 76799, 0 };
  int value20[] =
    { 1, 3, 0, 36467, 7, 0, 256, 12155, 12155, 12155, 24311, 36467, 0 };
  int value21[] =
    { 1, 2, 0, 16463, 8, 0, 256, 5487, 5487, 5487, 10975, 16463, 0 };
  int value22[] =
    { 1, 2, 1, 8351, 9, 0, 256, 2783, 2783, 2783, 5567, 8351, 0 };
  int value23[] =
    { 1, 2, 1, 6191, 10, 0, 256, 2063, 2063, 2063, 4127, 6191, 0 };
  int value24[] =
    { 1, 2, 1, 6191, 10, 0, 256, 2063, 2063, 2063, 4127, 6191, 0, 2 };
  int *value = NULL;
  int *pvalue1 = NULL;
  int *pvalue2 = NULL;
  int *pvalue3 = NULL;
  int *pvalue4 = NULL;
  int *pvalue5 = NULL;
  int *pvalue6 = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      pvalue1 = value1;
      pvalue2 = value2;
      pvalue3 = value3;
      pvalue4 = value4;
      pvalue5 = value5;
      pvalue6 = value6;
      break;
    case S_USB1INIFILE:
      pvalue1 = value7;
      pvalue2 = value8;
      pvalue3 = value9;
      pvalue4 = value10;
      pvalue5 = value11;
      pvalue6 = value12;
      break;
    case T_RTINIFILE:
      pvalue1 = value13;
      pvalue2 = value14;
      pvalue3 = value15;
      pvalue4 = value16;
      pvalue5 = value17;
      pvalue6 = value18;
      break;
    case T_USB1INIFILE:
      pvalue1 = value19;
      pvalue2 = value20;
      pvalue3 = value21;
      pvalue4 = value22;
      pvalue5 = value23;
      pvalue6 = value24;
      break;
    }

  switch (section)
    {
    case SCANNEGGRAYMODE1:
      value = pvalue1;
      break;
    case SCANNEGGRAYMODE2:
      value = pvalue2;
      break;
    case SCANNEGGRAYMODE3:
      value = pvalue3;
      break;
    case SCANNEGGRAYMODE4:
      value = pvalue4;
      break;
    case SCANNEGGRAYMODE5:
      value = pvalue5;
      break;
    case SCANNEGGRAYMODE6:
      value = pvalue6;
      break;
    }

  if (value != NULL)
    {
      switch (option)
	{
	case SAMPLERATE:
	  rst = value[0];
	  break;
	case SYSTEMCLOCK:
	  rst = value[1];
	  break;
	case SCANMOTORSTEPTYPE:
	  rst = value[2];
	  break;
	case CTPC:
	  rst = value[3];
	  break;
	case TIMING:
	  rst = value[4];
	  break;
	case MOTORCURVE:
	  rst = value[5];
	  break;
	case MOTORBACKSTEP:
	  rst = value[6];
	  break;
	case MEXPT1:
	  rst = value[7];
	  break;
	case EXPT1:
	  rst = value[8];
	  break;
	case MEXPT2:
	  rst = value[9];
	  break;
	case EXPT2:
	  rst = value[10];
	  break;
	case MEXPT3:
	  rst = value[11];
	  break;
	case EXPT3:
	  rst = value[12];
	  break;
	case DUMMYLINE:
	  if (section == SCANNEGGRAYMODE6)
	    rst = value[13];
	  break;
	}
    }

  return rst;
}

static int
srt_sec20_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  int value1[] = { 0, 0, 0, 0 };
  int value2[] = { 0, 0, 0, 0 };
  int value3[] = { 0, 0, 0, 0 };
  int value4[] = { 0, 0, 0, 0 };
  int *value = NULL;

  switch (file)
    {
    case S_RTINIFILE:
      value = value1;
      break;
    case S_USB1INIFILE:
      value = value2;
      break;
    case T_RTINIFILE:
      value = value3;
      break;
    case T_USB1INIFILE:
      value = value4;
      break;
    }

  if (value != NULL)
    {
      switch (option)
	{
	case SHADINGTIME_16BIT:
	  rst = value[0];
	  break;
	case SHADOWTIME_16BIT:
	  rst = value[1];
	  break;
	case SHADINGTIME_8BIT:
	  rst = value[2];
	  break;
	case SHADOWTIME_8BIT:
	  rst = value[3];
	  break;
	}
    }

  return rst;
}

static int
srt_sec_get (int file, int section, int option, int defvalue)
{
  int rst = defvalue;

  switch (section)
    {
    case SCAN_PARAM:
      rst = srt_sec1_get (file, option, defvalue);
      break;
    case USB1_PWM:
      rst = srt_sec2_get (file, option, defvalue);
      break;
    case USB2_PWM:
      rst = srt_sec3_get (file, option, defvalue);
      break;
    case WAVETEST:
      rst = srt_sec4_get (file, option, defvalue);
      break;
    case DMA_PARAM:
      rst = srt_sec5_get (file, option, defvalue);
      break;
    case SCAN_CALI:
      rst = srt_sec6_get (file, option, defvalue);
      break;
    case TRUE_GRAY_PARAM:
      rst = srt_sec7_get (file, option, defvalue);
      break;
    case CALI_PARAM:
      rst = srt_sec8_get (file, option, defvalue);
      break;
    case FLB_FIND_EDGE:
      rst = srt_sec9_get (file, option, defvalue);
      break;
    case DUMMYLINE:
      rst = srt_sec10_get (file, option, defvalue);
      break;
    case MOVEMOTORSETTING:
      rst = srt_sec11_get (file, option, defvalue);
      break;
    case PLATFORM:
      rst = srt_sec12_get (file, option, defvalue);
      break;
    case MOTORMOVE1:
    case MOTORMOVE2:
      rst = srt_sec13_get (file, section, option, defvalue);
      break;
    case SCANCOLORMODE1:
    case SCANCOLORMODE2:
    case SCANCOLORMODE3:
    case SCANCOLORMODE4:
    case SCANCOLORMODE5:
    case SCANCOLORMODE6:
      rst = srt_sec14_get (file, section, option, defvalue);
      break;
    case SCANGRAYMODE1:
    case SCANGRAYMODE2:
    case SCANGRAYMODE3:
    case SCANGRAYMODE4:
    case SCANGRAYMODE5:
    case SCANGRAYMODE6:
      rst = srt_sec15_get (file, section, option, defvalue);
      break;
    case SCANTACOLORMODE1:
    case SCANTACOLORMODE2:
    case SCANTACOLORMODE3:
    case SCANTACOLORMODE4:
    case SCANTACOLORMODE5:
    case SCANTACOLORMODE6:
      rst = srt_sec16_get (file, section, option, defvalue);
      break;
    case SCANTAGRAYMODE1:
    case SCANTAGRAYMODE2:
    case SCANTAGRAYMODE3:
    case SCANTAGRAYMODE4:
    case SCANTAGRAYMODE5:
    case SCANTAGRAYMODE6:
      rst = srt_sec17_get (file, section, option, defvalue);
      break;
    case SCANNEGCOLORMODE1:
    case SCANNEGCOLORMODE2:
    case SCANNEGCOLORMODE3:
    case SCANNEGCOLORMODE4:
    case SCANNEGCOLORMODE5:
    case SCANNEGCOLORMODE6:
      rst = srt_sec18_get (file, section, option, defvalue);
      break;
    case SCANNEGGRAYMODE1:
    case SCANNEGGRAYMODE2:
    case SCANNEGGRAYMODE3:
    case SCANNEGGRAYMODE4:
    case SCANNEGGRAYMODE5:
    case SCANNEGGRAYMODE6:
      rst = srt_sec19_get (file, section, option, defvalue);
      break;
    case SCANINFO:
      rst = srt_sec20_get (file, option, defvalue);
      break;
    }

  return rst;
}

static int
ttf_sec1_get (int file, int option, int defvalue)
{
  int rst = defvalue;
  int *pvalue = NULL;
  int value1[] =
    { 2400, 11, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0x24000, 4, 6, 9, 11, 0
  };
  int value2[] =
    { 1200, 26, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0x11000, 8, 12, 21, 24, 1
  };
  int value3[] =
    { 600, 23, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 9, 12, 18, 20, 0
  };
  int value4[] =
    { 300, 23, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 4, 6, 21, 23, 0
  };
  int value5[] =
    { 200, 29, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 10, 12, 27, 29, 0
  };
  int value6[] =
    { 2400, 11, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0x24000, 4, 6, 9, 11, 0
  };
  int value7[] =
    { 1200, 26, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0x11000, 8, 12, 21, 24, 1
  };
  int value8[] =
    { 600, 23, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 9, 12, 18, 20, 0
  };
  int value9[] =
    { 300, 23, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 4, 6, 21, 23, 0
  };
  int value10[] =
    { 200, 29, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 10, 12, 27, 28, 0
  };
  int value11[] =
    { 100, 35, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x11000, 2, 3, 34, 35, 0
  };
  int value12[] =
    { 100, 35, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x11000, 2, 3, 34, 35, 0
  };
  int value13[] =
    { 2400, 11, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1,
    1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x24000, 5, 7, 9, 11, 0
  };
  int value14[] =
    { 1200, 26, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0,
    1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x11000, 11, 14, 23, 25, 1
  };
  int value15[] =
    { 600, 23, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 9, 11, 21, 23, 0
  };
  int value16[] =
    { 300, 23, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 4, 6, 21, 23, 0
  };
  int value17[] =
    { 200, 29, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 10, 12, 26, 28, 0
  };
  int value18[] =
    { 2400, 11, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x24000, 5, 7, 9, 11, 0
  };
  int value19[] =
    { 1200, 26, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x11000, 11, 13, 23, 25, 1
  };
  int value20[] =
    { 600, 23, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 9, 11, 21, 23, 0
  };
  int value21[] =
    { 300, 23, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 4, 6, 21, 23, 0
  };
  int value22[] =
    { 200, 29, 0, 0, 0, 15, 4, 4, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x5500, 10, 12, 26, 29, 0
  };
  int value23[] =
    { 100, 35, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x2700, 2, 3, 34, 35, 0
  };
  int value24[] =
    { 100, 35, 0, 0, 0, 30, 1, 15, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0x2700, 2, 3, 34, 35, 0
  };

  switch (file)
    {
    case T_TIMING1:
      pvalue = value1;
      break;
    case T_TIMING2:
      pvalue = value2;
      break;
    case T_TIMING3:
      pvalue = value3;
      break;
    case T_TIMING4:
      pvalue = value4;
      break;
    case T_TIMING5:
      pvalue = value5;
      break;
    case T_TIMING6:
      pvalue = value6;
      break;
    case T_TIMING7:
      pvalue = value7;
      break;
    case T_TIMING8:
      pvalue = value8;
      break;
    case T_TIMING9:
      pvalue = value9;
      break;
    case T_TIMING10:
      pvalue = value10;
      break;
    case T_TIMING11:
      pvalue = value11;
      break;
    case T_TIMING12:
      pvalue = value12;
      break;
    case S_TIMING1:
      pvalue = value13;
      break;
    case S_TIMING2:
      pvalue = value14;
      break;
    case S_TIMING3:
      pvalue = value15;
      break;
    case S_TIMING4:
      pvalue = value16;
      break;
    case S_TIMING5:
      pvalue = value17;
      break;
    case S_TIMING6:
      pvalue = value18;
      break;
    case S_TIMING7:
      pvalue = value19;
      break;
    case S_TIMING8:
      pvalue = value20;
      break;
    case S_TIMING9:
      pvalue = value21;
      break;
    case S_TIMING10:
      pvalue = value22;
      break;
    case S_TIMING11:
      pvalue = value23;
      break;
    case S_TIMING12:
      pvalue = value24;
      break;
    }

  if (pvalue != NULL)
    switch (option)
      {
      case SENSORRESOLUTION:
	rst = pvalue[0];
	break;
      case CNPP:
	rst = pvalue[1];
	break;
      case CVTRP1:
	rst = pvalue[2];
	break;
      case CVTRP2:
	rst = pvalue[3];
	break;
      case CVTRP3:
	rst = pvalue[4];
	break;
      case CVTRW:
	rst = pvalue[5];
	break;
      case CVTRFPW:
	rst = pvalue[6];
	break;
      case CVTRBPW:
	rst = pvalue[7];
	break;
      case CPH0PS:
	rst = pvalue[8];
	break;
      case CPH0GE:
	rst = pvalue[9];
	break;
      case CPH0GO:
	rst = pvalue[10];
	break;
      case CPH1PS:
	rst = pvalue[11];
	break;
      case CPH1GE:
	rst = pvalue[12];
	break;
      case CPH1GO:
	rst = pvalue[13];
	break;
      case CPH2PS:
	rst = pvalue[14];
	break;
      case CPH2GE:
	rst = pvalue[15];
	break;
      case CPH2GO:
	rst = pvalue[16];
	break;
      case CPH3PS:
	rst = pvalue[17];
	break;
      case CPH3GE:
	rst = pvalue[18];
	break;
      case CPH3GO:
	rst = pvalue[19];
	break;
      case CPH4PS:
	rst = pvalue[20];
	break;
      case CPH4GE:
	rst = pvalue[21];
	break;
      case CPH4GO:
	rst = pvalue[22];
	break;
      case CPH5PS:
	rst = pvalue[23];
	break;
      case CPH5GE:
	rst = pvalue[24];
	break;
      case CPH5GO:
	rst = pvalue[25];
	break;
      case CPHBP2S:
	rst = pvalue[26];
	break;
      case CPHBP2E:
	rst = pvalue[27];
	break;
      case CLAMPS:
	rst = pvalue[28];
	break;
      case CLAMPE:
	rst = pvalue[29];
	break;
      case CDSS1:
	rst = pvalue[30];
	break;
      case CDSC1:
	rst = pvalue[31];
	break;
      case CDSS2:
	rst = pvalue[32];
	break;
      case CDSC2:
	rst = pvalue[33];
	break;
      case ADCCLKP2E:
	rst = pvalue[34];
	break;
      }

  return rst;
}

static double
lttf_sec1_get (int file, int option, double defvalue)
{
  double rst = defvalue;
  double *pvalue = NULL;
  double value1[] = {
    27481079808.0, 0, 0, 0, 34376515584.0, 0, 8455716864.0, 0, 60246982656.,
      0,
    68719214592.0, 0, 68719214592.0, 0
  };
  double value2[] = {
    33351135232.0, 33351135232.0, 0, 0, 64424511232.0, 0, 68711088128.0, 0,
    8388352.0, 0, 68719476480.0, 0, 68719476480.0, 0
  };
  double value3[] = {
    64677150720.0, 0, 0, 0, 60129570816.0, 0, 68719472640.0, 0, 68719472640.0,
      0,
    16773120.0, 0, 68702699520.0, 0
  };
  double value4[] = {
    8084643840.0, 0, 0, 0, 51539611648.0, 0, 68719472640.0, 0, 68719472640.0,
      0,
    1057222656.0, 0, 67662249984.0, 0
  };
  double value5[] = {
    4164816768.0, 0, 0, 0, 68182605888.0, 0, 68719476720.0, 0, 68719476720.0,
      0,
    16659267072.0, 0, 52060209600.0, 0
  };
  double value6[] = {
    2113929216.0, 0, 0, 0, 34376515584.00, 0, 8455716864.0, 0, 60246982656.0,
      0,
    68719214592.0, 0, 68719214592.0, 0
  };
  double value7[] = {
    67104768.0, 67104768.0, 0, 0, 64424511232.0, 0, 68711088128.0, 0,
      8388352.0,
    0, 68719476480.0, 0, 68719476480.0, 0
  };
  double value8[] = {
    268369920.0, 0, 0, 0, 60129570816.0, 0, 68719472640.0, 0, 68719472640.0,
      0,
    16773120.0, 0, 68702699520.0, 0
  };
  double value9[] = {
    33546240.0, 0, 0, 0, 51539611648.0, 0, 68719472640.0, 0, 68719472640.0, 0,
    1057222656.0, 0, 67662249984.0, 0
  };
  double value10[] = {
    4194176.0, 0, 68585258944.0, 0, 536870784.0, 0, 16659267072.0, 0,
      52060209600.0,
    0, 0, 0, 0, 0
  };
  double value11[] = {
    2114445438.0, 0, 0, 0, 34359738368.0, 0, 68719476735.0, 0, 68719476735.0,
      0,
    7635497415.0, 0, 61083979320.0, 0
  };
  double value12[] = {
    524286.0, 0, 0, 0, 34359738368.0, 0, 68719476735.0, 0, 68719476735.0, 0,
    7635497415.0, 0, 61083979320.0, 0
  };
  double value13[] = {
    27481079808.0, 0, 60112764928.0, 0, 34326183936.0, 0, 1056964608.0, 0,
      67645734912.0,
    0, 1056964608.0, 0, 67645734912.0, 0
  };
  double value14[] = {
    16675567616.0, 16675567616.0, 68316823296.0, 0, 42949672704.0, 0,
      4194048.0, 0,
    68715282432.0, 0, 4194048.0, 0, 68715282432.0, 0
  };
  double value15[] = {
    8084643840.0, 0, 67914166272.0, 0, 42949668864.0, 0, 16773120.0, 0,
      68702699520.0,
    0, 0, 0, 0, 0
  };
  double value16[] = {
    8084643840.0, 0, 60129538048.0, 0, 34359730176.0, 0, 1057222656.0, 0,
      67662249984.0,
    0, 0, 0, 0, 0
  };
  double value17[] = {
    8329633536.0, 0, 68585258944.0, 0, 536870784.0, 0, 16659267072.0, 0,
      52060209600.0,
    0, 0, 0, 0, 0
  };
  double value18[] = {
    2113929216.0, 0, 60112764928.0, 0, 34326183936.0, 0, 1056964608.0, 0,
      67645734912.0,
    0, 1056964608.0, 0, 67645734912.0, 0
  };
  double value19[] = {
    33552384.0, 33552384.0, 68316823296.0, 0, 42949672704.0, 0, 4194048.0, 0,
    68715282432.0, 0, 4194048.0, 0, 68715282432.0, 0
  };
  double value20[] = {
    33546240.0, 0, 67914166272.0, 0, 42949668864.0, 0, 16773120.0, 0,
      68702699520.0,
    0, 0, 0, 0, 0
  };
  double value21[] = {
    33546240.0, 0, 60129538048.0, 0, 34359730176.0, 0, 1057222656.0, 0,
      67662249984.0,
    0, 0, 0, 0, 0
  };
  double value22[] = {
    4194176.0, 0, 0, 0, 68182605888.0, 0, 68719476720.0, 0, 68719476720.0, 0,
    16659267072.0, 0, 52060209600.0, 0
  };
  double value23[] = {
    2114445438.0, 0, 51539607551.0, 0, 34359738366.0, 0, 7635497415.0, 0,
      61083979320.0,
    0, 0, 0, 0, 0
  };
  double value24[] = {
    524286.0, 0, 51539607551.0, 0, 34359738366.0, 0, 7635497415.0, 0,
      61083979320.0,
    0, 0, 0, 0, 0
  };

  switch (file)
    {
    case T_TIMING1:
      pvalue = value1;
      break;
    case T_TIMING2:
      pvalue = value2;
      break;
    case T_TIMING3:
      pvalue = value3;
      break;
    case T_TIMING4:
      pvalue = value4;
      break;
    case T_TIMING5:
      pvalue = value5;
      break;
    case T_TIMING6:
      pvalue = value6;
      break;
    case T_TIMING7:
      pvalue = value7;
      break;
    case T_TIMING8:
      pvalue = value8;
      break;
    case T_TIMING9:
      pvalue = value9;
      break;
    case T_TIMING10:
      pvalue = value10;
      break;
    case T_TIMING11:
      pvalue = value11;
      break;
    case T_TIMING12:
      pvalue = value12;
      break;
    case S_TIMING1:
      pvalue = value13;
      break;
    case S_TIMING2:
      pvalue = value14;
      break;
    case S_TIMING3:
      pvalue = value15;
      break;
    case S_TIMING4:
      pvalue = value16;
      break;
    case S_TIMING5:
      pvalue = value17;
      break;
    case S_TIMING6:
      pvalue = value18;
      break;
    case S_TIMING7:
      pvalue = value19;
      break;
    case S_TIMING8:
      pvalue = value20;
      break;
    case S_TIMING9:
      pvalue = value21;
      break;
    case S_TIMING10:
      pvalue = value22;
      break;
    case S_TIMING11:
      pvalue = value23;
      break;
    case S_TIMING12:
      pvalue = value24;
      break;

    }

  if (pvalue != NULL)
    switch (option)
      {
      case ADCCLKP1:
	rst = pvalue[0];
	break;
      case ADCCLKP2:
	rst = pvalue[1];
	break;
      case CPH0P1:
	rst = pvalue[2];
	break;
      case CPH0P2:
	rst = pvalue[3];
	break;
      case CPH1P1:
	rst = pvalue[4];
	break;
      case CPH1P2:
	rst = pvalue[5];
	break;
      case CPH2P1:
	rst = pvalue[6];
	break;
      case CPH2P2:
	rst = pvalue[7];
	break;
      case CPH3P1:
	rst = pvalue[8];
	break;
      case CPH3P2:
	rst = pvalue[9];
	break;
      case CPH4P1:
	rst = pvalue[10];
	break;
      case CPH4P2:
	rst = pvalue[11];
	break;
      case CPH5P1:
	rst = pvalue[12];
	break;
      case CPH5P2:
	rst = pvalue[13];
	break;
      }

  return rst;
}

static int
ttf_sec_get (int file, int section, int option, int defvalue)
{
  int rst = defvalue;

  switch (section)
    {
    case TIMING:
      rst = ttf_sec1_get (file, option, defvalue);
      break;
    }

  return rst;
}

static double
lttf_sec_get (int file, int section, int option, double defvalue)
{
  double rst = defvalue;

  switch (section)
    {
    case TIMING:
      rst = lttf_sec1_get (file, option, defvalue);
      break;
    }

  return rst;
}

static int
get_value (int section, int option, int defvalue, int file)
{
  int rst = defvalue;

  switch (file)
    {
    case FITCALIBRATE:
      rst = fc_sec_get (section, option, defvalue);
      break;
    case MOTORCURVE1:
      rst = mc_sec_get (1, section, option, defvalue);
      break;
    case MOTORCURVE2:
      rst = mc_sec_get (2, section, option, defvalue);
      break;
    case MOTORCURVE3:
      rst = mc_sec_get (3, section, option, defvalue);
      break;
    case MOTORCURVE4:
      rst = mc_sec_get (4, section, option, defvalue);
      break;
    case MOTORCURVE5:
      rst = mc_sec_get (5, section, option, defvalue);
      break;
    case MOTORCURVE6:
      rst = mc_sec_get (6, section, option, defvalue);
      break;
    case MOTORCURVE7:
      rst = mc_sec_get (7, section, option, defvalue);
      break;
    case MOTORCURVE8:
      rst = mc_sec_get (8, section, option, defvalue);
      break;
    case S_RTINIFILE:
    case S_USB1INIFILE:
    case T_RTINIFILE:
    case T_USB1INIFILE:
      rst = srt_sec_get (file, section, option, defvalue);
      break;
    case T_TIMING1:
    case T_TIMING2:
    case T_TIMING3:
    case T_TIMING4:
    case T_TIMING5:
    case T_TIMING6:
    case T_TIMING7:
    case T_TIMING8:
    case T_TIMING9:
    case T_TIMING10:
    case T_TIMING11:
    case T_TIMING12:
    case S_TIMING1:
    case S_TIMING2:
    case S_TIMING3:
    case S_TIMING4:
    case S_TIMING5:
    case S_TIMING6:
    case S_TIMING7:
    case S_TIMING8:
    case S_TIMING9:
    case S_TIMING10:
    case S_TIMING11:
    case S_TIMING12:
      rst = ttf_sec_get (file, section, option, defvalue);
      break;
    }

  return rst;
}

static double
get_lvalue (int section, int option, double defvalue, int file)
{
  double rst = defvalue;

  switch (file)
    {
    case T_TIMING1:
    case T_TIMING2:
    case T_TIMING3:
    case T_TIMING4:
    case T_TIMING5:
    case T_TIMING6:
    case T_TIMING7:
    case T_TIMING8:
    case T_TIMING9:
    case T_TIMING10:
    case T_TIMING11:
    case T_TIMING12:
    case S_TIMING1:
    case S_TIMING2:
    case S_TIMING3:
    case S_TIMING4:
    case S_TIMING5:
    case S_TIMING6:
    case S_TIMING7:
    case S_TIMING8:
    case S_TIMING9:
    case S_TIMING10:
    case S_TIMING11:
    case S_TIMING12:
      rst = lttf_sec_get (file, section, option, defvalue);
      break;
    }

  return rst;
}

/*void *ltrim(char *texto)
{
	// Text must finish in '\0'
	int pos = 0;
		
	if (texto != NULL)
	{
		while (texto[pos] != '\0')
		{
			if (texto[pos] == ' ')
				pos++;
					else break;
		}
	}
	return texto + pos;
}*/

/*char *strlwr(char *string)
{
	// Note:  This function invades the proper name space of ANSI C
	char *convert;

	convert = string;
	do
	{
		*convert = tolower (*convert);
	} while (*convert++);
	
	return string;      // The input value
}*/

/*char *GetStrValue(char *section, char *option, char *file)
{
	char mysection[0x100];
	char myoption[0x100];
	char line[0x100];
	char *myline = NULL;
	FILE *myfile;
	int status;
	UINT optionlen;
	
	strcpy(mysection, section);
	strcpy(myoption, option);
	
	strlwr(ltrim(mysection));	
	strlwr(ltrim(myoption));	
	
	if (strlen(myoption) == 0)
		return NULL;
	
	// try to open specified file
	myfile = fopen(file, "r");
	// if file does not exist, return default value

	if (myfile == NULL)
	{
		#ifdef RTSDEBUG
			if (Debug_Level >= 0)
				printf("GetStrValue: File %s does not exist\n", file);
		#endif
		return NULL;
	}
	
	if (strlen(mysection) == 0)
		status = 1;
			else status = 0;

	optionlen = strlen(myoption);
	
	while ((status != 0xff) && (!feof(myfile)))
	{
		// Reads a line and converts it to lowercase
		bzero(line, 0x100);
		fgets(line, 0xff, myfile);
		myline = ltrim(line);
		if (strlen(myline) > 0x00)
		{
			strlwr(myline);
			switch(status)
			{
				case 0:
					// Locate Seccion
					if (myline[0x00] == '[')
					{
						myline++;
						if (strlen(myline) > strlen(mysection))
						{
							myline[strlen(mysection)] = '\0';
							if (strcmp(myline, mysection) == 0)
								status = 1; // Section found
						}
					}
					break;
				case 1:
					// Locate Option
					if (myline[0x00] == '[')
					{
						fclose(myfile);
						return NULL;
					}
					if (strlen(myline) > (optionlen + 1))
					{
						if ((myline[optionlen] == ' ')||(myline[optionlen] == '='))
						{
							myline[optionlen] = '\0';
							if (strcmp(myline, myoption) == 0)
							{
								// Option found
								status = 0xff;
								myline = myline + optionlen + 1;
								ltrim(myline);
							}
						}
					}
			  	break;
			}
		}
	}
	// Close file
	fclose(myfile);
	return myline;
}*/

/*double GetLValue(char *section, char *option, double defvalue, char *file)
{
	char *myline = GetStrValue(section, option, file);
	
	if (myline != NULL)
	{
		// in theory myline points to value 
		if (strlen(myline) > 0)
		{
			// try to decode 
			char datatype = 0; // decimal positive 
			
			// Detecting data type 
			if (myline[0x00] == '-')
			{
				datatype = 2; // decimal negative 
				myline++;
			} else if (strlen(myline) > 2)
			{
				if ((myline[0] == '0') && (myline[1] == 'x'))
				{
					datatype = 1; // hexadecimal 
					myline = myline + 2;
				}
			}
			
			ltrim(myline);
			if (strlen(myline) > 0)
			{
				char buffer[0xff];
				char data;
				UINT pos1;
				int  pos2;
				bzero(buffer, 0xff);
				pos1 = 0; pos2 = 0;
				while (pos1 < strlen(myline))
				{
					data = myline[pos1];
					if (((data >= '0')&&(data <= '9'))||
					    ((datatype == 1)&&((data >= 'a')&&(data <= 'f'))))
					{
						buffer[pos2] = data;
						pos2++;
					} else break;
					pos1++;
				}
				
				if (strlen(buffer) > 0)
				{
					double  rst = 0;
					for (pos2 = (strlen(buffer) - 1); pos2 >= 0; pos2--)
					{
						data = buffer[pos2];
						switch (datatype)
						{
							case 0x01:
								// hexadecimal
								if (data > 0x39)
									data = data - 0x57;
										else data = data - 0x30;
								rst = rst + (data * pow(16, strlen(buffer) - (pos2 + 1)));
								break;
							default:
								// decimal
								rst = rst + ((data - 0x30) * pow(10, strlen(buffer) - (pos2 + 1)));
								break;
						}
					}
					if (datatype == 2)
						rst = -rst;
					return rst;
				}
			}
		}
	}
	return defvalue;
}*/

/*int GetValue(char *section, char *option, int defvalue, char *file)
{
	char *myline = GetStrValue(section, option, file);
	
	if (myline != NULL)
	{
		// in theory myline points to value 
		if (strlen(myline) > 0)
		{
			// try to decode 
			char datatype = 0; // decimal positive
			
			// Detecting data type
			if (myline[0x00] == '-')
			{
				datatype = 2; // decimal negative
				myline++;
			} else if (strlen(myline) > 2)
			{
				if ((myline[0] == '0') && (myline[1] == 'x'))
				{
					datatype = 1; // hexadecimal
					myline = myline + 2;
				}
			}
			
			ltrim(myline);
			if (strlen(myline) > 0)
			{
				char buffer[0xff];
				UINT pos1;
				int pos2;
				char data;
				bzero(buffer, 0xff);
				pos1 = 0;
				pos2 = 0;
				while (pos1 < strlen(myline))
				{
					data = myline[pos1];
					if (((data >= '0')&&(data <= '9'))||
					    ((datatype == 1)&&((data >= 'a')&&(data <= 'f'))))
					{
						buffer[pos2] = data;
						pos2++;
					} else break;
					pos1++;
				}
				
				if (strlen(buffer) > 0)
				{
					int  rst = 0;
					for (pos2 = (strlen(buffer) - 1); pos2 >= 0; pos2--)
					{
						data = buffer[pos2];
						switch (datatype)
						{
							case 0x01:
								// hexadecimal
								if (data > 0x39)
									data = data - 0x57;
										else data = data - 0x30;
								rst = rst + (data * pow(16, strlen(buffer) - (pos2 + 1)));
								break;
							default:
								// decimal 
								rst = rst + ((data - 0x30) * pow(10, strlen(buffer) - (pos2 + 1)));
								break;
						}
					}
					if (datatype == 2)
						rst = -rst;
					return rst;
				}
			}
		}
	}
	return defvalue;
}*/
