#include <fs_secure.h>
#include <lsm.h>
#include <errno.h>
#include "kernel_stat.h"
#include "xstat_conv.h"
#include <flask_util.h>

int stat_secure(const char *pathname, 
		struct stat *buf, 
		security_id_t *out_sid)
{
	struct kernel_stat kbuf;
	unsigned long args[3];
	long err;

	if (is_flask_enabled()) {
		args[0] = (unsigned long)pathname;
		args[1] = (unsigned long)&kbuf;
		args[2] = (unsigned long)out_sid;
		err = lsm(SELINUX_MAGIC, SELINUXCALL_STAT, args);
		if (err)
			return err;
		return xstat_conv(_STAT_VER_LINUX, &kbuf, buf);
	} else {
		/* Compatibility for the modified utilities
		   until they are fixed. */
		*out_sid = SECINITSID_UNLABELED;
		return stat(pathname, buf);
	}
}
