/*
 * msgwrite.c
 *
 * Author: Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
 * 
 * Write a message to the queue with the given id
 *
 */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <getopt.h>
#include <linux/flask/flask.h>
#include <sys/msg.h>
#include <ipc_secure.h>
#include <string.h>
#include <ss.h> /* for security_context_to_sid() */

/* print the usage information for this program */
void usage(char *progname) 
{
  fprintf(stderr, "usage:  %s [-i id] [-c context | -s sid] [-t type] < message\n", progname);
  exit(1);
}

#define MAXMSGTESTED 4096

struct ipcmsgbuf {
  long mtype;     /* message type, must be > 0 */
  char mtext[MAXMSGTESTED];  /* message data */
};

int main(int argc, char **argv)
{
  int id, got_id = 0;
  struct ipcmsgbuf buf;
  char *message;
  int type = 1;
  security_id_t sid = SECSID_NULL;
  int valid_msg_sid = 0;
  char *word, *first_words;
  int ret;
  char c;

  while ( (c = getopt(argc, argv, "c:i:s:t:")) != EOF) {
    switch (c) {
    case 's':
      if (valid_msg_sid) {
	fprintf (stderr, "Only a sid or a context may be given, not both\n");
	usage(argv[0]);
      } else {
	valid_msg_sid = 1;
	sid = atoi(optarg);
      }
      break;
    case 'c':
      if (valid_msg_sid) {
	fprintf (stderr, "Only a sid or a context may be given, not both\n");
	usage(argv[0]);
      } else {
	valid_msg_sid =1;
	ret = security_context_to_sid(optarg,strlen(optarg)+1,&sid);
	if (ret) {
	  perror("Invalid context on command line");
	  exit(ret);
	}
      }
      break;
    case 'i':
      id = atoi(optarg);
      got_id = 1;
      break;
    case 't':
      type = atoi(optarg);
      break;
    default:
      usage(argv[0]);
    }
  }
  if (! got_id) {
    fprintf (stderr, "Semaphore ID (-i) is required.\n");
    usage(argv[0]);
  }

  first_words = (char *) malloc (strlen (""));
  word = (char *) malloc (20);
  strcpy (first_words, "");
  message = (char *) malloc (strlen (""));
  strcpy (message, "");
  while (scanf ("%20s", word) != EOF) {
    first_words = message;
    message = (char *) malloc (strlen (first_words) + strlen (word) + 2);
    strcpy (message, first_words);
    strcat (message, " ");
    strcat (message, word);
    free (first_words);
  }
  free (word);

  buf.mtype = type;
  strncpy (buf.mtext, message, MAXMSGTESTED);
  if (valid_msg_sid) {
    if (msgsnd_secure (id, &buf, strlen(message), 0, sid) < 0)
      perror ("msgsnd_secure failed");
    else
      fprintf (stderr, "Message QID: %d Type: %d SENT: %s\n", id, type, message);
  } else {
    if (msgsnd (id, &buf, strlen(message), 0) < 0)
      perror ("msgsnd failed");
    else
      fprintf (stderr, "Message QID: %d Type: %d SENT: %s\n",id, type, message);
  }
  return 0;
}


