/* sid_to_context.c
 *
 * Given a SID, returns the associated security context
 */

#include <ss.h>
#include <stdlib.h>
#include <errno.h>

int main(int argc, char **argv)
{
	int ret_val;
#define INITLEN 255
	char *buf;
	unsigned int buf_len;

	if (argc != 2) {
		printf("usage:  %s sid\n\n", argv[0]);
		exit(1);
	}

	buf = malloc(INITLEN);
	if (!buf) {
		perror("malloc");
		exit(1);
	}
	buf_len = INITLEN;

	ret_val = security_sid_to_context(atoi(argv[1]), buf, &buf_len);
	if (ret_val && errno == ENOSPC) {
		buf = realloc(buf, buf_len);
		if (!buf) {
			perror("realloc");
			exit(1);
		}
		ret_val =
		    security_sid_to_context(atoi(argv[1]), buf, &buf_len);
	}

	if (ret_val) {
		perror("security_sid_to_context");
		exit(2);
	}

	printf("%s\n", buf);
	exit(0);
}
