/*
 * Flask Networking Utility Library
 *
 * Copyright (c) 2001-2002 James Morris <jmorris@intercode.com.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#ifndef _LIBFLUTIL_H_
#define _LIBFLUTIL_H_

#ifndef NIPQUAD 
#define NIPQUAD(addr) \
        ((unsigned char *)&addr)[0], \
        ((unsigned char *)&addr)[1], \
        ((unsigned char *)&addr)[2], \
        ((unsigned char *)&addr)[3]
#endif

int string_to_number(const char *s, int min, int max);
struct in_addr *dotted_to_addr(const char *dotted);
struct in_addr *network_to_addr(const char *name);
void inaddrcpy(struct in_addr *dst, struct in_addr *src);
struct in_addr *host_to_addr(const char *name, unsigned int *naddr);
struct in_addr *parse_hostnetwork(const char *name, unsigned int *naddrs);
struct in_addr *parse_mask(char *mask);
void parse_hostnetworkmask(const char *name, struct in_addr **addrpp,
                           struct in_addr *maskp, unsigned int *naddrs);
u_int8_t ip_masklen(u_int32_t netmask);

#endif	/* _LIBFLUTIL_H_ */


