#
# Makefile module for scmpd.
#
# This file is GPL.
#
EXE_TARGS+=$(SCMPD_EXE)
OBJ_TARGS+=$(SCMPD_OBJS)

INST_TARGS+=install_scmpd
UNINST_TARGS+=uninstall_scmpd

SCMPD_EXE:=scmpd/scmpd
SCMPD_OBJS:=scmpd/server.o scmpd/flnetlink.o scmpd/transport.o scmpd/protocol.o \
            scmpd/perimtab.o scmpd/debug.o

SCMPD_LIBS=$(LIBFLNETLINK_LIB) $(LIBFLUTIL_LIB)

CFLAGS+=-DSCMPD_VERSION=\"$(VERSION)\" -I/usr/local/selinux/include
LDFLAGS+=-L/usr/local/selinux/lib

$(SCMPD_EXE): $(SCMPD_OBJS) $(SCMPD_LIBS)
	$(CC) $(LDFLAGS) -o $@ $^ $(SCMPD_LIBS) -lsecure

install_scmpd: $(SCMPD_EXE)
	@install --verbose -s -m 755 -o root -g root $(SCMPD_EXE) $(SBINDIR)
	
uninstall_scmpd:
	@rm -fv $(SBINDIR)/scmpd
