/*===========================================================================
 *  Filename : functable-r5rs-procedure.c
 *  About    : Built-in function table
 *             This file is auto-generated by build_func_table.rb
 *
 *  Copyright (C) 2005-2006 Kazuki Ohta <mover AT hct.zaq.ne.jp>
 *
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of authors nor the names of its contributors
 *     may be used to endorse or promote products derived from this software
 *     without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 *  IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 *  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 *  PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
===========================================================================*/

#include <stddef.h>

#include "sigscheme.h"
static const struct scm_func_registration_info scm_r5rs_procedure_func_info_table[] = {
    /* eval.c */
    { "eval", (ScmFuncType)scm_p_eval, SCM_PROCEDURE_FIXED_2 },
    { "apply", (ScmFuncType)scm_p_apply, SCM_PROCEDURE_VARIADIC_TAILREC_2 },
    { "scheme-report-environment", (ScmFuncType)scm_p_scheme_report_environment, SCM_PROCEDURE_FIXED_1 },
    { "null-environment", (ScmFuncType)scm_p_null_environment, SCM_PROCEDURE_FIXED_1 },
    { "interaction-environment", (ScmFuncType)scm_p_interaction_environment, SCM_PROCEDURE_FIXED_0 },

    /* procedure.c */
    { "eq?", (ScmFuncType)scm_p_eqp, SCM_PROCEDURE_FIXED_2 },
    { "eqv?", (ScmFuncType)scm_p_eqvp, SCM_PROCEDURE_FIXED_2 },
    { "equal?", (ScmFuncType)scm_p_equalp, SCM_PROCEDURE_FIXED_2 },
    { "not", (ScmFuncType)scm_p_not, SCM_PROCEDURE_FIXED_1 },
    { "boolean?", (ScmFuncType)scm_p_booleanp, SCM_PROCEDURE_FIXED_1 },
    { "symbol?", (ScmFuncType)scm_p_symbolp, SCM_PROCEDURE_FIXED_1 },
    { "symbol->string", (ScmFuncType)scm_p_symbol2string, SCM_PROCEDURE_FIXED_1 },
    { "string->symbol", (ScmFuncType)scm_p_string2symbol, SCM_PROCEDURE_FIXED_1 },
    { "procedure?", (ScmFuncType)scm_p_procedurep, SCM_PROCEDURE_FIXED_1 },
    { "map", (ScmFuncType)scm_p_map, SCM_PROCEDURE_VARIADIC_1 },
    { "for-each", (ScmFuncType)scm_p_for_each, SCM_PROCEDURE_VARIADIC_1 },
    { "force", (ScmFuncType)scm_p_force, SCM_PROCEDURE_FIXED_1 },
    { "call-with-current-continuation", (ScmFuncType)scm_p_call_with_current_continuation, SCM_PROCEDURE_FIXED_TAILREC_1 },
    { "values", (ScmFuncType)scm_p_values, SCM_PROCEDURE_VARIADIC_0 },
    { "call-with-values", (ScmFuncType)scm_p_call_with_values, SCM_PROCEDURE_FIXED_TAILREC_2 },
    { "dynamic-wind", (ScmFuncType)scm_p_dynamic_wind, SCM_PROCEDURE_FIXED_3 },

    /* list.c */
    { "car", (ScmFuncType)scm_p_car, SCM_PROCEDURE_FIXED_1 },
    { "cdr", (ScmFuncType)scm_p_cdr, SCM_PROCEDURE_FIXED_1 },
    { "pair?", (ScmFuncType)scm_p_pairp, SCM_PROCEDURE_FIXED_1 },
    { "cons", (ScmFuncType)scm_p_cons, SCM_PROCEDURE_FIXED_2 },
    { "set-car!", (ScmFuncType)scm_p_set_carx, SCM_PROCEDURE_FIXED_2 },
    { "set-cdr!", (ScmFuncType)scm_p_set_cdrx, SCM_PROCEDURE_FIXED_2 },
    { "caar", (ScmFuncType)scm_p_caar, SCM_PROCEDURE_FIXED_1 },
    { "cadr", (ScmFuncType)scm_p_cadr, SCM_PROCEDURE_FIXED_1 },
    { "cdar", (ScmFuncType)scm_p_cdar, SCM_PROCEDURE_FIXED_1 },
    { "cddr", (ScmFuncType)scm_p_cddr, SCM_PROCEDURE_FIXED_1 },
    { "caddr", (ScmFuncType)scm_p_caddr, SCM_PROCEDURE_FIXED_1 },
    { "cdddr", (ScmFuncType)scm_p_cdddr, SCM_PROCEDURE_FIXED_1 },
    { "list", (ScmFuncType)scm_p_list, SCM_PROCEDURE_VARIADIC_0 },
    { "null?", (ScmFuncType)scm_p_nullp, SCM_PROCEDURE_FIXED_1 },
    { "list?", (ScmFuncType)scm_p_listp, SCM_PROCEDURE_FIXED_1 },
    { "length", (ScmFuncType)scm_p_length, SCM_PROCEDURE_FIXED_1 },
    { "append", (ScmFuncType)scm_p_append, SCM_PROCEDURE_VARIADIC_0 },
    { "reverse", (ScmFuncType)scm_p_reverse, SCM_PROCEDURE_FIXED_1 },
    { "list-tail", (ScmFuncType)scm_p_list_tail, SCM_PROCEDURE_FIXED_2 },
    { "list-ref", (ScmFuncType)scm_p_list_ref, SCM_PROCEDURE_FIXED_2 },
    { "memq", (ScmFuncType)scm_p_memq, SCM_PROCEDURE_FIXED_2 },
    { "memv", (ScmFuncType)scm_p_memv, SCM_PROCEDURE_FIXED_2 },
    { "member", (ScmFuncType)scm_p_member, SCM_PROCEDURE_FIXED_2 },
    { "assq", (ScmFuncType)scm_p_assq, SCM_PROCEDURE_FIXED_2 },
    { "assv", (ScmFuncType)scm_p_assv, SCM_PROCEDURE_FIXED_2 },
    { "assoc", (ScmFuncType)scm_p_assoc, SCM_PROCEDURE_FIXED_2 },

    /* number.c */
    { "+", (ScmFuncType)scm_p_add, SCM_REDUCTION_OPERATOR },
    { "*", (ScmFuncType)scm_p_multiply, SCM_REDUCTION_OPERATOR },
    { "-", (ScmFuncType)scm_p_subtract, SCM_REDUCTION_OPERATOR },
    { "/", (ScmFuncType)scm_p_divide, SCM_REDUCTION_OPERATOR },
    { "number?", (ScmFuncType)scm_p_numberp, SCM_PROCEDURE_FIXED_1 },
    { "integer?", (ScmFuncType)scm_p_integerp, SCM_PROCEDURE_FIXED_1 },
    { "=", (ScmFuncType)scm_p_equal, SCM_REDUCTION_OPERATOR },
    { "<", (ScmFuncType)scm_p_less, SCM_REDUCTION_OPERATOR },
    { "<=", (ScmFuncType)scm_p_less_equal, SCM_REDUCTION_OPERATOR },
    { ">", (ScmFuncType)scm_p_greater, SCM_REDUCTION_OPERATOR },
    { ">=", (ScmFuncType)scm_p_greater_equal, SCM_REDUCTION_OPERATOR },
    { "zero?", (ScmFuncType)scm_p_zerop, SCM_PROCEDURE_FIXED_1 },
    { "positive?", (ScmFuncType)scm_p_positivep, SCM_PROCEDURE_FIXED_1 },
    { "negative?", (ScmFuncType)scm_p_negativep, SCM_PROCEDURE_FIXED_1 },
    { "odd?", (ScmFuncType)scm_p_oddp, SCM_PROCEDURE_FIXED_1 },
    { "even?", (ScmFuncType)scm_p_evenp, SCM_PROCEDURE_FIXED_1 },
    { "max", (ScmFuncType)scm_p_max, SCM_REDUCTION_OPERATOR },
    { "min", (ScmFuncType)scm_p_min, SCM_REDUCTION_OPERATOR },
    { "abs", (ScmFuncType)scm_p_abs, SCM_PROCEDURE_FIXED_1 },
    { "quotient", (ScmFuncType)scm_p_quotient, SCM_PROCEDURE_FIXED_2 },
    { "modulo", (ScmFuncType)scm_p_modulo, SCM_PROCEDURE_FIXED_2 },
    { "remainder", (ScmFuncType)scm_p_remainder, SCM_PROCEDURE_FIXED_2 },
    { "number->string", (ScmFuncType)scm_p_number2string, SCM_PROCEDURE_VARIADIC_1 },
    { "string->number", (ScmFuncType)scm_p_string2number, SCM_PROCEDURE_VARIADIC_1 },

    /* char.c */
    { "char?", (ScmFuncType)scm_p_charp, SCM_PROCEDURE_FIXED_1 },
    { "char=?", (ScmFuncType)scm_p_char_equalp, SCM_PROCEDURE_FIXED_2 },
    { "char<?", (ScmFuncType)scm_p_char_lessp, SCM_PROCEDURE_FIXED_2 },
    { "char>?", (ScmFuncType)scm_p_char_greaterp, SCM_PROCEDURE_FIXED_2 },
    { "char<=?", (ScmFuncType)scm_p_char_less_equalp, SCM_PROCEDURE_FIXED_2 },
    { "char>=?", (ScmFuncType)scm_p_char_greater_equalp, SCM_PROCEDURE_FIXED_2 },
    { "char-ci=?", (ScmFuncType)scm_p_char_ci_equalp, SCM_PROCEDURE_FIXED_2 },
    { "char-ci<?", (ScmFuncType)scm_p_char_ci_lessp, SCM_PROCEDURE_FIXED_2 },
    { "char-ci>?", (ScmFuncType)scm_p_char_ci_greaterp, SCM_PROCEDURE_FIXED_2 },
    { "char-ci<=?", (ScmFuncType)scm_p_char_ci_less_equalp, SCM_PROCEDURE_FIXED_2 },
    { "char-ci>=?", (ScmFuncType)scm_p_char_ci_greater_equalp, SCM_PROCEDURE_FIXED_2 },
    { "char-alphabetic?", (ScmFuncType)scm_p_char_alphabeticp, SCM_PROCEDURE_FIXED_1 },
    { "char-numeric?", (ScmFuncType)scm_p_char_numericp, SCM_PROCEDURE_FIXED_1 },
    { "char-whitespace?", (ScmFuncType)scm_p_char_whitespacep, SCM_PROCEDURE_FIXED_1 },
    { "char-upper-case?", (ScmFuncType)scm_p_char_upper_casep, SCM_PROCEDURE_FIXED_1 },
    { "char-lower-case?", (ScmFuncType)scm_p_char_lower_casep, SCM_PROCEDURE_FIXED_1 },
    { "char->integer", (ScmFuncType)scm_p_char2integer, SCM_PROCEDURE_FIXED_1 },
    { "integer->char", (ScmFuncType)scm_p_integer2char, SCM_PROCEDURE_FIXED_1 },
    { "char-upcase", (ScmFuncType)scm_p_char_upcase, SCM_PROCEDURE_FIXED_1 },
    { "char-downcase", (ScmFuncType)scm_p_char_downcase, SCM_PROCEDURE_FIXED_1 },

    /* string.c */
    { "string?", (ScmFuncType)scm_p_stringp, SCM_PROCEDURE_FIXED_1 },
    { "make-string", (ScmFuncType)scm_p_make_string, SCM_PROCEDURE_VARIADIC_1 },
    { "string", (ScmFuncType)scm_p_string, SCM_PROCEDURE_VARIADIC_0 },
    { "string-length", (ScmFuncType)scm_p_string_length, SCM_PROCEDURE_FIXED_1 },
    { "string-ref", (ScmFuncType)scm_p_string_ref, SCM_PROCEDURE_FIXED_2 },
    { "string-set!", (ScmFuncType)scm_p_string_setx, SCM_PROCEDURE_FIXED_3 },
    { "string=?", (ScmFuncType)scm_p_stringequalp, SCM_PROCEDURE_FIXED_2 },
    { "string-ci=?", (ScmFuncType)scm_p_string_ci_equalp, SCM_PROCEDURE_FIXED_2 },
    { "string>?", (ScmFuncType)scm_p_string_greaterp, SCM_PROCEDURE_FIXED_2 },
    { "string<?", (ScmFuncType)scm_p_string_lessp, SCM_PROCEDURE_FIXED_2 },
    { "string>=?", (ScmFuncType)scm_p_string_greater_equalp, SCM_PROCEDURE_FIXED_2 },
    { "string<=?", (ScmFuncType)scm_p_string_less_equalp, SCM_PROCEDURE_FIXED_2 },
    { "string-ci>?", (ScmFuncType)scm_p_string_ci_greaterp, SCM_PROCEDURE_FIXED_2 },
    { "string-ci<?", (ScmFuncType)scm_p_string_ci_lessp, SCM_PROCEDURE_FIXED_2 },
    { "string-ci>=?", (ScmFuncType)scm_p_string_ci_greater_equalp, SCM_PROCEDURE_FIXED_2 },
    { "string-ci<=?", (ScmFuncType)scm_p_string_ci_less_equalp, SCM_PROCEDURE_FIXED_2 },
    { "substring", (ScmFuncType)scm_p_substring, SCM_PROCEDURE_FIXED_3 },
    { "string-append", (ScmFuncType)scm_p_string_append, SCM_PROCEDURE_VARIADIC_0 },
    { "string->list", (ScmFuncType)scm_p_string2list, SCM_PROCEDURE_FIXED_1 },
    { "list->string", (ScmFuncType)scm_p_list2string, SCM_PROCEDURE_FIXED_1 },
    { "string-copy", (ScmFuncType)scm_p_string_copy, SCM_PROCEDURE_FIXED_1 },
    { "string-fill!", (ScmFuncType)scm_p_string_fillx, SCM_PROCEDURE_FIXED_2 },

    /* vector.c */
    { "vector?", (ScmFuncType)scm_p_vectorp, SCM_PROCEDURE_FIXED_1 },
    { "make-vector", (ScmFuncType)scm_p_make_vector, SCM_PROCEDURE_VARIADIC_1 },
    { "vector", (ScmFuncType)scm_p_vector, SCM_PROCEDURE_VARIADIC_0 },
    { "vector-length", (ScmFuncType)scm_p_vector_length, SCM_PROCEDURE_FIXED_1 },
    { "vector-ref", (ScmFuncType)scm_p_vector_ref, SCM_PROCEDURE_FIXED_2 },
    { "vector-set!", (ScmFuncType)scm_p_vector_setx, SCM_PROCEDURE_FIXED_3 },
    { "vector->list", (ScmFuncType)scm_p_vector2list, SCM_PROCEDURE_FIXED_1 },
    { "list->vector", (ScmFuncType)scm_p_list2vector, SCM_PROCEDURE_FIXED_1 },
    { "vector-fill!", (ScmFuncType)scm_p_vector_fillx, SCM_PROCEDURE_FIXED_2 },

    /* port.c */
    { "call-with-input-file", (ScmFuncType)scm_p_call_with_input_file, SCM_PROCEDURE_FIXED_2 },
    { "call-with-output-file", (ScmFuncType)scm_p_call_with_output_file, SCM_PROCEDURE_FIXED_2 },
    { "input-port?", (ScmFuncType)scm_p_input_portp, SCM_PROCEDURE_FIXED_1 },
    { "output-port?", (ScmFuncType)scm_p_output_portp, SCM_PROCEDURE_FIXED_1 },
    { "current-input-port", (ScmFuncType)scm_p_current_input_port, SCM_PROCEDURE_FIXED_0 },
    { "current-output-port", (ScmFuncType)scm_p_current_output_port, SCM_PROCEDURE_FIXED_0 },
    { "with-input-from-file", (ScmFuncType)scm_p_with_input_from_file, SCM_PROCEDURE_FIXED_2 },
    { "with-output-to-file", (ScmFuncType)scm_p_with_output_to_file, SCM_PROCEDURE_FIXED_2 },
    { "open-input-file", (ScmFuncType)scm_p_open_input_file, SCM_PROCEDURE_FIXED_1 },
    { "open-output-file", (ScmFuncType)scm_p_open_output_file, SCM_PROCEDURE_FIXED_1 },
    { "close-input-port", (ScmFuncType)scm_p_close_input_port, SCM_PROCEDURE_FIXED_1 },
    { "close-output-port", (ScmFuncType)scm_p_close_output_port, SCM_PROCEDURE_FIXED_1 },
    { "read-char", (ScmFuncType)scm_p_read_char, SCM_PROCEDURE_VARIADIC_0 },
    { "peek-char", (ScmFuncType)scm_p_peek_char, SCM_PROCEDURE_VARIADIC_0 },
    { "eof-object?", (ScmFuncType)scm_p_eof_objectp, SCM_PROCEDURE_FIXED_1 },
    { "char-ready?", (ScmFuncType)scm_p_char_readyp, SCM_PROCEDURE_VARIADIC_0 },
    { "newline", (ScmFuncType)scm_p_newline, SCM_PROCEDURE_VARIADIC_0 },
    { "write-char", (ScmFuncType)scm_p_write_char, SCM_PROCEDURE_VARIADIC_1 },

    /* read.c */
    { "read", (ScmFuncType)scm_p_read, SCM_PROCEDURE_VARIADIC_0 },

    /* write.c */
    { "write", (ScmFuncType)scm_p_write, SCM_PROCEDURE_VARIADIC_1 },
    { "display", (ScmFuncType)scm_p_display, SCM_PROCEDURE_VARIADIC_1 },

    /* load.c */
    { "load-path", (ScmFuncType)scm_p_load_path, SCM_PROCEDURE_FIXED_0 },
    { "load", (ScmFuncType)scm_p_load, SCM_PROCEDURE_FIXED_1 },

    /* deep-cadrs.c */
    { "caaar", (ScmFuncType)scm_p_caaar, SCM_PROCEDURE_FIXED_1 },
    { "caadr", (ScmFuncType)scm_p_caadr, SCM_PROCEDURE_FIXED_1 },
    { "cadar", (ScmFuncType)scm_p_cadar, SCM_PROCEDURE_FIXED_1 },
    { "cdaar", (ScmFuncType)scm_p_cdaar, SCM_PROCEDURE_FIXED_1 },
    { "cdadr", (ScmFuncType)scm_p_cdadr, SCM_PROCEDURE_FIXED_1 },
    { "cddar", (ScmFuncType)scm_p_cddar, SCM_PROCEDURE_FIXED_1 },
    { "caaaar", (ScmFuncType)scm_p_caaaar, SCM_PROCEDURE_FIXED_1 },
    { "caaadr", (ScmFuncType)scm_p_caaadr, SCM_PROCEDURE_FIXED_1 },
    { "caadar", (ScmFuncType)scm_p_caadar, SCM_PROCEDURE_FIXED_1 },
    { "caaddr", (ScmFuncType)scm_p_caaddr, SCM_PROCEDURE_FIXED_1 },
    { "cadaar", (ScmFuncType)scm_p_cadaar, SCM_PROCEDURE_FIXED_1 },
    { "cadadr", (ScmFuncType)scm_p_cadadr, SCM_PROCEDURE_FIXED_1 },
    { "caddar", (ScmFuncType)scm_p_caddar, SCM_PROCEDURE_FIXED_1 },
    { "cadddr", (ScmFuncType)scm_p_cadddr, SCM_PROCEDURE_FIXED_1 },
    { "cdaaar", (ScmFuncType)scm_p_cdaaar, SCM_PROCEDURE_FIXED_1 },
    { "cdaadr", (ScmFuncType)scm_p_cdaadr, SCM_PROCEDURE_FIXED_1 },
    { "cdadar", (ScmFuncType)scm_p_cdadar, SCM_PROCEDURE_FIXED_1 },
    { "cdaddr", (ScmFuncType)scm_p_cdaddr, SCM_PROCEDURE_FIXED_1 },
    { "cddaar", (ScmFuncType)scm_p_cddaar, SCM_PROCEDURE_FIXED_1 },
    { "cddadr", (ScmFuncType)scm_p_cddadr, SCM_PROCEDURE_FIXED_1 },
    { "cdddar", (ScmFuncType)scm_p_cdddar, SCM_PROCEDURE_FIXED_1 },
    { "cddddr", (ScmFuncType)scm_p_cddddr, SCM_PROCEDURE_FIXED_1 },

    { NULL, NULL, SCM_FUNCTYPE_INVALID }
};

