# Soya 3D tutorial
# Copyright (C) 2004 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# blender-auto-exporter-1: Blender auto-exporter : how to export models automatically

# This lesson is similar to basic-2.py, but it loads a Blender model !
# You NEED Blender to run this lesson.

# The Soya auto-exporter feature currently support the following file formats :
#  - Blender model (Both static models, and Cal3D ones)
#  - OBJ/MTL model (thanks David PHAM-VAN)
#  - .png images
#  - .jpeg images 


# Imports and inits Soya (see lesson basic-1.py).

import sys, os, os.path, soya

soya.init()
soya.path.append(os.path.join(os.path.dirname(sys.argv[0]), "data"))

# Creates the scene.

scene = soya.World()

# Loads the knife model.

# To use auto-exporter, simply put your Blender models in {soya.path}/blender/ , your
# OBJ/MTL models in {soya.path}/obj/ and your textures in {soya.path}/images/ .
# Soya will automatically exports models to Soya worlds ans shapes, and textures to
# materials, if the corresponding Soya doesn't exist OR is not up-to-date.

# Here, the knife model doesn't exist as a Soya model yet, but the original Blender model
# is in {soya.path}/blender/knife.blender ; so Soya will find it, export it to
# a world and then compile the world into a shape.

# Soya will save the exported world and shape, so if you run the lesson again, the model
# won't be exported again. If you want so, just modify the model and/or the texture.

knife_model = soya.Shape.get("knife")


# You can also "compose" more complex shape name, if you want to produce SEVERAL Soya model
# from a SINGLE Blender model.

# E.g. if you have a "blender/mushroom.blend" blender model, with a "grow" animation,
# you can use the following names to get the model at different moments of the "grow"ing
# animation :
#
#   soya.Shape.get("mushroom@grow:1")
#   soya.Shape.get("mushroom@grow:50")
#   soya.Shape.get("mushroom@grow:100")

# You can also replace one or several materials of the model. E.g., if the mushroom use
# a material called "mushroom", you can replace it by the material called "rotten_mushroom"
# as following :
#
#   soya.Shape.get("mushroom@,mushroom:rotten_mushroom")
#
# You can use several ",old_material_name:new_material_name" if you want.

# Both animation and material can be specified :
#
#   soya.Shape.get("mushroom@grow:100,mushroom:rotten_mushroom")


# The rest of the script is the same than lesson-2.

# Creates a rotating volume class.

class RotatingVolume(soya.Volume):
  def advance_time(self, proportion):
    soya.Volume.advance_time(self, proportion)
    self.rotate_lateral(proportion * 5.0)


knife = RotatingVolume(scene, knife_model)

# Creates a light.

light = soya.Light(scene)
light.set_xyz(0.5, 0.0, 2.0)

# Creates a camera.

camera = soya.Camera(scene)
camera.z = 3.0
soya.set_root_widget(camera)

soya.Idler(scene).idle()

