/*
 * SpanDSP - a series of DSP components for telephony
 *
 * v17rx.c - ITU V.17 modem receive part
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2004 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: v17rx.c,v 1.31 2006/01/21 05:10:27 steveu Exp $
 */

/*! \file */

/* THIS IS A WORK IN PROGRESS - KIND OF FUNCTIONAL, BUT NOT ROBUST! */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <inttypes.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "spandsp/telephony.h"
#include "spandsp/logging.h"
#include "spandsp/async.h"
#include "spandsp/power_meter.h"
#include "spandsp/arctan2.h"
#include "spandsp/complex.h"
#include "spandsp/dds.h"
#include "spandsp/complex_filters.h"

#include "spandsp/v29rx.h"
#include "spandsp/v17rx.h"

/* Segments of the training sequence */
#define V17_TRAINING_SEG_1_LEN          256
#define V17_TRAINING_SEG_2_LEN          2976
#define V17_TRAINING_SHORT_SEG_2_LEN    38
#define V17_TRAINING_SEG_3_LEN          64
#define V17_TRAINING_SEG_4A_LEN         15
#define V17_TRAINING_SEG_4_LEN          48

#define V17_BRIDGE_WORD                 0x8880

#define EQUALIZER_DELTA                 0.25

enum
{
    TRAINING_STAGE_NORMAL_OPERATION = 0,
    TRAINING_STAGE_SYMBOL_ACQUISITION,
    TRAINING_STAGE_LOG_PHASE,
    TRAINING_STAGE_SHORT_WAIT_FOR_CDBA,
    TRAINING_STAGE_WAIT_FOR_CDBA,
    TRAINING_STAGE_TRAIN_ON_CDBA,
    TRAINING_STAGE_SHORT_TRAIN_ON_CDBA_AND_TEST,
    TRAINING_STAGE_TRAIN_ON_CDBA_AND_TEST,
    TRAINING_STAGE_BRIDGE,
    TRAINING_STAGE_TCM_WINDUP,
    TRAINING_STAGE_TEST_ONES,
    TRAINING_STAGE_PARKED
};

#if 0
/* Raised root cosine pulse shaping; Beta = 0.25; 4 symbols either
   side of the centre. We cannot simplify this by using only half
   the filter, as each variant are each skewed by n/PULSESHAPER_COEFF_SETS
   of a sample. Only one is symmetric. */
#define PULSESHAPER_GAIN        (1.5964543012e+02/16.0)
#define PULSESHAPER_COEFF_SETS  192
static const float pulseshaper[PULSESHAPER_COEFF_SETS][V17RX_FILTER_STEPS] =
{
    {
         0.0281155862,          /* Filter 0 */
         0.0138439626,
        -0.0285615173,
        -0.0521677994,
        -0.0162777823,
         0.0603982517,
         0.0999497832,
         0.0342926437,
        -0.1119970377,
        -0.2077231549,
        -0.1023409733,
         0.2441526325,
         0.6974182428,
         1.0170945955,
         1.0170945955,
         0.6974182428,
         0.2441526325,
        -0.1023409733,
        -0.2077231549,
        -0.1119970377,
         0.0342926437,
         0.0999497832,
         0.0603982517,
        -0.0162777823,
        -0.0521677994,
        -0.0285615173,
         0.0138439626
    },
    {
         0.0281455086,          /* Filter 1 */
         0.0136669179,
        -0.0287814710,
        -0.0521482937,
        -0.0159333835,
         0.0607785783,
         0.0999056691,
         0.0336613619,
        -0.1127695264,
        -0.2077900880,
        -0.1011096226,
         0.2464276827,
         0.6996390591,
         1.0180033440,
         1.0161492956,
         0.6951824025,
         0.2418902555,
        -0.1035444025,
        -0.2076333119,
        -0.1112193006,
         0.0349140696,
         0.0999815497,
         0.0600138315,
        -0.0166171210,
        -0.0521802379,
        -0.0283394799,
         0.0140175186
    },
    {
         0.0281754311,          /* Filter 2 */
         0.0134898733,
        -0.0290014248,
        -0.0521287880,
        -0.0155889846,
         0.0611589050,
         0.0998615549,
         0.0330300802,
        -0.1135420151,
        -0.2078570211,
        -0.0998782719,
         0.2487027328,
         0.7018598754,
         1.0189120925,
         1.0152039956,
         0.6929465623,
         0.2396278784,
        -0.1047478317,
        -0.2075434690,
        -0.1104415636,
         0.0355354955,
         0.1000133163,
         0.0596294114,
        -0.0169564597,
        -0.0521926765,
        -0.0281174426,
         0.0141910745
    },
    {
         0.0282053536,          /* Filter 3 */
         0.0133128286,
        -0.0292213785,
        -0.0521092822,
        -0.0152445858,
         0.0615392316,
         0.0998174408,
         0.0323987984,
        -0.1143145038,
        -0.2079239542,
        -0.0986469212,
         0.2509777830,
         0.7040806917,
         1.0198208411,
         1.0142586957,
         0.6907107220,
         0.2373655014,
        -0.1059512609,
        -0.2074536260,
        -0.1096638265,
         0.0361569214,
         0.1000450828,
         0.0592449912,
        -0.0172957985,
        -0.0522051151,
        -0.0278954053,
         0.0143646305
    },
    {
         0.0282352761,          /* Filter 4 */
         0.0131357839,
        -0.0294413322,
        -0.0520897765,
        -0.0149001870,
         0.0619195582,
         0.0997733266,
         0.0317675166,
        -0.1150869926,
        -0.2079908873,
        -0.0974155706,
         0.2532528331,
         0.7063015080,
         1.0207295896,
         1.0133133958,
         0.6884748817,
         0.2351031244,
        -0.1071546901,
        -0.2073637831,
        -0.1088860894,
         0.0367783473,
         0.1000768493,
         0.0588605710,
        -0.0176351372,
        -0.0522175536,
        -0.0276733679,
         0.0145381864
    },
    {
         0.0282609850,          /* Filter 5 */
         0.0129553270,
        -0.0296590666,
        -0.0520631588,
        -0.0145508614,
         0.0622955721,
         0.0997167809,
         0.0311265805,
        -0.1158538389,
        -0.2080346289,
        -0.0961564085,
         0.2555400525,
         0.7085067190,
         1.0216015356,
         1.0123318055,
         0.6862246016,
         0.2328539186,
        -0.1083300970,
        -0.2072513178,
        -0.1081034967,
         0.0373897219,
         0.1000963572,
         0.0584722768,
        -0.0179692860,
        -0.0522229732,
        -0.0274493829,
         0.0147081796
    },
    {
         0.0282866939,          /* Filter 6 */
         0.0127748701,
        -0.0298768009,
        -0.0520365410,
        -0.0142015358,
         0.0626715861,
         0.0996602352,
         0.0304856443,
        -0.1166206852,
        -0.2080783704,
        -0.0948972465,
         0.2578272718,
         0.7107119299,
         1.0224734817,
         1.0113502151,
         0.6839743215,
         0.2306047128,
        -0.1095055040,
        -0.2071388526,
        -0.1073209040,
         0.0380010965,
         0.1001158651,
         0.0580839825,
        -0.0183034347,
        -0.0522283929,
        -0.0272253980,
         0.0148781728
    },
    {
         0.0283124028,          /* Filter 7 */
         0.0125944132,
        -0.0300945352,
        -0.0520099232,
        -0.0138522102,
         0.0630476000,
         0.0996036895,
         0.0298447081,
        -0.1173875315,
        -0.2081221120,
        -0.0936380845,
         0.2601144912,
         0.7129171408,
         1.0233454277,
         1.0103686247,
         0.6817240414,
         0.2283555070,
        -0.1106809110,
        -0.2070263874,
        -0.1065383112,
         0.0386124711,
         0.1001353729,
         0.0576956882,
        -0.0186375834,
        -0.0522338125,
        -0.0270014130,
         0.0150481659
    },
    {
         0.0283381118,          /* Filter 8 */
         0.0124139562,
        -0.0303122695,
        -0.0519833054,
        -0.0135028846,
         0.0634236139,
         0.0995471438,
         0.0292037719,
        -0.1181543779,
        -0.2081658535,
        -0.0923789224,
         0.2624017105,
         0.7151223517,
         1.0242173737,
         1.0093870344,
         0.6794737613,
         0.2261063011,
        -0.1118563180,
        -0.2069139221,
        -0.1057557185,
         0.0392238457,
         0.1001548808,
         0.0573073940,
        -0.0189717322,
        -0.0522392321,
        -0.0267774280,
         0.0152181591
    },
    {
         0.0283595656,          /* Filter 9 */
         0.0122301658,
        -0.0305276490,
        -0.0519495339,
        -0.0131487691,
         0.0637950963,
         0.0994780876,
         0.0285533886,
        -0.1189151866,
        -0.2081861277,
        -0.0910920686,
         0.2647005894,
         0.7173113789,
         1.0250522763,
         1.0083694246,
         0.6772096282,
         0.2238707586,
        -0.1130036115,
        -0.2067791278,
        -0.1049686613,
         0.0398249796,
         0.1001622239,
         0.0569154453,
        -0.0193005645,
        -0.0522376843,
        -0.0265516316,
         0.0153845178
    },
    {
         0.0283810195,          /* Filter 10 */
         0.0120463754,
        -0.0307430284,
        -0.0519157624,
        -0.0127946535,
         0.0641665788,
         0.0994090315,
         0.0279030053,
        -0.1196759954,
        -0.2082064019,
        -0.0898052147,
         0.2669994683,
         0.7195004060,
         1.0258871789,
         1.0073518147,
         0.6749454951,
         0.2216352161,
        -0.1141509050,
        -0.2066443334,
        -0.1041816041,
         0.0404261135,
         0.1001695669,
         0.0565234966,
        -0.0196293968,
        -0.0522361365,
        -0.0263258351,
         0.0155508765
    },
    {
         0.0284024733,          /* Filter 11 */
         0.0118625851,
        -0.0309584078,
        -0.0518819910,
        -0.0124405379,
         0.0645380613,
         0.0993399753,
         0.0272526220,
        -0.1204368041,
        -0.2082266761,
        -0.0885183609,
         0.2692983472,
         0.7216894332,
         1.0267220814,
         1.0063342048,
         0.6726813620,
         0.2193996736,
        -0.1152981985,
        -0.2065095391,
        -0.1033945469,
         0.0410272474,
         0.1001769100,
         0.0561315479,
        -0.0199582292,
        -0.0522345887,
        -0.0261000387,
         0.0157172352
    },
    {
         0.0284239271,          /* Filter 12 */
         0.0116787947,
        -0.0311737872,
        -0.0518482195,
        -0.0120864223,
         0.0649095437,
         0.0992709191,
         0.0266022387,
        -0.1211976129,
        -0.2082469503,
        -0.0872315071,
         0.2715972261,
         0.7238784604,
         1.0275569840,
         1.0053165950,
         0.6704172289,
         0.2171641311,
        -0.1164454920,
        -0.2063747447,
        -0.1026074897,
         0.0416283812,
         0.1001842531,
         0.0557395992,
        -0.0202870615,
        -0.0522330408,
        -0.0258742422,
         0.0158835939
    },
    {
         0.0284410866,          /* Filter 13 */
         0.0114917519,
        -0.0313866766,
        -0.0518072561,
        -0.0117276568,
         0.0652762765,
         0.0991892787,
         0.0259426215,
        -0.1219519878,
        -0.2082434873,
        -0.0859170904,
         0.2739072494,
         0.7260507286,
         1.0283546123,
         1.0042632463,
         0.6681398320,
         0.2149427379,
        -0.1175645901,
        -0.2062179199,
        -0.1018163576,
         0.0422190910,
         0.1001795300,
         0.0553442159,
        -0.0206104545,
        -0.0522245802,
        -0.0256467705,
         0.0160462489
    },
    {
         0.0284582460,          /* Filter 14 */
         0.0113047092,
        -0.0315995659,
        -0.0517662927,
        -0.0113688914,
         0.0656430093,
         0.0991076383,
         0.0252830043,
        -0.1227063627,
        -0.2082400243,
        -0.0846026737,
         0.2762172727,
         0.7282229968,
         1.0291522405,
         1.0032098976,
         0.6658624351,
         0.2127213447,
        -0.1186836882,
        -0.2060610952,
        -0.1010252256,
         0.0428098007,
         0.1001748069,
         0.0549488325,
        -0.0209338476,
        -0.0522161196,
        -0.0254192988,
         0.0162089039
    },
    {
         0.0284754055,          /* Filter 15 */
         0.0111176665,
        -0.0318124553,
        -0.0517253294,
        -0.0110101259,
         0.0660097421,
         0.0990259978,
         0.0246233872,
        -0.1234607376,
        -0.2082365614,
        -0.0832882571,
         0.2785272960,
         0.7303952650,
         1.0299498687,
         1.0021565489,
         0.6635850382,
         0.2104999514,
        -0.1198027863,
        -0.2059042704,
        -0.1002340935,
         0.0434005105,
         0.1001700839,
         0.0545534492,
        -0.0212572406,
        -0.0522076590,
        -0.0251918270,
         0.0163715588
    },
    {
         0.0284925649,          /* Filter 16 */
         0.0109306237,
        -0.0320253446,
        -0.0516843660,
        -0.0106513604,
         0.0663764748,
         0.0989443574,
         0.0239637700,
        -0.1242151125,
        -0.2082330984,
        -0.0819738404,
         0.2808373192,
         0.7325675332,
         1.0307474970,
         1.0011032002,
         0.6613076413,
         0.2082785582,
        -0.1209218845,
        -0.2057474457,
        -0.0994429615,
         0.0439912202,
         0.1001653608,
         0.0541580658,
        -0.0215806336,
        -0.0521991983,
        -0.0249643553,
         0.0165342138
    },
    {
         0.0285053928,          /* Filter 17 */
         0.0107404120,
        -0.0322356092,
        -0.0516361759,
        -0.0102880885,
         0.0667382403,
         0.0988500641,
         0.0232951379,
        -0.1249626565,
        -0.2082056347,
        -0.0806319993,
         0.2831579663,
         0.7347224706,
         1.0315076302,
         1.0000144030,
         0.6590175721,
         0.2060717940,
        -0.1220127147,
        -0.2055688946,
        -0.0986481424,
         0.0445713285,
         0.1001486751,
         0.0537594676,
        -0.0218984681,
        -0.0521838827,
        -0.0247353445,
         0.0166930983
    },
    {
         0.0285182207,          /* Filter 18 */
         0.0105502003,
        -0.0324458737,
        -0.0515879858,
        -0.0099248165,
         0.0671000058,
         0.0987557709,
         0.0226265059,
        -0.1257102004,
        -0.2081781711,
        -0.0792901582,
         0.2854786134,
         0.7368774080,
         1.0322677635,
         0.9989256059,
         0.6567275030,
         0.2038650297,
        -0.1231035449,
        -0.2053903436,
        -0.0978533234,
         0.0451514368,
         0.1001319894,
         0.0533608693,
        -0.0222163025,
        -0.0521685671,
        -0.0245063337,
         0.0168519827
    },
    {
         0.0285310486,          /* Filter 19 */
         0.0103599887,
        -0.0326561383,
        -0.0515397957,
        -0.0095615446,
         0.0674617712,
         0.0986614776,
         0.0219578739,
        -0.1264577443,
        -0.2081507074,
        -0.0779483171,
         0.2877992604,
         0.7390323454,
         1.0330278967,
         0.9978368087,
         0.6544374338,
         0.2016582654,
        -0.1241943751,
        -0.2052117925,
        -0.0970585043,
         0.0457315451,
         0.1001153037,
         0.0529622711,
        -0.0225341369,
        -0.0521532515,
        -0.0242773229,
         0.0170108672
    },
    {
         0.0285438766,          /* Filter 20 */
         0.0101697770,
        -0.0328664028,
        -0.0514916056,
        -0.0091982726,
         0.0678235367,
         0.0985671844,
         0.0212892419,
        -0.1272052882,
        -0.2081232437,
        -0.0766064761,
         0.2901199075,
         0.7411872828,
         1.0337880300,
         0.9967480115,
         0.6521473646,
         0.1994515012,
        -0.1252852054,
        -0.2050332414,
        -0.0962636853,
         0.0463116534,
         0.1000986179,
         0.0525636728,
        -0.0228519713,
        -0.0521379359,
        -0.0240483120,
         0.0171697517
    },
    {
         0.0285523381,          /* Filter 21 */
         0.0099764820,
        -0.0330739083,
        -0.0514361574,
        -0.0088306409,
         0.0681801180,
         0.0984601750,
         0.0206118199,
        -0.1279456033,
        -0.2080715221,
        -0.0752373583,
         0.2924506525,
         0.7433243212,
         1.0345104579,
         0.9956240658,
         0.6498452166,
         0.1972598392,
        -0.1263477046,
        -0.2048332734,
        -0.0954655652,
         0.0468809890,
         0.1000700777,
         0.0521620793,
        -0.0231641314,
        -0.0521158263,
        -0.0238178982,
         0.0173248013
    },
    {
         0.0285607996,          /* Filter 22 */
         0.0097831870,
        -0.0332814138,
        -0.0513807092,
        -0.0084630092,
         0.0685366992,
         0.0983531656,
         0.0199343978,
        -0.1286859183,
        -0.2080198004,
        -0.0738682406,
         0.2947813975,
         0.7454613595,
         1.0352328858,
         0.9945001202,
         0.6475430686,
         0.1950681772,
        -0.1274102038,
        -0.2046333054,
        -0.0946674451,
         0.0474503246,
         0.1000415374,
         0.0517604858,
        -0.0234762914,
        -0.0520937166,
        -0.0235874845,
         0.0174798509
    },
    {
         0.0285692612,          /* Filter 23 */
         0.0095898920,
        -0.0334889193,
        -0.0513252610,
        -0.0080953775,
         0.0688932805,
         0.0982461562,
         0.0192569758,
        -0.1294262333,
        -0.2079680788,
        -0.0724991229,
         0.2971121425,
         0.7475983979,
         1.0359553138,
         0.9933761745,
         0.6452409205,
         0.1928765151,
        -0.1284727030,
        -0.2044333374,
        -0.0938693250,
         0.0480196602,
         0.1000129971,
         0.0513588923,
        -0.0237884515,
        -0.0520716070,
        -0.0233570707,
         0.0176349005
    },
    {
         0.0285777227,          /* Filter 24 */
         0.0093965971,
        -0.0336964248,
        -0.0512698128,
        -0.0077277457,
         0.0692498618,
         0.0981391468,
         0.0185795538,
        -0.1301665484,
        -0.2079163571,
        -0.0711300052,
         0.2994428875,
         0.7497354363,
         1.0366777417,
         0.9922522288,
         0.6429387725,
         0.1906848531,
        -0.1295352022,
        -0.2042333694,
        -0.0930712050,
         0.0485889958,
         0.0999844569,
         0.0509572988,
        -0.0241006115,
        -0.0520494973,
        -0.0231266569,
         0.0177899501
    },
    {
         0.0285817853,          /* Filter 25 */
         0.0092003067,
        -0.0339010376,
        -0.0512070787,
        -0.0073559041,
         0.0696010428,
         0.0980193632,
         0.0178935723,
        -0.1308992360,
        -0.2078401266,
        -0.0697337681,
         0.3017831995,
         0.7518540111,
         1.0373622642,
         0.9910934441,
         0.6406251411,
         0.1885087601,
        -0.1305693167,
        -0.2040122988,
        -0.0922701678,
         0.0491473936,
         0.0999441748,
         0.0505529295,
        -0.0244069852,
        -0.0520206575,
        -0.0228949761,
         0.0179411030
    },
    {
         0.0285858479,          /* Filter 26 */
         0.0090040163,
        -0.0341056505,
        -0.0511443445,
        -0.0069840626,
         0.0699522238,
         0.0978995797,
         0.0172075908,
        -0.1316319236,
        -0.2077638962,
        -0.0683375309,
         0.3041235115,
         0.7539725858,
         1.0380467868,
         0.9899346594,
         0.6383115096,
         0.1863326671,
        -0.1316034311,
        -0.2037912283,
        -0.0914691306,
         0.0497057914,
         0.0999038927,
         0.0501485602,
        -0.0247133588,
        -0.0519918178,
        -0.0226632954,
         0.0180922560
    },
    {
         0.0285899105,          /* Filter 27 */
         0.0088077259,
        -0.0343102633,
        -0.0510816104,
        -0.0066122210,
         0.0703034048,
         0.0977797962,
         0.0165216094,
        -0.1323646112,
        -0.2076876657,
        -0.0669412938,
         0.3064638235,
         0.7560911606,
         1.0387313093,
         0.9887758746,
         0.6359978781,
         0.1841565741,
        -0.1326375456,
        -0.2035701578,
        -0.0906680935,
         0.0502641893,
         0.0998636106,
         0.0497441908,
        -0.0250197324,
        -0.0519629781,
        -0.0224316146,
         0.0182434089
    },
    {
         0.0285939730,          /* Filter 28 */
         0.0086114355,
        -0.0345148761,
        -0.0510188762,
        -0.0062403794,
         0.0706545858,
         0.0976600127,
         0.0158356279,
        -0.1330972988,
        -0.2076114352,
        -0.0655450567,
         0.3088041356,
         0.7582097354,
         1.0394158319,
         0.9876170899,
         0.6336842466,
         0.1819804810,
        -0.1336716600,
        -0.2033490873,
        -0.0898670563,
         0.0508225871,
         0.0998233285,
         0.0493398215,
        -0.0253261060,
        -0.0519341383,
        -0.0221999338,
         0.0183945618
    },
    {
         0.0285936064,          /* Filter 29 */
         0.0084122397,
        -0.0347164631,
        -0.0509488318,
        -0.0058644810,
         0.0710001514,
         0.0975274024,
         0.0151413232,
        -0.1338219600,
        -0.2075104516,
        -0.0641218667,
         0.3111534787,
         0.7603092861,
         1.0400622595,
         0.9864237850,
         0.6313597287,
         0.1798204171,
        -0.1346773453,
        -0.2031072337,
        -0.0890634838,
         0.0513698882,
         0.0997714219,
         0.0489328955,
        -0.0256265847,
        -0.0518986355,
        -0.0219671218,
         0.0185417587
    },
    {
         0.0285932398,          /* Filter 30 */
         0.0082130440,
        -0.0349180502,
        -0.0508787873,
        -0.0054885826,
         0.0713457170,
         0.0973947921,
         0.0144470186,
        -0.1345466212,
        -0.2074094681,
        -0.0626986768,
         0.3135028219,
         0.7624088367,
         1.0407086871,
         0.9852304800,
         0.6290352108,
         0.1776603531,
        -0.1356830305,
        -0.2028653801,
        -0.0882599114,
         0.0519171894,
         0.0997195152,
         0.0485259695,
        -0.0259270634,
        -0.0518631326,
        -0.0217343099,
         0.0186889556
    },
    {
         0.0285928731,          /* Filter 31 */
         0.0080138482,
        -0.0351196373,
        -0.0508087429,
        -0.0051126842,
         0.0716912826,
         0.0972621819,
         0.0137527139,
        -0.1352712825,
        -0.2073084845,
        -0.0612754868,
         0.3158521651,
         0.7645083874,
         1.0413551147,
         0.9840371751,
         0.6267106928,
         0.1755002891,
        -0.1366887157,
        -0.2026235265,
        -0.0874563389,
         0.0524644905,
         0.0996676085,
         0.0481190436,
        -0.0262275421,
        -0.0518276298,
        -0.0215014979,
         0.0188361525
    },
    {
         0.0285925065,          /* Filter 32 */
         0.0078146525,
        -0.0353212243,
        -0.0507386984,
        -0.0047367858,
         0.0720368483,
         0.0971295716,
         0.0130584092,
        -0.1359959437,
        -0.2072075009,
        -0.0598522969,
         0.3182015083,
         0.7666079380,
         1.0420015423,
         0.9828438702,
         0.6243861749,
         0.1733402251,
        -0.1376944010,
        -0.2023816729,
        -0.0866527665,
         0.0530117917,
         0.0996157019,
         0.0477121176,
        -0.0265280208,
        -0.0517921269,
        -0.0212686859,
         0.0189833495
    },
    {
         0.0285876827,          /* Filter 33 */
         0.0076126436,
        -0.0355196534,
        -0.0506613229,
        -0.0043569868,
         0.0723765844,
         0.0969840875,
         0.0123560232,
        -0.1367121792,
        -0.2070815267,
        -0.0584023300,
         0.3205593420,
         0.7686879080,
         1.0426096958,
         0.9816163732,
         0.6220513690,
         0.1711966435,
        -0.1386716219,
        -0.2021193605,
        -0.0858470382,
         0.0535478433,
         0.0995522923,
         0.0473028536,
        -0.0268224999,
        -0.0517500309,
        -0.0210348781,
         0.0191265336
    },
    {
         0.0285828589,          /* Filter 34 */
         0.0074106347,
        -0.0357180824,
        -0.0505839474,
        -0.0039771878,
         0.0727163205,
         0.0968386034,
         0.0116536372,
        -0.1374284147,
        -0.2069555524,
        -0.0569523632,
         0.3229171757,
         0.7707678781,
         1.0432178494,
         0.9803888762,
         0.6197165630,
         0.1690530618,
        -0.1396488428,
        -0.2018570481,
        -0.0850413100,
         0.0540838950,
         0.0994888827,
         0.0468935897,
        -0.0271169790,
        -0.0517079349,
        -0.0208010704,
         0.0192697177
    },
    {
         0.0285780351,          /* Filter 35 */
         0.0072086258,
        -0.0359165114,
        -0.0505065718,
        -0.0035973889,
         0.0730560567,
         0.0966931192,
         0.0109512512,
        -0.1381446502,
        -0.2068295781,
        -0.0555023964,
         0.3252750094,
         0.7728478481,
         1.0438260029,
         0.9791613792,
         0.6173817571,
         0.1669094802,
        -0.1406260637,
        -0.2015947356,
        -0.0842355817,
         0.0546199467,
         0.0994254731,
         0.0464843258,
        -0.0274114580,
        -0.0516658388,
        -0.0205672627,
         0.0194129018
    },
    {
         0.0285732113,          /* Filter 36 */
         0.0070066169,
        -0.0361149404,
        -0.0504291963,
        -0.0032175899,
         0.0733957928,
         0.0965476351,
         0.0102488652,
        -0.1388608857,
        -0.2067036039,
        -0.0540524296,
         0.3276328431,
         0.7749278181,
         1.0444341565,
         0.9779338822,
         0.6150469512,
         0.1647658985,
        -0.1416032847,
        -0.2013324232,
        -0.0834298535,
         0.0551559984,
         0.0993620635,
         0.0460750618,
        -0.0277059371,
        -0.0516237428,
        -0.0203334550,
         0.0195560859
    },
    {
         0.0285639048,          /* Filter 37 */
         0.0068018891,
        -0.0363100799,
        -0.0503444724,
        -0.0028340495,
         0.0737294866,
         0.0963892355,
         0.0095386453,
        -0.1395682961,
        -0.2065524081,
        -0.0525758712,
         0.3299986220,
         0.7769876554,
         1.0450038675,
         0.9766725304,
         0.6127024570,
         0.1626392455,
        -0.1425520154,
        -0.2010499809,
        -0.0826223465,
         0.0556806541,
         0.0992872771,
         0.0456636782,
        -0.0279943155,
        -0.0515751265,
        -0.0200987866,
         0.0196952030
    },
    {
         0.0285545983,          /* Filter 38 */
         0.0065971614,
        -0.0365052193,
        -0.0502597486,
        -0.0024505092,
         0.0740631803,
         0.0962308358,
         0.0088284254,
        -0.1402757065,
        -0.2064012123,
        -0.0510993128,
         0.3323644010,
         0.7790474926,
         1.0455735784,
         0.9754111786,
         0.6103579628,
         0.1605125925,
        -0.1435007462,
        -0.2007675386,
        -0.0818148395,
         0.0562053098,
         0.0992124906,
         0.0452522945,
        -0.0282826938,
        -0.0515265101,
        -0.0198641183,
         0.0198343200
    },
    {
         0.0285452918,          /* Filter 39 */
         0.0063924337,
        -0.0367003588,
        -0.0501750248,
        -0.0020669688,
         0.0743968740,
         0.0960724362,
         0.0081182055,
        -0.1409831168,
        -0.2062500165,
        -0.0496227544,
         0.3347301800,
         0.7811073299,
         1.0461432894,
         0.9741498268,
         0.6080134686,
         0.1583859395,
        -0.1444494769,
        -0.2004850963,
        -0.0810073326,
         0.0567299654,
         0.0991377041,
         0.0448409108,
        -0.0285710722,
        -0.0514778937,
        -0.0196294499,
         0.0199734371
    },
    {
         0.0285359852,          /* Filter 40 */
         0.0061877060,
        -0.0368954982,
        -0.0500903010,
        -0.0016834284,
         0.0747305678,
         0.0959140366,
         0.0074079856,
        -0.1416905272,
        -0.2060988208,
        -0.0481461961,
         0.3370959589,
         0.7831671671,
         1.0467130004,
         0.9728884750,
         0.6056689744,
         0.1562592865,
        -0.1453982077,
        -0.2002026540,
        -0.0801998256,
         0.0572546211,
         0.0990629176,
         0.0444295272,
        -0.0288594506,
        -0.0514292773,
        -0.0193947816,
         0.0201125542
    },
    {
         0.0285221729,          /* Filter 41 */
         0.0059803558,
        -0.0370872174,
        -0.0499982153,
        -0.0012963090,
         0.0750580074,
         0.0957426854,
         0.0066901848,
        -0.1423887129,
        -0.2059221796,
        -0.0466432408,
         0.3394691335,
         0.7852063239,
         1.0472441108,
         0.9715936148,
         0.6033153928,
         0.1541500014,
        -0.1463184317,
        -0.1999004153,
        -0.0793909145,
         0.0577677405,
         0.0989768846,
         0.0440162414,
        -0.0291416310,
        -0.0513742163,
        -0.0191593874,
         0.0202475525
    },
    {
         0.0285083605,          /* Filter 42 */
         0.0057730057,
        -0.0372789366,
        -0.0499061296,
        -0.0009091895,
         0.0753854470,
         0.0955713342,
         0.0059723839,
        -0.1430868986,
        -0.2057455384,
        -0.0451402854,
         0.3418423080,
         0.7872454807,
         1.0477752212,
         0.9702987546,
         0.6009618111,
         0.1520407163,
        -0.1472386556,
        -0.1995981766,
        -0.0785820034,
         0.0582808598,
         0.0988908515,
         0.0436029556,
        -0.0294238113,
        -0.0513191552,
        -0.0189239931,
         0.0203825509
    },
    {
         0.0284945481,          /* Filter 43 */
         0.0055656555,
        -0.0374706558,
        -0.0498140439,
        -0.0005220700,
         0.0757128867,
         0.0953999830,
         0.0052545830,
        -0.1437850844,
        -0.2055688972,
        -0.0436373301,
         0.3442154826,
         0.7892846374,
         1.0483063317,
         0.9690038944,
         0.5986082295,
         0.1499314312,
        -0.1481588796,
        -0.1992959379,
        -0.0777730922,
         0.0587939792,
         0.0988048184,
         0.0431896699,
        -0.0297059917,
        -0.0512640942,
        -0.0186885989,
         0.0205175492
    },
    {
         0.0284807357,          /* Filter 44 */
         0.0053583054,
        -0.0376623750,
        -0.0497219582,
        -0.0001349506,
         0.0760403263,
         0.0952286318,
         0.0045367821,
        -0.1444832701,
        -0.2053922561,
        -0.0421343748,
         0.3465886571,
         0.7913237942,
         1.0488374421,
         0.9677090342,
         0.5962546478,
         0.1478221462,
        -0.1490791036,
        -0.1989936992,
        -0.0769641811,
         0.0593070986,
         0.0987187853,
         0.0427763841,
        -0.0299881721,
        -0.0512090332,
        -0.0184532046,
         0.0206525475
    },
    {
         0.0284623966,          /* Filter 45 */
         0.0051484313,
        -0.0378505442,
        -0.0496225007,
         0.0002555828,
         0.0763613015,
         0.0950442986,
         0.0038116586,
        -0.1451718318,
        -0.2051899526,
        -0.0406052265,
         0.3489686733,
         0.7933417275,
         1.0493298047,
         0.9663810209,
         0.5938925804,
         0.1457306611,
        -0.1499708135,
        -0.1986720020,
        -0.0761542377,
         0.0598085475,
         0.0986216400,
         0.0423614131,
        -0.0302640610,
        -0.0511476059,
        -0.0182172187,
         0.0207833780
    },
    {
         0.0284440576,          /* Filter 46 */
         0.0049385571,
        -0.0380387134,
        -0.0495230433,
         0.0006461162,
         0.0766822767,
         0.0948599654,
         0.0030865352,
        -0.1458603935,
        -0.2049876492,
        -0.0390760782,
         0.3513486894,
         0.7953596608,
         1.0498221673,
         0.9650530076,
         0.5915305130,
         0.1436391761,
        -0.1508625233,
        -0.1983503047,
        -0.0753442942,
         0.0603099964,
         0.0985244948,
         0.0419464421,
        -0.0305399498,
        -0.0510861786,
        -0.0179812328,
         0.0209142086
    },
    {
         0.0284257186,          /* Filter 47 */
         0.0047286830,
        -0.0382268826,
        -0.0494235858,
         0.0010366496,
         0.0770032519,
         0.0946756322,
         0.0023614117,
        -0.1465489553,
        -0.2047853458,
        -0.0375469299,
         0.3537287056,
         0.7973775941,
         1.0503145299,
         0.9637249942,
         0.5891684456,
         0.1415476910,
        -0.1517542331,
        -0.1980286075,
        -0.0745343508,
         0.0608114453,
         0.0984273495,
         0.0415314712,
        -0.0308158387,
        -0.0510247514,
        -0.0177452469,
         0.0210450391
    },
    {
         0.0284073795,          /* Filter 48 */
         0.0045188089,
        -0.0384150518,
        -0.0493241283,
         0.0014271830,
         0.0773242271,
         0.0944912991,
         0.0016362882,
        -0.1472375170,
        -0.2045830423,
        -0.0360177816,
         0.3561087217,
         0.7993955274,
         1.0508068925,
         0.9623969809,
         0.5868063781,
         0.1394562060,
        -0.1526459430,
        -0.1977069103,
        -0.0737244073,
         0.0613128943,
         0.0983302043,
         0.0411165002,
        -0.0310917276,
        -0.0509633241,
        -0.0175092610,
         0.0211758696
    },
    {
         0.0283844955,          /* Filter 49 */
         0.0043065112,
        -0.0385995423,
        -0.0492172929,
         0.0018209622,
         0.0776385291,
         0.0942939591,
         0.0009041058,
        -0.1479160557,
        -0.2043548669,
        -0.0344626534,
         0.3584950213,
         0.8013916991,
         1.0512603707,
         0.9610361786,
         0.5844364273,
         0.1373829458,
        -0.1535091405,
        -0.1973660966,
        -0.0729138006,
         0.0618025449,
         0.0982220854,
         0.0407000601,
        -0.0313612352,
        -0.0508956118,
        -0.0172728171,
         0.0213024858
    },
    {
         0.0283616115,          /* Filter 50 */
         0.0040942135,
        -0.0387840327,
        -0.0491104574,
         0.0022147415,
         0.0779528310,
         0.0940966192,
         0.0001719234,
        -0.1485945944,
        -0.2041266915,
        -0.0329075253,
         0.3608813210,
         0.8033878707,
         1.0517138489,
         0.9596753762,
         0.5820664765,
         0.1353096856,
        -0.1543723380,
        -0.1970252830,
        -0.0721031939,
         0.0622921956,
         0.0981139665,
         0.0402836201,
        -0.0316307427,
        -0.0508278996,
        -0.0170363732,
         0.0214291019
    },
    {
         0.0283387275,          /* Filter 51 */
         0.0038819158,
        -0.0389685232,
        -0.0490036219,
         0.0026085207,
         0.0782671329,
         0.0938992792,
        -0.0005602590,
        -0.1492731331,
        -0.2038985161,
        -0.0313523972,
         0.3632676206,
         0.8053840424,
         1.0521673271,
         0.9583145739,
         0.5796965257,
         0.1332364254,
        -0.1552355354,
        -0.1966844694,
        -0.0712925872,
         0.0627818462,
         0.0980058476,
         0.0398671800,
        -0.0319002503,
        -0.0507601873,
        -0.0167999292,
         0.0215557181
    },
    {
         0.0283158435,          /* Filter 52 */
         0.0036696181,
        -0.0391530137,
        -0.0488967864,
         0.0030022999,
         0.0785814349,
         0.0937019393,
        -0.0012924414,
        -0.1499516718,
        -0.2036703407,
        -0.0297972690,
         0.3656539202,
         0.8073802140,
         1.0526208053,
         0.9569537715,
         0.5773265749,
         0.1311631652,
        -0.1560987329,
        -0.1963436557,
        -0.0704819805,
         0.0632714968,
         0.0978977287,
         0.0394507399,
        -0.0321697579,
        -0.0506924750,
        -0.0165634853,
         0.0216823343
    },
    {
         0.0282883987,          /* Filter 53 */
         0.0034549992,
        -0.0393336978,
        -0.0487825704,
         0.0033991541,
         0.0788888562,
         0.0934915736,
        -0.0020314136,
        -0.1506197889,
        -0.2034160908,
        -0.0282163835,
         0.3680459413,
         0.8093540909,
         1.0530352732,
         0.9555605530,
         0.5749493436,
         0.1291085472,
        -0.1569334290,
        -0.1959840719,
        -0.0696710766,
         0.0637492276,
         0.0977787787,
         0.0390330460,
        -0.0324327983,
        -0.0506185616,
        -0.0163267165,
         0.0218046922
    },
    {
         0.0282609539,          /* Filter 54 */
         0.0032403803,
        -0.0395143818,
        -0.0486683543,
         0.0037960083,
         0.0791962776,
         0.0932812079,
        -0.0027703858,
        -0.1512879059,
        -0.2031618409,
        -0.0266354980,
         0.3704379624,
         0.8113279677,
         1.0534497412,
         0.9541673345,
         0.5725721122,
         0.1270539293,
        -0.1577681250,
        -0.1956244881,
        -0.0688601728,
         0.0642269584,
         0.0976598287,
         0.0386153521,
        -0.0326958387,
        -0.0505446481,
        -0.0160899476,
         0.0219270501
    },
    {
         0.0282335091,          /* Filter 55 */
         0.0030257614,
        -0.0396950659,
        -0.0485541383,
         0.0041928625,
         0.0795036990,
         0.0930708421,
        -0.0035093581,
        -0.1519560229,
        -0.2029075910,
        -0.0250546124,
         0.3728299835,
         0.8133018446,
         1.0538642091,
         0.9527741159,
         0.5701948809,
         0.1249993114,
        -0.1586028211,
        -0.1952649043,
        -0.0680492690,
         0.0647046892,
         0.0975408787,
         0.0381976581,
        -0.0329588790,
        -0.0504707347,
        -0.0158531787,
         0.0220494080
    },
    {
         0.0282060643,          /* Filter 56 */
         0.0028111425,
        -0.0398757500,
        -0.0484399222,
         0.0045897167,
         0.0798111203,
         0.0928604764,
        -0.0042483303,
        -0.1526241400,
        -0.2026533412,
        -0.0234737269,
         0.3752220046,
         0.8152757214,
         1.0542786771,
         0.9513808974,
         0.5678176496,
         0.1229446934,
        -0.1594375171,
        -0.1949053204,
        -0.0672383651,
         0.0651824199,
         0.0974219288,
         0.0377799642,
        -0.0332219194,
        -0.0503968213,
        -0.0156164098,
         0.0221717660
    },
    {
         0.0281740453,          /* Filter 57 */
         0.0025943067,
        -0.0400525011,
        -0.0483183269,
         0.0049894721,
         0.0801114555,
         0.0926370717,
        -0.0049938182,
        -0.1532814373,
        -0.2023728217,
        -0.0218673155,
         0.3776191813,
         0.8172267755,
         1.0546540198,
         0.9499556441,
         0.5654337409,
         0.1209091276,
        -0.1602437317,
        -0.1945273166,
        -0.0664275272,
         0.0656481155,
         0.0972922941,
         0.0373612306,
        -0.0334784104,
        -0.0503167932,
        -0.0153794484,
         0.0222898243
    },
    {
         0.0281420263,          /* Filter 58 */
         0.0023774709,
        -0.0402292523,
        -0.0481967315,
         0.0053892276,
         0.0804117907,
         0.0924136669,
        -0.0057393060,
        -0.1539387346,
        -0.2020923023,
        -0.0202609042,
         0.3800163581,
         0.8191778295,
         1.0550293626,
         0.9485303907,
         0.5630498322,
         0.1188735619,
        -0.1610499463,
        -0.1941493128,
        -0.0656166893,
         0.0661138110,
         0.0971626594,
         0.0369424970,
        -0.0337349014,
        -0.0502367651,
        -0.0151424869,
         0.0224078827
    },
    {
         0.0281100073,          /* Filter 59 */
         0.0021606351,
        -0.0404060035,
        -0.0480751361,
         0.0057889831,
         0.0807121259,
         0.0921902622,
        -0.0064847939,
        -0.1545960320,
        -0.2018117828,
        -0.0186544929,
         0.3824135348,
         0.8211288836,
         1.0554047053,
         0.9471051374,
         0.5606659235,
         0.1168379961,
        -0.1618561609,
        -0.1937713089,
        -0.0648058514,
         0.0665795066,
         0.0970330248,
         0.0365237635,
        -0.0339913924,
        -0.0501567370,
        -0.0149055255,
         0.0225259411
    },
    {
         0.0280779883,          /* Filter 60 */
         0.0019437993,
        -0.0405827546,
        -0.0479535407,
         0.0061887386,
         0.0810124611,
         0.0919668574,
        -0.0072302817,
        -0.1552533293,
        -0.2015312634,
        -0.0170480815,
         0.3848107115,
         0.8230799377,
         1.0557800480,
         0.9456798841,
         0.5582820148,
         0.1148024303,
        -0.1626623755,
        -0.1933933051,
        -0.0639950135,
         0.0670452021,
         0.0969033901,
         0.0361050299,
        -0.0342478835,
        -0.0500767089,
        -0.0146685640,
         0.0226439994
    },
    {
         0.0280413842,          /* Filter 61 */
         0.0017248528,
        -0.0407554476,
        -0.0478245709,
         0.0065912190,
         0.0813055063,
         0.0917304062,
        -0.0079820058,
        -0.1558994097,
        -0.2012242867,
        -0.0154163851,
         0.3872124744,
         0.8250076464,
         1.0561161613,
         0.9442229858,
         0.5558920321,
         0.1127863189,
        -0.1634401378,
        -0.1929972353,
        -0.0631846015,
         0.0674987534,
         0.0967632210,
         0.0356854698,
        -0.0344977469,
        -0.0499906552,
        -0.0144315416,
         0.0227577196
    },
    {
         0.0280047802,          /* Filter 62 */
         0.0015059063,
        -0.0409281405,
        -0.0476956011,
         0.0069936994,
         0.0815985515,
         0.0914939550,
        -0.0087337299,
        -0.1565454900,
        -0.2009173100,
        -0.0137846887,
         0.3896142374,
         0.8269353551,
         1.0564522745,
         0.9427660875,
         0.5535020493,
         0.1107702076,
        -0.1642179000,
        -0.1926011654,
        -0.0623741895,
         0.0679523047,
         0.0966230519,
         0.0352659097,
        -0.0347476102,
        -0.0499046014,
        -0.0141945192,
         0.0228714397
    },
    {
         0.0279681761,          /* Filter 63 */
         0.0012869597,
        -0.0411008334,
        -0.0475666313,
         0.0073961798,
         0.0818915967,
         0.0912575039,
        -0.0094854539,
        -0.1571915704,
        -0.2006103333,
        -0.0121529924,
         0.3920160003,
         0.8288630638,
         1.0567883878,
         0.9413091892,
         0.5511120665,
         0.1087540962,
        -0.1649956622,
        -0.1922050956,
        -0.0615637774,
         0.0684058560,
         0.0964828828,
         0.0348463496,
        -0.0349974736,
        -0.0498185477,
        -0.0139574968,
         0.0229851599
    },
    {
         0.0279315720,          /* Filter 64 */
         0.0010680132,
        -0.0412735264,
        -0.0474376615,
         0.0077986603,
         0.0821846419,
         0.0910210527,
        -0.0102371780,
        -0.1578376507,
        -0.2003033567,
        -0.0105212960,
         0.3944177633,
         0.8307907726,
         1.0571245011,
         0.9398522908,
         0.5487220838,
         0.1067379848,
        -0.1657734244,
        -0.1918090257,
        -0.0607533654,
         0.0688594072,
         0.0963427137,
         0.0344267896,
        -0.0352473370,
        -0.0497324940,
        -0.0137204743,
         0.0230988800
    },
    {
         0.0278903746,          /* Filter 65 */
         0.0008470639,
        -0.0414420371,
        -0.0473013261,
         0.0082036867,
         0.0824701952,
         0.0907715535,
        -0.0109948538,
        -0.1584721177,
        -0.1999697427,
        -0.0088645644,
         0.3968235396,
         0.8326946189,
         1.0574212916,
         0.9383641457,
         0.5463266301,
         0.1047417224,
        -0.1665227723,
        -0.1913952475,
        -0.0599437358,
         0.0693007114,
         0.0961921641,
         0.0340066150,
        -0.0354904983,
        -0.0496405062,
        -0.0134835218,
         0.0232082259
    },
    {
         0.0278491771,          /* Filter 66 */
         0.0006261145,
        -0.0416105478,
        -0.0471649906,
         0.0086087131,
         0.0827557485,
         0.0905220543,
        -0.0117525296,
        -0.1591065847,
        -0.1996361287,
        -0.0072078328,
         0.3992293159,
         0.8345984652,
         1.0577180822,
         0.9368760006,
         0.5439311765,
         0.1027454600,
        -0.1672721201,
        -0.1909814693,
        -0.0591341063,
         0.0697420156,
         0.0960416146,
         0.0335864403,
        -0.0357336596,
        -0.0495485184,
        -0.0132465692,
         0.0233175718
    },
    {
         0.0278079796,          /* Filter 67 */
         0.0004051652,
        -0.0417790585,
        -0.0470286551,
         0.0090137394,
         0.0830413018,
         0.0902725551,
        -0.0125102054,
        -0.1597410516,
        -0.1993025148,
        -0.0055511012,
         0.4016350922,
         0.8365023116,
         1.0580148728,
         0.9353878555,
         0.5415357228,
         0.1007491976,
        -0.1680214680,
        -0.1905676911,
        -0.0583244767,
         0.0701833198,
         0.0958910650,
         0.0331662657,
        -0.0359768210,
        -0.0494565306,
        -0.0130096166,
         0.0234269176
    },
    {
         0.0277667821,          /* Filter 68 */
         0.0001842159,
        -0.0419475693,
        -0.0468923197,
         0.0094187658,
         0.0833268551,
         0.0900230559,
        -0.0132678812,
        -0.1603755186,
        -0.1989689008,
        -0.0038943696,
         0.4040408685,
         0.8384061579,
         1.0583116633,
         0.9338997104,
         0.5391402692,
         0.0987529352,
        -0.1687708158,
        -0.1901539128,
        -0.0575148472,
         0.0706246240,
         0.0957405154,
         0.0327460911,
        -0.0362199823,
        -0.0493645428,
        -0.0127726640,
         0.0235362635
    },
    {
         0.0277209854,          /* Filter 69 */
        -0.0000386265,
        -0.0421117751,
        -0.0467486310,
         0.0098261567,
         0.0836047165,
         0.0897605130,
        -0.0140312193,
        -0.1609979768,
        -0.1986084771,
        -0.0022128618,
         0.4064500821,
         0.8402856305,
         1.0585690487,
         0.9323807248,
         0.5367399476,
         0.0967769084,
        -0.1694917963,
        -0.1897227874,
        -0.0567063533,
         0.0710535846,
         0.0955797430,
         0.0323255127,
        -0.0364563709,
        -0.0492667149,
        -0.0125359112,
         0.0236412017
    },
    {
         0.0276751887,          /* Filter 70 */
        -0.0002614689,
        -0.0422759809,
        -0.0466049424,
         0.0102335475,
         0.0838825779,
         0.0894979702,
        -0.0147945573,
        -0.1616204351,
        -0.1982480534,
        -0.0005313539,
         0.4088592957,
         0.8421651031,
         1.0588264340,
         0.9308617391,
         0.5343396259,
         0.0948008816,
        -0.1702127767,
        -0.1892916619,
        -0.0558978594,
         0.0714825451,
         0.0954189705,
         0.0319049342,
        -0.0366927596,
        -0.0491688869,
        -0.0122991583,
         0.0237461398
    },
    {
         0.0276293920,          /* Filter 71 */
        -0.0004843113,
        -0.0424401868,
        -0.0464612538,
         0.0106409383,
         0.0841604394,
         0.0892354273,
        -0.0155578954,
        -0.1622428933,
        -0.1978876297,
         0.0011501539,
         0.4112685092,
         0.8440445758,
         1.0590838194,
         0.9293427535,
         0.5319393043,
         0.0928248549,
        -0.1709337572,
        -0.1888605364,
        -0.0550893655,
         0.0719115057,
         0.0952581980,
         0.0314843558,
        -0.0369291483,
        -0.0490710590,
        -0.0120624055,
         0.0238510780
    },
    {
         0.0275835953,          /* Filter 72 */
        -0.0007071536,
        -0.0426043926,
        -0.0463175652,
         0.0110483291,
         0.0844383008,
         0.0889728845,
        -0.0163212335,
        -0.1628653515,
        -0.1975272061,
         0.0028316618,
         0.4136777228,
         0.8459240484,
         1.0593412048,
         0.9278237679,
         0.5295389827,
         0.0908488281,
        -0.1716547376,
        -0.1884294110,
        -0.0542808717,
         0.0723404663,
         0.0950974255,
         0.0310637773,
        -0.0371655369,
        -0.0489732311,
        -0.0118256527,
         0.0239560162
    },
    {
         0.0275331961,          /* Filter 73 */
        -0.0009317776,
        -0.0427641724,
        -0.0461665398,
         0.0114579004,
         0.0847082726,
         0.0886973083,
        -0.0170899394,
        -0.1634754069,
        -0.1971398080,
         0.0045376780,
         0.4160897945,
         0.8477786418,
         1.0595591135,
         0.9262743562,
         0.5271343955,
         0.0888934157,
        -0.1723474065,
        -0.1879813028,
        -0.0534738632,
         0.0727569930,
         0.0949265913,
         0.0306430044,
        -0.0373950862,
        -0.0488696594,
        -0.0115892286,
         0.0240565159
    },
    {
         0.0274827969,          /* Filter 74 */
        -0.0011564016,
        -0.0429239521,
        -0.0460155144,
         0.0118674716,
         0.0849782443,
         0.0884217321,
        -0.0178586454,
        -0.1640854623,
        -0.1967524100,
         0.0062436942,
         0.4185018661,
         0.8496332353,
         1.0597770223,
         0.9247249445,
         0.5247298084,
         0.0869380034,
        -0.1730400753,
        -0.1875331946,
        -0.0526668547,
         0.0731735196,
         0.0947557570,
         0.0302222314,
        -0.0376246355,
        -0.0487660878,
        -0.0113528045,
         0.0241570155
    },
    {
         0.0274323977,          /* Filter 75 */
        -0.0013810255,
        -0.0430837318,
        -0.0458644889,
         0.0122770428,
         0.0852482160,
         0.0881461560,
        -0.0186273513,
        -0.1646955176,
        -0.1963650120,
         0.0079497104,
         0.4209139378,
         0.8514878288,
         1.0599949310,
         0.9231755327,
         0.5223252212,
         0.0849825910,
        -0.1737327442,
        -0.1870850863,
        -0.0518598462,
         0.0735900463,
         0.0945849227,
         0.0298014585,
        -0.0378541849,
        -0.0486625161,
        -0.0111163804,
         0.0242575152
    },
    {
         0.0273819985,          /* Filter 76 */
        -0.0016056495,
        -0.0432435116,
        -0.0457134635,
         0.0126866141,
         0.0855181878,
         0.0878705798,
        -0.0193960573,
        -0.1653055730,
        -0.1959776139,
         0.0096557267,
         0.4233260095,
         0.8533424222,
         1.0602128397,
         0.9216261210,
         0.5199206341,
         0.0830271786,
        -0.1744254131,
        -0.1866369781,
        -0.0510528377,
         0.0740065730,
         0.0944140884,
         0.0293806855,
        -0.0380837342,
        -0.0485589444,
        -0.0108799564,
         0.0243580149
    },
    {
         0.0273269961,          /* Filter 77 */
        -0.0018319419,
        -0.0433987455,
        -0.0455551214,
         0.0130981793,
         0.0857800742,
         0.0875819866,
        -0.0201698319,
        -0.1659028327,
        -0.1955630848,
         0.0113859744,
         0.4257403572,
         0.8551716372,
         1.0603912113,
         0.9200467055,
         0.5175123832,
         0.0810927514,
        -0.1750898350,
        -0.1861722549,
        -0.0502476607,
         0.0744105818,
         0.0942333569,
         0.0289599260,
        -0.0383063813,
        -0.0484497276,
        -0.0106439890,
         0.0244540480
    },
    {
         0.0272719937,          /* Filter 78 */
        -0.0020582344,
        -0.0435539795,
        -0.0453967793,
         0.0135097445,
         0.0860419607,
         0.0872933934,
        -0.0209436066,
        -0.1665000923,
        -0.1951485556,
         0.0131162221,
         0.4281547048,
         0.8570008521,
         1.0605695828,
         0.9184672899,
         0.5151041323,
         0.0791583242,
        -0.1757542570,
        -0.1857075316,
        -0.0494424836,
         0.0748145905,
         0.0940526254,
         0.0285391664,
        -0.0385290284,
        -0.0483405109,
        -0.0104080216,
         0.0245500811
    },
    {
         0.0272169913,          /* Filter 79 */
        -0.0022845268,
        -0.0437092134,
        -0.0452384373,
         0.0139213097,
         0.0863038471,
         0.0870048002,
        -0.0217173812,
        -0.1670973520,
        -0.1947340265,
         0.0148464698,
         0.4305690525,
         0.8588300671,
         1.0607479544,
         0.9168878743,
         0.5126958814,
         0.0772238969,
        -0.1764186789,
        -0.1852428084,
        -0.0486373065,
         0.0752185993,
         0.0938718938,
         0.0281184069,
        -0.0387516756,
        -0.0482312941,
        -0.0101720543,
         0.0246461141
    },
    {
         0.0271619890,          /* Filter 80 */
        -0.0025108192,
        -0.0438644473,
        -0.0450800952,
         0.0143328749,
         0.0865657336,
         0.0867162070,
        -0.0224911559,
        -0.1676946117,
        -0.1943194973,
         0.0165767175,
         0.4329834002,
         0.8606592820,
         1.0609263260,
         0.9153084588,
         0.5102876305,
         0.0752894697,
        -0.1770831009,
        -0.1847780851,
        -0.0478321295,
         0.0756226081,
         0.0936911623,
         0.0276976473,
        -0.0389743227,
        -0.0481220773,
        -0.0099360869,
         0.0247421472
    },
    {
         0.0271023853,          /* Filter 81 */
        -0.0027386653,
        -0.0440150173,
        -0.0449144605,
         0.0147462453,
         0.0868193414,
         0.0864146191,
        -0.0232696953,
        -0.1682786845,
        -0.1938776882,
         0.0183309110,
         0.4353994391,
         0.8624626252,
         1.0610651108,
         0.9136994694,
         0.5078763167,
         0.0733763902,
        -0.1777193493,
        -0.1842971176,
        -0.0470291262,
         0.0760140212,
         0.0935007013,
         0.0272771075,
        -0.0391900087,
        -0.0480073163,
        -0.0097007032,
         0.0248336882
    },
    {
         0.0270427816,          /* Filter 82 */
        -0.0029665115,
        -0.0441655873,
        -0.0447488258,
         0.0151596157,
         0.0870729492,
         0.0861130312,
        -0.0240482346,
        -0.1688627572,
        -0.1934358791,
         0.0200851045,
         0.4378154780,
         0.8642659685,
         1.0612038957,
         0.9120904801,
         0.5054650030,
         0.0714633107,
        -0.1783555977,
        -0.1838161500,
        -0.0462261229,
         0.0764054343,
         0.0933102404,
         0.0268565677,
        -0.0394056948,
        -0.0478925554,
        -0.0094653195,
         0.0249252291
    },
    {
         0.0269831779,          /* Filter 83 */
        -0.0031943576,
        -0.0443161573,
        -0.0445831910,
         0.0155729860,
         0.0873265571,
         0.0858114433,
        -0.0248267740,
        -0.1694468299,
        -0.1929940700,
         0.0218392979,
         0.4402315169,
         0.8660693117,
         1.0613426805,
         0.9104814907,
         0.5030536893,
         0.0695502312,
        -0.1789918461,
        -0.1833351825,
        -0.0454231196,
         0.0767968474,
         0.0931197794,
         0.0264360279,
        -0.0396213808,
        -0.0477777944,
        -0.0092299358,
         0.0250167701
    },
    {
         0.0269235742,          /* Filter 84 */
        -0.0034222037,
        -0.0444667272,
        -0.0444175563,
         0.0159863564,
         0.0875801649,
         0.0855098554,
        -0.0256053134,
        -0.1700309027,
        -0.1925522609,
         0.0235934914,
         0.4426475558,
         0.8678726550,
         1.0614814654,
         0.9088725014,
         0.5006423756,
         0.0676371518,
        -0.1796280945,
        -0.1828542149,
        -0.0446201163,
         0.0771882605,
         0.0929293185,
         0.0260154882,
        -0.0398370668,
        -0.0476630334,
        -0.0089945521,
         0.0251083110
    },
    {
         0.0268593737,          /* Filter 85 */
        -0.0036514873,
        -0.0446125168,
        -0.0442446568,
         0.0164013409,
         0.0878253032,
         0.0851953011,
        -0.0263883089,
        -0.1706013989,
        -0.1920830312,
         0.0253713360,
         0.4450646987,
         0.8696496397,
         1.0615806250,
         0.9072343759,
         0.4982285989,
         0.0657457744,
        -0.1802362515,
        -0.1823573767,
        -0.0438196252,
         0.0775670064,
         0.0927292992,
         0.0255953729,
        -0.0400457367,
        -0.0475428313,
        -0.0087598778,
         0.0251953370
    },
    {
         0.0267951732,          /* Filter 86 */
        -0.0038807708,
        -0.0447583063,
        -0.0440717573,
         0.0168163255,
         0.0880704415,
         0.0848807469,
        -0.0271713045,
        -0.1711718950,
        -0.1916138014,
         0.0271491806,
         0.4474818415,
         0.8714266245,
         1.0616797846,
         0.9055962504,
         0.4958148222,
         0.0638543970,
        -0.1808444084,
        -0.1818605385,
        -0.0430191341,
         0.0779457523,
         0.0925292800,
         0.0251752576,
        -0.0402544065,
        -0.0474226293,
        -0.0085252035,
         0.0252823630
    },
    {
         0.0267309727,          /* Filter 87 */
        -0.0041100543,
        -0.0449040958,
        -0.0438988578,
         0.0172313100,
         0.0883155799,
         0.0845661927,
        -0.0279543000,
        -0.1717423912,
        -0.1911445716,
         0.0289270252,
         0.4498989843,
         0.8732036093,
         1.0617789442,
         0.9039581250,
         0.4934010456,
         0.0619630196,
        -0.1814525654,
        -0.1813637003,
        -0.0422186430,
         0.0783244982,
         0.0923292607,
         0.0247551423,
        -0.0404630764,
        -0.0473024272,
        -0.0082905293,
         0.0253693890
    },
    {
         0.0266667722,          /* Filter 88 */
        -0.0043393378,
        -0.0450498853,
        -0.0437259583,
         0.0176462945,
         0.0885607182,
         0.0842516385,
        -0.0287372955,
        -0.1723128874,
        -0.1906753418,
         0.0307048699,
         0.4523161271,
         0.8749805941,
         1.0618781038,
         0.9023199995,
         0.4909872689,
         0.0600716423,
        -0.1820607223,
        -0.1808668621,
        -0.0414181519,
         0.0787032441,
         0.0921292414,
         0.0243350270,
        -0.0406717462,
        -0.0471822251,
        -0.0080558550,
         0.0254564149
    },
    {
         0.0265979819,          /* Filter 89 */
        -0.0045699408,
        -0.0451907796,
        -0.0435458258,
         0.0180626999,
         0.0887971986,
         0.0839241524,
        -0.0295244340,
        -0.1728694192,
        -0.1901785586,
         0.0325060623,
         0.4547337842,
         0.8767307402,
         1.0619376106,
         0.9006531831,
         0.4885716279,
         0.0582023131,
        -0.1826408785,
        -0.1803545296,
        -0.0406205075,
         0.0790692576,
         0.0919198381,
         0.0239155392,
        -0.0408733488,
        -0.0470566871,
        -0.0078220148,
         0.0255389057
    },
    {
         0.0265291917,          /* Filter 90 */
        -0.0048005439,
        -0.0453316739,
        -0.0433656932,
         0.0184791053,
         0.0890336791,
         0.0835966663,
        -0.0303115725,
        -0.1734259510,
        -0.1896817755,
         0.0343072547,
         0.4571514412,
         0.8784808862,
         1.0619971174,
         0.8989863666,
         0.4861559870,
         0.0563329839,
        -0.1832210347,
        -0.1798421972,
        -0.0398228631,
         0.0794352710,
         0.0917104347,
         0.0234960514,
        -0.0410749513,
        -0.0469311491,
        -0.0075881746,
         0.0256213965
    },
    {
         0.0264604015,          /* Filter 91 */
        -0.0050311469,
        -0.0454725682,
        -0.0431855607,
         0.0188955107,
         0.0892701595,
         0.0832691803,
        -0.0310987111,
        -0.1739824828,
        -0.1891849924,
         0.0361084471,
         0.4595690983,
         0.8802310323,
         1.0620566241,
         0.8973195501,
         0.4837403461,
         0.0544636547,
        -0.1838011909,
        -0.1793298647,
        -0.0390252187,
         0.0798012844,
         0.0915010314,
         0.0230765636,
        -0.0412765538,
        -0.0468056111,
        -0.0073543344,
         0.0257038873
    },
    {
         0.0263916112,          /* Filter 92 */
        -0.0052617500,
        -0.0456134625,
        -0.0430054281,
         0.0193119161,
         0.0895066400,
         0.0829416942,
        -0.0318858496,
        -0.1745390147,
        -0.1886882093,
         0.0379096396,
         0.4619867553,
         0.8819811784,
         1.0621161309,
         0.8956527337,
         0.4813247051,
         0.0525943255,
        -0.1843813471,
        -0.1788175322,
        -0.0382275743,
         0.0801672978,
         0.0912916280,
         0.0226570758,
        -0.0414781564,
        -0.0466800732,
        -0.0071204942,
         0.0257863781
    },
    {
         0.0263182409,          /* Filter 93 */
        -0.0054935532,
        -0.0457493485,
        -0.0428180982,
         0.0197295470,
         0.0897342768,
         0.0826013169,
        -0.0326768135,
        -0.1750811963,
        -0.1881637484,
         0.0397338678,
         0.4644043347,
         0.8837040122,
         1.0621359683,
         0.8939576787,
         0.4789077971,
         0.0507473822,
        -0.1849336018,
        -0.1782900845,
        -0.0374331070,
         0.0805205196,
         0.0910730178,
         0.0222384168,
        -0.0416726443,
        -0.0465493065,
        -0.0068876114,
         0.0258643161
    },
    {
         0.0262448706,          /* Filter 94 */
        -0.0057253565,
        -0.0458852346,
        -0.0426307682,
         0.0201471779,
         0.0899619136,
         0.0822609396,
        -0.0334677774,
        -0.1756233779,
        -0.1876392875,
         0.0415580960,
         0.4668219142,
         0.8854268461,
         1.0621558058,
         0.8922626237,
         0.4764908891,
         0.0489004389,
        -0.1854858565,
        -0.1777626367,
        -0.0366386397,
         0.0808737414,
         0.0908544077,
         0.0218197578,
        -0.0418671323,
        -0.0464185399,
        -0.0066547286,
         0.0259422541
    },
    {
         0.0261715004,          /* Filter 95 */
        -0.0059571598,
        -0.0460211206,
        -0.0424434382,
         0.0205648088,
         0.0901895505,
         0.0819205623,
        -0.0342587413,
        -0.1761655596,
        -0.1871148267,
         0.0433823242,
         0.4692394936,
         0.8871496799,
         1.0621756432,
         0.8905675688,
         0.4740739811,
         0.0470534957,
        -0.1860381112,
        -0.1772351890,
        -0.0358441724,
         0.0812269632,
         0.0906357975,
         0.0214010988,
        -0.0420616202,
        -0.0462877733,
        -0.0064218458,
         0.0260201921
    },
    {
         0.0260981301,          /* Filter 96 */
        -0.0061889631,
        -0.0461570066,
        -0.0422561082,
         0.0209824397,
         0.0904171873,
         0.0815801850,
        -0.0350497051,
        -0.1767077412,
        -0.1865903658,
         0.0452065524,
         0.4716570731,
         0.8888725138,
         1.0621954806,
         0.8888725138,
         0.4716570731,
         0.0452065524,
        -0.1865903658,
        -0.1767077412,
        -0.0350497051,
         0.0815801850,
         0.0904171873,
         0.0209824397,
        -0.0422561082,
        -0.0461570066,
        -0.0061889631,
         0.0260981301
    },
    {
         0.0260201921,          /* Filter 97 */
        -0.0064218458,
        -0.0462877733,
        -0.0420616202,
         0.0214010988,
         0.0906357975,
         0.0812269632,
        -0.0358441724,
        -0.1772351890,
        -0.1860381112,
         0.0470534957,
         0.4740739811,
         0.8905675688,
         1.0621756432,
         0.8871496799,
         0.4692394936,
         0.0433823242,
        -0.1871148267,
        -0.1761655596,
        -0.0342587413,
         0.0819205623,
         0.0901895505,
         0.0205648088,
        -0.0424434382,
        -0.0460211206,
        -0.0059571598,
         0.0261715004
    },
    {
         0.0259422541,          /* Filter 98 */
        -0.0066547286,
        -0.0464185399,
        -0.0418671323,
         0.0218197578,
         0.0908544077,
         0.0808737414,
        -0.0366386397,
        -0.1777626367,
        -0.1854858565,
         0.0489004389,
         0.4764908891,
         0.8922626237,
         1.0621558058,
         0.8854268461,
         0.4668219142,
         0.0415580960,
        -0.1876392875,
        -0.1756233779,
        -0.0334677774,
         0.0822609396,
         0.0899619136,
         0.0201471779,
        -0.0426307682,
        -0.0458852346,
        -0.0057253565,
         0.0262448706
    },
    {
         0.0258643161,          /* Filter 99 */
        -0.0068876114,
        -0.0465493065,
        -0.0416726443,
         0.0222384168,
         0.0910730178,
         0.0805205196,
        -0.0374331070,
        -0.1782900845,
        -0.1849336018,
         0.0507473822,
         0.4789077971,
         0.8939576787,
         1.0621359683,
         0.8837040122,
         0.4644043347,
         0.0397338678,
        -0.1881637484,
        -0.1750811963,
        -0.0326768135,
         0.0826013169,
         0.0897342768,
         0.0197295470,
        -0.0428180982,
        -0.0457493485,
        -0.0054935532,
         0.0263182409
    },
    {
         0.0257863781,          /* Filter 100 */
        -0.0071204942,
        -0.0466800732,
        -0.0414781564,
         0.0226570758,
         0.0912916280,
         0.0801672978,
        -0.0382275743,
        -0.1788175322,
        -0.1843813471,
         0.0525943255,
         0.4813247051,
         0.8956527337,
         1.0621161309,
         0.8819811784,
         0.4619867553,
         0.0379096396,
        -0.1886882093,
        -0.1745390147,
        -0.0318858496,
         0.0829416942,
         0.0895066400,
         0.0193119161,
        -0.0430054281,
        -0.0456134625,
        -0.0052617500,
         0.0263916112
    },
    {
         0.0257038873,          /* Filter 101 */
        -0.0073543344,
        -0.0468056111,
        -0.0412765538,
         0.0230765636,
         0.0915010314,
         0.0798012844,
        -0.0390252187,
        -0.1793298647,
        -0.1838011909,
         0.0544636547,
         0.4837403461,
         0.8973195501,
         1.0620566241,
         0.8802310323,
         0.4595690983,
         0.0361084471,
        -0.1891849924,
        -0.1739824828,
        -0.0310987111,
         0.0832691803,
         0.0892701595,
         0.0188955107,
        -0.0431855607,
        -0.0454725682,
        -0.0050311469,
         0.0264604015
    },
    {
         0.0256213965,          /* Filter 102 */
        -0.0075881746,
        -0.0469311491,
        -0.0410749513,
         0.0234960514,
         0.0917104347,
         0.0794352710,
        -0.0398228631,
        -0.1798421972,
        -0.1832210347,
         0.0563329839,
         0.4861559870,
         0.8989863666,
         1.0619971174,
         0.8784808862,
         0.4571514412,
         0.0343072547,
        -0.1896817755,
        -0.1734259510,
        -0.0303115725,
         0.0835966663,
         0.0890336791,
         0.0184791053,
        -0.0433656932,
        -0.0453316739,
        -0.0048005439,
         0.0265291917
    },
    {
         0.0255389057,          /* Filter 103 */
        -0.0078220148,
        -0.0470566871,
        -0.0408733488,
         0.0239155392,
         0.0919198381,
         0.0790692576,
        -0.0406205075,
        -0.1803545296,
        -0.1826408785,
         0.0582023131,
         0.4885716279,
         0.9006531831,
         1.0619376106,
         0.8767307402,
         0.4547337842,
         0.0325060623,
        -0.1901785586,
        -0.1728694192,
        -0.0295244340,
         0.0839241524,
         0.0887971986,
         0.0180626999,
        -0.0435458258,
        -0.0451907796,
        -0.0045699408,
         0.0265979819
    },
    {
         0.0254564149,          /* Filter 104 */
        -0.0080558550,
        -0.0471822251,
        -0.0406717462,
         0.0243350270,
         0.0921292414,
         0.0787032441,
        -0.0414181519,
        -0.1808668621,
        -0.1820607223,
         0.0600716423,
         0.4909872689,
         0.9023199995,
         1.0618781038,
         0.8749805941,
         0.4523161271,
         0.0307048699,
        -0.1906753418,
        -0.1723128874,
        -0.0287372955,
         0.0842516385,
         0.0885607182,
         0.0176462945,
        -0.0437259583,
        -0.0450498853,
        -0.0043393378,
         0.0266667722
    },
    {
         0.0253693890,          /* Filter 105 */
        -0.0082905293,
        -0.0473024272,
        -0.0404630764,
         0.0247551423,
         0.0923292607,
         0.0783244982,
        -0.0422186430,
        -0.1813637003,
        -0.1814525654,
         0.0619630196,
         0.4934010456,
         0.9039581250,
         1.0617789442,
         0.8732036093,
         0.4498989843,
         0.0289270252,
        -0.1911445716,
        -0.1717423912,
        -0.0279543000,
         0.0845661927,
         0.0883155799,
         0.0172313100,
        -0.0438988578,
        -0.0449040958,
        -0.0041100543,
         0.0267309727
    },
    {
         0.0252823630,          /* Filter 106 */
        -0.0085252035,
        -0.0474226293,
        -0.0402544065,
         0.0251752576,
         0.0925292800,
         0.0779457523,
        -0.0430191341,
        -0.1818605385,
        -0.1808444084,
         0.0638543970,
         0.4958148222,
         0.9055962504,
         1.0616797846,
         0.8714266245,
         0.4474818415,
         0.0271491806,
        -0.1916138014,
        -0.1711718950,
        -0.0271713045,
         0.0848807469,
         0.0880704415,
         0.0168163255,
        -0.0440717573,
        -0.0447583063,
        -0.0038807708,
         0.0267951732
    },
    {
         0.0251953370,          /* Filter 107 */
        -0.0087598778,
        -0.0475428313,
        -0.0400457367,
         0.0255953729,
         0.0927292992,
         0.0775670064,
        -0.0438196252,
        -0.1823573767,
        -0.1802362515,
         0.0657457744,
         0.4982285989,
         0.9072343759,
         1.0615806250,
         0.8696496397,
         0.4450646987,
         0.0253713360,
        -0.1920830312,
        -0.1706013989,
        -0.0263883089,
         0.0851953011,
         0.0878253032,
         0.0164013409,
        -0.0442446568,
        -0.0446125168,
        -0.0036514873,
         0.0268593737
    },
    {
         0.0251083110,          /* Filter 108 */
        -0.0089945521,
        -0.0476630334,
        -0.0398370668,
         0.0260154882,
         0.0929293185,
         0.0771882605,
        -0.0446201163,
        -0.1828542149,
        -0.1796280945,
         0.0676371518,
         0.5006423756,
         0.9088725014,
         1.0614814654,
         0.8678726550,
         0.4426475558,
         0.0235934914,
        -0.1925522609,
        -0.1700309027,
        -0.0256053134,
         0.0855098554,
         0.0875801649,
         0.0159863564,
        -0.0444175563,
        -0.0444667272,
        -0.0034222037,
         0.0269235742
    },
    {
         0.0250167701,          /* Filter 109 */
        -0.0092299358,
        -0.0477777944,
        -0.0396213808,
         0.0264360279,
         0.0931197794,
         0.0767968474,
        -0.0454231196,
        -0.1833351825,
        -0.1789918461,
         0.0695502312,
         0.5030536893,
         0.9104814907,
         1.0613426805,
         0.8660693117,
         0.4402315169,
         0.0218392979,
        -0.1929940700,
        -0.1694468299,
        -0.0248267740,
         0.0858114433,
         0.0873265571,
         0.0155729860,
        -0.0445831910,
        -0.0443161573,
        -0.0031943576,
         0.0269831779
    },
    {
         0.0249252291,          /* Filter 110 */
        -0.0094653195,
        -0.0478925554,
        -0.0394056948,
         0.0268565677,
         0.0933102404,
         0.0764054343,
        -0.0462261229,
        -0.1838161500,
        -0.1783555977,
         0.0714633107,
         0.5054650030,
         0.9120904801,
         1.0612038957,
         0.8642659685,
         0.4378154780,
         0.0200851045,
        -0.1934358791,
        -0.1688627572,
        -0.0240482346,
         0.0861130312,
         0.0870729492,
         0.0151596157,
        -0.0447488258,
        -0.0441655873,
        -0.0029665115,
         0.0270427816
    },
    {
         0.0248336882,          /* Filter 111 */
        -0.0097007032,
        -0.0480073163,
        -0.0391900087,
         0.0272771075,
         0.0935007013,
         0.0760140212,
        -0.0470291262,
        -0.1842971176,
        -0.1777193493,
         0.0733763902,
         0.5078763167,
         0.9136994694,
         1.0610651108,
         0.8624626252,
         0.4353994391,
         0.0183309110,
        -0.1938776882,
        -0.1682786845,
        -0.0232696953,
         0.0864146191,
         0.0868193414,
         0.0147462453,
        -0.0449144605,
        -0.0440150173,
        -0.0027386653,
         0.0271023853
    },
    {
         0.0247421472,          /* Filter 112 */
        -0.0099360869,
        -0.0481220773,
        -0.0389743227,
         0.0276976473,
         0.0936911623,
         0.0756226081,
        -0.0478321295,
        -0.1847780851,
        -0.1770831009,
         0.0752894697,
         0.5102876305,
         0.9153084588,
         1.0609263260,
         0.8606592820,
         0.4329834002,
         0.0165767175,
        -0.1943194973,
        -0.1676946117,
        -0.0224911559,
         0.0867162070,
         0.0865657336,
         0.0143328749,
        -0.0450800952,
        -0.0438644473,
        -0.0025108192,
         0.0271619890
    },
    {
         0.0246461141,          /* Filter 113 */
        -0.0101720543,
        -0.0482312941,
        -0.0387516756,
         0.0281184069,
         0.0938718938,
         0.0752185993,
        -0.0486373065,
        -0.1852428084,
        -0.1764186789,
         0.0772238969,
         0.5126958814,
         0.9168878743,
         1.0607479544,
         0.8588300671,
         0.4305690525,
         0.0148464698,
        -0.1947340265,
        -0.1670973520,
        -0.0217173812,
         0.0870048002,
         0.0863038471,
         0.0139213097,
        -0.0452384373,
        -0.0437092134,
        -0.0022845268,
         0.0272169913
    },
    {
         0.0245500811,          /* Filter 114 */
        -0.0104080216,
        -0.0483405109,
        -0.0385290284,
         0.0285391664,
         0.0940526254,
         0.0748145905,
        -0.0494424836,
        -0.1857075316,
        -0.1757542570,
         0.0791583242,
         0.5151041323,
         0.9184672899,
         1.0605695828,
         0.8570008521,
         0.4281547048,
         0.0131162221,
        -0.1951485556,
        -0.1665000923,
        -0.0209436066,
         0.0872933934,
         0.0860419607,
         0.0135097445,
        -0.0453967793,
        -0.0435539795,
        -0.0020582344,
         0.0272719937
    },
    {
         0.0244540480,          /* Filter 115 */
        -0.0106439890,
        -0.0484497276,
        -0.0383063813,
         0.0289599260,
         0.0942333569,
         0.0744105818,
        -0.0502476607,
        -0.1861722549,
        -0.1750898350,
         0.0810927514,
         0.5175123832,
         0.9200467055,
         1.0603912113,
         0.8551716372,
         0.4257403572,
         0.0113859744,
        -0.1955630848,
        -0.1659028327,
        -0.0201698319,
         0.0875819866,
         0.0857800742,
         0.0130981793,
        -0.0455551214,
        -0.0433987455,
        -0.0018319419,
         0.0273269961
    },
    {
         0.0243580149,          /* Filter 116 */
        -0.0108799564,
        -0.0485589444,
        -0.0380837342,
         0.0293806855,
         0.0944140884,
         0.0740065730,
        -0.0510528377,
        -0.1866369781,
        -0.1744254131,
         0.0830271786,
         0.5199206341,
         0.9216261210,
         1.0602128397,
         0.8533424222,
         0.4233260095,
         0.0096557267,
        -0.1959776139,
        -0.1653055730,
        -0.0193960573,
         0.0878705798,
         0.0855181878,
         0.0126866141,
        -0.0457134635,
        -0.0432435116,
        -0.0016056495,
         0.0273819985
    },
    {
         0.0242575152,          /* Filter 117 */
        -0.0111163804,
        -0.0486625161,
        -0.0378541849,
         0.0298014585,
         0.0945849227,
         0.0735900463,
        -0.0518598462,
        -0.1870850863,
        -0.1737327442,
         0.0849825910,
         0.5223252212,
         0.9231755327,
         1.0599949310,
         0.8514878288,
         0.4209139378,
         0.0079497104,
        -0.1963650120,
        -0.1646955176,
        -0.0186273513,
         0.0881461560,
         0.0852482160,
         0.0122770428,
        -0.0458644889,
        -0.0430837318,
        -0.0013810255,
         0.0274323977
    },
    {
         0.0241570155,          /* Filter 118 */
        -0.0113528045,
        -0.0487660878,
        -0.0376246355,
         0.0302222314,
         0.0947557570,
         0.0731735196,
        -0.0526668547,
        -0.1875331946,
        -0.1730400753,
         0.0869380034,
         0.5247298084,
         0.9247249445,
         1.0597770223,
         0.8496332353,
         0.4185018661,
         0.0062436942,
        -0.1967524100,
        -0.1640854623,
        -0.0178586454,
         0.0884217321,
         0.0849782443,
         0.0118674716,
        -0.0460155144,
        -0.0429239521,
        -0.0011564016,
         0.0274827969
    },
    {
         0.0240565159,          /* Filter 119 */
        -0.0115892286,
        -0.0488696594,
        -0.0373950862,
         0.0306430044,
         0.0949265913,
         0.0727569930,
        -0.0534738632,
        -0.1879813028,
        -0.1723474065,
         0.0888934157,
         0.5271343955,
         0.9262743562,
         1.0595591135,
         0.8477786418,
         0.4160897945,
         0.0045376780,
        -0.1971398080,
        -0.1634754069,
        -0.0170899394,
         0.0886973083,
         0.0847082726,
         0.0114579004,
        -0.0461665398,
        -0.0427641724,
        -0.0009317776,
         0.0275331961
    },
    {
         0.0239560162,          /* Filter 120 */
        -0.0118256527,
        -0.0489732311,
        -0.0371655369,
         0.0310637773,
         0.0950974255,
         0.0723404663,
        -0.0542808717,
        -0.1884294110,
        -0.1716547376,
         0.0908488281,
         0.5295389827,
         0.9278237679,
         1.0593412048,
         0.8459240484,
         0.4136777228,
         0.0028316618,
        -0.1975272061,
        -0.1628653515,
        -0.0163212335,
         0.0889728845,
         0.0844383008,
         0.0110483291,
        -0.0463175652,
        -0.0426043926,
        -0.0007071536,
         0.0275835953
    },
    {
         0.0238510780,          /* Filter 121 */
        -0.0120624055,
        -0.0490710590,
        -0.0369291483,
         0.0314843558,
         0.0952581980,
         0.0719115057,
        -0.0550893655,
        -0.1888605364,
        -0.1709337572,
         0.0928248549,
         0.5319393043,
         0.9293427535,
         1.0590838194,
         0.8440445758,
         0.4112685092,
         0.0011501539,
        -0.1978876297,
        -0.1622428933,
        -0.0155578954,
         0.0892354273,
         0.0841604394,
         0.0106409383,
        -0.0464612538,
        -0.0424401868,
        -0.0004843113,
         0.0276293920
    },
    {
         0.0237461398,          /* Filter 122 */
        -0.0122991583,
        -0.0491688869,
        -0.0366927596,
         0.0319049342,
         0.0954189705,
         0.0714825451,
        -0.0558978594,
        -0.1892916619,
        -0.1702127767,
         0.0948008816,
         0.5343396259,
         0.9308617391,
         1.0588264340,
         0.8421651031,
         0.4088592957,
        -0.0005313539,
        -0.1982480534,
        -0.1616204351,
        -0.0147945573,
         0.0894979702,
         0.0838825779,
         0.0102335475,
        -0.0466049424,
        -0.0422759809,
        -0.0002614689,
         0.0276751887
    },
    {
         0.0236412017,          /* Filter 123 */
        -0.0125359112,
        -0.0492667149,
        -0.0364563709,
         0.0323255127,
         0.0955797430,
         0.0710535846,
        -0.0567063533,
        -0.1897227874,
        -0.1694917963,
         0.0967769084,
         0.5367399476,
         0.9323807248,
         1.0585690487,
         0.8402856305,
         0.4064500821,
        -0.0022128618,
        -0.1986084771,
        -0.1609979768,
        -0.0140312193,
         0.0897605130,
         0.0836047165,
         0.0098261567,
        -0.0467486310,
        -0.0421117751,
        -0.0000386265,
         0.0277209854
    },
    {
         0.0235362635,          /* Filter 124 */
        -0.0127726640,
        -0.0493645428,
        -0.0362199823,
         0.0327460911,
         0.0957405154,
         0.0706246240,
        -0.0575148472,
        -0.1901539128,
        -0.1687708158,
         0.0987529352,
         0.5391402692,
         0.9338997104,
         1.0583116633,
         0.8384061579,
         0.4040408685,
        -0.0038943696,
        -0.1989689008,
        -0.1603755186,
        -0.0132678812,
         0.0900230559,
         0.0833268551,
         0.0094187658,
        -0.0468923197,
        -0.0419475693,
         0.0001842159,
         0.0277667821
    },
    {
         0.0234269176,          /* Filter 125 */
        -0.0130096166,
        -0.0494565306,
        -0.0359768210,
         0.0331662657,
         0.0958910650,
         0.0701833198,
        -0.0583244767,
        -0.1905676911,
        -0.1680214680,
         0.1007491976,
         0.5415357228,
         0.9353878555,
         1.0580148728,
         0.8365023116,
         0.4016350922,
        -0.0055511012,
        -0.1993025148,
        -0.1597410516,
        -0.0125102054,
         0.0902725551,
         0.0830413018,
         0.0090137394,
        -0.0470286551,
        -0.0417790585,
         0.0004051652,
         0.0278079796
    },
    {
         0.0233175718,          /* Filter 126 */
        -0.0132465692,
        -0.0495485184,
        -0.0357336596,
         0.0335864403,
         0.0960416146,
         0.0697420156,
        -0.0591341063,
        -0.1909814693,
        -0.1672721201,
         0.1027454600,
         0.5439311765,
         0.9368760006,
         1.0577180822,
         0.8345984652,
         0.3992293159,
        -0.0072078328,
        -0.1996361287,
        -0.1591065847,
        -0.0117525296,
         0.0905220543,
         0.0827557485,
         0.0086087131,
        -0.0471649906,
        -0.0416105478,
         0.0006261145,
         0.0278491771
    },
    {
         0.0232082259,          /* Filter 127 */
        -0.0134835218,
        -0.0496405062,
        -0.0354904983,
         0.0340066150,
         0.0961921641,
         0.0693007114,
        -0.0599437358,
        -0.1913952475,
        -0.1665227723,
         0.1047417224,
         0.5463266301,
         0.9383641457,
         1.0574212916,
         0.8326946189,
         0.3968235396,
        -0.0088645644,
        -0.1999697427,
        -0.1584721177,
        -0.0109948538,
         0.0907715535,
         0.0824701952,
         0.0082036867,
        -0.0473013261,
        -0.0414420371,
         0.0008470639,
         0.0278903746
    },
    {
         0.0230988800,          /* Filter 128 */
        -0.0137204743,
        -0.0497324940,
        -0.0352473370,
         0.0344267896,
         0.0963427137,
         0.0688594072,
        -0.0607533654,
        -0.1918090257,
        -0.1657734244,
         0.1067379848,
         0.5487220838,
         0.9398522908,
         1.0571245011,
         0.8307907726,
         0.3944177633,
        -0.0105212960,
        -0.2003033567,
        -0.1578376507,
        -0.0102371780,
         0.0910210527,
         0.0821846419,
         0.0077986603,
        -0.0474376615,
        -0.0412735264,
         0.0010680132,
         0.0279315720
    },
    {
         0.0229851599,          /* Filter 129 */
        -0.0139574968,
        -0.0498185477,
        -0.0349974736,
         0.0348463496,
         0.0964828828,
         0.0684058560,
        -0.0615637774,
        -0.1922050956,
        -0.1649956622,
         0.1087540962,
         0.5511120665,
         0.9413091892,
         1.0567883878,
         0.8288630638,
         0.3920160003,
        -0.0121529924,
        -0.2006103333,
        -0.1571915704,
        -0.0094854539,
         0.0912575039,
         0.0818915967,
         0.0073961798,
        -0.0475666313,
        -0.0411008334,
         0.0012869597,
         0.0279681761
    },
    {
         0.0228714397,          /* Filter 130 */
        -0.0141945192,
        -0.0499046014,
        -0.0347476102,
         0.0352659097,
         0.0966230519,
         0.0679523047,
        -0.0623741895,
        -0.1926011654,
        -0.1642179000,
         0.1107702076,
         0.5535020493,
         0.9427660875,
         1.0564522745,
         0.8269353551,
         0.3896142374,
        -0.0137846887,
        -0.2009173100,
        -0.1565454900,
        -0.0087337299,
         0.0914939550,
         0.0815985515,
         0.0069936994,
        -0.0476956011,
        -0.0409281405,
         0.0015059063,
         0.0280047802
    },
    {
         0.0227577196,          /* Filter 131 */
        -0.0144315416,
        -0.0499906552,
        -0.0344977469,
         0.0356854698,
         0.0967632210,
         0.0674987534,
        -0.0631846015,
        -0.1929972353,
        -0.1634401378,
         0.1127863189,
         0.5558920321,
         0.9442229858,
         1.0561161613,
         0.8250076464,
         0.3872124744,
        -0.0154163851,
        -0.2012242867,
        -0.1558994097,
        -0.0079820058,
         0.0917304062,
         0.0813055063,
         0.0065912190,
        -0.0478245709,
        -0.0407554476,
         0.0017248528,
         0.0280413842
    },
    {
         0.0226439994,          /* Filter 132 */
        -0.0146685640,
        -0.0500767089,
        -0.0342478835,
         0.0361050299,
         0.0969033901,
         0.0670452021,
        -0.0639950135,
        -0.1933933051,
        -0.1626623755,
         0.1148024303,
         0.5582820148,
         0.9456798841,
         1.0557800480,
         0.8230799377,
         0.3848107115,
        -0.0170480815,
        -0.2015312634,
        -0.1552533293,
        -0.0072302817,
         0.0919668574,
         0.0810124611,
         0.0061887386,
        -0.0479535407,
        -0.0405827546,
         0.0019437993,
         0.0280779883
    },
    {
         0.0225259411,          /* Filter 133 */
        -0.0149055255,
        -0.0501567370,
        -0.0339913924,
         0.0365237635,
         0.0970330248,
         0.0665795066,
        -0.0648058514,
        -0.1937713089,
        -0.1618561609,
         0.1168379961,
         0.5606659235,
         0.9471051374,
         1.0554047053,
         0.8211288836,
         0.3824135348,
        -0.0186544929,
        -0.2018117828,
        -0.1545960320,
        -0.0064847939,
         0.0921902622,
         0.0807121259,
         0.0057889831,
        -0.0480751361,
        -0.0404060035,
         0.0021606351,
         0.0281100073
    },
    {
         0.0224078827,          /* Filter 134 */
        -0.0151424869,
        -0.0502367651,
        -0.0337349014,
         0.0369424970,
         0.0971626594,
         0.0661138110,
        -0.0656166893,
        -0.1941493128,
        -0.1610499463,
         0.1188735619,
         0.5630498322,
         0.9485303907,
         1.0550293626,
         0.8191778295,
         0.3800163581,
        -0.0202609042,
        -0.2020923023,
        -0.1539387346,
        -0.0057393060,
         0.0924136669,
         0.0804117907,
         0.0053892276,
        -0.0481967315,
        -0.0402292523,
         0.0023774709,
         0.0281420263
    },
    {
         0.0222898243,          /* Filter 135 */
        -0.0153794484,
        -0.0503167932,
        -0.0334784104,
         0.0373612306,
         0.0972922941,
         0.0656481155,
        -0.0664275272,
        -0.1945273166,
        -0.1602437317,
         0.1209091276,
         0.5654337409,
         0.9499556441,
         1.0546540198,
         0.8172267755,
         0.3776191813,
        -0.0218673155,
        -0.2023728217,
        -0.1532814373,
        -0.0049938182,
         0.0926370717,
         0.0801114555,
         0.0049894721,
        -0.0483183269,
        -0.0400525011,
         0.0025943067,
         0.0281740453
    },
    {
         0.0221717660,          /* Filter 136 */
        -0.0156164098,
        -0.0503968213,
        -0.0332219194,
         0.0377799642,
         0.0974219288,
         0.0651824199,
        -0.0672383651,
        -0.1949053204,
        -0.1594375171,
         0.1229446934,
         0.5678176496,
         0.9513808974,
         1.0542786771,
         0.8152757214,
         0.3752220046,
        -0.0234737269,
        -0.2026533412,
        -0.1526241400,
        -0.0042483303,
         0.0928604764,
         0.0798111203,
         0.0045897167,
        -0.0484399222,
        -0.0398757500,
         0.0028111425,
         0.0282060643
    },
    {
         0.0220494080,          /* Filter 137 */
        -0.0158531787,
        -0.0504707347,
        -0.0329588790,
         0.0381976581,
         0.0975408787,
         0.0647046892,
        -0.0680492690,
        -0.1952649043,
        -0.1586028211,
         0.1249993114,
         0.5701948809,
         0.9527741159,
         1.0538642091,
         0.8133018446,
         0.3728299835,
        -0.0250546124,
        -0.2029075910,
        -0.1519560229,
        -0.0035093581,
         0.0930708421,
         0.0795036990,
         0.0041928625,
        -0.0485541383,
        -0.0396950659,
         0.0030257614,
         0.0282335091
    },
    {
         0.0219270501,          /* Filter 138 */
        -0.0160899476,
        -0.0505446481,
        -0.0326958387,
         0.0386153521,
         0.0976598287,
         0.0642269584,
        -0.0688601728,
        -0.1956244881,
        -0.1577681250,
         0.1270539293,
         0.5725721122,
         0.9541673345,
         1.0534497412,
         0.8113279677,
         0.3704379624,
        -0.0266354980,
        -0.2031618409,
        -0.1512879059,
        -0.0027703858,
         0.0932812079,
         0.0791962776,
         0.0037960083,
        -0.0486683543,
        -0.0395143818,
         0.0032403803,
         0.0282609539
    },
    {
         0.0218046922,          /* Filter 139 */
        -0.0163267165,
        -0.0506185616,
        -0.0324327983,
         0.0390330460,
         0.0977787787,
         0.0637492276,
        -0.0696710766,
        -0.1959840719,
        -0.1569334290,
         0.1291085472,
         0.5749493436,
         0.9555605530,
         1.0530352732,
         0.8093540909,
         0.3680459413,
        -0.0282163835,
        -0.2034160908,
        -0.1506197889,
        -0.0020314136,
         0.0934915736,
         0.0788888562,
         0.0033991541,
        -0.0487825704,
        -0.0393336978,
         0.0034549992,
         0.0282883987
    },
    {
         0.0216823343,          /* Filter 140 */
        -0.0165634853,
        -0.0506924750,
        -0.0321697579,
         0.0394507399,
         0.0978977287,
         0.0632714968,
        -0.0704819805,
        -0.1963436557,
        -0.1560987329,
         0.1311631652,
         0.5773265749,
         0.9569537715,
         1.0526208053,
         0.8073802140,
         0.3656539202,
        -0.0297972690,
        -0.2036703407,
        -0.1499516718,
        -0.0012924414,
         0.0937019393,
         0.0785814349,
         0.0030022999,
        -0.0488967864,
        -0.0391530137,
         0.0036696181,
         0.0283158435
    },
    {
         0.0215557181,          /* Filter 141 */
        -0.0167999292,
        -0.0507601873,
        -0.0319002503,
         0.0398671800,
         0.0980058476,
         0.0627818462,
        -0.0712925872,
        -0.1966844694,
        -0.1552355354,
         0.1332364254,
         0.5796965257,
         0.9583145739,
         1.0521673271,
         0.8053840424,
         0.3632676206,
        -0.0313523972,
        -0.2038985161,
        -0.1492731331,
        -0.0005602590,
         0.0938992792,
         0.0782671329,
         0.0026085207,
        -0.0490036219,
        -0.0389685232,
         0.0038819158,
         0.0283387275
    },
    {
         0.0214291019,          /* Filter 142 */
        -0.0170363732,
        -0.0508278996,
        -0.0316307427,
         0.0402836201,
         0.0981139665,
         0.0622921956,
        -0.0721031939,
        -0.1970252830,
        -0.1543723380,
         0.1353096856,
         0.5820664765,
         0.9596753762,
         1.0517138489,
         0.8033878707,
         0.3608813210,
        -0.0329075253,
        -0.2041266915,
        -0.1485945944,
         0.0001719234,
         0.0940966192,
         0.0779528310,
         0.0022147415,
        -0.0491104574,
        -0.0387840327,
         0.0040942135,
         0.0283616115
    },
    {
         0.0213024858,          /* Filter 143 */
        -0.0172728171,
        -0.0508956118,
        -0.0313612352,
         0.0407000601,
         0.0982220854,
         0.0618025449,
        -0.0729138006,
        -0.1973660966,
        -0.1535091405,
         0.1373829458,
         0.5844364273,
         0.9610361786,
         1.0512603707,
         0.8013916991,
         0.3584950213,
        -0.0344626534,
        -0.2043548669,
        -0.1479160557,
         0.0009041058,
         0.0942939591,
         0.0776385291,
         0.0018209622,
        -0.0492172929,
        -0.0385995423,
         0.0043065112,
         0.0283844955
    },
    {
         0.0211758696,          /* Filter 144 */
        -0.0175092610,
        -0.0509633241,
        -0.0310917276,
         0.0411165002,
         0.0983302043,
         0.0613128943,
        -0.0737244073,
        -0.1977069103,
        -0.1526459430,
         0.1394562060,
         0.5868063781,
         0.9623969809,
         1.0508068925,
         0.7993955274,
         0.3561087217,
        -0.0360177816,
        -0.2045830423,
        -0.1472375170,
         0.0016362882,
         0.0944912991,
         0.0773242271,
         0.0014271830,
        -0.0493241283,
        -0.0384150518,
         0.0045188089,
         0.0284073795
    },
    {
         0.0210450391,          /* Filter 145 */
        -0.0177452469,
        -0.0510247514,
        -0.0308158387,
         0.0415314712,
         0.0984273495,
         0.0608114453,
        -0.0745343508,
        -0.1980286075,
        -0.1517542331,
         0.1415476910,
         0.5891684456,
         0.9637249942,
         1.0503145299,
         0.7973775941,
         0.3537287056,
        -0.0375469299,
        -0.2047853458,
        -0.1465489553,
         0.0023614117,
         0.0946756322,
         0.0770032519,
         0.0010366496,
        -0.0494235858,
        -0.0382268826,
         0.0047286830,
         0.0284257186
    },
    {
         0.0209142086,          /* Filter 146 */
        -0.0179812328,
        -0.0510861786,
        -0.0305399498,
         0.0419464421,
         0.0985244948,
         0.0603099964,
        -0.0753442942,
        -0.1983503047,
        -0.1508625233,
         0.1436391761,
         0.5915305130,
         0.9650530076,
         1.0498221673,
         0.7953596608,
         0.3513486894,
        -0.0390760782,
        -0.2049876492,
        -0.1458603935,
         0.0030865352,
         0.0948599654,
         0.0766822767,
         0.0006461162,
        -0.0495230433,
        -0.0380387134,
         0.0049385571,
         0.0284440576
    },
    {
         0.0207833780,          /* Filter 147 */
        -0.0182172187,
        -0.0511476059,
        -0.0302640610,
         0.0423614131,
         0.0986216400,
         0.0598085475,
        -0.0761542377,
        -0.1986720020,
        -0.1499708135,
         0.1457306611,
         0.5938925804,
         0.9663810209,
         1.0493298047,
         0.7933417275,
         0.3489686733,
        -0.0406052265,
        -0.2051899526,
        -0.1451718318,
         0.0038116586,
         0.0950442986,
         0.0763613015,
         0.0002555828,
        -0.0496225007,
        -0.0378505442,
         0.0051484313,
         0.0284623966
    },
    {
         0.0206525475,          /* Filter 148 */
        -0.0184532046,
        -0.0512090332,
        -0.0299881721,
         0.0427763841,
         0.0987187853,
         0.0593070986,
        -0.0769641811,
        -0.1989936992,
        -0.1490791036,
         0.1478221462,
         0.5962546478,
         0.9677090342,
         1.0488374421,
         0.7913237942,
         0.3465886571,
        -0.0421343748,
        -0.2053922561,
        -0.1444832701,
         0.0045367821,
         0.0952286318,
         0.0760403263,
        -0.0001349506,
        -0.0497219582,
        -0.0376623750,
         0.0053583054,
         0.0284807357
    },
    {
         0.0205175492,          /* Filter 149 */
        -0.0186885989,
        -0.0512640942,
        -0.0297059917,
         0.0431896699,
         0.0988048184,
         0.0587939792,
        -0.0777730922,
        -0.1992959379,
        -0.1481588796,
         0.1499314312,
         0.5986082295,
         0.9690038944,
         1.0483063317,
         0.7892846374,
         0.3442154826,
        -0.0436373301,
        -0.2055688972,
        -0.1437850844,
         0.0052545830,
         0.0953999830,
         0.0757128867,
        -0.0005220700,
        -0.0498140439,
        -0.0374706558,
         0.0055656555,
         0.0284945481
    },
    {
         0.0203825509,          /* Filter 150 */
        -0.0189239931,
        -0.0513191552,
        -0.0294238113,
         0.0436029556,
         0.0988908515,
         0.0582808598,
        -0.0785820034,
        -0.1995981766,
        -0.1472386556,
         0.1520407163,
         0.6009618111,
         0.9702987546,
         1.0477752212,
         0.7872454807,
         0.3418423080,
        -0.0451402854,
        -0.2057455384,
        -0.1430868986,
         0.0059723839,
         0.0955713342,
         0.0753854470,
        -0.0009091895,
        -0.0499061296,
        -0.0372789366,
         0.0057730057,
         0.0285083605
    },
    {
         0.0202475525,          /* Filter 151 */
        -0.0191593874,
        -0.0513742163,
        -0.0291416310,
         0.0440162414,
         0.0989768846,
         0.0577677405,
        -0.0793909145,
        -0.1999004153,
        -0.1463184317,
         0.1541500014,
         0.6033153928,
         0.9715936148,
         1.0472441108,
         0.7852063239,
         0.3394691335,
        -0.0466432408,
        -0.2059221796,
        -0.1423887129,
         0.0066901848,
         0.0957426854,
         0.0750580074,
        -0.0012963090,
        -0.0499982153,
        -0.0370872174,
         0.0059803558,
         0.0285221729
    },
    {
         0.0201125542,          /* Filter 152 */
        -0.0193947816,
        -0.0514292773,
        -0.0288594506,
         0.0444295272,
         0.0990629176,
         0.0572546211,
        -0.0801998256,
        -0.2002026540,
        -0.1453982077,
         0.1562592865,
         0.6056689744,
         0.9728884750,
         1.0467130004,
         0.7831671671,
         0.3370959589,
        -0.0481461961,
        -0.2060988208,
        -0.1416905272,
         0.0074079856,
         0.0959140366,
         0.0747305678,
        -0.0016834284,
        -0.0500903010,
        -0.0368954982,
         0.0061877060,
         0.0285359852
    },
    {
         0.0199734371,          /* Filter 153 */
        -0.0196294499,
        -0.0514778937,
        -0.0285710722,
         0.0448409108,
         0.0991377041,
         0.0567299654,
        -0.0810073326,
        -0.2004850963,
        -0.1444494769,
         0.1583859395,
         0.6080134686,
         0.9741498268,
         1.0461432894,
         0.7811073299,
         0.3347301800,
        -0.0496227544,
        -0.2062500165,
        -0.1409831168,
         0.0081182055,
         0.0960724362,
         0.0743968740,
        -0.0020669688,
        -0.0501750248,
        -0.0367003588,
         0.0063924337,
         0.0285452918
    },
    {
         0.0198343200,          /* Filter 154 */
        -0.0198641183,
        -0.0515265101,
        -0.0282826938,
         0.0452522945,
         0.0992124906,
         0.0562053098,
        -0.0818148395,
        -0.2007675386,
        -0.1435007462,
         0.1605125925,
         0.6103579628,
         0.9754111786,
         1.0455735784,
         0.7790474926,
         0.3323644010,
        -0.0510993128,
        -0.2064012123,
        -0.1402757065,
         0.0088284254,
         0.0962308358,
         0.0740631803,
        -0.0024505092,
        -0.0502597486,
        -0.0365052193,
         0.0065971614,
         0.0285545983
    },
    {
         0.0196952030,          /* Filter 155 */
        -0.0200987866,
        -0.0515751265,
        -0.0279943155,
         0.0456636782,
         0.0992872771,
         0.0556806541,
        -0.0826223465,
        -0.2010499809,
        -0.1425520154,
         0.1626392455,
         0.6127024570,
         0.9766725304,
         1.0450038675,
         0.7769876554,
         0.3299986220,
        -0.0525758712,
        -0.2065524081,
        -0.1395682961,
         0.0095386453,
         0.0963892355,
         0.0737294866,
        -0.0028340495,
        -0.0503444724,
        -0.0363100799,
         0.0068018891,
         0.0285639048
    },
    {
         0.0195560859,          /* Filter 156 */
        -0.0203334550,
        -0.0516237428,
        -0.0277059371,
         0.0460750618,
         0.0993620635,
         0.0551559984,
        -0.0834298535,
        -0.2013324232,
        -0.1416032847,
         0.1647658985,
         0.6150469512,
         0.9779338822,
         1.0444341565,
         0.7749278181,
         0.3276328431,
        -0.0540524296,
        -0.2067036039,
        -0.1388608857,
         0.0102488652,
         0.0965476351,
         0.0733957928,
        -0.0032175899,
        -0.0504291963,
        -0.0361149404,
         0.0070066169,
         0.0285732113
    },
    {
         0.0194129018,          /* Filter 157 */
        -0.0205672627,
        -0.0516658388,
        -0.0274114580,
         0.0464843258,
         0.0994254731,
         0.0546199467,
        -0.0842355817,
        -0.2015947356,
        -0.1406260637,
         0.1669094802,
         0.6173817571,
         0.9791613792,
         1.0438260029,
         0.7728478481,
         0.3252750094,
        -0.0555023964,
        -0.2068295781,
        -0.1381446502,
         0.0109512512,
         0.0966931192,
         0.0730560567,
        -0.0035973889,
        -0.0505065718,
        -0.0359165114,
         0.0072086258,
         0.0285780351
    },
    {
         0.0192697177,          /* Filter 158 */
        -0.0208010704,
        -0.0517079349,
        -0.0271169790,
         0.0468935897,
         0.0994888827,
         0.0540838950,
        -0.0850413100,
        -0.2018570481,
        -0.1396488428,
         0.1690530618,
         0.6197165630,
         0.9803888762,
         1.0432178494,
         0.7707678781,
         0.3229171757,
        -0.0569523632,
        -0.2069555524,
        -0.1374284147,
         0.0116536372,
         0.0968386034,
         0.0727163205,
        -0.0039771878,
        -0.0505839474,
        -0.0357180824,
         0.0074106347,
         0.0285828589
    },
    {
         0.0191265336,          /* Filter 159 */
        -0.0210348781,
        -0.0517500309,
        -0.0268224999,
         0.0473028536,
         0.0995522923,
         0.0535478433,
        -0.0858470382,
        -0.2021193605,
        -0.1386716219,
         0.1711966435,
         0.6220513690,
         0.9816163732,
         1.0426096958,
         0.7686879080,
         0.3205593420,
        -0.0584023300,
        -0.2070815267,
        -0.1367121792,
         0.0123560232,
         0.0969840875,
         0.0723765844,
        -0.0043569868,
        -0.0506613229,
        -0.0355196534,
         0.0076126436,
         0.0285876827
    },
    {
         0.0189833495,          /* Filter 160 */
        -0.0212686859,
        -0.0517921269,
        -0.0265280208,
         0.0477121176,
         0.0996157019,
         0.0530117917,
        -0.0866527665,
        -0.2023816729,
        -0.1376944010,
         0.1733402251,
         0.6243861749,
         0.9828438702,
         1.0420015423,
         0.7666079380,
         0.3182015083,
        -0.0598522969,
        -0.2072075009,
        -0.1359959437,
         0.0130584092,
         0.0971295716,
         0.0720368483,
        -0.0047367858,
        -0.0507386984,
        -0.0353212243,
         0.0078146525,
         0.0285925065
    },
    {
         0.0188361525,          /* Filter 161 */
        -0.0215014979,
        -0.0518276298,
        -0.0262275421,
         0.0481190436,
         0.0996676085,
         0.0524644905,
        -0.0874563389,
        -0.2026235265,
        -0.1366887157,
         0.1755002891,
         0.6267106928,
         0.9840371751,
         1.0413551147,
         0.7645083874,
         0.3158521651,
        -0.0612754868,
        -0.2073084845,
        -0.1352712825,
         0.0137527139,
         0.0972621819,
         0.0716912826,
        -0.0051126842,
        -0.0508087429,
        -0.0351196373,
         0.0080138482,
         0.0285928731
    },
    {
         0.0186889556,          /* Filter 162 */
        -0.0217343099,
        -0.0518631326,
        -0.0259270634,
         0.0485259695,
         0.0997195152,
         0.0519171894,
        -0.0882599114,
        -0.2028653801,
        -0.1356830305,
         0.1776603531,
         0.6290352108,
         0.9852304800,
         1.0407086871,
         0.7624088367,
         0.3135028219,
        -0.0626986768,
        -0.2074094681,
        -0.1345466212,
         0.0144470186,
         0.0973947921,
         0.0713457170,
        -0.0054885826,
        -0.0508787873,
        -0.0349180502,
         0.0082130440,
         0.0285932398
    },
    {
         0.0185417587,          /* Filter 163 */
        -0.0219671218,
        -0.0518986355,
        -0.0256265847,
         0.0489328955,
         0.0997714219,
         0.0513698882,
        -0.0890634838,
        -0.2031072337,
        -0.1346773453,
         0.1798204171,
         0.6313597287,
         0.9864237850,
         1.0400622595,
         0.7603092861,
         0.3111534787,
        -0.0641218667,
        -0.2075104516,
        -0.1338219600,
         0.0151413232,
         0.0975274024,
         0.0710001514,
        -0.0058644810,
        -0.0509488318,
        -0.0347164631,
         0.0084122397,
         0.0285936064
    },
    {
         0.0183945618,          /* Filter 164 */
        -0.0221999338,
        -0.0519341383,
        -0.0253261060,
         0.0493398215,
         0.0998233285,
         0.0508225871,
        -0.0898670563,
        -0.2033490873,
        -0.1336716600,
         0.1819804810,
         0.6336842466,
         0.9876170899,
         1.0394158319,
         0.7582097354,
         0.3088041356,
        -0.0655450567,
        -0.2076114352,
        -0.1330972988,
         0.0158356279,
         0.0976600127,
         0.0706545858,
        -0.0062403794,
        -0.0510188762,
        -0.0345148761,
         0.0086114355,
         0.0285939730
    },
    {
         0.0182434089,          /* Filter 165 */
        -0.0224316146,
        -0.0519629781,
        -0.0250197324,
         0.0497441908,
         0.0998636106,
         0.0502641893,
        -0.0906680935,
        -0.2035701578,
        -0.1326375456,
         0.1841565741,
         0.6359978781,
         0.9887758746,
         1.0387313093,
         0.7560911606,
         0.3064638235,
        -0.0669412938,
        -0.2076876657,
        -0.1323646112,
         0.0165216094,
         0.0977797962,
         0.0703034048,
        -0.0066122210,
        -0.0510816104,
        -0.0343102633,
         0.0088077259,
         0.0285899105
    },
    {
         0.0180922560,          /* Filter 166 */
        -0.0226632954,
        -0.0519918178,
        -0.0247133588,
         0.0501485602,
         0.0999038927,
         0.0497057914,
        -0.0914691306,
        -0.2037912283,
        -0.1316034311,
         0.1863326671,
         0.6383115096,
         0.9899346594,
         1.0380467868,
         0.7539725858,
         0.3041235115,
        -0.0683375309,
        -0.2077638962,
        -0.1316319236,
         0.0172075908,
         0.0978995797,
         0.0699522238,
        -0.0069840626,
        -0.0511443445,
        -0.0341056505,
         0.0090040163,
         0.0285858479
    },
    {
         0.0179411030,          /* Filter 167 */
        -0.0228949761,
        -0.0520206575,
        -0.0244069852,
         0.0505529295,
         0.0999441748,
         0.0491473936,
        -0.0922701678,
        -0.2040122988,
        -0.1305693167,
         0.1885087601,
         0.6406251411,
         0.9910934441,
         1.0373622642,
         0.7518540111,
         0.3017831995,
        -0.0697337681,
        -0.2078401266,
        -0.1308992360,
         0.0178935723,
         0.0980193632,
         0.0696010428,
        -0.0073559041,
        -0.0512070787,
        -0.0339010376,
         0.0092003067,
         0.0285817853
    },
    {
         0.0177899501,          /* Filter 168 */
        -0.0231266569,
        -0.0520494973,
        -0.0241006115,
         0.0509572988,
         0.0999844569,
         0.0485889958,
        -0.0930712050,
        -0.2042333694,
        -0.1295352022,
         0.1906848531,
         0.6429387725,
         0.9922522288,
         1.0366777417,
         0.7497354363,
         0.2994428875,
        -0.0711300052,
        -0.2079163571,
        -0.1301665484,
         0.0185795538,
         0.0981391468,
         0.0692498618,
        -0.0077277457,
        -0.0512698128,
        -0.0336964248,
         0.0093965971,
         0.0285777227
    },
    {
         0.0176349005,          /* Filter 169 */
        -0.0233570707,
        -0.0520716070,
        -0.0237884515,
         0.0513588923,
         0.1000129971,
         0.0480196602,
        -0.0938693250,
        -0.2044333374,
        -0.1284727030,
         0.1928765151,
         0.6452409205,
         0.9933761745,
         1.0359553138,
         0.7475983979,
         0.2971121425,
        -0.0724991229,
        -0.2079680788,
        -0.1294262333,
         0.0192569758,
         0.0982461562,
         0.0688932805,
        -0.0080953775,
        -0.0513252610,
        -0.0334889193,
         0.0095898920,
         0.0285692612
    },
    {
         0.0174798509,          /* Filter 170 */
        -0.0235874845,
        -0.0520937166,
        -0.0234762914,
         0.0517604858,
         0.1000415374,
         0.0474503246,
        -0.0946674451,
        -0.2046333054,
        -0.1274102038,
         0.1950681772,
         0.6475430686,
         0.9945001202,
         1.0352328858,
         0.7454613595,
         0.2947813975,
        -0.0738682406,
        -0.2080198004,
        -0.1286859183,
         0.0199343978,
         0.0983531656,
         0.0685366992,
        -0.0084630092,
        -0.0513807092,
        -0.0332814138,
         0.0097831870,
         0.0285607996
    },
    {
         0.0173248013,          /* Filter 171 */
        -0.0238178982,
        -0.0521158263,
        -0.0231641314,
         0.0521620793,
         0.1000700777,
         0.0468809890,
        -0.0954655652,
        -0.2048332734,
        -0.1263477046,
         0.1972598392,
         0.6498452166,
         0.9956240658,
         1.0345104579,
         0.7433243212,
         0.2924506525,
        -0.0752373583,
        -0.2080715221,
        -0.1279456033,
         0.0206118199,
         0.0984601750,
         0.0681801180,
        -0.0088306409,
        -0.0514361574,
        -0.0330739083,
         0.0099764820,
         0.0285523381
    },
    {
         0.0171697517,          /* Filter 172 */
        -0.0240483120,
        -0.0521379359,
        -0.0228519713,
         0.0525636728,
         0.1000986179,
         0.0463116534,
        -0.0962636853,
        -0.2050332414,
        -0.1252852054,
         0.1994515012,
         0.6521473646,
         0.9967480115,
         1.0337880300,
         0.7411872828,
         0.2901199075,
        -0.0766064761,
        -0.2081232437,
        -0.1272052882,
         0.0212892419,
         0.0985671844,
         0.0678235367,
        -0.0091982726,
        -0.0514916056,
        -0.0328664028,
         0.0101697770,
         0.0285438766
    },
    {
         0.0170108672,          /* Filter 173 */
        -0.0242773229,
        -0.0521532515,
        -0.0225341369,
         0.0529622711,
         0.1001153037,
         0.0457315451,
        -0.0970585043,
        -0.2052117925,
        -0.1241943751,
         0.2016582654,
         0.6544374338,
         0.9978368087,
         1.0330278967,
         0.7390323454,
         0.2877992604,
        -0.0779483171,
        -0.2081507074,
        -0.1264577443,
         0.0219578739,
         0.0986614776,
         0.0674617712,
        -0.0095615446,
        -0.0515397957,
        -0.0326561383,
         0.0103599887,
         0.0285310486
    },
    {
         0.0168519827,          /* Filter 174 */
        -0.0245063337,
        -0.0521685671,
        -0.0222163025,
         0.0533608693,
         0.1001319894,
         0.0451514368,
        -0.0978533234,
        -0.2053903436,
        -0.1231035449,
         0.2038650297,
         0.6567275030,
         0.9989256059,
         1.0322677635,
         0.7368774080,
         0.2854786134,
        -0.0792901582,
        -0.2081781711,
        -0.1257102004,
         0.0226265059,
         0.0987557709,
         0.0671000058,
        -0.0099248165,
        -0.0515879858,
        -0.0324458737,
         0.0105502003,
         0.0285182207
    },
    {
         0.0166930983,          /* Filter 175 */
        -0.0247353445,
        -0.0521838827,
        -0.0218984681,
         0.0537594676,
         0.1001486751,
         0.0445713285,
        -0.0986481424,
        -0.2055688946,
        -0.1220127147,
         0.2060717940,
         0.6590175721,
         1.0000144030,
         1.0315076302,
         0.7347224706,
         0.2831579663,
        -0.0806319993,
        -0.2082056347,
        -0.1249626565,
         0.0232951379,
         0.0988500641,
         0.0667382403,
        -0.0102880885,
        -0.0516361759,
        -0.0322356092,
         0.0107404120,
         0.0285053928
    },
    {
         0.0165342138,          /* Filter 176 */
        -0.0249643553,
        -0.0521991983,
        -0.0215806336,
         0.0541580658,
         0.1001653608,
         0.0439912202,
        -0.0994429615,
        -0.2057474457,
        -0.1209218845,
         0.2082785582,
         0.6613076413,
         1.0011032002,
         1.0307474970,
         0.7325675332,
         0.2808373192,
        -0.0819738404,
        -0.2082330984,
        -0.1242151125,
         0.0239637700,
         0.0989443574,
         0.0663764748,
        -0.0106513604,
        -0.0516843660,
        -0.0320253446,
         0.0109306237,
         0.0284925649
    },
    {
         0.0163715588,          /* Filter 177 */
        -0.0251918270,
        -0.0522076590,
        -0.0212572406,
         0.0545534492,
         0.1001700839,
         0.0434005105,
        -0.1002340935,
        -0.2059042704,
        -0.1198027863,
         0.2104999514,
         0.6635850382,
         1.0021565489,
         1.0299498687,
         0.7303952650,
         0.2785272960,
        -0.0832882571,
        -0.2082365614,
        -0.1234607376,
         0.0246233872,
         0.0990259978,
         0.0660097421,
        -0.0110101259,
        -0.0517253294,
        -0.0318124553,
         0.0111176665,
         0.0284754055
    },
    {
         0.0162089039,          /* Filter 178 */
        -0.0254192988,
        -0.0522161196,
        -0.0209338476,
         0.0549488325,
         0.1001748069,
         0.0428098007,
        -0.1010252256,
        -0.2060610952,
        -0.1186836882,
         0.2127213447,
         0.6658624351,
         1.0032098976,
         1.0291522405,
         0.7282229968,
         0.2762172727,
        -0.0846026737,
        -0.2082400243,
        -0.1227063627,
         0.0252830043,
         0.0991076383,
         0.0656430093,
        -0.0113688914,
        -0.0517662927,
        -0.0315995659,
         0.0113047092,
         0.0284582460
    },
    {
         0.0160462489,          /* Filter 179 */
        -0.0256467705,
        -0.0522245802,
        -0.0206104545,
         0.0553442159,
         0.1001795300,
         0.0422190910,
        -0.1018163576,
        -0.2062179199,
        -0.1175645901,
         0.2149427379,
         0.6681398320,
         1.0042632463,
         1.0283546123,
         0.7260507286,
         0.2739072494,
        -0.0859170904,
        -0.2082434873,
        -0.1219519878,
         0.0259426215,
         0.0991892787,
         0.0652762765,
        -0.0117276568,
        -0.0518072561,
        -0.0313866766,
         0.0114917519,
         0.0284410866
    },
    {
         0.0158835939,          /* Filter 180 */
        -0.0258742422,
        -0.0522330408,
        -0.0202870615,
         0.0557395992,
         0.1001842531,
         0.0416283812,
        -0.1026074897,
        -0.2063747447,
        -0.1164454920,
         0.2171641311,
         0.6704172289,
         1.0053165950,
         1.0275569840,
         0.7238784604,
         0.2715972261,
        -0.0872315071,
        -0.2082469503,
        -0.1211976129,
         0.0266022387,
         0.0992709191,
         0.0649095437,
        -0.0120864223,
        -0.0518482195,
        -0.0311737872,
         0.0116787947,
         0.0284239271
    },
    {
         0.0157172352,          /* Filter 181 */
        -0.0261000387,
        -0.0522345887,
        -0.0199582292,
         0.0561315479,
         0.1001769100,
         0.0410272474,
        -0.1033945469,
        -0.2065095391,
        -0.1152981985,
         0.2193996736,
         0.6726813620,
         1.0063342048,
         1.0267220814,
         0.7216894332,
         0.2692983472,
        -0.0885183609,
        -0.2082266761,
        -0.1204368041,
         0.0272526220,
         0.0993399753,
         0.0645380613,
        -0.0124405379,
        -0.0518819910,
        -0.0309584078,
         0.0118625851,
         0.0284024733
    },
    {
         0.0155508765,          /* Filter 182 */
        -0.0263258351,
        -0.0522361365,
        -0.0196293968,
         0.0565234966,
         0.1001695669,
         0.0404261135,
        -0.1041816041,
        -0.2066443334,
        -0.1141509050,
         0.2216352161,
         0.6749454951,
         1.0073518147,
         1.0258871789,
         0.7195004060,
         0.2669994683,
        -0.0898052147,
        -0.2082064019,
        -0.1196759954,
         0.0279030053,
         0.0994090315,
         0.0641665788,
        -0.0127946535,
        -0.0519157624,
        -0.0307430284,
         0.0120463754,
         0.0283810195
    },
    {
         0.0153845178,          /* Filter 183 */
        -0.0265516316,
        -0.0522376843,
        -0.0193005645,
         0.0569154453,
         0.1001622239,
         0.0398249796,
        -0.1049686613,
        -0.2067791278,
        -0.1130036115,
         0.2238707586,
         0.6772096282,
         1.0083694246,
         1.0250522763,
         0.7173113789,
         0.2647005894,
        -0.0910920686,
        -0.2081861277,
        -0.1189151866,
         0.0285533886,
         0.0994780876,
         0.0637950963,
        -0.0131487691,
        -0.0519495339,
        -0.0305276490,
         0.0122301658,
         0.0283595656
    },
    {
         0.0152181591,          /* Filter 184 */
        -0.0267774280,
        -0.0522392321,
        -0.0189717322,
         0.0573073940,
         0.1001548808,
         0.0392238457,
        -0.1057557185,
        -0.2069139221,
        -0.1118563180,
         0.2261063011,
         0.6794737613,
         1.0093870344,
         1.0242173737,
         0.7151223517,
         0.2624017105,
        -0.0923789224,
        -0.2081658535,
        -0.1181543779,
         0.0292037719,
         0.0995471438,
         0.0634236139,
        -0.0135028846,
        -0.0519833054,
        -0.0303122695,
         0.0124139562,
         0.0283381118
    },
    {
         0.0150481659,          /* Filter 185 */
        -0.0270014130,
        -0.0522338125,
        -0.0186375834,
         0.0576956882,
         0.1001353729,
         0.0386124711,
        -0.1065383112,
        -0.2070263874,
        -0.1106809110,
         0.2283555070,
         0.6817240414,
         1.0103686247,
         1.0233454277,
         0.7129171408,
         0.2601144912,
        -0.0936380845,
        -0.2081221120,
        -0.1173875315,
         0.0298447081,
         0.0996036895,
         0.0630476000,
        -0.0138522102,
        -0.0520099232,
        -0.0300945352,
         0.0125944132,
         0.0283124028
    },
    {
         0.0148781728,          /* Filter 186 */
        -0.0272253980,
        -0.0522283929,
        -0.0183034347,
         0.0580839825,
         0.1001158651,
         0.0380010965,
        -0.1073209040,
        -0.2071388526,
        -0.1095055040,
         0.2306047128,
         0.6839743215,
         1.0113502151,
         1.0224734817,
         0.7107119299,
         0.2578272718,
        -0.0948972465,
        -0.2080783704,
        -0.1166206852,
         0.0304856443,
         0.0996602352,
         0.0626715861,
        -0.0142015358,
        -0.0520365410,
        -0.0298768009,
         0.0127748701,
         0.0282866939
    },
    {
         0.0147081796,          /* Filter 187 */
        -0.0274493829,
        -0.0522229732,
        -0.0179692860,
         0.0584722768,
         0.1000963572,
         0.0373897219,
        -0.1081034967,
        -0.2072513178,
        -0.1083300970,
         0.2328539186,
         0.6862246016,
         1.0123318055,
         1.0216015356,
         0.7085067190,
         0.2555400525,
        -0.0961564085,
        -0.2080346289,
        -0.1158538389,
         0.0311265805,
         0.0997167809,
         0.0622955721,
        -0.0145508614,
        -0.0520631588,
        -0.0296590666,
         0.0129553270,
         0.0282609850
    },
    {
         0.0145381864,          /* Filter 188 */
        -0.0276733679,
        -0.0522175536,
        -0.0176351372,
         0.0588605710,
         0.1000768493,
         0.0367783473,
        -0.1088860894,
        -0.2073637831,
        -0.1071546901,
         0.2351031244,
         0.6884748817,
         1.0133133958,
         1.0207295896,
         0.7063015080,
         0.2532528331,
        -0.0974155706,
        -0.2079908873,
        -0.1150869926,
         0.0317675166,
         0.0997733266,
         0.0619195582,
        -0.0149001870,
        -0.0520897765,
        -0.0294413322,
         0.0131357839,
         0.0282352761
    },
    {
         0.0143646305,          /* Filter 189 */
        -0.0278954053,
        -0.0522051151,
        -0.0172957985,
         0.0592449912,
         0.1000450828,
         0.0361569214,
        -0.1096638265,
        -0.2074536260,
        -0.1059512609,
         0.2373655014,
         0.6907107220,
         1.0142586957,
         1.0198208411,
         0.7040806917,
         0.2509777830,
        -0.0986469212,
        -0.2079239542,
        -0.1143145038,
         0.0323987984,
         0.0998174408,
         0.0615392316,
        -0.0152445858,
        -0.0521092822,
        -0.0292213785,
         0.0133128286,
         0.0282053536
    },
    {
         0.0141910745,          /* Filter 190 */
        -0.0281174426,
        -0.0521926765,
        -0.0169564597,
         0.0596294114,
         0.1000133163,
         0.0355354955,
        -0.1104415636,
        -0.2075434690,
        -0.1047478317,
         0.2396278784,
         0.6929465623,
         1.0152039956,
         1.0189120925,
         0.7018598754,
         0.2487027328,
        -0.0998782719,
        -0.2078570211,
        -0.1135420151,
         0.0330300802,
         0.0998615549,
         0.0611589050,
        -0.0155889846,
        -0.0521287880,
        -0.0290014248,
         0.0134898733,
         0.0281754311
    },
    {
         0.0140175186,          /* Filter 191 */
        -0.0283394799,
        -0.0521802379,
        -0.0166171210,
         0.0600138315,
         0.0999815497,
         0.0349140696,
        -0.1112193006,
        -0.2076333119,
        -0.1035444025,
         0.2418902555,
         0.6951824025,
         1.0161492956,
         1.0180033440,
         0.6996390591,
         0.2464276827,
        -0.1011096226,
        -0.2077900880,
        -0.1127695264,
         0.0336613619,
         0.0999056691,
         0.0607785783,
        -0.0159333835,
        -0.0521482937,
        -0.0287814710,
         0.0136669179,
         0.0281455086
    },
};
#else
/* Raised root cosine pulse shaping; Beta = 0.5; 4 symbols either
   side of the centre. We cannot simplify this by using only half
   the filter, as each variant are each skewed by n/PULSESHAPER_COEFF_SETS
   of a sample. Only one is symmetric. */
#define PULSESHAPER_GAIN        10.00736638
#define PULSESHAPER_COEFF_SETS  192
static const float pulseshaper[PULSESHAPER_COEFF_SETS][V17RX_FILTER_STEPS] =
{
    {
        -0.0077172773,      /* Filter 0 */
        -0.0038694321,
         0.0112115904,
         0.0124836134,
        -0.0082281633,
        -0.0167092864,
         0.0146132015,
         0.0413429837,
        -0.0147924454,
        -0.1313410544,
        -0.1320188601,
         0.1554566471,
         0.6664080627,
         1.0773601675,
         1.0773601675,
         0.6664080627,
         0.1554566471,
        -0.1320188601,
        -0.1313410544,
        -0.0147924454,
         0.0413429837,
         0.0146132015,
        -0.0167092864,
        -0.0082281633,
         0.0124836134,
         0.0112115904,
        -0.0038694321,
    },
    {
        -0.0068190610,      /* Filter 1 */
        -0.0038041721,
         0.0112770421,
         0.0124187357,
        -0.0083449709,
        -0.0166459447,
         0.0148368812,
         0.0413102396,
        -0.0153409117,
        -0.1318357126,
        -0.1313337561,
         0.1577435842,
         0.6691429414,
         1.0785755229,
         1.0760969704,
         0.6636622690,
         0.1531967383,
        -0.1326702527,
        -0.1308339184,
        -0.0142522454,
         0.0413657190,
         0.0143894917,
        -0.0167675034,
        -0.0081100070,
         0.0125456020,
         0.0111444708,
        -0.0039331771,
    },
    {
        -0.0059208446,      /* Filter 2 */
        -0.0037389121,
         0.0113424938,
         0.0123538580,
        -0.0084617785,
        -0.0165826029,
         0.0150605609,
         0.0412774954,
        -0.0158893779,
        -0.1323303708,
        -0.1306486520,
         0.1600305213,
         0.6718778202,
         1.0797908782,
         1.0748337732,
         0.6609164753,
         0.1509368295,
        -0.1333216453,
        -0.1303267825,
        -0.0137120455,
         0.0413884544,
         0.0141657819,
        -0.0168257204,
        -0.0079918506,
         0.0126075905,
         0.0110773512,
        -0.0039969220,
    },
    {
        -0.0050226282,      /* Filter 3 */
        -0.0036736522,
         0.0114079456,
         0.0122889803,
        -0.0085785861,
        -0.0165192611,
         0.0152842405,
         0.0412447513,
        -0.0164378441,
        -0.1328250291,
        -0.1299635480,
         0.1623174583,
         0.6746126989,
         1.0810062335,
         1.0735705761,
         0.6581706816,
         0.1486769207,
        -0.1339730378,
        -0.1298196465,
        -0.0131718456,
         0.0414111897,
         0.0139420721,
        -0.0168839373,
        -0.0078736943,
         0.0126695791,
         0.0110102315,
        -0.0040606669,
    },
    {
        -0.0041244119,      /* Filter 4 */
        -0.0036083922,
         0.0114733973,
         0.0122241026,
        -0.0086953937,
        -0.0164559194,
         0.0155079202,
         0.0412120072,
        -0.0169863104,
        -0.1333196873,
        -0.1292784439,
         0.1646043954,
         0.6773475777,
         1.0822215889,
         1.0723073790,
         0.6554248879,
         0.1464170119,
        -0.1346244304,
        -0.1293125105,
        -0.0126316456,
         0.0414339250,
         0.0137183623,
        -0.0169421543,
        -0.0077555379,
         0.0127315677,
         0.0109431119,
        -0.0041244119,
    },
    {
        -0.0041866002,      /* Filter 5 */
        -0.0035416604,
         0.0115371125,
         0.0121563712,
        -0.0088107333,
        -0.0163874531,
         0.0157313656,
         0.0411691108,
        -0.0175427866,
        -0.1338013254,
        -0.1285594059,
         0.1669178292,
         0.6800706101,
         1.0833886456,
         1.0709968144,
         0.6526691109,
         0.1441846479,
        -0.1352423471,
        -0.1287934386,
        -0.0120999589,
         0.0414468005,
         0.0134948240,
        -0.0169952506,
        -0.0076361520,
         0.0127906345,
         0.0108743939,
        -0.0041866002,
    },
    {
        -0.0042487886,      /* Filter 6 */
        -0.0034749286,
         0.0116008276,
         0.0120886399,
        -0.0089260730,
        -0.0163189869,
         0.0159548109,
         0.0411262144,
        -0.0180992628,
        -0.1342829635,
        -0.1278403679,
         0.1692312630,
         0.6827936425,
         1.0845557023,
         1.0696862498,
         0.6499133339,
         0.1419522838,
        -0.1358602638,
        -0.1282743666,
        -0.0115682723,
         0.0414596759,
         0.0132712856,
        -0.0170483468,
        -0.0075167661,
         0.0128497013,
         0.0108056758,
        -0.0042487886,
    },
    {
        -0.0043109769,      /* Filter 7 */
        -0.0034081968,
         0.0116645427,
         0.0120209086,
        -0.0090414127,
        -0.0162505206,
         0.0161782562,
         0.0410833180,
        -0.0186557390,
        -0.1347646015,
        -0.1271213298,
         0.1715446968,
         0.6855166750,
         1.0857227590,
         1.0683756853,
         0.6471575569,
         0.1397199198,
        -0.1364781806,
        -0.1277552947,
        -0.0110365856,
         0.0414725514,
         0.0130477473,
        -0.0171014431,
        -0.0073973803,
         0.0129087681,
         0.0107369577,
        -0.0043109769,
    },
    {
        -0.0043731652,      /* Filter 8 */
        -0.0033414650,
         0.0117282579,
         0.0119531772,
        -0.0091567523,
        -0.0161820543,
         0.0164017016,
         0.0410404216,
        -0.0192122152,
        -0.1352462396,
        -0.1264022918,
         0.1738581306,
         0.6882397074,
         1.0868898157,
         1.0670651207,
         0.6444017799,
         0.1374875558,
        -0.1370960973,
        -0.1272362227,
        -0.0105048989,
         0.0414854268,
         0.0128242090,
        -0.0171545394,
        -0.0072779944,
         0.0129678349,
         0.0106682397,
        -0.0043731652,
    },
    {
        -0.0044337570,      /* Filter 9 */
        -0.0032733062,
         0.0117901689,
         0.0118826305,
        -0.0092705050,
        -0.0161084683,
         0.0166247059,
         0.0409872351,
        -0.0197764357,
        -0.1357143147,
        -0.1256491108,
         0.1761975146,
         0.6909499628,
         1.0880081347,
         1.0657076804,
         0.6416369510,
         0.1352832377,
        -0.1376807868,
        -0.1267057555,
        -0.0099819630,
         0.0414885965,
         0.0126010409,
        -0.0172025235,
        -0.0071574981,
         0.0130239501,
         0.0105979936,
        -0.0044337570,
    },
    {
        -0.0044943488,          /* Filter 10 */
        -0.0032051475,
         0.0118520798,
         0.0118120839,
        -0.0093842577,
        -0.0160348823,
         0.0168477102,
         0.0409340485,
        -0.0203406562,
        -0.1361823898,
        -0.1248959297,
         0.1785368986,
         0.6936602182,
         1.0891264538,
         1.0643502402,
         0.6388721222,
         0.1330789196,
        -0.1382654762,
        -0.1261752882,
        -0.0094590271,
         0.0414917662,
         0.0123778727,
        -0.0172505076,
        -0.0070370019,
         0.0130800652,
         0.0105277476,
        -0.0044943488,
    },
    {
        -0.0045549407,          /* Filter 11 */
        -0.0031369887,
         0.0119139907,
         0.0117415372,
        -0.0094980105,
        -0.0159612963,
         0.0170707144,
         0.0408808619,
        -0.0209048767,
        -0.1366504649,
        -0.1241427487,
         0.1808762827,
         0.6963704736,
         1.0902447728,
         1.0629927999,
         0.6361072934,
         0.1308746015,
        -0.1388501656,
        -0.1256448209,
        -0.0089360912,
         0.0414949359,
         0.0121547045,
        -0.0172984917,
        -0.0069165056,
         0.0131361803,
         0.0104575015,
        -0.0045549407,
    },
    {
        -0.0046155325,          /* Filter 12 */
        -0.0030688299,
         0.0119759017,
         0.0116709905,
        -0.0096117632,
        -0.0158877103,
         0.0172937187,
         0.0408276754,
        -0.0214690972,
        -0.1371185400,
        -0.1233895677,
         0.1832156667,
         0.6990807290,
         1.0913630919,
         1.0616353597,
         0.6333424645,
         0.1286702834,
        -0.1394348551,
        -0.1251143537,
        -0.0084131553,
         0.0414981056,
         0.0119315364,
        -0.0173464758,
        -0.0067960093,
         0.0131922955,
         0.0103872554,
        -0.0046155325,
    },
    {
        -0.0046744897,          /* Filter 13 */
        -0.0029992907,
         0.0120359418,
         0.0115976695,
        -0.0097238102,
        -0.0158090139,
         0.0175160726,
         0.0407640667,
        -0.0220407870,
        -0.1375725092,
        -0.1226020481,
         0.1855804396,
         0.7017772778,
         1.0924322522,
         1.0602315525,
         0.6305695147,
         0.1264944970,
        -0.1399865786,
        -0.1245730307,
        -0.0078991983,
         0.0414917289,
         0.0117089343,
        -0.0173893605,
        -0.0066745217,
         0.0132454319,
         0.0103155524,
        -0.0046744897,
    },
    {
        -0.0047334468,          /* Filter 14 */
        -0.0029297514,
         0.0120959820,
         0.0115243486,
        -0.0098358572,
        -0.0157303174,
         0.0177384266,
         0.0407004580,
        -0.0226124769,
        -0.1380264784,
        -0.1218145285,
         0.1879452126,
         0.7044738266,
         1.0935014125,
         1.0588277453,
         0.6277965649,
         0.1243187106,
        -0.1405383020,
        -0.1240317076,
        -0.0073852414,
         0.0414853522,
         0.0114863321,
        -0.0174322452,
        -0.0065530340,
         0.0132985683,
         0.0102438494,
        -0.0047334468,
    },
    {
        -0.0047924040,          /* Filter 15 */
        -0.0028602122,
         0.0121560221,
         0.0114510276,
        -0.0099479042,
        -0.0156516210,
         0.0179607805,
         0.0406368492,
        -0.0231841667,
        -0.1384804475,
        -0.1210270090,
         0.1903099855,
         0.7071703754,
         1.0945705729,
         1.0574239382,
         0.6250236152,
         0.1221429243,
        -0.1410900254,
        -0.1234903846,
        -0.0068712844,
         0.0414789754,
         0.0112637299,
        -0.0174751298,
        -0.0064315464,
         0.0133517048,
         0.0101721464,
        -0.0047924040,
    },
    {
        -0.0048513612,          /* Filter 16 */
        -0.0027906730,
         0.0122160622,
         0.0113777066,
        -0.0100599512,
        -0.0155729245,
         0.0181831345,
         0.0405732405,
        -0.0237558566,
        -0.1389344167,
        -0.1202394894,
         0.1926747584,
         0.7098669242,
         1.0956397332,
         1.0560201310,
         0.6222506654,
         0.1199671379,
        -0.1416417489,
        -0.1229490616,
        -0.0063573274,
         0.0414725987,
         0.0110411278,
        -0.0175180145,
        -0.0063100588,
         0.0134048412,
         0.0101004434,
        -0.0048513612,
    },
    {
        -0.0049086473,          /* Filter 17 */
        -0.0027198013,
         0.0122741660,
         0.0113016552,
        -0.0101701741,
        -0.0154891315,
         0.0184046266,
         0.0404990835,
        -0.0243347316,
        -0.1393737373,
        -0.1194174496,
         0.1950643444,
         0.7125488383,
         1.0966593320,
         1.0545704826,
         0.6194705246,
         0.1178203534,
        -0.1421607801,
        -0.1223974207,
        -0.0058525679,
         0.0414568398,
         0.0108192844,
        -0.0175558169,
        -0.0061876986,
         0.0134549746,
         0.0100273553,
        -0.0049086473,
    },
    {
        -0.0049659333,          /* Filter 18 */
        -0.0026489296,
         0.0123322698,
         0.0112256038,
        -0.0102803970,
        -0.0154053385,
         0.0186261188,
         0.0404249265,
        -0.0249136066,
        -0.1398130578,
        -0.1185954098,
         0.1974539303,
         0.7152307524,
         1.0976789308,
         1.0531208343,
         0.6166903838,
         0.1156735689,
        -0.1426798114,
        -0.1218457798,
        -0.0053478084,
         0.0414410808,
         0.0105974410,
        -0.0175936193,
        -0.0060653383,
         0.0135051081,
         0.0099542672,
        -0.0049659333,
    },
    {
        -0.0050232194,          /* Filter 19 */
        -0.0025780580,
         0.0123903736,
         0.0111495523,
        -0.0103906199,
        -0.0153215454,
         0.0188476109,
         0.0403507694,
        -0.0254924816,
        -0.1402523783,
        -0.1177733700,
         0.1998435162,
         0.7179126665,
         1.0986985296,
         1.0516711859,
         0.6139102430,
         0.1135267845,
        -0.1431988426,
        -0.1212941389,
        -0.0048430490,
         0.0414253219,
         0.0103755977,
        -0.0176314216,
        -0.0059429781,
         0.0135552415,
         0.0098811792,
        -0.0050232194,
    },
    {
        -0.0050805055,          /* Filter 20 */
        -0.0025071863,
         0.0124484774,
         0.0110735009,
        -0.0105008428,
        -0.0152377524,
         0.0190691031,
         0.0402766124,
        -0.0260713566,
        -0.1406916989,
        -0.1169513302,
         0.2022331022,
         0.7205945806,
         1.0997181284,
         1.0502215375,
         0.6111301022,
         0.1113800000,
        -0.1437178738,
        -0.1207424980,
        -0.0043382895,
         0.0414095629,
         0.0101537543,
        -0.0176692240,
        -0.0058206179,
         0.0136053750,
         0.0098080911,
        -0.0050805055,
    },
    {
        -0.0051360858,          /* Filter 21 */
        -0.0024350318,
         0.0125045805,
         0.0109947656,
        -0.0106091236,
        -0.0151488812,
         0.0192895198,
         0.0401917871,
        -0.0266571235,
        -0.1411158285,
        -0.1160946025,
         0.2046469108,
         0.7232609339,
         1.1006877812,
         1.0487265902,
         0.6083436989,
         0.1092626720,
        -0.1442044989,
        -0.1201810753,
        -0.0038429366,
         0.0413845907,
         0.0099328593,
        -0.0177019653,
        -0.0056975035,
         0.0136524840,
         0.0097336904,
        -0.0051360858,
    },
    {
        -0.0051916661,          /* Filter 22 */
        -0.0023628774,
         0.0125606836,
         0.0109160303,
        -0.0107174044,
        -0.0150600100,
         0.0195099365,
         0.0401069617,
        -0.0272428903,
        -0.1415399582,
        -0.1152378747,
         0.2070607195,
         0.7259272872,
         1.1016574340,
         1.0472316428,
         0.6055572955,
         0.1071453439,
        -0.1446911239,
        -0.1196196527,
        -0.0033475838,
         0.0413596184,
         0.0097119643,
        -0.0177347066,
        -0.0055743891,
         0.0136995931,
         0.0096592897,
        -0.0051916661,
    },
    {
        -0.0052472464,          /* Filter 23 */
        -0.0022907229,
         0.0126167868,
         0.0108372951,
        -0.0108256852,
        -0.0149711387,
         0.0197303531,
         0.0400221364,
        -0.0278286572,
        -0.1419640879,
        -0.1143811470,
         0.2094745282,
         0.7285936405,
         1.1026270869,
         1.0457366955,
         0.6027708922,
         0.1050280159,
        -0.1451777490,
        -0.1190582300,
        -0.0028522309,
         0.0413346462,
         0.0094910693,
        -0.0177674479,
        -0.0054512747,
         0.0137467021,
         0.0095848891,
        -0.0052472464,
    },
    {
        -0.0053028267,          /* Filter 24 */
        -0.0022185685,
         0.0126728899,
         0.0107585598,
        -0.0109339660,
        -0.0148822675,
         0.0199507698,
         0.0399373110,
        -0.0284144241,
        -0.1423882175,
        -0.1135244193,
         0.2118883368,
         0.7312599938,
         1.1035967397,
         1.0442417482,
         0.5999844889,
         0.1029106879,
        -0.1456643740,
        -0.1184968073,
        -0.0023568781,
         0.0413096740,
         0.0092701743,
        -0.0178001892,
        -0.0053281603,
         0.0137938111,
         0.0095104884,
        -0.0053028267,
    },
    {
        -0.0053566683,          /* Filter 25 */
        -0.0021451824,
         0.0127269293,
         0.0106771900,
        -0.0110401874,
        -0.0147883412,
         0.0201698953,
         0.0398417036,
        -0.0290067804,
        -0.1427966148,
        -0.1126328501,
         0.2143257637,
         0.7339098625,
         1.1045160806,
         1.0427020605,
         0.5971927497,
         0.1008232550,
        -0.1461188909,
        -0.1179261368,
        -0.0018711315,
         0.0412756620,
         0.0090504141,
        -0.0178278949,
        -0.0052044097,
         0.0138378770,
         0.0094348481,
        -0.0053566683,
    },
    {
        -0.0054105099,          /* Filter 26 */
        -0.0020717962,
         0.0127809687,
         0.0105958202,
        -0.0111464087,
        -0.0146944149,
         0.0203890209,
         0.0397460963,
        -0.0295991367,
        -0.1432050120,
        -0.1117412809,
         0.2167631905,
         0.7365597312,
         1.1054354216,
         1.0411623729,
         0.5944010105,
         0.0987358221,
        -0.1465734077,
        -0.1173554664,
        -0.0013853848,
         0.0412416500,
         0.0088306538,
        -0.0178556005,
        -0.0050806591,
         0.0138819430,
         0.0093592079,
        -0.0054105099,
    },
    {
        -0.0054643514,          /* Filter 27 */
        -0.0019984100,
         0.0128350080,
         0.0105144504,
        -0.0112526301,
        -0.0146004886,
         0.0206081464,
         0.0396504889,
        -0.0301914931,
        -0.1436134093,
        -0.1108497118,
         0.2192006174,
         0.7392096000,
         1.1063547626,
         1.0396226852,
         0.5916092714,
         0.0966483892,
        -0.1470279245,
        -0.1167847959,
        -0.0008996382,
         0.0412076380,
         0.0086108936,
        -0.0178833062,
        -0.0049569085,
         0.0139260090,
         0.0092835676,
        -0.0054643514,
    },
    {
        -0.0055181930,          /* Filter 28 */
        -0.0019250239,
         0.0128890474,
         0.0104330806,
        -0.0113588515,
        -0.0145065623,
         0.0208272719,
         0.0395548815,
        -0.0307838494,
        -0.1440218066,
        -0.1099581426,
         0.2216380443,
         0.7418594687,
         1.1072741035,
         1.0380829975,
         0.5888175322,
         0.0945609563,
        -0.1474824414,
        -0.1162141254,
        -0.0004138916,
         0.0411736260,
         0.0083911333,
        -0.0179110118,
        -0.0048331579,
         0.0139700749,
         0.0092079274,
        -0.0055181930,
    },
    {
        -0.0055702647,          /* Filter 29 */
        -0.0018504587,
         0.0129409612,
         0.0103491284,
        -0.0114628967,
        -0.0144076086,
         0.0210448887,
         0.0394483848,
        -0.0313824838,
        -0.1444139311,
        -0.1090315928,
         0.2240984709,
         0.7444919319,
         1.1081427855,
         1.0364991441,
         0.5860213816,
         0.0925038414,
        -0.1479051599,
        -0.1156347387,
         0.0000620587,
         0.0411307521,
         0.0081726908,
        -0.0179337113,
        -0.0047088885,
         0.0140110819,
         0.0091311211,
        -0.0055702647,
    },
    {
        -0.0056223365,          /* Filter 30 */
        -0.0017758935,
         0.0129928749,
         0.0102651761,
        -0.0115669419,
        -0.0143086549,
         0.0212625055,
         0.0393418882,
        -0.0319811182,
        -0.1448060556,
        -0.1081050431,
         0.2265588975,
         0.7471243951,
         1.1090114676,
         1.0349152908,
         0.5832252311,
         0.0904467264,
        -0.1483278784,
        -0.1150553521,
         0.0005380091,
         0.0410878783,
         0.0079542483,
        -0.0179564107,
        -0.0045846191,
         0.0140520889,
         0.0090543149,
        -0.0056223365,
    },
    {
        -0.0056744082,          /* Filter 31 */
        -0.0017013282,
         0.0130447886,
         0.0101812239,
        -0.0116709872,
        -0.0142097012,
         0.0214801224,
         0.0392353915,
        -0.0325797525,
        -0.1451981802,
        -0.1071784933,
         0.2290193240,
         0.7497568583,
         1.1098801496,
         1.0333314375,
         0.5804290805,
         0.0883896114,
        -0.1487505969,
        -0.1144759654,
         0.0010139594,
         0.0410450044,
         0.0077358057,
        -0.0179791102,
        -0.0044603497,
         0.0140930960,
         0.0089775086,
        -0.0056744082,
    },
    {
        -0.0057264799,          /* Filter 32 */
        -0.0016267630,
         0.0130967024,
         0.0100972717,
        -0.0117750324,
        -0.0141107475,
         0.0216977392,
         0.0391288948,
        -0.0331783869,
        -0.1455903047,
        -0.1062519435,
         0.2314797506,
         0.7523893215,
         1.1107488316,
         1.0317475841,
         0.5776329299,
         0.0863324965,
        -0.1491733154,
        -0.1138965787,
         0.0014899097,
         0.0410021305,
         0.0075173632,
        -0.0180018097,
        -0.0043360803,
         0.0141341030,
         0.0089007023,
        -0.0057264799,
    },
    {
        -0.0057767524,          /* Filter 33 */
        -0.0015510728,
         0.0131464301,
         0.0100107918,
        -0.0118767855,
        -0.0140067989,
         0.0219136281,
         0.0390114081,
        -0.0337829790,
        -0.1459656175,
        -0.1052902885,
         0.2339625446,
         0.7550034614,
         1.1115665265,
         1.0301201555,
         0.5748332898,
         0.0843061062,
        -0.1495645568,
        -0.1133090048,
         0.0019558832,
         0.0409505768,
         0.0073004179,
        -0.0180195365,
        -0.0042114090,
         0.0141720380,
         0.0088228040,
        -0.0057767524,
    },
    {
        -0.0058270249,          /* Filter 34 */
        -0.0014753825,
         0.0131961579,
         0.0099243119,
        -0.0119785386,
        -0.0139028502,
         0.0221295169,
         0.0388939214,
        -0.0343875711,
        -0.1463409303,
        -0.1043286335,
         0.2364453385,
         0.7576176012,
         1.1123842213,
         1.0284927270,
         0.5720336496,
         0.0822797160,
        -0.1499557981,
        -0.1127214308,
         0.0024218567,
         0.0408990232,
         0.0070834727,
        -0.0180372632,
        -0.0040867377,
         0.0142099731,
         0.0087449056,
        -0.0058270249,
    },
    {
        -0.0058772974,          /* Filter 35 */
        -0.0013996923,
         0.0132458857,
         0.0098378320,
        -0.0120802917,
        -0.0137989015,
         0.0223454057,
         0.0387764347,
        -0.0349921631,
        -0.1467162430,
        -0.1033669786,
         0.2389281325,
         0.7602317411,
         1.1132019161,
         1.0268652984,
         0.5692340095,
         0.0802533257,
        -0.1503470394,
        -0.1121338569,
         0.0028878302,
         0.0408474696,
         0.0068665274,
        -0.0180549900,
        -0.0039620663,
         0.0142479081,
         0.0086670073,
        -0.0058772974,
    },
    {
        -0.0059275699,          /* Filter 36 */
        -0.0013240021,
         0.0132956134,
         0.0097513521,
        -0.0121820448,
        -0.0136949529,
         0.0225612946,
         0.0386589480,
        -0.0355967552,
        -0.1470915558,
        -0.1024053236,
         0.2414109265,
         0.7628458810,
         1.1140196110,
         1.0252378699,
         0.5664343693,
         0.0782269355,
        -0.1507382808,
        -0.1115462830,
         0.0033538037,
         0.0407959159,
         0.0066495821,
        -0.0180727168,
        -0.0038373950,
         0.0142858431,
         0.0085891090,
        -0.0059275699,
    },
    {
        -0.0059760157,          /* Filter 37 */
        -0.0012472424,
         0.0133430961,
         0.0096624020,
        -0.0122813907,
        -0.0135860464,
         0.0227752346,
         0.0385303773,
        -0.0362069758,
        -0.1474495196,
        -0.1014084535,
         0.2439154420,
         0.7654407834,
         1.1147860096,
         1.0235674721,
         0.5636321583,
         0.0762316606,
        -0.1510983776,
        -0.1109510478,
         0.0038096294,
         0.0407358686,
         0.0064343100,
        -0.0180855083,
        -0.0037124377,
         0.0143206958,
         0.0085101930,
        -0.0059760157,
    },
    {
        -0.0060244614,          /* Filter 38 */
        -0.0011704827,
         0.0133905787,
         0.0095734519,
        -0.0123807366,
        -0.0134771399,
         0.0229891745,
         0.0384018067,
        -0.0368171965,
        -0.1478074833,
        -0.1004115835,
         0.2464199576,
         0.7680356859,
         1.1155524083,
         1.0218970744,
         0.5608299474,
         0.0742363857,
        -0.1514584744,
        -0.1103558127,
         0.0042654550,
         0.0406758213,
         0.0062190379,
        -0.0180982998,
        -0.0035874805,
         0.0143555485,
         0.0084312770,
        -0.0060244614,
    },
    {
        -0.0060729072,          /* Filter 39 */
        -0.0010937229,
         0.0134380614,
         0.0094845018,
        -0.0124800826,
        -0.0133682335,
         0.0232031144,
         0.0382732360,
        -0.0374274171,
        -0.1481654471,
        -0.0994147134,
         0.2489244731,
         0.7706305883,
         1.1163188069,
         1.0202266767,
         0.5580277364,
         0.0722411107,
        -0.1518185712,
        -0.1097605776,
         0.0047212807,
         0.0406157739,
         0.0060037659,
        -0.0181110913,
        -0.0034625233,
         0.0143904012,
         0.0083523609,
        -0.0060729072,
    },
    {
        -0.0061213530,          /* Filter 40 */
        -0.0010169632,
         0.0134855441,
         0.0093955517,
        -0.0125794285,
        -0.0132593270,
         0.0234170544,
         0.0381446654,
        -0.0380376377,
        -0.1485234109,
        -0.0984178433,
         0.2514289886,
         0.7732254908,
         1.1170852055,
         1.0185562789,
         0.5552255254,
         0.0702458358,
        -0.1521786680,
        -0.1091653424,
         0.0051771063,
         0.0405557266,
         0.0057884938,
        -0.0181238828,
        -0.0033375660,
         0.0144252539,
         0.0082734449,
        -0.0061213530,
    },
    {
        -0.0061679463,          /* Filter 41 */
        -0.0009391908,
         0.0135307242,
         0.0093041915,
        -0.0126762532,
        -0.0131455046,
         0.0236288232,
         0.0380049238,
        -0.0386531490,
        -0.1488634904,
        -0.0973856632,
         0.2539545665,
         0.7758002457,
         1.1178000180,
         1.0168435331,
         0.5524216589,
         0.0682820506,
        -0.1525079637,
        -0.1085629689,
         0.0056226226,
         0.0404873756,
         0.0055750672,
        -0.0181317803,
        -0.0032124381,
         0.0144570168,
         0.0081935858,
        -0.0061679463,
    },
    {
        -0.0062145396,          /* Filter 42 */
        -0.0008614184,
         0.0135759042,
         0.0092128313,
        -0.0127730779,
        -0.0130316821,
         0.0238405920,
         0.0378651821,
        -0.0392686603,
        -0.1492035698,
        -0.0963534830,
         0.2564801443,
         0.7783750007,
         1.1185148306,
         1.0151307873,
         0.5496177925,
         0.0663182654,
        -0.1528372594,
        -0.1079605953,
         0.0060681390,
         0.0404190246,
         0.0053616406,
        -0.0181396778,
        -0.0030873103,
         0.0144887797,
         0.0081137266,
        -0.0062145396,
    },
    {
        -0.0062611330,          /* Filter 43 */
        -0.0007836460,
         0.0136210843,
         0.0091214711,
        -0.0128699026,
        -0.0129178597,
         0.0240523607,
         0.0377254405,
        -0.0398841716,
        -0.1495436493,
        -0.0953213029,
         0.2590057222,
         0.7809497556,
         1.1192296431,
         1.0134180415,
         0.5468139260,
         0.0643544803,
        -0.1531665552,
        -0.1073582218,
         0.0065136553,
         0.0403506736,
         0.0051482140,
        -0.0181475753,
        -0.0029621824,
         0.0145205425,
         0.0080338675,
        -0.0062611330,
    },
    {
        -0.0063077263,          /* Filter 44 */
        -0.0007058736,
         0.0136662644,
         0.0090301109,
        -0.0129667273,
        -0.0128040373,
         0.0242641295,
         0.0375856989,
        -0.0404996829,
        -0.1498837288,
        -0.0942891228,
         0.2615313001,
         0.7835245105,
         1.1199444556,
         1.0117052957,
         0.5440100595,
         0.0623906951,
        -0.1534958509,
        -0.1067558483,
         0.0069591716,
         0.0402823226,
         0.0049347874,
        -0.0181554728,
        -0.0028370545,
         0.0145523054,
         0.0079540084,
        -0.0063077263,
    },
    {
        -0.0063524433,          /* Filter 45 */
        -0.0006271468,
         0.0137090859,
         0.0089364034,
        -0.0130609178,
        -0.0126853455,
         0.0244735035,
         0.0374347062,
        -0.0411201383,
        -0.1502053910,
        -0.0932215526,
         0.2640772680,
         0.7860782123,
         1.1206074115,
         1.0099508380,
         0.5412054490,
         0.0604587578,
        -0.1537946998,
        -0.1061468558,
         0.0073942266,
         0.0402058615,
         0.0047233748,
        -0.0181585214,
        -0.0027118704,
         0.0145809736,
         0.0078732811,
        -0.0063524433,
    },
    {
        -0.0063971602,          /* Filter 46 */
        -0.0005484199,
         0.0137519074,
         0.0088426959,
        -0.0131551082,
        -0.0125666538,
         0.0246828775,
         0.0372837136,
        -0.0417405937,
        -0.1505270533,
        -0.0921539825,
         0.2666232359,
         0.7886319141,
         1.1212703674,
         1.0081963802,
         0.5384008385,
         0.0585268205,
        -0.1540935488,
        -0.1055378633,
         0.0078292816,
         0.0401294005,
         0.0045119622,
        -0.0181615700,
        -0.0025866862,
         0.0146096417,
         0.0077925538,
        -0.0063971602,
    },
    {
        -0.0064418771,          /* Filter 47 */
        -0.0004696930,
         0.0137947290,
         0.0087489883,
        -0.0132492987,
        -0.0124479620,
         0.0248922515,
         0.0371327210,
        -0.0423610491,
        -0.1508487156,
        -0.0910864123,
         0.2691692038,
         0.7911856159,
         1.1219333234,
         1.0064419225,
         0.5355962280,
         0.0565948832,
        -0.1543923977,
        -0.1049288709,
         0.0082643366,
         0.0400529394,
         0.0043005496,
        -0.0181646186,
        -0.0024615020,
         0.0146383099,
         0.0077118264,
        -0.0064418771,
    },
    {
        -0.0064865941,          /* Filter 48 */
        -0.0003909662,
         0.0138375505,
         0.0086552808,
        -0.0133434892,
        -0.0123292702,
         0.0251016255,
         0.0369817283,
        -0.0429815045,
        -0.1511703778,
        -0.0900188421,
         0.2717151717,
         0.7937393177,
         1.1225962793,
         1.0046874648,
         0.5327916175,
         0.0546629459,
        -0.1546912466,
        -0.1043198784,
         0.0086993916,
         0.0399764783,
         0.0040891370,
        -0.0181676672,
        -0.0023363179,
         0.0146669781,
         0.0076310991,
        -0.0064865941,
    },
    {
        -0.0065294127,          /* Filter 49 */
        -0.0003113444,
         0.0138779590,
         0.0085592912,
        -0.0134349336,
        -0.0122057605,
         0.0253083800,
         0.0368194119,
        -0.0436065490,
        -0.1514730924,
        -0.0889158172,
         0.2742808445,
         0.7962710656,
         1.1232071276,
         1.0028919459,
         0.5299871702,
         0.0527631983,
        -0.1549600134,
        -0.1037047827,
         0.0091238428,
         0.0398921042,
         0.0038799031,
        -0.0181659157,
        -0.0022111908,
         0.0146925495,
         0.0075495786,
        -0.0065294127,
    },
    {
        -0.0065722312,          /* Filter 50 */
        -0.0002317225,
         0.0139183676,
         0.0084633017,
        -0.0135263781,
        -0.0120822508,
         0.0255151345,
         0.0366570954,
        -0.0442315934,
        -0.1517758070,
        -0.0878127922,
         0.2768465172,
         0.7988028136,
         1.1238179760,
         1.0010964271,
         0.5271827229,
         0.0508634507,
        -0.1552287801,
        -0.1030896870,
         0.0095482939,
         0.0398077301,
         0.0036706691,
        -0.0181641642,
        -0.0020860637,
         0.0147181210,
         0.0074680581,
        -0.0065722312,
    },
    {
        -0.0066150497,          /* Filter 51 */
        -0.0001521007,
         0.0139587762,
         0.0083673121,
        -0.0136178226,
        -0.0119587410,
         0.0257218890,
         0.0364947790,
        -0.0448566378,
        -0.1520785217,
        -0.0867097673,
         0.2794121900,
         0.8013345616,
         1.1244288244,
         0.9993009082,
         0.5243782755,
         0.0489637030,
        -0.1554975469,
        -0.1024745913,
         0.0099727451,
         0.0397233560,
         0.0034614352,
        -0.0181624126,
        -0.0019609366,
         0.0147436925,
         0.0073865376,
        -0.0066150497,
    },
    {
        -0.0066578683,          /* Filter 52 */
        -0.0000724789,
         0.0139991847,
         0.0082713225,
        -0.0137092670,
        -0.0118352313,
         0.0259286435,
         0.0363324626,
        -0.0454816823,
        -0.1523812363,
        -0.0856067424,
         0.2819778628,
         0.8038663095,
         1.1250396727,
         0.9975053893,
         0.5215738282,
         0.0470639554,
        -0.1557663137,
        -0.1018594956,
         0.0103971963,
         0.0396389819,
         0.0032522013,
        -0.0181606611,
        -0.0018358095,
         0.0147692639,
         0.0073050171,
        -0.0066578683,
    },
    {
        -0.0066987682,          /* Filter 53 */
         0.0000079772,
         0.0140371276,
         0.0081731188,
        -0.0137978550,
        -0.0117069598,
         0.0261325528,
         0.0361587569,
        -0.0461109524,
        -0.1526644760,
        -0.0844682133,
         0.2845625427,
         0.8063752082,
         1.1255981821,
         0.9956694743,
         0.5187704467,
         0.0451967228,
        -0.1560053732,
        -0.1012388084,
         0.0108109106,
         0.0395468952,
         0.0030453068,
        -0.0181541619,
        -0.0017108518,
         0.0147917392,
         0.0072227785,
        -0.0066987682,
    },
    {
        -0.0067396681,          /* Filter 54 */
         0.0000884333,
         0.0140750705,
         0.0080749152,
        -0.0138864430,
        -0.0115786884,
         0.0263364621,
         0.0359850512,
        -0.0467402225,
        -0.1529477156,
        -0.0833296841,
         0.2871472226,
         0.8088841069,
         1.1261566915,
         0.9938335593,
         0.5159670651,
         0.0433294902,
        -0.1562444327,
        -0.1006181213,
         0.0112246249,
         0.0394548085,
         0.0028384123,
        -0.0181476627,
        -0.0015858941,
         0.0148142145,
         0.0071405400,
        -0.0067396681,
    },
    {
        -0.0067805681,          /* Filter 55 */
         0.0001688893,
         0.0141130135,
         0.0079767115,
        -0.0139750309,
        -0.0114504169,
         0.0265403713,
         0.0358113454,
        -0.0473694925,
        -0.1532309553,
        -0.0821911550,
         0.2897319024,
         0.8113930056,
         1.1267152010,
         0.9919976443,
         0.5131636835,
         0.0414622576,
        -0.1564834922,
        -0.0999974342,
         0.0116383393,
         0.0393627217,
         0.0026315179,
        -0.0181411635,
        -0.0014609363,
         0.0148366898,
         0.0070583015,
        -0.0067805681,
    },
    {
        -0.0068214680,          /* Filter 56 */
         0.0002493454,
         0.0141509564,
         0.0078785078,
        -0.0140636189,
        -0.0113221454,
         0.0267442806,
         0.0356376397,
        -0.0479987626,
        -0.1535141950,
        -0.0810526259,
         0.2923165823,
         0.8139019043,
         1.1272737104,
         0.9901617293,
         0.5103603020,
         0.0395950250,
        -0.1567225517,
        -0.0993767470,
         0.0120520536,
         0.0392706350,
         0.0024246234,
        -0.0181346643,
        -0.0013359786,
         0.0148591651,
         0.0069760629,
        -0.0068214680,
    },
    {
        -0.0068604309,          /* Filter 57 */
         0.0003305737,
         0.0141863827,
         0.0077781605,
        -0.0141492413,
        -0.0111891732,
         0.0269451182,
         0.0354524867,
        -0.0486318865,
        -0.1537774355,
        -0.0798785587,
         0.2949195592,
         0.8163870640,
         1.1277796693,
         0.9882860972,
         0.5075588838,
         0.0377606163,
        -0.1569322887,
        -0.0987509760,
         0.0124549075,
         0.0391710391,
         0.0022202251,
        -0.0181234734,
        -0.0012113014,
         0.0148785476,
         0.0068931815,
        -0.0068604309,
    },
    {
        -0.0068993938,          /* Filter 58 */
         0.0004118021,
         0.0142218089,
         0.0076778131,
        -0.0142348637,
        -0.0110562009,
         0.0271459557,
         0.0352673337,
        -0.0492650104,
        -0.1540406760,
        -0.0787044914,
         0.2975225362,
         0.8188722237,
         1.1282856282,
         0.9864104651,
         0.5047574656,
         0.0359262076,
        -0.1571420257,
        -0.0981252050,
         0.0128577614,
         0.0390714433,
         0.0020158269,
        -0.0181122824,
        -0.0010866241,
         0.0148979301,
         0.0068103001,
        -0.0068993938,
    },
    {
        -0.0069383568,          /* Filter 59 */
         0.0004930304,
         0.0142572352,
         0.0075774657,
        -0.0143204862,
        -0.0109232287,
         0.0273467933,
         0.0350821807,
        -0.0498981343,
        -0.1543039166,
        -0.0775304241,
         0.3001255131,
         0.8213573834,
         1.1287915871,
         0.9845348330,
         0.5019560473,
         0.0340917989,
        -0.1573517628,
        -0.0974994339,
         0.0132606152,
         0.0389718474,
         0.0018114286,
        -0.0181010915,
        -0.0009619468,
         0.0149173125,
         0.0067274187,
        -0.0069383568,
    },
    {
        -0.0069773197,          /* Filter 60 */
         0.0005742587,
         0.0142926615,
         0.0074771184,
        -0.0144061086,
        -0.0107902564,
         0.0275476309,
         0.0348970277,
        -0.0505312582,
        -0.1545671571,
        -0.0763563569,
         0.3027284900,
         0.8238425431,
         1.1292975460,
         0.9826592009,
         0.4991546291,
         0.0322573902,
        -0.1575614998,
        -0.0968736629,
         0.0136634691,
         0.0388722515,
         0.0016070303,
        -0.0180899006,
        -0.0008372696,
         0.0149366950,
         0.0066445373,
        -0.0069773197,
    },
    {
        -0.0070143291,          /* Filter 61 */
         0.0006561962,
         0.0143255219,
         0.0073747002,
        -0.0144886579,
        -0.0106526491,
         0.0277451696,
         0.0347003770,
        -0.0511678560,
        -0.1548098779,
        -0.0751467332,
         0.3053490417,
         0.8263030803,
         1.1297507626,
         0.9807445444,
         0.4963560664,
         0.0304560978,
        -0.1577423087,
        -0.0962433112,
         0.0140553483,
         0.0387653529,
         0.0014052809,
        -0.0180740774,
        -0.0007129826,
         0.0149529906,
         0.0065610881,
        -0.0070143291,
    },
    {
        -0.0070513384,          /* Filter 62 */
         0.0007381336,
         0.0143583824,
         0.0072722821,
        -0.0145712072,
        -0.0105150418,
         0.0279427082,
         0.0345037263,
        -0.0518044538,
        -0.1550525987,
        -0.0739371095,
         0.3079695935,
         0.8287636175,
         1.1302039792,
         0.9788298879,
         0.4935575036,
         0.0286548053,
        -0.1579231176,
        -0.0956129596,
         0.0144472274,
         0.0386584542,
         0.0012035315,
        -0.0180582542,
        -0.0005886957,
         0.0149692862,
         0.0064776390,
        -0.0070513384,
    },
    {
        -0.0070883478,          /* Filter 63 */
         0.0008200711,
         0.0143912428,
         0.0071698639,
        -0.0146537564,
        -0.0103774345,
         0.0281402469,
         0.0343070757,
        -0.0524410516,
        -0.1552953196,
        -0.0727274858,
         0.3105901453,
         0.8312241547,
         1.1306571957,
         0.9769152314,
         0.4907589408,
         0.0268535128,
        -0.1581039265,
        -0.0949826079,
         0.0148391066,
         0.0385515555,
         0.0010017821,
        -0.0180424310,
        -0.0004644087,
         0.0149855817,
         0.0063941899,
        -0.0070883478,
    },
    {
        -0.0071253572,          /* Filter 64 */
         0.0009020085,
         0.0144241033,
         0.0070674458,
        -0.0147363057,
        -0.0102398272,
         0.0283377856,
         0.0341104250,
        -0.0530776494,
        -0.1555380404,
        -0.0715178621,
         0.3132106970,
         0.8336846919,
         1.1311104123,
         0.9750005749,
         0.4879603781,
         0.0250522204,
        -0.1582847354,
        -0.0943522562,
         0.0152309858,
         0.0384446569,
         0.0008000327,
        -0.0180266078,
        -0.0003401218,
         0.0150018773,
         0.0063107407,
        -0.0071253572,
    },
    {
        -0.0071603984,          /* Filter 65 */
         0.0009845909,
         0.0144543506,
         0.0069630322,
        -0.0148156760,
        -0.0100976555,
         0.0285317978,
         0.0339022340,
        -0.0537173332,
        -0.1557597248,
        -0.0702726794,
         0.3158480896,
         0.8361197295,
         1.1315107147,
         0.9730476000,
         0.4851655571,
         0.0232843200,
        -0.1584370199,
        -0.0937178223,
         0.0156117854,
         0.0383306645,
         0.0006010807,
        -0.0180062152,
        -0.0002163337,
         0.0150150946,
         0.0062267989,
        -0.0071603984,
    },
    {
        -0.0071954396,          /* Filter 66 */
         0.0010671732,
         0.0144845980,
         0.0068586187,
        -0.0148950462,
        -0.0099554838,
         0.0287258100,
         0.0336940430,
        -0.0543570170,
        -0.1559814091,
        -0.0690274966,
         0.3184854822,
         0.8385547671,
         1.1319110171,
         0.9710946252,
         0.4823707362,
         0.0215164197,
        -0.1585893044,
        -0.0930833884,
         0.0159925851,
         0.0382166722,
         0.0004021286,
        -0.0179858226,
        -0.0000925456,
         0.0150283118,
         0.0061428571,
        -0.0071954396,
    },
    {
        -0.0072304808,          /* Filter 67 */
         0.0011497556,
         0.0145148453,
         0.0067542051,
        -0.0149744164,
        -0.0098133120,
         0.0289198222,
         0.0334858520,
        -0.0549967007,
        -0.1562030935,
        -0.0677823139,
         0.3211228748,
         0.8409898048,
         1.1323113195,
         0.9691416503,
         0.4795759152,
         0.0197485194,
        -0.1587415890,
        -0.0924489546,
         0.0163733847,
         0.0381026799,
         0.0002031766,
        -0.0179654300,
         0.0000312425,
         0.0150415291,
         0.0060589152,
        -0.0072304808,
    },
    {
        -0.0072655220,          /* Filter 68 */
         0.0012323380,
         0.0145450926,
         0.0066497916,
        -0.0150537867,
        -0.0096711403,
         0.0291138344,
         0.0332776610,
        -0.0556363845,
        -0.1564247779,
        -0.0665371312,
         0.3237602674,
         0.8434248424,
         1.1327116219,
         0.9671886754,
         0.4767810943,
         0.0179806190,
        -0.1588938735,
        -0.0918145207,
         0.0167541843,
         0.0379886875,
         0.0000042245,
        -0.0179450374,
         0.0001550306,
         0.0150547463,
         0.0059749734,
        -0.0072655220,
    },
    {
        -0.0072985821,          /* Filter 69 */
         0.0013155000,
         0.0145726813,
         0.0065434604,
        -0.0151298737,
        -0.0095244794,
         0.0293040921,
         0.0330578948,
        -0.0562787584,
        -0.1566249133,
        -0.0652564027,
         0.3264137554,
         0.8458335104,
         1.1330588584,
         0.9651981011,
         0.4739908953,
         0.0162463699,
        -0.1590180464,
        -0.0911764983,
         0.0171238088,
         0.0378678131,
        -0.0001917859,
        -0.0179201415,
         0.0002782127,
         0.0150648964,
         0.0058906138,
        -0.0072985821,
    },
    {
        -0.0073316423,          /* Filter 70 */
         0.0013986619,
         0.0146002700,
         0.0064371292,
        -0.0152059606,
        -0.0093778185,
         0.0294943498,
         0.0328381287,
        -0.0569211323,
        -0.1568250487,
        -0.0639756742,
         0.3290672434,
         0.8482421784,
         1.1334060948,
         0.9632075269,
         0.4712006964,
         0.0145121209,
        -0.1591422194,
        -0.0905384758,
         0.0174934334,
         0.0377469388,
        -0.0003877963,
        -0.0178952456,
         0.0004013948,
         0.0150750465,
         0.0058062542,
        -0.0073316423,
    },
    {
        -0.0073647024,          /* Filter 71 */
         0.0014818238,
         0.0146278587,
         0.0063307981,
        -0.0152820476,
        -0.0092311577,
         0.0296846075,
         0.0326183626,
        -0.0575635062,
        -0.1570251841,
        -0.0626949457,
         0.3317207313,
         0.8506508464,
         1.1337533312,
         0.9612169527,
         0.4684104974,
         0.0127778718,
        -0.1592663923,
        -0.0899004534,
         0.0178630580,
         0.0376260645,
        -0.0005838066,
        -0.0178703496,
         0.0005245769,
         0.0150851966,
         0.0057218945,
        -0.0073647024,
    },
    {
        -0.0073977626,          /* Filter 72 */
         0.0015649858,
         0.0146554474,
         0.0062244669,
        -0.0153581346,
        -0.0090844968,
         0.0298748652,
         0.0323985964,
        -0.0582058801,
        -0.1572253195,
        -0.0614142172,
         0.3343742193,
         0.8530595144,
         1.1341005677,
         0.9592263784,
         0.4656202984,
         0.0110436227,
        -0.1593905652,
        -0.0892624310,
         0.0182326825,
         0.0375051901,
        -0.0007798170,
        -0.0178454537,
         0.0006477590,
         0.0150953467,
         0.0056375349,
        -0.0073977626,
    },
    {
        -0.0074288307,          /* Filter 73 */
         0.0016486610,
         0.0146803340,
         0.0061162982,
        -0.0154308360,
        -0.0089334270,
         0.0300611403,
         0.0321672283,
        -0.0588505405,
        -0.1574033979,
        -0.0600979721,
         0.3370430459,
         0.8554409500,
         1.1343946064,
         0.9571989365,
         0.4628355950,
         0.0093432676,
        -0.1594870480,
        -0.0886213085,
         0.0185910456,
         0.0373776477,
        -0.0009727457,
        -0.0178161239,
         0.0007702295,
         0.0151024434,
         0.0055528321,
        -0.0074288307,
    },
    {
        -0.0074598989,          /* Filter 74 */
         0.0017323362,
         0.0147052206,
         0.0060081295,
        -0.0155035374,
        -0.0087823572,
         0.0302474155,
         0.0319358603,
        -0.0594952010,
        -0.1575814762,
        -0.0587817270,
         0.3397118725,
         0.8578223857,
         1.1346886452,
         0.9551714946,
         0.4600508916,
         0.0076429125,
        -0.1595835309,
        -0.0879801860,
         0.0189494088,
         0.0372501053,
        -0.0011656744,
        -0.0177867940,
         0.0008927000,
         0.0151095401,
         0.0054681293,
        -0.0074598989,
    },
    {
        -0.0074909671,          /* Filter 75 */
         0.0018160114,
         0.0147301073,
         0.0058999608,
        -0.0155762387,
        -0.0086312874,
         0.0304336906,
         0.0317044922,
        -0.0601398614,
        -0.1577595546,
        -0.0574654818,
         0.3423806991,
         0.8602038214,
         1.1349826840,
         0.9531440526,
         0.4572661882,
         0.0059425574,
        -0.1596800138,
        -0.0873390634,
         0.0193077719,
         0.0371225630,
        -0.0013586031,
        -0.0177574641,
         0.0010151706,
         0.0151166368,
         0.0053834266,
        -0.0074909671,
    },
    {
        -0.0075220352,          /* Filter 76 */
         0.0018996866,
         0.0147549939,
         0.0057917921,
        -0.0156489401,
        -0.0084802176,
         0.0306199657,
         0.0314731241,
        -0.0607845218,
        -0.1579376330,
        -0.0561492367,
         0.3450495257,
         0.8625852570,
         1.1352767227,
         0.9511166107,
         0.4544814848,
         0.0042422023,
        -0.1597764966,
        -0.0866979409,
         0.0196661350,
         0.0369950206,
        -0.0015515318,
        -0.0177281343,
         0.0011376411,
         0.0151237335,
         0.0052987238,
        -0.0075220352,
    },
    {
        -0.0075511022,          /* Filter 77 */
         0.0019838077,
         0.0147771370,
         0.0056818683,
        -0.0157181554,
        -0.0083248237,
         0.0308020301,
         0.0312301354,
        -0.0614310576,
        -0.1580931511,
        -0.0547975203,
         0.3477329233,
         0.8649386054,
         1.1355174522,
         0.9490530451,
         0.4517031437,
         0.0025759672,
        -0.1598457194,
        -0.0860542014,
         0.0200131596,
         0.0368610264,
        -0.0017412432,
        -0.0176944430,
         0.0012592959,
         0.0151277930,
         0.0052137523,
        -0.0075511022,
    },
    {
        -0.0075801691,          /* Filter 78 */
         0.0020679289,
         0.0147992801,
         0.0055719445,
        -0.0157873707,
        -0.0081694298,
         0.0309840946,
         0.0309871466,
        -0.0620775934,
        -0.1582486693,
        -0.0534458038,
         0.3504163209,
         0.8672919537,
         1.1357581817,
         0.9469894795,
         0.4489248026,
         0.0009097321,
        -0.1599149422,
        -0.0854104620,
         0.0203601842,
         0.0367270322,
        -0.0019309546,
        -0.0176607517,
         0.0013809507,
         0.0151318525,
         0.0051287807,
        -0.0075801691,
    },
    {
        -0.0076092361,          /* Filter 79 */
         0.0021520500,
         0.0148214231,
         0.0054620207,
        -0.0158565859,
        -0.0080140360,
         0.0311661591,
         0.0307441579,
        -0.0627241291,
        -0.1584041874,
        -0.0520940873,
         0.3530997184,
         0.8696453021,
         1.1359989112,
         0.9449259138,
         0.4461464615,
        -0.0007565030,
        -0.1599841650,
        -0.0847667225,
         0.0207072088,
         0.0365930381,
        -0.0021206660,
        -0.0176270603,
         0.0015026056,
         0.0151359121,
         0.0050438092,
        -0.0076092361,
    },
    {
        -0.0076383031,          /* Filter 80 */
         0.0022361711,
         0.0148435662,
         0.0053520969,
        -0.0159258012,
        -0.0078586421,
         0.0313482235,
         0.0305011692,
        -0.0633706649,
        -0.1585597055,
        -0.0507423709,
         0.3557831160,
         0.8719986504,
         1.1362396407,
         0.9428623482,
         0.4433681204,
        -0.0024227381,
        -0.1600533878,
        -0.0841229830,
         0.0210542334,
         0.0364590439,
        -0.0023103774,
        -0.0175933690,
         0.0016242604,
         0.0151399716,
         0.0049588376,
        -0.0076383031,
    },
    {
        -0.0076653616,          /* Filter 81 */
         0.0023206699,
         0.0148629263,
         0.0052405027,
        -0.0159914320,
        -0.0076990139,
         0.0315258494,
         0.0302465494,
        -0.0640186574,
        -0.1586921653,
        -0.0493552445,
         0.3584803062,
         0.8743230646,
         1.1364269696,
         0.9407634148,
         0.4405970010,
        -0.0040546438,
        -0.1600957887,
        -0.0834771042,
         0.0213898515,
         0.0363188161,
        -0.0024967402,
        -0.0175553917,
         0.0017449971,
         0.0151410128,
         0.0048736713,
        -0.0076653616,
    },
    {
        -0.0076924201,          /* Filter 82 */
         0.0024051688,
         0.0148822863,
         0.0051289086,
        -0.0160570628,
        -0.0075393856,
         0.0317034753,
         0.0299919296,
        -0.0646666499,
        -0.1588246251,
        -0.0479681182,
         0.3611774964,
         0.8766474789,
         1.1366142985,
         0.9386644814,
         0.4378258816,
        -0.0056865495,
        -0.1601381896,
        -0.0828312254,
         0.0217254696,
         0.0361785883,
        -0.0026831030,
        -0.0175174144,
         0.0018657338,
         0.0151420539,
         0.0047885049,
        -0.0076924201,
    },
    {
        -0.0077194786,          /* Filter 83 */
         0.0024896677,
         0.0149016464,
         0.0050173145,
        -0.0161226937,
        -0.0073797574,
         0.0318811011,
         0.0297373097,
        -0.0653146424,
        -0.1589570848,
        -0.0465809918,
         0.3638746867,
         0.8789718932,
         1.1368016273,
         0.9365655480,
         0.4350547621,
        -0.0073184552,
        -0.1601805906,
        -0.0821853465,
         0.0220610877,
         0.0360383604,
        -0.0028694659,
        -0.0174794371,
         0.0019864706,
         0.0151430951,
         0.0047033386,
        -0.0077194786,
    },
    {
        -0.0077465371,          /* Filter 84 */
         0.0025741665,
         0.0149210065,
         0.0049057203,
        -0.0161883245,
        -0.0072201291,
         0.0320587270,
         0.0294826899,
        -0.0659626349,
        -0.1590895446,
        -0.0451938654,
         0.3665718769,
         0.8812963074,
         1.1369889562,
         0.9344666146,
         0.4322836427,
        -0.0089503609,
        -0.1602229915,
        -0.0815394677,
         0.0223967058,
         0.0358981326,
        -0.0030558287,
        -0.0174414598,
         0.0021072073,
         0.0151441363,
         0.0046181723,
        -0.0077465371,
    },
    {
        -0.0077715817,          /* Filter 85 */
         0.0026589739,
         0.0149375463,
         0.0047925427,
        -0.0162502746,
        -0.0070563609,
         0.0322316868,
         0.0292164368,
        -0.0666116582,
        -0.1591984533,
        -0.0437714067,
         0.3692820712,
         0.8835909493,
         1.1371228133,
         0.9323330810,
         0.4295205967,
        -0.0105477443,
        -0.1602390166,
        -0.0808919213,
         0.0227208584,
         0.0357518911,
        -0.0032387162,
        -0.0173992750,
         0.0022269252,
         0.0151421803,
         0.0045328849,
        -0.0077715817,
    },
    {
        -0.0077966263,          /* Filter 86 */
         0.0027437814,
         0.0149540860,
         0.0046793651,
        -0.0163122247,
        -0.0068925926,
         0.0324046465,
         0.0289501837,
        -0.0672606816,
        -0.1593073621,
        -0.0423489480,
         0.3719922654,
         0.8858855912,
         1.1372566705,
         0.9301995473,
         0.4267575507,
        -0.0121451278,
        -0.1602550416,
        -0.0802443750,
         0.0230450111,
         0.0356056497,
        -0.0034216036,
        -0.0173570901,
         0.0023466432,
         0.0151402244,
         0.0044475975,
        -0.0077966263,
    },
    {
        -0.0078216708,          /* Filter 87 */
         0.0028285889,
         0.0149706258,
         0.0045661874,
        -0.0163741748,
        -0.0067288244,
         0.0325776063,
         0.0286839306,
        -0.0679097049,
        -0.1594162708,
        -0.0409264892,
         0.3747024597,
         0.8881802332,
         1.1373905277,
         0.9280660136,
         0.4239945048,
        -0.0137425112,
        -0.1602710667,
        -0.0795968286,
         0.0233691637,
         0.0354594082,
        -0.0036044911,
        -0.0173149052,
         0.0024663611,
         0.0151382684,
         0.0043623100,
        -0.0078216708,
    },
    {
        -0.0078467154,          /* Filter 88 */
         0.0029133963,
         0.0149871656,
         0.0044530098,
        -0.0164361249,
        -0.0065650562,
         0.0327505660,
         0.0284176775,
        -0.0685587283,
        -0.1595251795,
        -0.0395040305,
         0.3774126540,
         0.8904748751,
         1.1375243848,
         0.9259324800,
         0.4212314588,
        -0.0153398946,
        -0.1602870918,
        -0.0789492822,
         0.0236933163,
         0.0353131667,
        -0.0037873786,
        -0.0172727204,
         0.0025860790,
         0.0151363124,
         0.0042770226,
        -0.0078467154,
    },
    {
        -0.0078697424,          /* Filter 89 */
         0.0029984424,
         0.0150008499,
         0.0043383378,
        -0.0164943003,
        -0.0063972472,
         0.0329186327,
         0.0281397975,
        -0.0692083494,
        -0.1596100502,
        -0.0380463334,
         0.3801350536,
         0.8927389154,
         1.1376047194,
         0.9237651249,
         0.4184773301,
        -0.0169025795,
        -0.1602771947,
        -0.0783005341,
         0.0240059536,
         0.0351611331,
        -0.0039666685,
        -0.0172264093,
         0.0027046791,
         0.0151313829,
         0.0041916871,
        -0.0078697424,
    },
    {
        -0.0078927693,          /* Filter 90 */
         0.0030834886,
         0.0150145343,
         0.0042236658,
        -0.0165524757,
        -0.0062294381,
         0.0330866994,
         0.0278619174,
        -0.0698579705,
        -0.1596949209,
        -0.0365886362,
         0.3828574533,
         0.8950029557,
         1.1376850540,
         0.9215977697,
         0.4157232014,
        -0.0184652644,
        -0.1602672976,
        -0.0776517859,
         0.0243185908,
         0.0350090996,
        -0.0041459584,
        -0.0171800981,
         0.0028232792,
         0.0151264535,
         0.0041063517,
        -0.0078927693,
    },
    {
        -0.0079157963,          /* Filter 91 */
         0.0031685348,
         0.0150282187,
         0.0041089937,
        -0.0166106510,
        -0.0060616291,
         0.0332547661,
         0.0275840373,
        -0.0705075917,
        -0.1597797917,
        -0.0351309390,
         0.3855798530,
         0.8972669961,
         1.1377653887,
         0.9194304146,
         0.4129690726,
        -0.0200279493,
        -0.1602574005,
        -0.0770030378,
         0.0246312280,
         0.0348570660,
        -0.0043252482,
        -0.0171337870,
         0.0029418794,
         0.0151215240,
         0.0040210163,
        -0.0079157963,
    },
    {
        -0.0079388232,          /* Filter 92 */
         0.0032535809,
         0.0150419030,
         0.0039943217,
        -0.0166688264,
        -0.0058938201,
         0.0334228328,
         0.0273061573,
        -0.0711572128,
        -0.1598646624,
        -0.0336732419,
         0.3883022526,
         0.8995310364,
         1.1378457233,
         0.9172630595,
         0.4102149439,
        -0.0215906342,
        -0.1602475034,
        -0.0763542897,
         0.0249438653,
         0.0347050324,
        -0.0045045381,
        -0.0170874759,
         0.0030604795,
         0.0151165945,
         0.0039356808,
        -0.0079388232,
    },
    {
        -0.0079598307,          /* Filter 93 */
         0.0033387951,
         0.0150526990,
         0.0038782465,
        -0.0167231354,
        -0.0057220741,
         0.0335857801,
         0.0270166651,
        -0.0718069918,
        -0.1599250142,
        -0.0321804167,
         0.3910360493,
         0.9017636552,
         1.1378725049,
         0.9150626725,
         0.4074705678,
        -0.0231184609,
        -0.1602121450,
        -0.0757047995,
         0.0252449461,
         0.0345474298,
        -0.0046801126,
        -0.0170371225,
         0.0031778648,
         0.0151087176,
         0.0038503700,
        -0.0079598307,
    },
    {
        -0.0079808382,          /* Filter 94 */
         0.0034240093,
         0.0150634949,
         0.0037621712,
        -0.0167774444,
        -0.0055503281,
         0.0337487275,
         0.0267271730,
        -0.0724567708,
        -0.1599853660,
        -0.0306875914,
         0.3937698460,
         0.9039962740,
         1.1378992865,
         0.9128622855,
         0.4047261917,
        -0.0246462875,
        -0.1601767866,
        -0.0750553093,
         0.0255460270,
         0.0343898273,
        -0.0048556871,
        -0.0169867691,
         0.0032952501,
         0.0151008407,
         0.0037650592,
        -0.0079808382,
    },
    {
        -0.0080018457,          /* Filter 95 */
         0.0035092234,
         0.0150742909,
         0.0036460959,
        -0.0168317533,
        -0.0053785821,
         0.0339116748,
         0.0264376808,
        -0.0731065499,
        -0.1600457179,
        -0.0291947661,
         0.3965036428,
         0.9062288927,
         1.1379260681,
         0.9106618985,
         0.4019818156,
        -0.0261741142,
        -0.1601414281,
        -0.0744058191,
         0.0258471078,
         0.0342322247,
        -0.0050312616,
        -0.0169364157,
         0.0034126354,
         0.0150929638,
         0.0036797484,
        -0.0080018457,
    },
    {
        -0.0080228532,          /* Filter 96 */
         0.0035944376,
         0.0150850869,
         0.0035300207,
        -0.0168860623,
        -0.0052068361,
         0.0340746221,
         0.0261481886,
        -0.0737563289,
        -0.1601060697,
        -0.0277019409,
         0.3992374395,
         0.9084615115,
         1.1379528497,
         0.9084615115,
         0.3992374395,
        -0.0277019409,
        -0.1601060697,
        -0.0737563289,
         0.0261481886,
         0.0340746221,
        -0.0052068361,
        -0.0168860623,
         0.0035300207,
         0.0150850869,
         0.0035944376,
        -0.0080228532,
    },
    {
        -0.0080418412,          /* Filter 97 */
         0.0036797484,
         0.0150929638,
         0.0034126354,
        -0.0169364157,
        -0.0050312616,
         0.0342322247,
         0.0258471078,
        -0.0744058191,
        -0.1601414281,
        -0.0261741142,
         0.4019818156,
         0.9106618985,
         1.1379260681,
         0.9062288927,
         0.3965036428,
        -0.0291947661,
        -0.1600457179,
        -0.0731065499,
         0.0264376808,
         0.0339116748,
        -0.0053785821,
        -0.0168317533,
         0.0036460959,
         0.0150742909,
         0.0035092234,
        -0.0080418412,
    },
    {
        -0.0080608292,          /* Filter 98 */
         0.0037650592,
         0.0151008407,
         0.0032952501,
        -0.0169867691,
        -0.0048556871,
         0.0343898273,
         0.0255460270,
        -0.0750553093,
        -0.1601767866,
        -0.0246462875,
         0.4047261917,
         0.9128622855,
         1.1378992865,
         0.9039962740,
         0.3937698460,
        -0.0306875914,
        -0.1599853660,
        -0.0724567708,
         0.0267271730,
         0.0337487275,
        -0.0055503281,
        -0.0167774444,
         0.0037621712,
         0.0150634949,
         0.0034240093,
        -0.0080608292,
    },
    {
        -0.0080798172,          /* Filter 99 */
         0.0038503700,
         0.0151087176,
         0.0031778648,
        -0.0170371225,
        -0.0046801126,
         0.0345474298,
         0.0252449461,
        -0.0757047995,
        -0.1602121450,
        -0.0231184609,
         0.4074705678,
         0.9150626725,
         1.1378725049,
         0.9017636552,
         0.3910360493,
        -0.0321804167,
        -0.1599250142,
        -0.0718069918,
         0.0270166651,
         0.0335857801,
        -0.0057220741,
        -0.0167231354,
         0.0038782465,
         0.0150526990,
         0.0033387951,
        -0.0080798172,
    },
    {
        -0.0080988052,          /* Filter 100 */
         0.0039356808,
         0.0151165945,
         0.0030604795,
        -0.0170874759,
        -0.0045045381,
         0.0347050324,
         0.0249438653,
        -0.0763542897,
        -0.1602475034,
        -0.0215906342,
         0.4102149439,
         0.9172630595,
         1.1378457233,
         0.8995310364,
         0.3883022526,
        -0.0336732419,
        -0.1598646624,
        -0.0711572128,
         0.0273061573,
         0.0334228328,
        -0.0058938201,
        -0.0166688264,
         0.0039943217,
         0.0150419030,
         0.0032535809,
        -0.0080988052,
    },
    {
        -0.0081157754,          /* Filter 101 */
         0.0040210163,
         0.0151215240,
         0.0029418794,
        -0.0171337870,
        -0.0043252482,
         0.0348570660,
         0.0246312280,
        -0.0770030378,
        -0.1602574005,
        -0.0200279493,
         0.4129690726,
         0.9194304146,
         1.1377653887,
         0.8972669961,
         0.3855798530,
        -0.0351309390,
        -0.1597797917,
        -0.0705075917,
         0.0275840373,
         0.0332547661,
        -0.0060616291,
        -0.0166106510,
         0.0041089937,
         0.0150282187,
         0.0031685348,
        -0.0081157754,
    },
    {
        -0.0081327457,          /* Filter 102 */
         0.0041063517,
         0.0151264535,
         0.0028232792,
        -0.0171800981,
        -0.0041459584,
         0.0350090996,
         0.0243185908,
        -0.0776517859,
        -0.1602672976,
        -0.0184652644,
         0.4157232014,
         0.9215977697,
         1.1376850540,
         0.8950029557,
         0.3828574533,
        -0.0365886362,
        -0.1596949209,
        -0.0698579705,
         0.0278619174,
         0.0330866994,
        -0.0062294381,
        -0.0165524757,
         0.0042236658,
         0.0150145343,
         0.0030834886,
        -0.0081327457,
    },
    {
        -0.0081497159,          /* Filter 103 */
         0.0041916871,
         0.0151313829,
         0.0027046791,
        -0.0172264093,
        -0.0039666685,
         0.0351611331,
         0.0240059536,
        -0.0783005341,
        -0.1602771947,
        -0.0169025795,
         0.4184773301,
         0.9237651249,
         1.1376047194,
         0.8927389154,
         0.3801350536,
        -0.0380463334,
        -0.1596100502,
        -0.0692083494,
         0.0281397975,
         0.0329186327,
        -0.0063972472,
        -0.0164943003,
         0.0043383378,
         0.0150008499,
         0.0029984424,
        -0.0081497159,
    },
    {
        -0.0081666861,          /* Filter 104 */
         0.0042770226,
         0.0151363124,
         0.0025860790,
        -0.0172727204,
        -0.0037873786,
         0.0353131667,
         0.0236933163,
        -0.0789492822,
        -0.1602870918,
        -0.0153398946,
         0.4212314588,
         0.9259324800,
         1.1375243848,
         0.8904748751,
         0.3774126540,
        -0.0395040305,
        -0.1595251795,
        -0.0685587283,
         0.0284176775,
         0.0327505660,
        -0.0065650562,
        -0.0164361249,
         0.0044530098,
         0.0149871656,
         0.0029133963,
        -0.0081666861,
    },
    {
        -0.0081816420,          /* Filter 105 */
         0.0043623100,
         0.0151382684,
         0.0024663611,
        -0.0173149052,
        -0.0036044911,
         0.0354594082,
         0.0233691637,
        -0.0795968286,
        -0.1602710667,
        -0.0137425112,
         0.4239945048,
         0.9280660136,
         1.1373905277,
         0.8881802332,
         0.3747024597,
        -0.0409264892,
        -0.1594162708,
        -0.0679097049,
         0.0286839306,
         0.0325776063,
        -0.0067288244,
        -0.0163741748,
         0.0045661874,
         0.0149706258,
         0.0028285889,
        -0.0081816420,
    },
    {
        -0.0081965980,          /* Filter 106 */
         0.0044475975,
         0.0151402244,
         0.0023466432,
        -0.0173570901,
        -0.0034216036,
         0.0356056497,
         0.0230450111,
        -0.0802443750,
        -0.1602550416,
        -0.0121451278,
         0.4267575507,
         0.9301995473,
         1.1372566705,
         0.8858855912,
         0.3719922654,
        -0.0423489480,
        -0.1593073621,
        -0.0672606816,
         0.0289501837,
         0.0324046465,
        -0.0068925926,
        -0.0163122247,
         0.0046793651,
         0.0149540860,
         0.0027437814,
        -0.0081965980,
    },
    {
        -0.0082115539,          /* Filter 107 */
         0.0045328849,
         0.0151421803,
         0.0022269252,
        -0.0173992750,
        -0.0032387162,
         0.0357518911,
         0.0227208584,
        -0.0808919213,
        -0.1602390166,
        -0.0105477443,
         0.4295205967,
         0.9323330810,
         1.1371228133,
         0.8835909493,
         0.3692820712,
        -0.0437714067,
        -0.1591984533,
        -0.0666116582,
         0.0292164368,
         0.0322316868,
        -0.0070563609,
        -0.0162502746,
         0.0047925427,
         0.0149375463,
         0.0026589739,
        -0.0082115539,
    },
    {
        -0.0082265098,          /* Filter 108 */
         0.0046181723,
         0.0151441363,
         0.0021072073,
        -0.0174414598,
        -0.0030558287,
         0.0358981326,
         0.0223967058,
        -0.0815394677,
        -0.1602229915,
        -0.0089503609,
         0.4322836427,
         0.9344666146,
         1.1369889562,
         0.8812963074,
         0.3665718769,
        -0.0451938654,
        -0.1590895446,
        -0.0659626349,
         0.0294826899,
         0.0320587270,
        -0.0072201291,
        -0.0161883245,
         0.0049057203,
         0.0149210065,
         0.0025741665,
        -0.0082265098,
    },
    {
        -0.0082394567,          /* Filter 109 */
         0.0047033386,
         0.0151430951,
         0.0019864706,
        -0.0174794371,
        -0.0028694659,
         0.0360383604,
         0.0220610877,
        -0.0821853465,
        -0.1601805906,
        -0.0073184552,
         0.4350547621,
         0.9365655480,
         1.1368016273,
         0.8789718932,
         0.3638746867,
        -0.0465809918,
        -0.1589570848,
        -0.0653146424,
         0.0297373097,
         0.0318811011,
        -0.0073797574,
        -0.0161226937,
         0.0050173145,
         0.0149016464,
         0.0024896677,
        -0.0082394567,
    },
    {
        -0.0082524037,          /* Filter 110 */
         0.0047885049,
         0.0151420539,
         0.0018657338,
        -0.0175174144,
        -0.0026831030,
         0.0361785883,
         0.0217254696,
        -0.0828312254,
        -0.1601381896,
        -0.0056865495,
         0.4378258816,
         0.9386644814,
         1.1366142985,
         0.8766474789,
         0.3611774964,
        -0.0479681182,
        -0.1588246251,
        -0.0646666499,
         0.0299919296,
         0.0317034753,
        -0.0075393856,
        -0.0160570628,
         0.0051289086,
         0.0148822863,
         0.0024051688,
        -0.0082524037,
    },
    {
        -0.0082653506,          /* Filter 111 */
         0.0048736713,
         0.0151410128,
         0.0017449971,
        -0.0175553917,
        -0.0024967402,
         0.0363188161,
         0.0213898515,
        -0.0834771042,
        -0.1600957887,
        -0.0040546438,
         0.4405970010,
         0.9407634148,
         1.1364269696,
         0.8743230646,
         0.3584803062,
        -0.0493552445,
        -0.1586921653,
        -0.0640186574,
         0.0302465494,
         0.0315258494,
        -0.0076990139,
        -0.0159914320,
         0.0052405027,
         0.0148629263,
         0.0023206699,
        -0.0082653506,
    },
    {
        -0.0082782975,          /* Filter 112 */
         0.0049588376,
         0.0151399716,
         0.0016242604,
        -0.0175933690,
        -0.0023103774,
         0.0364590439,
         0.0210542334,
        -0.0841229830,
        -0.1600533878,
        -0.0024227381,
         0.4433681204,
         0.9428623482,
         1.1362396407,
         0.8719986504,
         0.3557831160,
        -0.0507423709,
        -0.1585597055,
        -0.0633706649,
         0.0305011692,
         0.0313482235,
        -0.0078586421,
        -0.0159258012,
         0.0053520969,
         0.0148435662,
         0.0022361711,
        -0.0082782975,
    },
    {
        -0.0082892424,          /* Filter 113 */
         0.0050438092,
         0.0151359121,
         0.0015026056,
        -0.0176270603,
        -0.0021206660,
         0.0365930381,
         0.0207072088,
        -0.0847667225,
        -0.1599841650,
        -0.0007565030,
         0.4461464615,
         0.9449259138,
         1.1359989112,
         0.8696453021,
         0.3530997184,
        -0.0520940873,
        -0.1584041874,
        -0.0627241291,
         0.0307441579,
         0.0311661591,
        -0.0080140360,
        -0.0158565859,
         0.0054620207,
         0.0148214231,
         0.0021520500,
        -0.0082892424,
    },
    {
        -0.0083001873,          /* Filter 114 */
         0.0051287807,
         0.0151318525,
         0.0013809507,
        -0.0176607517,
        -0.0019309546,
         0.0367270322,
         0.0203601842,
        -0.0854104620,
        -0.1599149422,
         0.0009097321,
         0.4489248026,
         0.9469894795,
         1.1357581817,
         0.8672919537,
         0.3504163209,
        -0.0534458038,
        -0.1582486693,
        -0.0620775934,
         0.0309871466,
         0.0309840946,
        -0.0081694298,
        -0.0157873707,
         0.0055719445,
         0.0147992801,
         0.0020679289,
        -0.0083001873,
    },
    {
        -0.0083111322,          /* Filter 115 */
         0.0052137523,
         0.0151277930,
         0.0012592959,
        -0.0176944430,
        -0.0017412432,
         0.0368610264,
         0.0200131596,
        -0.0860542014,
        -0.1598457194,
         0.0025759672,
         0.4517031437,
         0.9490530451,
         1.1355174522,
         0.8649386054,
         0.3477329233,
        -0.0547975203,
        -0.1580931511,
        -0.0614310576,
         0.0312301354,
         0.0308020301,
        -0.0083248237,
        -0.0157181554,
         0.0056818683,
         0.0147771370,
         0.0019838077,
        -0.0083111322,
    },
    {
        -0.0083220771,          /* Filter 116 */
         0.0052987238,
         0.0151237335,
         0.0011376411,
        -0.0177281343,
        -0.0015515318,
         0.0369950206,
         0.0196661350,
        -0.0866979409,
        -0.1597764966,
         0.0042422023,
         0.4544814848,
         0.9511166107,
         1.1352767227,
         0.8625852570,
         0.3450495257,
        -0.0561492367,
        -0.1579376330,
        -0.0607845218,
         0.0314731241,
         0.0306199657,
        -0.0084802176,
        -0.0156489401,
         0.0057917921,
         0.0147549939,
         0.0018996866,
        -0.0083220771,
    },
    {
        -0.0083310287,          /* Filter 117 */
         0.0053834266,
         0.0151166368,
         0.0010151706,
        -0.0177574641,
        -0.0013586031,
         0.0371225630,
         0.0193077719,
        -0.0873390634,
        -0.1596800138,
         0.0059425574,
         0.4572661882,
         0.9531440526,
         1.1349826840,
         0.8602038214,
         0.3423806991,
        -0.0574654818,
        -0.1577595546,
        -0.0601398614,
         0.0317044922,
         0.0304336906,
        -0.0086312874,
        -0.0155762387,
         0.0058999608,
         0.0147301073,
         0.0018160114,
        -0.0083310287,
    },
    {
        -0.0083399803,          /* Filter 118 */
         0.0054681293,
         0.0151095401,
         0.0008927000,
        -0.0177867940,
        -0.0011656744,
         0.0372501053,
         0.0189494088,
        -0.0879801860,
        -0.1595835309,
         0.0076429125,
         0.4600508916,
         0.9551714946,
         1.1346886452,
         0.8578223857,
         0.3397118725,
        -0.0587817270,
        -0.1575814762,
        -0.0594952010,
         0.0319358603,
         0.0302474155,
        -0.0087823572,
        -0.0155035374,
         0.0060081295,
         0.0147052206,
         0.0017323362,
        -0.0083399803,
    },
    {
        -0.0083489318,          /* Filter 119 */
         0.0055528321,
         0.0151024434,
         0.0007702295,
        -0.0178161239,
        -0.0009727457,
         0.0373776477,
         0.0185910456,
        -0.0886213085,
        -0.1594870480,
         0.0093432676,
         0.4628355950,
         0.9571989365,
         1.1343946064,
         0.8554409500,
         0.3370430459,
        -0.0600979721,
        -0.1574033979,
        -0.0588505405,
         0.0321672283,
         0.0300611403,
        -0.0089334270,
        -0.0154308360,
         0.0061162982,
         0.0146803340,
         0.0016486610,
        -0.0083489318,
    },
    {
        -0.0083578834,          /* Filter 120 */
         0.0056375349,
         0.0150953467,
         0.0006477590,
        -0.0178454537,
        -0.0007798170,
         0.0375051901,
         0.0182326825,
        -0.0892624310,
        -0.1593905652,
         0.0110436227,
         0.4656202984,
         0.9592263784,
         1.1341005677,
         0.8530595144,
         0.3343742193,
        -0.0614142172,
        -0.1572253195,
        -0.0582058801,
         0.0323985964,
         0.0298748652,
        -0.0090844968,
        -0.0153581346,
         0.0062244669,
         0.0146554474,
         0.0015649858,
        -0.0083578834,
    },
    {
        -0.0083648520,          /* Filter 121 */
         0.0057218945,
         0.0150851966,
         0.0005245769,
        -0.0178703496,
        -0.0005838066,
         0.0376260645,
         0.0178630580,
        -0.0899004534,
        -0.1592663923,
         0.0127778718,
         0.4684104974,
         0.9612169527,
         1.1337533312,
         0.8506508464,
         0.3317207313,
        -0.0626949457,
        -0.1570251841,
        -0.0575635062,
         0.0326183626,
         0.0296846075,
        -0.0092311577,
        -0.0152820476,
         0.0063307981,
         0.0146278587,
         0.0014818238,
        -0.0083648520,
    },
    {
        -0.0083718207,          /* Filter 122 */
         0.0058062542,
         0.0150750465,
         0.0004013948,
        -0.0178952456,
        -0.0003877963,
         0.0377469388,
         0.0174934334,
        -0.0905384758,
        -0.1591422194,
         0.0145121209,
         0.4712006964,
         0.9632075269,
         1.1334060948,
         0.8482421784,
         0.3290672434,
        -0.0639756742,
        -0.1568250487,
        -0.0569211323,
         0.0328381287,
         0.0294943498,
        -0.0093778185,
        -0.0152059606,
         0.0064371292,
         0.0146002700,
         0.0013986619,
        -0.0083718207,
    },
    {
        -0.0083787894,          /* Filter 123 */
         0.0058906138,
         0.0150648964,
         0.0002782127,
        -0.0179201415,
        -0.0001917859,
         0.0378678131,
         0.0171238088,
        -0.0911764983,
        -0.1590180464,
         0.0162463699,
         0.4739908953,
         0.9651981011,
         1.1330588584,
         0.8458335104,
         0.3264137554,
        -0.0652564027,
        -0.1566249133,
        -0.0562787584,
         0.0330578948,
         0.0293040921,
        -0.0095244794,
        -0.0151298737,
         0.0065434604,
         0.0145726813,
         0.0013155000,
        -0.0083787894,
    },
    {
        -0.0083857580,          /* Filter 124 */
         0.0059749734,
         0.0150547463,
         0.0001550306,
        -0.0179450374,
         0.0000042245,
         0.0379886875,
         0.0167541843,
        -0.0918145207,
        -0.1588938735,
         0.0179806190,
         0.4767810943,
         0.9671886754,
         1.1327116219,
         0.8434248424,
         0.3237602674,
        -0.0665371312,
        -0.1564247779,
        -0.0556363845,
         0.0332776610,
         0.0291138344,
        -0.0096711403,
        -0.0150537867,
         0.0066497916,
         0.0145450926,
         0.0012323380,
        -0.0083857580,
    },
    {
        -0.0083907558,          /* Filter 125 */
         0.0060589152,
         0.0150415291,
         0.0000312425,
        -0.0179654300,
         0.0002031766,
         0.0381026799,
         0.0163733847,
        -0.0924489546,
        -0.1587415890,
         0.0197485194,
         0.4795759152,
         0.9691416503,
         1.1323113195,
         0.8409898048,
         0.3211228748,
        -0.0677823139,
        -0.1562030935,
        -0.0549967007,
         0.0334858520,
         0.0289198222,
        -0.0098133120,
        -0.0149744164,
         0.0067542051,
         0.0145148453,
         0.0011497556,
        -0.0083907558,
    },
    {
        -0.0083957537,          /* Filter 126 */
         0.0061428571,
         0.0150283118,
        -0.0000925456,
        -0.0179858226,
         0.0004021286,
         0.0382166722,
         0.0159925851,
        -0.0930833884,
        -0.1585893044,
         0.0215164197,
         0.4823707362,
         0.9710946252,
         1.1319110171,
         0.8385547671,
         0.3184854822,
        -0.0690274966,
        -0.1559814091,
        -0.0543570170,
         0.0336940430,
         0.0287258100,
        -0.0099554838,
        -0.0148950462,
         0.0068586187,
         0.0144845980,
         0.0010671732,
        -0.0083957537,
    },
    {
        -0.0084007515,          /* Filter 127 */
         0.0062267989,
         0.0150150946,
        -0.0002163337,
        -0.0180062152,
         0.0006010807,
         0.0383306645,
         0.0156117854,
        -0.0937178223,
        -0.1584370199,
         0.0232843200,
         0.4851655571,
         0.9730476000,
         1.1315107147,
         0.8361197295,
         0.3158480896,
        -0.0702726794,
        -0.1557597248,
        -0.0537173332,
         0.0339022340,
         0.0285317978,
        -0.0100976555,
        -0.0148156760,
         0.0069630322,
         0.0144543506,
         0.0009845909,
        -0.0084007515,
    },
    {
        -0.0084057493,          /* Filter 128 */
         0.0063107407,
         0.0150018773,
        -0.0003401218,
        -0.0180266078,
         0.0008000327,
         0.0384446569,
         0.0152309858,
        -0.0943522562,
        -0.1582847354,
         0.0250522204,
         0.4879603781,
         0.9750005749,
         1.1311104123,
         0.8336846919,
         0.3132106970,
        -0.0715178621,
        -0.1555380404,
        -0.0530776494,
         0.0341104250,
         0.0283377856,
        -0.0102398272,
        -0.0147363057,
         0.0070674458,
         0.0144241033,
         0.0009020085,
        -0.0084057493,
    },
    {
        -0.0084087900,          /* Filter 129 */
         0.0063941899,
         0.0149855817,
        -0.0004644087,
        -0.0180424310,
         0.0010017821,
         0.0385515555,
         0.0148391066,
        -0.0949826079,
        -0.1581039265,
         0.0268535128,
         0.4907589408,
         0.9769152314,
         1.1306571957,
         0.8312241547,
         0.3105901453,
        -0.0727274858,
        -0.1552953196,
        -0.0524410516,
         0.0343070757,
         0.0281402469,
        -0.0103774345,
        -0.0146537564,
         0.0071698639,
         0.0143912428,
         0.0008200711,
        -0.0084087900,
    },
    {
        -0.0084118308,          /* Filter 130 */
         0.0064776390,
         0.0149692862,
        -0.0005886957,
        -0.0180582542,
         0.0012035315,
         0.0386584542,
         0.0144472274,
        -0.0956129596,
        -0.1579231176,
         0.0286548053,
         0.4935575036,
         0.9788298879,
         1.1302039792,
         0.8287636175,
         0.3079695935,
        -0.0739371095,
        -0.1550525987,
        -0.0518044538,
         0.0345037263,
         0.0279427082,
        -0.0105150418,
        -0.0145712072,
         0.0072722821,
         0.0143583824,
         0.0007381336,
        -0.0084118308,
    },
    {
        -0.0084148715,          /* Filter 131 */
         0.0065610881,
         0.0149529906,
        -0.0007129826,
        -0.0180740774,
         0.0014052809,
         0.0387653529,
         0.0140553483,
        -0.0962433112,
        -0.1577423087,
         0.0304560978,
         0.4963560664,
         0.9807445444,
         1.1297507626,
         0.8263030803,
         0.3053490417,
        -0.0751467332,
        -0.1548098779,
        -0.0511678560,
         0.0347003770,
         0.0277451696,
        -0.0106526491,
        -0.0144886579,
         0.0073747002,
         0.0143255219,
         0.0006561962,
        -0.0084148715,
    },
    {
        -0.0084179123,          /* Filter 132 */
         0.0066445373,
         0.0149366950,
        -0.0008372696,
        -0.0180899006,
         0.0016070303,
         0.0388722515,
         0.0136634691,
        -0.0968736629,
        -0.1575614998,
         0.0322573902,
         0.4991546291,
         0.9826592009,
         1.1292975460,
         0.8238425431,
         0.3027284900,
        -0.0763563569,
        -0.1545671571,
        -0.0505312582,
         0.0348970277,
         0.0275476309,
        -0.0107902564,
        -0.0144061086,
         0.0074771184,
         0.0142926615,
         0.0005742587,
        -0.0084179123,
    },
    {
        -0.0084190113,          /* Filter 133 */
         0.0067274187,
         0.0149173125,
        -0.0009619468,
        -0.0181010915,
         0.0018114286,
         0.0389718474,
         0.0132606152,
        -0.0974994339,
        -0.1573517628,
         0.0340917989,
         0.5019560473,
         0.9845348330,
         1.1287915871,
         0.8213573834,
         0.3001255131,
        -0.0775304241,
        -0.1543039166,
        -0.0498981343,
         0.0350821807,
         0.0273467933,
        -0.0109232287,
        -0.0143204862,
         0.0075774657,
         0.0142572352,
         0.0004930304,
        -0.0084190113,
    },
    {
        -0.0084201103,          /* Filter 134 */
         0.0068103001,
         0.0148979301,
        -0.0010866241,
        -0.0181122824,
         0.0020158269,
         0.0390714433,
         0.0128577614,
        -0.0981252050,
        -0.1571420257,
         0.0359262076,
         0.5047574656,
         0.9864104651,
         1.1282856282,
         0.8188722237,
         0.2975225362,
        -0.0787044914,
        -0.1540406760,
        -0.0492650104,
         0.0352673337,
         0.0271459557,
        -0.0110562009,
        -0.0142348637,
         0.0076778131,
         0.0142218089,
         0.0004118021,
        -0.0084201103,
    },
    {
        -0.0084212093,          /* Filter 135 */
         0.0068931815,
         0.0148785476,
        -0.0012113014,
        -0.0181234734,
         0.0022202251,
         0.0391710391,
         0.0124549075,
        -0.0987509760,
        -0.1569322887,
         0.0377606163,
         0.5075588838,
         0.9882860972,
         1.1277796693,
         0.8163870640,
         0.2949195592,
        -0.0798785587,
        -0.1537774355,
        -0.0486318865,
         0.0354524867,
         0.0269451182,
        -0.0111891732,
        -0.0141492413,
         0.0077781605,
         0.0141863827,
         0.0003305737,
        -0.0084212093,
    },
    {
        -0.0084223083,          /* Filter 136 */
         0.0069760629,
         0.0148591651,
        -0.0013359786,
        -0.0181346643,
         0.0024246234,
         0.0392706350,
         0.0120520536,
        -0.0993767470,
        -0.1567225517,
         0.0395950250,
         0.5103603020,
         0.9901617293,
         1.1272737104,
         0.8139019043,
         0.2923165823,
        -0.0810526259,
        -0.1535141950,
        -0.0479987626,
         0.0356376397,
         0.0267442806,
        -0.0113221454,
        -0.0140636189,
         0.0078785078,
         0.0141509564,
         0.0002493454,
        -0.0084223083,
    },
    {
        -0.0084214825,          /* Filter 137 */
         0.0070583015,
         0.0148366898,
        -0.0014609363,
        -0.0181411635,
         0.0026315179,
         0.0393627217,
         0.0116383393,
        -0.0999974342,
        -0.1564834922,
         0.0414622576,
         0.5131636835,
         0.9919976443,
         1.1267152010,
         0.8113930056,
         0.2897319024,
        -0.0821911550,
        -0.1532309553,
        -0.0473694925,
         0.0358113454,
         0.0265403713,
        -0.0114504169,
        -0.0139750309,
         0.0079767115,
         0.0141130135,
         0.0001688893,
        -0.0084214825,
    },
    {
        -0.0084206567,          /* Filter 138 */
         0.0071405400,
         0.0148142145,
        -0.0015858941,
        -0.0181476627,
         0.0028384123,
         0.0394548085,
         0.0112246249,
        -0.1006181213,
        -0.1562444327,
         0.0433294902,
         0.5159670651,
         0.9938335593,
         1.1261566915,
         0.8088841069,
         0.2871472226,
        -0.0833296841,
        -0.1529477156,
        -0.0467402225,
         0.0359850512,
         0.0263364621,
        -0.0115786884,
        -0.0138864430,
         0.0080749152,
         0.0140750705,
         0.0000884333,
        -0.0084206567,
    },
    {
        -0.0084198310,          /* Filter 139 */
         0.0072227785,
         0.0147917392,
        -0.0017108518,
        -0.0181541619,
         0.0030453068,
         0.0395468952,
         0.0108109106,
        -0.1012388084,
        -0.1560053732,
         0.0451967228,
         0.5187704467,
         0.9956694743,
         1.1255981821,
         0.8063752082,
         0.2845625427,
        -0.0844682133,
        -0.1526644760,
        -0.0461109524,
         0.0361587569,
         0.0261325528,
        -0.0117069598,
        -0.0137978550,
         0.0081731188,
         0.0140371276,
         0.0000079772,
        -0.0084198310,
    },
    {
        -0.0084190052,          /* Filter 140 */
         0.0073050171,
         0.0147692639,
        -0.0018358095,
        -0.0181606611,
         0.0032522013,
         0.0396389819,
         0.0103971963,
        -0.1018594956,
        -0.1557663137,
         0.0470639554,
         0.5215738282,
         0.9975053893,
         1.1250396727,
         0.8038663095,
         0.2819778628,
        -0.0856067424,
        -0.1523812363,
        -0.0454816823,
         0.0363324626,
         0.0259286435,
        -0.0118352313,
        -0.0137092670,
         0.0082713225,
         0.0139991847,
        -0.0000724789,
        -0.0084190052,
    },
    {
        -0.0084162732,          /* Filter 141 */
         0.0073865376,
         0.0147436925,
        -0.0019609366,
        -0.0181624126,
         0.0034614352,
         0.0397233560,
         0.0099727451,
        -0.1024745913,
        -0.1554975469,
         0.0489637030,
         0.5243782755,
         0.9993009082,
         1.1244288244,
         0.8013345616,
         0.2794121900,
        -0.0867097673,
        -0.1520785217,
        -0.0448566378,
         0.0364947790,
         0.0257218890,
        -0.0119587410,
        -0.0136178226,
         0.0083673121,
         0.0139587762,
        -0.0001521007,
        -0.0084162732,
    },
    {
        -0.0084135412,          /* Filter 142 */
         0.0074680581,
         0.0147181210,
        -0.0020860637,
        -0.0181641642,
         0.0036706691,
         0.0398077301,
         0.0095482939,
        -0.1030896870,
        -0.1552287801,
         0.0508634507,
         0.5271827229,
         1.0010964271,
         1.1238179760,
         0.7988028136,
         0.2768465172,
        -0.0878127922,
        -0.1517758070,
        -0.0442315934,
         0.0366570954,
         0.0255151345,
        -0.0120822508,
        -0.0135263781,
         0.0084633017,
         0.0139183676,
        -0.0002317225,
        -0.0084135412,
    },
    {
        -0.0084108092,          /* Filter 143 */
         0.0075495786,
         0.0146925495,
        -0.0022111908,
        -0.0181659157,
         0.0038799031,
         0.0398921042,
         0.0091238428,
        -0.1037047827,
        -0.1549600134,
         0.0527631983,
         0.5299871702,
         1.0028919459,
         1.1232071276,
         0.7962710656,
         0.2742808445,
        -0.0889158172,
        -0.1514730924,
        -0.0436065490,
         0.0368194119,
         0.0253083800,
        -0.0122057605,
        -0.0134349336,
         0.0085592912,
         0.0138779590,
        -0.0003113444,
        -0.0084108092,
    },
    {
        -0.0084080772,          /* Filter 144 */
         0.0076310991,
         0.0146669781,
        -0.0023363179,
        -0.0181676672,
         0.0040891370,
         0.0399764783,
         0.0086993916,
        -0.1043198784,
        -0.1546912466,
         0.0546629459,
         0.5327916175,
         1.0046874648,
         1.1225962793,
         0.7937393177,
         0.2717151717,
        -0.0900188421,
        -0.1511703778,
        -0.0429815045,
         0.0369817283,
         0.0251016255,
        -0.0123292702,
        -0.0133434892,
         0.0086552808,
         0.0138375505,
        -0.0003909662,
        -0.0084080772,
    },
    {
        -0.0084034591,          /* Filter 145 */
         0.0077118264,
         0.0146383099,
        -0.0024615020,
        -0.0181646186,
         0.0043005496,
         0.0400529394,
         0.0082643366,
        -0.1049288709,
        -0.1543923977,
         0.0565948832,
         0.5355962280,
         1.0064419225,
         1.1219333234,
         0.7911856159,
         0.2691692038,
        -0.0910864123,
        -0.1508487156,
        -0.0423610491,
         0.0371327210,
         0.0248922515,
        -0.0124479620,
        -0.0132492987,
         0.0087489883,
         0.0137947290,
        -0.0004696930,
        -0.0084034591,
    },
    {
        -0.0083988409,          /* Filter 146 */
         0.0077925538,
         0.0146096417,
        -0.0025866862,
        -0.0181615700,
         0.0045119622,
         0.0401294005,
         0.0078292816,
        -0.1055378633,
        -0.1540935488,
         0.0585268205,
         0.5384008385,
         1.0081963802,
         1.1212703674,
         0.7886319141,
         0.2666232359,
        -0.0921539825,
        -0.1505270533,
        -0.0417405937,
         0.0372837136,
         0.0246828775,
        -0.0125666538,
        -0.0131551082,
         0.0088426959,
         0.0137519074,
        -0.0005484199,
        -0.0083988409,
    },
    {
        -0.0083942228,          /* Filter 147 */
         0.0078732811,
         0.0145809736,
        -0.0027118704,
        -0.0181585214,
         0.0047233748,
         0.0402058615,
         0.0073942266,
        -0.1061468558,
        -0.1537946998,
         0.0604587578,
         0.5412054490,
         1.0099508380,
         1.1206074115,
         0.7860782123,
         0.2640772680,
        -0.0932215526,
        -0.1502053910,
        -0.0411201383,
         0.0374347062,
         0.0244735035,
        -0.0126853455,
        -0.0130609178,
         0.0089364034,
         0.0137090859,
        -0.0006271468,
        -0.0083942228,
    },
    {
        -0.0083896047,          /* Filter 148 */
         0.0079540084,
         0.0145523054,
        -0.0028370545,
        -0.0181554728,
         0.0049347874,
         0.0402823226,
         0.0069591716,
        -0.1067558483,
        -0.1534958509,
         0.0623906951,
         0.5440100595,
         1.0117052957,
         1.1199444556,
         0.7835245105,
         0.2615313001,
        -0.0942891228,
        -0.1498837288,
        -0.0404996829,
         0.0375856989,
         0.0242641295,
        -0.0128040373,
        -0.0129667273,
         0.0090301109,
         0.0136662644,
        -0.0007058736,
        -0.0083896047,
    },
    {
        -0.0083831221,          /* Filter 149 */
         0.0080338675,
         0.0145205425,
        -0.0029621824,
        -0.0181475753,
         0.0051482140,
         0.0403506736,
         0.0065136553,
        -0.1073582218,
        -0.1531665552,
         0.0643544803,
         0.5468139260,
         1.0134180415,
         1.1192296431,
         0.7809497556,
         0.2590057222,
        -0.0953213029,
        -0.1495436493,
        -0.0398841716,
         0.0377254405,
         0.0240523607,
        -0.0129178597,
        -0.0128699026,
         0.0091214711,
         0.0136210843,
        -0.0007836460,
        -0.0083831221,
    },
    {
        -0.0083766394,          /* Filter 150 */
         0.0081137266,
         0.0144887797,
        -0.0030873103,
        -0.0181396778,
         0.0053616406,
         0.0404190246,
         0.0060681390,
        -0.1079605953,
        -0.1528372594,
         0.0663182654,
         0.5496177925,
         1.0151307873,
         1.1185148306,
         0.7783750007,
         0.2564801443,
        -0.0963534830,
        -0.1492035698,
        -0.0392686603,
         0.0378651821,
         0.0238405920,
        -0.0130316821,
        -0.0127730779,
         0.0092128313,
         0.0135759042,
        -0.0008614184,
        -0.0083766394,
    },
    {
        -0.0083701567,          /* Filter 151 */
         0.0081935858,
         0.0144570168,
        -0.0032124381,
        -0.0181317803,
         0.0055750672,
         0.0404873756,
         0.0056226226,
        -0.1085629689,
        -0.1525079637,
         0.0682820506,
         0.5524216589,
         1.0168435331,
         1.1178000180,
         0.7758002457,
         0.2539545665,
        -0.0973856632,
        -0.1488634904,
        -0.0386531490,
         0.0380049238,
         0.0236288232,
        -0.0131455046,
        -0.0126762532,
         0.0093041915,
         0.0135307242,
        -0.0009391908,
        -0.0083701567,
    },
    {
        -0.0083636741,          /* Filter 152 */
         0.0082734449,
         0.0144252539,
        -0.0033375660,
        -0.0181238828,
         0.0057884938,
         0.0405557266,
         0.0051771063,
        -0.1091653424,
        -0.1521786680,
         0.0702458358,
         0.5552255254,
         1.0185562789,
         1.1170852055,
         0.7732254908,
         0.2514289886,
        -0.0984178433,
        -0.1485234109,
        -0.0380376377,
         0.0381446654,
         0.0234170544,
        -0.0132593270,
        -0.0125794285,
         0.0093955517,
         0.0134855441,
        -0.0010169632,
        -0.0083636741,
    },
    {
        -0.0083553500,          /* Filter 153 */
         0.0083523609,
         0.0143904012,
        -0.0034625233,
        -0.0181110913,
         0.0060037659,
         0.0406157739,
         0.0047212807,
        -0.1097605776,
        -0.1518185712,
         0.0722411107,
         0.5580277364,
         1.0202266767,
         1.1163188069,
         0.7706305883,
         0.2489244731,
        -0.0994147134,
        -0.1481654471,
        -0.0374274171,
         0.0382732360,
         0.0232031144,
        -0.0133682335,
        -0.0124800826,
         0.0094845018,
         0.0134380614,
        -0.0010937229,
        -0.0083553500,
    },
    {
        -0.0083470259,          /* Filter 154 */
         0.0084312770,
         0.0143555485,
        -0.0035874805,
        -0.0180982998,
         0.0062190379,
         0.0406758213,
         0.0042654550,
        -0.1103558127,
        -0.1514584744,
         0.0742363857,
         0.5608299474,
         1.0218970744,
         1.1155524083,
         0.7680356859,
         0.2464199576,
        -0.1004115835,
        -0.1478074833,
        -0.0368171965,
         0.0384018067,
         0.0229891745,
        -0.0134771399,
        -0.0123807366,
         0.0095734519,
         0.0133905787,
        -0.0011704827,
        -0.0083470259,
    },
    {
        -0.0083387019,          /* Filter 155 */
         0.0085101930,
         0.0143206958,
        -0.0037124377,
        -0.0180855083,
         0.0064343100,
         0.0407358686,
         0.0038096294,
        -0.1109510478,
        -0.1510983776,
         0.0762316606,
         0.5636321583,
         1.0235674721,
         1.1147860096,
         0.7654407834,
         0.2439154420,
        -0.1014084535,
        -0.1474495196,
        -0.0362069758,
         0.0385303773,
         0.0227752346,
        -0.0135860464,
        -0.0122813907,
         0.0096624020,
         0.0133430961,
        -0.0012472424,
        -0.0083387019,
    },
    {
        -0.0083303778,          /* Filter 156 */
         0.0085891090,
         0.0142858431,
        -0.0038373950,
        -0.0180727168,
         0.0066495821,
         0.0407959159,
         0.0033538037,
        -0.1115462830,
        -0.1507382808,
         0.0782269355,
         0.5664343693,
         1.0252378699,
         1.1140196110,
         0.7628458810,
         0.2414109265,
        -0.1024053236,
        -0.1470915558,
        -0.0355967552,
         0.0386589480,
         0.0225612946,
        -0.0136949529,
        -0.0121820448,
         0.0097513521,
         0.0132956134,
        -0.0013240021,
        -0.0083303778,
    },
    {
        -0.0083202368,          /* Filter 157 */
         0.0086670073,
         0.0142479081,
        -0.0039620663,
        -0.0180549900,
         0.0068665274,
         0.0408474696,
         0.0028878302,
        -0.1121338569,
        -0.1503470394,
         0.0802533257,
         0.5692340095,
         1.0268652984,
         1.1132019161,
         0.7602317411,
         0.2389281325,
        -0.1033669786,
        -0.1467162430,
        -0.0349921631,
         0.0387764347,
         0.0223454057,
        -0.0137989015,
        -0.0120802917,
         0.0098378320,
         0.0132458857,
        -0.0013996923,
        -0.0083202368,
    },
    {
        -0.0083100959,          /* Filter 158 */
         0.0087449056,
         0.0142099731,
        -0.0040867377,
        -0.0180372632,
         0.0070834727,
         0.0408990232,
         0.0024218567,
        -0.1127214308,
        -0.1499557981,
         0.0822797160,
         0.5720336496,
         1.0284927270,
         1.1123842213,
         0.7576176012,
         0.2364453385,
        -0.1043286335,
        -0.1463409303,
        -0.0343875711,
         0.0388939214,
         0.0221295169,
        -0.0139028502,
        -0.0119785386,
         0.0099243119,
         0.0131961579,
        -0.0014753825,
        -0.0083100959,
    },
    {
        -0.0082999550,          /* Filter 159 */
         0.0088228040,
         0.0141720380,
        -0.0042114090,
        -0.0180195365,
         0.0073004179,
         0.0409505768,
         0.0019558832,
        -0.1133090048,
        -0.1495645568,
         0.0843061062,
         0.5748332898,
         1.0301201555,
         1.1115665265,
         0.7550034614,
         0.2339625446,
        -0.1052902885,
        -0.1459656175,
        -0.0337829790,
         0.0390114081,
         0.0219136281,
        -0.0140067989,
        -0.0118767855,
         0.0100107918,
         0.0131464301,
        -0.0015510728,
        -0.0082999550,
    },
    {
        -0.0082898140,          /* Filter 160 */
         0.0089007023,
         0.0141341030,
        -0.0043360803,
        -0.0180018097,
         0.0075173632,
         0.0410021305,
         0.0014899097,
        -0.1138965787,
        -0.1491733154,
         0.0863324965,
         0.5776329299,
         1.0317475841,
         1.1107488316,
         0.7523893215,
         0.2314797506,
        -0.1062519435,
        -0.1455903047,
        -0.0331783869,
         0.0391288948,
         0.0216977392,
        -0.0141107475,
        -0.0117750324,
         0.0100972717,
         0.0130967024,
        -0.0016267630,
        -0.0082898140,
    },
    {
        -0.0082778821,          /* Filter 161 */
         0.0089775086,
         0.0140930960,
        -0.0044603497,
        -0.0179791102,
         0.0077358057,
         0.0410450044,
         0.0010139594,
        -0.1144759654,
        -0.1487505969,
         0.0883896114,
         0.5804290805,
         1.0333314375,
         1.1098801496,
         0.7497568583,
         0.2290193240,
        -0.1071784933,
        -0.1451981802,
        -0.0325797525,
         0.0392353915,
         0.0214801224,
        -0.0142097012,
        -0.0116709872,
         0.0101812239,
         0.0130447886,
        -0.0017013282,
        -0.0082778821,
    },
    {
        -0.0082659503,          /* Filter 162 */
         0.0090543149,
         0.0140520889,
        -0.0045846191,
        -0.0179564107,
         0.0079542483,
         0.0410878783,
         0.0005380091,
        -0.1150553521,
        -0.1483278784,
         0.0904467264,
         0.5832252311,
         1.0349152908,
         1.1090114676,
         0.7471243951,
         0.2265588975,
        -0.1081050431,
        -0.1448060556,
        -0.0319811182,
         0.0393418882,
         0.0212625055,
        -0.0143086549,
        -0.0115669419,
         0.0102651761,
         0.0129928749,
        -0.0017758935,
        -0.0082659503,
    },
    {
        -0.0082540185,          /* Filter 163 */
         0.0091311211,
         0.0140110819,
        -0.0047088885,
        -0.0179337113,
         0.0081726908,
         0.0411307521,
         0.0000620587,
        -0.1156347387,
        -0.1479051599,
         0.0925038414,
         0.5860213816,
         1.0364991441,
         1.1081427855,
         0.7444919319,
         0.2240984709,
        -0.1090315928,
        -0.1444139311,
        -0.0313824838,
         0.0394483848,
         0.0210448887,
        -0.0144076086,
        -0.0114628967,
         0.0103491284,
         0.0129409612,
        -0.0018504587,
        -0.0082540185,
    },
    {
        -0.0082420866,          /* Filter 164 */
         0.0092079274,
         0.0139700749,
        -0.0048331579,
        -0.0179110118,
         0.0083911333,
         0.0411736260,
        -0.0004138916,
        -0.1162141254,
        -0.1474824414,
         0.0945609563,
         0.5888175322,
         1.0380829975,
         1.1072741035,
         0.7418594687,
         0.2216380443,
        -0.1099581426,
        -0.1440218066,
        -0.0307838494,
         0.0395548815,
         0.0208272719,
        -0.0145065623,
        -0.0113588515,
         0.0104330806,
         0.0128890474,
        -0.0019250239,
        -0.0082420866,
    },
    {
        -0.0082283912,          /* Filter 165 */
         0.0092835676,
         0.0139260090,
        -0.0049569085,
        -0.0178833062,
         0.0086108936,
         0.0412076380,
        -0.0008996382,
        -0.1167847959,
        -0.1470279245,
         0.0966483892,
         0.5916092714,
         1.0396226852,
         1.1063547626,
         0.7392096000,
         0.2192006174,
        -0.1108497118,
        -0.1436134093,
        -0.0301914931,
         0.0396504889,
         0.0206081464,
        -0.0146004886,
        -0.0112526301,
         0.0105144504,
         0.0128350080,
        -0.0019984100,
        -0.0082283912,
    },
    {
        -0.0082146959,          /* Filter 166 */
         0.0093592079,
         0.0138819430,
        -0.0050806591,
        -0.0178556005,
         0.0088306538,
         0.0412416500,
        -0.0013853848,
        -0.1173554664,
        -0.1465734077,
         0.0987358221,
         0.5944010105,
         1.0411623729,
         1.1054354216,
         0.7365597312,
         0.2167631905,
        -0.1117412809,
        -0.1432050120,
        -0.0295991367,
         0.0397460963,
         0.0203890209,
        -0.0146944149,
        -0.0111464087,
         0.0105958202,
         0.0127809687,
        -0.0020717962,
        -0.0082146959,
    },
    {
        -0.0082010005,          /* Filter 167 */
         0.0094348481,
         0.0138378770,
        -0.0052044097,
        -0.0178278949,
         0.0090504141,
         0.0412756620,
        -0.0018711315,
        -0.1179261368,
        -0.1461188909,
         0.1008232550,
         0.5971927497,
         1.0427020605,
         1.1045160806,
         0.7339098625,
         0.2143257637,
        -0.1126328501,
        -0.1427966148,
        -0.0290067804,
         0.0398417036,
         0.0201698953,
        -0.0147883412,
        -0.0110401874,
         0.0106771900,
         0.0127269293,
        -0.0021451824,
        -0.0082010005,
    },
    {
        -0.0081873051,          /* Filter 168 */
         0.0095104884,
         0.0137938111,
        -0.0053281603,
        -0.0178001892,
         0.0092701743,
         0.0413096740,
        -0.0023568781,
        -0.1184968073,
        -0.1456643740,
         0.1029106879,
         0.5999844889,
         1.0442417482,
         1.1035967397,
         0.7312599938,
         0.2118883368,
        -0.1135244193,
        -0.1423882175,
        -0.0284144241,
         0.0399373110,
         0.0199507698,
        -0.0148822675,
        -0.0109339660,
         0.0107585598,
         0.0126728899,
        -0.0022185685,
        -0.0081873051,
    },
    {
        -0.0081718749,          /* Filter 169 */
         0.0095848891,
         0.0137467021,
        -0.0054512747,
        -0.0177674479,
         0.0094910693,
         0.0413346462,
        -0.0028522309,
        -0.1190582300,
        -0.1451777490,
         0.1050280159,
         0.6027708922,
         1.0457366955,
         1.1026270869,
         0.7285936405,
         0.2094745282,
        -0.1143811470,
        -0.1419640879,
        -0.0278286572,
         0.0400221364,
         0.0197303531,
        -0.0149711387,
        -0.0108256852,
         0.0108372951,
         0.0126167868,
        -0.0022907229,
        -0.0081718749,
    },
    {
        -0.0081564448,          /* Filter 170 */
         0.0096592897,
         0.0136995931,
        -0.0055743891,
        -0.0177347066,
         0.0097119643,
         0.0413596184,
        -0.0033475838,
        -0.1196196527,
        -0.1446911239,
         0.1071453439,
         0.6055572955,
         1.0472316428,
         1.1016574340,
         0.7259272872,
         0.2070607195,
        -0.1152378747,
        -0.1415399582,
        -0.0272428903,
         0.0401069617,
         0.0195099365,
        -0.0150600100,
        -0.0107174044,
         0.0109160303,
         0.0125606836,
        -0.0023628774,
        -0.0081564448,
    },
    {
        -0.0081410146,          /* Filter 171 */
         0.0097336904,
         0.0136524840,
        -0.0056975035,
        -0.0177019653,
         0.0099328593,
         0.0413845907,
        -0.0038429366,
        -0.1201810753,
        -0.1442044989,
         0.1092626720,
         0.6083436989,
         1.0487265902,
         1.1006877812,
         0.7232609339,
         0.2046469108,
        -0.1160946025,
        -0.1411158285,
        -0.0266571235,
         0.0401917871,
         0.0192895198,
        -0.0151488812,
        -0.0106091236,
         0.0109947656,
         0.0125045805,
        -0.0024350318,
        -0.0081410146,
    },
    {
        -0.0081255844,          /* Filter 172 */
         0.0098080911,
         0.0136053750,
        -0.0058206179,
        -0.0176692240,
         0.0101537543,
         0.0414095629,
        -0.0043382895,
        -0.1207424980,
        -0.1437178738,
         0.1113800000,
         0.6111301022,
         1.0502215375,
         1.0997181284,
         0.7205945806,
         0.2022331022,
        -0.1169513302,
        -0.1406916989,
        -0.0260713566,
         0.0402766124,
         0.0190691031,
        -0.0152377524,
        -0.0105008428,
         0.0110735009,
         0.0124484774,
        -0.0025071863,
        -0.0081255844,
    },
    {
        -0.0081084495,          /* Filter 173 */
         0.0098811792,
         0.0135552415,
        -0.0059429781,
        -0.0176314216,
         0.0103755977,
         0.0414253219,
        -0.0048430490,
        -0.1212941389,
        -0.1431988426,
         0.1135267845,
         0.6139102430,
         1.0516711859,
         1.0986985296,
         0.7179126665,
         0.1998435162,
        -0.1177733700,
        -0.1402523783,
        -0.0254924816,
         0.0403507694,
         0.0188476109,
        -0.0153215454,
        -0.0103906199,
         0.0111495523,
         0.0123903736,
        -0.0025780580,
        -0.0081084495,
    },
    {
        -0.0080913145,          /* Filter 174 */
         0.0099542672,
         0.0135051081,
        -0.0060653383,
        -0.0175936193,
         0.0105974410,
         0.0414410808,
        -0.0053478084,
        -0.1218457798,
        -0.1426798114,
         0.1156735689,
         0.6166903838,
         1.0531208343,
         1.0976789308,
         0.7152307524,
         0.1974539303,
        -0.1185954098,
        -0.1398130578,
        -0.0249136066,
         0.0404249265,
         0.0186261188,
        -0.0154053385,
        -0.0102803970,
         0.0112256038,
         0.0123322698,
        -0.0026489296,
        -0.0080913145,
    },
    {
        -0.0080741796,          /* Filter 175 */
         0.0100273553,
         0.0134549746,
        -0.0061876986,
        -0.0175558169,
         0.0108192844,
         0.0414568398,
        -0.0058525679,
        -0.1223974207,
        -0.1421607801,
         0.1178203534,
         0.6194705246,
         1.0545704826,
         1.0966593320,
         0.7125488383,
         0.1950643444,
        -0.1194174496,
        -0.1393737373,
        -0.0243347316,
         0.0404990835,
         0.0184046266,
        -0.0154891315,
        -0.0101701741,
         0.0113016552,
         0.0122741660,
        -0.0027198013,
        -0.0080741796,
    },
    {
        -0.0080570447,          /* Filter 176 */
         0.0101004434,
         0.0134048412,
        -0.0063100588,
        -0.0175180145,
         0.0110411278,
         0.0414725987,
        -0.0063573274,
        -0.1229490616,
        -0.1416417489,
         0.1199671379,
         0.6222506654,
         1.0560201310,
         1.0956397332,
         0.7098669242,
         0.1926747584,
        -0.1202394894,
        -0.1389344167,
        -0.0237558566,
         0.0405732405,
         0.0181831345,
        -0.0155729245,
        -0.0100599512,
         0.0113777066,
         0.0122160622,
        -0.0027906730,
        -0.0080570447,
    },
    {
        -0.0080382364,          /* Filter 177 */
         0.0101721464,
         0.0133517048,
        -0.0064315464,
        -0.0174751298,
         0.0112637299,
         0.0414789754,
        -0.0068712844,
        -0.1234903846,
        -0.1410900254,
         0.1221429243,
         0.6250236152,
         1.0574239382,
         1.0945705729,
         0.7071703754,
         0.1903099855,
        -0.1210270090,
        -0.1384804475,
        -0.0231841667,
         0.0406368492,
         0.0179607805,
        -0.0156516210,
        -0.0099479042,
         0.0114510276,
         0.0121560221,
        -0.0028602122,
        -0.0080382364,
    },
    {
        -0.0080194281,          /* Filter 178 */
         0.0102438494,
         0.0132985683,
        -0.0065530340,
        -0.0174322452,
         0.0114863321,
         0.0414853522,
        -0.0073852414,
        -0.1240317076,
        -0.1405383020,
         0.1243187106,
         0.6277965649,
         1.0588277453,
         1.0935014125,
         0.7044738266,
         0.1879452126,
        -0.1218145285,
        -0.1380264784,
        -0.0226124769,
         0.0407004580,
         0.0177384266,
        -0.0157303174,
        -0.0098358572,
         0.0115243486,
         0.0120959820,
        -0.0029297514,
        -0.0080194281,
    },
    {
        -0.0080006198,          /* Filter 179 */
         0.0103155524,
         0.0132454319,
        -0.0066745217,
        -0.0173893605,
         0.0117089343,
         0.0414917289,
        -0.0078991983,
        -0.1245730307,
        -0.1399865786,
         0.1264944970,
         0.6305695147,
         1.0602315525,
         1.0924322522,
         0.7017772778,
         0.1855804396,
        -0.1226020481,
        -0.1375725092,
        -0.0220407870,
         0.0407640667,
         0.0175160726,
        -0.0158090139,
        -0.0097238102,
         0.0115976695,
         0.0120359418,
        -0.0029992907,
        -0.0080006198,
    },
    {
        -0.0079818115,          /* Filter 180 */
         0.0103872554,
         0.0131922955,
        -0.0067960093,
        -0.0173464758,
         0.0119315364,
         0.0414981056,
        -0.0084131553,
        -0.1251143537,
        -0.1394348551,
         0.1286702834,
         0.6333424645,
         1.0616353597,
         1.0913630919,
         0.6990807290,
         0.1832156667,
        -0.1233895677,
        -0.1371185400,
        -0.0214690972,
         0.0408276754,
         0.0172937187,
        -0.0158877103,
        -0.0096117632,
         0.0116709905,
         0.0119759017,
        -0.0030688299,
        -0.0079818115,
    },
    {
        -0.0079613624,          /* Filter 181 */
         0.0104575015,
         0.0131361803,
        -0.0069165056,
        -0.0172984917,
         0.0121547045,
         0.0414949359,
        -0.0089360912,
        -0.1256448209,
        -0.1388501656,
         0.1308746015,
         0.6361072934,
         1.0629927999,
         1.0902447728,
         0.6963704736,
         0.1808762827,
        -0.1241427487,
        -0.1366504649,
        -0.0209048767,
         0.0408808619,
         0.0170707144,
        -0.0159612963,
        -0.0094980105,
         0.0117415372,
         0.0119139907,
        -0.0031369887,
        -0.0079613624,
    },
    {
        -0.0079409132,          /* Filter 182 */
         0.0105277476,
         0.0130800652,
        -0.0070370019,
        -0.0172505076,
         0.0123778727,
         0.0414917662,
        -0.0094590271,
        -0.1261752882,
        -0.1382654762,
         0.1330789196,
         0.6388721222,
         1.0643502402,
         1.0891264538,
         0.6936602182,
         0.1785368986,
        -0.1248959297,
        -0.1361823898,
        -0.0203406562,
         0.0409340485,
         0.0168477102,
        -0.0160348823,
        -0.0093842577,
         0.0118120839,
         0.0118520798,
        -0.0032051475,
        -0.0079409132,
    },
    {
        -0.0079204640,          /* Filter 183 */
         0.0105979936,
         0.0130239501,
        -0.0071574981,
        -0.0172025235,
         0.0126010409,
         0.0414885965,
        -0.0099819630,
        -0.1267057555,
        -0.1376807868,
         0.1352832377,
         0.6416369510,
         1.0657076804,
         1.0880081347,
         0.6909499628,
         0.1761975146,
        -0.1256491108,
        -0.1357143147,
        -0.0197764357,
         0.0409872351,
         0.0166247059,
        -0.0161084683,
        -0.0092705050,
         0.0118826305,
         0.0117901689,
        -0.0032733062,
        -0.0079204640,
    },
    {
        -0.0079000149,          /* Filter 184 */
         0.0106682397,
         0.0129678349,
        -0.0072779944,
        -0.0171545394,
         0.0128242090,
         0.0414854268,
        -0.0105048989,
        -0.1272362227,
        -0.1370960973,
         0.1374875558,
         0.6444017799,
         1.0670651207,
         1.0868898157,
         0.6882397074,
         0.1738581306,
        -0.1264022918,
        -0.1352462396,
        -0.0192122152,
         0.0410404216,
         0.0164017016,
        -0.0161820543,
        -0.0091567523,
         0.0119531772,
         0.0117282579,
        -0.0033414650,
        -0.0079000149,
    },
    {
        -0.0078779587,          /* Filter 185 */
         0.0107369577,
         0.0129087681,
        -0.0073973803,
        -0.0171014431,
         0.0130477473,
         0.0414725514,
        -0.0110365856,
        -0.1277552947,
        -0.1364781806,
         0.1397199198,
         0.6471575569,
         1.0683756853,
         1.0857227590,
         0.6855166750,
         0.1715446968,
        -0.1271213298,
        -0.1347646015,
        -0.0186557390,
         0.0410833180,
         0.0161782562,
        -0.0162505206,
        -0.0090414127,
         0.0120209086,
         0.0116645427,
        -0.0034081968,
        -0.0078779587,
    },
    {
        -0.0078559026,          /* Filter 186 */
         0.0108056758,
         0.0128497013,
        -0.0075167661,
        -0.0170483468,
         0.0132712856,
         0.0414596759,
        -0.0115682723,
        -0.1282743666,
        -0.1358602638,
         0.1419522838,
         0.6499133339,
         1.0696862498,
         1.0845557023,
         0.6827936425,
         0.1692312630,
        -0.1278403679,
        -0.1342829635,
        -0.0180992628,
         0.0411262144,
         0.0159548109,
        -0.0163189869,
        -0.0089260730,
         0.0120886399,
         0.0116008276,
        -0.0034749286,
        -0.0078559026,
    },
    {
        -0.0078338464,          /* Filter 187 */
         0.0108743939,
         0.0127906345,
        -0.0076361520,
        -0.0169952506,
         0.0134948240,
         0.0414468005,
        -0.0120999589,
        -0.1287934386,
        -0.1352423471,
         0.1441846479,
         0.6526691109,
         1.0709968144,
         1.0833886456,
         0.6800706101,
         0.1669178292,
        -0.1285594059,
        -0.1338013254,
        -0.0175427866,
         0.0411691108,
         0.0157313656,
        -0.0163874531,
        -0.0088107333,
         0.0121563712,
         0.0115371125,
        -0.0035416604,
        -0.0078338464,
    },
    {
        -0.0078117902,          /* Filter 188 */
         0.0109431119,
         0.0127315677,
        -0.0077555379,
        -0.0169421543,
         0.0137183623,
         0.0414339250,
        -0.0126316456,
        -0.1293125105,
        -0.1346244304,
         0.1464170119,
         0.6554248879,
         1.0723073790,
         1.0822215889,
         0.6773475777,
         0.1646043954,
        -0.1292784439,
        -0.1333196873,
        -0.0169863104,
         0.0412120072,
         0.0155079202,
        -0.0164559194,
        -0.0086953937,
         0.0122241026,
         0.0114733973,
        -0.0036083922,
        -0.0078117902,
    },
    {
        -0.0077897340,          /* Filter 189 */
         0.0110118299,
         0.0126725009,
        -0.0078749238,
        -0.0168890580,
         0.0139419006,
         0.0414210496,
        -0.0131633323,
        -0.1298315825,
        -0.1340065137,
         0.1486493759,
         0.6581806649,
         1.0736179436,
         1.0810545322,
         0.6746245453,
         0.1622909616,
        -0.1299974819,
        -0.1328380492,
        -0.0164298342,
         0.0412549036,
         0.0152844749,
        -0.0165243857,
        -0.0085800541,
         0.0122918340,
         0.0114096821,
        -0.0036751240,
        -0.0077897340,
    },
    {
        -0.0077676778,          /* Filter 190 */
         0.0110805480,
         0.0126134341,
        -0.0079943096,
        -0.0168359618,
         0.0141654390,
         0.0414081741,
        -0.0136950189,
        -0.1303506544,
        -0.1333885969,
         0.1508817400,
         0.6609364419,
         1.0749285081,
         1.0798874755,
         0.6719015128,
         0.1599775278,
        -0.1307165199,
        -0.1323564111,
        -0.0158733580,
         0.0412978000,
         0.0150610295,
        -0.0165928520,
        -0.0084647144,
         0.0123595653,
         0.0113459670,
        -0.0037418558,
        -0.0077676778,
    },
    {
        -0.0077456217,          /* Filter 191 */
         0.0111492661,
         0.0125543673,
        -0.0081136955,
        -0.0167828655,
         0.0143889773,
         0.0413952987,
        -0.0142267056,
        -0.1308697263,
        -0.1327706802,
         0.1531141040,
         0.6636922189,
         1.0762390727,
         1.0787204188,
         0.6691784804,
         0.1576640940,
        -0.1314355580,
        -0.1318747731,
        -0.0153168818,
         0.0413406964,
         0.0148375842,
        -0.0166613182,
        -0.0083493747,
         0.0124272966,
         0.0112822519,
        -0.0038085876,
        -0.0077456217,
    }
};
#endif

/* The following table maps the 8 soft-decisions associated with every possible point in the
   constellation space. If you look at the constellations carefully, all 4 can be accurately
   mapped at 0.5 unit resolution. */
const static uint8_t constel_maps[4][36][36][8] =
{
    {   /* 14,400bps map */
        {
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x63, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x63, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x66, 0x7f},
            {0x10, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x66, 0x7f},
            {0x18, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x41, 0x7a, 0x73, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x7a, 0x73, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x73, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x73, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x76, 0x6f},
            {0x18, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x76, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x63, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x63, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x66, 0x7f},
            {0x10, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x66, 0x7f},
            {0x18, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x41, 0x7a, 0x73, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x7a, 0x73, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x73, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x73, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x76, 0x6f},
            {0x18, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x76, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x29, 0x5a, 0x23, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x5a, 0x23, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x23, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x23, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x66, 0x7f},
            {0x10, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x66, 0x7f},
            {0x18, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x21, 0x7a, 0x33, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x7a, 0x33, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x33, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x33, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x76, 0x6f},
            {0x18, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x76, 0x6f},
            {0x58, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x29, 0x5a, 0x23, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x5a, 0x23, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x23, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x23, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x66, 0x7f},
            {0x10, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x66, 0x7f},
            {0x18, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x21, 0x7a, 0x33, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x7a, 0x33, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x33, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x33, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x76, 0x6f},
            {0x18, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x76, 0x6f},
            {0x58, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x26, 0x5f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x26, 0x5f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x26, 0x7f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x26, 0x7f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x36, 0x7f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x36, 0x7f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x36, 0x6f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x36, 0x6f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x16, 0x6f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x16, 0x6f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x26, 0x5f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x26, 0x5f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x26, 0x7f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x26, 0x7f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x36, 0x7f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x36, 0x7f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x36, 0x6f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x36, 0x6f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x16, 0x6f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x16, 0x6f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x46, 0x1f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x46, 0x1f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x26, 0x1f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x26, 0x1f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x26, 0x3f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x26, 0x3f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x36, 0x3f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x36, 0x3f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x36, 0x2f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x36, 0x2f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x16, 0x2f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x16, 0x2f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x46, 0x1f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x46, 0x1f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x26, 0x1f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x26, 0x1f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x26, 0x3f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x26, 0x3f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x36, 0x3f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x36, 0x3f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x36, 0x2f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x36, 0x2f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x16, 0x2f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x16, 0x2f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x46, 0x1f},
            {0x70, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x46, 0x1f},
            {0x30, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x29, 0x1a, 0x23, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x1a, 0x23, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x23, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x23, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x26, 0x3f},
            {0x30, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x26, 0x3f},
            {0x38, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x21, 0x3a, 0x33, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x3a, 0x33, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x33, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x33, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x36, 0x2f},
            {0x38, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x36, 0x2f},
            {0x78, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x61, 0x2a, 0x13, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x2a, 0x13, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x13, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x13, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x46, 0x1f},
            {0x70, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x46, 0x1f},
            {0x30, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x29, 0x1a, 0x23, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x1a, 0x23, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x23, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x23, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x26, 0x3f},
            {0x30, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x26, 0x3f},
            {0x38, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x21, 0x3a, 0x33, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x3a, 0x33, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x33, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x33, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x36, 0x2f},
            {0x38, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x36, 0x2f},
            {0x78, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x61, 0x2a, 0x13, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x2a, 0x13, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x13, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x13, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x46, 0x1f},
            {0x70, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x46, 0x1f},
            {0x30, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x39, 0x1a, 0x2b, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x1a, 0x2b, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x2b, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x2b, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x26, 0x3f},
            {0x30, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x26, 0x3f},
            {0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x31, 0x3a, 0x3b, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x3a, 0x3b, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x3b, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x3b, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x36, 0x2f},
            {0x38, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x36, 0x2f},
            {0x78, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x71, 0x2a, 0x1b, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x2a, 0x1b, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x1b, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x1b, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x46, 0x1f},
            {0x70, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x46, 0x1f},
            {0x30, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x39, 0x1a, 0x2b, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x1a, 0x2b, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x2b, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x2b, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x26, 0x3f},
            {0x30, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x26, 0x3f},
            {0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x31, 0x3a, 0x3b, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x3a, 0x3b, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x3b, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x3b, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x36, 0x2f},
            {0x38, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x36, 0x2f},
            {0x78, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x71, 0x2a, 0x1b, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x2a, 0x1b, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x1b, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x1b, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x4e, 0x1f},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x4e, 0x1f},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x2e, 0x1f},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x2e, 0x1f},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x2e, 0x3f},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x2e, 0x3f},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x3e, 0x3f},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x3e, 0x3f},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x3e, 0x2f},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x3e, 0x2f},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x1e, 0x2f},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x1e, 0x2f},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x1e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x1e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f}
        },
        {
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x4e, 0x1f},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x4e, 0x1f},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x2e, 0x1f},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x2e, 0x1f},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x2e, 0x3f},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x2e, 0x3f},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x3e, 0x3f},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x3e, 0x3f},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x3e, 0x2f},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x3e, 0x2f},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x1e, 0x2f},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x1e, 0x2f},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x1e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x1e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f}
        },
        {
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x4e, 0x17},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x4e, 0x17},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x2e, 0x17},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x2e, 0x17},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x2e, 0x37},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x2e, 0x37},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x3e, 0x37},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x3e, 0x37},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x3e, 0x27},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x3e, 0x27},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x1e, 0x27},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x1e, 0x27},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x1e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x1e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47}
        },
        {
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x4e, 0x17},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x4e, 0x17},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x2e, 0x17},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x2e, 0x17},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x2e, 0x37},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x2e, 0x37},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x3e, 0x37},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x3e, 0x37},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x3e, 0x27},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x3e, 0x27},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x1e, 0x27},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x1e, 0x27},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x1e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x1e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x39, 0x12, 0x2b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x12, 0x2b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x2b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x2b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x2e, 0x37},
            {0x20, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x2e, 0x37},
            {0x28, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x31, 0x32, 0x3b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x32, 0x3b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x3b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x3b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x3e, 0x27},
            {0x28, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x3e, 0x27},
            {0x68, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x71, 0x22, 0x1b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x22, 0x1b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x1b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x1b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x39, 0x12, 0x2b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x12, 0x2b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x2b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x2b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x2e, 0x37},
            {0x20, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x2e, 0x37},
            {0x28, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x31, 0x32, 0x3b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x32, 0x3b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x3b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x3b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x3e, 0x27},
            {0x28, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x3e, 0x27},
            {0x68, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x71, 0x22, 0x1b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x22, 0x1b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x1b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x1b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x19, 0x12, 0x6b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x12, 0x6b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x6b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x6b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x2e, 0x37},
            {0x20, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x2e, 0x37},
            {0x28, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x11, 0x32, 0x7b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x32, 0x7b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x7b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x7b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x3e, 0x27},
            {0x28, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x3e, 0x27},
            {0x68, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x51, 0x22, 0x5b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x22, 0x5b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x19, 0x12, 0x6b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x12, 0x6b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x6b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x6b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x2e, 0x37},
            {0x20, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x2e, 0x37},
            {0x28, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x11, 0x32, 0x7b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x32, 0x7b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x7b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x7b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x3e, 0x27},
            {0x28, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x3e, 0x27},
            {0x68, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x51, 0x22, 0x5b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x22, 0x5b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x6e, 0x37},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x6e, 0x37},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x7e, 0x37},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x7e, 0x37},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x7e, 0x27},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x7e, 0x27},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x5e, 0x27},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x6e, 0x37},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x6e, 0x37},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x7e, 0x37},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x7e, 0x37},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x7e, 0x27},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x7e, 0x27},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x5e, 0x27},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x6e, 0x77},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x6e, 0x77},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x7e, 0x77},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x7e, 0x77},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x7e, 0x67},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x7e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x6e, 0x77},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x6e, 0x77},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x7e, 0x77},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x7e, 0x77},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x7e, 0x67},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x7e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x11, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x11, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67}
        }
    },
    {   /* 12,000bps map */
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27}
        },
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27}
        },
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27}
        },
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27}
        },
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17}
        }
    },
    {   /* 9,600bps map */
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17}
        }
    },
    {   /* 7,200bps map */
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        }
    },
};

float v17_rx_carrier_frequency(v17_rx_state_t *s)
{
    return s->carrier_phase_rate*(float) SAMPLE_RATE/(65536.0*65536.0);
}
/*- End of function --------------------------------------------------------*/

float v17_rx_symbol_timing_correction(v17_rx_state_t *s)
{
    return s->gardner_total_correction;
}
/*- End of function --------------------------------------------------------*/

float v17_rx_signal_power(v17_rx_state_t *s)
{
    return power_meter_dbm0(&s->power);
}
/*- End of function --------------------------------------------------------*/

void v17_rx_signal_cutoff(v17_rx_state_t *s, float cutoff)
{
    s->carrier_on_power = power_meter_level_dbm0(cutoff - 2.5);
    s->carrier_off_power = power_meter_level_dbm0(cutoff + 2.5);
}
/*- End of function --------------------------------------------------------*/

int v17_rx_equalizer_state(v17_rx_state_t *s, complex_t **coeffs)
{
    *coeffs = s->eq_coeff;
    return 2*V17_EQUALIZER_LEN + 1;
}
/*- End of function --------------------------------------------------------*/

static void equalizer_save(v17_rx_state_t *s)
{
    int i;

    for (i = 0;  i < 2*V17_EQUALIZER_LEN + 1;  i++)
        s->eq_coeff_save[i] = s->eq_coeff[i];
}
/*- End of function --------------------------------------------------------*/

static void equalizer_restore(v17_rx_state_t *s)
{
    int i;

    for (i = 0;  i < 2*V17_EQUALIZER_LEN + 1;  i++)
        s->eq_coeff[i] = s->eq_coeff_save[i];
    for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
        s->eq_buf[i] = complex_set(0.0, 0.0);

    s->eq_put_step = PULSESHAPER_COEFF_SETS*10/(3*2) - 1;
    s->eq_step = 0;
    s->eq_delta = EQUALIZER_DELTA/(2*V17_EQUALIZER_LEN + 1);
}
/*- End of function --------------------------------------------------------*/

static void equalizer_reset(v17_rx_state_t *s)
{
    int i;

    /* Start with an equalizer based on everything being perfect */
    for (i = 0;  i < 2*V17_EQUALIZER_LEN + 1;  i++)
        s->eq_coeff[i] = complex_set(0.0, 0.0);
    s->eq_coeff[V17_EQUALIZER_LEN] = complex_set(3.0, 0.0);
    for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
        s->eq_buf[i] = complex_set(0.0, 0.0);

    s->eq_put_step = PULSESHAPER_COEFF_SETS*10/(3*2) - 1;
    s->eq_step = 0;
    s->eq_delta = EQUALIZER_DELTA/(2*V17_EQUALIZER_LEN + 1);
}
/*- End of function --------------------------------------------------------*/

static __inline__ complex_t equalizer_get(v17_rx_state_t *s)
{
    int i;
    int p;
    complex_t z;
    complex_t z1;

    /* Get the next equalized value. */
    z = complex_set(0.0, 0.0);
    p = s->eq_step - 1;
    for (i = 0;  i < 2*V17_EQUALIZER_LEN + 1;  i++)
    {
        p = (p - 1) & V17_EQUALIZER_MASK;
        z1 = complex_mul(&s->eq_coeff[i], &s->eq_buf[p]);
        z = complex_add(&z, &z1);
    }
    return z;
}
/*- End of function --------------------------------------------------------*/

static void tune_equalizer(v17_rx_state_t *s, const complex_t *z, const complex_t *target)
{
    int i;
    int p;
    complex_t ez;
    complex_t z1;

    /* Find the x and y mismatch from the exact constellation position. */
    ez = complex_sub(target, z);
    //span_log(&s->logging, SPAN_LOG_FLOW, "Equalizer error %f\n", sqrt(ez.re*ez.re + ez.im*ez.im));
    ez.re *= s->eq_delta;
    ez.im *= s->eq_delta;

    p = s->eq_step - 1;
    for (i = 0;  i < 2*V17_EQUALIZER_LEN + 1;  i++)
    {
        p = (p - 1) & V17_EQUALIZER_MASK;
        z1 = complex_conj(&s->eq_buf[p]);
        z1 = complex_mul(&ez, &z1);
        s->eq_coeff[i] = complex_add(&s->eq_coeff[i], &z1);
        /* Leak a little to tame uncontrolled wandering */
        s->eq_coeff[i].re *= 0.9999;
        s->eq_coeff[i].im *= 0.9999;
    }
}
/*- End of function --------------------------------------------------------*/

static int descramble(v17_rx_state_t *s, int in_bit)
{
    int out_bit;

    out_bit = (in_bit ^ (s->scramble_reg >> 17) ^ (s->scramble_reg >> 22)) & 1;
    s->scramble_reg <<= 1;
    if (s->in_training > TRAINING_STAGE_NORMAL_OPERATION  &&  s->in_training < TRAINING_STAGE_TCM_WINDUP)
        s->scramble_reg |= out_bit;
    else
        s->scramble_reg |= (in_bit & 1);
    return out_bit;
}
/*- End of function --------------------------------------------------------*/

static __inline__ int find_quadrant(complex_t *z)
{
    int b1;
    int b2;

    /* Split the space along the two diagonals. */
    b1 = (z->im > z->re);
    b2 = (z->im < -z->re);
    return (b2 << 1) | (b1 ^ b2);
}
/*- End of function --------------------------------------------------------*/

static void track_carrier(v17_rx_state_t *s, const complex_t *z, const complex_t *target)
{
    complex_t zz;

    /* For small errors the imaginary part of zz is now proportional to the phase error,
       for any particular target. However, the different amplitudes of the various target
       positions scale things. */

    zz = complex_conj(target);
    zz = complex_mul(z, &zz);
    
    s->carrier_phase_rate += s->carrier_track_i*zz.im;
    s->carrier_phase += s->carrier_track_p*zz.im;
    span_log(&s->logging, SPAN_LOG_FLOW, "Im = %15.5f   f = %15.5f\n", zz.im, (float) s->carrier_phase_rate*SAMPLE_RATE/(65536.0*65536.0));
    printf("Im = %15.5f (%15.5f)  f = %15.5f\n", zz.im, s->carrier_track_i, (float) s->carrier_phase_rate*SAMPLE_RATE/(65536.0*65536.0));
}
/*- End of function --------------------------------------------------------*/

static __inline__ void put_bit(v17_rx_state_t *s, int bit)
{
    int out_bit;

    /* We need to strip the last part of the training - the test period of all 1s -
       before we let data go to the application. */
    if (s->in_training == TRAINING_STAGE_NORMAL_OPERATION)
    {
        out_bit = descramble(s, bit);
        s->put_bit(s->user_data, out_bit);
    }
    else if (s->in_training == TRAINING_STAGE_TEST_ONES)
    {
        /* The bits during the final stage of training should be all ones. However,
           buggy modems mean you cannot rely on this. Therefore we don't bother
           testing for ones, but just rely on a constellation mismatch measurement. */
        out_bit = descramble(s, bit);
        span_log(&s->logging, SPAN_LOG_FLOW, "A 1 is really %d\n", out_bit);
    }
}
/*- End of function --------------------------------------------------------*/

static int decode_baud(v17_rx_state_t *s, complex_t *z)
{
    static const int diff_code[16] =
    {
        0, 3, 2, 1, 1, 0, 3, 2, 2, 1, 0, 3, 3, 2, 1, 0                         
    };
    static const int tcm_paths[8][4] =
    {
        {0, 6, 2, 4},
        {6, 0, 4, 2},
        {2, 4, 0, 6},
        {4, 2, 6, 0},
        {1, 3, 7, 5},
        {5, 7, 3, 1},
        {7, 5, 1, 3},
        {3, 1, 5, 7}
    };
    int nearest;
    int i;
    int j;
    int k;
    int re;
    int im;
    int raw;
    int constellation_state;
    float distances[8];
    float new_distances[8];
    float min;

    re = (z->re + 9.0)*2.0;
    if (re > 35)
        re = 35;
    else if (re < 0)
        re = 0;
    im = (z->im + 9.0)*2.0;
    if (im > 35)
        im = 35;
    else if (im < 0)
        im = 0;

    /* Find a set of 8 candidate constellation positions, that are the closest
       to the target, with different patterns in the last 3 bits. */
    min = 9999999.0;
    j = 0;
    for (i = 0;  i < 8;  i++)
    {
        nearest = constel_maps[s->space_map][re][im][i];
        distances[i] = (s->constellation[nearest].re - z->re)*(s->constellation[nearest].re - z->re)
                     + (s->constellation[nearest].im - z->im)*(s->constellation[nearest].im - z->im);
        if (min > distances[i])
        {
            min = distances[i];
            j = i;
        }
    }
    /* Use the nearest of these soft-decisions as the basis for DFE */
    constellation_state = constel_maps[s->space_map][re][im][j];
    /* Control the equalizer, carrier tracking, etc. based on the non-trellis
       corrected information. The trellis correct stuff comes out a bit late. */
    track_carrier(s, z, &s->constellation[constellation_state]);
    //tune_equalizer(s, z, &s->constellation[constellation_state]);

    /* Now do the trellis decoding */
    /* Update the minimum accumulated distance to each of the 8 states */
    if (++s->trellis_ptr >= V17_TRELLIS_DEPTH)
        s->trellis_ptr = 0;
    for (i = 0;  i < 4;  i++)
    {
        min = distances[tcm_paths[i][0]] + s->distances[0];
        k = 0;
        for (j = 1;  j < 4;  j++)
        {
            if (min > distances[tcm_paths[i][j]] + s->distances[j << 1])
            {
                min = distances[tcm_paths[i][j]] + s->distances[j << 1];
                k = j;
            }
        }
        /* Use an elementary IIR filter to track the distance to date. */
        new_distances[i] = s->distances[k << 1]*0.9 + distances[tcm_paths[i][k]]*0.1;
        s->full_path_to_past_state_locations[s->trellis_ptr][i] = constel_maps[s->space_map][re][im][tcm_paths[i][k]];
        s->past_state_locations[s->trellis_ptr][i] = k << 1;
    }
    for (i = 4;  i < 8;  i++)
    {
        min = distances[tcm_paths[i][0]] + s->distances[1];
        k = 0;
        for (j = 1;  j < 4;  j++)
        {
            if (min > distances[tcm_paths[i][j]] + s->distances[(j << 1) + 1])
            {
                min = distances[tcm_paths[i][j]] + s->distances[(j << 1) + 1];
                k = j;
            }
        }
        new_distances[i] = s->distances[(k << 1) + 1]*0.9 + distances[tcm_paths[i][k]]*0.1;
        s->full_path_to_past_state_locations[s->trellis_ptr][i] = constel_maps[s->space_map][re][im][tcm_paths[i][k]];
        s->past_state_locations[s->trellis_ptr][i] = (k << 1) + 1;
    }
    memcpy(s->distances, new_distances, sizeof(s->distances));

    /* Find the minimum distance to date. This is the start of the path back to the result. */
    min = s->distances[0];
    k = 0;
    for (i = 1;  i < 8;  i++)
    {
        if (min > s->distances[i])
        {
            min = s->distances[i];
            k = i;
        }
    }
    /* Trace back through every time step, starting with the current one, and find the
       state from which the path came one step before. At the end of this search, the
       last state found also points to the constellation point at that state. This is the
       output of the trellis. */
    for (i = 0, j = s->trellis_ptr;  i < V17_TRELLIS_DEPTH - 1;  i++)
    {
        k = s->past_state_locations[j][k];
        if (--j < 0)
            j = V17_TRELLIS_DEPTH - 1;
    }
    nearest = s->full_path_to_past_state_locations[j][k] >> 1;

    /* Differentially decode */
    raw = (nearest & 0x3C) | diff_code[((nearest & 0x03) << 2) | s->diff];
    s->diff = nearest & 0x03;
    for (i = 0;  i < s->bits_per_symbol;  i++)
    {
        put_bit(s, raw);
        raw >>= 1;
    }
    return constellation_state;
}
/*- End of function --------------------------------------------------------*/

int fred = 0;

static void process_baud(v17_rx_state_t *s, const complex_t *sample)
{
    static const complex_t cdba[4] =
    {
        { 6.0,  2.0},
        {-2.0,  6.0},
        { 2.0, -6.0},
        {-6.0, -2.0}
    };
    complex_t z;
    complex_t zz;
    const complex_t *target;
    float p;
    float q;
    int bit;
    int i;
    int j;
    float phase;
    int32_t angle;
    int32_t ang;
    int constellation_state;

    s->rrc_filter[s->rrc_filter_step] =
    s->rrc_filter[s->rrc_filter_step + V17RX_FILTER_STEPS] = *sample;
    if (++s->rrc_filter_step >= V17RX_FILTER_STEPS)
        s->rrc_filter_step = 0;
    /* Put things into the equalization buffer at T/2 rate. The Gardner algorithm
       will fiddle the step to align this with the bits. */
    if ((s->eq_put_step -= PULSESHAPER_COEFF_SETS) > 0)
    {
        //span_log(&s->logging, SPAN_LOG_FLOW, "Samp, %f, %f, %f, 0, 0x%X\n", z.re, z.im, sqrt(z.re*z.re + z.im*z.im), s->eq_put_step);
        return;
    }

    /* This is our interpolation filter and phase shifter, as well as our demod filter. */
    j = -s->eq_put_step;
    if (j > PULSESHAPER_COEFF_SETS - 1)
        j = PULSESHAPER_COEFF_SETS - 1;
    z = complex_set(0.0, 0.0);
    for (i = 0;  i < V17RX_FILTER_STEPS;  i++)
    {
        z.re += pulseshaper[j][i]*s->rrc_filter[i + s->rrc_filter_step].re;
        z.im += pulseshaper[j][i]*s->rrc_filter[i + s->rrc_filter_step].im;
    }
    z.re *= 1.0/PULSESHAPER_GAIN;
    z.im *= 1.0/PULSESHAPER_GAIN;

    s->eq_put_step += PULSESHAPER_COEFF_SETS*10/(3*2);

    /* Add a sample to the equalizer's circular buffer, but don't calculate anything
       at this time. */
    s->eq_buf[s->eq_step] = z;
    s->eq_step = (s->eq_step + 1) & V17_EQUALIZER_MASK;

    /* On alternate insertions we have a whole baud and must process it. */
    if ((s->baud_phase ^= 1))
        return;

#if 0
    /* Perform a Gardner test for baud alignment on the three most recent samples. */
    p = s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].re
      - s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].re;
    p *= s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].re;
    s->gardner_integrate += (p > 0.0)  ?  s->gardner_step  :  -s->gardner_step;

    q = s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].im
      - s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].im;
    q *= s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].im;

    s->gardner_integrate += (q > 0.0)  ?  s->gardner_step  :  -s->gardner_step;
#else
    if ((s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].re + s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].re) < 2.0*s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].re)
        p = -s->gardner_step;
    else
        p = s->gardner_step;
    if (s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].re > s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].re)
        p = -p;
    s->gardner_integrate += (p > 0.0)  ?  s->gardner_step  :  -s->gardner_step;

    if ((s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].im + s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].im) < 2.0*s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].im)
        q = -s->gardner_step;
    else
        q = s->gardner_step;
    if (s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].im > s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].im)
        q = -q;

    s->gardner_integrate += (q > 0.0)  ?  s->gardner_step  :  -s->gardner_step;
#endif

    if (abs(s->gardner_integrate) >= 16)
    {
        /* This integrate and dump approach avoids rapid changes of the equalizer put step.
           Rapid changes, without hysteresis, are bad. They degrade the equalizer performance
           when the true symbol boundary is close to a sample boundary. */
        s->eq_put_step += (s->gardner_integrate/16);
        s->gardner_total_correction += (s->gardner_integrate/16);
        if (s->qam_report)
            s->qam_report(s->qam_user_data, NULL, NULL, s->gardner_integrate);
        s->gardner_integrate = 0;
    }

    span_log(&s->logging, SPAN_LOG_FLOW, "Gardtest %d %d %d\n", fred++, s->gardner_total_correction, s->gardner_step);

    z = equalizer_get(s);

    constellation_state = 0;
    switch (s->in_training)
    {
    case TRAINING_STAGE_NORMAL_OPERATION:
        /* Normal operation. */
        constellation_state = decode_baud(s, &z);
        target = &s->constellation[constellation_state];
        break;
    case TRAINING_STAGE_SYMBOL_ACQUISITION:
        /* Allow time for the Gardner algorithm to settle the symbol timing. */
        target = &z;
        /* Don't start narrowing the bandwidth of the Gardner algorithm too early.
           Some modems are a bit wobbly when they start sending the signal. Also, we start
           this analysis before our filter buffers have completely filled. */
        if (++s->training_count == 30)
            s->gardner_step = 16;
        else if (s->training_count == 40)
            s->gardner_step = 8;
        else if (s->training_count >= 50)
        {
            /* Record the current phase angle */
            s->angles[0] =
            s->start_angles[0] = arctan2(z.im, z.re);
            /* QAM and Gardner only play nicely with heavy damping, so we need to change to
               a slow rate of symbol timing adaption. However, it must not be so slow that it
               cannot track the worst case timing error specified in V.17. This should be 0.01%,
               but since we might be off in the opposite direction from the source, the total
               error could be higher. */
            s->gardner_step = 8;
            s->in_training = TRAINING_STAGE_LOG_PHASE;
        }
        break;
    case TRAINING_STAGE_LOG_PHASE:
        /* Record the current alternate phase angle */
        target = &z;
        angle = arctan2(z.im, z.re);
        s->training_count = 1;
        if (s->short_train)
        {
            /* Check if we just saw A or B */
            if ((uint32_t) (angle - s->start_angles[0]) < 0x80000000U)
            {
                angle = s->start_angles[0];
                s->angles[0] = 0x80000000 + 219937506;
                s->angles[1] = 0xC0000000 + 219937506;
            }
            else
            {
                s->training_count = 0;
                s->angles[0] = 0xC0000000 + 219937506;
                s->angles[1] = 0x80000000 + 219937506;
            }
            /* Make a step shift in the phase, to pull it into line. We need to rotate the RRC filter
               buffer and the equalizer buffer, as well as the carrier phase, for this to play out
               nicely. */
            /* angle is now the difference between where A is, and where it should be */
            p = 3.14159 + angle*2.0*3.14159/(65536.0*65536.0) - 0.321751;
            span_log(&s->logging, SPAN_LOG_FLOW, "Spin (short) by %.5f rads\n", p);
            printf("Spin (short) by %.5f rads\n", p);
            zz = complex_set(cos(p), -sin(p));
            for (i = 0;  i < 2*V17RX_FILTER_STEPS;  i++)
                s->rrc_filter[i] = complex_mul(&s->rrc_filter[i], &zz);
            for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
                s->eq_buf[i] = complex_mul(&s->eq_buf[i], &zz);
            s->carrier_phase += (0x80000000 + angle - 219937506);

            s->carrier_track_i = 100.0;
            s->carrier_track_p = 500000.0;

            s->in_training = TRAINING_STAGE_SHORT_WAIT_FOR_CDBA;
        }
        else
        {
            s->angles[1] =
            s->start_angles[1] = angle;
            s->in_training = TRAINING_STAGE_WAIT_FOR_CDBA;
        }
        break;
    case TRAINING_STAGE_WAIT_FOR_CDBA:
        target = &z;
        angle = arctan2(z.im, z.re);
        /* Look for the initial ABAB sequence to display a phase reversal, which will
           signal the start of the scrambled CDBA segment */
        ang = angle - s->angles[(s->training_count - 1) & 0xF];
printf("Ang= %10d %15.5f %15.5f\n", angle, z.im, z.re);
        s->angles[(s->training_count + 1) & 0xF] = angle;

        if ((ang > 0x40000000  ||  ang < -0x40000000)  &&  s->training_count >= 13)
        {
printf("We seem to have a reversal at symbol %d\n", s->training_count);
            /* We seem to have a phase reversal */
            /* Slam the carrier frequency into line, based on the total phase drift over the last
               section. Use the shift from the odd bits and the shift from the even bits to get
               better jitter suppression. */
            /* TODO: We are supposed to deal with frequancy errors up to +-8Hz. Over 200+
                     symbols that is more than half a cycle. We get confused an do crazy things.
                     We can only cope with errors up to 5Hz right now. We need to implement
                     greater tolerance to be compliant, although it doesn't really matter much
                     these days. */
            /* Step back a few symbols so we don't get ISI distorting things. */
            i = (s->training_count - 8) & ~1;
            /* Avoid the possibility of a divide by zero */
            if (i)
            {
                j = i & 0xF;
                ang = (s->angles[j] - s->start_angles[0])/i
                    + (s->angles[j | 0x1] - s->start_angles[1])/i;
                s->carrier_phase_rate += 3*(ang/20);
            }
            //span_log(&s->logging, SPAN_LOG_FLOW, "%d %d %d %d %d\n", s->angles[s->training_count & 0xF], s->start_angles[0], s->angles[(s->training_count | 0x1) & 0xF], s->start_angles[1], s->training_count);
            span_log(&s->logging, SPAN_LOG_FLOW, "Coarse carrier frequency %7.2f (%d)\n", s->carrier_phase_rate*8000.0/(65536.0*65536.0), s->training_count);

            /* Make a step shift in the phase, to pull it into line. We need to rotate the RRC filter
               buffer and the equalizer buffer, as well as the carrier phase, for this to play out
               nicely. */
            /* angle is now the difference between where C is, and where it should be */
            p = angle*2.0*3.14159/(65536.0*65536.0) - 0.321751;
            span_log(&s->logging, SPAN_LOG_FLOW, "Spin (long) by %.5f rads\n", p);
            printf("Spin (long) by %.5f rads\n", p);
            zz = complex_set(cos(p), -sin(p));
            for (i = 0;  i < 2*V17RX_FILTER_STEPS;  i++)
                s->rrc_filter[i] = complex_mul(&s->rrc_filter[i], &zz);
            for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
                s->eq_buf[i] = complex_mul(&s->eq_buf[i], &zz);
            s->carrier_phase += (angle - 219937506);

            /* We have just seen the first symbol of the scrambled sequence, so skip it. */
            descramble(s, 1);
            descramble(s, 1);
            s->training_count = 1;
            s->gardner_step = 6;
            s->in_training = TRAINING_STAGE_TRAIN_ON_CDBA;
        }
        else if (++s->training_count > V17_TRAINING_SEG_1_LEN)
        {
            /* This is bogus. There are not this many bits in this section
               of a real training sequence. */
            span_log(&s->logging, SPAN_LOG_FLOW, "Training failed (sequence failed)\n");
            /* Park this modem */
            s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
            s->in_training = TRAINING_STAGE_PARKED;
        }
        break;
    case TRAINING_STAGE_TRAIN_ON_CDBA:
        /* Train on the scrambled CDBA section. */
        bit = descramble(s, 1);
        bit = (bit << 1) | descramble(s, 1);
        target = &cdba[bit];
        track_carrier(s, &z, target);
        tune_equalizer(s, &z, target);
        if (s->training_count == V17_TRAINING_SEG_2_LEN - 2000)
            s->eq_delta /= 5.0;
        if (++s->training_count >= V17_TRAINING_SEG_2_LEN - 48)
        {
            s->gardner_step = 4;
            s->training_error = 0.0;
            s->carrier_track_i = 100.0;
            s->carrier_track_p = 500000.0;
            s->in_training = TRAINING_STAGE_TRAIN_ON_CDBA_AND_TEST;
        }
        break;
    case TRAINING_STAGE_TRAIN_ON_CDBA_AND_TEST:
        /* Continue training on the scrambled CDBA section, but measure the quality of training too. */
        bit = descramble(s, 1);
        bit = (bit << 1) | descramble(s, 1);

        //span_log(&s->logging, SPAN_LOG_FLOW, "%5d [%15.5f, %15.5f]     [%15.5f, %15.5f]\n", s->training_count, z.re, z.im, cdba[bit].re, cdba[bit].im);
        target = &cdba[bit];
        track_carrier(s, &z, target);
        tune_equalizer(s, &z, target);
        /* Measure the training error */
        zz = complex_sub(&z, &cdba[bit]);
        s->training_error += power(&zz);
        if (++s->training_count >= V17_TRAINING_SEG_2_LEN)
        {
            span_log(&s->logging, SPAN_LOG_FLOW, "Training error %f\n", s->training_error);
            if (s->training_error < 100.0)
            {
                s->training_count = 0;
                s->training_error = 0.0;
                s->in_training = TRAINING_STAGE_BRIDGE;
            }
            else
            {
                span_log(&s->logging, SPAN_LOG_FLOW, "Training failed (convergence failed)\n");
                /* Park this modem */
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
                s->in_training = TRAINING_STAGE_PARKED;
            }
        }
        break;
    case TRAINING_STAGE_BRIDGE:
        descramble(s, V17_BRIDGE_WORD >> ((s->training_count & 0x7) << 1));
        descramble(s, V17_BRIDGE_WORD >> (((s->training_count & 0x7) << 1) + 1));
        target = &z;
        if (++s->training_count >= V17_TRAINING_SEG_3_LEN)
        {
            s->training_count = 0;
            s->training_error = 0.0;
            s->in_training = TRAINING_STAGE_TCM_WINDUP;
        }
        break;
    case TRAINING_STAGE_SHORT_WAIT_FOR_CDBA:
        target = &cdba[(s->training_count & 1) + 2];
        angle = arctan2(z.im, z.re);
        /* Look for the initial ABAB sequence to display a phase reversal, which will
           signal the start of the scrambled CDBA segment */
        ang = angle - s->angles[(s->training_count - 1) & 0xF];
        s->angles[(s->training_count + 1) & 0xF] = angle;
        if (ang > 0x40000000  ||  ang < -0x40000000)
        {
            /* We seem to have a phase reversal */
            /* We have just seen the first symbol of the scrambled sequence, so skip it. */
            descramble(s, 1);
            descramble(s, 1);
            s->training_count = 1;
            s->gardner_step = 4;
            s->in_training = TRAINING_STAGE_SHORT_TRAIN_ON_CDBA_AND_TEST;
        }
        else
        {
            track_carrier(s, &z, target);
            if (++s->training_count > V17_TRAINING_SEG_1_LEN)
            {
                /* This is bogus. There are not this many bits in this section
                   of a real training sequence. */
                span_log(&s->logging, SPAN_LOG_FLOW, "Training failed (sequence failed)\n");
                /* Park this modem */
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
                s->in_training = TRAINING_STAGE_PARKED;
            }
        }
        break;
    case TRAINING_STAGE_SHORT_TRAIN_ON_CDBA_AND_TEST:
        /* Short retrain on the scrambled CDBA section, but measure the quality of training too. */
        bit = descramble(s, 1);
        bit = (bit << 1) | descramble(s, 1);
        //span_log(&s->logging, SPAN_LOG_FLOW, "%5d [%15.5f, %15.5f]     [%15.5f, %15.5f] %d\n", s->training_count, z.re, z.im, cdba[bit].re, cdba[bit].im, arctan2(z.im, z.re));
        target = &cdba[bit];
        track_carrier(s, &z, target);
        //tune_equalizer(s, &z, target);
        /* Measure the training error */
        if (s->training_count > 8)
        {
            zz = complex_sub(&z, &cdba[bit]);
            s->training_error += power(&zz);
        }
        if (++s->training_count >= V17_TRAINING_SHORT_SEG_2_LEN)
        {
            s->carrier_track_i = 100.0;
            s->carrier_track_p = 500000.0;
            span_log(&s->logging, SPAN_LOG_FLOW, "Short training error %f\n", s->training_error);
            if (s->training_error < 4000.0)
            {
                s->training_count = 0;
                s->in_training = TRAINING_STAGE_TCM_WINDUP;
            }
            else
            {
                span_log(&s->logging, SPAN_LOG_FLOW, "Short training failed (convergence failed)\n");
                /* Park this modem */
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
                s->in_training = TRAINING_STAGE_PARKED;
            }
        }
        break;
    case TRAINING_STAGE_TCM_WINDUP:
        /* We need to wait 15 bauds while the trellis fills up. */
        //span_log(&s->logging, SPAN_LOG_FLOW, "%5d %15.5f, %15.5f\n", s->training_count, z.re, z.im);
        constellation_state = decode_baud(s, &z);
        target = &s->constellation[constellation_state];
        /* Measure the training error */
        zz = complex_sub(&z, target);
        s->training_error += power(&zz);
        if (++s->training_count >= V17_TRAINING_SEG_4A_LEN)
        {
            s->training_count = 0;
            s->training_error = 0.0;
            /* Restart the differential decoder */
            s->diff = (s->short_train)  ?  0  :  1;
            s->in_training = TRAINING_STAGE_TEST_ONES;
        }
        break;
    case TRAINING_STAGE_TEST_ONES:
        /* We are in the test phase, where we check that we can receive reliably.
           We should get a run of 1's, 48 symbols long. */
        //span_log(&s->logging, SPAN_LOG_FLOW, "%5d %15.5f, %15.5f\n", s->training_count, z.re, z.im);
        constellation_state = decode_baud(s, &z);
        target = &s->constellation[constellation_state];
        /* Measure the training error */
        zz = complex_sub(&z, target);
        s->training_error += power(&zz);
        if (++s->training_count >= V17_TRAINING_SEG_4_LEN)
        {
            if (s->training_error < 25.0)
            {
                /* We are up and running */
                span_log(&s->logging, SPAN_LOG_FLOW, "Training succeeded (constellation mismatch %f)\n", s->training_error);
                s->put_bit(s->user_data, PUTBIT_TRAINING_SUCCEEDED);
                equalizer_save(s);
                s->carrier_phase_rate_save = s->carrier_phase_rate;
                s->agc_scaling_save = s->agc_scaling;
                s->in_training = TRAINING_STAGE_NORMAL_OPERATION;
            }
            else
            {
                /* Training has failed */
                span_log(&s->logging, SPAN_LOG_FLOW, "Training failed (constellation mismatch %f)\n", s->training_error);
                /* Park this modem */
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
                s->in_training = TRAINING_STAGE_PARKED;
            }
        }
        break;
    case TRAINING_STAGE_PARKED:
    default:
        /* We failed to train! */
        /* Park here until the carrier drops. */
        target = &z;
        break;
    }
    if (s->qam_report)
        s->qam_report(s->qam_user_data, &z, target, constellation_state);
}
/*- End of function --------------------------------------------------------*/

void v17_rx(v17_rx_state_t *s, const int16_t *amp, int len)
{
    int i;
    int16_t sample;
    complex_t z;
    int32_t power;
    float x;

    for (i = 0;  i < len;  i++)
    {
        sample = amp[i];
        power = power_meter_update(&(s->power), sample);
        if (s->carrier_present)
        {
            /* Look for power below turnoff threshold to turn the carrier off */
            if (power < s->carrier_off_power)
            {
                v17_rx_restart(s, s->bit_rate, s->short_train);
                s->put_bit(s->user_data, PUTBIT_CARRIER_DOWN);
                continue;
            }
        }
        else
        {
            /* Look for power exceeding turnon threshold to turn the carrier on */
            if (power < s->carrier_on_power)
                continue;
            s->carrier_present = TRUE;
            s->put_bit(s->user_data, PUTBIT_CARRIER_UP);
        }
        if (s->in_training != TRAINING_STAGE_PARKED)
        {
            /* Only spend effort processing this data if the modem is not
               parked, after training failure. */
            if (!s->short_train  &&  s->in_training == TRAINING_STAGE_SYMBOL_ACQUISITION)
            {
                /* Only AGC during the initial training */
                s->agc_scaling = 3.0*3.60/sqrt(power);
            }
printf("AGC scaling %15.5f %15.5f\n", s->agc_scaling, x);
            x = sample*s->agc_scaling;
            /* Shift to baseband */
            z = dds_complexf(&(s->carrier_phase), s->carrier_phase_rate);
            z.re *= x;
            z.im *= x;
            process_baud(s, &z);
        }
printf("State %d\n", s->in_training);
fprintf(stderr, "State %d\n", s->in_training);
    }
}
/*- End of function --------------------------------------------------------*/

void v17_rx_set_put_bit(v17_rx_state_t *s, put_bit_func_t put_bit, void *user_data)
{
    s->put_bit = put_bit;
    s->user_data = user_data;
}
/*- End of function --------------------------------------------------------*/

int v17_rx_restart(v17_rx_state_t *s, int rate, int short_train)
{
    int i;
    int j;

    span_log(&s->logging, SPAN_LOG_FLOW, "Restarting V.17\n");
    switch (rate)
    {
    case 14400:
        s->constellation = v17_14400_constellation;
        s->space_map = 0;
        s->bits_per_symbol = 6;
        break;
    case 12000:
        s->constellation = v17_12000_constellation;
        s->space_map = 1;
        s->bits_per_symbol = 5;
        break;
    case 9600:
        s->constellation = v17_9600_constellation;
        s->space_map = 2;
        s->bits_per_symbol = 4;
        break;
    case 7200:
        s->constellation = v17_7200_constellation;
        s->space_map = 3;
        s->bits_per_symbol = 3;
        break;
    default:
        return -1;
    }
    s->bit_rate = rate;
    memset(s->rrc_filter, 0, sizeof(s->rrc_filter));
    s->rrc_filter_step = 0;

    s->diff = 1;
    s->scramble_reg = 0x2ECDD5;
    s->in_training = TRAINING_STAGE_SYMBOL_ACQUISITION;
    s->training_count = 0;
    s->carrier_present = FALSE;
    s->short_train = short_train;

    /* Initialise the TCM decoder parameters. */
    /* The accumulated distance vectors are set so state zero starts
       at a value of zero, and all others start larger. This forces the
       initial paths to merge at the zero states. */
    for (i = 0;  i < 8;  i++)
    {
        s->distances[i] = 99.0;
        for (j = 0;  j < 16;  j++)
        {
            s->full_path_to_past_state_locations[j][i] = 0;
            s->past_state_locations[j][i] = 0;
        }
    }
    s->distances[0] = 0;
    s->trellis_ptr = 14;

    span_log(&s->logging, SPAN_LOG_FLOW, "Phase rates %f %f\n", s->carrier_phase_rate*(float) SAMPLE_RATE/(65536.0*65536.0), s->carrier_phase_rate_save*(float) SAMPLE_RATE/(65536.0*65536.0));
    s->carrier_phase = 0;
    s->carrier_track_i = 100.0;
    s->carrier_track_p = 40000.0;
    power_meter_init(&(s->power), 4);

printf("Restart %d\n", s->short_train);
    if (s->short_train)
    {
        s->carrier_phase_rate = s->carrier_phase_rate_save;
        s->agc_scaling = s->agc_scaling_save;
        equalizer_restore(s);
    }
    else
    {
        s->carrier_phase_rate = dds_phase_stepf(1800.0);
        s->agc_scaling = 0.0005;
        equalizer_reset(s);
    }

    s->gardner_integrate = 0;
    s->gardner_total_correction = 0;
    /* Start with very big Gardner steps, until we start to pull in the symbol timing. */
    s->gardner_step = 64;
    s->baud_phase = 0;
    
    return 0;
}
/*- End of function --------------------------------------------------------*/

v17_rx_state_t *v17_rx_init(v17_rx_state_t *s, int rate, put_bit_func_t put_bit, void *user_data)
{
    if (s == NULL)
    {
        if ((s = (v17_rx_state_t *) malloc(sizeof(*s))) == NULL)
            return NULL;
    }
    memset(s, 0, sizeof(*s));
    s->put_bit = put_bit;
    s->user_data = user_data;
    s->short_train = FALSE;
    s->carrier_on_power = power_meter_level_dbm0(-43);
    s->carrier_off_power = power_meter_level_dbm0(-48);
    s->agc_scaling = 0.0005;
    s->agc_scaling_save = 0.0005;
    s->carrier_phase_rate_save = dds_phase_stepf(1800.0);

    v17_rx_restart(s, rate, s->short_train);
    return s;
}
/*- End of function --------------------------------------------------------*/

int v17_rx_release(v17_rx_state_t *s)
{
    free(s);
    return 0;
}
/*- End of function --------------------------------------------------------*/

void v17_rx_set_qam_report_handler(v17_rx_state_t *s, qam_report_handler_t *handler, void *user_data)
{
    s->qam_report = handler;
    s->qam_user_data = user_data;
}
/*- End of function --------------------------------------------------------*/
/*- End of file ------------------------------------------------------------*/
