#include <stdio.h>
#include "sufary.h"
#include "keys.h"

#define BUF_SIZE 999999

struct {
    int mode;
    int gram;
    char* mozdic_name;
    SUFARY *sa;
} Opt;

void print_help(void)
{
    printf ("splitter for iisa\n"\
	    "  usage: splitter [options] < file\n"\
	    "  options:\n");
    printf ("    -char     : character type mode (%s)\n",
	    (Opt.mode==0)?"ON":"OFF");
    printf ("    -ngram .. : ngram mode (%s N=%d)\n",
	    (Opt.mode==1)?"ON":"OFF", Opt.gram);
    printf ("    -moz ..   : moz mode (%s dic=%s)\n",
	    (Opt.mode==2)?"ON":"OFF", Opt.mozdic_name);
    printf ("    -help     : show this help\n");
    exit(1);
}

int main (int argc, char *argv[])
{
    char buf[BUF_SIZE];
    KeyBuffer sstr;
    int i, rest, last;

    Opt.mode = 0; /* split by character */
    Opt.gram = 4; Opt.mozdic_name = "";

    /* parse arguments */
    for (i = 1; i < argc; i++) {
	switch (argv[i][1]) {
	  case 'm':
	    if (strcmp("-moz", argv[i]) == 0) {
		Opt.mode = 2;
		Opt.mozdic_name = argv[++i];
		if ((Opt.sa = sa_openfiles(argv[i], NULL)) == NULL) {
		    fprintf(stderr, "cannot open moz dic files\n");
		    exit(1);
		}
		break;
	    }
	  case 'n':
	    if (strcmp("-ngram", argv[i]) == 0) {
		Opt.mode = 1;
		Opt.gram = atoi(argv[++i]);
	    } else
		print_help();
	    break;
	  case 'c':
	    if (strcmp("-char", argv[i]) == 0)
		Opt.mode = 0;
	    else
		print_help();
	    break;
	  default:
	    print_help();
	}
    }
    
    rest = 0;
    while (fgets(buf + rest, BUF_SIZE - rest -1, stdin) != NULL) {
	switch (Opt.mode) {
	  case 1:
	    rest = parse_by_ngram (&sstr, buf, Opt.gram); break;
	  case 2:
	    rest = parse_by_mozdic (&sstr, buf, Opt.sa); break;
	  default:
	    rest = parse_by_chartype (&sstr, buf);
	}
	if (rest) {
	    for (i = 0; i < sstr.num-1; i++) {
		printf ("%s\n", sstr.str[i]);
	    }
	    last = sstr.num - 1;
	    rest = strlen(sstr.str[last]);
	    for (i = 0; i < rest; i++) {
		buf[i] = sstr.str[last][i];
	    }
	    if (!(sstr.str[last][rest-1] & 0x80)) {
		buf[i] = ' '; i++; rest++;
	    }
	    buf[i] = '\0';
/*	    buf[i] = '\n'; rest++;*/
	} else {
	    for (i = 0; i < sstr.num; i++) {
		printf ("%s\n", sstr.str[i]);
	    }
	}
    }
    if (rest) {
	puts(buf);
	if (Opt.mode == 1) {
	    for (i = 2; i < rest; i += 2) {
		puts(buf+i);
	    }
	}
    }
    exit(0);
}
