/*==================================================================
 * main.c - Main routine to kick things off
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 *==================================================================*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <gtk/gtk.h>

/* for temporary open call */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <popt.h>

#include <libswami/SwamiConfig.h>
#include <libswami/SwamiPlugin.h>

#include "SwamiUIObject.h"

#include "util.h"
#include "i18n.h"

#ifdef CANVAS_SUPPORT
#include <gnome.h>
#endif

int
main (int argc, char *argv[])
{
  int h = 0, d = 0, c = 0;
  struct poptOption cmd_options[] =
    {
      { "help", 'h', POPT_ARG_NONE, &h, 0,
	N_("Display help information"), NULL },
      { "disable-plugins", 'd', POPT_ARG_NONE, &d, 0,
	N_("Disable plugins (try if crashing on startup)"), NULL },
      { "config-defaults", 'c', POPT_ARG_NONE, &c, 0,
	N_("Ignore preferences and use factory defaults"), NULL },
      { NULL, '\0', 0, NULL, 0, NULL, NULL }
    };
  poptContext popt_ctx;
  const char *fname;
  int retval;

#if defined(ENABLE_NLS)
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
#endif

  g_thread_init (NULL);		/* initialize glib thread support */

#ifdef CANVAS_SUPPORT
  /* initialize gnome for canvas widget */
  gnome_init_with_popt_table ("Swami", VERSION, argc, argv,
			      cmd_options, 0, &popt_ctx);
#else
  gtk_set_locale ();
  gtk_init (&argc, &argv);	/* initialize GTK */

  popt_ctx = poptGetContext ("Swami", argc, (const char **)argv,
			     cmd_options, 0);

  poptSetOtherOptionHelp (popt_ctx,
	_("[OPTION...] [file1.sf2 file2.sf2 ...]"));

  if ((retval = poptGetNextOpt (popt_ctx)) != -1)
    {
      fprintf (stderr, "%s: %s\n",
	       poptBadOption (popt_ctx, POPT_BADOPTION_NOALIAS),
	       poptStrerror (retval));
      exit (1);
    }

  if (h)
    {
      poptPrintHelp (popt_ctx, stderr, 0);
      exit (0);
    }
#endif

  swami_init ();
  swamiui_util_init ();

  if (!c) swami_config_load (); /* load the config files */
  if (!d) swami_plugin_load_all (); /* load plugins */

  swamiui_object_new ();

  /* loop over command line non-options, assuming they're files to open */
  while ((fname = poptGetArg (popt_ctx)))
    swami_patch_load (swami_object, fname);

  poptFreeContext (popt_ctx);

  gdk_threads_enter ();
  gtk_main ();			/* kick it in the main GTK loop */
  gdk_threads_leave ();

  exit (0);
}
