/*
 * wavetbl_fluidsynth.h - Header file for FluidSynth plugin
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __WAVETBL_FLUIDSYNTH_H__
#define __WAVETBL_FLUIDSYNTH_H__

#include <glib.h>
#include <instpatch.h>

#include <libswami/SwamiWavetbl.h>
#include <libswami/SwamiMidi.h>

#include <fluidsynth.h>

#include "GObjSup.h"


/* FluidSynth SwamiWavetbl object */


typedef struct _WavetblFluidSynth WavetblFluidSynth;
typedef struct _WavetblFluidSynthClass WavetblFluidSynthClass;

#define WAVETBL_TYPE_FLUIDSYNTH   (wavetbl_fluidsynth_get_type ())
#define WAVETBL_FLUIDSYNTH(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), WAVETBL_TYPE_FLUIDSYNTH, \
   WavetblFluidSynth))
#define WAVETBL_FLUIDSYNTH_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), WAVETBL_TYPE_FLUIDSYNTH, \
   WavetblFluidSynthClass))
#define WAVETBL_IS_FLUIDSYNTH(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WAVETBL_TYPE_FLUIDSYNTH))
#define WAVETBL_IS_FLUIDSYNTH_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), WAVETBL_TYPE_FLUIDSYNTH))

typedef struct _realtime_noteon_t realtime_noteon_t;

/* FluidSynth SwamiWavetbl object */
struct _WavetblFluidSynth
{
  SwamiWavetbl object;		/* derived from SwamiWavetbl */
  fluid_midi_router_t *midi_router; /* FluidSynth MIDI router */
  fluid_midi_driver_t *midi_driver; /* FluidSynth MIDI driver */
  fluid_audio_driver_t *audio_driver; /* FluidSynth audio driver */
  fluid_synth_t *synth;		/* the FluidSynth handle */
  fluid_settings_t *settings;	/* FluidSynth settings */
  IPItem *temp_item;		/* temporary audible preset item */

  /* note on info for temp audible, allows realtime setting of generators */
  realtime_noteon_t *realtime_noteon;
};

/* fluidsynth wavetbl class */
struct _WavetblFluidSynthClass
{
  SwamiWavetblClass parent_class; /* derived from SwamiWavetblClass */
};


/* FluidSynth SwamiMidi object */


typedef struct _MidiFluidSynth MidiFluidSynth;
typedef struct _MidiFluidSynthClass MidiFluidSynthClass;

#define MIDI_TYPE_FLUIDSYNTH   (midi_fluidsynth_get_type ())
#define MIDI_FLUIDSYNTH(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), MIDI_TYPE_FLUIDSYNTH, \
   MidiFluidSynth))
#define MIDI_FLUIDSYNTH_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), MIDI_TYPE_FLUIDSYNTH, \
   MidiFluidSynthClass))
#define MIDI_IS_FLUIDSYNTH(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDI_TYPE_FLUIDSYNTH))
#define MIDI_IS_FLUIDSYNTH_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDI_TYPE_FLUIDSYNTH))

/* FluidSynth SwamiMidi object */
struct _MidiFluidSynth
{
  SwamiMidi object;		/* derived from SwamiMidi */
  WavetblFluidSynth *wavetbl;	/* linked FluidSynth wavetbl driver or NULL */
};

/* FluidSynth midi class */
struct _MidiFluidSynthClass
{
  SwamiMidiClass parent_class; /* derived from SwamiMidiClass */
};

GType wavetbl_fluidsynth_get_type (void);

void wavetbl_fluidsynth_set_gain (WavetblFluidSynth *wavetbl, float gain);
void wavetbl_fluidsynth_set_reverb_enable (WavetblFluidSynth *wavetbl,
					   gboolean enable);
void wavetbl_fluidsynth_set_chorus_enable (WavetblFluidSynth *wavetbl,
					   gboolean enable);
void wavetbl_fluidsynth_update_reverb (WavetblFluidSynth *wavetbl);
void wavetbl_fluidsynth_update_chorus (WavetblFluidSynth *wavetbl);

extern double default_gain;

#endif
