/***************************************************************************
                            th-disc-drive.h
                            ---------------
    begin                : Tue Oct 12 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_disc_drive_h_included_
#define _th_disc_drive_h_included_

#include <gtk/gtktreemodel.h>

#include "th-job.h"

#define TH_TYPE_DISC_DRIVE             (th_disc_drive_get_type())
#define TH_DISC_DRIVE(obj)             (G_TYPE_CHECK_INSTANCE_CAST (obj,  TH_TYPE_DISC_DRIVE, ThDiscDrive))
#define TH_DISC_DRIVE_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST (klass,   TH_TYPE_DISC_DRIVE, ThDiscDriveClass))
#define TH_IS_DISC_DRIVE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE (obj,  TH_TYPE_DISC_DRIVE))
#define TH_IS_DISC_DRIVE_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), TH_TYPE_DISC_DRIVE))

typedef struct _ThDiscDrive        ThDiscDrive;
typedef struct _ThDiscDriveClass   ThDiscDriveClass;
typedef struct _ThDiscDrivePrivate ThDiscDrivePrivate;

struct _ThDiscDrive
{
	GObject              object;
	
	GtkTreeIter          iter;        /* for the combo box list store */
	
	ThDiscDrivePrivate  *priv;
};

struct _ThDiscDriveClass
{
	GObjectClass  parent_class;
};

/* functions */

GType            th_disc_drive_get_type (void) G_GNUC_CONST;

ThDiscDrive     *th_disc_drive_new (const gchar  *udi, 
                                    const gchar  *device, 
                                    const gchar  *vendor, 
                                    const gchar  *product);

const GList     *th_disc_drive_get_titles (ThDiscDrive *drive);

#endif /* _th_disc_drive_h_included_ */

