/* ========================================================================== */
/* === UMF_kernel_init_usage ================================================ */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/* Return number of Units needed for initial elements by UMF_kernel_init */
/* (including the tuples). */

#include "umf_internal.h"
#include "umf_build_tuples_usage.h"

GLOBAL Int UMF_kernel_init_usage
(
    const Int Ap [ ],
    const Int Cperm_init [ ],
    const Int Row_degree [ ],
    Int n,
    double *dusage		/* input and output argument */
)
{
    Int newcol, oldcol, cdeg, usage ;

    /* elements: */
    usage = 0 ;
    for (newcol = 0 ; newcol < n ; newcol++)
    {
	oldcol = Cperm_init [newcol] ;
	DEBUG2 (("oldcol "ID" newcol "ID"   Ap["ID"] = "ID"  Ap ["ID"] "ID"\n",
		oldcol, newcol, oldcol+1, Ap [oldcol+1], oldcol, Ap [oldcol])) ;
	cdeg = Ap [oldcol+1] - Ap [oldcol] ;
	usage   += GET_ELEMENT_SIZE (cdeg, 1) + 1 ;
	*dusage += DGET_ELEMENT_SIZE (cdeg, 1) + 1 ;
    }

    DEBUG0 (("UMF_kernel_init_usage : original elements: "ID" %g\n",
	usage, *dusage)) ;

    /* tuples: */
    usage += UMF_build_tuples_usage ((Int *) NULL, (Int *) NULL,
	Row_degree, Row_degree, n, dusage) ;

    DEBUG0 (("UMF_kernel_init_usage : all: "ID" %g\n", usage, *dusage)) ;
    return (usage) ;
}

