/* ========================================================================== */
/* === UMFPACK_get_lunz ===================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/*
    User-callable.  Determines the number of nonzeros in L and U, and the size
    of L and U.
*/

#include "umf_internal.h"
#include "umf_valid_numeric.h"

GLOBAL Int UMFPACK_get_lunz
(
    Int *lnz,
    Int *unz,
    Int *nn,
    void *NumericHandle
)
{
    NumericType *Numeric ;

    Numeric = (NumericType *) NumericHandle ;

    if (!UMF_valid_numeric (Numeric))
    {
	return (UMFPACK_ERROR_invalid_Numeric_object) ;
    }
    if (!lnz || !unz || !nn)
    {
	return (UMFPACK_ERROR_argument_missing) ;
    }

    *nn = Numeric->n ;
    *lnz = Numeric->lnz + Numeric->n ;
    *unz = Numeric->unz + Numeric->n ;

    return (UMFPACK_OK) ;
}

