/* ========================================================================== */
/* === umfpack_report_status ================================================ */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

void umfpack_report_status
(
    const double Control [UMFPACK_CONTROL],
    int status
) ;

void umfpack_l_report_status
(
    const double Control [UMFPACK_CONTROL],
    long status
) ;

/*
int Syntax:

    #include "umfpack.h"
    double Control [UMFPACK_CONTROL] ;
    int status ;
    umfpack_report_status (Control, status) ;

long Syntax:

    #include "umfpack.h"
    double Control [UMFPACK_CONTROL] ;
    long status ;
    umfpack_l_report_status (Control, status) ;

Purpose:

    Prints the status (return value) of other umfpack_* routines.

Arguments:

    double Control [UMFPACK_CONTROL] ;   Input argument, not modified.

	If a (double *) NULL pointer is passed, then the default control
	settings are used.  Otherwise, the settings are determined from the
	Control array.  See umfpack_defaults on how to fill the Control
	array with the default settings.  The following Control parameters
	are used:

	Control [UMFPACK_PRL]:  printing level.

	    0 or less: no output, even when an error occurs
	    1: error messages only
	    2 or more: print status, whether or not an error occured
	    4 or more: also print the UMFPACK Copyright
	    6 or more: also print the UMFPACK License
	    Default: 1

    Int status ;			Input argument, not modified.

	The return value from another umfpack_* routine.
*/
