               
#include <vdk/vdk.h>
#include "kill.xpm"
extern char * folder_xpm[];
///////////////////////////////////////////
void ExternClicked(GtkWidget*, gpointer gp)
    {
      VDKObject* sender = (VDKObject*) gp;
      printf("\nExternClicked(%p)",sender);
      fflush(stdout);
    }
/////////////////////////////////////
class MyButton: public VDKLabelButton
{

public:
  MyButton(VDKForm* owner, char* label, char* tip):
    VDKLabelButton(owner,label,tip) 
    {
      printf("\nMyButton::SignalConnect() to slot:%d",
	     SignalConnect("clicked",&MyButton::Clicked));
      fflush(stdout);
    }
  bool Clicked(VDKObject* sender)
    {
      printf("\nMyButton::Clicked(%p)",sender); 
      fflush(stdout);
      // jump to parent level 
      return false;
    }
  virtual ~MyButton() {} 
DECLARE_SIGNAL_LIST(MyButton);
};
DEFINE_SIGNAL_LIST(MyButton,VDKLabelButton);
///////////////////////////////////////////
class MyCanvas: public VDKCanvas
{
public:
  MyCanvas(VDKForm* owner, int w, int h):
    VDKCanvas(owner,w,h) 
    {
      printf("\nMyCanvas::EventConnect() to slot:%d",
	     EventConnect("button_press_event",&MyCanvas::MouseClick));
      fflush(stdout);
    }
  virtual ~MyCanvas() {}
  bool  MouseClick(VDKObject* sender, GdkEvent* event)
    {
      printf("\nMyCanvas::MouseClick() :%p, type:%d",sender,event->type);
      fflush(stdout);
      // jump to parent level
      return false;
    }

DECLARE_EVENT_LIST(MyCanvas);
};

DEFINE_EVENT_LIST(MyCanvas,VDKCanvas);

/////////////////////////////////////
class MyForm: public VDKForm
{ 
protected:
  static void StaticClicked(GtkWidget*, gpointer gp)
    {
      VDKObject* sender = (VDKObject*) gp;
      printf("\nMyForm::StaticClicked(%p)",sender);
      fflush(stdout);
    }
  bool Clicked(VDKObject* sender)
    {
      printf("\nMyForm::Clicked(%p)",sender);
      fflush(stdout);
      return true;
    }
  MyButton* helloButton;
  VDKPixmapButton* closeButton;
  VDKLabel* label;
  MyCanvas* canvas;
public: 
 
  MyForm(VDKApplication* app, gchar* title):
    VDKForm(app,title) {}
  ~MyForm() {}
void Setup() 
{ 
  VDKBox *box = new VDKBox(this);  
  //
  canvas = new MyCanvas(this,200,100);
  canvas->NormalBackground = clIvory;
  box->Add(canvas);
  box->Add(helloButton = new MyButton(
				       this,
				       "Hello",
				       "Says \"hello\""));
  box->Add(closeButton = new VDKPixmapButton(this,
					kill_xpm ,  
					"DISMISS",
					"Closes hello application"));
  box->Add(label = new VDKLabel(this,""));  

  Add(box); 
  //SetSize(200,100);    
  // signal connecting
  SignalConnect(closeButton,"clicked" ,&MyForm::Quit);
  // 
  printf("\nMyForm::SignalConnect() to slot:%d",
	 SignalConnect(helloButton,"clicked" ,&MyForm::Clicked));
  fflush(stdout);
  //
  SignalConnect(helloButton,"clicked" ,&MyForm::SayHello);
  // connection with static or "C" callbacks unhandled
  gtk_signal_connect(GTK_OBJECT(helloButton->Widget()),
		     "clicked" , 
		     GTK_SIGNAL_FUNC(MyForm::StaticClicked),
		     (gpointer) helloButton);
  gtk_signal_connect(GTK_OBJECT(helloButton->Widget()),
		     "clicked" , 
		     GTK_SIGNAL_FUNC(ExternClicked),
		     (gpointer) helloButton);
  // event connecting
  printf("\nMyForm::EventConnect(button_press) to slot:%d",
	 EventConnect(canvas,"button_press_event",&MyForm::MouseClick));
  fflush(stdout);
}    
       
bool SayHello(VDKObject* sender) 
{ 
  label->Caption="Hello world !";  
  return true;  
}     
 
bool Quit(VDKObject* sender) 
{ 
  Close();     
  return true;    
} 

bool MouseClick(VDKObject* sender, GdkEvent* event)
{
printf("\nMyForm::MouseClick():%p,type:%d",sender,event->type);
fflush(stdout);
return true;
} 
DECLARE_SIGNAL_LIST(MyForm);
DECLARE_EVENT_LIST(MyForm);
};    
     
DEFINE_SIGNAL_LIST(MyForm,VDKForm); 
DEFINE_EVENT_LIST(MyForm,VDKForm); 

/////////////////////////////////// 
class MyApp: public VDKApplication   
{     
           
public:  
  MyApp(int* argc, char** argv): VDKApplication(argc,argv) {}
  ~MyApp() {}  
  void Setup()  
  { 
    MainForm = new MyForm(this,"Hello world 2");
    MainForm->Setup();
    MainForm->Show(); 
  }
};   

/////////////////////////////////
int main (int argc, char *argv[])    
{
  MyApp app(&argc, argv); 
  app.Run();      
  return 0;  
}  






