/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  PIXMAPS_H
#define  PIXMAPS_H

#include <vdk/vdkobj.h>
class VDKTooltip;
class VDKRawPixmap;
/*!
  \class VDKPixmap
  \brief Provides a pixmap widget
  \par EVENTS
  button_press_event received whenever user clicks on pixmap
  \par TIP
  Constructing with <pixfile> or <pixdata> set to NULL will make
  only the inner event box. Thus allowing to construct an empty
  pixmap that can be later initialized with SetPixmap().
 */
class VDKPixmap: public VDKObject
{

protected:
  int width,height;
  GdkPixmap* pixmap;
  GtkWidget* pixmapWid;
  VDKTooltip* tip;
  VDKRawPixmap* oldRawPix;
public:
  /*!
    Constructor
    \param owner
    \param pixfile
    \param tip
   */
  VDKPixmap(VDKForm* owner,
	    char* pixfile, 
	    char* tip = NULL);
  /*!
    Constructor
    \param owner
    \param pixdata
    \param tip
   */
  VDKPixmap(VDKForm* owner,
	    char** pixdata, 
	    char* tip = NULL);
  /*!
    Destructor
  */
  virtual ~VDKPixmap();
  /*!
    Clear the pixmap
   */
  void Clear();
  /*!
    Return pixmap width
   */
  int Width() { return width; }
  int Height() { return height; }
  /*!
    Return pixmap height
   */
  /*!
    Returns the raw pixmap contained into VDKPixmap
   */
  VDKRawPixmap* SetPixmap() { return oldRawPix; }
  /*!
    Change the raw pixmap contained into VDKPixmap
    \param file pixmap file
   */
  VDKRawPixmap* SetPixmap(char* file);
  /*!
    Change the raw pixmap contained into VDKPixmap
    \param newpix new pixmap
   */
  VDKRawPixmap* SetPixmap(VDKRawPixmap* newpix);
  /*!
    Change the raw pixmap contained into VDKPixmap
    \param pixdata pixmap data
   */
  VDKRawPixmap* SetPixmap(char** pixdata);
};
#endif
