#
#       Makefile
#
###
#
#  Copyright (c) 1994 - 2001	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

# if this fails to build one may have to edit the individual Imakefiles
# especially if your OS does not have srand48() and drand48().
# Also install the appropriate Puzzle.ad file in $HOME or where ever you
# normally  put these preferences.
# Please consult the individual README's.

# After ftping all the *.tar.gz files you want (each program is independent)
#	make -f xpuzzles.Makefile gunzip  # this step may not be necessary
#         depending on how it was packaged, also it destroys original gz files
#	make -f xpuzzles.Makefile configure
#	make -f xpuzzles.Makefile
#	make -f xpuzzles.Makefile run     # this cycles through all programs
#	make -f xpuzzles.Makefile run.xm  # this cycles through all motif programs
#	make -f xpuzzles.Makefile install # if you like them

#SHELL=/bin/sh

XLOCK=more
STUFF=abacus dial threed
ROTATIONAL=rubik skewb dino pyraminx oct mball
SLIDING=cubes triangles hexagons mlink panex
PUZZLES=${ROTATIONAL} ${SLIDING}
ALTRIS=tetris tertris hextris welltris
VER=-5.5.4

#PRE=xlock
#NAME=xlockmore.
PRE=x
NAME=xpuzzles.
#NAME=xabacus.
#PRE=al
#NAME=altris.
NAME_TRUNC=`echo ${NAME} | cut -c1-8`.

PROGRAMS=${PUZZLES}

# Used by me to zip and write and read from my floppy drive
UNIXDIR=./net
MOUNT=eject -q floppy
#MOUNT=mntflop -d
UMOUNT=eject -p floppy
#UMOUNT=mntflop -u ; if [ -x /usr/bin/eject ]; then ; /usr/bin/eject -p floppy; fi
#DOSDIR=/dosa
DOSDIR=/floppy/floppy0
# eject is a mount floppy disk utility that I maintain for Linux which is like
# the Solaris version. If there is interest, I will make it publicly available.
# If there is something out there already, let me know.

all :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make;\
			cd ..;\
		fi;\
	done

all.xm :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make all.xm;\
			cd ..;\
		fi;\
	done

autoconf :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			autoconf;\
			cd ..;\
		fi;\
	done

configure :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			configure;\
			cd ..;\
		fi;\
	done

xmkmf :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			xmkmf -a;\
			cd ..;\
		fi;\
	done

lint :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make lint;\
			cd ..;\
		fi;\
	done

indent :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make indent;\
			cd ..;\
		fi;\
	done

indentcheck :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			ls -al *.c *.c~ *.h *.h~;\
			cd ..;\
		fi;\
	done

run :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			./${PRE}$${i};\
			cd ..;\
		fi;\
	done

run.xm :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			./xm$${i};\
			cd ..;\
		fi;\
	done

clean :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in clean;\
			cd ..;\
		fi;\
	done

distclean :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			cd ..;\
		fi;\
	done

clean.all : distclean

tar :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in tar;\
			cd ..;\
		fi;\
	done

compress :
	cp ${NAME}README ${UNIXDIR}/${NAME}README;\
	cp ${NAME}Makefile ${UNIXDIR}/${NAME}Makefile;\
	cp ${NAME}lsm ${UNIXDIR}/${NAME}lsm;\
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in compress;\
			cd ..;\
		fi;\
	done

gzip :
	cp ${NAME}README ${UNIXDIR}/${NAME}README;\
	cp ${NAME}Makefile ${UNIXDIR}/${NAME}Makefile;\
	cp ${NAME}lsm ${UNIXDIR}/${NAME}lsm;\
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in gzip;\
			cd ..;\
			mv ${PRE}$${i}${VER}.tar.gz ${UNIXDIR};\
		fi;\
	done

dostgz :
	${MOUNT};\
	cp ${NAME}README ${DOSDIR}/${NAME}rea;\
	cp ${NAME}Makefile ${DOSDIR}/${NAME}mak;\
	cp ${NAME}lsm ${DOSDIR}/${NAME}lsm;\
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in tgz;\
			cd ..;\
			cp `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz ${DOSDIR};\
		if [ -w ${DOSDIR}/`echo ${PRE}$${i}${VER} | cut -c1-8`.tgz ]; then\
				rm -f `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz;\
			fi;\
		fi;\
	done;\
	${UMOUNT}


unixtgz :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
	   		make -f Makefile.in tgz;\
			cd ..;\
		fi;\
	done;\
	DEVICE=/dev/fd0;\
	OS=`uname`;\
	if [ "$${OS}" = "SunOS7" ]; then\
		eject -q floppy 2> /tmp/dev$$;\
		DEVICE=`cat /tmp/dev$$ | cut -f1 -d' '`;\
		rm -f /tmp/dev$$;\
	fi;\
	tar cvf $${DEVICE} *.tgz ${NAME}README ${NAME}Makefile ${NAME}lsm;\
	for i in ${PROGRAMS}; do\
		rm -f `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz;\
	done;\
	if [ "$${OS}" = "SunOS7" ]; then\
		trap "exit 0" 0;\
		eject -p floppy 2> /dev/null;\
	fi

utar :
	for i in ${PROGRAMS}; do\
		tar xvf ${PRE}$${i}${VER}.tar;\
		rm -f ${PRE}$${i}${VER}.tar;\
	done

uncompress :
	for i in ${PROGRAMS}; do\
		uncompress ${PRE}$${i}${VER}.tar.Z;\
		tar xvf ${PRE}$${i}${VER}.tar;\
		rm -f ${PRE}$${i}${VER}.tar;\
	done

gunzip :
	for i in ${PROGRAMS}; do\
		gunzip ${PRE}$${i}${VER}.tar.gz;\
		tar xvf ${PRE}$${i}${VER}.tar;\
		rm -f ${PRE}$${i}${VER}.tar;\
	done

utgz :
	for i in ${PROGRAMS}; do\
		if [ -r `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz ]; then\
			gunzip -f `echo ${PRE}$${i}${VER} | cut -c1-8`.tgz;\
			tar xvf `echo ${PRE}$${i}${VER} | cut -c1-8`.tar;\
			rm -f `echo ${PRE}$${i}${VER} | cut -c1-8`.tar;\
		fi;\
	done

dosextract :
	${MOUNT};\
	cp ${DOSDIR}/${NAME}rea ${NAME}README;\
	cp ${DOSDIR}/${NAME}mak ${NAME}Makefile;\
	cp ${DOSDIR}/${NAME}lsm ${NAME}lsm;\
	chmod 600 ${NAME}README ${NAME}Makefile ${NAME}lsm;\
	for i in ${PROGRAMS}; do\
		if [ -r ${DOSDIR}/`echo ${PRE}$${i}${VER} | cut -c1-8`.tgz ]; then\
			cp ${DOSDIR}/`echo ${PRE}$${i}${VER} | cut -c1-8`.tgz .;\
		fi;\
	done;\
	${UMOUNT}

unixextract :
	DEVICE=/dev/fd0;\
	OS=`uname`;\
	if [ "$${OS}" = "SunOS7" ]; then\
		eject -q floppy 2> /tmp/dev$$;\
		DEVICE=`cat /tmp/dev$$ | cut -f1 -d' '`;\
		rm -f /tmp/dev$$;\
	fi;\
	tar xvf $${DEVICE};\
	if [ "$${OS}" = "SunOS7" ]; then\
		trap "exit 0" 0;\
		eject -p floppy 2> /dev/null;\
	fi

read :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			more README;\
			cd ..;\
		fi;\
	done

man :
	for i in ${PROGRAMS}; do\
		if [ -d ${PRE}$${i}${VER} ]; then\
			cd ${PRE}$${i}${VER};\
			nroff -man $${i}.man | more;\
			cd ..;\
		fi;\
	done

#print :

#install :
